/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.InvalidationEvent;
import com.ibm.ws.cache.SerializationUtility;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class InvalidateByIdEvent
implements InvalidationEvent,
Externalizable {
    static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc = Trace.register(class$com$ibm$ws$cache$CacheEntry == null ? (class$com$ibm$ws$cache$CacheEntry = InvalidateByIdEvent.class$("com.ibm.ws.cache.CacheEntry")) : class$com$ibm$ws$cache$CacheEntry, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    protected Cache cache = null;
    private Object id = null;
    private byte[] serializedId = null;
    private long timeStamp = -1L;
    private long drsClock = -1L;
    public int causeOfInvalidation;
    public int source;
    static /* synthetic */ Class class$com$ibm$ws$cache$CacheEntry;

    public InvalidateByIdEvent(Object object, int n, int n2, Cache cache) {
        this.id = object;
        this.causeOfInvalidation = n;
        this.source = n2;
        this.timeStamp = System.currentTimeMillis();
        this.cache = cache;
    }

    public InvalidateByIdEvent(Object object, Cache cache) {
        this.id = object;
        this.timeStamp = System.currentTimeMillis();
        this.cache = cache;
    }

    public InvalidateByIdEvent(Object object, long l, Cache cache) {
        this.id = object;
        this.timeStamp = l;
        this.cache = cache;
    }

    public InvalidateByIdEvent() {
    }

    private void processDrsInbound(long l) {
        if (this.drsClock <= 0L) {
            return;
        }
        if (this.timeStamp <= 0L) {
            return;
        }
        long l2 = l - this.drsClock;
        this.timeStamp += l2;
        this.drsClock = -1L;
    }

    private void processDrsOutbound() {
        if (this.drsClock != -1L) {
            return;
        }
        if (this.timeStamp <= 0L) {
            return;
        }
        this.drsClock = System.currentTimeMillis();
    }

    public Object getId() {
        return this.id;
    }

    public byte[] getSerializedId() {
        return this.serializedId;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean prepareForSerialization() {
        boolean bl = true;
        String string = null;
        if (this.serializedId == null) {
            try {
                this.serializedId = SerializationUtility.serialize((Serializable)this.id);
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (ClassCastException classCastException) {
                string = classCastException.toString();
            }
            if (this.serializedId == null) {
                Tr.error((TraceComponent)tc, (String)"dynacache.error", (Object)new Object[]{"OBJECT_NOT_REPLICATED_OR_SAVED_TO_DISK cacheID=" + this.id.getClass().getName() + " exception=" + string});
                bl = false;
            }
        }
        return bl;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.processDrsOutbound();
        if (this.serializedId != null) {
            objectOutput.writeInt(this.serializedId.length);
            objectOutput.write(this.serializedId);
        } else {
            objectOutput.writeInt(-1);
        }
        objectOutput.writeLong(this.timeStamp);
        objectOutput.writeLong(this.drsClock);
        objectOutput.writeInt(this.causeOfInvalidation);
        objectOutput.writeInt(this.source);
        objectOutput.writeObject(this.cache.getCacheName());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        long l = System.currentTimeMillis();
        int n = objectInput.readInt();
        if (n > 0) {
            this.serializedId = new byte[n];
            objectInput.readFully(this.serializedId);
        } else {
            this.serializedId = null;
        }
        this.id = null;
        if (this.serializedId != null) {
            try {
                this.id = SerializationUtility.deserialize(this.serializedId);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.InvalidateByIdEvent.getId", "146", this);
                exception.printStackTrace();
            }
            this.serializedId = null;
        } else {
            this.id = null;
        }
        this.timeStamp = objectInput.readLong();
        this.drsClock = objectInput.readLong();
        this.causeOfInvalidation = objectInput.readInt();
        this.source = objectInput.readInt();
        String string = (String)objectInput.readObject();
        this.cache = ServerCache.getCache(string);
        this.processDrsInbound(l);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

