/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.ExternalCacheFragment;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.InvalidationEvent;
import com.ibm.ws.cache.NonSyncHashtable;
import com.ibm.ws.cache.ReadWriteLock;
import com.ibm.ws.cache.RealTimeDaemon;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

public class InvalidationAuditDaemon
extends RealTimeDaemon {
    private long lastTimeCleared = 0L;
    private NonSyncHashtable pastIdSet = new NonSyncHashtable(1000);
    private NonSyncHashtable presentIdSet = new NonSyncHashtable(1000);
    private NonSyncHashtable futureIdSet = new NonSyncHashtable(1000);
    private NonSyncHashtable pastTemplateSet = new NonSyncHashtable(100);
    private NonSyncHashtable presentTemplateSet = new NonSyncHashtable(100);
    private NonSyncHashtable futureTemplateSet = new NonSyncHashtable(100);
    private ReadWriteLock readWriteLock = new ReadWriteLock();

    public InvalidationAuditDaemon(int n) {
        super(n);
        this.lastTimeCleared = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp(long l, long l2) {
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            this.readWriteLock.preWrite();
            this.lastTimeCleared = l2;
            this.pastIdSet.clear();
            NonSyncHashtable nonSyncHashtable = this.pastIdSet;
            this.pastIdSet = this.presentIdSet;
            this.presentIdSet = this.futureIdSet;
            this.futureIdSet = nonSyncHashtable;
            this.pastTemplateSet.clear();
            nonSyncHashtable = this.pastTemplateSet;
            this.pastTemplateSet = this.presentTemplateSet;
            this.presentTemplateSet = this.futureTemplateSet;
            this.futureTemplateSet = nonSyncHashtable;
            this.readWriteLock.postWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInvalidations(Iterator iterator) {
        ReadWriteLock readWriteLock = this.readWriteLock;
        synchronized (readWriteLock) {
            this.readWriteLock.preWrite();
            while (iterator.hasNext()) {
                long l;
                Externalizable externalizable;
                Object object;
                Externalizable externalizable2;
                Object e = iterator.next();
                if (e instanceof InvalidateByIdEvent) {
                    externalizable2 = (InvalidateByIdEvent)e;
                    object = ((InvalidateByIdEvent)externalizable2).getId();
                    externalizable = (InvalidateByIdEvent)this.presentIdSet.get(object);
                    l = ((InvalidateByIdEvent)externalizable2).getTimeStamp();
                    if (externalizable != null && ((InvalidateByIdEvent)externalizable).getTimeStamp() >= l) continue;
                    this.presentIdSet.put(object, externalizable2);
                    continue;
                }
                externalizable2 = (InvalidateByTemplateEvent)e;
                object = ((InvalidateByTemplateEvent)externalizable2).getTemplate();
                externalizable = (InvalidateByTemplateEvent)this.presentTemplateSet.get(object);
                l = ((InvalidateByTemplateEvent)externalizable2).getTimeStamp();
                if (externalizable != null && ((InvalidateByTemplateEvent)externalizable).getTimeStamp() >= l) continue;
                this.presentTemplateSet.put(object, externalizable2);
            }
            this.readWriteLock.postWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry filterEntry(CacheEntry cacheEntry) {
        this.readWriteLock.preRead();
        try {
            CacheEntry cacheEntry2 = this.internalFilterEntry(cacheEntry);
            return cacheEntry2;
        }
        finally {
            this.readWriteLock.postRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList filterEntryList(ArrayList arrayList) {
        this.readWriteLock.preRead();
        try {
            ArrayList arrayList2;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                CacheEntry cacheEntry;
                arrayList2 = iterator.next();
                if (!(arrayList2 instanceof CacheEntry) || this.internalFilterEntry(cacheEntry = (CacheEntry)((Object)arrayList2)) != null) continue;
                iterator.remove();
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.readWriteLock.postRead();
        }
    }

    private final CacheEntry internalFilterEntry(CacheEntry cacheEntry) {
        InvalidateByIdEvent invalidateByIdEvent = null;
        if (cacheEntry == null) {
            return null;
        }
        if (cacheEntry.id == null) {
            return null;
        }
        long l = cacheEntry.getTimeStamp();
        invalidateByIdEvent = (InvalidateByIdEvent)this.presentIdSet.get(cacheEntry.id);
        if (invalidateByIdEvent != null && invalidateByIdEvent.getTimeStamp() > l) {
            return null;
        }
        if (this.collision(this.presentTemplateSet, cacheEntry.getTemplates(), l) || this.collision(this.presentIdSet, cacheEntry.getDataIds(), l)) {
            return null;
        }
        if (l > this.lastTimeCleared) {
            return cacheEntry;
        }
        invalidateByIdEvent = (InvalidateByIdEvent)this.pastIdSet.get(cacheEntry.id);
        if (invalidateByIdEvent != null && invalidateByIdEvent.getTimeStamp() > l) {
            return null;
        }
        if (this.collision(this.pastTemplateSet, cacheEntry.getTemplates(), l) || this.collision(this.pastIdSet, cacheEntry.getDataIds(), l)) {
            return null;
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalCacheFragment filterExternalCacheFragment(ExternalCacheFragment externalCacheFragment) {
        this.readWriteLock.preRead();
        try {
            ExternalCacheFragment externalCacheFragment2 = this.internalFilterExternalCacheFragment(externalCacheFragment);
            return externalCacheFragment2;
        }
        finally {
            this.readWriteLock.postRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList filterExternalCacheFragmentList(ArrayList arrayList) {
        this.readWriteLock.preRead();
        try {
            Serializable serializable;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                serializable = (ExternalCacheFragment)iterator.next();
                if (null != this.internalFilterExternalCacheFragment((ExternalCacheFragment)serializable)) continue;
                iterator.remove();
            }
            serializable = arrayList;
            return serializable;
        }
        finally {
            this.readWriteLock.postRead();
        }
    }

    private final ExternalCacheFragment internalFilterExternalCacheFragment(ExternalCacheFragment externalCacheFragment) {
        if (externalCacheFragment == null) {
            return null;
        }
        long l = externalCacheFragment.getTimeStamp();
        if (this.collision(this.presentTemplateSet, externalCacheFragment.getInvalidationIds(), l) || this.collision(this.presentIdSet, externalCacheFragment.getTemplates(), l)) {
            return null;
        }
        if (l > this.lastTimeCleared) {
            return externalCacheFragment;
        }
        if (this.collision(this.pastTemplateSet, externalCacheFragment.getInvalidationIds(), l) || this.collision(this.pastIdSet, externalCacheFragment.getTemplates(), l)) {
            return null;
        }
        return externalCacheFragment;
    }

    private final boolean collision(NonSyncHashtable nonSyncHashtable, Enumeration enumeration, long l) {
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            InvalidationEvent invalidationEvent = (InvalidationEvent)nonSyncHashtable.get(e);
            if (invalidationEvent == null || invalidationEvent.getTimeStamp() <= l) continue;
            return true;
        }
        return false;
    }
}

