/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.CachePerf;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheService;
import com.ibm.ws.cache.CacheUnitImpl;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.command.CommandCache;
import com.ibm.ws.cache.drs.DRSNotificationService;
import com.ibm.ws.cache.drs.DRSRemoteServices;
import com.ibm.ws.cache.servlet.JSPCache;
import java.util.Hashtable;

public class ServerCache {
    private static TraceComponent tc = Trace.register(class$com$ibm$ws$cache$ServerCache == null ? (class$com$ibm$ws$cache$ServerCache = ServerCache.class$("com.ibm.ws.cache.ServerCache")) : class$com$ibm$ws$cache$ServerCache, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static boolean cacheEnabled = false;
    public static CacheUnitImpl cacheUnit = null;
    public static Cache cache = null;
    public static CommandCache commandCache = null;
    public static JSPCache jspCache = null;
    public static CachePerf cachePerf = null;
    public static CacheService cacheService = null;
    public static ClassLoader classLoader = null;
    private static int sharingPolicy = 1;
    private static int pushFrequency = 0;
    private static Hashtable cacheInstances = new Hashtable();
    static /* synthetic */ Class class$com$ibm$ws$cache$ServerCache;

    public static int getSharingPolicy() {
        return sharingPolicy;
    }

    public static void setSharingPolicy(int n) {
        sharingPolicy = n;
    }

    public static int getPushFrequency() {
        return pushFrequency;
    }

    public static void setPushFrequency(int n) {
        pushFrequency = n;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        ServerCache.classLoader = classLoader;
    }

    public static boolean isBatchEnabled() {
        return pushFrequency > 0;
    }

    public static Hashtable getCacheInstances() {
        return cacheInstances;
    }

    public static Cache getCache(String string) {
        Cache cache = ServerCache.cache;
        if (string != null && !string.equalsIgnoreCase("baseCache")) {
            cache = (Cache)cacheInstances.get(string);
        }
        return cache;
    }

    public static Cache createCache(String string, CacheConfig cacheConfig) {
        if (ServerCache.getCache(string) != null) {
            throw new IllegalStateException("cache: " + string + " already exists");
        }
        Cache cache = new Cache(string, cacheConfig);
        cache.setBatchUpdateDaemon(ServerCache.cacheUnit.batchUpdateDaemon);
        DRSNotificationService dRSNotificationService = null;
        RemoteServices remoteServices = null;
        if (CacheUnitImpl.isDRSNotification()) {
            dRSNotificationService = new DRSNotificationService();
            remoteServices = new DRSRemoteServices();
            remoteServices.setNotificationService(dRSNotificationService);
            dRSNotificationService.setCacheName(string);
            remoteServices.setCacheName(string);
            cacheService.initNotificationServiceInstance(dRSNotificationService, cacheConfig);
            dRSNotificationService.start();
            remoteServices.start();
            dRSNotificationService.registerCacheUnit(string, cacheUnit);
            remoteServices.setCacheUnit(cacheUnit.getUniqueCacheName(), cacheUnit);
        } else {
            remoteServices = ServerCache.cacheUnit.remoteServices;
        }
        cache.setRemoteServices(remoteServices);
        cache.setTimeLimitDaemon(ServerCache.cacheUnit.timeLimitDaemon);
        cache.setDefaultPriority(cacheConfig.cachePriority);
        cache.setCacheStatisticsListener(ServerCache.cacheUnit.cacheStatisticsListener);
        cacheInstances.put(string, cache);
        return cache;
    }

    public static String getServerName() {
        return cacheService != null ? cacheService.getServerName() : "unknown";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

