/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheStatisticsListener;
import com.ibm.ws.cache.DistributedMapImpl;
import com.ibm.ws.cache.ExternalCacheServices;
import com.ibm.ws.cache.InvalidationAuditDaemon;
import com.ibm.ws.cache.NotificationService;
import com.ibm.ws.cache.NullCachePerfModule;
import com.ibm.ws.cache.NullNotificationService;
import com.ibm.ws.cache.NullRemoteServices;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.TimeLimitDaemon;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.ffdc.FFDCFilter;

public class StandaloneCache {
    private static TraceComponent tc = Trace.register(class$com$ibm$ws$cache$Cache == null ? (class$com$ibm$ws$cache$Cache = StandaloneCache.class$("com.ibm.ws.cache.Cache")) : class$com$ibm$ws$cache$Cache, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private String uniqueCacheName;
    private boolean isDrsNotification;
    private BatchUpdateDaemon batchUpdateDaemon = null;
    private Cache cache = null;
    private CacheStatisticsListener cacheStatisticsListener = null;
    private ExternalCacheServices externalCacheServices = null;
    private InvalidationAuditDaemon invalidationAuditDaemon = null;
    private NotificationService notificationService = null;
    private RemoteServices remoteServices = null;
    private TimeLimitDaemon timeLimitDaemon = null;
    private static StandaloneCache theCache = null;
    static /* synthetic */ Class class$com$ibm$ws$cache$Cache;

    public static synchronized void initialize(CacheConfig cacheConfig) {
        if (theCache == null) {
            theCache = new StandaloneCache();
            theCache.init(cacheConfig);
        }
    }

    public static DistributedMap getMap() {
        return new DistributedMapImpl(ServerCache.cache);
    }

    private void init(CacheConfig cacheConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        try {
            ServerCache.cachePerf = new NullCachePerfModule();
            this.uniqueCacheName = cacheConfig.serverName;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Initializing CacheUnit " + this.uniqueCacheName));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("batchUpdateInterval set to " + cacheConfig.batchUpdateInterval));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("timeHoldingInvalidations set to " + cacheConfig.timeHoldingInvalidations));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cacheSprayerName set to " + cacheConfig.cacheSprayerName));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("notificationType set to " + cacheConfig.notificationType));
            }
            this.isDrsNotification = false;
            this.notificationService = new NullNotificationService();
            ServerCache.setSharingPolicy(1);
            if (ServerCache.cachePerf.isPMIEnabled()) {
                ServerCache.cachePerf.updateCacheSizes((long)cacheConfig.cacheSize, 0L);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cacheSize set to " + cacheConfig.cacheSize));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cachePriority set to " + cacheConfig.cachePriority));
            }
            try {
                this.cacheStatisticsListener = (CacheStatisticsListener)this.getClass().getClassLoader().loadClass(cacheConfig.cacheStatisticsListenerBeanName).newInstance();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.StandaloneCache.initialize", "471", this);
                throwable.printStackTrace();
                Tr.error((TraceComponent)tc, (String)"dynacache.configerror", (Object)throwable.getMessage());
                throw new IllegalArgumentException("cacheStatisticsListener must fully specify a bean name for an object of type com.ibm.ws.cache.CacheStatisticsListener");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cacheStatisticsListener created from class " + cacheConfig.cacheStatisticsListenerBeanName));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("maxTimeLimitInSeconds set to " + cacheConfig.maxTimeLimitInSeconds));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("timeGranularityInSeconds set to " + cacheConfig.timeGranularityInSeconds));
            }
            this.batchUpdateDaemon = new BatchUpdateDaemon(cacheConfig.batchUpdateInterval);
            ServerCache.cache = this.cache = new Cache("baseCache", cacheConfig);
            this.externalCacheServices = new ExternalCacheServices();
            this.remoteServices = new NullRemoteServices();
            this.invalidationAuditDaemon = new InvalidationAuditDaemon(cacheConfig.timeHoldingInvalidations);
            this.timeLimitDaemon = new TimeLimitDaemon(cacheConfig.maxTimeLimitInSeconds, cacheConfig.timeGranularityInSeconds);
            this.batchUpdateDaemon.setExternalCacheServices(this.externalCacheServices);
            this.batchUpdateDaemon.setInvalidationAuditDaemon(this.invalidationAuditDaemon);
            this.cache.setBatchUpdateDaemon(this.batchUpdateDaemon);
            this.cache.setRemoteServices(this.remoteServices);
            this.cache.setTimeLimitDaemon(this.timeLimitDaemon);
            this.cache.setDefaultPriority(cacheConfig.cachePriority);
            this.cache.setCacheStatisticsListener(this.cacheStatisticsListener);
            this.remoteServices.setNotificationService(this.notificationService);
            this.batchUpdateDaemon.start();
            this.cache.start();
            this.cacheStatisticsListener.start();
            this.externalCacheServices.start();
            this.invalidationAuditDaemon.start();
            this.notificationService.start();
            this.remoteServices.start();
            this.timeLimitDaemon.start();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Registering this cache unit with any other live cache units...");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"succeeded");
            }
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.cache.StandaloneCache.initialize", "640", this);
            throw illegalStateException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.StandaloneCache.initialize", "644", this);
            Tr.error((TraceComponent)tc, (String)"dynacache.configerror", (Object)exception.getMessage());
            throw new IllegalStateException("Unexpected exception in Configuration.initializeDynacache method.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

