/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.NonSyncHashtable;
import com.ibm.ws.cache.RealTimeDaemon;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;

public class TimeLimitDaemon
extends RealTimeDaemon {
    private static TraceComponent tc = Trace.register(class$com$ibm$ws$cache$TimeLimitDaemon == null ? (class$com$ibm$ws$cache$TimeLimitDaemon = TimeLimitDaemon.class$("com.ibm.ws.cache.TimeLimitDaemon")) : class$com$ibm$ws$cache$TimeLimitDaemon, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private int timeGranularityInSeconds = 10;
    private BinaryHeap timeLimitHeap;
    private InvalidationTaskPool taskPool = new InvalidationTaskPool(100);
    private NonSyncHashtable expirationTable = null;
    static /* synthetic */ Class class$com$ibm$ws$cache$TimeLimitDaemon;

    public TimeLimitDaemon(int n, int n2) {
        super(n2 * 1000);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating TimeLimitDaemon");
        }
        this.timeGranularityInSeconds = n2;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set time granularity to " + n2));
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("timeGranularityInSeconds must be positive");
        }
        this.expirationTable = new NonSyncHashtable(512);
        this.timeLimitHeap = new BinaryHeap();
    }

    public void start() {
        super.start();
    }

    public synchronized void wakeUp(long l, long l2) {
        try {
            InvalidationTask invalidationTask = this.timeLimitHeap.minimum();
            while (invalidationTask != null) {
                if (invalidationTask.expirationTime <= l2) {
                    invalidationTask = this.timeLimitHeap.deleteMin();
                    this.expirationTable.remove(invalidationTask.ik);
                    invalidationTask.ik.cache.invalidateById(invalidationTask.ik.id, 3, false);
                    this.taskPool.add(invalidationTask);
                    invalidationTask = this.timeLimitHeap.minimum();
                    continue;
                }
                invalidationTask = null;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.TimeLimitDaemon.wakeUp", "152", this);
            throwable.printStackTrace();
        }
    }

    public synchronized void valueHasChanged(Cache cache, Object object, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("expirationTime must be positive");
        }
        InvalidationKey invalidationKey = new InvalidationKey(cache, object);
        InvalidationTask invalidationTask = (InvalidationTask)this.expirationTable.get(invalidationKey);
        if (invalidationTask == null) {
            invalidationTask = (InvalidationTask)this.taskPool.remove();
            invalidationTask.ik = invalidationKey;
            this.expirationTable.put(invalidationKey, invalidationTask);
        } else {
            this.timeLimitHeap.delete(invalidationTask);
        }
        invalidationTask.expirationTime = l;
        this.timeLimitHeap.insert(invalidationTask);
    }

    public synchronized void valueWasRemoved(Cache cache, Object object) {
        InvalidationKey invalidationKey = new InvalidationKey(cache, object);
        InvalidationTask invalidationTask = (InvalidationTask)this.expirationTable.remove(invalidationKey);
        if (invalidationTask != null) {
            this.timeLimitHeap.delete(invalidationTask);
            this.taskPool.add(invalidationTask);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class BinaryHeap {
        private InvalidationTask[] heapArray = new InvalidationTask[1024];
        private static final int DEFAULT_SIZE = 1024;
        private int heapSize;

        public BinaryHeap() {
            InvalidationTask invalidationTask = new InvalidationTask();
            invalidationTask.expirationTime = Long.MIN_VALUE;
            invalidationTask.index = 0;
            this.heapArray[0] = invalidationTask;
            this.heapSize = 0;
        }

        public synchronized void insert(InvalidationTask invalidationTask) {
            int n = ++this.heapSize;
            this.growIfNec();
            while (invalidationTask.lessThan(this.heapArray[BinaryHeap.parent(n)])) {
                this.heapArray[n] = this.heapArray[BinaryHeap.parent(n)];
                this.heapArray[n].index = n;
                n = BinaryHeap.parent(n);
            }
            this.heapArray[n] = invalidationTask;
            this.heapArray[n].index = n;
        }

        public final InvalidationTask minimum() {
            if (this.isEmpty()) {
                return null;
            }
            return this.heapArray[1];
        }

        public final synchronized InvalidationTask deleteMin() {
            InvalidationTask invalidationTask;
            if (this.isEmpty()) {
                invalidationTask = null;
            } else {
                InvalidationTask invalidationTask2 = this.heapArray[this.heapSize];
                this.heapArray[this.heapSize--] = null;
                if (this.isEmpty()) {
                    invalidationTask = invalidationTask2;
                } else {
                    invalidationTask = this.heapArray[1];
                    this.heapArray[1] = invalidationTask2;
                    this.heapArray[1].index = 1;
                    this.heapify(1);
                }
            }
            return invalidationTask;
        }

        public synchronized void delete(InvalidationTask invalidationTask) {
            int n = this.findKey(invalidationTask);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            this.heapArray[n] = this.heapArray[0];
            this.heapArray[n].index = n;
            this.percolateUp(n);
            this.deleteMin();
        }

        private int findKey(InvalidationTask invalidationTask) {
            return invalidationTask.index;
        }

        private void percolateUp(int n) {
            while (this.heapArray[n].lessThan(this.heapArray[BinaryHeap.parent(n)])) {
                int n2 = BinaryHeap.parent(n);
                InvalidationTask invalidationTask = this.heapArray[n2];
                this.heapArray[n2] = this.heapArray[n];
                this.heapArray[n2].index = n2;
                this.heapArray[n] = invalidationTask;
                this.heapArray[n].index = n;
                int n3 = n;
                n = n2;
                this.heapify(n3);
            }
        }

        private final void heapify(int n) {
            InvalidationTask invalidationTask = this.heapArray[n];
            while (BinaryHeap.left(n) <= this.heapSize) {
                int n2 = BinaryHeap.left(n);
                if (n2 < this.heapSize && this.heapArray[BinaryHeap.right(n)].lessThan(this.heapArray[n2])) {
                    ++n2;
                }
                if (!this.heapArray[n2].lessThan(invalidationTask)) break;
                this.heapArray[n] = this.heapArray[n2];
                this.heapArray[n].index = n;
                n = n2;
            }
            this.heapArray[n] = invalidationTask;
            this.heapArray[n].index = n;
        }

        public final boolean isEmpty() {
            return this.heapSize == 0;
        }

        public final int size() {
            return this.heapSize;
        }

        private static final int parent(int n) {
            return n / 2;
        }

        private static final int left(int n) {
            return 2 * n;
        }

        private static final int right(int n) {
            return 2 * n + 1;
        }

        private void growIfNec() {
            if (this.heapSize + 1 == this.heapArray.length) {
                InvalidationTask[] invalidationTaskArray = this.heapArray;
                this.heapArray = new InvalidationTask[this.heapSize * 2];
                System.arraycopy(invalidationTaskArray, 0, this.heapArray, 0, invalidationTaskArray.length);
            }
        }
    }

    static class InvalidationTaskPool
    extends ObjectPool {
        public InvalidationTaskPool(int n) {
            super("InvalidationTaskPool", n);
        }

        protected Object createObject() {
            return new InvalidationTask();
        }
    }

    public static class InvalidationTask {
        public long expirationTime;
        public InvalidationKey ik;
        public int index;

        public final boolean lessThan(InvalidationTask invalidationTask) {
            return this.expirationTime < invalidationTask.expirationTime;
        }

        public final boolean equals(InvalidationTask invalidationTask) {
            return this.expirationTime == invalidationTask.expirationTime;
        }

        public final boolean lessThanOrEquals(InvalidationTask invalidationTask) {
            return this.expirationTime <= invalidationTask.expirationTime;
        }
    }

    public static class InvalidationKey {
        private Object id;
        private Cache cache;

        public InvalidationKey(Cache cache, Object object) {
            this.id = object;
            this.cache = cache;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object object) {
            InvalidationKey invalidationKey = (InvalidationKey)object;
            return invalidationKey.cache == this.cache && invalidationKey.id.equals(this.id);
        }
    }
}

