/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.CacheId;
import com.ibm.ws.cache.config.Component;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.DependencyId;
import com.ibm.ws.cache.config.ElementHandler;
import com.ibm.ws.cache.config.Field;
import com.ibm.ws.cache.config.Invalidation;
import com.ibm.ws.cache.config.Method;
import com.ibm.ws.cache.config.RuleHandler;
import com.ibm.ws.cache.config.Value;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.xml.sax.Attributes;

public class CacheHandler
extends ElementHandler {
    private static TraceComponent tc = Trace.register(class$com$ibm$ws$cache$config$CacheHandler == null ? (class$com$ibm$ws$cache$config$CacheHandler = CacheHandler.class$("com.ibm.ws.cache.config.CacheHandler")) : class$com$ibm$ws$cache$config$CacheHandler, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    protected String displayName;
    protected String description;
    private ArrayList cacheEntries;
    private ArrayList groups;
    private HashMap appContext;
    private String appName;
    private String filename;
    String[][] invalidClassComponentType = new String[][]{{"command", "parameter"}, {"command", "session"}, {"command", "cookie"}, {"command", "attribute"}, {"command", "header"}, {"command", "pathinfo"}, {"command", "servletpath"}, {"command", "locale"}, {"command", "body"}, {"command", "SOAPAction"}, {"command", "SOAPEnvelope"}, {"command", "serviceOperation"}, {"command", "serviceOperationParameter"}, {"webservice", "method"}, {"webservice", "field"}, {"webservice", "parameter"}, {"webservice", "session"}, {"webservice", "cookie"}, {"webservice", "attribute"}, {"webservice", "pathinfo"}, {"webservice", "servletpath"}, {"webservice", "locale"}, {"servlet", "method"}, {"servlet", "field"}, {"servlet", "body"}, {"servlet", "SOAPAction"}, {"servlet", "SOAPEnvelope"}, {"servlet", "serviceOperation"}, {"servlet", "serviceOperationParameter"}};
    String[][] invalidClassProperty = new String[][]{{"command", "edgeable"}, {"command", "externalcache"}, {"command", "consume-subfragments"}, {"command", "do-not-consume"}, {"webservice", "edgecacheable"}, {"webservice", "edgeable"}, {"webservice", "externalcache"}};
    static /* synthetic */ Class class$com$ibm$ws$cache$config$CacheHandler;

    public CacheHandler(String string, HashMap hashMap) {
        this.appName = string;
        this.appContext = hashMap;
        this.cacheEntries = new ArrayList();
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public ArrayList getEntries() {
        return this.cacheEntries;
    }

    public void addRules(RuleHandler ruleHandler) {
        ruleHandler.addRule("display-name", new DisplayNameHandler());
        ruleHandler.addRule("description", new DescriptionHandler());
        ruleHandler.addRule("cache-entry", new CacheEntryHandler());
        ruleHandler.addRule("group", new GroupHandler());
    }

    private void checkInvalidClassProperty(String string, String string2) {
        boolean bl;
        if (string != null && string2 != null && (bl = this.walkInvalidList(string, string2, this.invalidClassProperty))) {
            Tr.error((TraceComponent)tc, (String)"DYNA0050E", (Object)new Object[]{"'" + string2 + "'", "'" + string + "'"});
            Tr.error((TraceComponent)tc, (String)"dynacache.configerror", (Object)new Object[]{this.filename});
        }
    }

    private void checkInvalidClassComponentType(String string, String string2) {
        boolean bl;
        if (string != null && string2 != null && (bl = this.walkInvalidList(string, string2, this.invalidClassComponentType))) {
            Tr.error((TraceComponent)tc, (String)"DYNA0050E", (Object)new Object[]{"'" + string2 + "'", "'" + string + "'"});
            Tr.error((TraceComponent)tc, (String)"dynacache.configerror", (Object)new Object[]{this.filename});
        }
    }

    private boolean walkInvalidList(String string, String string2, String[][] stringArray) {
        boolean bl = false;
        for (int i = 0; i != stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i][0]) || !string2.equalsIgnoreCase(stringArray[i][1])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static interface FieldReceiver {
        public void addField(Field var1);
    }

    private static interface MethodReceiver {
        public void addMethod(Method var1);
    }

    private static interface ComponentReceiver {
        public void addComponent(Component var1);
    }

    private static interface PropertyReceiver {
        public void addProperty(String var1, String var2);
    }

    private class GroupHandler
    extends ElementHandler {
        protected String name;
        protected String description;

        public GroupHandler() {
            this.reset();
        }

        public String toString() {
            return "<group>";
        }

        public void reset() {
            this.name = null;
            this.description = null;
        }

        public void finished() {
        }

        public void addRules(RuleHandler ruleHandler) {
            ruleHandler.addRule("description", new DescriptionHandler());
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            string2 = attributes.getValue("name");
            if (string2 == null) {
                Tr.error((TraceComponent)tc, (String)"DYNA0030E", (Object)new Object[]{"group", "name"});
            }
        }
    }

    private class CacheEntryHandler
    extends ElementHandler
    implements PropertyReceiver {
        protected String className;
        protected String name;
        protected HashSet allNames;
        protected int sharingPolicy;
        protected boolean sharingSet;
        protected HashMap properties;
        protected ArrayList cacheIds = new ArrayList();
        protected ArrayList dependencyIds = new ArrayList();
        protected ArrayList invalidations = new ArrayList();

        public CacheEntryHandler() {
            this.reset();
        }

        public String toString() {
            return "<cache-entry>";
        }

        public void reset() {
            this.className = null;
            this.name = null;
            this.allNames = new HashSet();
            this.sharingPolicy = 1;
            this.sharingSet = false;
            this.properties = new HashMap();
            this.cacheIds = new ArrayList();
            this.invalidations = new ArrayList();
            this.dependencyIds = new ArrayList();
        }

        public void finished() {
            ConfigEntry configEntry = new ConfigEntry();
            configEntry.className = this.className;
            configEntry.name = this.generateName(this.name);
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = this.allNames.iterator();
            while (iterator.hasNext()) {
                hashSet.add(this.generateName((String)iterator.next()));
            }
            configEntry.allNames = hashSet;
            configEntry.sharingPolicy = this.sharingSet ? this.sharingPolicy : ServerCache.getSharingPolicy();
            configEntry.properties = this.properties;
            configEntry.cacheIds = this.cacheIds.toArray(new CacheId[0]);
            configEntry.dependencyIds = this.dependencyIds.toArray(new DependencyId[0]);
            configEntry.invalidations = this.invalidations.toArray(new Invalidation[0]);
            CacheHandler.this.cacheEntries.add(configEntry);
            this.reset();
        }

        private String generateName(String string) {
            boolean bl;
            Object var2_2 = null;
            boolean bl2 = bl = string.indexOf(".class") != -1;
            if (bl) {
                return this.getAppPrefixedName(string);
            }
            if (this.className.equalsIgnoreCase("command")) {
                if (!bl) {
                    return string + ".class";
                }
                return string;
            }
            return this.getAppPrefixedName(string);
        }

        private String getAppPrefixedName(String string) {
            String string2 = null;
            if (CacheHandler.this.appContext != null) {
                string2 = (String)CacheHandler.this.appContext.get(this.className);
            }
            if (string2 != null) {
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                return string2 + string;
            }
            return string;
        }

        public void addRules(RuleHandler ruleHandler) {
            ruleHandler.addRule("class", new ClassHandler());
            ruleHandler.addRule("name", new NameHandler());
            ruleHandler.addRule("sharing-policy", new SharingPolicyHandler());
            ruleHandler.addRule("property", new PropertyHandler(this));
            ruleHandler.addRule("cache-id", new CacheIdHandler());
            ruleHandler.addRule("dependency-id", new DependencyIdHandler());
            ruleHandler.addRule("invalidation", new InvalidationHandler());
        }

        public void addProperty(String string, String string2) {
            if (this.properties == null) {
                this.properties = new HashMap();
            }
            this.properties.put(string, string2);
        }

        private class DependencyIdHandler
        extends ElementHandler
        implements ComponentReceiver {
            ArrayList components = new ArrayList();

            public String toString() {
                return "<dependency-id>";
            }

            public void addRules(RuleHandler ruleHandler) {
                ruleHandler.addRule("component", new ComponentHandler(this));
            }

            public void addComponent(Component component) {
                if (this.components == null) {
                    this.components = new ArrayList();
                }
                this.components.add(component);
            }

            public void finished() {
                DependencyId dependencyId = new DependencyId();
                dependencyId.baseName = this.getCharacters();
                dependencyId.components = this.components.toArray(new Component[0]);
                CacheEntryHandler.this.dependencyIds.add(dependencyId);
                this.components.clear();
            }
        }

        private class ComponentHandler
        extends ElementHandler
        implements MethodReceiver,
        FieldReceiver {
            private String type;
            private String id;
            private boolean ignoreValue;
            private Method method;
            private Field field;
            private boolean required;
            private HashMap values;
            private ArrayList notValues;
            private ComponentReceiver receiver;

            public ComponentHandler(ComponentReceiver componentReceiver) {
                this.receiver = componentReceiver;
                this.reset();
            }

            public String toString() {
                return "<component>";
            }

            public void reset() {
                this.type = null;
                this.id = null;
                this.ignoreValue = false;
                this.method = null;
                this.required = true;
                this.values = new HashMap();
                this.notValues = new ArrayList();
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) {
                this.type = attributes.getValue("type");
                this.id = attributes.getValue("id");
                try {
                    String string4 = attributes.getValue("ignore-value");
                    if (string4 != null) {
                        this.ignoreValue = Boolean.valueOf(string4);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.CacheHandler.startElement", "403", this);
                    Tr.error((TraceComponent)tc, (String)"DYNA0032E", (Object)new Object[]{"ignore-value", attributes.getValue("ignore-value")});
                }
                if (this.id == null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0030E", (Object)new Object[]{"component", "id"});
                }
                if (this.type == null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0030E", (Object)new Object[]{"component", "type"});
                }
            }

            public void addMethod(Method method) {
                if (this.method != null || this.field != null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0031E", (Object)new Object[]{"method", method.name});
                    return;
                }
                this.method = method;
            }

            public void addField(Field field) {
                if (this.method != null || this.field != null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0031E", (Object)new Object[]{"field", field.name});
                    return;
                }
                this.field = field;
            }

            public void addRules(RuleHandler ruleHandler) {
                ruleHandler.addRule("method", new MethodHandler(this));
                ruleHandler.addRule("field", new FieldHandler(this));
                ruleHandler.addRule("required", new RequiredHandler());
                ruleHandler.addRule("value", new ValueHandler());
                ruleHandler.addRule("not-value", new NotValueHandler());
            }

            public void finished() {
                if (this.id == null || this.type == null) {
                    return;
                }
                Component component = new Component();
                component.type = this.type;
                component.id = this.id;
                component.ignoreValue = this.ignoreValue;
                component.method = this.method;
                component.field = this.field;
                component.required = this.required;
                component.values = this.values;
                component.notValues = this.notValues.toArray(new Value[0]);
                component.validate();
                this.receiver.addComponent(component);
                CacheHandler.this.checkInvalidClassComponentType(CacheEntryHandler.this.className, this.type);
                this.reset();
            }

            private class NotValueHandler
            extends ElementHandler {
                private NotValueHandler() {
                }

                public String toString() {
                    return "<not-value>";
                }

                public void finished() {
                    Value value = new Value();
                    value.value = this.getCharacters();
                    ComponentHandler.this.notValues.add(value);
                }
            }

            private class ValueHandler
            extends ElementHandler {
                private ValueHandler() {
                }

                public String toString() {
                    return "<value>";
                }

                public void finished() {
                    Value value = new Value();
                    value.value = this.getCharacters();
                    ComponentHandler.this.values.put(value.value, value);
                }
            }

            private class RequiredHandler
            extends ElementHandler {
                private RequiredHandler() {
                }

                public void finished() {
                    String string = this.getCharacters();
                    try {
                        if (string != null) {
                            ComponentHandler.this.required = Boolean.valueOf(string);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.CacheHandler.finished", "547", this);
                        Tr.error((TraceComponent)tc, (String)"DYNA0032E", (Object)new Object[]{"required", string});
                    }
                }

                public String toString() {
                    return "<required>";
                }
            }

            private class FieldHandler
            extends ElementHandler
            implements MethodReceiver,
            FieldReceiver {
                FieldReceiver receiver;
                Method method = null;
                Field field = null;

                public FieldHandler(FieldReceiver fieldReceiver) {
                    this.receiver = fieldReceiver;
                }

                public String toString() {
                    return "<field>";
                }

                public void addRules(RuleHandler ruleHandler) {
                    ruleHandler.addRule("method", new MethodHandler(this));
                    ruleHandler.addRule("field", new FieldHandler(this));
                }

                public void addMethod(Method method) {
                    if (this.method != null || this.field != null) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0031E", (Object)new Object[]{"method", method.name});
                        return;
                    }
                    this.method = method;
                }

                public void addField(Field field) {
                    if (this.method != null || this.field != null) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0031E", (Object)new Object[]{"field", field.name});
                        return;
                    }
                    this.field = field;
                }

                public void finished() {
                    Field field = new Field();
                    field.name = this.getCharacters();
                    field.method = this.method;
                    field.field = this.field;
                    this.receiver.addField(field);
                }
            }

            private class MethodHandler
            extends ElementHandler
            implements MethodReceiver,
            FieldReceiver {
                MethodReceiver receiver;
                Method method = null;
                Field field = null;

                public MethodHandler(MethodReceiver methodReceiver) {
                    this.receiver = methodReceiver;
                }

                public String toString() {
                    return "<method>";
                }

                public void addRules(RuleHandler ruleHandler) {
                    ruleHandler.addRule("method", new MethodHandler(this));
                    ruleHandler.addRule("field", new FieldHandler(this));
                }

                public void addMethod(Method method) {
                    if (this.method != null || this.field != null) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0031E", (Object)new Object[]{"method", method.name});
                        return;
                    }
                    this.method = method;
                }

                public void addField(Field field) {
                    if (this.method != null || this.field != null) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0031E", (Object)new Object[]{"field", field.name});
                        return;
                    }
                    this.field = field;
                }

                public void finished() {
                    Method method = new Method();
                    method.name = this.getCharacters();
                    method.method = this.method;
                    method.field = this.field;
                    this.receiver.addMethod(method);
                }
            }
        }

        private class PropertyHandler
        extends ElementHandler {
            PropertyReceiver receiver;
            String name;

            public PropertyHandler(PropertyReceiver propertyReceiver) {
                this.receiver = propertyReceiver;
            }

            public String toString() {
                return "<property>";
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) {
                String string4 = this.name = attributes.getValue("name") != null ? attributes.getValue("name").toLowerCase() : null;
                if (this.name == null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0030E", (Object)new Object[]{"property", "name"});
                }
            }

            public void finished() {
                if (this.name != null) {
                    CacheHandler.this.checkInvalidClassProperty(CacheEntryHandler.this.className, this.name);
                    if (this.name != null && this.name.equals("edgecacheable")) {
                        this.name = "edgeable";
                    }
                    this.receiver.addProperty(this.name, this.getCharacters());
                }
            }
        }

        private class InvalidationHandler
        extends ElementHandler
        implements ComponentReceiver {
            private String invalidationGenerator;
            private ArrayList components = new ArrayList();

            public String toString() {
                return "<invalidation>";
            }

            public void finished() {
                Invalidation invalidation = new Invalidation();
                invalidation.baseName = this.getCharacters();
                invalidation.invalidationGenerator = this.invalidationGenerator;
                invalidation.components = this.components.toArray(new Component[0]);
                CacheEntryHandler.this.invalidations.add(invalidation);
                this.components.clear();
                this.invalidationGenerator = null;
            }

            public void addRules(RuleHandler ruleHandler) {
                ruleHandler.addRule("invalidationgenerator", new InvalidationGeneratorHandler());
                ruleHandler.addRule("component", new ComponentHandler(this));
            }

            public void addComponent(Component component) {
                if (this.invalidationGenerator != null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0028E", (Object)new Object[]{component.id, this.invalidationGenerator});
                    return;
                }
                this.components.add(component);
            }

            private class InvalidationGeneratorHandler
            extends ElementHandler {
                private InvalidationGeneratorHandler() {
                }

                public void finished() {
                    if (InvalidationHandler.this.components.size() != 0) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0029E", (Object)new Object[]{this.getCharacters(), ((Component)((InvalidationHandler)InvalidationHandler.this).components.get((int)0)).id});
                        return;
                    }
                    InvalidationHandler.this.invalidationGenerator = this.getCharacters();
                }

                public String toString() {
                    return "<invalidationGenerator>";
                }
            }
        }

        class CacheIdHandler
        extends ElementHandler
        implements PropertyReceiver,
        ComponentReceiver {
            private String idGenerator;
            private String metaDataGenerator;
            private int timeout;
            private int priority;
            private HashMap properties;
            private ArrayList components;

            public CacheIdHandler() {
                this.reset();
            }

            public String toString() {
                return "<cache-id>";
            }

            public void addRules(RuleHandler ruleHandler) {
                ruleHandler.addRule("display-name", new DisplayNameHandler());
                ruleHandler.addRule("component", new ComponentHandler(this));
                ruleHandler.addRule("idgenerator", new IdGeneratorHandler());
                ruleHandler.addRule("metadatagenerator", new MetaDataGeneratorHandler());
                ruleHandler.addRule("timeout", new TimeoutHandler());
                ruleHandler.addRule("priority", new PriorityHandler());
                ruleHandler.addRule("property", new PropertyHandler(this));
            }

            public void reset() {
                this.metaDataGenerator = null;
                this.idGenerator = null;
                this.priority = 0;
                this.timeout = 0;
                this.properties = new HashMap();
                this.components = new ArrayList();
            }

            public void finished() {
                CacheId cacheId = new CacheId();
                cacheId.idGenerator = this.idGenerator;
                cacheId.metaDataGenerator = this.metaDataGenerator;
                cacheId.timeout = this.timeout;
                cacheId.priority = this.priority;
                cacheId.components = this.components.toArray(new Component[0]);
                cacheId.properties = this.properties;
                CacheEntryHandler.this.cacheIds.add(cacheId);
                this.reset();
            }

            public void addProperty(String string, String string2) {
                if (this.properties == null) {
                    this.properties = new HashMap();
                }
                this.properties.put(string, string2);
            }

            public void addComponent(Component component) {
                if (this.components == null) {
                    this.components = new ArrayList();
                }
                if (this.idGenerator != null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA0028E", (Object)new Object[]{component.id, this.idGenerator});
                    return;
                }
                this.components.add(component);
            }

            private class PriorityHandler
            extends ElementHandler {
                private PriorityHandler() {
                }

                public void finished() {
                    String string = this.getCharacters();
                    try {
                        CacheIdHandler.this.priority = Integer.valueOf(string);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.CacheHandler.finished", "298", this);
                        Tr.error((TraceComponent)tc, (String)"dynacache.priority", (Object)new Object[]{"<cache-id>", string});
                    }
                }

                public String toString() {
                    return "<priority>";
                }
            }

            private class TimeoutHandler
            extends ElementHandler {
                private TimeoutHandler() {
                }

                public void finished() {
                    String string = this.getCharacters();
                    try {
                        CacheIdHandler.this.timeout = Integer.valueOf(string);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.CacheHandler.finished", "282", this);
                        Tr.error((TraceComponent)tc, (String)"dynacache.timeout", (Object)new Object[]{"<cache-id>", string});
                    }
                }

                public String toString() {
                    return "<timeout>";
                }
            }

            private class MetaDataGeneratorHandler
            extends ElementHandler {
                private MetaDataGeneratorHandler() {
                }

                public void finished() {
                    CacheIdHandler.this.metaDataGenerator = this.getCharacters();
                }

                public String toString() {
                    return "<metadatagenerator>";
                }
            }

            private class IdGeneratorHandler
            extends ElementHandler {
                private IdGeneratorHandler() {
                }

                public void finished() {
                    if (CacheIdHandler.this.components.size() != 0) {
                        Tr.error((TraceComponent)tc, (String)"DYNA0029E", (Object)new Object[]{this.getCharacters(), ((Component)((CacheIdHandler)CacheIdHandler.this).components.get((int)0)).id});
                        return;
                    }
                    CacheIdHandler.this.idGenerator = this.getCharacters();
                }

                public String toString() {
                    return "<idgenerator>";
                }
            }
        }

        private class SharingPolicyHandler
        extends ElementHandler {
            private SharingPolicyHandler() {
            }

            public void finished() {
                String string = this.getCharacters().toLowerCase();
                if (string.equals("not-shared")) {
                    CacheEntryHandler.this.sharingPolicy = 1;
                } else if (string.equals("shared-push")) {
                    CacheEntryHandler.this.sharingPolicy = 2;
                } else if (string.equals("shared-pull")) {
                    CacheEntryHandler.this.sharingPolicy = 3;
                } else if (string.equals("shared-push-pull")) {
                    CacheEntryHandler.this.sharingPolicy = 4;
                } else {
                    Tr.error((TraceComponent)tc, (String)"DYNA0027E", (Object)new Object[]{string});
                }
                CacheEntryHandler.this.sharingSet = true;
            }

            public String toString() {
                return "<sharing-policy>";
            }
        }

        private class NameHandler
        extends ElementHandler {
            private NameHandler() {
            }

            public void finished() {
                String string = this.getCharacters();
                if (CacheEntryHandler.this.name == null) {
                    CacheEntryHandler.this.name = string;
                }
                CacheEntryHandler.this.allNames.add(string);
            }

            public String toString() {
                return "<name>";
            }
        }

        private class ClassHandler
        extends ElementHandler {
            private ClassHandler() {
            }

            public void finished() {
                CacheEntryHandler.this.className = this.getCharacters();
            }

            public String toString() {
                return "<class>";
            }
        }
    }

    private class DescriptionHandler
    extends ElementHandler {
        private DescriptionHandler() {
        }

        public void finished() {
            CacheHandler.this.description = this.getCharacters();
        }

        public String toString() {
            return "<description>";
        }
    }

    private class DisplayNameHandler
    extends ElementHandler {
        private DisplayNameHandler() {
        }

        public void finished() {
            CacheHandler.this.displayName = this.getCharacters();
        }

        public String toString() {
            return "<display-name>";
        }
    }
}

