/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.Field;
import com.ibm.ws.cache.config.Method;
import com.ibm.ws.cache.config.Value;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;

public class Component {
    private static TraceComponent tc = Trace.register(class$com$ibm$ws$cache$config$Component == null ? (class$com$ibm$ws$cache$config$Component = Component.class$("com.ibm.ws.cache.config.Component")) : class$com$ibm$ws$cache$config$Component, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public String type;
    public String id;
    public boolean ignoreValue;
    public Method method;
    public Field field;
    public boolean required;
    public HashMap values;
    public Value[] notValues;
    public int iType;
    public Method idMethod;
    public Field idField;
    public static final int METHOD = 0;
    public static final int FIELD = 1;
    public static final int SESSION = 2;
    public static final int PARAMETER = 3;
    public static final int COOKIE = 4;
    public static final int HEADER = 5;
    public static final int LOCALE = 6;
    public static final int SOAP_ACTION = 7;
    public static final int SERVICE_OPERATION = 8;
    public static final int SERVICE_OPERATION_PARAMETER = 9;
    public static final int SOAP_ENVELOPE = 10;
    public static final int ATTRIBUTE = 11;
    public static final int PATH_INFO = 12;
    public static final int SERVLET_PATH = 13;
    public static final int PARAMETER_LIST = 14;
    public static final int OPERATION = 15;
    public static final int PART = 16;
    public static final int WSDL_SERVICE = 17;
    public static final int WSDL_PORT = 18;
    public static final int SOAP_HEADER_ENTRY = 19;
    static /* synthetic */ Class class$com$ibm$ws$cache$config$Component;

    public void validate() {
        if (this.type.equalsIgnoreCase("method")) {
            this.iType = 0;
        } else if (this.type.equalsIgnoreCase("field")) {
            this.iType = 1;
        } else if (this.type.equalsIgnoreCase("session")) {
            this.iType = 2;
        } else if (this.type.equalsIgnoreCase("parameter")) {
            this.iType = 3;
        } else if (this.type.equalsIgnoreCase("cookie")) {
            this.iType = 4;
        } else if (this.type.equalsIgnoreCase("header")) {
            this.iType = 5;
        } else if (this.type.equalsIgnoreCase("locale")) {
            this.iType = 6;
        } else if (this.type.equalsIgnoreCase("SOAPAction")) {
            this.iType = 7;
        } else if (this.type.equalsIgnoreCase("serviceOperation")) {
            this.iType = 8;
        } else if (this.type.equalsIgnoreCase("serviceOperationParameter")) {
            this.iType = 9;
        } else if (this.type.equalsIgnoreCase("SOAPEnvelope")) {
            this.iType = 10;
        } else if (this.type.equalsIgnoreCase("attribute")) {
            this.iType = 11;
        } else if (this.type.equalsIgnoreCase("pathInfo")) {
            this.iType = 12;
        } else if (this.type.equalsIgnoreCase("servletpath")) {
            this.iType = 13;
        } else if (this.type.equalsIgnoreCase("parameter-list")) {
            this.iType = 14;
        } else if (this.type.equalsIgnoreCase("operation")) {
            this.iType = 15;
        } else if (this.type.equalsIgnoreCase("part")) {
            this.iType = 16;
        } else if (this.type.equalsIgnoreCase("WSDLServiceName")) {
            this.iType = 17;
        } else if (this.type.equalsIgnoreCase("WSDLPortName")) {
            this.iType = 18;
        } else if (this.type.equalsIgnoreCase("SOAPHeaderEntry")) {
            this.iType = 19;
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA0049E", (Object)new Object[]{this.type});
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("type       : " + this.type);
        printWriter.println("id         : " + this.id);
        printWriter.println("ignoreValue: " + this.ignoreValue);
        printWriter.println("method     : " + this.method);
        printWriter.println("required   : " + this.required);
        printWriter.println("values     : " + this.values);
        for (int i = 0; this.notValues != null && i < this.notValues.length; ++i) {
            printWriter.println("NotValue " + i + "]");
            printWriter.println(this.notValues[i]);
        }
        return stringWriter.toString();
    }

    public String fancyFormat(int n) {
        int n2;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("id         : " + this.id);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("type       : " + this.type);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("ignoreValue: " + this.ignoreValue);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("method     : " + this.method);
        for (n2 = n; n2 > 0; --n2) {
            printWriter.print("\t");
        }
        printWriter.println("required   : " + this.required);
        if (this.values != null && this.values.size() > 0) {
            for (n2 = n; n2 > 0; --n2) {
                printWriter.print("\t");
            }
            printWriter.println("values     : " + this.values);
            Iterator iterator = this.values.values().iterator();
            while (iterator.hasNext()) {
                printWriter.println(((Value)iterator.next()).fancyFormat(n + 1));
            }
        }
        for (int i = 0; this.notValues != null && i < this.notValues.length; ++i) {
            for (int j = n; j > 0; --j) {
                printWriter.print("\t");
            }
            printWriter.println("NotValue " + i + "");
            printWriter.println(this.notValues[i].fancyFormat(n + 1));
        }
        return stringWriter.toString();
    }

    public void getESIComponent(StringBuffer stringBuffer) {
        if (this.required) {
            if (this.ignoreValue) {
                stringBuffer.append("<").append(this.id);
                stringBuffer.append(">");
                this.getESIValues(stringBuffer);
            } else {
                stringBuffer.append(this.id);
                this.getESIValues(stringBuffer);
            }
        } else if (!this.required) {
            stringBuffer.append("[");
            if (this.ignoreValue) {
                stringBuffer.append("<").append(this.id);
                stringBuffer.append(">");
                this.getESIValues(stringBuffer);
            } else {
                stringBuffer.append(this.id);
                this.getESIValues(stringBuffer);
            }
            stringBuffer.append("]");
        }
    }

    public void getESIValues(StringBuffer stringBuffer) {
        if (this.values != null && this.values.size() > 0) {
            stringBuffer.append("={");
            Iterator iterator = this.values.values().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((Value)iterator.next()).value);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else if (this.notValues != null && this.notValues.length > 0) {
            stringBuffer.append("!={");
            for (int i = 0; i < this.notValues.length; ++i) {
                stringBuffer.append(this.notValues[i].value);
                if (i + 1 >= this.notValues.length) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        }
    }

    public Object clone() {
        Component component = new Component();
        component.type = this.type;
        component.iType = this.iType;
        component.id = this.id;
        component.ignoreValue = this.ignoreValue;
        component.required = this.required;
        if (this.method != null) {
            component.method = (Method)this.method.clone();
        }
        if (this.field != null) {
            component.field = (Field)this.field.clone();
        }
        if (this.notValues != null) {
            component.notValues = new Value[this.notValues.length];
            for (int i = 0; i < this.notValues.length; ++i) {
                component.notValues[i] = (Value)this.notValues[i].clone();
            }
        }
        if (this.values != null) {
            component.values = new HashMap();
            Iterator iterator = this.values.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                component.values.put(k, ((Value)this.values.get(k)).clone());
            }
        }
        return component;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

