/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.CacheHandler;
import com.ibm.ws.cache.config.CacheProcessor;
import com.ibm.ws.cache.config.ConfigChangeListener;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.ConfigErrorHandler;
import com.ibm.ws.cache.config.ConfigFileEntry;
import com.ibm.ws.cache.config.RuleHandler;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.xml.ParserFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ConfigManager
implements AlarmListener {
    private static TraceComponent tc = Trace.register(class$com$ibm$ws$cache$config$ConfigManager == null ? (class$com$ibm$ws$cache$config$ConfigManager = ConfigManager.class$("com.ibm.ws.cache.config.ConfigManager")) : class$com$ibm$ws$cache$config$ConfigManager, "WebSphere Cache", "com.ibm.ws.cache.resources.dynacache");
    static final String CACHE_SPEC = "cachespec.xml";
    static final String CACHE_SPEC_DTD = "cachespec.dtd";
    static String propertiesDir = "";
    private SAXParser jaxpParser = null;
    private ArrayList globalCacheEntries = new ArrayList();
    private ArrayList legacyCacheEntries = new ArrayList();
    private ArrayList configListeners = new ArrayList();
    private HashMap cacheEntries = new HashMap();
    private HashMap configFiles = new HashMap();
    private int reloadInterval = -1;
    private HashMap entryCache = new HashMap();
    private MultiProcessorPool processorPool = new MultiProcessorPool();
    private HashMap jaxRpcClientConfigEntries = new HashMap(1);
    private static ConfigManager instance = new ConfigManager();
    static /* synthetic */ Class class$com$ibm$ws$cache$config$ConfigManager;

    public static ConfigManager getInstance() {
        return instance;
    }

    protected ConfigManager() {
    }

    public synchronized void addConfigChangeListener(ConfigChangeListener configChangeListener) {
        this.configListeners.add(configChangeListener);
    }

    public synchronized void removeConfigChangeListener(ConfigChangeListener configChangeListener) {
        this.configListeners.remove(configChangeListener);
    }

    public synchronized void fireChangedEvent() {
        int n = this.configListeners.size();
        for (int i = 0; i < n; ++i) {
            ((ConfigChangeListener)this.configListeners.get(i)).configChanged();
        }
    }

    public void setReloadInterval(int n) {
        if (this.reloadInterval == -1) {
            this.reloadInterval = n;
            AlarmManager.create((long)n, (AlarmListener)this, null);
        }
    }

    public static void setPropertiesDirectory(String string) {
        propertiesDir = string;
        if (!propertiesDir.endsWith(File.separator)) {
            propertiesDir = propertiesDir + File.separator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        HashMap hashMap = this.configFiles;
        synchronized (hashMap) {
            this.checkConfig();
        }
        AlarmManager.create((long)this.reloadInterval, (AlarmListener)this, null);
    }

    protected void checkConfig() {
        Iterator iterator = this.configFiles.values().iterator();
        while (iterator.hasNext()) {
            ConfigFileEntry configFileEntry = (ConfigFileEntry)iterator.next();
            try {
                if (configFileEntry.lastModified == configFileEntry.configFile.lastModified()) continue;
                if (configFileEntry.configFile.exists()) {
                    if (this.loadConfig(configFileEntry.fileName, configFileEntry.isWarFile, configFileEntry.isModule, configFileEntry.appName, configFileEntry.appContext)) continue;
                    iterator.remove();
                    continue;
                }
                iterator.remove();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.checkConfig", "110", this);
                iterator.remove();
            }
        }
    }

    public void addLegacyCacheEntry(ConfigEntry configEntry) {
        if (this.preProcessEntry(configEntry)) {
            this.globalCacheEntries.add(configEntry);
            this.legacyCacheEntries.add(configEntry);
        }
    }

    public ConfigEntry getJaxRpcConfigEntry(String string) {
        return (ConfigEntry)this.jaxRpcClientConfigEntries.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigEntry getCacheEntry(Object object, String string, String string2) {
        Class<?> clazz;
        String string3;
        ConfigEntry configEntry;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCacheEntry()" + string + " " + string2));
        }
        if ((configEntry = (ConfigEntry)this.entryCache.get(string3 = (clazz = object.getClass()).getName() + (string != null ? string : "null") + (string2 != null ? string2 : "null"))) == null) {
            String string4;
            String string5 = clazz.getName() + ".class";
            String string6 = string4 = string2 == null ? string5 : string2 + "/" + string5;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Searching config entries for 1of2" + string));
                Tr.debug((TraceComponent)tc, (String)("Searching config entries for 2of2" + string4));
            }
            for (int i = 0; i < this.globalCacheEntries.size() && configEntry == null; ++i) {
                ConfigEntry configEntry2 = (ConfigEntry)this.globalCacheEntries.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checking " + configEntry2.className + " " + configEntry2.name + ": " + configEntry2.allNames));
                }
                if (!configEntry2.allNames.contains(string) && !configEntry2.allNames.contains(string4)) continue;
                configEntry = (ConfigEntry)configEntry2.clone();
                HashMap hashMap = this.entryCache;
                synchronized (hashMap) {
                    this.entryCache.put(string3, configEntry);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Config Entry cached using key " + string3));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("using config entry: " + configEntry));
            }
        }
        return configEntry;
    }

    public ConfigEntry getCacheEntry(Object object, String string) {
        return this.getCacheEntry(object, string, null);
    }

    public CacheProcessor getCacheProcessor(ConfigEntry configEntry) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCacheProcessor");
        }
        if (configEntry == null) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("iClassName = " + configEntry.iClassName));
        }
        CacheProcessor cacheProcessor = (CacheProcessor)this.processorPool.pools[configEntry.iClassName].remove();
        cacheProcessor.reset(configEntry);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCacheProcessor: " + cacheProcessor));
        }
        return cacheProcessor;
    }

    public void returnCacheProcessor(CacheProcessor cacheProcessor) {
        this.processorPool.pools[cacheProcessor.configEntry.iClassName].add(cacheProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadConfig(String string, boolean bl, boolean bl2, String string2, HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadConfig");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("loading cache config file from: " + string));
        }
        String string3 = string;
        File file = new File(string);
        if (file.isDirectory()) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            string3 = bl ? string + "WEB-INF/cachespec.xml" : string + "META-INF/cachespec.xml";
        }
        HashMap hashMap2 = this.configFiles;
        synchronized (hashMap2) {
            block35: {
                block34: {
                    boolean bl3;
                    block33: {
                        ConfigFileEntry configFileEntry = (ConfigFileEntry)this.configFiles.get(string);
                        if (configFileEntry == null) {
                            configFileEntry = new ConfigFileEntry();
                            configFileEntry.configFile = new File(string3);
                            configFileEntry.fileName = string;
                            configFileEntry.lastModified = 0L;
                            configFileEntry.isModule = bl2;
                            configFileEntry.isJarFile = file.isFile() && bl2;
                            configFileEntry.isWarFile = bl;
                            configFileEntry.appContext = hashMap;
                            this.configFiles.put(string, configFileEntry);
                        }
                        if (!configFileEntry.configFile.exists()) {
                            return false;
                        }
                        if (configFileEntry.lastModified == configFileEntry.configFile.lastModified()) return true;
                        configFileEntry.lastModified = configFileEntry.configFile.lastModified();
                        try {
                            try {
                                HashMap<String, ConfigEntry> hashMap3;
                                Object object;
                                Object object2;
                                CacheHandler cacheHandler = new CacheHandler(string2, hashMap);
                                XMLReader xMLReader = null;
                                if (this.jaxpParser == null) {
                                    this.jaxpParser = this.newSAXParser();
                                }
                                xMLReader = this.jaxpParser.getXMLReader();
                                try {
                                    xMLReader.setFeature("http://xml.org/sax/features/validation", true);
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.loadConfig", "250", this);
                                }
                                RuleHandler ruleHandler = new RuleHandler();
                                ruleHandler.addRule("cache", cacheHandler);
                                xMLReader.setContentHandler(ruleHandler);
                                xMLReader.setErrorHandler(new ConfigErrorHandler(string3));
                                xMLReader.setEntityResolver(new CacheSpecEntityResolver());
                                if (configFileEntry.isJarFile) {
                                    object2 = new ZipFile(string3);
                                    object = ((ZipFile)object2).getEntry(configFileEntry.isWarFile ? "WEB-INF/cachespec.xml" : "META-INF/cachespec.xml");
                                    if (object == null) {
                                        ((ZipFile)object2).close();
                                        bl3 = false;
                                        Object var22_24 = null;
                                        break block33;
                                    }
                                    cacheHandler.setFilename(configFileEntry.fileName + (configFileEntry.isWarFile ? "WEB-INF/cachespec.xml" : "META-INF/cachespec.xml"));
                                    hashMap3 = ((ZipFile)object2).getInputStream((ZipEntry)object);
                                    xMLReader.parse(new InputSource((InputStream)((Object)hashMap3)));
                                    ((InputStream)((Object)hashMap3)).close();
                                    ((ZipFile)object2).close();
                                } else {
                                    cacheHandler.setFilename(string3);
                                    xMLReader.parse(string3);
                                }
                                configFileEntry.configEntries = cacheHandler.getEntries();
                                object2 = configFileEntry.configEntries.iterator();
                                while (object2.hasNext()) {
                                    object = (ConfigEntry)object2.next();
                                    if (!this.preProcessEntry((ConfigEntry)object)) {
                                        object2.remove();
                                        continue;
                                    }
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug((TraceComponent)tc, (String)("cache policy:" + object));
                                }
                                object = new ArrayList();
                                object2 = this.configFiles.values().iterator();
                                while (object2.hasNext()) {
                                    hashMap3 = (ConfigFileEntry)object2.next();
                                    if (((ConfigFileEntry)((Object)hashMap3)).configEntries == null) continue;
                                    ((ArrayList)object).addAll(((ConfigFileEntry)((Object)hashMap3)).configEntries);
                                }
                                ((ArrayList)object).addAll(this.legacyCacheEntries);
                                hashMap3 = null;
                                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                                    ConfigEntry configEntry = (ConfigEntry)((ArrayList)object).get(i);
                                    if (configEntry.iClassName != 4) continue;
                                    ConfigEntry configEntry2 = (ConfigEntry)configEntry.clone();
                                    if (hashMap3 == null) {
                                        hashMap3 = new HashMap<String, ConfigEntry>(10);
                                    }
                                    if (configEntry2 == null) continue;
                                    object2 = configEntry.allNames.iterator();
                                    while (object2.hasNext()) {
                                        String string4 = (String)object2.next();
                                        hashMap3.put(string4, configEntry2);
                                    }
                                }
                                if (hashMap3 == null) {
                                    this.jaxRpcClientConfigEntries.clear();
                                } else {
                                    this.jaxRpcClientConfigEntries = hashMap3;
                                }
                                this.globalCacheEntries = object;
                                HashMap hashMap4 = this.entryCache;
                                synchronized (hashMap4) {
                                    this.entryCache.clear();
                                }
                                this.fireChangedEvent();
                                Tr.info((TraceComponent)tc, (String)"DYNA0047I", (Object)new Object[]{string3});
                                break block34;
                            }
                            catch (SAXParseException sAXParseException) {
                                FFDCFilter.processException((Throwable)sAXParseException, "com.ibm.ws.cache.config.ConfigManager.loadConfig", "295", this);
                                String string5 = sAXParseException.getMessage();
                                String string6 = Integer.toString(sAXParseException.getLineNumber());
                                String string7 = Integer.toString(sAXParseException.getColumnNumber());
                                Tr.error((TraceComponent)tc, (String)"DYNA0045E", (Object)new Object[]{string5, string, string6, string7});
                                Tr.error((TraceComponent)tc, (String)"DYNA0043E", (Object)new Object[]{string});
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"dynacache config error", (Object)sAXParseException);
                                }
                                Object var22_26 = null;
                                if (!tc.isEntryEnabled()) return true;
                                Tr.exit((TraceComponent)tc, (String)"loadConfig");
                                break block35;
                            }
                            catch (IOException iOException) {
                                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.config.ConfigManager.loadConfig", "303", this);
                                Tr.error((TraceComponent)tc, (String)"DYNA0046E", (Object)new Object[]{iOException.getMessage(), string});
                                Tr.error((TraceComponent)tc, (String)"DYNA0043E", (Object)new Object[]{string});
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"dynacache config error", (Object)iOException);
                                }
                                Object var22_27 = null;
                                if (!tc.isEntryEnabled()) return true;
                                Tr.exit((TraceComponent)tc, (String)"loadConfig");
                                break block35;
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.loadConfig", "308", this);
                                Tr.error((TraceComponent)tc, (String)"DYNA0043E", (Object)new Object[]{string});
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"dynacache config error", (Object)exception);
                                }
                                Object var22_28 = null;
                                if (!tc.isEntryEnabled()) return true;
                                Tr.exit((TraceComponent)tc, (String)"loadConfig");
                                break block35;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var22_29 = null;
                            if (!tc.isEntryEnabled()) throw throwable;
                            Tr.exit((TraceComponent)tc, (String)"loadConfig");
                            throw throwable;
                        }
                    }
                    if (!tc.isEntryEnabled()) return bl3;
                    Tr.exit((TraceComponent)tc, (String)"loadConfig");
                    return bl3;
                }
                Object var22_25 = null;
                if (!tc.isEntryEnabled()) return true;
                Tr.exit((TraceComponent)tc, (String)"loadConfig");
            }
            return true;
        }
    }

    public ArrayList getEntries() {
        return this.globalCacheEntries;
    }

    protected boolean preProcessEntry(ConfigEntry configEntry) {
        boolean bl = true;
        if (configEntry.className.equalsIgnoreCase("servlet")) {
            configEntry.iClassName = 1;
        } else if (configEntry.className.equalsIgnoreCase("command")) {
            configEntry.iClassName = 2;
        } else if (configEntry.className.equalsIgnoreCase("webservice")) {
            configEntry.iClassName = 3;
        } else if (configEntry.className.equalsIgnoreCase("JAXRPCClient")) {
            configEntry.iClassName = 4;
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA0050E", (Object)new Object[]{configEntry.className, "class"});
            bl = false;
        }
        if (bl) {
            CacheProcessor cacheProcessor = this.getCacheProcessor(configEntry);
            bl = cacheProcessor.preProcess(configEntry);
            this.returnCacheProcessor(cacheProcessor);
        }
        return bl;
    }

    private SAXParser newSAXParser() {
        SAXParser sAXParser;
        block7: {
            SAXParserFactory sAXParserFactory = null;
            sAXParser = null;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ConfigManager.newSAXParser()");
            }
            try {
                sAXParserFactory = ParserFactory.newSAXParserFactory();
                sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
                sAXParser = sAXParserFactory.newSAXParser();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                FFDCFilter.processException((Throwable)parserConfigurationException, "com.ibm.ws.cache.config.ConfigManager.newSAXParser", "314", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ConfigManager: ParserConfigurationException in newSAXParser()");
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                FFDCFilter.processException((Throwable)sAXNotRecognizedException, "com.ibm.ws.cache.config.ConfigManager.newSAXParser", "317", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ConfigManager: SAXNotRecognizedException in newSAXParser()");
                }
            }
            catch (SAXException sAXException) {
                FFDCFilter.processException((Throwable)sAXException, "com.ibm.ws.cache.config.ConfigManager.newSAXParser", "320", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"ConfigManager: SAXException in newSAXParser()");
            }
        }
        return sAXParser;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class MultiProcessorPool {
        CacheProcessorPool[] pools = new CacheProcessorPool[16];

        MultiProcessorPool() {
            this.addPool(1, "com.ibm.ws.cache.servlet.FragmentCacheProcessor");
            this.addPool(3, "com.ibm.ws.cache.servlet.WebServicesCacheProcessor");
            this.addPool(4, "com.ibm.ws.cache.webservices.client.JAXRPCCacheProcessor");
            this.addPool(2, "com.ibm.ws.cache.command.CommandCacheProcessor");
        }

        public void addPool(int n, String string) {
            try {
                this.pools[n] = new CacheProcessorPool(100, string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.MultiProcessorPool", "402", this);
            }
        }
    }

    static class CacheProcessorPool
    extends ObjectPool {
        Class myClass;

        public CacheProcessorPool(int n, String string) {
            super("CommandCacheProcessorPool", n);
            try {
                this.myClass = (class$com$ibm$ws$cache$config$ConfigManager == null ? (class$com$ibm$ws$cache$config$ConfigManager = ConfigManager.class$("com.ibm.ws.cache.config.ConfigManager")) : class$com$ibm$ws$cache$config$ConfigManager).getClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.cache.config.ConfigManager.CacheProcessorPool", "378", (Object)this);
            }
        }

        protected Object createObject() {
            try {
                return this.myClass.newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.config.ConfigManager.CacheProcessorPool", "382", (Object)this);
                return null;
            }
        }

        public boolean add(CacheProcessor cacheProcessor) {
            cacheProcessor.reset(null);
            return super.add((Object)cacheProcessor);
        }
    }

    static class CacheSpecEntityResolver
    implements EntityResolver {
        CacheSpecEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) {
            try {
                String string3 = propertiesDir + ConfigManager.CACHE_SPEC_DTD;
                return new InputSource(new FileReader(string3));
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.config.ConfigManager.resolveEntity", "332", this);
                return null;
            }
        }
    }
}

