/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.persistent.htod;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.SerializationUtility;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.persistent.filemgr.FileManager;
import com.ibm.ws.cache.persistent.filemgr.FileManagerException;
import com.ibm.ws.cache.persistent.filemgr.FileManagerImpl;
import com.ibm.ws.cache.persistent.htod.HashHeader;
import com.ibm.ws.cache.persistent.htod.HashtableAction;
import com.ibm.ws.cache.persistent.htod.HashtableEntry;
import com.ibm.ws.cache.persistent.htod.HashtableInitInterface;
import com.ibm.ws.cache.persistent.htod.HashtableOnDiskException;
import com.ibm.ws.cache.persistent.htod.Rehash;
import com.ibm.ws.cache.persistent.htod.Semaphore;
import com.ibm.ws.cache.persistent.util.ByteArrayPlusOutputStream;
import com.ibm.ws.cache.persistent.util.ProfTimer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;

public class HashtableOnDisk {
    private static TraceComponent tc = Trace.register(class$com$ibm$ws$cache$persistent$htod$HashtableOnDisk == null ? (class$com$ibm$ws$cache$persistent$htod$HashtableOnDisk = HashtableOnDisk.class$("com.ibm.ws.cache.persistent.htod.HashtableOnDisk")) : class$com$ibm$ws$cache$persistent$htod$HashtableOnDisk, "WebSphere Persistent Hashtable", "com.ibm.ws.cache.resources.dynacache");
    HashHeader header = null;
    int defaulttablesize = 477551;
    long[] htindex = null;
    long[] new_htindex = null;
    int threshold;
    Semaphore iterationLock;
    FileManager filemgr = null;
    long currentTable = 0L;
    String filename = null;
    boolean debug = false;
    ByteArrayPlusOutputStream dataout = null;
    byte[] databuf = null;
    ByteArrayPlusOutputStream keyout = null;
    byte[] keybuf = null;
    HashtableInitInterface item_initialize = null;
    boolean readonly = false;
    byte[] headeroutbuf = null;
    ByteArrayOutputStream headeroutbytestream = null;
    DataOutputStream headerout = null;
    byte[] headerinbuf = null;
    ByteArrayInputStream headerinbytestream = null;
    DataInputStream headerin = null;
    ArrayList rangeIndexList = new ArrayList();
    public int rangeExpiredIndex = 0;
    static final int DWORDSIZE = 8;
    static final int SWORDSIZE = 4;
    static final int magic = 71750002;
    int collisions = 0;
    int read_requests = 0;
    int read_hits = 0;
    int write_replacements = 0;
    int write_requests = 0;
    long bytes_deserialized = 0L;
    long bytes_serialized = 0L;
    int removes = 0;
    int clears = 0;
    boolean auto_rehash = false;
    ProfTimer serializeTimer = null;
    ProfTimer deserializeTimer = null;
    int serialize_time = 0;
    int deserialize_time = 0;
    static /* synthetic */ Class class$com$ibm$ws$cache$persistent$htod$HashtableOnDisk;

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    protected HashtableOnDisk(FileManager fileManager, boolean bl, long l) throws FileManagerException, ClassNotFoundException, IOException, HashtableOnDiskException {
        this.init(fileManager, bl, l, null);
    }

    protected HashtableOnDisk(FileManager fileManager, boolean bl, long l, HashtableInitInterface hashtableInitInterface) throws FileManagerException, ClassNotFoundException, IOException, HashtableOnDiskException {
        this.init(fileManager, bl, l, hashtableInitInterface);
    }

    protected void init(FileManager fileManager, boolean bl, long l, HashtableInitInterface hashtableInitInterface) throws FileManagerException, ClassNotFoundException, IOException, HashtableOnDiskException {
        this.filemgr = fileManager;
        this.filename = fileManager.filename();
        this.item_initialize = hashtableInitInterface;
        this.readonly = fileManager.isReadOnly();
        this.auto_rehash = bl;
        this.header = new HashHeader(fileManager, l);
        if (this.header.magic != 71750002) {
            throw new HashtableOnDiskException("Invalid magic string. Expected 71750002 received " + this.header.magic);
        }
        this.currentTable = this.header.currentTable();
        this.threshold = this.header.loadFactor * this.header.tablesize() / 100;
        this.cacheHTIndex();
        this.serializeTimer = new ProfTimer();
        this.deserializeTimer = new ProfTimer();
        this.iterationLock = new Semaphore();
        if (this.header.rehashInProgress != 0L) {
            this.recover();
            this.cacheHTIndex();
            this.iterationLock.p();
            this.iterationLock.v();
        }
        if (this.header.num_objects() == 0) {
            this.countObjects();
        }
        fileManager.flush();
    }

    void cacheHTIndex() throws IOException {
        this.htindex = new long[this.header.tablesize()];
        byte[] byArray = new byte[this.header.tablesize() * 8];
        this.filemgr.seek(this.currentTable);
        this.filemgr.read(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        for (int i = 0; i < this.header.tablesize(); ++i) {
            this.htindex[i] = dataInputStream.readLong();
        }
        dataInputStream.close();
        byArray = null;
    }

    public static HashtableOnDisk getInstance(FileManager fileManager, boolean bl, long l) throws FileManagerException, ClassNotFoundException, IOException, HashtableOnDiskException {
        return HashtableOnDisk.getStaticInstance(fileManager, bl, l, null);
    }

    public static HashtableOnDisk getStaticInstance(FileManager fileManager, boolean bl, long l, HashtableInitInterface hashtableInitInterface) throws FileManagerException, ClassNotFoundException, IOException, HashtableOnDiskException {
        if (l == 0L) {
            l = fileManager.start();
        }
        HashtableOnDisk hashtableOnDisk = null;
        try {
            hashtableOnDisk = new HashtableOnDisk(fileManager, bl, l, hashtableInitInterface);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return hashtableOnDisk;
    }

    public static long createInstance(FileManager fileManager, int n, int n2) throws IOException, HashtableOnDiskException {
        HashHeader hashHeader = new HashHeader(fileManager, 71750002, n2, n);
        return hashHeader.disklocation;
    }

    public static void destroyInstance(FileManager fileManager, long l) throws IOException, HashtableOnDiskException {
        if (l == 0L) {
            throw new HashtableOnDiskException("Attempt to destroy instance 0");
        }
        fileManager.deallocate(l);
    }

    public FileManager getFileManager() {
        return this.filemgr;
    }

    public static boolean exists(String string, int n) {
        File file = n == 1 ? new File(string + "." + 0) : new File(string);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.iterationLock.p();
        try {
            HashtableOnDisk hashtableOnDisk = this;
            synchronized (hashtableOnDisk) {
                this.header.write();
                this.filemgr = null;
            }
        }
        finally {
            this.iterationLock.v();
        }
    }

    public synchronized int size() {
        return this.header.num_objects();
    }

    public int tablesize() {
        return this.header.tablesize();
    }

    public int getNextRangeIndex() {
        int n = this.rangeIndexList.size();
        if (n > 0) {
            Integer n2 = (Integer)this.rangeIndexList.get(n - 1);
            return n2;
        }
        return 0;
    }

    public int getPreviousRangeIndex() {
        int n = this.rangeIndexList.size();
        if (n == 2) {
            this.rangeIndexList.remove(1);
            return 0;
        }
        if (n == 1) {
            return 0;
        }
        this.rangeIndexList.remove(n - 1);
        this.rangeIndexList.remove(n - 2);
        Integer n2 = (Integer)this.rangeIndexList.get(n - 3);
        return n2;
    }

    public void addRangeIndex(int n) {
        this.rangeIndexList.add(new Integer(n));
    }

    public void initRangeIndex() {
        this.rangeIndexList.clear();
        this.rangeIndexList.add(new Integer(0));
    }

    public String getFilename() {
        return this.filename;
    }

    public int load() {
        return this.header.loadFactor;
    }

    public void dump_filemgr_header(Writer writer) throws IOException {
        this.filemgr.dump_stats_header(writer);
    }

    public void dump_filemgr_stats(Writer writer, boolean bl) throws IOException {
        this.filemgr.dump_stats(writer, bl);
    }

    public void dump_filemgr_memory(Writer writer) throws IOException {
        this.filemgr.dump_memory(writer);
    }

    public void dump_filemgr_disk(Writer writer) throws IOException {
        this.filemgr.dump_disk_memory(writer);
    }

    public static boolean isByteArray(Object object) {
        Class<?> clazz;
        if (object == null) {
            return false;
        }
        Class<?> clazz2 = object.getClass();
        return clazz2.isArray() && (clazz = clazz2.getComponentType()) == Byte.TYPE;
    }

    public synchronized boolean containsKey(Object object) throws FileManagerException, ClassNotFoundException, IOException, HashtableOnDiskException {
        if (this.filemgr == null) {
            throw new HashtableOnDiskException("No Filemanager");
        }
        HashtableEntry hashtableEntry = this.findEntry(object, false, false);
        return hashtableEntry != null;
    }

    public synchronized Object get(Object object) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        HashtableEntry hashtableEntry;
        if (this.filemgr == null) {
            throw new HashtableOnDiskException("No Filemanager");
        }
        Object object2 = null;
        if (object2 == null && (hashtableEntry = this.findEntry(object, true, false)) != null) {
            object2 = hashtableEntry.value;
        }
        ++this.read_requests;
        if (object2 != null) {
            ++this.read_hits;
        }
        return object2;
    }

    public synchronized Object get_or_expire(Object object) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        HashtableEntry hashtableEntry;
        if (this.filemgr == null) {
            throw new HashtableOnDiskException("No Filemanager");
        }
        Object object2 = null;
        if (object2 == null && (hashtableEntry = this.findEntry(object, true, true)) != null) {
            if (hashtableEntry.expired() < 0L) {
                this.remove(object);
                this.println("Expiring[" + -hashtableEntry.expired() / 1000L + "] " + object);
            } else {
                object2 = hashtableEntry.value;
            }
        }
        ++this.read_requests;
        if (object2 != null) {
            ++this.read_hits;
        }
        return object2;
    }

    public synchronized boolean put(Object object, byte[] byArray, int n, long l, long l2) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (object == null) {
            return false;
        }
        if (byArray == null) {
            return false;
        }
        this.mapPut(object, byArray, n, l, l2);
        return true;
    }

    public synchronized boolean put(Object object, Object object2, long l, long l2) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (object == null) {
            return false;
        }
        if (object2 == null) {
            return false;
        }
        this.mapPut(object, object2, -1, l, l2);
        return true;
    }

    public synchronized boolean put(Object object, byte[] byArray, int n) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (object == null) {
            return false;
        }
        if (byArray == null) {
            return false;
        }
        this.mapPut(object, byArray, n, -1L, -1L);
        return true;
    }

    public synchronized boolean put(Object object, Object object2) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (object == null) {
            return false;
        }
        if (object2 == null) {
            return false;
        }
        this.mapPut(object, object2, -1, -1L, -1L);
        return true;
    }

    protected Object mapPut(Object object, Object object2, int n, long l, long l2) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        HashtableEntry hashtableEntry;
        if (this.filemgr == null) {
            throw new HashtableOnDiskException("No Filemanager");
        }
        ++this.write_requests;
        Object var8_6 = null;
        if (object == null) {
            return null;
        }
        if (this.auto_rehash && this.header.num_objects() + 1 > this.threshold && this.header.rehashInProgress == 0L) {
            this.rehash();
        }
        if ((hashtableEntry = this.findEntry(object, false, false)) != null) {
            Object object3 = hashtableEntry.getValue();
            long l3 = hashtableEntry.location;
            hashtableEntry.value = object2;
            hashtableEntry.length = n;
            if (this.getHtindex(hashtableEntry.index, hashtableEntry.tableid) == hashtableEntry.location) {
                this.updateHtindex(hashtableEntry.index, hashtableEntry.next, hashtableEntry.tableid);
            }
            hashtableEntry.location = 0L;
            this.writeEntry(hashtableEntry);
            this.filemgr.deallocate(l3);
            this.filemgr.flush();
            ++this.write_replacements;
            return object3;
        }
        int n2 = this.header.getTableidForNewEntry();
        HashtableEntry hashtableEntry2 = new HashtableEntry(object, object2, this.header.tablesize(n2), n2, n, 0L, l, l2);
        this.writeEntry(hashtableEntry2);
        this.header.incrementObjectCount();
        this.filemgr.flush();
        return null;
    }

    public synchronized boolean remove(Object object) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (this.filemgr == null) {
            throw new HashtableOnDiskException("No Filemanager");
        }
        if (object == null) {
            return false;
        }
        HashtableEntry hashtableEntry = this.findEntry(object, false, false);
        if (hashtableEntry == null) {
            return false;
        }
        return this.remove(hashtableEntry);
    }

    public synchronized boolean remove(Object object, long l) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (this.filemgr == null) {
            throw new HashtableOnDiskException("No Filemanager");
        }
        if (object == null) {
            return false;
        }
        HashtableEntry hashtableEntry = this.findEntry(object, false, false);
        if (hashtableEntry == null) {
            return false;
        }
        if (hashtableEntry.expire_last_referenced(l)) {
            return this.remove(hashtableEntry);
        }
        return false;
    }

    protected Object mapRemove(Object object) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (object == null) {
            return null;
        }
        HashtableEntry hashtableEntry = this.findEntry(object, false, false);
        if (hashtableEntry == null) {
            return null;
        }
        Object object2 = hashtableEntry.getValue();
        if (!this.remove(hashtableEntry)) {
            object2 = null;
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException, EOFException, FileManagerException {
        this.iterationLock.p();
        try {
            HashtableOnDisk hashtableOnDisk = this;
            synchronized (hashtableOnDisk) {
                if (this.filemgr == null) {
                    throw new HashtableOnDiskException("No Filemanager");
                }
                int n = this.header.currentTableId();
                ++this.clears;
                for (int i = 0; i < this.header.tablesize(); ++i) {
                    this.filemgr.seek(this.header.calcOffset(i, n));
                    long l = this.filemgr.readLong();
                    while (l != 0L) {
                        this.filemgr.seek(l);
                        long l2 = this.filemgr.readLong();
                        this.header.decrementObjectCount();
                        this.filemgr.deallocate(l);
                        l = l2;
                    }
                    this.writeHashIndex(i, 0L, n);
                }
            }
        }
        finally {
            this.iterationLock.v();
        }
    }

    public int iterateObjects(HashtableAction hashtableAction, int n, int n2) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        return this.walkHash(hashtableAction, true, n, n2);
    }

    public int iterateKeys(HashtableAction hashtableAction, int n, int n2) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        return this.walkHash(hashtableAction, false, n, n2);
    }

    public void startRehash(int n) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (this.header.rehashInProgress == 0L) {
            this.doRehash(n);
        }
    }

    private boolean remove(HashtableEntry hashtableEntry) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (hashtableEntry == null) {
            throw new HashtableOnDiskException("remove: Internal error, null entry.");
        }
        ++this.removes;
        if (hashtableEntry.location == this.getHtindex(hashtableEntry.index, hashtableEntry.tableid)) {
            this.writeHashIndex(hashtableEntry.index, hashtableEntry.next, hashtableEntry.tableid);
        } else {
            this.updatePointer(hashtableEntry.previous, hashtableEntry.next);
        }
        this.header.decrementObjectCount();
        this.filemgr.deallocate(hashtableEntry.location);
        this.filemgr.flush();
        return true;
    }

    private void writeHashIndex(int n, long l, int n2) throws IOException {
        long l2 = this.header.calcOffset(n, n2);
        this.filemgr.seek(l2);
        this.filemgr.writeLong(l);
        this.updateHtindex(n, l, n2);
    }

    void updateHtindex(int n, long l, int n2) {
        if (n2 == this.header.currentTableId()) {
            this.htindex[n] = l;
        } else {
            this.new_htindex[n] = l;
        }
    }

    long getHtindex(int n, int n2) {
        if (n2 == this.header.currentTableId()) {
            return this.htindex[n];
        }
        return this.new_htindex[n];
    }

    private void updatePointer(long l, long l2) throws IOException, EOFException {
        this.filemgr.seek(l);
        this.filemgr.writeLong(l2);
    }

    private void initWriteBuffer() throws IOException {
        if (this.headeroutbuf == null) {
            int n = 56;
            this.headeroutbuf = new byte[n];
            this.headeroutbytestream = new ByteArrayPlusOutputStream(this.headeroutbuf);
            this.headerout = new DataOutputStream(this.headeroutbytestream);
        }
        this.headeroutbytestream.reset();
    }

    private void initReadBuffer(long l) throws IOException {
        if (this.headerinbuf == null) {
            int n = 56;
            this.headerinbuf = new byte[n];
            this.headerinbytestream = new ByteArrayInputStream(this.headerinbuf);
            this.headerin = new DataInputStream(this.headerinbytestream);
        }
        this.filemgr.seek(l);
        this.filemgr.read(this.headerinbuf);
        this.headerinbytestream.reset();
    }

    private void updateEntry(HashtableEntry hashtableEntry) throws IOException, EOFException, FileManagerException, ClassNotFoundException {
        if (this.dataout == null) {
            this.dataout = new ByteArrayPlusOutputStream(500);
            this.keyout = new ByteArrayPlusOutputStream(500);
        } else {
            this.dataout.reset();
            this.keyout.reset();
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n = 0;
        int n2 = 0;
        this.serializeTimer.reset();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.keyout);
        objectOutputStream.writeObject(hashtableEntry.key);
        objectOutputStream.close();
        byArray2 = this.keyout.getTheBuffer();
        n = this.keyout.size();
        this.bytes_serialized += (long)n;
        int n3 = 0;
        if (HashtableOnDisk.isByteArray(hashtableEntry.value)) {
            n3 = 1;
            byArray = (byte[])hashtableEntry.value;
            n2 = hashtableEntry.length != -1 ? hashtableEntry.length : byArray.length;
        } else {
            objectOutputStream = new ObjectOutputStream(this.dataout);
            objectOutputStream.writeObject(hashtableEntry.value);
            objectOutputStream.close();
            byArray = this.dataout.getTheBuffer();
            n2 = this.dataout.size();
            this.bytes_serialized += (long)n2;
        }
        this.serialize_time = (int)((long)this.serialize_time + this.serializeTimer.elapsed());
        hashtableEntry.location = this.filemgr.allocate(n + n2 + 4 + 4 + 4 + 4 + 8 + 8 + 8 + 8 + 8 + 8);
        this.initWriteBuffer();
        this.headerout.writeLong(hashtableEntry.next);
        this.headerout.writeInt(hashtableEntry.hash);
        this.headerout.writeLong(System.currentTimeMillis());
        this.headerout.writeLong(System.currentTimeMillis());
        this.headerout.writeLong(hashtableEntry.first_created);
        this.headerout.writeLong(hashtableEntry.expiration);
        this.headerout.writeLong(hashtableEntry.grace);
        this.headerout.writeInt(n);
        this.headerout.flush();
        this.filemgr.seek(hashtableEntry.location);
        this.filemgr.write(this.headeroutbuf);
        this.filemgr.write(byArray2, 0, n);
        this.filemgr.writeInt(n3);
        this.filemgr.writeInt(n2);
        this.filemgr.write(byArray, 0, n2);
        if (n2 > 100000) {
            this.dataout = null;
        }
    }

    private void writeEntry(HashtableEntry hashtableEntry) throws IOException, EOFException, FileManagerException, ClassNotFoundException {
        long l = this.getHtindex(hashtableEntry.index, hashtableEntry.tableid);
        if (l == 0L) {
            this.updateEntry(hashtableEntry);
            this.writeHashIndex(hashtableEntry.index, hashtableEntry.location, hashtableEntry.tableid);
        } else if (l == hashtableEntry.location) {
            this.updateEntry(hashtableEntry);
            this.writeHashIndex(hashtableEntry.index, hashtableEntry.location, hashtableEntry.tableid);
        } else if (hashtableEntry.previous == 0L) {
            hashtableEntry.next = l;
            this.updateEntry(hashtableEntry);
            this.writeHashIndex(hashtableEntry.index, hashtableEntry.location, hashtableEntry.tableid);
        } else if (hashtableEntry.location == 0L) {
            this.updateEntry(hashtableEntry);
            this.updatePointer(hashtableEntry.previous, hashtableEntry.location);
        } else {
            this.updateEntry(hashtableEntry);
        }
    }

    private void deallocate(HashtableEntry hashtableEntry) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (hashtableEntry.location == 0L) {
            throw new HashtableOnDiskException("deallocate:  space not allocated.");
        }
        this.filemgr.deallocate(hashtableEntry.location);
        hashtableEntry.location = 0L;
    }

    private Object readDataField(int n, int n2) throws IOException, ClassNotFoundException {
        Object object = null;
        this.deserializeTimer.reset();
        if (n == 0) {
            if (this.databuf == null || this.databuf.length < n2) {
                this.databuf = new byte[n2];
            }
            this.deserialize_time = (int)((long)this.deserialize_time + this.deserializeTimer.elapsed());
            this.filemgr.read(this.databuf, 0, n2);
            this.deserializeTimer.reset();
            object = SerializationUtility.deserialize(this.databuf, 0, n2);
            this.bytes_deserialized += (long)n2;
        } else {
            object = new byte[n2];
            this.deserialize_time = (int)((long)this.deserialize_time + this.deserializeTimer.elapsed());
            this.filemgr.read((byte[])object);
            this.deserializeTimer.reset();
        }
        this.deserialize_time = (int)((long)this.deserialize_time + this.deserializeTimer.elapsed());
        if (n2 > 100000) {
            this.databuf = null;
        }
        return object;
    }

    protected HashtableEntry readEntry(long l, long l2, boolean bl, boolean bl2, int n) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (l == 0L) {
            return null;
        }
        long l3 = 0L;
        int n2 = 0;
        this.initReadBuffer(l);
        l3 = this.headerin.readLong();
        n2 = this.headerin.readInt();
        return this.readEntry2(l, l3, n2, l2, bl, bl2, n);
    }

    protected HashtableEntry readEntry2(long l, long l2, int n, long l3, boolean bl, boolean bl2, int n2) throws IOException, ClassNotFoundException {
        long l4 = this.headerin.readLong();
        long l5 = this.headerin.readLong();
        long l6 = this.headerin.readLong();
        long l7 = this.headerin.readLong();
        long l8 = this.headerin.readLong();
        int n3 = this.headerin.readInt();
        long l9 = 0L;
        if (bl2 && (l9 = l7 + l8 - System.currentTimeMillis()) < 0L) {
            bl = false;
        }
        int n4 = -1;
        int n5 = 0;
        if (this.keybuf == null || this.keybuf.length < n3) {
            this.keybuf = new byte[n3];
        }
        this.filemgr.read(this.keybuf, 0, n3);
        this.deserializeTimer.reset();
        Object object = null;
        Serializable serializable = SerializationUtility.deserialize(this.keybuf, 0, n3);
        this.deserialize_time = (int)((long)this.deserialize_time + this.deserializeTimer.elapsed());
        this.bytes_deserialized += (long)n3;
        if (bl) {
            n5 = this.filemgr.readInt();
            n4 = this.filemgr.readInt();
            object = this.readDataField(n5, n4);
        }
        return new HashtableEntry(l, l4, l5, l6, serializable, object, l2, l3, this.header.tablesize(n2), n2, n4, l7, l8, l9);
    }

    private HashtableEntry findEntry(Object object, boolean bl, boolean bl2) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (object == null) {
            return null;
        }
        int n = object.hashCode();
        int n2 = this.header.getHtIndex(n, this.header.currentTableId());
        long l = 0L;
        HashtableEntry hashtableEntry = null;
        if (this.header.rehashInProgress == 1L) {
            this.print("*");
            if (this.htindex[n2] != 0L) {
                this.print("A");
                l = this.htindex[n2];
                if (l == 0L) {
                    throw new IllegalStateException("findEntry: ht pointer is null");
                }
                hashtableEntry = this.findEntry(object, n, bl, bl2, l, this.header.currentTableId());
                if (hashtableEntry != null) {
                    return hashtableEntry;
                }
            }
            if (this.new_htindex[n2 = this.header.getHtIndex(n, this.header.alternateTableId())] != 0L) {
                this.print("B ");
                l = this.new_htindex[n2];
                if (l == 0L) {
                    throw new IllegalStateException("findEntry: ht pointer is null");
                }
                return this.findEntry(object, n, bl, bl2, l, this.header.alternateTableId());
            }
            return null;
        }
        if (this.htindex[n2] == 0L) {
            return null;
        }
        int n3 = this.header.currentTableId();
        l = this.htindex[n2];
        if (l == 0L) {
            throw new IllegalStateException("findEntry: ht pointer is null");
        }
        return this.findEntry(object, n, bl, bl2, l, n3);
    }

    private HashtableEntry findEntry(Object object, int n, boolean bl, boolean bl2, long l, int n2) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        long l2 = 0L;
        long l3 = 0L;
        int n3 = 0;
        this.initReadBuffer(l);
        l3 = this.headerin.readLong();
        n3 = this.headerin.readInt();
        while (l != 0L) {
            if (n3 == n) {
                HashtableEntry hashtableEntry = this.readEntry2(l, l3, n3, l2, bl, bl2, n2);
                if (hashtableEntry.key.equals(object)) {
                    return hashtableEntry;
                }
            }
            ++this.collisions;
            l2 = l;
            l = l3;
            if (l == 0L) continue;
            this.initReadBuffer(l);
            l3 = this.headerin.readLong();
            n3 = this.headerin.readInt();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int walkHash(HashtableAction hashtableAction, boolean bl, int n, int n2) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        this.iterationLock.p();
        int n3 = -1;
        int n4 = this.header.tablesize();
        try {
            int n5 = 0;
            for (int i = n; i < n4; ++i) {
                HashtableOnDisk hashtableOnDisk = this;
                synchronized (hashtableOnDisk) {
                    long l = this.getHtindex(i, this.header.currentTableId());
                    HashtableEntry hashtableEntry = this.readEntry(l, 0L, bl, false, this.header.currentTableId());
                    while (hashtableEntry != null) {
                        ++n5;
                        Object object = null;
                        if (bl) {
                            object = hashtableEntry.value;
                        }
                        try {
                            hashtableAction.execute(hashtableEntry);
                        }
                        catch (Exception exception) {
                            throw new HashtableOnDiskException("HashtableAction: " + exception.toString());
                        }
                        hashtableEntry = this.readEntry(hashtableEntry.next, hashtableEntry.location, bl, false, this.header.currentTableId());
                        if (n5 != n2) continue;
                        n3 = i + 1;
                        i = this.header.tablesize();
                        break;
                    }
                    continue;
                }
            }
        }
        finally {
            this.iterationLock.v();
        }
        if (n3 == -1) {
            n3 = n4;
        }
        return n3;
    }

    public void listfiles(Writer writer) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        ListAction listAction = new ListAction(writer);
        this.walkHash(listAction, false, 0, -1);
    }

    public synchronized void reset_stats() {
        this.filemgr.reset_stats();
        this.collisions = 0;
        this.read_hits = 0;
        this.write_replacements = 0;
        this.serialize_time = 0;
        this.deserialize_time = 0;
        this.read_requests = 0;
        this.write_requests = 0;
        this.removes = 0;
        this.clears = 0;
        this.bytes_serialized = 0L;
        this.bytes_deserialized = 0L;
    }

    public void dump_stats_header(Writer writer) throws IOException {
        writer.write("Header-Loc\t");
        writer.write("Header-Size\t");
        writer.write("Magic\t");
        writer.write("Cur-Table\t");
        writer.write("Num-Objects\t");
        writer.write("Load-Factor\t");
        writer.write("Auto_rehash\t");
        writer.write("Rehash\t");
        writer.write("Collisions\t");
        writer.write("Read-Requests\t");
        writer.write("Read-Hits\t");
        writer.write("Write-Replacements\t");
        writer.write("Write-Requests\t");
        writer.write("Serialize-Time\t");
        writer.write("Deserialize_time\t");
        writer.write("Bytes-Serialized\t");
        writer.write("Bytes-deSerialized\t");
        writer.write("Removes\t");
        writer.write("Clears\t");
    }

    public synchronized void dump_htod_stats(Writer writer, boolean bl) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        if (bl) {
            int n;
            long l;
            writer.write("\n\n");
            writer.write("--------------------------------------------------\n");
            writer.write("HTOD Header:\n");
            writer.write("--------------------------------------------------\n");
            writer.write("Header location = " + (this.header.disklocation - 4L) + "\n");
            writer.write("Header size = " + this.filemgr.grain_size() + "\n");
            writer.write("Magic string = " + this.header.magic + "\n");
            writer.write("currentTablePtr = " + this.header.currentTablePtr + "\n");
            writer.write("num_objects = " + this.header.num_objects() + "\n");
            writer.write("loadFactor = " + this.header.loadFactor + "\n");
            writer.write("auto_rehash = " + this.auto_rehash + "\n");
            writer.write("rehashInProgress = " + this.header.rehashInProgress + "\n");
            if (this.header.tableLocation[0] == 0L) {
                writer.write("Hashtable[0] is empty\n");
            } else {
                writer.write("Hashtable[0].tablesize = " + this.header.tablesize[0] + "\n");
                l = this.header.tableLocation[0] - 4L;
                n = this.header.tablesize[0];
                writer.write("Hashtable[0] physical location, size = " + l + " " + n + "\n");
            }
            if (this.header.tableLocation[1] == 0L) {
                writer.write("Hashtable[1] is empty\n");
            } else {
                writer.write("Hashtable[1].tablesize = " + this.header.tablesize[1] + "\n");
                l = this.header.tableLocation[1] - 4L;
                n = this.header.tablesize[1];
                writer.write("Hashtable[1] physical location, size = " + l + " " + n + "\n");
            }
            writer.write("collisions: " + this.collisions + "\n");
            writer.write("read_requests " + this.read_requests + "\n");
            writer.write("read_hits " + this.read_hits + "\n");
            writer.write("write_replacements: " + this.write_replacements + "\n");
            writer.write("write_requests: " + this.write_requests + "\n");
            writer.write("serialize time: " + this.serialize_time + "\n");
            writer.write("deserialize time: " + this.deserialize_time + "\n");
            writer.write("bytes serialized: " + this.bytes_serialized + "\n");
            writer.write("bytes deserialized: " + this.bytes_deserialized + "\n");
            writer.write("removes: " + this.removes + "\n");
            writer.write("clears: " + this.clears + "\n");
            writer.write("--------------------------------------------------\n");
        } else {
            writer.write(this.header.disklocation - 4L + "\t");
            writer.write(this.filemgr.grain_size() + "\t");
            writer.write(this.header.magic + "\t");
            writer.write(this.header.currentTablePtr + "\t");
            writer.write(this.header.num_objects() + "\t");
            writer.write(this.header.loadFactor + "\t");
            writer.write(this.auto_rehash + "\t");
            writer.write(this.header.rehashInProgress + "\t");
            writer.write(this.collisions + "\t");
            writer.write(this.read_requests + "\t");
            writer.write(this.read_hits + "\t");
            writer.write(this.write_replacements + "\t");
            writer.write(this.write_requests + "\t");
            writer.write(this.serialize_time + "\t");
            writer.write(this.deserialize_time + "\t");
            writer.write(this.bytes_serialized + "\t");
            writer.write(this.bytes_deserialized + "\t");
            writer.write(this.removes + "\t");
            writer.write(this.clears + "\t");
        }
    }

    public void dumpFilemgr(Writer writer) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        this.filemgr.dump_memory(writer);
        this.filemgr.dump_disk_memory(writer);
    }

    public void analyzeHash(boolean bl) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        int n;
        boolean bl2 = false;
        long l = this.header.disklocation - 4L;
        this.filemgr.seek(l);
        int n2 = this.filemgr.readInt();
        this.println("\n\n");
        this.println("--------------------------------------------------");
        this.println("Header information:\n");
        this.println("--------------------------------------------------");
        this.println("Header location = " + l);
        this.println("Header size = " + n2);
        this.println("Magic string = " + this.header.magic);
        this.println("currentTablePtr = " + this.header.currentTablePtr);
        this.println("num_objects = " + this.header.num_objects());
        this.println("loadFactor = " + this.header.loadFactor);
        this.println("rehashInProgress = " + this.header.rehashInProgress);
        this.println("currentTablePtr = " + this.header.currentTablePtr);
        if (this.header.tableLocation[0] == 0L) {
            this.println("Hashtable[0] is empty\n");
        } else {
            this.println("Hashtable[0].tablesize = " + this.header.tablesize[0]);
            l = this.header.tableLocation[0] - 4L;
            this.filemgr.seek(l);
            n = this.filemgr.readInt();
            this.println("Hashtable[0] physical location, size = " + l + " " + n);
        }
        if (this.header.tableLocation[1] == 0L) {
            this.println("Hashtable[1] is empty\n");
        } else {
            this.println("Hashtable[1].tablesize = " + this.header.tablesize[1]);
            l = this.header.tableLocation[1] - 4L;
            this.filemgr.seek(l);
            n = this.filemgr.readInt();
            this.println("Hashtable[1] physical location, size = " + l + " " + n);
        }
        this.println("--------------------------------------------------");
    }

    private void countAndVerifyObjects() throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        this.print("Hashtable " + this.filename + " was not closed properly.  Validating ");
        this.header.set_num_objects(0);
        HashtableAction hashtableAction = new HashtableAction(){

            public boolean execute(HashtableEntry hashtableEntry) throws IOException {
                if (HashtableOnDisk.this.header.num_objects() % 100 == 0) {
                    HashtableOnDisk.this.print(".");
                }
                HashtableOnDisk.this.header.incrementObjectCount();
                if (HashtableOnDisk.this.item_initialize != null) {
                    HashtableOnDisk.this.item_initialize.initialize(hashtableEntry.getKey(), hashtableEntry.getValue());
                }
                return true;
            }
        };
        this.walkHash(hashtableAction, true, 0, -1);
        this.header.write();
        this.println("done.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countObjects() throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        this.print("Hashtable " + this.filename + " was not closed properly.  Validating ");
        this.iterationLock.p();
        int n = 0;
        try {
            for (int i = 0; i < this.header.tablesize(); ++i) {
                long l = this.getHtindex(i, this.header.currentTableId());
                while (l != 0L) {
                    if (++n % 100 == 0) {
                        this.print(".");
                    }
                    this.filemgr.seek(l);
                    l = this.filemgr.readLong();
                }
            }
            this.header.set_num_objects(n);
            this.header.write();
        }
        finally {
            this.iterationLock.v();
        }
        this.println("done[" + n + "]\n");
    }

    private void rehash() throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        this.doRehash(this.header.tablesize() * 2 + 1);
    }

    private void doRehash(int n) throws IOException, EOFException, FileManagerException, ClassNotFoundException, HashtableOnDiskException {
        this.iterationLock.p();
        long l = 0L;
        this.header.setRehashFlag(1L);
        l = this.filemgr.allocateAndClear(n * 8);
        this.header.initNewTable(n, l);
        this.new_htindex = new long[n];
        Rehash rehash = new Rehash(this, l, n);
        Thread thread = new Thread(rehash);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rehashAllEntries(long l, int n) throws IOException, ClassNotFoundException, FileManagerException, HashtableOnDiskException {
        if (this.debug) {
            this.print("Rehashing");
        }
        try {
            int n2 = this.header.currentTableId();
            for (int i = 0; i < this.header.tablesize(); ++i) {
                Thread.yield();
                HashtableOnDisk hashtableOnDisk = this;
                synchronized (hashtableOnDisk) {
                    long l2 = this.header.calcOffset(i, n2);
                    this.filemgr.seek(l2);
                    long l3 = this.filemgr.readLong();
                    HashtableEntry hashtableEntry = this.readEntry(l3, 0L, false, false, n2);
                    long l4 = 0L;
                    while (hashtableEntry != null) {
                        int n3 = (hashtableEntry.hash & Integer.MAX_VALUE) % n;
                        long l5 = l + (long)(n3 * 8);
                        this.filemgr.seek(l5);
                        l4 = this.filemgr.readLong();
                        if (l4 != 0L) {
                            this.header.setRehashFlag(l4);
                        }
                        this.filemgr.seek(l5);
                        this.filemgr.writeLong(hashtableEntry.location);
                        this.new_htindex[n3] = hashtableEntry.location;
                        this.filemgr.seek(l2);
                        this.filemgr.writeLong(hashtableEntry.next);
                        this.htindex[i] = hashtableEntry.next;
                        long l6 = hashtableEntry.next;
                        hashtableEntry.next = l4;
                        this.updatePointer(hashtableEntry.location, hashtableEntry.next);
                        this.header.setRehashFlag(1L);
                        hashtableEntry = this.readEntry(l6, 0L, false, false, n2);
                        if (!this.debug) continue;
                        this.print(".");
                    }
                    this.header.updateRehashIndex(i);
                    continue;
                }
            }
            HashtableOnDisk hashtableOnDisk = this;
            synchronized (hashtableOnDisk) {
                this.header.swapTables();
                this.threshold = this.header.loadFactor * this.header.tablesize() / 100;
                this.htindex = this.new_htindex;
                this.new_htindex = null;
            }
        }
        finally {
            this.iterationLock.v();
        }
        if (this.debug) {
            this.println("done");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void recover() throws HashtableOnDiskException, FileManagerException, ClassNotFoundException, IOException, EOFException {
        if (this.debug) {
            this.println("Hashtable recover starts");
        }
        boolean bl = false;
        if (this.header.tableLocation[0] == 0L) {
            if (this.header.currentTablePtr != 1) throw new HashtableOnDiskException("Cannot recover hashtable, current table pointer is invalid.");
            if (this.header.tableLocation[1] == 0L) throw new HashtableOnDiskException("Cannot recover hashtable, no valid table pointers.");
            this.header.tableLocation[0] = 0L;
            this.header.tablesize[0] = 0;
            bl = true;
        } else if (this.header.tableLocation[1] == 0L) {
            if (this.header.currentTablePtr != 0) throw new HashtableOnDiskException("Cannot recover hashtable, current table pointer is invalid.");
            if (this.header.tableLocation[0] == 0L) throw new HashtableOnDiskException("Cannot recover hashtable, no valid table pointers.");
            this.header.tableLocation[1] = 0L;
            this.header.tablesize[1] = 0;
            bl = true;
        }
        if (bl) {
            if (this.debug) {
                this.println("Recovery ended - previous rehash did not enter critical section.");
            }
            this.header.set_num_objects(0);
            this.header.rehashInProgress = 0L;
            this.header.write();
            return;
        }
        long l = this.header.alternateTable();
        int n = this.header.alternateSize();
        this.new_htindex = new long[n];
        if (this.debug) {
            this.println("Clearing inconsistencies");
        }
        this.clearInconsistencies(l, n);
        if (this.debug) {
            this.println("Resuming rehash.");
        }
        this.iterationLock.p();
        Rehash rehash = new Rehash(this, l, n);
        Thread thread = new Thread(rehash);
        thread.start();
    }

    void clearInconsistencies(long l, int n) throws IOException, EOFException, ClassNotFoundException, FileManagerException, HashtableOnDiskException {
        long l2 = this.header.currentTable();
        int n2 = this.header.tablesize();
        for (int i = 0; i < n; ++i) {
            long l3 = l + (long)(i * 8);
            this.filemgr.seek(l3);
            long l4 = this.filemgr.readLong();
            if (this.header.rehashInProgress == l4) {
                this.header.setRehashFlag(1L);
                return;
            }
            HashtableEntry hashtableEntry = this.readEntry(l4, 0L, false, false, this.header.alternateTableId());
            while (hashtableEntry != null) {
                HashtableEntry hashtableEntry2 = this.findEntry(hashtableEntry.key, hashtableEntry.hash, false, false, 0L, this.header.currentTableId());
                if (hashtableEntry2 == null) {
                    if (hashtableEntry.next == 0L) {
                        if (this.header.rehashInProgress != 1L) {
                            hashtableEntry.next = this.header.rehashInProgress;
                        }
                        this.updatePointer(hashtableEntry.location, hashtableEntry.next);
                        this.header.setRehashFlag(1L);
                        return;
                    }
                    HashtableEntry hashtableEntry3 = this.readEntry(hashtableEntry.next, 0L, false, false, this.header.alternateTableId());
                    hashtableEntry2 = this.findEntry(hashtableEntry3.key, hashtableEntry3.hash, false, false, 0L, this.header.currentTableId());
                    if (hashtableEntry2 != null) {
                        hashtableEntry.next = this.header.rehashInProgress == 1L ? 0L : this.header.rehashInProgress;
                        this.updatePointer(hashtableEntry.location, hashtableEntry.next);
                        this.header.setRehashFlag(1L);
                        return;
                    }
                } else {
                    this.filemgr.seek(l3);
                    if (this.header.rehashInProgress == 1L) {
                        this.filemgr.writeLong(0L);
                    } else {
                        this.filemgr.writeLong(this.header.rehashInProgress);
                    }
                    this.header.setRehashFlag(1L);
                    return;
                }
                hashtableEntry = this.readEntry(hashtableEntry.next, 0L, false, false, this.header.alternateTableId());
            }
        }
    }

    void println(String string) {
        Tr.debug((TraceComponent)tc, (String)(string + "\n"));
    }

    void print(String string) {
        Tr.debug((TraceComponent)tc, (String)string);
    }

    static void usage() {
        System.out.println("filemgr.HashtableOnDisk <fn> <instance> [-full]");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        String string = null;
        int n = -1;
        boolean bl = false;
        if (stringArray.length < 2) {
            HashtableOnDisk.usage();
        }
        if (stringArray.length == 2) {
            string = stringArray[0];
            n = Integer.parseInt(stringArray[1]);
            bl = false;
        } else if (stringArray.length == 3) {
            string = stringArray[0];
            n = Integer.parseInt(stringArray[1]);
            if (stringArray[2].equals("-full")) {
                bl = true;
            } else {
                HashtableOnDisk.usage();
            }
        } else {
            HashtableOnDisk.usage();
        }
        System.out.println("filename = " + string);
        System.out.println("full = " + bl);
        try {
            FileManagerImpl fileManagerImpl = new FileManagerImpl(string, false, "r", 1);
            HashtableOnDisk hashtableOnDisk = new HashtableOnDisk(fileManagerImpl, true, n);
            hashtableOnDisk.analyzeHash(bl);
            hashtableOnDisk.close();
            fileManagerImpl.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AnalyzeStruct {
        Object object;
        int buffersize;
        int objectsize;
        long location;

        AnalyzeStruct(Object object, long l, int n, int n2) {
            this.object = object;
            this.buffersize = n;
            this.objectsize = n2;
            this.location = l;
        }
    }

    class ListAction
    implements HashtableAction {
        Writer out;

        ListAction(Writer writer) {
            this.out = writer;
        }

        public boolean execute(HashtableEntry hashtableEntry) throws IOException {
            this.out.write(hashtableEntry.getKey().toString());
            this.out.write("\n");
            this.out.flush();
            return true;
        }
    }
}

