/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.ExternalCacheFragment;
import com.ibm.ws.cache.ExternalCacheServices;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.FragmentComposerMemento;
import javax.servlet.http.HttpServletResponse;

public class JSPCache {
    private Cache cache = null;
    private RemoteServices remoteServices = null;
    private BatchUpdateDaemon batchUpdateDaemon = null;
    private ExternalCacheServices externalCacheServices = null;
    private int defaultPriority = CacheEntry.DEFAULT_PRIORITY;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setBatchUpdateDaemon(BatchUpdateDaemon batchUpdateDaemon) {
        this.batchUpdateDaemon = batchUpdateDaemon;
    }

    public void setRemoteServices(RemoteServices remoteServices) {
        this.remoteServices = remoteServices;
    }

    public void setExternalCacheServices(ExternalCacheServices externalCacheServices) {
        this.externalCacheServices = externalCacheServices;
    }

    public void setDefaultPriority(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("defaultPriority must be nonnegative");
        }
        this.defaultPriority = n;
    }

    public void start() {
        if (this.cache == null || this.batchUpdateDaemon == null || this.remoteServices == null) {
            throw new IllegalStateException("cache, batchUpdateDaemon, and remoteServices must all be set before start()");
        }
    }

    public void setExternalCacheFragment(String string, ExternalCacheFragment externalCacheFragment) {
        this.remoteServices.setExternalCacheFragment(string, externalCacheFragment);
    }

    public void setValue(EntryInfo entryInfo, FragmentComposerMemento fragmentComposerMemento, ExternalCacheFragment externalCacheFragment) {
        fragmentComposerMemento.setExternalCacheFragment(externalCacheFragment);
        if (!entryInfo.wasPrioritySet()) {
            entryInfo.setPriority(this.defaultPriority);
        }
        this.cache.setValue(entryInfo, fragmentComposerMemento);
        if (externalCacheFragment != null && entryInfo.isNotShared()) {
            this.batchUpdateDaemon.pushExternalCacheFragment(externalCacheFragment, this.cache);
        }
        fragmentComposerMemento.setExternalCacheFragment(null);
    }

    public boolean finish(CacheEntry cacheEntry) {
        return this.cache.finish(cacheEntry);
    }

    public void itsUncacheable(String string) {
        this.cache.itsUncacheable(string);
    }

    public CacheEntry getEntry(String string) {
        return (CacheEntry)this.cache.getEntry(string);
    }

    public CacheEntry getEntry(EntryInfo entryInfo) {
        return (CacheEntry)this.cache.getEntry(entryInfo);
    }

    public boolean isValid(String string) {
        return this.cache.isValid(string);
    }

    public Object getValue(EntryInfo entryInfo, boolean bl) {
        return this.cache.getValue(entryInfo, bl);
    }

    public void invalidateById(String string, boolean bl) {
        this.cache.invalidateById(string, bl);
    }

    public void invalidateByTemplate(String string, boolean bl) {
        this.cache.invalidateByTemplate(string, bl);
    }

    public boolean shouldPull(int n, String string) {
        return this.cache.shouldPull(n, string);
    }

    public void preInvoke(String string, CacheProxyRequest cacheProxyRequest, CacheProxyResponse cacheProxyResponse) {
        this.externalCacheServices.preInvoke(string, cacheProxyRequest, (HttpServletResponse)cacheProxyResponse);
    }

    public void postInvoke(String string, CacheProxyRequest cacheProxyRequest, CacheProxyResponse cacheProxyResponse) {
        this.externalCacheServices.postInvoke(string, cacheProxyRequest, (HttpServletResponse)cacheProxyResponse);
    }
}

