/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.CacheableServlet;
import com.ibm.websphere.servlet.event.ApplicationEvent;
import com.ibm.websphere.servlet.event.ApplicationListener;
import com.ibm.websphere.servlet.event.ServletContextEventSource;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.config.ConfigChangeListener;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.ConfigManager;
import com.ibm.ws.cache.servlet.CacheHook;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.FragmentCacheProcessor;
import com.ibm.ws.cache.servlet.FragmentInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.HttpJspPage;

public class ServletWrapper
implements CacheableServlet,
Servlet,
HttpJspPage,
ConfigChangeListener,
ApplicationListener {
    private static TraceComponent tc = Trace.register(class$com$ibm$ws$cache$servlet$ServletWrapper == null ? (class$com$ibm$ws$cache$servlet$ServletWrapper = ServletWrapper.class$("com.ibm.ws.cache.servlet.ServletWrapper")) : class$com$ibm$ws$cache$servlet$ServletWrapper, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    Servlet proxied = null;
    ConfigEntry cacheEntry = null;
    boolean cacheEntrySet = false;
    boolean wrapsCacheableServlet = false;
    private boolean firstTime = true;
    private static ArrayList applicationUnAvailList = new ArrayList();
    static /* synthetic */ Class class$com$ibm$ws$cache$servlet$ServletWrapper;

    public ServletWrapper(Servlet servlet) {
        this.proxied = servlet;
        this.wrapsCacheableServlet = servlet instanceof CacheableServlet;
        ConfigManager.getInstance().addConfigChangeListener(this);
    }

    public void configChanged() {
        this.cacheEntrySet = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareMetadata(CacheProxyRequest cacheProxyRequest, CacheProxyResponse cacheProxyResponse) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("prepareMetadata: " + this.proxied));
        }
        FragmentInfo fragmentInfo = null;
        if (this.wrapsCacheableServlet) {
            CacheableServlet cacheableServlet = (CacheableServlet)this.proxied;
            String string = cacheableServlet.getId(cacheProxyRequest);
            int n = cacheableServlet.getSharingPolicy(cacheProxyRequest);
            if (string == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"cacheId is null");
                }
            } else {
                fragmentInfo = (FragmentInfo)cacheProxyRequest.getFragmentInfo();
                fragmentInfo.setId(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sharingPolicy: " + n));
                }
                fragmentInfo.setSharingPolicy(n);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepareMetadata");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("config entry set=" + this.cacheEntrySet));
        }
        if (!this.cacheEntrySet) {
            this.cacheEntry = ConfigManager.getInstance().getCacheEntry(this.proxied, this.buildName(cacheProxyRequest), cacheProxyRequest.getContextPath());
            this.cacheEntrySet = true;
        }
        fragmentInfo = (FragmentInfo)cacheProxyRequest.getFragmentInfo();
        if (this.cacheEntry == null) {
            fragmentInfo.setId(null);
        } else {
            FragmentCacheProcessor fragmentCacheProcessor = (FragmentCacheProcessor)ConfigManager.getInstance().getCacheProcessor(this.cacheEntry);
            try {
                ArrayList arrayList;
                fragmentCacheProcessor.execute(cacheProxyRequest, cacheProxyResponse, this.proxied);
                fragmentInfo.setId(fragmentCacheProcessor.getId());
                if (fragmentCacheProcessor.getId() != null) {
                    fragmentCacheProcessor.populateFragmentInfo(fragmentInfo);
                }
                if ((arrayList = fragmentCacheProcessor.getInvalidationIds()) != null) {
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        ServerCache.cache.invalidateById((String)arrayList.get(i), i == n - 1);
                    }
                }
            }
            finally {
                ConfigManager.getInstance().returnCacheProcessor(fragmentCacheProcessor);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareMetadata");
        }
    }

    String buildName(CacheProxyRequest cacheProxyRequest) {
        String string = cacheProxyRequest.getAbsoluteUri();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(63);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getId(HttpServletRequest httpServletRequest) {
        CacheProxyRequest cacheProxyRequest = (CacheProxyRequest)httpServletRequest;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getId() for " + this.proxied + " returned " + cacheProxyRequest.getFragmentInfo().getId()));
        }
        return cacheProxyRequest.getFragmentInfo().getId();
    }

    public int getSharingPolicy(HttpServletRequest httpServletRequest) {
        CacheProxyRequest cacheProxyRequest = (CacheProxyRequest)httpServletRequest;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getSharingPolicy() for " + this.proxied + " returned " + cacheProxyRequest.getFragmentInfo().getSharingPolicy()));
        }
        return cacheProxyRequest.getFragmentInfo().getSharingPolicy();
    }

    public void destroy() {
        ConfigEntry configEntry = ConfigManager.getInstance().getCacheEntry(this.proxied, null);
        if (configEntry != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("destroy() - ce=" + configEntry));
            }
            Iterator iterator = configEntry.allNames.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (applicationUnAvailList.contains(string)) {
                    applicationUnAvailList.remove(string);
                    continue;
                }
                ServerCache.cache.invalidateByTemplate(string, true);
            }
        }
        this.proxied.destroy();
        ConfigManager.getInstance().removeConfigChangeListener(this);
    }

    public ServletConfig getServletConfig() {
        return this.proxied.getServletConfig();
    }

    public String getServletInfo() {
        return this.proxied.getServletInfo();
    }

    public ServletContext getServletContext() {
        return this.proxied.getServletConfig().getServletContext();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"init()");
        }
        this.proxied.init(servletConfig);
        ServletContext servletContext = servletConfig.getServletContext();
        if (servletContext != null) {
            ServletContextEventSource servletContextEventSource = (ServletContextEventSource)servletContext.getAttribute("com.ibm.websphere.servlet.event.ServletContextEventSource");
            servletContextEventSource.addApplicationListener((ApplicationListener)this);
        }
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        CacheHook.handleServlet(this, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
    }

    public Servlet getProxiedServlet() {
        return this.proxied;
    }

    public void serviceProxied(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        this.proxied.service(servletRequest, servletResponse);
    }

    public void _jspService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ((HttpJspPage)this.proxied)._jspService(httpServletRequest, httpServletResponse);
    }

    public void jspInit() {
        ((HttpJspPage)this.proxied).jspInit();
    }

    public void jspDestroy() {
        ((HttpJspPage)this.proxied).jspDestroy();
    }

    public void onApplicationStart(ApplicationEvent applicationEvent) {
    }

    public void onApplicationEnd(ApplicationEvent applicationEvent) {
    }

    public void onApplicationAvailableForService(ApplicationEvent applicationEvent) {
    }

    public void onApplicationUnavailableForService(ApplicationEvent applicationEvent) {
        ConfigEntry configEntry = ConfigManager.getInstance().getCacheEntry(this.proxied, null);
        if (configEntry != null) {
            Iterator iterator = configEntry.allNames.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (applicationUnAvailList.contains(string)) continue;
                applicationUnAvailList.add(string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("ApplicationUnavailableForService() current=" + string));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

