/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.webservices.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.SerializationUtility;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.config.CacheProcessor;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.ConfigManager;
import com.ibm.ws.cache.webservices.client.JAXRPCCacheProcessor;
import com.ibm.ws.cache.webservices.client.JAXRPCEntryInfo;
import com.ibm.ws.cache.webservices.client.JAXRPCResponse;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;

public class JAXRPCCache {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$cache$webservices$client$JAXRPCCache == null ? (class$com$ibm$ws$cache$webservices$client$JAXRPCCache = JAXRPCCache.class$("com.ibm.ws.cache.webservices.client.JAXRPCCache")) : class$com$ibm$ws$cache$webservices$client$JAXRPCCache), (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final String WSDL_PORT_NAME = "wsdl.portName";
    private static JAXRPCEntryInfoObjectPool entryInfoPool = new JAXRPCEntryInfoObjectPool(50);
    private static MessageFactory mf = null;
    static /* synthetic */ Class class$com$ibm$ws$cache$webservices$client$JAXRPCCache;

    private JAXRPCCache() {
    }

    public static boolean getId(String string, SOAPMessageContext sOAPMessageContext, EntryInfo entryInfo) {
        Object object;
        Object object2;
        Object object3;
        SOAPMessageContext sOAPMessageContext2 = sOAPMessageContext;
        SOAPHeader sOAPHeader = null;
        SOAPBody sOAPBody = null;
        try {
            object3 = sOAPMessageContext2.getMessage();
            object2 = object3.getSOAPPart();
            object = object2.getEnvelope();
            sOAPHeader = object.getHeader();
            sOAPBody = object.getBody();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.cache.webservices.client.JAXRPCCache.getId", "76");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception while retrieving SOAP elements. " + exception.getMessage()));
            }
            return false;
        }
        if (string == null || string.equals("")) {
            return false;
        }
        object3 = ConfigManager.getInstance().getJaxRpcConfigEntry(string);
        if (object3 == null) {
            return false;
        }
        object2 = (JAXRPCCacheProcessor)ConfigManager.getInstance().getCacheProcessor((ConfigEntry)object3);
        object = (QName)sOAPMessageContext.getProperty(WSDL_PORT_NAME);
        boolean bl = ((JAXRPCCacheProcessor)object2).execute(sOAPMessageContext2, string, null, (QName)object, sOAPHeader, sOAPBody);
        ((CacheProcessor)object2).setEntryInfo(entryInfo);
        ArrayList arrayList = ((CacheProcessor)object2).getInvalidationIds();
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ServerCache.cache.invalidateById((String)arrayList.get(i), i == n - 1);
            }
        }
        ConfigManager.getInstance().returnCacheProcessor((CacheProcessor)object2);
        return bl;
    }

    public static byte[] serialize(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        try {
            ((SOAPMessage)object).writeTo((OutputStream)objectOutputStream);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException(sOAPException, "com.ibm.ws.cache.webservices.client.JAXRPCCache.serialize", "135");
            IOException iOException = new IOException("Exception while serializing SOAP message");
            iOException.initCause(sOAPException);
            throw iOException;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        SOAPMessage sOAPMessage = null;
        try {
            if (mf == null) {
                mf = MessageFactory.newInstance();
            }
            sOAPMessage = mf.createMessage(null, (InputStream)objectInputStream);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException(sOAPException, "com.ibm.ws.cache.webservices.client.JAXRPCCache.deserialize", "160");
            IOException iOException = new IOException("Exception while creating SOAP message from input stream");
            iOException.initCause(sOAPException);
            throw iOException;
        }
        return sOAPMessage;
    }

    public static Object getValue(EntryInfo entryInfo) {
        JAXRPCResponse jAXRPCResponse;
        block4: {
            byte[] byArray = (byte[])ServerCache.cache.getValue(entryInfo, false);
            if (byArray == null) {
                return null;
            }
            jAXRPCResponse = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Deserializing cache value to create SOAP response.");
                }
                jAXRPCResponse = (JAXRPCResponse)SerializationUtility.deserialize(byArray);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.cache.webservices.client.JAXRPCCache.getValue", "187");
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Exception while deserialize SOAP response. " + exception.getMessage()));
            }
        }
        return jAXRPCResponse.getCopyValue();
    }

    public static void setValue(EntryInfo entryInfo, Object object) {
        JAXRPCResponse jAXRPCResponse = new JAXRPCResponse();
        jAXRPCResponse.setCopyValue(object);
        JAXRPCEntryInfo jAXRPCEntryInfo = (JAXRPCEntryInfo)entryInfo;
        byte[] byArray = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Serializing the value to save a copy of SOAP response.");
            }
            byArray = SerializationUtility.serialize(jAXRPCResponse);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.cache.webservices.client.JAXRPCCache.setValue", "230");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception while serialize SOAP response. " + exception.getMessage()));
            }
            return;
        }
        ServerCache.cache.setValue(jAXRPCEntryInfo, byArray);
    }

    public static boolean isCachingEnabled() {
        return ServerCache.cacheEnabled;
    }

    public static void returnToEntryInfoPool(EntryInfo entryInfo) {
        if (entryInfo != null) {
            entryInfo.reset();
            entryInfoPool.add(entryInfo);
        }
    }

    public static EntryInfo getFromEntryInfoPool() {
        return (EntryInfo)entryInfoPool.remove();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class JAXRPCEntryInfoObjectPool
    extends ObjectPool {
        public JAXRPCEntryInfoObjectPool(int n) {
            super("JAXRPCEntryInfoPool", n);
        }

        public Object createObject() {
            return new JAXRPCEntryInfo();
        }
    }
}

