/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.classloader.ClassLoaderListener;
import com.ibm.ws.classloader.ClassLoaderManager;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.component.DeployedApplicationImpl;
import com.ibm.ws.runtime.component.DeployedModuleImpl;
import com.ibm.ws.runtime.deploy.DeployedApplicationFilter;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectHandler;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.ApplicationServer;
import com.ibm.ws.runtime.service.LibraryMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.ResourceMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VirtualHostMgr;
import com.ibm.ws.webcontainer.WebContainerService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TooManyListenersException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class ApplicationMgrImpl
extends ContainerImpl
implements ApplicationMgr,
DeployedObjectListener,
DeployedObjectHandler {
    private static TraceComponent tc = Tr.register(class$com$ibm$ws$runtime$component$ApplicationMgrImpl == null ? (class$com$ibm$ws$runtime$component$ApplicationMgrImpl = ApplicationMgrImpl.class$("com.ibm.ws.runtime.component.ApplicationMgrImpl")) : class$com$ibm$ws$runtime$component$ApplicationMgrImpl, "Runtime", "com.ibm.ws.runtime.runtime");
    static final String SERVERINDEX = "serverindex.xml";
    static final String EAR_EXTENSION = ".ear";
    private boolean extraProcessing = false;
    private ArrayList applications = new ArrayList();
    private ArrayList deployedListeners = new ArrayList();
    private ArrayList deployedHandlers = new ArrayList();
    private ArrayList deployedApplicationFilters = new ArrayList();
    static /* synthetic */ Class class$com$ibm$ws$runtime$component$ApplicationMgrImpl;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ApplicationMgr;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ApplicationServer;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ResourceMgr;
    static /* synthetic */ Class class$com$ibm$ws$classloader$Handler;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$VariableMap;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$VirtualHostMgr;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$LibraryMgr;
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$WebContainerService;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        this.getOuterBCS().addService(class$com$ibm$ws$runtime$service$ApplicationMgr == null ? (class$com$ibm$ws$runtime$service$ApplicationMgr = ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.ApplicationMgr")) : class$com$ibm$ws$runtime$service$ApplicationMgr, this);
        this.setState("INITIALIZING");
        ApplicationServer applicationServer = (ApplicationServer)this.getService(class$com$ibm$ws$runtime$service$ApplicationServer == null ? (class$com$ibm$ws$runtime$service$ApplicationServer = ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.ApplicationServer")) : class$com$ibm$ws$runtime$service$ApplicationServer);
        int n = applicationServer.getClassLoaderPolicy();
        int n2 = applicationServer.getClassLoadingMode();
        this.releaseService(applicationServer);
        boolean bl = n == 1;
        ClassLoaderManager.setSingleServerClassLoader((boolean)bl);
        if (bl) {
            ClassLoaderManager.setDefaultDelegationMode((n2 == 0 ? 1 : 0) != 0);
        }
        ResourceMgr resourceMgr = (ResourceMgr)this.getService(class$com$ibm$ws$runtime$service$ResourceMgr == null ? (class$com$ibm$ws$runtime$service$ResourceMgr = ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.ResourceMgr")) : class$com$ibm$ws$runtime$service$ResourceMgr);
        resourceMgr.registerURLHandler("wsjar", (class$com$ibm$ws$classloader$Handler == null ? (class$com$ibm$ws$classloader$Handler = ApplicationMgrImpl.class$("com.ibm.ws.classloader.Handler")) : class$com$ibm$ws$classloader$Handler).getName(), new String[0]);
        this.releaseService(resourceMgr);
        this.registerMBean();
        this.setState("INITIALIZED");
    }

    public ServerEntry getServerEntry(Repository repository) throws ConfigurationError {
        Resource resource;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "reading", SERVERINDEX);
        }
        String string = repository.getServerName();
        try {
            resource = repository.getConfigRoot().getResource(3, SERVERINDEX);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Error loading serverindex.xml", exception);
        }
        EList eList = ((ServerIndex)resource.getContents().get(0)).getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            if (!serverEntry.getServerName().equals(string)) continue;
            return serverEntry;
        }
        return null;
    }

    private DeployedApplicationImpl initializeApplication(Repository repository, String string, String string2, boolean bl) throws ConfigurationWarning, ConfigurationError {
        DeployedApplicationImpl deployedApplicationImpl;
        ConfigurationWarning configurationWarning;
        block13: {
            int n = this.applications.size();
            for (int i = 0; i < n; ++i) {
                DeployedApplicationImpl deployedApplicationImpl2 = (DeployedApplicationImpl)this.applications.get(i);
                if (!deployedApplicationImpl2.getName().equals(string)) continue;
                Tr.warning(tc, "WSVR0214W", string);
                throw new ConfigurationWarning("Duplicate application, " + string);
            }
            configurationWarning = null;
            deployedApplicationImpl = new DeployedApplicationImpl(string, string2);
            this.add(deployedApplicationImpl);
            boolean bl2 = false;
            try {
                deployedApplicationImpl.initialize(bl ? Boolean.TRUE : Boolean.FALSE);
                if (deployedApplicationImpl.getState() != "INITIALIZED") break block13;
                bl2 = true;
                this.applications.add(deployedApplicationImpl);
                try {
                    deployedApplicationImpl.addDeployedObjectListener(this);
                    deployedApplicationImpl.addDeployedObjectHandler(this);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    bl2 = true;
                    throw new ConfigurationError(tooManyListenersException);
                }
            }
            catch (ConfigurationWarning configurationWarning2) {
                Tr.warning(tc, "WSVR0100W", new Object[]{deployedApplicationImpl.getName(), configurationWarning2});
                configurationWarning = configurationWarning2;
            }
            catch (ConfigurationError configurationError) {
                Tr.error(tc, "WSVR0100W", new Object[]{deployedApplicationImpl.getName(), configurationError});
                throw configurationError;
            }
            catch (Throwable throwable) {
                Tr.error(tc, "WSVR0100W", new Object[]{deployedApplicationImpl.getName(), throwable});
                throw new ConfigurationWarning(throwable);
            }
            finally {
                if (!bl2) {
                    this.destroyApplication(deployedApplicationImpl);
                }
            }
        }
        if (configurationWarning != null) {
            throw configurationWarning;
        }
        return deployedApplicationImpl;
    }

    public void start() throws RuntimeError, RuntimeWarning {
        int n;
        DeployedApplicationImpl[] deployedApplicationImplArray;
        Object object;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "starting applications: " + this.applications.size());
        }
        this.setState("STARTING");
        Repository repository = (Repository)this.getService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository);
        Throwable throwable = null;
        try {
            object = this.getServerEntry(repository);
            deployedApplicationImplArray = object.getDeployedApplications();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initializing Applications", new Integer(deployedApplicationImplArray.size()));
            }
            for (n = 0; n < deployedApplicationImplArray.size(); ++n) {
                String string = (String)deployedApplicationImplArray.get(n);
                int n2 = string.indexOf(47);
                String string2 = n2 == -1 ? string : string.substring(0, n2 - EAR_EXTENSION.length());
                try {
                    this.initializeApplication(repository, string2, string, true);
                    continue;
                }
                catch (ConfigurationWarning configurationWarning) {
                    throwable = configurationWarning;
                    continue;
                }
                catch (ConfigurationError configurationError) {
                    throw configurationError;
                }
            }
        }
        catch (ConfigurationError configurationError) {
            throw new RuntimeError(configurationError.getMessage(), configurationError);
        }
        finally {
            this.releaseService(repository);
        }
        object = null;
        if (throwable != null) {
            object = new RuntimeWarning(throwable.getMessage(), throwable);
        }
        Collections.sort(this.applications);
        deployedApplicationImplArray = this.applications.toArray(new DeployedApplicationImpl[this.applications.size()]);
        for (n = 0; n < deployedApplicationImplArray.length; ++n) {
            try {
                this.startApplication(deployedApplicationImplArray[n]);
                continue;
            }
            catch (RuntimeWarning runtimeWarning) {
                object = runtimeWarning;
            }
        }
        if (throwable != null) {
            throw object;
        }
        this.setState("STARTED");
    }

    protected void startApplication(DeployedApplicationImpl deployedApplicationImpl) throws RuntimeWarning, RuntimeError {
        boolean bl = false;
        boolean bl2 = true;
        int n = this.deployedApplicationFilters.size();
        for (int i = 0; i < n && bl2; ++i) {
            DeployedApplicationFilter deployedApplicationFilter = (DeployedApplicationFilter)this.deployedApplicationFilters.get(i);
            if (deployedApplicationFilter.applicationMayStart(deployedApplicationImpl)) continue;
            bl2 = false;
            FFDCFilter.processException((Throwable)new Exception("could not start application" + deployedApplicationImpl.getName() + " because of filter " + deployedApplicationFilter.toString()), (String)(class$com$ibm$ws$runtime$service$ApplicationMgr == null ? ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.ApplicationMgr") : class$com$ibm$ws$runtime$service$ApplicationMgr).getName(), (String)"291");
        }
        if (bl2) {
            try {
                Tr.audit(tc, "WSVR0200I", deployedApplicationImpl.getName());
                deployedApplicationImpl.start();
                deployedApplicationImpl.addClassLoaderListener(new ApplicationNotifier(deployedApplicationImpl));
                Tr.audit(tc, "WSVR0221I", deployedApplicationImpl.getName());
            }
            catch (RuntimeWarning runtimeWarning) {
                Tr.warning(tc, "WSVR0101W", deployedApplicationImpl.getName());
                bl = true;
                throw runtimeWarning;
            }
            catch (RuntimeError runtimeError) {
                Tr.error(tc, "WSVR0101W", deployedApplicationImpl.getName());
                bl = true;
                throw runtimeError;
            }
            catch (Throwable throwable) {
                Tr.error(tc, "WSVR0101W", deployedApplicationImpl.getName());
                bl = true;
                throw new RuntimeError(throwable);
            }
            finally {
                if (bl) {
                    this.stopApplication(deployedApplicationImpl);
                    this.destroyApplication(deployedApplicationImpl);
                }
            }
        } else {
            this.destroyApplication(deployedApplicationImpl);
            Tr.warning(tc, "WSVR0101W", deployedApplicationImpl.getName());
            throw new RuntimeWarning("could not start application (filtered)");
        }
    }

    protected void registerMBean() {
        try {
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(this, "ApplicationManager");
            mBeanFactory.activateMBean("ApplicationManager", defaultRuntimeCollaborator, "ApplicationManager");
        }
        catch (Throwable throwable) {
            Tr.service(tc, "Attempting to register MBean:", throwable);
        }
    }

    public void stop() {
        this.setState("STOPPING");
        for (int i = this.applications.size() - 1; i >= 0; --i) {
            DeployedApplicationImpl deployedApplicationImpl = (DeployedApplicationImpl)this.applications.get(i);
            if (deployedApplicationImpl.getState() != "STARTED") continue;
            try {
                this.stopApplication(deployedApplicationImpl);
                continue;
            }
            catch (RuntimeWarning runtimeWarning) {
                // empty catch block
            }
        }
        this.setState("STOPPED");
    }

    protected void stopApplication(DeployedApplicationImpl deployedApplicationImpl) throws RuntimeWarning {
        boolean bl = false;
        boolean bl2 = true;
        if ("STARTED".equals(this.getState())) {
            int n = this.deployedApplicationFilters.size();
            for (int i = 0; i < n && bl2; ++i) {
                DeployedApplicationFilter deployedApplicationFilter = (DeployedApplicationFilter)this.deployedApplicationFilters.get(i);
                if (deployedApplicationFilter.applicationMayStop(deployedApplicationImpl)) continue;
                bl2 = false;
                FFDCFilter.processException((Throwable)new Exception("could not stop application" + deployedApplicationImpl.getName() + " because of filter " + deployedApplicationFilter.toString()), (String)(class$com$ibm$ws$runtime$service$ApplicationMgr == null ? ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.ApplicationMgr") : class$com$ibm$ws$runtime$service$ApplicationMgr).getName(), (String)"385");
            }
        }
        if (bl2) {
            try {
                Tr.audit(tc, "WSVR0217I", deployedApplicationImpl.getName());
                deployedApplicationImpl.stop();
                Tr.audit(tc, "WSVR0220I", deployedApplicationImpl.getName());
            }
            catch (Throwable throwable) {
                Tr.error(tc, "WSVR0102E", new Object[]{deployedApplicationImpl.getName(), throwable});
            }
        } else {
            Tr.error(tc, "WSVR0102E", new Object[]{deployedApplicationImpl.getName()});
            throw new RuntimeWarning("could not stop application " + deployedApplicationImpl.getName() + " (filtered)");
        }
    }

    public void destroy() {
        this.setState("DESTROYING");
        for (int i = this.applications.size() - 1; i >= 0; --i) {
            DeployedApplicationImpl deployedApplicationImpl = (DeployedApplicationImpl)this.applications.get(i);
            this.destroyApplication(deployedApplicationImpl);
        }
        this.applications.clear();
        this.setState("DESTROYED");
    }

    protected void destroyApplication(DeployedApplicationImpl deployedApplicationImpl) {
        try {
            deployedApplicationImpl.destroy();
        }
        catch (Throwable throwable) {
            Tr.error(tc, "WSVR0102E", new Object[]{deployedApplicationImpl.getName(), throwable});
        }
        deployedApplicationImpl.removeDeployedObjectListener(this);
        deployedApplicationImpl.removeDeployedObjectHandler(this);
        this.remove(deployedApplicationImpl);
        this.applications.remove(deployedApplicationImpl);
    }

    public void addDeployedObjectListener(DeployedObjectListener deployedObjectListener) {
        this.deployedListeners.add(deployedObjectListener);
    }

    public void removeDeployedObjectListener(DeployedObjectListener deployedObjectListener) {
        this.deployedListeners.remove(deployedObjectListener);
    }

    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        RuntimeWarning runtimeWarning = null;
        for (int i = 0; i < this.deployedListeners.size(); ++i) {
            try {
                ((DeployedObjectListener)this.deployedListeners.get(i)).stateChanged(deployedObjectEvent);
                continue;
            }
            catch (RuntimeWarning runtimeWarning2) {
                runtimeWarning = runtimeWarning2;
            }
        }
        if (runtimeWarning != null) {
            throw runtimeWarning;
        }
    }

    public void addDeployedObjectHandler(DeployedObjectHandler deployedObjectHandler) {
        this.deployedHandlers.add(deployedObjectHandler);
    }

    public void removeDeployedObjectHandler(DeployedObjectHandler deployedObjectHandler) {
        this.deployedHandlers.remove(deployedObjectHandler);
    }

    public boolean start(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        RuntimeWarning runtimeWarning = null;
        boolean bl = false;
        for (int i = 0; i < this.deployedHandlers.size(); ++i) {
            try {
                bl |= ((DeployedObjectHandler)this.deployedHandlers.get(i)).start(deployedObjectEvent);
                continue;
            }
            catch (RuntimeWarning runtimeWarning2) {
                runtimeWarning = runtimeWarning2;
            }
        }
        if (runtimeWarning != null) {
            throw runtimeWarning;
        }
        return bl;
    }

    public void stop(DeployedObjectEvent deployedObjectEvent) {
        for (int i = 0; i < this.deployedHandlers.size(); ++i) {
            ((DeployedObjectHandler)this.deployedHandlers.get(i)).stop(deployedObjectEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startApplication(String string) throws ConfigurationWarning, ConfigurationError, RuntimeWarning, RuntimeError {
        Object object;
        Repository repository = (Repository)this.getService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository);
        ServerEntry serverEntry = this.getServerEntry(repository);
        Resource resource = serverEntry.eResource();
        resource.getResourceSet().getResources().remove((Object)resource);
        resource.unload();
        EList eList = serverEntry.getDeployedApplications();
        String string2 = null;
        int n = eList.size();
        for (int i = 0; string2 == null && i < n; ++i) {
            object = (String)eList.get(i);
            if (!((String)object).startsWith(string) || !((String)object).regionMatches(string.length(), EAR_EXTENSION, 0, EAR_EXTENSION.length()) || ((String)object).charAt(string.length() + EAR_EXTENSION.length()) != '/') continue;
            string2 = object;
        }
        if (string2 == null) {
            Tr.warning(tc, "WSVR0215W", string);
            throw new ConfigurationWarning("Application " + string + " not installed");
        }
        VariableMap variableMap = (VariableMap)this.getService(class$com$ibm$ws$runtime$service$VariableMap == null ? (class$com$ibm$ws$runtime$service$VariableMap = ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.VariableMap")) : class$com$ibm$ws$runtime$service$VariableMap);
        try {
            variableMap.refresh();
        }
        finally {
            this.releaseService(variableMap);
        }
        DeployedApplicationImpl deployedApplicationImpl = this.initializeApplication(repository, string, string2, false);
        if (deployedApplicationImpl != null) {
            object = (VirtualHostMgr)this.getService(class$com$ibm$ws$runtime$service$VirtualHostMgr == null ? (class$com$ibm$ws$runtime$service$VirtualHostMgr = ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.VirtualHostMgr")) : class$com$ibm$ws$runtime$service$VirtualHostMgr);
            object.reload();
            this.releaseService(object);
            ResourceMgr resourceMgr = (ResourceMgr)this.getService(class$com$ibm$ws$runtime$service$ResourceMgr == null ? (class$com$ibm$ws$runtime$service$ResourceMgr = ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.ResourceMgr")) : class$com$ibm$ws$runtime$service$ResourceMgr);
            LibraryMgr libraryMgr = (LibraryMgr)this.getService(class$com$ibm$ws$runtime$service$LibraryMgr == null ? (class$com$ibm$ws$runtime$service$LibraryMgr = ApplicationMgrImpl.class$("com.ibm.ws.runtime.service.LibraryMgr")) : class$com$ibm$ws$runtime$service$LibraryMgr);
            try {
                resourceMgr.reload();
                libraryMgr.refresh();
            }
            catch (RuntimeError runtimeError) {
            }
            catch (RuntimeWarning runtimeWarning) {
            }
            finally {
                this.releaseService(resourceMgr);
                this.releaseService(libraryMgr);
            }
            this.startApplication(deployedApplicationImpl);
        }
    }

    public synchronized void stopApplication(String string) throws RuntimeWarning {
        DeployedApplicationImpl deployedApplicationImpl = null;
        int n = this.applications.size();
        for (int i = 0; deployedApplicationImpl == null && i < n; ++i) {
            DeployedApplicationImpl deployedApplicationImpl2 = (DeployedApplicationImpl)this.applications.get(i);
            if (!deployedApplicationImpl2.getName().equals(string)) continue;
            deployedApplicationImpl = deployedApplicationImpl2;
        }
        if (deployedApplicationImpl == null) {
            Tr.warning(tc, "WSVR0216W", string);
            throw new RuntimeWarning("Application " + string + " not started");
        }
        this.stopApplication(deployedApplicationImpl);
        this.destroyApplication(deployedApplicationImpl);
    }

    protected void setState(String string) {
        try {
            super.setState(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)this.getClass().getName(), (String)"532");
        }
    }

    public void setExtraProcessing(boolean bl) {
        this.extraProcessing = bl;
    }

    public boolean getExtraProcessing() {
        return this.extraProcessing;
    }

    public void addDeployedApplicationFilter(DeployedApplicationFilter deployedApplicationFilter) {
        this.deployedApplicationFilters.add(deployedApplicationFilter);
    }

    public void removeDeployedApplicationFilter(DeployedApplicationFilter deployedApplicationFilter) {
        this.deployedApplicationFilters.remove(deployedApplicationFilter);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ApplicationNotifier
    implements ClassLoaderListener {
        DeployedApplicationImpl deployedApp;
        boolean isJ9vmEnabled;

        public ApplicationNotifier(DeployedApplicationImpl deployedApplicationImpl) {
            this.deployedApp = deployedApplicationImpl;
            this.isJ9vmEnabled = false;
            if (System.getProperties().containsKey("com.ibm.ws.classloader.j9enabled") && System.getProperty("com.ibm.ws.classloader.j9enabled").equalsIgnoreCase("true")) {
                this.isJ9vmEnabled = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void classChanged(ModuleRef moduleRef) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "classChanged");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "J9 support enabled?: " + this.isJ9vmEnabled);
            }
            if (!this.isJ9vmEnabled) {
                if (moduleRef != null && moduleRef.isWeb()) {
                    boolean bl = false;
                    WebContainerService webContainerService = (WebContainerService)ApplicationMgrImpl.this.getService(class$com$ibm$ws$webcontainer$WebContainerService == null ? (class$com$ibm$ws$webcontainer$WebContainerService = ApplicationMgrImpl.class$("com.ibm.ws.webcontainer.WebContainerService")) : class$com$ibm$ws$webcontainer$WebContainerService);
                    this.deployedApp.getClassLoaderManager().reloadClassLoader(moduleRef);
                    DeployedModuleImpl deployedModuleImpl = this.deployedApp.getDeployedModule(moduleRef);
                    try {
                        webContainerService.reload((DeployedObject)deployedModuleImpl);
                    }
                    catch (RuntimeWarning runtimeWarning) {
                        bl = true;
                    }
                    catch (RuntimeError runtimeError) {
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        bl = true;
                        Tr.error(tc, "WSVR206E", new Object[]{deployedModuleImpl.getName(), this.deployedApp.getName()});
                        FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"507");
                    }
                    finally {
                        ApplicationMgrImpl.this.releaseService(webContainerService);
                    }
                    if (bl) {
                        try {
                            ApplicationMgrImpl.this.stopApplication(this.deployedApp.getName());
                        }
                        catch (RuntimeWarning runtimeWarning) {}
                    }
                } else {
                    String string = this.deployedApp.getName();
                    try {
                        ApplicationMgrImpl.this.stopApplication(string);
                        ApplicationMgrImpl.this.startApplication(string);
                    }
                    catch (RuntimeWarning runtimeWarning) {
                    }
                    catch (ConfigurationWarning configurationWarning) {
                    }
                    catch (ConfigurationError configurationError) {
                    }
                    catch (RuntimeError runtimeError) {
                        // empty catch block
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "classChanged");
            }
        }
    }
}

