/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.classloader.Classloader;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.classloader.ClassLoaderUtils;
import com.ibm.ws.classloader.ExtJarClassLoader;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.naming.java.javaNameSpaceAccessor;
import com.ibm.ws.naming.java.javaURLContextFactoryBase;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.config.ContainerConfig;
import com.ibm.ws.runtime.service.LibraryMgr;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.threadContext.JavaNameSpaceAccessorImpl;
import com.ibm.ws.util.PathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.Policy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ApplicationServerImpl
extends ContainerImpl
implements com.ibm.ws.runtime.service.ApplicationServer {
    private int classloaderPolicy;
    private int classloadingMode;
    private ClassLoader applicationClassLoader;
    private Properties customProperties = null;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ApplicationServer;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$LibraryMgr;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Server;

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        ConfigurationWarning configurationWarning = null;
        ContainerConfig containerConfig = (ContainerConfig)object;
        ApplicationServer applicationServer = (ApplicationServer)containerConfig.getConfig();
        if (applicationServer.getStateManagement().getInitialState().getValue() == 1) {
            throw new ComponentDisabledException();
        }
        this.customProperties = new Properties();
        Iterator iterator = applicationServer.getProperties().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            this.customProperties.setProperty(property.getName(), property.getValue());
        }
        this.getOuterBCS().addService(class$com$ibm$ws$runtime$service$ApplicationServer == null ? (class$com$ibm$ws$runtime$service$ApplicationServer = ApplicationServerImpl.class$("com.ibm.ws.runtime.service.ApplicationServer")) : class$com$ibm$ws$runtime$service$ApplicationServer, this);
        this.classloaderPolicy = applicationServer.getApplicationClassLoaderPolicy().getValue();
        this.classloadingMode = applicationServer.getApplicationClassLoadingMode().getValue();
        try {
            this.setInitializationState("INITIALIZING");
        }
        catch (ConfigurationWarning configurationWarning2) {
            configurationWarning = configurationWarning2;
        }
        this.components = this.loadComponents("META-INF/ws-applicationserver-startup.xml");
        try {
            this.initializeComponents((EObject)applicationServer, containerConfig.getLocators());
        }
        catch (ConfigurationWarning configurationWarning3) {
            configurationWarning = configurationWarning3;
        }
        this.initializeClassLoader(applicationServer);
        try {
            this.setInitializationState("INITIALIZED");
        }
        catch (ConfigurationWarning configurationWarning4) {
            configurationWarning = configurationWarning4;
        }
        if (configurationWarning != null) {
            throw configurationWarning;
        }
    }

    public void destroy() {
        try {
            this.setState("DESTROYING");
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.destroy();
        try {
            this.setState("DESTROYED");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        RuntimeWarning runtimeWarning = null;
        try {
            this.setStartState("STARTING");
        }
        catch (RuntimeWarning runtimeWarning2) {
            runtimeWarning = runtimeWarning2;
        }
        this.initializeNameSpaces();
        try {
            super.start();
        }
        catch (RuntimeWarning runtimeWarning3) {
            runtimeWarning = runtimeWarning3;
        }
        try {
            this.setStartState("STARTED");
        }
        catch (RuntimeWarning runtimeWarning4) {
            runtimeWarning = runtimeWarning4;
        }
        if (runtimeWarning != null) {
            throw runtimeWarning;
        }
    }

    public void stop() {
        try {
            this.setState("STOPPING");
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stop();
        try {
            this.setState("STOPPED");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ClassLoader getClassLoader() {
        return this.applicationClassLoader;
    }

    protected void initializeNameSpaces() throws RuntimeError {
        try {
            javaURLContextFactoryBase.setAccessor((javaNameSpaceAccessor)JavaNameSpaceAccessorImpl.getJavaNameSpaceAccessor());
        }
        catch (NamingException namingException) {
            throw new RuntimeError("Error initializing java:comp setup");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.ibm.websphere.naming.genericURLInitialContextFactory");
        hashtable.put("com.ibm.websphere.naming.generic.url.schemeid", "local");
        hashtable.put("com.ibm.websphere.naming.generic.url.package", "com.ibm.ws.runtime");
        try {
            new InitialContext(hashtable);
        }
        catch (NamingException namingException) {
            throw new RuntimeError("Error creating local: namespace", namingException);
        }
        hashtable.put("com.ibm.websphere.naming.generic.url.schemeid", "services");
        try {
            new InitialContext(hashtable);
        }
        catch (NamingException namingException) {
            throw new RuntimeError("Error creating services: namespace", namingException);
        }
    }

    protected void initializeClassLoader(ApplicationServer applicationServer) throws ConfigurationError {
        this.applicationClassLoader = this.buildApplicationClassLoader();
        ComponentImpl componentImpl = (ComponentImpl)this.components.get(0);
        LibraryMgr libraryMgr = (LibraryMgr)componentImpl.getService(class$com$ibm$ws$runtime$service$LibraryMgr == null ? (class$com$ibm$ws$runtime$service$LibraryMgr = ApplicationServerImpl.class$("com.ibm.ws.runtime.service.LibraryMgr")) : class$com$ibm$ws$runtime$service$LibraryMgr);
        EList eList = applicationServer.getClassloaders();
        if (eList != null) {
            Policy policy = Policy.getPolicy();
            DynamicPolicy dynamicPolicy = null;
            if (policy instanceof DynamicPolicy) {
                dynamicPolicy = (DynamicPolicy)Policy.getPolicy();
            }
            ExtJarClassLoader extJarClassLoader = null;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Classloader classloader = (Classloader)iterator.next();
                String[] stringArray = libraryMgr.getClassPaths(classloader);
                String[] stringArray2 = libraryMgr.getNativeLibPaths(classloader);
                if (stringArray.length == 0) continue;
                boolean bl = true;
                if (classloader.getMode().getValue() == 1) {
                    bl = false;
                }
                stringArray = PathUtils.expandPaths(stringArray);
                stringArray = ClassLoaderUtils.addDependentJars((String[])stringArray);
                HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
                if (dynamicPolicy != null) {
                    hashMap.put("type", "library");
                    hashMap.put("classpath", stringArray);
                }
                HashMap hashMap2 = new HashMap();
                dynamicPolicy.getSecurityPolicy(hashMap, hashMap2);
                if (extJarClassLoader == null || extJarClassLoader.getDelegationMode() != bl) {
                    extJarClassLoader = new ExtJarClassLoader(stringArray, this.applicationClassLoader, null, bl);
                    extJarClassLoader.setCodeSourcePermissions(hashMap2);
                    this.applicationClassLoader = extJarClassLoader;
                } else {
                    extJarClassLoader.addPaths(stringArray);
                }
                if (stringArray2.length == 0) continue;
                extJarClassLoader.addNativeLibPaths(stringArray2);
            }
        }
        componentImpl.releaseService(libraryMgr);
    }

    protected ClassLoader buildApplicationClassLoader() throws ConfigurationError {
        ExtJarClassLoader extJarClassLoader;
        Server server = (Server)this.getService(class$com$ibm$ws$runtime$service$Server == null ? (class$com$ibm$ws$runtime$service$Server = ApplicationServerImpl.class$("com.ibm.ws.runtime.service.Server")) : class$com$ibm$ws$runtime$service$Server);
        ClassLoader classLoader = server.getPublicClassLoader();
        this.releaseService(server);
        String string = this.expandVariable("${USER_INSTALL_ROOT}");
        if (string == null || string.length() == 0) {
            throw new ConfigurationError("Missing variable: USER_INSTALL_ROOT");
        }
        string = string + File.separator + "lib" + File.separator + "app";
        String[] stringArray = new String[]{};
        try {
            extJarClassLoader = new ArrayList();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string + File.separator + "protected.prefixes"));
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    extJarClassLoader.add(string2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            stringArray = new String[extJarClassLoader.size()];
            extJarClassLoader.toArray(stringArray);
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        extJarClassLoader = new ExtJarClassLoader(string, classLoader, stringArray, false);
        return extJarClassLoader;
    }

    public int getClassLoaderPolicy() {
        return this.classloaderPolicy;
    }

    public int getClassLoadingMode() {
        return this.classloadingMode;
    }

    public String getCustomProperty(String string) {
        return this.customProperties.getProperty(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

