/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.etools.application.Module;
import com.ibm.etools.archive.ArchiveManifest;
import com.ibm.etools.archive.exception.ArchiveWrappedException;
import com.ibm.etools.archive.exception.ReopenException;
import com.ibm.etools.commonarchive.Archive;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.models.config.appcfg.ModuleConfig;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.component.DeployedApplicationImpl;
import com.ibm.ws.runtime.deploy.DeployedApplication;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.ApplicationServer;
import com.ibm.ws.runtime.service.MetaDataFactoryMgr;
import java.beans.PropertyVetoException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class DeployedModuleImpl
extends ComponentImpl
implements DeployedModule,
Comparable {
    protected DeployedApplicationImpl application;
    protected ModuleRef moduleRef;
    protected DeploymentTargetMapping serverMap;
    protected DeploymentTargetMapping clusterMap;
    protected ModuleMetaData metadata;
    protected int weight;
    private String id;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ApplicationServer;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$MetaDataFactoryMgr;

    public DeployedModuleImpl(DeployedApplicationImpl deployedApplicationImpl, DeploymentTargetMapping deploymentTargetMapping, DeploymentTargetMapping deploymentTargetMapping2) {
        this.application = deployedApplicationImpl;
        this.serverMap = deploymentTargetMapping;
        this.clusterMap = deploymentTargetMapping2;
        ModuleDeployment moduleDeployment = this.getModuleDeployment();
        String string = moduleDeployment.getAltDD();
        if (string == null || string.length() == 0) {
            string = moduleDeployment.getUri();
        }
        this.setName(string);
    }

    public String getId() {
        return this.id;
    }

    protected DeployedObjectEvent createDeployedObjectEvent(String string) {
        ApplicationServer applicationServer = (ApplicationServer)this.getService(class$com$ibm$ws$runtime$service$ApplicationServer == null ? (class$com$ibm$ws$runtime$service$ApplicationServer = DeployedModuleImpl.class$("com.ibm.ws.runtime.service.ApplicationServer")) : class$com$ibm$ws$runtime$service$ApplicationServer);
        String string2 = applicationServer.getState();
        this.releaseService(applicationServer);
        DeployedObjectEvent deployedObjectEvent = new DeployedObjectEvent(this, "state", this.state, string, string2);
        return deployedObjectEvent;
    }

    protected void setState(String string) throws RuntimeError, RuntimeWarning {
        DeployedObjectEvent deployedObjectEvent = this.createDeployedObjectEvent(string);
        this.setState(deployedObjectEvent);
    }

    protected void setState(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        this.application.fireDeployedObjectEvent(deployedObjectEvent);
        try {
            super.setState(deployedObjectEvent.getNewValue().toString());
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new RuntimeError(propertyVetoException);
        }
        catch (WsException wsException) {
            throw new RuntimeError(wsException);
        }
    }

    public DeployedApplication getDeployedApplication() {
        return this.application;
    }

    public boolean isOpen() {
        if (this.moduleRef != null) {
            return this.moduleRef.getModuleFile().isOpen();
        }
        return false;
    }

    protected ModuleFile open() throws Throwable {
        try {
            this.moduleRef.getDeploymentDescriptor();
            this.moduleRef.getBindings();
            this.moduleRef.getExtensions();
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
        return this.moduleRef.getModuleFile();
    }

    public ModuleFile reopen() throws ReopenException {
        ModuleFile moduleFile = this.moduleRef.getModuleFile();
        moduleFile.setManifest((ArchiveManifest)null);
        moduleFile.reopen((Archive)this.application.getEARFile());
        return moduleFile;
    }

    public void close() {
        Resource[] resourceArray;
        Resource resource;
        Resource resource2;
        if (!this.isOpen()) {
            return;
        }
        ModuleFile moduleFile = this.moduleRef.getModuleFile();
        try {
            resource2 = this.getDeploymentDescriptor().eResource();
            resource = this.getBinding().eResource();
            resourceArray = this.getExtension().eResource();
            EClass eClass = moduleFile.eClass();
            moduleFile.eSet(eClass.getEStructuralFeature("bindings"), null);
            moduleFile.eSet(eClass.getEStructuralFeature("extensions"), null);
            moduleFile.eSet(eClass.getEStructuralFeature("deploymentDescriptor"), null);
            EList eList = resource2.getResourceSet().getResources();
            eList.remove(resource);
            eList.remove(resourceArray);
            eList.remove(resource2);
            resource.unload();
            resourceArray.unload();
            resource2.unload();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        resource2 = moduleFile.getResourceSet();
        resource = resource2.getResources();
        resourceArray = resource.toArray(new Resource[resource.size()]);
        resource.clear();
        for (int i = 0; i < resourceArray.length; ++i) {
            resourceArray[i].unload();
        }
        moduleFile.close();
    }

    public ModuleFile getModuleFile() {
        return this.moduleRef.getModuleFile();
    }

    public ModuleRef getModuleRef() {
        return this.moduleRef;
    }

    public ClassLoader getClassLoader() {
        return this.application.getClassLoader(this.moduleRef);
    }

    public EObject getDeploymentDescriptor() {
        try {
            return this.moduleRef.getDeploymentDescriptor();
        }
        catch (ArchiveWrappedException archiveWrappedException) {
            return null;
        }
    }

    public EObject getBinding() {
        try {
            return this.moduleRef.getBindings();
        }
        catch (ArchiveWrappedException archiveWrappedException) {
            return null;
        }
    }

    public EObject getExtension() {
        try {
            return this.moduleRef.getExtensions();
        }
        catch (ArchiveWrappedException archiveWrappedException) {
            return null;
        }
    }

    public ModuleDeployment getModuleDeployment() {
        DeploymentTargetMapping deploymentTargetMapping = this.clusterMap != null ? this.clusterMap : this.serverMap;
        return (ModuleDeployment)deploymentTargetMapping.eContainer();
    }

    public ModuleConfig getServerConfiguration() {
        if (this.serverMap != null) {
            return (ModuleConfig)this.serverMap.getConfig();
        }
        return null;
    }

    public ModuleConfig getClusterConfiguration() {
        if (this.clusterMap != null) {
            return (ModuleConfig)this.clusterMap.getConfig();
        }
        return null;
    }

    public boolean isEnable() {
        DeploymentTargetMapping deploymentTargetMapping = this.serverMap;
        if (this.clusterMap != null) {
            deploymentTargetMapping = this.clusterMap;
        }
        return deploymentTargetMapping.isEnable();
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        Module module = (Module)object;
        ModuleDeployment moduleDeployment = this.getModuleDeployment();
        this.id = this.getConfigId((EObject)moduleDeployment);
        this.moduleRef = this.application.getEARFile().getModuleRef(module);
        this.weight = moduleDeployment.getStartingWeight();
        try {
            this.setState("INITIALIZING");
        }
        catch (WsException wsException) {
            // empty catch block
        }
        try {
            this.open();
        }
        catch (Throwable throwable) {
            this.close();
            throw new ConfigurationWarning("Open failure", throwable);
        }
        try {
            this.setState("INITIALIZED");
        }
        catch (WsException wsException) {
            // empty catch block
        }
    }

    public void destroy() {
        try {
            this.setState("DESTROYING");
        }
        catch (WsException wsException) {
            // empty catch block
        }
        try {
            this.setState("DESTROYED");
        }
        catch (WsException wsException) {
            // empty catch block
        }
        this.application.removeClassLoader(this.moduleRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws RuntimeError, RuntimeWarning {
        try {
            if (!this.isOpen()) {
                try {
                    this.reopen();
                }
                catch (ReopenException reopenException) {
                    throw new RuntimeWarning("Reopen failed", reopenException);
                }
            }
            MetaDataFactoryMgr metaDataFactoryMgr = null;
            try {
                Object object;
                if (this.moduleRef.isWeb()) {
                    object = (WebModuleDeployment)this.getModuleDeployment();
                    this.application.getClassLoaderManager().setDelegationMode(this.moduleRef, object.getClassloaderMode().getValue() == 0);
                }
                metaDataFactoryMgr = (MetaDataFactoryMgr)this.getService(class$com$ibm$ws$runtime$service$MetaDataFactoryMgr == null ? (class$com$ibm$ws$runtime$service$MetaDataFactoryMgr = DeployedModuleImpl.class$("com.ibm.ws.runtime.service.MetaDataFactoryMgr")) : class$com$ibm$ws$runtime$service$MetaDataFactoryMgr);
                metaDataFactoryMgr.createMetaData(this);
                object = this.createDeployedObjectEvent("STARTING");
                this.setState((DeployedObjectEvent)object);
                this.application.fireDeployedObjectStart((DeployedObjectEvent)object);
                this.setState("STARTED");
            }
            catch (RuntimeError runtimeError) {
                try {
                    throw runtimeError;
                    catch (RuntimeWarning runtimeWarning) {
                        throw runtimeWarning;
                    }
                }
                catch (Throwable throwable) {
                    this.releaseService(metaDataFactoryMgr);
                    throw throwable;
                }
            }
            this.releaseService(metaDataFactoryMgr);
            return;
        }
        finally {
            this.close();
        }
    }

    public void stop() {
        String string = this.state;
        DeployedObjectEvent deployedObjectEvent = this.createDeployedObjectEvent("STOPPING");
        try {
            this.setState(deployedObjectEvent);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"358");
        }
        if (string == "STARTED") {
            try {
                this.application.fireDeployedObjectStop(deployedObjectEvent);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"366");
            }
        }
        try {
            this.setState("STOPPED");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"373");
        }
        MetaDataFactoryMgr metaDataFactoryMgr = (MetaDataFactoryMgr)this.getService(class$com$ibm$ws$runtime$service$MetaDataFactoryMgr == null ? (class$com$ibm$ws$runtime$service$MetaDataFactoryMgr = DeployedModuleImpl.class$("com.ibm.ws.runtime.service.MetaDataFactoryMgr")) : class$com$ibm$ws$runtime$service$MetaDataFactoryMgr);
        metaDataFactoryMgr.destroyMetaData(this);
        this.releaseService(metaDataFactoryMgr);
    }

    public MetaData getMetaData() {
        return this.metadata;
    }

    public void setMetaData(MetaData metaData) {
        this.metadata = (ModuleMetaData)metaData;
    }

    public int compareTo(Object object) {
        if (object instanceof DeployedModuleImpl) {
            return this.weight - ((DeployedModuleImpl)object).weight;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

