/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.product.VersionInfo;
import com.ibm.websphere.product.WASProduct;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.component.ServerImpl;
import com.ibm.ws.runtime.service.WLC;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ServerCollaborator
extends RuntimeCollaborator
implements PropertyChangeListener {
    private static final TraceComponent tc = Tr.register(class$com$ibm$ws$runtime$component$ServerCollaborator == null ? (class$com$ibm$ws$runtime$component$ServerCollaborator = ServerCollaborator.class$("com.ibm.ws.runtime.component.ServerCollaborator")) : class$com$ibm$ws$runtime$component$ServerCollaborator, "Runtime", "com.ibm.ws.runtime.runtime");
    static final String[] RESOURCE_TYPES = new String[]{"J2CResourceAdapter", "JDBCProvider", "JMSProvider", "MailProvider", "URLProvider"};
    private ServerImpl server;
    private long ntfySeqNum = 0L;
    private int lastStatus = 1;
    private Integer statusPort = null;
    private ShutdownHook shutdownHook;
    private WASProduct wasproduct = new WASProduct();
    static /* synthetic */ Class class$com$ibm$ws$runtime$component$ServerCollaborator;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$WLC;

    public ServerCollaborator(ServerImpl serverImpl) {
        this.server = serverImpl;
        serverImpl.addPropertyChangeListener("state", this);
        this.statusPort = Integer.getInteger("was.status.socket");
        this.shutdownHook = new ShutdownHook();
    }

    public void setThreadMonitorInterval(int n) {
        this.server.setThreadMonitorInterval(n);
    }

    public void setThreadMonitorThreshold(int n) {
        this.server.setThreadMonitorThreshold(n);
    }

    public void setThreadMonitorAdjustmentThreshold(int n) {
        this.server.setThreadMonitorAdjustmentThreshold(n);
    }

    public int getThreadMonitorInterval() {
        return this.server.getThreadMonitorInterval();
    }

    public int getThreadMonitorThreshold() {
        return this.server.getThreadMonitorThreshold();
    }

    public int getThreadMonitorAdjustmentThreshold() {
        return this.server.getThreadMonitorAdjustmentThreshold();
    }

    public String getName() {
        return this.getObjectName().getKeyProperty("name");
    }

    public void stop() {
        AdminHelper.getInstance().audit("ADMN1020I", "ADMN1021I", new Object[]{this.getName(), null});
        this.stop(false);
    }

    public void stopImmediate() {
        AdminHelper.getInstance().audit("ADMN1022I", "ADMN1023I", new Object[]{this.getName(), null});
        this.stop(true);
    }

    public void stop(Boolean bl, Integer n) {
        this.statusPort = n;
        this.stop();
    }

    protected void stop(boolean bl) {
        AlarmManager.create(50L, new StopAction(bl));
    }

    private void sendStatus(int n) {
        this.sendStatus(this.statusPort, n);
    }

    public String getPid() {
        String string = null;
        Process process = null;
        try {
            process = ProcessFactory.createSelf();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (process != null) {
            try {
                string = process.id();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public String getCellName() {
        String string = this.getObjectName().getKeyProperty("cell");
        return string;
    }

    public String getNodeName() {
        String string = this.getObjectName().getKeyProperty("node");
        return string;
    }

    public String getProcessType() {
        String string = AdminServiceFactory.getAdminService().getProcessType();
        return string;
    }

    public String[] getDeployedObjects() {
        Set set = this.lookupMBeans("WebSphere:type=Application,*");
        ArrayList<String> arrayList = new ArrayList<String>();
        MBeanServer mBeanServer = AdminServiceFactory.getMBeanFactory().getMBeanServer();
        String[] stringArray = set.iterator();
        while (stringArray.hasNext()) {
            try {
                ObjectName objectName = (ObjectName)stringArray.next();
                arrayList.add(objectName.getCanonicalName());
                String[] stringArray2 = (String[])mBeanServer.getAttribute(objectName, "modules");
                if (stringArray2 == null) continue;
                for (int i = 0; i < stringArray2.length; ++i) {
                    arrayList.add(stringArray2[i]);
                }
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (MBeanException mBeanException) {
            }
            catch (ReflectionException reflectionException) {
            }
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getJavaVMs() {
        Set set = this.lookupMBeans("WebSphere:type=JVM,*");
        String[] stringArray = new String[set.size()];
        Iterator iterator = set.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = iterator.next().toString();
        }
        return stringArray;
    }

    public String[] getResources() {
        StringBuffer stringBuffer = new StringBuffer("WebSphere:*,type=");
        int n = stringBuffer.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < RESOURCE_TYPES.length; ++i) {
            stringBuffer.setLength(n);
            stringBuffer.append(RESOURCE_TYPES[i]);
            Set set = this.lookupMBeans(stringBuffer.toString());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().toString());
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String getServerVersion() {
        VersionInfo versionInfo = new VersionInfo();
        StringWriter stringWriter = new StringWriter(2048);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        versionInfo.runReport("text", printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public String getServerVendor() {
        return "IBM";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getNewValue();
        String string2 = null;
        if (string.equals("STARTING")) {
            string2 = "j2ee.state.starting";
        } else if (string.equals("STARTED")) {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            string2 = "j2ee.state.running";
            this.lastStatus = 0;
            this.sendStatus(this.lastStatus);
            this.statusPort = null;
        } else if (string.equals("STOPPING")) {
            string2 = "j2ee.state.stopping";
        } else if (string.equals("STOPPED")) {
            string2 = "j2ee.state.stopped";
        } else if (string.equals("DESTROYED")) {
            this.lastStatus = this.lastStatus == 0 ? 0 : -1;
            this.sendStatus(this.lastStatus);
        }
        if (string2 != null) {
            this.sendStateNotification(string2);
        }
    }

    private void sendStateNotification(String string) {
        try {
            this.sendNotification(new Notification(string, this.getObjectName(), this.ntfySeqNum++));
        }
        catch (MBeanException mBeanException) {
            // empty catch block
        }
    }

    public String getState() {
        return this.server.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStatus(Integer n, int n2) {
        FilterOutputStream filterOutputStream = null;
        Socket socket = null;
        if (n != null) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                socket = new Socket(inetAddress, (int)n);
                filterOutputStream = new DataOutputStream(socket.getOutputStream());
                ((DataOutputStream)filterOutputStream).writeInt(n2);
                ((DataOutputStream)filterOutputStream).flush();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Tr.service(tc, "WSVR0120E", new Object[]{this.server.getName(), throwable});
            }
            finally {
                try {
                    filterOutputStream.close();
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected Set lookupMBeans(String string) {
        try {
            ObjectName objectName = new ObjectName(string);
            return this.lookupMBeans(objectName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Tr.service(tc, "WSVR0402W", new Object[]{string, malformedObjectNameException});
            return null;
        }
    }

    protected Set lookupMBeans(ObjectName objectName) {
        return AdminServiceFactory.getMBeanFactory().getMBeanServer().queryNames(objectName, null);
    }

    public String getPlatformName() {
        return this.wasproduct.getPlatform().getName();
    }

    public String getPlatformVersion() {
        return this.wasproduct.getPlatform().getVersion();
    }

    public String getProductVersion(String string) {
        return this.wasproduct.loadVersionInfoAsXMLString(string + ".product");
    }

    public String getComponentVersion(String string) {
        return this.wasproduct.loadVersionInfoAsXMLString(string + ".component");
    }

    public String getEFixVersion(String string) {
        return this.wasproduct.loadVersionInfoAsXMLString(string + ".efix");
    }

    public String getPTFVersion(String string) {
        return this.wasproduct.loadVersionInfoAsXMLString(string + ".ptf");
    }

    public String getExtensionVersion(String string) {
        return this.wasproduct.loadVersionInfoAsXMLString(string + ".extension");
    }

    public String[] getVersionsForAllProducts() {
        return this.wasproduct.loadAllVersionInfoByType("product");
    }

    public String[] getVersionsForAllComponents() {
        return this.wasproduct.loadAllVersionInfoByType("component");
    }

    public String[] getVersionsForAllEFixes() {
        return this.wasproduct.loadAllVersionInfoByType("efix");
    }

    public String[] getVersionsForAllPTFs() {
        return this.wasproduct.loadAllVersionInfoByType("ptf");
    }

    public String[] getVersionsForAllExtensions() {
        return this.wasproduct.loadAllVersionInfoByType("extension");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        public void run() {
            this.run(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(final boolean bl) {
            ShutdownHook shutdownHook = this;
            synchronized (shutdownHook) {
                ShutdownHook shutdownHook2 = ServerCollaborator.this.shutdownHook;
                ServerCollaborator.this.shutdownHook = null;
                if (shutdownHook2 == null) {
                    return;
                }
            }
            try {
                ContextManagerFactory.getInstance().runAsSystem(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public Object run() throws Exception {
                        if (bl) {
                            ComponentImpl componentImpl = new ComponentImpl();
                            ServerCollaborator.this.server.add(componentImpl);
                            WLC wLC = (WLC)componentImpl.getService(class$com$ibm$ws$runtime$service$WLC == null ? (class$com$ibm$ws$runtime$service$WLC = ServerCollaborator.class$("com.ibm.ws.runtime.service.WLC")) : class$com$ibm$ws$runtime$service$WLC);
                            if (wLC != null) {
                                wLC.stopImmediate();
                                componentImpl.releaseService(wLC);
                            }
                        }
                        try {
                            try {
                                ServerCollaborator.this.server.stop();
                                ServerCollaborator.this.server.destroy();
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                Object var4_5 = null;
                                Tr.audit(tc, "WSVR0024I", ServerCollaborator.this.server.getName());
                                return null;
                            }
                            Object var4_4 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            Tr.audit(tc, "WSVR0024I", ServerCollaborator.this.server.getName());
                            throw throwable;
                        }
                        Tr.audit(tc, "WSVR0024I", ServerCollaborator.this.server.getName());
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.getException().printStackTrace();
            }
        }
    }

    class StopAction
    implements AlarmListener {
        boolean immediate;

        StopAction(boolean bl) {
            this.immediate = bl;
        }

        public void alarm(Object object) {
            if (ServerCollaborator.this.shutdownHook != null) {
                ServerCollaborator.this.shutdownHook.run(this.immediate);
                System.exit(0);
            }
        }
    }
}

