/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.component.ServerCollaborator;
import com.ibm.ws.runtime.component.ServerImpl;
import com.ibm.ws.runtime.service.ApplicationServer;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadMonitor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.management.MBeanException;
import javax.management.Notification;

public class ThreadMonitorImpl
extends ComponentImpl
implements ThreadMonitor,
ThreadMonitor.Listener,
PropertyChangeListener {
    private static TraceComponent tc = Tr.register(class$com$ibm$ws$runtime$component$ThreadMonitorImpl == null ? (class$com$ibm$ws$runtime$component$ThreadMonitorImpl = ThreadMonitorImpl.class$("com.ibm.ws.runtime.component.ThreadMonitorImpl")) : class$com$ibm$ws$runtime$component$ThreadMonitorImpl, "Runtime", "com.ibm.ws.runtime.runtime");
    private static final String INTERVAL_CUSTOM_PROPERTY_NAME = "com.ibm.websphere.threadmonitor.interval";
    private static final String THRESHOLD_CUSTOM_PROPERTY_NAME = "com.ibm.websphere.threadmonitor.threshold";
    private static final String ADJUSTMENT_THRESHOLD_CUSTOM_PROPERTY_NAME = "com.ibm.websphere.threadmonitor.false.alarm.threshold";
    private Map groupPolicyMap = Collections.synchronizedMap(new HashMap());
    private ThreadMonitor.DetectionPolicy defaultPolicy = null;
    private ServerCollaborator jmxCollaborator = null;
    private long threshold = 600000L;
    private long interval = 180000L;
    private int numberOfHungThreads = 0;
    private int numberOfClearedThreads = 0;
    private int adjustmentThreshold = 100;
    private Vector listeners = new Vector();
    private Set hungThreads = Collections.synchronizedSet(new HashSet());
    private AlarmBasedNotification notifier = null;
    static /* synthetic */ Class class$com$ibm$ws$runtime$component$ThreadMonitorImpl;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ThreadMonitor;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Server;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ApplicationServer;

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        try {
            this.defaultPolicy = new SimplePolicy(this.getThreshold());
            this.listeners.add(new RasListener());
            this.addService(class$com$ibm$ws$runtime$service$ThreadMonitor == null ? (class$com$ibm$ws$runtime$service$ThreadMonitor = ThreadMonitorImpl.class$("com.ibm.ws.runtime.service.ThreadMonitor")) : class$com$ibm$ws$runtime$service$ThreadMonitor);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        try {
            boolean bl = tc.isDebugEnabled();
            if (bl) {
                Tr.debug(tc, "starting ThreadMonitor");
            }
            Server server = (Server)this.getService(class$com$ibm$ws$runtime$service$Server == null ? (class$com$ibm$ws$runtime$service$Server = ThreadMonitorImpl.class$("com.ibm.ws.runtime.service.Server")) : class$com$ibm$ws$runtime$service$Server);
            server.addPropertyChangeListener("threadMonitorInterval", this);
            server.addPropertyChangeListener("threadMonitorThreshold", this);
            server.addPropertyChangeListener("threadMonitorAdjustmentThreshold", this);
            this.jmxCollaborator = ((ServerImpl)server).getCollaborator();
            this.releaseService(server);
            ApplicationServer applicationServer = (ApplicationServer)this.getService(class$com$ibm$ws$runtime$service$ApplicationServer == null ? (class$com$ibm$ws$runtime$service$ApplicationServer = ThreadMonitorImpl.class$("com.ibm.ws.runtime.service.ApplicationServer")) : class$com$ibm$ws$runtime$service$ApplicationServer);
            if (applicationServer != null) {
                String string;
                String string2;
                String string3 = applicationServer.getCustomProperty(INTERVAL_CUSTOM_PROPERTY_NAME);
                if (string3 != null) {
                    this.jmxCollaborator.setThreadMonitorInterval(Integer.parseInt(string3));
                    if (bl) {
                        Tr.debug(tc, "configured interval : " + string3 + " seconds");
                    }
                }
                if ((string2 = applicationServer.getCustomProperty(THRESHOLD_CUSTOM_PROPERTY_NAME)) != null) {
                    this.jmxCollaborator.setThreadMonitorThreshold(Integer.parseInt(string2));
                    ((SimplePolicy)this.defaultPolicy).setThreshold(this.threshold);
                    if (bl) {
                        Tr.debug(tc, "configured threshold : " + string2 + " seconds");
                    }
                }
                if ((string = applicationServer.getCustomProperty(ADJUSTMENT_THRESHOLD_CUSTOM_PROPERTY_NAME)) != null) {
                    this.adjustmentThreshold = Integer.parseInt(string);
                    if (bl) {
                        Tr.debug(tc, "configured adjustment threshold : " + string);
                    }
                }
            }
            if (this.isEnabled()) {
                this.notifier = new AlarmBasedNotification();
            }
            this.listeners.add(new JmxListener());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isEnabled() {
        return this.interval > 0L;
    }

    public void checkAllThreads() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAllThreads");
        }
        boolean bl = tc.isDebugEnabled();
        try {
            Iterator iterator = this.groupPolicyMap.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    ThreadMonitor.ThreadGroup threadGroup = (ThreadMonitor.ThreadGroup)iterator.next();
                    ThreadMonitor.DetectionPolicy detectionPolicy = (ThreadMonitor.DetectionPolicy)this.groupPolicyMap.get(threadGroup);
                    if (detectionPolicy == null) {
                        detectionPolicy = this.defaultPolicy;
                    }
                    threadGroup.checkAllThreads(detectionPolicy);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"232");
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            FFDCFilter.processException((Throwable)concurrentModificationException, (String)this.getClass().getName(), (String)"235");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAllThreads");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("threadMonitorInterval".equals(propertyChangeEvent.getPropertyName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "interval changed " + propertyChangeEvent.getNewValue());
            }
            long l = this.interval;
            this.interval = (long)((Integer)propertyChangeEvent.getNewValue()).intValue() * 1000L;
            if (this.notifier != null) {
                this.notifier.cancel();
                if (this.interval >= 0L) {
                    this.notifier.scheduleNext();
                }
            }
            boolean bl = false;
            bl |= l <= 0L && this.interval > 0L;
            if (bl |= l > 0L && this.interval <= 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "monitor has changed state  enabled=" + this.isEnabled());
                }
                Iterator iterator = this.groupPolicyMap.keySet().iterator();
                while (iterator.hasNext()) {
                    ThreadMonitor.ThreadGroup threadGroup = (ThreadMonitor.ThreadGroup)iterator.next();
                    threadGroup.monitorStateChanged(this.isEnabled());
                }
            }
        } else if ("threadMonitorThreshold".equals(propertyChangeEvent.getPropertyName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threshold changed " + propertyChangeEvent.getNewValue());
            }
            this.threshold = (long)((Integer)propertyChangeEvent.getNewValue()).intValue() * 1000L;
            ((SimplePolicy)this.defaultPolicy).setThreshold(this.threshold);
        } else if ("threadMonitorAdjustmentThreshold".equals(propertyChangeEvent.getPropertyName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adjustment threshold changed " + propertyChangeEvent.getNewValue());
            }
            this.adjustmentThreshold = (Integer)propertyChangeEvent.getNewValue();
            this.numberOfClearedThreads = 0;
        }
    }

    public long getThreshold() {
        return this.threshold;
    }

    public synchronized long getInterval() {
        return this.interval;
    }

    public void addThreadMonitorListener(ThreadMonitor.Listener listener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addThreadMonitorListener", listener);
        }
        this.listeners.add(listener);
    }

    public void removeThreadMonitorListener(ThreadMonitor.Listener listener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeThreadMonitorListener", listener);
        }
        this.listeners.remove(listener);
    }

    public void setDetectionPolicy(ThreadMonitor.DetectionPolicy detectionPolicy, ThreadMonitor.ThreadGroup threadGroup) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void threadIsClear(String string, int n, long l) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "threadIsClear", new Object[]{string, new Long(l)});
        }
        this.hungThreads.remove(string);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ThreadMonitor.Listener listener = (ThreadMonitor.Listener)iterator.next();
                listener.threadIsClear(string, n, l);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"439");
            }
        }
        this.incrementNumberOfClearedThreads();
        if (this.adjustmentThreshold > 0 && this.getNumberOfClearedThreads() % this.adjustmentThreshold == 0) {
            long l2 = this.threshold + this.threshold / 2L;
            this.jmxCollaborator.setThreadMonitorThreshold((int)(l2 / 1000L));
            Tr.warning(tc, "WSVR0607W", new Long(l2 / 1000L));
        }
    }

    public void threadIsHung(String string, int n, long l) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "threadIsHung", new Object[]{string, Integer.toHexString(n), new Long(l)});
        }
        if (!this.hungThreads.contains(string)) {
            this.hungThreads.add(string);
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ThreadMonitor.Listener listener = (ThreadMonitor.Listener)iterator.next();
                    listener.threadIsHung(string, n, l);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"487");
                }
            }
        }
    }

    public void addThreadGroup(ThreadMonitor.ThreadGroup threadGroup) throws ComponentDisabledException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addThreadGroup", threadGroup);
        }
        if (!this.isEnabled()) {
            throw new ComponentDisabledException("The thread monitor is disabled.");
        }
        try {
            threadGroup.setThreadMonitorListener(this);
            this.groupPolicyMap.put(threadGroup, null);
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    public void removeThreadGroup(ThreadMonitor.ThreadGroup threadGroup) throws ComponentDisabledException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeThreadGroup", threadGroup);
        }
        if (!this.isEnabled()) {
            throw new ComponentDisabledException("The thread monitor is disabled.");
        }
        try {
            threadGroup.setThreadMonitorListener(null);
            this.groupPolicyMap.remove(threadGroup);
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    private int getNumberOfClearedThreads() {
        return this.numberOfClearedThreads;
    }

    private synchronized void incrementNumberOfClearedThreads() {
        ++this.numberOfClearedThreads;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class JmxListener
    implements ThreadMonitor.Listener {
        private JmxListener() {
        }

        public void threadIsHung(String string, int n, long l) {
            try {
                String string2 = MessageFormat.format("Thread \"{0}\" has been active for {1} milliseconds and may be hung.  There are {2} threads in total that may be hung.", string, new Long(l), new Integer(ThreadMonitorImpl.this.hungThreads.size()));
                Notification notification = new Notification("websphere.thread.hung", (Object)ThreadMonitorImpl.this.jmxCollaborator.getObjectName(), 0L, string2);
                Properties properties = new Properties();
                properties.setProperty("threadName", string);
                properties.setProperty("processId", ThreadMonitorImpl.this.jmxCollaborator.getPid());
                properties.setProperty("processName", ThreadMonitorImpl.this.jmxCollaborator.getName());
                notification.setUserData(properties);
                ThreadMonitorImpl.this.jmxCollaborator.sendNotification(notification);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, (String)this.getClass().getName(), (String)"366");
            }
        }

        public void threadIsClear(String string, int n, long l) {
            try {
                String string2 = MessageFormat.format("Thread \"{0}\" was previously reported to be hung but has completed.  It was active for approximately {1} milliseconds. There are now {2} total that may be hung.", string, new Long(l), new Integer(ThreadMonitorImpl.this.hungThreads.size()));
                Notification notification = new Notification("websphere.thread.clear", (Object)ThreadMonitorImpl.this.jmxCollaborator.getObjectName(), 0L, string2);
                Properties properties = new Properties();
                properties.setProperty("threadName", string);
                notification.setUserData(properties);
                ThreadMonitorImpl.this.jmxCollaborator.sendNotification(notification);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, (String)this.getClass().getName(), (String)"380");
            }
        }
    }

    private class RasListener
    implements ThreadMonitor.Listener {
        private RasListener() {
        }

        public void threadIsClear(String string, int n, long l) {
            Tr.warning(tc, "WSVR0606W", new Object[]{string, Integer.toHexString(n), new Long(l), new Integer(ThreadMonitorImpl.this.hungThreads.size())});
        }

        public void threadIsHung(String string, int n, long l) {
            Tr.warning(tc, "WSVR0605W", new Object[]{string, Integer.toHexString(n), new Long(l), new Integer(ThreadMonitorImpl.this.hungThreads.size())});
        }
    }

    private static class SimplePolicy
    implements ThreadMonitor.DetectionPolicy {
        private long threshold = 0L;

        SimplePolicy(long l) {
            this.threshold = l;
        }

        public boolean isThreadHung(String string, int n, long l) {
            return l > this.threshold;
        }

        public long getThreshold() {
            return this.threshold;
        }

        public void setThreshold(long l) {
            this.threshold = l;
        }
    }

    private class AlarmBasedNotification
    implements AlarmListener {
        Alarm current = null;

        AlarmBasedNotification() {
            this.current = AlarmManager.create(ThreadMonitorImpl.this.getInterval(), this);
        }

        public void alarm(Object object) {
            try {
                ThreadMonitorImpl.this.checkAllThreads();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"295");
            }
            this.scheduleNext();
        }

        void cancel() {
            if (this.current != null) {
                this.current.cancel();
                this.current = null;
            }
        }

        void scheduleNext() {
            if (ThreadMonitorImpl.this.getInterval() > 0L) {
                this.current = AlarmManager.create(ThreadMonitorImpl.this.getInterval(), this);
            }
        }
    }
}

