/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.pmi.ThreadPoolPerf;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.pmi.server.PmiFactory;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ThreadMonitor;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.util.ThreadPoolListener;
import com.ibm.ws.util.WSUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.TooManyListenersException;
import org.eclipse.emf.ecore.EObject;

public class ThreadPoolMgrImpl
extends ComponentImpl
implements ThreadPoolMgr,
ThreadPoolListener {
    private static TraceComponent tc = Tr.register(class$com$ibm$ws$runtime$component$ThreadPoolMgrImpl == null ? (class$com$ibm$ws$runtime$component$ThreadPoolMgrImpl = ThreadPoolMgrImpl.class$("com.ibm.ws.runtime.component.ThreadPoolMgrImpl")) : class$com$ibm$ws$runtime$component$ThreadPoolMgrImpl, "Runtime", "com.ibm.ws.runtime.runtime");
    private Map threadPools = new HashMap(2);
    private ThreadPoolListener[] threadPoolListeners = new ThreadPoolListener[0];
    static /* synthetic */ Class class$com$ibm$ws$runtime$component$ThreadPoolMgrImpl;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ThreadPoolMgr;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ThreadMonitor;
    static /* synthetic */ Class class$com$ibm$ws$runtime$component$ThreadPoolMgrImpl$ThreadPoolMonitorAdapter;

    public void initialize(Object object) {
        this.addService(class$com$ibm$ws$runtime$service$ThreadPoolMgr == null ? (class$com$ibm$ws$runtime$service$ThreadPoolMgr = ThreadPoolMgrImpl.class$("com.ibm.ws.runtime.service.ThreadPoolMgr")) : class$com$ibm$ws$runtime$service$ThreadPoolMgr);
    }

    public ThreadPool getThreadPool(String string) {
        return (ThreadPool)this.threadPools.get(string);
    }

    public ThreadPool getThreadPool(String string, com.ibm.websphere.models.config.process.ThreadPool threadPool) {
        ThreadPool threadPool2 = this.getThreadPool(string);
        if (threadPool2 == null) {
            String string2;
            PmiThreadPoolAdapter pmiThreadPoolAdapter = new PmiThreadPoolAdapter();
            ThreadPoolListener[] threadPoolListenerArray = new ThreadPoolListener[]{pmiThreadPoolAdapter, this};
            if (threadPool == null) {
                threadPool2 = new ThreadPool(string, 1, 5, threadPoolListenerArray);
                string2 = string;
            } else {
                threadPool2 = new ThreadPool(string, threadPool.getMinimumSize(), threadPool.getMaximumSize(), threadPoolListenerArray);
                threadPool2.setKeepAliveTime(threadPool.getInactivityTimeout());
                threadPool2.setGrowAsNeeded(threadPool.isIsGrowable());
                string2 = this.getConfigId((EObject)threadPool);
            }
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(threadPool2, string);
            this.registerMBean("ThreadPool", (RuntimeCollaborator)defaultRuntimeCollaborator, WSUtil.convertToMbeanCompliantString(string), WSUtil.convertToMbeanCompliantString(string2), null);
            this.threadPools.put(string, threadPool2);
            ThreadMonitor threadMonitor = (ThreadMonitor)this.getService(class$com$ibm$ws$runtime$service$ThreadMonitor == null ? (class$com$ibm$ws$runtime$service$ThreadMonitor = ThreadPoolMgrImpl.class$("com.ibm.ws.runtime.service.ThreadMonitor")) : class$com$ibm$ws$runtime$service$ThreadMonitor);
            ThreadPoolMonitorAdapter threadPoolMonitorAdapter = new ThreadPoolMonitorAdapter(threadPool2, threadMonitor, pmiThreadPoolAdapter);
            this.releaseService(threadMonitor);
        }
        return threadPool2;
    }

    public void addThreadPoolListener(ThreadPoolListener threadPoolListener) {
        int n = this.threadPoolListeners.length + 1;
        ThreadPoolListener[] threadPoolListenerArray = new ThreadPoolListener[n];
        System.arraycopy(this.threadPoolListeners, 0, threadPoolListenerArray, 0, n - 1);
        threadPoolListenerArray[n - 1] = threadPoolListener;
        this.threadPoolListeners = threadPoolListenerArray;
    }

    public void removeThreadPoolListener(ThreadPoolListener threadPoolListener) {
        int n;
        for (n = 0; n < this.threadPoolListeners.length && this.threadPoolListeners[n] != threadPoolListener; ++n) {
        }
        if (n < this.threadPoolListeners.length) {
            int n2 = this.threadPoolListeners.length - 1;
            ThreadPoolListener[] threadPoolListenerArray = new ThreadPoolListener[n2];
            System.arraycopy(this.threadPoolListeners, 0, threadPoolListenerArray, 0, n);
            System.arraycopy(this.threadPoolListeners, n + 1, threadPoolListenerArray, n, n2 - n - 1);
            this.threadPoolListeners = threadPoolListenerArray;
        }
    }

    public void threadPoolCreated(ThreadPool threadPool) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadPoolCreated(threadPool);
        }
    }

    public void threadCreated(ThreadPool threadPool, int n) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadCreated(threadPool, n);
        }
    }

    public void threadStarted(ThreadPool threadPool, int n, int n2) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadStarted(threadPool, n, n2);
        }
    }

    public void threadReturned(ThreadPool threadPool, int n, int n2) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadReturned(threadPool, n, n2);
        }
    }

    public void threadDestroyed(ThreadPool threadPool, int n) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadDestroyed(threadPool, n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ThreadPoolMonitorAdapter
    implements ThreadPool.MonitorPlugin,
    ThreadMonitor.ThreadGroup {
        private ThreadMonitor.DetectionPolicy policy = null;
        private ThreadPool threadPool = null;
        private ThreadMonitor.Listener listener = null;
        private PmiThreadPoolAdapter pmiAdapter = null;

        ThreadPoolMonitorAdapter(ThreadPool threadPool, ThreadMonitor threadMonitor, PmiThreadPoolAdapter pmiThreadPoolAdapter) {
            this.threadPool = threadPool;
            this.pmiAdapter = pmiThreadPoolAdapter;
            try {
                threadMonitor.addThreadGroup(this);
                this.threadPool.setMonitorPlugin(this);
                pmiThreadPoolAdapter.monitorStateChanged(threadMonitor.isEnabled());
            }
            catch (ComponentDisabledException componentDisabledException) {
            }
            catch (TooManyListenersException tooManyListenersException) {
                tooManyListenersException.printStackTrace(System.out);
                FFDCFilter.processException((Throwable)tooManyListenersException, (String)(class$com$ibm$ws$runtime$component$ThreadPoolMgrImpl$ThreadPoolMonitorAdapter == null ? (class$com$ibm$ws$runtime$component$ThreadPoolMgrImpl$ThreadPoolMonitorAdapter = ThreadPoolMgrImpl.class$("com.ibm.ws.runtime.component.ThreadPoolMgrImpl$ThreadPoolMonitorAdapter")) : class$com$ibm$ws$runtime$component$ThreadPoolMgrImpl$ThreadPoolMonitorAdapter).getName(), (String)"198");
            }
        }

        public boolean checkThread(String string, int n, long l) {
            if (this.policy.isThreadHung(string, n, l)) {
                this.pmiAdapter.threadIsHung(string);
                this.listener.threadIsHung(string, n, l);
                return true;
            }
            return false;
        }

        public void clearThread(String string, int n, long l) {
            this.pmiAdapter.threadIsClear(string, l);
            this.listener.threadIsClear(string, n, l);
        }

        public void checkAllThreads(ThreadMonitor.DetectionPolicy detectionPolicy) {
            this.policy = detectionPolicy;
            this.threadPool.checkAllThreads();
        }

        public void setThreadMonitorListener(ThreadMonitor.Listener listener) {
            if (this.listener != null && !this.listener.equals(listener)) {
                throw new IllegalStateException("Listener already registered");
            }
            this.listener = listener;
        }

        public String toString() {
            return "ThreadPoolMonitorAdapter[pool=" + this.threadPool.getName() + "]";
        }

        public void monitorStateChanged(boolean bl) {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "monitorStateChanged", new Object[]{this, bl ? Boolean.TRUE : Boolean.FALSE});
            }
            this.pmiAdapter.monitorStateChanged(bl);
        }
    }

    static class PmiThreadPoolAdapter
    implements ThreadPoolListener {
        ThreadPoolPerf tpPerf;

        public void threadPoolCreated(ThreadPool threadPool) {
            this.tpPerf = PmiFactory.createThreadPoolPerf((String)threadPool.getName(), (int)threadPool.getMinimumPoolSize(), (int)threadPool.getMaximumPoolSize());
        }

        public void threadCreated(ThreadPool threadPool, int n) {
            if (this.tpPerf != null) {
                this.tpPerf.threadCreated(n);
            }
        }

        public void threadStarted(ThreadPool threadPool, int n, int n2) {
            if (this.tpPerf != null) {
                this.tpPerf.threadStarted(n2);
            }
        }

        public void threadReturned(ThreadPool threadPool, int n, int n2) {
            if (this.tpPerf != null) {
                this.tpPerf.threadReturned(n2);
            }
        }

        public void threadDestroyed(ThreadPool threadPool, int n) {
            if (this.tpPerf != null) {
                this.tpPerf.threadDestroyed(n);
            }
        }

        void threadIsHung(String string) {
            if (this.tpPerf != null) {
                this.tpPerf.threadHangDetected();
            }
        }

        void threadIsClear(String string, long l) {
            if (this.tpPerf != null) {
                this.tpPerf.threadHangCleared(l);
            }
        }

        void monitorStateChanged(boolean bl) {
            if (this.tpPerf != null) {
                this.tpPerf.setThreadMonitorServiceEnabled(bl);
            }
        }
    }
}

