/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.beans.EventSetDescriptor;
import java.lang.reflect.Method;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import tcl.lang.AdaptorClassLoader;
import tcl.lang.AssocData;
import tcl.lang.BeanEventParamSet;
import tcl.lang.EventAdaptor;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;

class BeanEventMgr
implements AssocData {
    private static Hashtable adaptorClsTab = new Hashtable();
    private static AdaptorClassLoader adaptorLoader = new AdaptorClassLoader();
    Stack eventParamSetStack = new Stack();

    private BeanEventMgr() {
    }

    static BeanEventMgr getBeanEventMgr(Interp interp) {
        BeanEventMgr beanEventMgr = (BeanEventMgr)interp.getAssocData("tclBeanEvent");
        if (beanEventMgr == null) {
            beanEventMgr = new BeanEventMgr();
            interp.setAssocData("tclBeanEvent", (AssocData)beanEventMgr);
        }
        return beanEventMgr;
    }

    void pushEventParamSet(BeanEventParamSet beanEventParamSet) {
        this.eventParamSetStack.push(beanEventParamSet);
    }

    void popEventParamSet() throws EmptyStackException {
        this.eventParamSetStack.pop();
    }

    BeanEventParamSet peekEventParamSet() {
        if (this.eventParamSetStack.size() == 0) {
            return null;
        }
        return (BeanEventParamSet)this.eventParamSetStack.peek();
    }

    public void disposeAssocData(Interp interp) {
        this.eventParamSetStack = null;
    }

    void setBinding(Interp interp, ReflectObject reflectObject, EventSetDescriptor eventSetDescriptor, Method method, TclObject tclObject) throws TclException {
        EventAdaptor eventAdaptor = null;
        if (reflectObject.bindings == null) {
            reflectObject.bindings = new Hashtable();
        } else {
            eventAdaptor = (EventAdaptor)reflectObject.bindings.get(eventSetDescriptor);
        }
        if (eventAdaptor == null) {
            Class<?> clazz = eventSetDescriptor.getListenerType();
            Class clazz2 = (Class)adaptorClsTab.get(clazz);
            if (clazz2 == null) {
                clazz2 = adaptorLoader.loadEventAdaptor(interp, eventSetDescriptor);
                adaptorClsTab.put(clazz, clazz2);
            }
            try {
                eventAdaptor = (EventAdaptor)clazz2.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (eventAdaptor == null) {
                throw new TclException(interp, "couldn't instantiate adaptor class for eventset \"" + eventSetDescriptor + "\"");
            }
            eventAdaptor.init(interp, reflectObject.javaObj, eventSetDescriptor);
            reflectObject.bindings.put(eventSetDescriptor, eventAdaptor);
        }
        if (tclObject.toString().length() > 0) {
            eventAdaptor.setCallback(method.getName(), tclObject);
        } else if (eventAdaptor.deleteCallback(method.getName()) == 0) {
            reflectObject.bindings.remove(eventSetDescriptor);
            if (reflectObject.bindings.size() == 0) {
                reflectObject.bindings = null;
            }
        }
    }

    TclObject getBinding(Interp interp, ReflectObject reflectObject, EventSetDescriptor eventSetDescriptor, Method method) {
        EventAdaptor eventAdaptor = null;
        if (reflectObject.bindings != null) {
            eventAdaptor = (EventAdaptor)reflectObject.bindings.get(eventSetDescriptor);
        }
        if (eventAdaptor == null) {
            return null;
        }
        return eventAdaptor.getCallback(method.getName());
    }

    TclObject getHandledEvents(ReflectObject reflectObject) {
        TclObject tclObject = TclList.newInstance();
        if (reflectObject.bindings != null) {
            Enumeration enumeration = reflectObject.bindings.elements();
            while (enumeration.hasMoreElements()) {
                EventAdaptor eventAdaptor = (EventAdaptor)enumeration.nextElement();
                eventAdaptor.getHandledEvents(tclObject);
            }
        }
        return tclObject;
    }
}

