/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.iiop;

import com.ibm.CORBA.iiop.UserKey;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.corba.UserKeyImpl;
import com.ibm.rmi.util.Utility;
import java.util.Arrays;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;

public final class ObjectKey {
    private byte[] objectKey;
    private UserKey userKey;
    public static final int INVALID_SERVER_ID = -1;
    private static final int JMBI_VERSION = 74;
    private static final int KMBI_VERSION = 75;
    private static final int LMBI_VERSION = 76;
    private static final int XMBI_MAGIC = 5063241;
    private static final String MBI_MAGIC_SUFFIX = "MBI";
    private static final int IBM_MAGIC_OFFSET = 0;
    private static final int IBM_SCID_OFFSET = 4;
    private static final int IBM_SERVERID_OFFSET = 8;
    private static final int IBM_USERKEYOFFSET_OFFSET = 12;
    private static final int IBM_USERKEYLEN_SIZE = 2;
    private static final int IBM_POANAMELEN_SIZE = 2;
    private static final int JMBI_SERVERUUID_SIZE = 16;
    private static final int JMBI_SERVERUUID_OFFSET = 12;
    private static final int JMBI_USERKEYOFFSET_OFFSET = 28;
    private static final int JMBI_USERKEYLEN_OFFSET = 32;
    private static final int IBM_OBJECTKEY_SIZE = 14;
    private static final int JMBI_OBJECTKEY_SIZE = 36;
    private static final int JMBI_USERKEY_OFFSET = 36;
    private String stringOfKey = null;
    private int hash = 0;
    private static final ObjectKey SINOObjectKey = new ObjectKey(new byte[]{73, 78, 73, 84});
    private static final ObjectKey SINOObjectKeyReversed = new ObjectKey(new byte[]{84, 73, 78, 73});

    public ObjectKey(byte[] byArray) {
        byte[] byArray2;
        if (byArray == null) {
            throw new BAD_PARAM("null parameter passed to ObjectKey(byte[])", 1229124141, CompletionStatus.COMPLETED_NO);
        }
        this.objectKey = byArray;
        this.userKey = null;
        if (this.isMBI() && (byArray2 = this.getUserKeyBytes()) != null) {
            this.userKey = new UserKeyImpl(byArray2);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, this, "<init>:316", this.toString());
        }
    }

    public ObjectKey(int n, int n2, int n3, byte[] byArray) {
        this(n, n2, n3, byArray, null);
    }

    public ObjectKey(int n, int n2, int n3, UserKey userKey) {
        this(n, n2, n3, userKey, null);
    }

    public ObjectKey(int n, int n2, int n3, byte[] byArray, byte[] byArray2) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4132L, this, "<init>:375", (Object)("magic=0x" + Integer.toHexString(n) + ",subcontractId=0x" + Integer.toHexString(n2) + ",serverId=0x" + Integer.toHexString(n3) + ",userKey=0x" + Utility.bytesToHexString(byArray)), (Object)(",poaName=0x" + Utility.bytesToHexString(byArray2)));
        }
        this.createObjectKey(n, n2, n3, byArray, byArray2);
        this.userKey = new UserKeyImpl(byArray);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4132L, this, "<init>:390", (Object)this.toString());
        }
    }

    public ObjectKey(int n, int n2, int n3, UserKey userKey, byte[] byArray) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4132L, this, "<init>:414", (Object)("magic=0x" + Integer.toHexString(n) + ",subcontractId=0x" + Integer.toHexString(n2) + ",serverId=0x" + Integer.toHexString(n3) + ",userKey=" + userKey), (Object)(",poaName=0x" + Utility.bytesToHexString(byArray)));
        }
        if (userKey == null) {
            throw new NullPointerException("null UserKey");
        }
        this.createObjectKey(n, n2, n3, userKey.getBytes(), byArray);
        this.userKey = userKey;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4132L, this, "<init>:433", (Object)this.toString());
        }
    }

    private void createObjectKey(int n, int n2, int n3, byte[] byArray, byte[] byArray2) {
        int n4 = n >>> 24;
        int n5 = 0;
        switch (n4) {
            case 74: {
                this.objectKey = new byte[36 + byArray.length];
                break;
            }
            case 75: {
                this.objectKey = new byte[16 + byArray.length];
                break;
            }
            default: {
                n5 = byArray2 == null ? 2 : byArray2.length + 2;
                int n6 = 2 + byArray.length;
                this.objectKey = new byte[14 + n5 + n6];
            }
        }
        Utility.intToBytes(n, this.objectKey, 0);
        Utility.intToBytes(n2, this.objectKey, 4);
        Utility.intToBytes(n3, this.objectKey, 8);
        switch (n4) {
            case 74: {
                Utility.intToBytes(36, this.objectKey, 28);
                Utility.intToBytes(byArray.length, this.objectKey, 32);
                System.arraycopy(byArray, 0, this.objectKey, 36, byArray.length);
                break;
            }
            case 75: {
                Utility.shortToBytes((short)14, this.objectKey, 12);
                Utility.shortToBytes((short)byArray.length, this.objectKey, 14);
                System.arraycopy(byArray, 0, this.objectKey, 16, byArray.length);
                break;
            }
            default: {
                int n7 = 14;
                if (byArray2 != null) {
                    Utility.shortToBytes((short)byArray2.length, this.objectKey, n7);
                    System.arraycopy(byArray2, 0, this.objectKey, n7 + 2, byArray2.length);
                } else {
                    Utility.shortToBytes((short)0, this.objectKey, n7);
                }
                Utility.shortToBytes((short)(n7 += n5), this.objectKey, 12);
                Utility.shortToBytes((short)byArray.length, this.objectKey, n7);
                System.arraycopy(byArray, 0, this.objectKey, n7 + 2, byArray.length);
            }
        }
    }

    public int getMagic() {
        int n = this._getMagic();
        if (n != 0) {
            return n;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, (Object)this, "getMagic:529", "Malformed objectKey - error extracting magic.", (Object)this.toString());
        }
        throw new INV_OBJREF("Malformed objectKey - error extracting magic.", 1229125523, CompletionStatus.COMPLETED_MAYBE);
    }

    private int _getMagic() {
        if (this.objectKey.length >= 4) {
            return Utility.bytesToInt(this.objectKey, 0);
        }
        return 0;
    }

    public boolean isMBI() {
        return ObjectKey.isMBI(this._getMagic());
    }

    public static boolean isMBI(int n) {
        return (n & 0xFFFFFF) == 5063241;
    }

    public static boolean isMBI(String string) {
        return string != null && string.length() >= 4 && string.regionMatches(1, MBI_MAGIC_SUFFIX, 0, 3);
    }

    public int getVersion() {
        return this._getMagic() >>> 24;
    }

    public int getSCID() {
        if (this.isMBI() && this.objectKey.length >= 8) {
            return Utility.bytesToInt(this.objectKey, 4);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, (Object)this, "getSCID:608", "Malformed objectKey - error getting SCID.", (Object)this.toString());
        }
        throw new INV_OBJREF("Malformed objectKey - error getting SCID.", 1229125524, CompletionStatus.COMPLETED_MAYBE);
    }

    public void setSCID(int n) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "setSCID:630", (Object)("subcontractId=0x" + Integer.toHexString(n)));
        }
        if (!this.isMBI() || this.objectKey.length < 8) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, (Object)this, "setSCID:641", "Malformed objectKey - error setting SCID.", (Object)this.toString());
            }
            throw new INV_OBJREF("Malformed objectKey - error setting SCID.", 1229125529, CompletionStatus.COMPLETED_MAYBE);
        }
        Utility.intToBytes(n, this.objectKey, 4);
        this.stringOfKey = null;
        this.hash = 0;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "setSCID:652", (Object)this.toString());
        }
    }

    public int getServerId() {
        if (this.objectKey.length >= 12) {
            return Utility.bytesToInt(this.objectKey, 8);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, (Object)this, "getServerId:673", "Malformed objectKey - error getting ServerId.", (Object)this.toString());
        }
        return -1;
    }

    public void setServerId(int n) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "setServerId:693", (Object)("serverId=0x" + Integer.toHexString(n)));
        }
        if (!this.isMBI() || this.objectKey.length < 12) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, (Object)this, "setServerId:704", "Malformed objectKey - error setting ServerId.", (Object)this.toString());
            }
            throw new INV_OBJREF("Malformed objectKey - error setting ServerId.", 1229125530, CompletionStatus.COMPLETED_MAYBE);
        }
        Utility.intToBytes(n, this.objectKey, 8);
        this.stringOfKey = null;
        this.hash = 0;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "setServerId:716", (Object)this.toString());
        }
    }

    public byte[] getServerUUID() {
        if (this.getVersion() == 74) {
            if (this.objectKey.length >= 28) {
                byte[] byArray = new byte[16];
                System.arraycopy(this.objectKey, 12, byArray, 0, 16);
                return byArray;
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, (Object)this, "getServerUUID:744", "Malformed objectKey - error getting ServerUUID.", (Object)this.toString());
            }
            throw new INV_OBJREF("Malformed objectKey - error getting ServerUUID.", 1229125526, CompletionStatus.COMPLETED_MAYBE);
        }
        return null;
    }

    public void setServerUUID(byte[] byArray) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "setServerUUID:775");
        }
        switch (this.getVersion()) {
            case 74: {
                if (byArray != null) {
                    if (byArray.length == 16) {
                        System.arraycopy(byArray, 0, this.objectKey, 12, 16);
                        this.stringOfKey = null;
                        this.hash = 0;
                        break;
                    }
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8208L, (Object)this, "setServerUUID:792", "Malformed ServerUUID - invalid length = " + byArray.length, (Object)this.toString());
                    }
                    throw new BAD_PARAM("Invalid length ServerUUID specified", 1229124135, CompletionStatus.COMPLETED_MAYBE);
                }
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(8208L, (Object)this, "setServerUUID:806", "Malformed ServerUUID - serverUUID of null specified ", (Object)this.toString());
                }
                throw new BAD_PARAM("NULL ServerUUID specified", 1229124136, CompletionStatus.COMPLETED_MAYBE);
            }
            default: {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(8208L, (Object)this, "setServerUUID:821", "Malformed objectkey - Attempt to set a ServerUUID on a key type of " + this.getVersion(), (Object)this.toString());
                }
                throw new INV_OBJREF("ServerUUID specified for non-JMBI ObjectKey", 1229125527, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "setServerUUID:832", (Object)this.toString());
        }
    }

    public UserKey getUserKeyObject() {
        if (!this.isMBI()) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, (Object)this, "getUserKeyObject:849", "Malformed objectkey - Attempt to get a UserKey from a key type of " + this.getVersion(), (Object)this.toString());
            }
            throw new INV_OBJREF("Attempt to get user key from non-IBM objectKey", 1229125531, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.userKey;
    }

    public byte[] getUserKey() {
        return this.getUserKeyObject().getBytes();
    }

    private byte[] getUserKeyBytes() {
        byte[] byArray = null;
        if (!this.isMBI()) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, (Object)this, "getUserKeyBytes:887", "Malformed objectkey - Attempt to get a UserKey from a key type of " + this.getVersion(), (Object)this.toString());
            }
            throw new INV_OBJREF("Attempt to get user key from non-IBM objectKey", 1229125531, CompletionStatus.COMPLETED_MAYBE);
        }
        try {
            if (this.getVersion() == 74) {
                int n = Utility.bytesToInt(this.objectKey, 32);
                if (n > 0) {
                    byArray = new byte[n];
                    int n2 = Utility.bytesToInt(this.objectKey, 28);
                    System.arraycopy(this.objectKey, n2, byArray, 0, n);
                }
            } else {
                short s = Utility.bytesToShort(this.objectKey, 12);
                short s2 = Utility.bytesToShort(this.objectKey, s);
                if (s2 > 0) {
                    byArray = new byte[s2];
                    System.arraycopy(this.objectKey, s + 2, byArray, 0, s2);
                }
            }
        }
        catch (Exception exception) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, this, "getUserKeyBytes:921", exception.toString());
            }
            byArray = null;
        }
        return byArray;
    }

    public void setUserKey(byte[] byArray) {
        this.setUserKey(new UserKeyImpl(byArray));
    }

    public void setUserKey(UserKey userKey) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "setUserKey:951", (Object)userKey);
        }
        if (userKey == null) {
            throw new NullPointerException("null UserKey");
        }
        this.userKey = userKey;
        if (!this.isMBI()) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, (Object)this, "setUserKey:968", "Malformed objectkey - Attempt to set a UserKey in a key type of " + this.getVersion(), (Object)this.toString());
            }
            throw new INV_OBJREF("Attempt to set user key in non-IBM objectKey", 1229125532, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.getVersion() == 74) {
            int n = Utility.bytesToInt(this.objectKey, 28);
            byte[] byArray = new byte[n];
            System.arraycopy(this.objectKey, 0, byArray, 0, n);
            this.objectKey = new byte[n + userKey.length()];
            System.arraycopy(byArray, 0, this.objectKey, 0, n);
            Utility.intToBytes(userKey.length(), this.objectKey, n - 4);
            System.arraycopy(userKey.getBytes(), 0, this.objectKey, n, userKey.length());
        } else {
            short s = Utility.bytesToShort(this.objectKey, 12);
            byte[] byArray = new byte[s];
            System.arraycopy(this.objectKey, 0, byArray, 0, s);
            this.objectKey = new byte[s + 2 + userKey.length()];
            System.arraycopy(byArray, 0, this.objectKey, 0, s);
            Utility.shortToBytes((short)userKey.length(), this.objectKey, s);
            System.arraycopy(userKey.getBytes(), 0, this.objectKey, s + 2, userKey.length());
        }
        this.stringOfKey = null;
        this.hash = 0;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "setUserKey:1005", (Object)this.toString());
        }
    }

    public byte[] getBytes() {
        return this.objectKey;
    }

    public byte[] getObjectKey() {
        return this.objectKey;
    }

    public String toString() {
        if (this.stringOfKey == null) {
            this.stringOfKey = "0x" + Utility.bytesToHexString(this.objectKey);
        }
        return this.stringOfKey;
    }

    public byte[] getPOAName() {
        byte[] byArray = null;
        if (!this.isMBI() || this.getVersion() == 74 || this.getVersion() == 75) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, (Object)this, "getPOAName:1067", "Malformed objectkey - Attempt to get a POAName from a key type of " + this.getVersion(), (Object)this.objectKey);
            }
            return null;
        }
        try {
            short s = Utility.bytesToShort(this.objectKey, 14);
            byArray = new byte[s];
            System.arraycopy(this.objectKey, 16, byArray, 0, s);
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "getPOAName:1086", exception);
            throw new INV_OBJREF("Malformed objectKey - error extracting POA name.", 1229125528, CompletionStatus.COMPLETED_MAYBE);
        }
        return byArray;
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            int n2 = 0;
            while (n2 < this.objectKey.length) {
                n = 31 * n + this.objectKey[n2];
                ++n2;
            }
            this.hash = n;
        }
        return n;
    }

    public boolean equals(ObjectKey objectKey) {
        return Arrays.equals(this.objectKey, objectKey.getBytes());
    }

    public boolean equals(Object object) {
        return object instanceof ObjectKey && this.equals((ObjectKey)object);
    }

    public static ObjectKey getSINOKey() {
        return SINOObjectKey;
    }

    public boolean isSINO() {
        return this.equals(SINOObjectKey) || this.equals(SINOObjectKeyReversed);
    }

    public int length() {
        return this.objectKey.length;
    }
}

