/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.transport;

import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionKey;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.ReaderPool;
import com.ibm.CORBA.transport.TransportConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public abstract class TransportConnectionBase
implements TransportConnection {
    private int MAX_SOCKET_RETRIES;
    private Socket socket;
    private ConnectionKey key;
    private ORBConnection conn;
    private InputStream inputStream;
    private OutputStream outputStream;
    private ReaderPool readerPool;
    private ConnectionTable table;
    private Object readerHandle;
    private ORBForTransports orbForTransports;
    private String remoteHostName;
    private int remotePort;
    private String remoteHost;
    private String localHostName;
    private int localPort;
    private String localHost;
    private InetAddress localInetAddress;
    private static final String DEFAULT_LOCAL_HOST = "127.0.0.1";
    private static final String DEFAULT_LOCAL_HOST_NAME = "localHost";
    private static final String thisClassName = "com.ibm.CORBA.transport.TransportConnectionBase";
    private static InetAddress defaultLocalInetAddress = null;
    private static boolean gotDefaultLocalInetAddress = false;
    private String theParameterString;

    protected TransportConnectionBase(ConnectionTable connectionTable, Socket socket, ReaderPool readerPool, ORBForTransports oRBForTransports) {
        block6: {
            this.MAX_SOCKET_RETRIES = 5;
            this.socket = null;
            this.key = null;
            this.conn = null;
            this.inputStream = null;
            this.outputStream = null;
            this.readerPool = null;
            this.table = null;
            this.readerHandle = null;
            this.orbForTransports = null;
            this.remoteHostName = null;
            this.remotePort = 0;
            this.remoteHost = null;
            this.localHostName = null;
            this.localPort = -1;
            this.localHost = null;
            this.localInetAddress = null;
            this.theParameterString = null;
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (Object)this, "<init> (server-side):157", (Object)("Server-side constructor, socket=" + socket));
            }
            try {
                this.table = connectionTable;
                this.socket = socket;
                this.readerPool = readerPool;
                this.orbForTransports = oRBForTransports;
                this.getIOStreams();
                this.remoteHostName = socket.getInetAddress().getHostName();
                this.remotePort = socket.getPort();
                this.conn = oRBForTransports.createORBConnectionForServer();
                this.conn.setStreams(this.inputStream, this.outputStream, this);
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "<init> (server-side):188", exception);
                try {
                    socket.close();
                }
                catch (Exception exception2) {
                    if (!ORBRas.isTrcLogging) break block6;
                    ORBRas.orbTrcLogger.trace(8208L, this, "<init> (server-side):197", exception2.toString());
                }
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "<init> (server-side):206");
        }
    }

    protected TransportConnectionBase(ORBForTransports oRBForTransports, ConnectionTable connectionTable, ConnectionKey connectionKey, ORBConnection oRBConnection, ReaderPool readerPool, Profile profile) {
        this.MAX_SOCKET_RETRIES = 5;
        this.socket = null;
        this.key = null;
        this.conn = null;
        this.inputStream = null;
        this.outputStream = null;
        this.readerPool = null;
        this.table = null;
        this.readerHandle = null;
        this.orbForTransports = null;
        this.remoteHostName = null;
        this.remotePort = 0;
        this.remoteHost = null;
        this.localHostName = null;
        this.localPort = -1;
        this.localHost = null;
        this.localInetAddress = null;
        this.theParameterString = null;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "<init> (client-side):247", (Object)("Client-side constructor, ConnectionKey=" + connectionKey));
        }
        this.orbForTransports = oRBForTransports;
        this.table = connectionTable;
        this.key = connectionKey;
        this.conn = oRBConnection;
        this.readerPool = readerPool;
        this.remoteHostName = profile.getHost();
        this.remotePort = profile.getPort();
        this.localInetAddress = this.getLocalInetAddress();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "<init> (client-side):268", (Object)("localHost=" + this.localInetAddress));
        }
    }

    private InetAddress getLocalInetAddress() {
        InetAddress inetAddress = null;
        Object object = this.orbForTransports.getTransportData();
        if (object == null) {
            block8: {
                this.localHost = this.orbForTransports.getProperty("com.ibm.CORBA.LocalHost");
                if (this.localHost != null && this.localHost.length() > 0) {
                    try {
                        inetAddress = InetAddress.getByName(this.localHost);
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (!ORBRas.isTrcLogging) break block8;
                        ORBRas.orbTrcLogger.exception(8200L, this, "getLocalInetAddress:295", (Exception)unknownHostException);
                    }
                }
            }
            if (inetAddress == null) {
                inetAddress = TransportConnectionBase.getDefaultLocalInetAddress();
            }
            if (inetAddress == null) {
                this.localHost = DEFAULT_LOCAL_HOST;
                this.localHostName = DEFAULT_LOCAL_HOST_NAME;
            } else {
                this.localHost = inetAddress.getHostAddress();
                this.localHostName = inetAddress.getHostName();
            }
            this.orbForTransports.setTransportData(inetAddress);
        } else {
            inetAddress = (InetAddress)object;
        }
        return inetAddress;
    }

    private static InetAddress getDefaultLocalInetAddress() {
        if (!gotDefaultLocalInetAddress) {
            try {
                try {
                    InetAddress inetAddress = defaultLocalInetAddress;
                    synchronized (inetAddress) {
                        if (!gotDefaultLocalInetAddress) {
                            defaultLocalInetAddress = InetAddress.getLocalHost();
                        }
                    }
                    Object var4_3 = null;
                    gotDefaultLocalInetAddress = true;
                }
                catch (UnknownHostException unknownHostException) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exception(8200L, thisClassName, "getDefaultLocalInetAddress:344", (Exception)unknownHostException);
                    }
                    Object var4_4 = null;
                    gotDefaultLocalInetAddress = true;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                gotDefaultLocalInetAddress = true;
                throw throwable;
            }
        }
        return defaultLocalInetAddress;
    }

    private void getIOStreams() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    TransportConnectionBase.this.inputStream = TransportConnectionBase.this.socket.getInputStream();
                    TransportConnectionBase.this.outputStream = TransportConnectionBase.this.socket.getOutputStream();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            ORBRas.orbTrcLogger.exception(4104L, this, "getIOStreams:382", exception);
            throw new TRANSIENT(exception.getMessage() + ":socket=" + this.socket, 1229124356, CompletionStatus.COMPLETED_NO);
        }
    }

    public final void connect() {
        int n = 0;
        while (true) {
            try {
                block11: {
                    this.socket = this.localInetAddress == null ? this.createSocket(this.remoteHostName, this.remotePort) : this.createSocket(this.remoteHostName, this.remotePort, this.localInetAddress);
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, this, "connect:417", "Client side constructor, successfully created a new " + this.socket);
                    }
                    try {
                        this.socket.setKeepAlive(true);
                        this.socket.setTcpNoDelay(true);
                    }
                    catch (Exception exception) {
                        if (!ORBRas.isTrcLogging) break block11;
                        ORBRas.orbTrcLogger.trace(8208L, this, "connect:432", exception.toString());
                    }
                }
                this.getIOStreams();
                this.conn.setStreams(this.inputStream, this.outputStream, this);
                this.readerHandle = this.readerPool.addConnection(this.conn);
            }
            catch (SocketException socketException) {
                if (ORBRas.isTrcLogging || !(socketException instanceof ConnectException)) {
                    ORBRas.orbTrcLogger.exception(4104L, this, "connect:448", (Exception)socketException);
                }
                if (socketException instanceof BindException || socketException instanceof ConnectException || socketException instanceof NoRouteToHostException) {
                    this.table.removeConnection(this.key);
                    this.conn.abortConnection();
                    throw new TRANSIENT(socketException.getMessage() + ":host=" + this.remoteHostName + ",port=" + this.remotePort, 1229124353, CompletionStatus.COMPLETED_NO);
                }
                if (n == this.MAX_SOCKET_RETRIES || !this.table.cleanUp()) {
                    this.table.removeConnection(this.key);
                    this.conn.abortConnection();
                    throw new TRANSIENT(socketException.getMessage() + ":host=" + this.remoteHostName + ",port=" + this.remotePort, 1229124354, CompletionStatus.COMPLETED_NO);
                }
                ++n;
                continue;
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "connect:481", exception);
                this.table.removeConnection(this.key);
                this.conn.abortConnection();
                if (exception instanceof SystemException) {
                    throw (SystemException)exception;
                }
                throw new TRANSIENT(exception.getMessage() + ":host=" + this.remoteHostName + ",port=" + this.remotePort, 1229124355, CompletionStatus.COMPLETED_NO);
            }
            break;
        }
    }

    public void removeConnection() {
        block4: {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (Object)this, "removeConnection:514", (Object)("removing connection for " + this.socket));
            }
            this.table.removeConnection(this.key);
            this.readerPool.removeConnection(this.conn, this.readerHandle);
            this.readerHandle = null;
            try {
                this.inputStream.close();
                this.outputStream.close();
                this.socket.close();
            }
            catch (Exception exception) {
                if (!ORBRas.isTrcLogging) break block4;
                ORBRas.orbTrcLogger.trace(4104L, this, "removeConnection:540", exception.toString());
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "removeConnection:548");
        }
    }

    protected void activateServer() {
        this.key = this.createKey(this.remoteHostName, this.remotePort);
        this.table.addConnection(this.key, this.conn);
        this.table.checkConnectionTable();
        this.readerHandle = this.readerPool.addConnection(this.conn);
    }

    public String getConnectionParameterString() {
        if (this.theParameterString == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.getClass().getName(), ".");
            String string = "";
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
            this.theParameterString = string + "[addr=" + this.getRemoteHost() + ",port=" + this.getRemotePort() + ",local=" + this.getLocalPort() + "]";
        }
        return this.theParameterString;
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + " socket=" + this.socket + " key=" + this.key;
    }

    public abstract ConnectionKey createKey(String var1, int var2);

    public Socket createSocket(String string, int n, InetAddress inetAddress) throws Exception {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, this, "createSocket:646", "createSocket(String host, int port, InetAddress localInetAddress) is not implemented by this transport. Ignoring the value localInetAddress=" + inetAddress);
        }
        return this.createSocket(string, n);
    }

    public abstract Socket createSocket(String var1, int var2) throws Exception;

    public abstract Object getConnectionData();

    public ORBForTransports getORBForTransports() {
        return this.orbForTransports;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null && this.socket != null) {
            this.remoteHost = this.socket.getInetAddress().getHostAddress();
        }
        return this.remoteHost;
    }

    public String getRemoteHostName() {
        return this.remoteHostName;
    }

    public int getLocalPort() {
        if (this.localPort < 0 && this.socket != null) {
            this.localPort = this.socket.getLocalPort();
        }
        return this.localPort;
    }

    public String getLocalHost() {
        if (this.localHost == null) {
            if (this.socket == null) {
                return DEFAULT_LOCAL_HOST;
            }
            this.localHost = this.socket.getLocalAddress().getHostAddress();
        }
        return this.localHost;
    }

    public String getLocalHostName() {
        if (this.localHostName == null) {
            if (this.socket == null) {
                return DEFAULT_LOCAL_HOST_NAME;
            }
            try {
                this.localHostName = this.socket.getLocalAddress().getHostName();
            }
            catch (Throwable throwable) {
                this.localHostName = DEFAULT_LOCAL_HOST_NAME;
            }
            if (this.localHostName == null) {
                this.localHostName = DEFAULT_LOCAL_HOST_NAME;
            }
        }
        return this.localHostName;
    }

    public void preWrite(boolean bl) {
    }

    public void preReply() {
    }
}

