/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.LoadMap;
import com.ibm.jvm.dump.extract.ThreadContext;
import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.DvFileReader;

public class FrameTraverser {
    public static int FRAME_TYPE_MMI;
    public static int FRAME_TYPE_JAVA;
    public static int FRAME_TYPE_JIT;
    public static int FRAME_TYPE_NATIVE;
    DvFileReader reader;
    int numMaps;
    LoadMap[] maps;
    byte[] symbolMaps;
    static boolean initialized;
    long jvmRas;
    String exeFileName;

    private native void setupTraverser();

    private native DvJavaFrame[] javaTraverser(ThreadContext var1);

    private native DvNativeFrame[] nativeTraverser(ThreadContext var1);

    public FrameTraverser(DvFileReader dvFileReader, long l, String string) {
        if (initialized) {
            return;
        }
        this.reader = dvFileReader;
        this.jvmRas = l;
        this.exeFileName = string;
        this.setupTraverser();
    }

    public FrameTraverser() {
    }

    public DvJavaFrame[] getJavaFrames(ThreadContext threadContext) {
        DvJavaFrame[] dvJavaFrameArray = null;
        dvJavaFrameArray = this.javaTraverser(threadContext);
        DvUtils.trace("JavaStack for ee " + Long.toHexString(threadContext.ee), 0, false);
        if (dvJavaFrameArray != null) {
            int n = 0;
            while (n < dvJavaFrameArray.length) {
                if (dvJavaFrameArray[n].getMb() != 0L && dvJavaFrameArray[n].getName() != null) {
                    DvUtils.trace("\t JavaFrame at " + Long.toHexString(dvJavaFrameArray[n].getPc()) + " " + new String(dvJavaFrameArray[n].getName()), 0, false);
                }
                ++n;
            }
        }
        return dvJavaFrameArray;
    }

    public DvNativeFrame[] getNativeFrames(ThreadContext threadContext) {
        if (threadContext.sp == 0L) {
            return null;
        }
        DvNativeFrame[] dvNativeFrameArray = null;
        dvNativeFrameArray = this.nativeTraverser(threadContext);
        DvUtils.trace("NativeStack for ee " + Long.toHexString(threadContext.ee), 0, false);
        if (dvNativeFrameArray != null) {
            int n = 0;
            while (n < dvNativeFrameArray.length) {
                if (dvNativeFrameArray[n].getName() != null) {
                    DvUtils.trace("\t NativeFrame at " + Long.toHexString(dvNativeFrameArray[n].getPc()) + " " + new String(dvNativeFrameArray[n].getName()), 0, false);
                }
                ++n;
            }
        }
        return dvNativeFrameArray;
    }

    int readBytes(byte[] byArray, long l, int n) {
        try {
            this.reader.setAddress(l);
            if (this.reader.getPos() == 0L) {
                return 0;
            }
            this.reader.read(byArray, 0, n);
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    static {
        System.loadLibrary("java");
        FRAME_TYPE_MMI = 0;
        FRAME_TYPE_JAVA = 1;
        FRAME_TYPE_JIT = 2;
        FRAME_TYPE_NATIVE = 3;
        initialized = false;
    }
}

