/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.CTypeFile;
import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvEnvData;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DvObjectsCommands;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTextArea;

public class DvConsole
implements Observer {
    public static DvDump theDump;
    public static boolean bSystemErrTrace;
    public static boolean bGuiRequested;
    static PrintStream original_output;
    static PrintStream original_error;
    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    boolean traceOn = false;
    String traceFileName = null;
    String output = null;
    String inputFileName = null;
    static Properties inParams;
    static CommandPlugin currentCP;
    static Vector cmdList;
    static Vector commandPlugins;
    static Vector fastPath;
    static String currDump;
    private static Properties myHelpProps;
    private static Enumeration myPropsEnum;
    static int currASIndex;
    static int currProcessIndex;
    static int currThreadIndex;
    static Vector currentClassSpecs;
    static Vector currentCBSpecs;
    static int currWidth;
    static char currOffset;
    static Vector viewerInit;
    public static boolean echoOn;
    static boolean ipDump;
    static boolean ipInput;
    static boolean ipOutput;
    static boolean ipWorkingDir;
    static int traceHandle;
    static boolean runningUnderGUI;
    static Dumpviewer theGUI;
    static String lastMemCommandPosition;
    static int lastMemCommandLength;
    private static Vector outputVector;
    private static boolean useOutputVector;
    private static DvConsole that;
    private static CommandPlugin childCP;
    public static Vector sanityCheckVector;
    public static boolean bHeapTraversalInprogress;
    private static Vector jvmsInDump;
    private static Vector jvmsInDumpAs;
    private static Vector jvmsInDumpThread;

    public DvConsole(boolean bl, Object object, Vector vector) {
        Object object2;
        that = this;
        runningUnderGUI = bl;
        theGUI = (Dumpviewer)object;
        DvUtils.setConsoleOutput(!bl);
        viewerInit = vector;
        commandPlugins = DvUtils.findCommandPlugins();
        int n = commandPlugins.size();
        String[] stringArray = null;
        DvCommand dvCommand = null;
        DvUtils.writetoTrace("Asking each command plugin what it supports ");
        int n2 = 0;
        while (n2 < n) {
            object2 = (CommandPlugin)commandPlugins.get(n2);
            DvUtils.writetoTrace(" Plugin " + ((CommandPlugin)object2).pluginName() + " supports: ");
            stringArray = ((CommandPlugin)object2).getSyntax();
            int n3 = 0;
            while (n3 < stringArray.length) {
                dvCommand = new DvCommand(stringArray[n3], n2);
                DvUtils.writetoTrace("    " + stringArray[n3]);
                cmdList.add(dvCommand);
                ++n3;
            }
            ++n2;
        }
        DvUtils.initSetCommand();
        if (ipWorkingDir) {
            object2 = "Set Workdir=" + inParams.getProperty("w");
            this.execCmdWithWait(new ValidCmd((String)object2), true);
        } else {
            object2 = DvUtils.getDvProperty("WorkDir");
            if (null != object2) {
                String string = "Set Workdir=" + (String)object2;
                this.execCmdWithWait(new ValidCmd(string), true);
            }
        }
        if (ipOutput) {
            object2 = "Set Output=" + inParams.getProperty("o");
            this.execCmdWithWait(new ValidCmd((String)object2), true);
        }
        if (ipDump) {
            object2 = "Set Dump=" + inParams.getProperty("d");
            this.execCmdWithWait(new ValidCmd((String)object2), true);
        }
        if (ipInput) {
            object2 = "Exec " + inParams.getProperty("i");
            this.execCmdWithWait(new ValidCmd((String)object2), true);
        }
        object2 = "";
        DvUtils.writetoTrace("Entering master loop - terminated with quit command");
        while (!runningUnderGUI && !((String)object2).equals("quit")) {
            Object object3;
            DvConsole.output("\nReady......");
            if (echoOn) {
                PrintStream printStream = System.out;
                object3 = DvConsole.getOriginal_output();
                System.setOut((PrintStream)object3);
                System.out.println("Ready...");
                System.setOut(printStream);
            }
            try {
                object2 = this.in.readLine();
            }
            catch (IOException iOException) {
                DvUtils.errorMsg(" IOException in DvConsole constructor input loop", 0);
            }
            if (echoOn) {
                DvConsole.output((String)object2);
            }
            if (null != object2) {
                Object object4;
                object2 = ((String)object2).trim();
                String string = new String((String)object2);
                if (!((String)(object2 = this.preProcessInput((String)object2))).equals(string)) {
                    DvConsole.output("Transformed command:" + (String)object2 + "\n");
                }
                object3 = DvConsole.validate((String)object2);
                if (((ValidCmd)object3).errorPos == 0) {
                    DvConsole.output("\n ......command executing");
                    if (echoOn) {
                        object4 = System.out;
                        PrintStream printStream = DvConsole.getOriginal_output();
                        System.setOut(printStream);
                        System.out.println("\n ......command executing (output->" + DvUtils.getValue("output") + ")");
                        System.setOut((PrintStream)object4);
                    }
                    this.execCmd((ValidCmd)object3, false);
                    while (null != currentCP && currentCP.getInProgress()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            System.err.println("\nInterruptedException");
                        }
                    }
                    continue;
                }
                object4 = new String();
                int n4 = 0;
                while (n4 < ((ValidCmd)object3).errorPos) {
                    object4 = (String)object4 + " ";
                    ++n4;
                }
                DvConsole.output("\n !!!Invalid Command: " + ((ValidCmd)object3).savedCmd + "\n" + "                    " + (String)object4 + "^\n");
                if (null == currentCP) continue;
                DvConsole.currentCP.cpInProgress = false;
                continue;
            }
            object2 = "";
        }
    }

    public static void main(String[] stringArray) {
        DvUtils.initTrace();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        String string = null;
        if (stringArray.length > 0) {
            inParams = new Properties();
            if (stringArray[0].charAt(0) != '-') {
                stringArray[0] = "-d" + stringArray[0];
            }
            int n = 0;
            while (n < stringArray.length && !bl) {
                if (bl2) {
                    if (stringArray[n].charAt(0) != '-') {
                        stringArray[n] = stringArray[n - 1] + stringArray[n];
                        bl2 = false;
                    } else {
                        DvConsole.output("\nError: value required for argument '" + stringArray[n - 1] + "'");
                        bl = true;
                    }
                }
                if (stringArray[n].charAt(0) == '-' && !bl) {
                    int n2 = 45;
                    if (stringArray[n].length() != 1) {
                        n2 = stringArray[n].charAt(1);
                    }
                    switch (n2) {
                        case 71: 
                        case 103: {
                            bGuiRequested = true;
                            break;
                        }
                        case 87: 
                        case 119: {
                            ipWorkingDir = true;
                            inParams.setProperty("w", stringArray[n].substring(2));
                            break;
                        }
                        case 68: 
                        case 100: {
                            if (stringArray[n].toUpperCase().equals("-D")) {
                                bl2 = true;
                                break;
                            }
                            if (stringArray[n].charAt(2) == '-') {
                                DvConsole.output("\nError: invalid value following '-d'");
                                bl = true;
                                break;
                            }
                            if (bl4) {
                                DvConsole.output("\nError: '-d' option was specified twice");
                                bl = true;
                                break;
                            }
                            bl4 = true;
                            ipDump = true;
                            inParams.setProperty("d", stringArray[n].substring(2));
                            string = stringArray[n].substring(2);
                            break;
                        }
                        case 73: 
                        case 105: {
                            if (stringArray[n].toUpperCase().equals("-I")) {
                                bl2 = true;
                                break;
                            }
                            if (stringArray[n].charAt(2) == '-') {
                                DvConsole.output("\nError: invalid value following '-i'");
                                bl = true;
                                break;
                            }
                            if (bl6) {
                                DvConsole.output("\nError: '-i' option was specified twice");
                                bl = true;
                                break;
                            }
                            bl6 = true;
                            ipInput = true;
                            inParams.setProperty("i", stringArray[n].substring(2));
                            break;
                        }
                        case 79: 
                        case 111: {
                            if (stringArray[n].toUpperCase().equals("-O")) {
                                bl2 = true;
                                break;
                            }
                            if (stringArray[n].charAt(2) == '-') {
                                DvConsole.output("\nError: invalid value following '-o'");
                                bl = true;
                                break;
                            }
                            if (bl5) {
                                DvConsole.output("\nError: '-o' option was specified twice");
                                bl = true;
                                break;
                            }
                            bl5 = true;
                            ipOutput = true;
                            inParams.setProperty("o", stringArray[n].substring(2));
                            break;
                        }
                        case 116: {
                            if (stringArray[n].equals("-t")) {
                                bl2 = true;
                                break;
                            }
                            if (stringArray[n].charAt(2) == '-') {
                                DvConsole.output("\nError: invalid value following '-t'");
                                bl = true;
                                break;
                            }
                            if (bl7) {
                                DvConsole.output("\nError: '-t' option was specified twice");
                                bl = true;
                                break;
                            }
                            bl7 = true;
                            DvUtils.setVerbose(true);
                            inParams.setProperty("t", stringArray[n].substring(2));
                            break;
                        }
                        case 84: {
                            if (bl7) {
                                DvConsole.output("\nError: '-t' option was specified twice");
                                bl = true;
                                break;
                            }
                            bl7 = true;
                            DvUtils.setVerbose(true);
                            inParams.setProperty("t", stringArray[n].substring(2));
                            break;
                        }
                        case 63: 
                        case 72: 
                        case 104: {
                            bl3 = true;
                            break;
                        }
                        default: {
                            DvConsole.output("\nError: invalid option '" + stringArray[n] + "'");
                            bl = true;
                            break;
                        }
                    }
                } else {
                    DvConsole.output("\nError: options must begin with '-'");
                    bl = true;
                }
                ++n;
            }
        }
        if (bl2) {
            DvConsole.output("\nError: value required for argument '" + stringArray[stringArray.length - 1] + "'");
            bl = true;
        }
        if (bl || bl3) {
            DvConsole.output("\nUsage: jformat [[-d]dumpfilename] [other options]\n");
            DvConsole.output("where options include: ");
            DvConsole.output("       -d dumpfilename    - the dump to format");
            DvConsole.output("       -g                 - bring up Dumpviewer (gui)");
            DvConsole.output("       -o outputfilename  - output to file");
            DvConsole.output("       -i inputfilename   - input from file");
            DvConsole.output("       -t tracefilename   - trace to file");
            DvConsole.output("       -T                 - trace to console");
            DvConsole.output("       -w                 - set working directory");
            DvConsole.output("       -? or -h           - help");
            DvConsole.output(" ");
            return;
        }
        if (bGuiRequested) {
            bl4 = false;
            ipDump = false;
            Dumpviewer dumpviewer = new Dumpviewer(bl7, string);
            dumpviewer.setVisible(true);
            if (null != Dumpviewer.consoleInitOutput) {
                Dumpviewer.message_frame = Dumpviewer.theIFM.createNewFrame("Message", Dumpviewer.theIFM.getDefaultProperties() - 2, 0);
                Dumpviewer.addIFrameToDesktop(Dumpviewer.message_frame, 200, 400, 5, Dumpviewer.selfRef.getHeight() - 330);
                Dumpviewer.msg_text = new JTextArea("", 8, 25);
                Dumpviewer.msg_text.setEditable(false);
                Dumpviewer.theIFM.addContentToFrame(Dumpviewer.message_frame, Dumpviewer.msg_text);
                String string2 = "";
                int n = 0;
                while (n < Dumpviewer.consoleInitOutput.size()) {
                    string2 = string2 + (String)Dumpviewer.consoleInitOutput.get(n);
                    string2 = string2 + "\n";
                    ++n;
                }
                Dumpviewer.showMessage(string2, false);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("\nInterruptedException");
                }
                try {
                    Dumpviewer.message_frame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        } else {
            DvUtils.writetoTrace("DvConsole:main - instantiating DvConsole instance");
            DvConsole dvConsole = new DvConsole(false, null, null);
        }
    }

    public static boolean setTheDump(DvDump dvDump, Vector vector, String string) {
        Object object;
        DvProcess[] dvProcessArray;
        DvUtils.writetoTrace(" Entry to DvConsole:setTheDump (" + string + ")");
        boolean bl = false;
        theDump = dvDump;
        DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < dvAddressSpaceArray.length && !bl2) {
            dvProcessArray = dvAddressSpaceArray[n4].getProcesses();
            int n5 = 0;
            while (n5 < dvProcessArray.length && !bl2) {
                object = dvProcessArray[n5].getThreads();
                if (0 != ((DvThread[])object).length) {
                    int n6 = 0;
                    while (n6 < ((DvThread[])object).length && !bl2) {
                        if (0L != object[n6].eeAddress().getAddressAsLong()) {
                            bl2 = true;
                            n = n4;
                            n2 = n5;
                            n3 = n6;
                        }
                        ++n6;
                    }
                }
                ++n5;
            }
            ++n4;
        }
        if (bl2) {
            Object object2;
            Object object3;
            DvUtils.setValue("ASID", dvAddressSpaceArray[n].id());
            dvProcessArray = dvAddressSpaceArray[n].getProcesses();
            DvProcess dvProcess = dvProcessArray[n2];
            object = dvProcess.getThreads();
            DvUtils.setValue("PID", dvProcess.id());
            DvThread dvThread = object[n3];
            DvUtils.setValue("THREAD", dvThread.id());
            dvAddressSpaceArray[n].getMemRanges();
            DvUtils.setValue("DUMP", string);
            DvEnvData dvEnvData = null;
            dvEnvData = dvProcess.getEnvData();
            if (null != dvEnvData) {
                String string2 = dvEnvData.javaVersion();
                object3 = DvUtils.getCtypeFile(theDump, string2);
                if (object3 != null) {
                    // empty if block
                }
            } else {
                DvUtils.writetoTrace(" !!! EnvData is null !!!");
            }
            boolean bl3 = false;
            object3 = dvDump.getCTypedefs();
            bl3 = true;
            if (object3 != null) {
                object2 = new CTypeFile((byte[])object3);
                if (object2 != null) {
                    bl3 = true;
                    vector.add("Using typedefs from core...");
                }
            } else {
                bl3 = DvUtils.loadFormatFile(vector);
            }
            if (!bl3) {
                vector.add(" !!! Error establishing format file        !!!");
                vector.add(" !!! Use SET FORMATFILE= command and retry !!!");
                return bl;
            }
            bl = true;
            object2 = dvAddressSpaceArray[n].createAddress(dvThread.eeAddress().getAddressAsLong());
            if (DvUtils.checkAddressInDump((DvAddress)object2, dvAddressSpaceArray[n])) {
                CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpaceArray[n], (DvAddress)object2, "execenv");
                if (null != cTypeObject) {
                    CTypeObject cTypeObject2 = cTypeObject.getField("jvmP");
                    if (null != cTypeObject2) {
                        String string3 = cTypeObject2.toString();
                        if (string3.startsWith("null ")) {
                            string3 = string3.substring(5);
                        }
                        if (string3.startsWith("(null) ")) {
                            string3 = string3.substring(7);
                        }
                        string3 = DvUtils.removeAtSign(string3);
                        string3 = DvUtils.remove0x(string3);
                        DvAddress dvAddress = null;
                        DvAddress dvAddress2 = null;
                        boolean bl4 = true;
                        try {
                            dvAddress2 = dvAddressSpaceArray[n].createAddress(DvUtils.hexToLong(string3));
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl4 = false;
                            DvUtils.writetoTrace(" DvConsole:setTheDump -String returned for jvmP_cTO is:<<" + string3 + ">>");
                            vector.add("\n jvmP addressing failure");
                        }
                        CTypeObject cTypeObject3 = null;
                        if (bl4) {
                            block40: {
                                try {
                                    dvAddress = dvAddressSpaceArray[n].readPointer(dvAddress2);
                                }
                                catch (DvAddressException dvAddressException) {
                                    if (null == vector) break block40;
                                    vector.add("\n jvmP addressing failure");
                                }
                            }
                            if (null != dvAddress) {
                                cTypeObject3 = DvUtils.formatAddrAsType(dvAddressSpaceArray[n], dvAddress, "Jvm");
                            }
                        }
                        if (null != cTypeObject3) {
                            DvUtils.setupJVMHints(cTypeObject3, dvAddress.getAddressAsLong(), dvAddressSpaceArray[n]);
                        } else if (null != vector) {
                            vector.add(" Unable to format Jvm!");
                        }
                    } else if (null != vector) {
                        vector.add(" Unable to get jvmP!");
                    }
                }
            } else {
                DvUtils.writetoTrace(" execenv was 0");
                vector.add(" execenv was 0!");
            }
        } else {
            vector.add("*** !!!!!!!!!!!!!!!!!!!!!!!!!! ***");
            vector.add(" No Java threads found in dump !!!");
            vector.add("*** !!!!!!!!!!!!!!!!!!!!!!!!!! ***");
        }
        sanityCheckVector.clear();
        if (!DvConsole.sanityCheck(sanityCheckVector)) {
            vector.add("\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\nSanity check failure.\nSanity check output follows.\nCould be: \n    a corrupted dump or ...\n    mismatch between types file and dump level\n \nFurther investigation suggested.\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            int n7 = 0;
            while (n7 < sanityCheckVector.size()) {
                vector.add(sanityCheckVector.get(n7));
                ++n7;
            }
        } else {
            vector.add("\nSanity check passed (use \"SANCHK\" for details)");
        }
        int n8 = jvmsInDump.size();
        if (0 == n8) {
            vector.add("\n*********!!! WARNING !!!**************************\n*   No jvms were uncovered in this dump   \n*\n*   Highly likely that futher errors will occur! \n*********!!! WARNING !!!**************************");
        }
        if (n8 > 1) {
            vector.add("\n******* JVM Sets detected *************\n*\n* " + n8 + " Jvms found" + "\n* \"SET\" will display information    " + "\n* on which JVM is currently targetted " + "\n* and what JVMs are available.        " + "\n* \"set jvm\" may also be useful.     " + "\n******* JVM Sets detected ************");
        }
        if (1 == n8) {
            vector.add("\nStandalone JVM found at 0x" + Long.toHexString((Long)jvmsInDump.get(0)));
        }
        if (n8 > 0) {
            int n9 = 0;
            while (n9 < n8) {
                object = "JVM#" + (n9 + 1);
                String string4 = Long.toHexString((Long)jvmsInDump.get(n9));
                DvUtils.setValue((String)object, string4);
                ++n9;
            }
            DvUtils.setValue("CURRJVM", Long.toHexString((Long)jvmsInDump.get(0)));
        } else {
            DvUtils.setValue("CURRJVM", "-1");
        }
        DvUtils.writetoTrace(" Exit from DvConsole:setTheDump");
        return bl;
    }

    private static void showHelp(String string) {
        String string2;
        String string3;
        String string4;
        block7: {
            DvUtils.writetoTrace("DvConsole:showHelp entry");
            string4 = null;
            string3 = "";
            string2 = null;
            if (null == myHelpProps) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(".\\DvGenericHelp.properties");
                    myHelpProps = new Properties();
                    myHelpProps.load(fileInputStream);
                }
                catch (IOException iOException) {
                    String string5 = System.getProperty("file.separator");
                    String string6 = "com" + string5 + "ibm" + string5 + "jvm" + string5 + "dump" + string5 + "DvGenericHelp.properties";
                    myHelpProps = DvUtils.searchClassPathForPropFile(string6);
                    if (null != myHelpProps) break block7;
                    string6 = "DvGenericHelp.properties";
                    myHelpProps = DvUtils.searchClassPathForPropFile(string6);
                }
            }
        }
        if (null != myHelpProps) {
            myPropsEnum = myHelpProps.propertyNames();
            int n = 1;
            while (n < 999) {
                string4 = string + n;
                string2 = myHelpProps.getProperty(string4);
                if (null != string2) {
                    string3 = string3 + string2;
                } else {
                    n = 999;
                }
                ++n;
            }
        }
        DvConsole.output(string3);
        DvUtils.writetoTrace("DvConsole:showHelp exit");
    }

    public void execValidCommand(String string) {
        DvUtils.writetoTrace("DvConsole:execValidCommand entry (" + string + ")");
        ValidCmd validCmd = new ValidCmd(string);
        this.execCmd(validCmd, false);
        DvUtils.writetoTrace("DvConsole:execValidCommand exit");
    }

    private static ValidCmd validate(String string) {
        ValidCmd validCmd = new ValidCmd(string);
        return validCmd;
    }

    private static void output(String string) {
        if (useOutputVector) {
            if (outputVector == null || string == null) {
                String string2 = "***ERROR*** Either output vector or object does not exist!\n" + string;
                DvUtils.output(string2);
            } else {
                outputVector.add(string);
            }
        } else {
            DvUtils.output(string);
        }
    }

    public void execCmdWithWait(ValidCmd validCmd, boolean bl) {
        boolean bl2 = false;
        while (!bl2) {
            if (null != currentCP && DvConsole.currentCP.cpInProgress) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
                continue;
            }
            this.execCmd(validCmd, bl);
            bl2 = true;
        }
    }

    public void execCmd(ValidCmd validCmd, boolean bl) {
        block27: {
            block26: {
                boolean bl2 = false;
                if (!validCmd.isNonPlugin) break block26;
                switch (validCmd.mainVerbOne) {
                    case '!': {
                        if (null != currentCP) {
                            currentCP.setForcedEnd(true);
                        }
                        break block27;
                    }
                    case '+': {
                        this.doPlusMinus(true);
                        break block27;
                    }
                    case '-': {
                        this.doPlusMinus(false);
                        break block27;
                    }
                    case '*': {
                        DvConsole.output(validCmd.savedCmd);
                        break block27;
                    }
                    case 'Q': {
                        System.exit(0);
                        break block27;
                    }
                    case 'E': {
                        this.execExecuteCmd(validCmd.modifier);
                        break block27;
                    }
                    default: {
                        if (null != currentCP && DvConsole.currentCP.cpInProgress) {
                            this.doSingleOutput("\n Unable to execute " + validCmd.savedCmd + "\n .. last command still in progress\n");
                            return;
                        }
                        break block27;
                    }
                }
            }
            if (null != currentCP && DvConsole.currentCP.cpInProgress) {
                this.doSingleOutput("\n Unable to execute " + validCmd.savedCmd + "\n .. last command still in progress\n");
                return;
            }
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            String string = " ";
            if (validCmd.bDumpOpenRqd && null == theDump) {
                bl3 = false;
                string = string + "\nUnable to run this command until dump identified (set dump=)";
            }
            if (validCmd.bHeapTraverseRqd && !DvObjectsCommands.heapsAlreadyTraversed()) {
                bl3 = false;
                string = string + "\nUnable to run this command until heaps traversed (dis os)";
            }
            if (bl3) {
                Class clazz = null;
                Method method = null;
                CommandPlugin commandPlugin = (CommandPlugin)commandPlugins.get(validCmd.pluginID);
                try {
                    clazz = commandPlugin.getClass();
                    method = clazz.getMethod(validCmd.method, new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!runningUnderGUI) {
                        this.doSingleOutput("\n ***** Error *****\n Expected method (" + validCmd.method + ") not found in " + clazz.getName() + "\n ***** Error *****\n");
                    }
                    return;
                }
                try {
                    currentCP = (CommandPlugin)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    System.err.println(" InstantiationException");
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println(" IllegalAccessException");
                }
                currentCP.setMethod(method);
                currentCP.setVerb(validCmd.mainVerb);
                currentCP.setParamString(validCmd.params);
                if (null != validCmd.enhancersString) {
                    currentCP.setEnhancers(validCmd.enhancersString);
                }
                currentCP.setVerbModifier(validCmd.modifier);
                currentCP.setSeperator(validCmd.seperator);
                currentCP.setForcedEnd(false);
                currentCP.setAddReady(bl);
                currentCP.setTheDump(theDump);
                if (!runningUnderGUI) {
                    currentCP.addObserverToResponse(this);
                } else {
                    currentCP.addObserverToResponse(theGUI);
                }
                try {
                    currentCP.start();
                }
                catch (Exception exception) {
                    System.err.println("\n!!! Exception !!!");
                }
            } else {
                this.doSingleOutput(string);
            }
        }
    }

    private boolean execExecuteCmd(String string) {
        boolean bl = false;
        String string2 = null;
        BufferedReader bufferedReader = null;
        int n = 0;
        string = string.trim();
        DvConsole.output("Will try and execute " + string + "!");
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            DvConsole.output("File " + string + " not found");
        }
        if (null != bufferedReader) {
            boolean bl2 = false;
            while (!bl2) {
                try {
                    string2 = bufferedReader.readLine();
                    if (null != string2) {
                        string2 = this.preProcessInput(string2);
                        DvConsole.output("\n Execute(" + string + ":" + ++n + "): " + string2 + "\n");
                    }
                    if (null == string2) {
                        bl2 = true;
                        continue;
                    }
                    ValidCmd validCmd = DvConsole.validate(string2);
                    if (validCmd.errorPos == 0) {
                        this.execCmd(validCmd, false);
                        while (DvConsole.currentCP.cpInProgress) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    System.err.println("Error pos is" + validCmd.errorPos);
                    String string3 = "Invalid Command - possible reasons:";
                    string3 = string3 + "\n An expected plugin was not found";
                    string3 = string3 + "\n .... what else ?????";
                    System.err.println(string3);
                }
                catch (IOException iOException) {
                    bl2 = true;
                }
            }
        }
        return bl;
    }

    public static String[] execValidCmdToArray(String string) {
        String[] stringArray = that.doExecValidCmdToArray(string);
        return stringArray;
    }

    private String[] doExecValidCmdToArray(String string) {
        outputVector = new Vector();
        useOutputVector = true;
        Class clazz = null;
        Method method = null;
        ValidCmd validCmd = new ValidCmd(string);
        CommandPlugin commandPlugin = (CommandPlugin)commandPlugins.get(validCmd.pluginID);
        try {
            clazz = commandPlugin.getClass();
            method = clazz.getMethod(validCmd.method, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("***** Error *****\nExpected method " + validCmd.method + " not found in " + clazz.getName() + "\n" + "***** Error *****\n");
            String[] stringArray = new String[]{"***ERROR***"};
            return stringArray;
        }
        try {
            childCP = (CommandPlugin)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            System.err.println(" InstantiationException");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(" IllegalAccessException");
        }
        childCP.setMethod(method);
        childCP.setVerb(validCmd.mainVerb);
        childCP.setParamString(validCmd.params);
        if (null != validCmd.enhancersString) {
            childCP.setEnhancers(validCmd.enhancersString);
        }
        childCP.setVerbModifier(validCmd.modifier);
        childCP.setSeperator(validCmd.seperator);
        childCP.setForcedEnd(false);
        childCP.setTheDump(theDump);
        childCP.addObserverToResponse(this);
        try {
            childCP.start();
        }
        catch (Exception exception) {
            System.err.println("\n!!! Exception !!!");
        }
        while (childCP.getInProgress()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("\nInterruptedException");
            }
        }
        useOutputVector = false;
        String[] stringArray = new String[outputVector.size() + 1];
        Enumeration enumeration = outputVector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        outputVector = null;
        return stringArray;
    }

    public void update(Observable observable, Object object) {
        DvUtils.writetoTrace("Entry DvConsole:output");
        Observable observable2 = observable;
        synchronized (observable2) {
            this.doSingleOutput(object);
        }
        DvUtils.writetoTrace("Exit DvConsole:output");
    }

    private void doSingleOutput(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = 0;
            while (n < vector.size()) {
                this.doSingleOutput(vector.get(n));
                ++n;
            }
        } else if (object instanceof Array) {
            Array array = (Array)object;
            int n = 0;
            while (n < Array.getLength(array)) {
                this.doSingleOutput(Array.get(array, n));
                ++n;
            }
        } else if (object instanceof String) {
            String string = (String)object;
            DvConsole.output(string);
        } else if (null != object) {
            DvConsole.output(object.toString());
        } else {
            DvConsole.output(" --- null --- ");
        }
    }

    private void doPlusMinus(boolean bl) {
        if (null != lastMemCommandPosition) {
            long l = DvUtils.hexToLong(lastMemCommandPosition);
            l = bl ? (l += (long)lastMemCommandLength) : (l -= (long)lastMemCommandLength);
            String string = "dis mem(" + Long.toHexString(l) + "," + lastMemCommandLength + ")";
            this.doSingleOutput(string);
            ValidCmd validCmd = DvConsole.validate(string);
            this.execCmd(validCmd, false);
        } else {
            this.doSingleOutput("\n No previous dis mem command found\n");
        }
    }

    private String preProcessInput(String string) {
        int n;
        String string2 = " ";
        String string3 = new String(string);
        string3 = " " + string3 + " ";
        while (-1 != string3.indexOf("~")) {
            n = string3.indexOf("~");
            String string4 = System.getProperty("user.home");
            if (null == string4) {
                string4 = "???";
            }
            String string5 = string3.substring(0, n);
            String string6 = string3.substring(n + 1);
            string3 = string5 + "^" + string4 + string6;
        }
        n = 0;
        boolean bl = false;
        while (!bl) {
            int n2 = string3.length();
            int n3 = 0;
            boolean bl2 = false;
            n3 = n2;
            while (n3 > 0 && !bl2) {
                if (string3.charAt(n3 - 1) == '$') {
                    boolean bl3 = false;
                    int n4 = 0;
                    n4 = n3;
                    while (n4 < n2 && !bl3) {
                        char c = string3.charAt(n4);
                        if (c == ' ' || c == ',' || c == '(' || c == ')' || c == '=' || c == '^') {
                            bl3 = true;
                        }
                        ++n4;
                    }
                    if (n4 == n3) {
                        DvUtils.writetoTrace(" Invalid command format (command substitution)");
                        bl = true;
                        n = 1;
                        bl2 = true;
                    } else {
                        String string7 = string3.substring(n3, n4 - 1);
                        String string8 = DvUtils.getValue(string7);
                        if (null == string8) {
                            bl = true;
                            n = 1;
                            bl2 = true;
                        } else {
                            String string9 = string3.substring(0, n3 - 1);
                            String string10 = string3.substring(n3 + string7.length());
                            string3 = string9.endsWith("$") ? string9 + string8 + string10 : string9 + "^" + string8 + string10;
                        }
                        bl2 = true;
                    }
                }
                --n3;
            }
            if (n3 != 0) continue;
            bl = true;
        }
        if (1 == n) {
            return string;
        }
        int n5 = 0;
        while (n5 < string3.length()) {
            if (string3.charAt(n5) != '^') {
                string2 = string2 + string3.charAt(n5);
            }
            ++n5;
        }
        string2 = string2.trim();
        return string2;
    }

    public static boolean sanityCheck(Vector vector) {
        boolean bl = true;
        DvAddressSpace[] dvAddressSpaceArray = theDump.getAddressSpaces();
        int n = dvAddressSpaceArray.length;
        int n2 = 0;
        while (n2 < n && bl) {
            String string = dvAddressSpaceArray[n2].id();
            DvProcess[] dvProcessArray = dvAddressSpaceArray[n2].getProcesses();
            int n3 = 0;
            while (n3 < dvProcessArray.length && bl) {
                String string2 = dvProcessArray[n3].id();
                DvThread[] dvThreadArray = dvProcessArray[n3].getThreads();
                int n4 = 0;
                while (n4 < dvThreadArray.length) {
                    String string3 = dvThreadArray[n4].id();
                    String string4 = " (as=" + string + " pr=" + string2 + " thread= " + string3 + ") ";
                    if (dvThreadArray[n4].isJava()) {
                        long l = dvThreadArray[n4].eeAddress().getAddressAsLong();
                        DvAddress dvAddress = dvAddressSpaceArray[n2].createAddress(l);
                        if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpaceArray[n2])) {
                            vector.add("execenv 0x" + Long.toHexString(l) + string4 + "is in memory");
                            if (!DvConsole.sanityCheckJVM(vector, dvAddress, dvAddressSpaceArray[n2], dvThreadArray[n4])) {
                                bl = false;
                            }
                        } else {
                            vector.add("execenv 0x" + Long.toHexString(l) + string4 + "is !!! NOT !!! in memory");
                            bl = false;
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        return bl;
    }

    private static boolean sanityCheckJVM(Vector vector, DvAddress dvAddress, DvAddressSpace dvAddressSpace, DvThread dvThread) {
        boolean bl = true;
        CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "execenv");
        if (null != cTypeObject) {
            long l = DvUtils.jvmFromExecenv(dvAddressSpace, dvAddress);
            DvAddress dvAddress2 = new DvAddress(l);
            if (DvUtils.checkAddressInDump(dvAddress2, dvAddressSpace)) {
                vector.add("   ... and this is at a valid memory address");
                boolean bl2 = false;
                int n = 0;
                while (n < jvmsInDump.size() && !bl2) {
                    long l2 = (Long)jvmsInDump.get(n);
                    if (l2 == l) {
                        bl2 = true;
                    }
                    ++n;
                }
                if (!bl2) {
                    if (!DvConsole.checkJVMEyeCatchers(vector, dvAddress2, dvAddressSpace)) {
                        bl = false;
                    }
                    jvmsInDump.add(new Long(l));
                    jvmsInDumpAs.add(dvAddressSpace);
                    jvmsInDumpThread.add(dvThread);
                } else {
                    vector.add("   ... has same jvmP as a previous one (0x" + Long.toHexString(l) + ")");
                }
            } else {
                bl = false;
                vector.add("   ... and this is !!! NOT !!! at a valid memory address");
            }
        } else {
            bl = false;
            vector.add("  .... Problem formatting execenv");
        }
        return bl;
    }

    private static boolean checkJVMEyeCatchers(Vector vector, DvAddress dvAddress, DvAddressSpace dvAddressSpace) {
        boolean bl = true;
        String[] stringArray = new String[]{"MAIN", "MAIN", "lk", "LOCK", "dg", "DIAG", "st", "STOR", "xm", "XMGT", "xe", "XENG", "cl", "CLAS", "ci", "CORE"};
        CTypeObject cTypeObject = new CTypeObject("Jvm", dvAddress, dvAddressSpace);
        CTypeObject cTypeObject2 = cTypeObject.getField("facade");
        long l = cTypeObject2.getAddr();
        vector.add("   ... has facade at 0x" + Long.toHexString(l));
        if (DvUtils.runningSystemIsEBCDIC()) {
            vector.add("   ... running DvConsole on an ebcdic based runtime system");
        } else {
            vector.add("   ... running DvConsole on an ascii based runtime system");
        }
        int n = 0;
        while (n < stringArray.length) {
            Object object;
            String string = stringArray[n];
            String string2 = stringArray[n + 1];
            CTypeObject cTypeObject3 = null;
            CTypeObject cTypeObject4 = null;
            if (0 == n) {
                cTypeObject4 = cTypeObject.getField("header");
            } else {
                object = cTypeObject2.getField(string);
                cTypeObject4 = ((CTypeObject)object).getField("header");
            }
            cTypeObject3 = cTypeObject4.getField("eyecatcher");
            try {
                object = dvAddressSpace.readBytes(dvAddressSpace.createAddress(cTypeObject3.getAddr()), (long)string2.length());
                String string3 = null;
                if (4 != theDump.getSystemType() && DvUtils.runningSystemIsEBCDIC()) {
                    try {
                        string3 = new String((byte[])object, "ascii");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string3 = new String((byte[])object);
                    }
                } else if (4 == theDump.getSystemType()) {
                    try {
                        string3 = new String((byte[])object, "Cp500");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new Error("No Cp500, cannot continue");
                    }
                } else {
                    string3 = new String((byte[])object);
                }
                if (string3.equals(string2)) {
                    vector.add("   ... " + string + " had expected eyecatcher (" + stringArray[n + 1] + ")");
                } else {
                    vector.add("   ... " + string + " had \"" + string3 + "\" rather than the expected eyecatcher (" + string2 + ")");
                    bl = false;
                }
            }
            catch (DvAddressException dvAddressException) {
                bl = false;
                vector.add("   ... unable to read MAIN eyecatcher memory");
            }
            n += 2;
        }
        return bl;
    }

    public static Vector getCommandPluginVector() {
        return commandPlugins;
    }

    public static CommandPlugin getCurrentCP() {
        return currentCP;
    }

    public static DvDump getCurrentDump() {
        return theDump;
    }

    public static int getCurrentAsIndex() {
        return currASIndex;
    }

    public static int getCurrentProcessIndex() {
        return currProcessIndex;
    }

    public static int getCurrentThreadIndex() {
        return currThreadIndex;
    }

    public static void setLastDisMem(String string, int n) {
        lastMemCommandPosition = string;
        lastMemCommandLength = n;
    }

    public static PrintStream getOriginal_output() {
        return original_output;
    }

    public static PrintStream getOriginal_error() {
        return original_error;
    }

    public static Vector getJvmsInDump() {
        return jvmsInDump;
    }

    public static DvAddressSpace getJvmsInDumpAs(int n) {
        return (DvAddressSpace)jvmsInDumpAs.get(n);
    }

    public static DvThread getFirstThreadForJVM(int n) {
        return (DvThread)jvmsInDumpThread.get(n);
    }

    static {
        bSystemErrTrace = false;
        bGuiRequested = false;
        original_output = System.out;
        original_error = System.err;
        cmdList = new Vector();
        commandPlugins = new Vector();
        fastPath = new Vector();
        currDump = null;
        myHelpProps = null;
        currASIndex = 0;
        currProcessIndex = 0;
        currThreadIndex = 0;
        currentClassSpecs = new Vector();
        currentCBSpecs = new Vector();
        currWidth = 80;
        currOffset = (char)78;
        echoOn = false;
        ipDump = false;
        ipInput = false;
        ipOutput = false;
        ipWorkingDir = false;
        runningUnderGUI = false;
        theGUI = null;
        outputVector = null;
        useOutputVector = false;
        that = null;
        sanityCheckVector = new Vector();
        bHeapTraversalInprogress = false;
        jvmsInDump = new Vector();
        jvmsInDumpAs = new Vector();
        jvmsInDumpThread = new Vector();
    }

    static class ValidCmd {
        public int errorPos = 1;
        public String mainVerb;
        public int pluginID = -1;
        public boolean isNonPlugin = false;
        public String seperator = null;
        public String savedCmd;
        public char mainVerbOne;
        public String restOfInput = null;
        public String params = null;
        public String modifier = null;
        public String method = null;
        public String enhancersString = null;
        public boolean bDumpOpenRqd = false;
        public boolean bHeapTraverseRqd = false;

        public ValidCmd(String string) {
            this.savedCmd = string.trim();
            String string2 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(this.savedCmd);
            try {
                string2 = stringTokenizer.nextToken();
                this.mainVerb = string2.toUpperCase();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.mainVerb = null;
            }
            if (this.mainVerb != null) {
                int n;
                this.mainVerbOne = this.mainVerb.charAt(0);
                this.seperator = null;
                if (stringTokenizer.hasMoreTokens()) {
                    this.restOfInput = string.substring(this.mainVerb.length()).trim();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(this.restOfInput, "=( ");
                    this.modifier = stringTokenizer2.nextToken();
                    this.modifier = this.modifier.trim();
                    this.restOfInput = this.restOfInput.substring(this.modifier.length()).trim();
                    this.seperator = " ";
                    if (this.restOfInput.startsWith("=")) {
                        this.seperator = "=";
                        this.restOfInput = this.restOfInput.substring(1);
                    }
                    if (this.restOfInput.startsWith("(")) {
                        this.seperator = "(";
                        this.restOfInput = this.restOfInput.substring(1);
                    }
                    if (stringTokenizer2.hasMoreTokens()) {
                        this.params = this.restOfInput;
                        if (this.seperator.equals("(")) {
                            if (this.params.endsWith(")")) {
                                this.params = this.params.substring(0, this.params.length() - 1);
                            } else {
                                n = this.params.indexOf(41);
                                if (-1 == n) {
                                    this.errorPos = this.params.length() + this.mainVerb.length() + this.modifier.length() + 2;
                                    return;
                                }
                                this.enhancersString = this.params.substring(n + 1);
                                this.params = this.params.substring(0, n);
                            }
                        }
                    }
                }
                switch (this.mainVerbOne) {
                    case '!': {
                        this.isNonPlugin = true;
                        this.errorPos = 0;
                        break;
                    }
                    case '+': 
                    case '-': {
                        this.isNonPlugin = true;
                        this.errorPos = 0;
                        break;
                    }
                    case '*': {
                        this.isNonPlugin = true;
                        this.errorPos = 0;
                        break;
                    }
                    case 'Q': {
                        if (!this.mainVerb.equals("Q") && !this.mainVerb.equals("QUIT")) break;
                        this.isNonPlugin = true;
                        this.errorPos = 0;
                        break;
                    }
                    case 'E': {
                        if (!this.mainVerb.equals("E") && !this.mainVerb.equals("EXEC") && !this.mainVerb.equals("EXECUTE")) break;
                        this.isNonPlugin = true;
                        this.errorPos = 0;
                        break;
                    }
                    default: {
                        this.errorPos = 1;
                    }
                }
                if (0 != this.errorPos) {
                    this.isNonPlugin = false;
                    boolean bl = false;
                    n = 0;
                    int n2 = -1;
                    DvCommand dvCommand = null;
                    int n3 = 0;
                    while (n3 < cmdList.size() && n2 == -1) {
                        dvCommand = (DvCommand)cmdList.get(n3);
                        if (this.mainVerb.equals(dvCommand.verb) || this.mainVerb.equals(dvCommand.verbShort)) {
                            bl = true;
                            if (this.modifier == null && dvCommand.modifier == null || this.modifier != null && this.modifier.toUpperCase().equals(dvCommand.modifier) || this.modifier != null && this.modifier.toUpperCase().equals(dvCommand.modifierShort)) {
                                n2 = dvCommand.index;
                                this.pluginID = dvCommand.index;
                                this.method = dvCommand.method;
                                this.errorPos = 0;
                                n = 1;
                                this.bDumpOpenRqd = dvCommand.bDumpOpen;
                                this.bHeapTraverseRqd = dvCommand.bHeapTraversed;
                            }
                        }
                        ++n3;
                    }
                    int n4 = 0;
                    while (n4 < cmdList.size() && n2 == -1) {
                        dvCommand = (DvCommand)cmdList.get(n4);
                        if (this.mainVerb.equals(dvCommand.verb) || this.mainVerb.equals(dvCommand.verbShort)) {
                            bl = true;
                            if (this.modifier == null && dvCommand.modifier == null || this.modifier != null && this.modifier.toUpperCase().equals(dvCommand.modifier) || this.modifier != null && this.modifier.toUpperCase().equals(dvCommand.modifierShort) || null != dvCommand.modifier && dvCommand.modifier.equals("*")) {
                                n2 = dvCommand.index;
                                this.pluginID = dvCommand.index;
                                this.method = dvCommand.method;
                                this.errorPos = 0;
                                n = 1;
                                this.bDumpOpenRqd = dvCommand.bDumpOpen;
                                this.bHeapTraverseRqd = dvCommand.bHeapTraversed;
                            }
                        }
                        ++n4;
                    }
                    if (bl) {
                        if (0 == n && null != this.modifier) {
                            this.errorPos = this.savedCmd.indexOf(this.modifier.trim()) + 1;
                        }
                    } else {
                        this.errorPos = 1;
                    }
                }
            }
        }
    }

    public class DvCommand {
        String verb = null;
        String verbShort = null;
        String modifier = null;
        String modifierShort = null;
        String method = null;
        boolean bDumpOpen = false;
        boolean bHeapTraversed = false;
        int index;

        public DvCommand(String string, int n) {
            this.index = n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (5 != stringTokenizer.countTokens() && 7 != stringTokenizer.countTokens()) {
                System.err.println("!!!Bad command definition!!! " + string);
            } else {
                this.verb = stringTokenizer.nextToken().toUpperCase();
                this.verbShort = stringTokenizer.nextToken().toUpperCase();
                this.modifier = stringTokenizer.nextToken().toUpperCase();
                if (this.modifier.equals(" ")) {
                    this.modifier = null;
                }
                this.modifierShort = stringTokenizer.nextToken().toUpperCase();
                if (this.modifierShort.equals(" ")) {
                    this.modifierShort = null;
                }
                this.method = stringTokenizer.nextToken();
                if (2 == stringTokenizer.countTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    if (string2.toUpperCase().startsWith("Y")) {
                        this.bDumpOpen = true;
                    }
                    if (string3.toUpperCase().startsWith("Y")) {
                        this.bHeapTraversed = true;
                    }
                }
            }
        }
    }
}

