/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class DvFileHistory {
    private static final int MAX_ITEM_LEN = 50;
    private static final String FILE_SEPARATOR_STR = System.getProperty("file.separator");
    private static String historySerFile;
    private static int max_itemnames;
    private static ArrayList itemnameHistory;
    private static ArrayList pathnameHistory;
    private static String formatFileName;
    private static String workDir;
    private IFileHistory caller;

    public DvFileHistory(IFileHistory iFileHistory) {
        this.caller = iFileHistory;
        historySerFile = System.getProperty("user.home") + FILE_SEPARATOR_STR + iFileHistory.getApplicationName() + "_FILE_HISTORY.cfg";
        String string = System.getProperty("itemnames.max", "9");
        try {
            max_itemnames = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(numberFormatException);
            numberFormatException.printStackTrace();
            System.exit(1);
        }
        if (max_itemnames < 1) {
            max_itemnames = 9;
        }
    }

    public final void initFileMenuHistory() {
        JMenu jMenu = this.caller.getFileMenu();
        if (new File(historySerFile).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(historySerFile);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                int n = 0;
                try {
                    n = objectInputStream.readInt();
                }
                catch (IOException iOException) {
                    formatFileName = (String)objectInputStream.readObject();
                    try {
                        n = objectInputStream.readInt();
                    }
                    catch (IOException iOException2) {
                        workDir = (String)objectInputStream.readObject();
                        n = objectInputStream.readInt();
                    }
                }
                if (n > max_itemnames) {
                    n = max_itemnames;
                }
                if (n > 0) {
                    jMenu.addSeparator();
                }
                int n2 = 0;
                while (n2 < n) {
                    itemnameHistory.add((String)objectInputStream.readObject());
                    pathnameHistory.add((String)objectInputStream.readObject());
                    MenuItemWithFixedTooltip menuItemWithFixedTooltip = new MenuItemWithFixedTooltip(n2 + 1 + ": " + (String)itemnameHistory.get(n2));
                    menuItemWithFixedTooltip.setToolTipText((String)pathnameHistory.get(n2));
                    menuItemWithFixedTooltip.addActionListener(new ItemListener(n2));
                    jMenu.add(menuItemWithFixedTooltip);
                    ++n2;
                }
                objectInputStream.close();
                fileInputStream.close();
            }
            catch (Exception exception) {
                System.err.println("Trouble reading file history entries: " + exception);
                exception.printStackTrace();
            }
        }
    }

    public void saveHistoryEntries() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(historySerFile);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            int n = itemnameHistory.size();
            objectOutputStream.writeObject(formatFileName);
            objectOutputStream.writeObject(workDir);
            objectOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                objectOutputStream.writeObject((String)itemnameHistory.get(n2));
                objectOutputStream.writeObject((String)pathnameHistory.get(n2));
                ++n2;
            }
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Trouble saving file history entries: " + exception);
            exception.printStackTrace();
        }
    }

    public final void insertPathname(String string) {
        int n;
        JMenu jMenu = this.caller.getFileMenu();
        int n2 = 0;
        while (n2 < pathnameHistory.size()) {
            if (((String)pathnameHistory.get(n2)).equals(string)) {
                int n3 = jMenu.getItemCount() - itemnameHistory.size() + n2;
                jMenu.remove(n3);
                pathnameHistory.remove(n2);
                itemnameHistory.remove(n2);
                if (itemnameHistory.isEmpty()) {
                    jMenu.remove(n3 - 1);
                }
                this.insertPathname(string);
                return;
            }
            ++n2;
        }
        if (itemnameHistory.isEmpty()) {
            jMenu.addSeparator();
        } else {
            n = jMenu.getItemCount() - 1;
            int n4 = 0;
            while (n4 < itemnameHistory.size()) {
                jMenu.remove(n);
                --n;
                ++n4;
            }
        }
        if (itemnameHistory.size() == max_itemnames) {
            itemnameHistory.remove(max_itemnames - 1);
            pathnameHistory.remove(max_itemnames - 1);
        }
        itemnameHistory.add(0, this.getItemname(string));
        pathnameHistory.add(0, string);
        n = 0;
        while (n < itemnameHistory.size()) {
            MenuItemWithFixedTooltip menuItemWithFixedTooltip = new MenuItemWithFixedTooltip(n + 1 + ": " + (String)itemnameHistory.get(n));
            menuItemWithFixedTooltip.setToolTipText((String)pathnameHistory.get(n));
            menuItemWithFixedTooltip.addActionListener(new ItemListener(n));
            jMenu.add(menuItemWithFixedTooltip);
            ++n;
        }
    }

    public String getFFName() {
        return formatFileName;
    }

    public void setFFName(String string) {
        formatFileName = string;
    }

    public String getWDName() {
        return workDir;
    }

    public void setWDName(String string) {
        workDir = string;
    }

    protected String getItemname(String string) {
        char c = FILE_SEPARATOR_STR.charAt(0);
        int n = string.length();
        if (n <= 50) {
            return string;
        }
        if (string.indexOf(FILE_SEPARATOR_STR) == string.lastIndexOf(FILE_SEPARATOR_STR)) {
            return string;
        }
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= n - 44) {
            if (string.charAt(n3) == c) {
                n2 = n3;
            }
            --n3;
        }
        if (n2 > 0) {
            return string.substring(0, 3) + ".." + string.substring(n2, n);
        }
        return string.substring(0, 3) + ".." + FILE_SEPARATOR_STR + ".." + string.substring(n - 44, n);
    }

    static {
        itemnameHistory = new ArrayList(max_itemnames);
        pathnameHistory = new ArrayList(max_itemnames);
        formatFileName = "";
        workDir = "";
    }

    private final class ItemListener
    implements ActionListener {
        int itemNbr;

        ItemListener(int n) {
            this.itemNbr = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DvFileHistory.this.caller.loadFile((String)pathnameHistory.get(this.itemNbr));
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            DvFileHistory.this.insertPathname(jMenuItem.getToolTipText());
        }
    }

    private final class MenuItemWithFixedTooltip
    extends JMenuItem {
        public MenuItemWithFixedTooltip(String string) {
            super(string);
        }

        public Point getToolTipLocation(MouseEvent mouseEvent) {
            Graphics graphics = this.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            String string = itemnameHistory.size() <= 9 ? "8: " : "88: ";
            int n = fontMetrics.stringWidth(string);
            int n2 = 20 + n;
            return new Point(n2, 0);
        }
    }

    public static interface IFileHistory {
        public String getApplicationName();

        public JMenu getFileMenu();

        public void loadFile(String var1);
    }
}

