/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvUtils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Vector;

public class DvNamesIndexFile
extends RandomAccessFile {
    private static int ptrLength;
    private static String file_name;
    private static IndexHeader IH;
    private static RandomAccessFile self;
    private static long[] indexArray;
    private static long next_record_pos;
    private static int index_table_size;
    private long saved_next_position = 0L;
    private long savedMagic = 0L;

    /*
     * Enabled aggressive block sorting
     */
    public DvNamesIndexFile(String string, String string2, int n, int n2, int n3, long l) throws IOException {
        super(string, string2);
        self = this;
        this.initPtrLength();
        if (!string2.equals("r")) {
            DvNamesIndexFile.initTheIndex(n, n2, n3, 0L);
            this.savedMagic = l;
            return;
        }
        IH = IndexHeader.readExistingHeader();
        if (IndexHeader.magic != l) {
            System.err.println("\n Existing index file invalid/incomplete ...\n ... previous creation may have failed (disk space problems?) ...\n ... will attempt recreation\n");
            throw new IOException("Index file is incomplete");
        }
        this.seek(IndexHeader.index_ptr);
        indexArray = new long[IndexHeader.index_table_size];
        int n4 = 0;
        while (n4 < IndexHeader.index_table_size) {
            DvNamesIndexFile.indexArray[n4] = this.readLong();
            ++n4;
        }
    }

    public boolean write(String string, long l, short s, long l2) {
        return this.write(string.getBytes(), l, s, l2);
    }

    public boolean write(byte[] byArray, long l, short s, long l2) {
        long l3;
        long l4 = this.hashTheKey(byArray);
        int n = 0;
        n = (int)(l4 % (long)IndexHeader.index_table_size);
        if (n < 0) {
            System.out.println("array index is " + n);
        }
        if ((l3 = IndexHeader.index_ptr + (long)(8 * n)) < 0L) {
            System.out.println("pos is " + l3);
        }
        try {
            this.seek(l3);
            long l5 = this.readLong();
            if (l5 < -1L) {
                System.out.println("x is " + l5 + "@" + l3 + ":" + IndexHeader.index_ptr + ":" + n);
            }
            if (-1L == l5) {
                DvNamesIndexFile.indexArray[n] = this.writeNewKeyRecord(l3, byArray, l, l2);
            } else {
                this.updateExisting(l3, byArray, l5, l, l2);
            }
        }
        catch (IOException iOException) {
            String string = new String(byArray);
            System.out.println("IOException " + l3 + " " + string);
        }
        return true;
    }

    private long writeNewKeyRecord(long l, byte[] byArray, long l2, long l3) {
        long l4 = 0L;
        try {
            this.seek(this.length());
            long l5 = this.getFilePointer();
            this.writeByte(75);
            this.writeByte(101);
            this.writeByte(121);
            this.writeByte(58);
            this.writeByte(60);
            this.writeInt(byArray.length);
            this.writeInt(1);
            this.writeLong(l3);
            this.writeLong(0L);
            long l6 = this.getFilePointer();
            this.writeLong(0L);
            long l7 = this.getFilePointer();
            this.writeLong(0L);
            this.write(byArray);
            this.writeByte(62);
            if (0L != l) {
                this.seek(l);
                this.writeLong(l5);
            }
            l4 = l5;
            long l8 = this.addInstanceAddress(0L, l2, l7);
            this.seek(l6);
            this.writeLong(l8);
        }
        catch (IOException iOException) {
            System.err.println("IOException in writeNewKeyRecord");
        }
        return l4;
    }

    public Vector summary(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object[] objectArray;
        Vector vector = new Vector();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < IndexHeader.index_table_size) {
            if (-1L != indexArray[n3]) {
                Object object;
                objectArray = "0000000000";
                String string = null;
                String string2 = null;
                String string3 = null;
                boolean bl5 = false;
                int n4 = 0;
                long l = indexArray[n3];
                while (l != 0L) {
                    object = new dataRecord(l);
                    string = new String(((dataRecord)object).name);
                    string2 = "" + ((dataRecord)object).count;
                    string3 = "" + ((dataRecord)object).totalsize;
                    int n5 = string2.length();
                    if (n5 < 10) {
                        string2 = objectArray.substring(n5) + string2;
                    }
                    if (n5 > 10) {
                        string2 = "9999999999";
                    }
                    if ((n5 = string3.length()) < 10) {
                        string3 = objectArray.substring(n5) + string3;
                    }
                    if (n5 > 10) {
                        string3 = "9999999999";
                    }
                    if (bl3) {
                        vector.add(string + "  : " + string2 + " (= " + string3 + " bytes)");
                    }
                    if (bl) {
                        vector.add(string2 + " (=" + string3 + " bytes)" + " of : " + string);
                    }
                    if (bl2) {
                        vector.add("(" + string3 + " bytes) " + string2 + " of : " + string);
                    }
                    if (string.equals("   !!! null !!!")) {
                        bl5 = true;
                        n4 = ((dataRecord)object).count;
                    }
                    n += ((dataRecord)object).count;
                    n2 = (int)((long)n2 + ((dataRecord)object).totalsize);
                    l = ((dataRecord)object).nextPtr;
                }
                if (bl5) {
                    object = "\n*******************\n";
                    object = (String)object + " There were " + n4 + " objects\n" + "where the classname could not be found\n" + "this suggests either a partial dump or\n" + "the possibility of heap corruption\n" + "*******************\n";
                    DvUtils.trace((String)object, 0, true);
                    if (DvConsole.bGuiRequested) {
                        Dumpviewer.showMessage((String)object, false);
                    }
                }
            }
            ++n3;
        }
        objectArray = new String[vector.size()];
        int n6 = 0;
        while (n6 < vector.size()) {
            objectArray[n6] = (String)vector.get(n6);
            ++n6;
        }
        Arrays.sort(objectArray);
        vector.clear();
        int n7 = 0;
        while (n7 < objectArray.length) {
            if (bl4) {
                vector.add(objectArray[n7]);
            } else {
                vector.add(objectArray[objectArray.length - n7 - 1]);
            }
            ++n7;
        }
        vector.add("\n Total number of objects = " + n);
        vector.add("\n Total byte count = " + n2);
        return vector;
    }

    public Vector getAllClassNames() {
        Vector vector = new Vector();
        int n = 0;
        while (n < IndexHeader.index_table_size) {
            if (-1L != indexArray[n]) {
                long l = indexArray[n];
                while (l != 0L) {
                    dataRecord dataRecord2 = new dataRecord(l);
                    String string = new String(dataRecord2.name);
                    vector.add(string);
                    l = dataRecord2.nextPtr;
                }
            }
            ++n;
        }
        return vector;
    }

    public int getInstanceCountForClass(String string) {
        int n = 0;
        DvUtils.writetoTrace("Entry to getInstanceCountForClass: " + string);
        byte[] byArray = string.getBytes();
        long l = this.hashTheKey(byArray);
        long l2 = indexArray[(int)(l % (long)IndexHeader.index_table_size)];
        boolean bl = false;
        while (!bl && l2 != 0L && -1L != l2) {
            dataRecord dataRecord2 = new dataRecord(l2);
            String string2 = new String(dataRecord2.name);
            if (string2.equals(string)) {
                bl = true;
                n = dataRecord2.count;
            }
            l2 = dataRecord2.nextPtr;
        }
        DvUtils.writetoTrace("Exit from to getInstanceCountForClass: " + n);
        return n;
    }

    public long getInstancesForClass(String string, int n, long l, long[] lArray) {
        long l2 = 0L;
        boolean bl = false;
        int n2 = this.getInstanceCountForClass(string) - n;
        if (null != lArray) {
            int n3 = 0;
            while (n3 < lArray.length) {
                lArray[n3] = 0L;
                ++n3;
            }
            byte[] byArray = string.getBytes();
            long l3 = this.hashTheKey(byArray);
            if (0L != l) {
                bl = true;
            }
            long l4 = indexArray[(int)(l3 % (long)IndexHeader.index_table_size)];
            boolean bl2 = false;
            while (!bl2 && l4 != 0L && -1L != l4) {
                String string2 = null;
                dataRecord dataRecord2 = null;
                if (!bl) {
                    dataRecord2 = new dataRecord(l4);
                    string2 = new String(dataRecord2.name);
                } else {
                    string2 = string;
                }
                if (string2.equals(string)) {
                    bl2 = true;
                    int n4 = 0;
                    long l5 = 0L;
                    l5 = true == bl ? l : dataRecord2.dataPtr;
                    boolean bl3 = false;
                    while (0L != l5 && !bl3) {
                        instanceRecord instanceRecord2 = new instanceRecord(l5);
                        int n5 = 0;
                        while (n5 < instanceRecord2.count) {
                            lArray[n4] = instanceRecord2.instance[n5];
                            if (++n4 == lArray.length || n4 == n2) {
                                bl3 = true;
                                l2 = instanceRecord2.nextIRptr;
                            }
                            ++n5;
                        }
                        l5 = instanceRecord2.nextIRptr;
                    }
                }
                l4 = null != dataRecord2 ? dataRecord2.nextPtr : 0L;
            }
        }
        return l2;
    }

    public long[] getInstancesForClass(String string) {
        DvUtils.writetoTrace("Entry to getInstancesForClass: " + string);
        long[] lArray = null;
        byte[] byArray = string.getBytes();
        long l = this.hashTheKey(byArray);
        long l2 = indexArray[(int)(l % (long)IndexHeader.index_table_size)];
        boolean bl = false;
        while (!bl && l2 != 0L && -1L != l2) {
            dataRecord dataRecord2 = new dataRecord(l2);
            String string2 = new String(dataRecord2.name);
            if (string2.equals(string)) {
                bl = true;
                lArray = new long[dataRecord2.count];
                int n = 0;
                long l3 = dataRecord2.dataPtr;
                while (0L != l3) {
                    instanceRecord instanceRecord2 = new instanceRecord(l3);
                    int n2 = 0;
                    while (n2 < instanceRecord2.count) {
                        lArray[n] = instanceRecord2.instance[n2];
                        ++n;
                        ++n2;
                    }
                    l3 = instanceRecord2.nextIRptr;
                }
            }
            l2 = dataRecord2.nextPtr;
        }
        if (null != lArray) {
            DvUtils.writetoTrace("Exit from getInstancesForClass: " + lArray.length);
        } else {
            DvUtils.writetoTrace("Exit from getInstancesForClass: no instances found");
        }
        return lArray;
    }

    public boolean updateExisting(long l, byte[] byArray, long l2, long l3, long l4) {
        try {
            long l5;
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            while (!bl2) {
                l5 = this.checkItOut(l2, byArray);
                ++n;
                if (l5 == l2) {
                    bl2 = true;
                    bl = true;
                }
                if (0L == l5) {
                    bl2 = true;
                }
                if (bl2) continue;
                l2 = l5;
            }
            if (bl) {
                this.seek(l2);
                byte[] byArray2 = new byte[4];
                this.read(byArray2);
                this.readByte();
                int n2 = byArray.length;
                int n3 = this.readInt();
                long l6 = this.getFilePointer();
                int n4 = this.readInt();
                long l7 = this.getFilePointer();
                long l8 = this.readLong();
                this.seek(l7);
                this.writeLong(l8 + l4);
                this.saved_next_position = this.getFilePointer();
                this.readLong();
                long l9 = this.getFilePointer();
                long l10 = this.readLong();
                long l11 = this.getFilePointer();
                this.seek(l6);
                int n5 = this.readInt() + 1;
                this.seek(l6);
                this.writeInt(n5);
                this.addInstanceAddress(l9, l3, l11);
            } else {
                l5 = this.writeNewKeyRecord(this.saved_next_position, byArray, l3, l4);
            }
        }
        catch (IOException iOException) {
            System.out.println(" !!! IOError in updateExisting !!!");
        }
        return true;
    }

    public void updateMagic() {
        try {
            this.seek(0L);
            this.writeLong(this.savedMagic);
        }
        catch (IOException iOException) {
            if (0L == this.savedMagic) {
                // empty if block
            }
        }
    }

    private long checkItOut(long l, byte[] byArray) {
        long l2 = 0L;
        try {
            this.seek(l);
            byte[] byArray2 = new byte[4];
            this.read(byArray2);
            String string = "";
            try {
                string = new String(byArray2, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                DvUtils.writetoTrace(" Eyecatcher error in DvNamesIndexFile");
            }
            if (string.equals("Key:")) {
                this.readByte();
                int n = this.readInt();
                int n2 = this.readInt();
                this.readLong();
                this.saved_next_position = this.getFilePointer();
                long l3 = this.readLong();
                this.readLong();
                this.readLong();
                byte[] byArray3 = new byte[n];
                this.read(byArray3);
                String string2 = new String(byArray);
                String string3 = new String(byArray3);
                l2 = string2.equals(string3) ? l : l3;
            } else {
                System.err.println("Bad format detected in checkItOut");
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException in checkItOut");
        }
        return l2;
    }

    private long addInstanceAddress(long l, long l2, long l3) {
        long l4 = l;
        if (0L == l) {
            l4 = this.writeNewDataRecord(l2, l3, 0L);
        } else {
            try {
                this.seek(l3);
                this.seek(this.readLong());
                long l5 = this.getFilePointer();
                this.readInt();
                long l6 = this.getFilePointer();
                int n = this.readInt();
                if (n < 8) {
                    this.seek(l5 + (long)(8 * (n + 1)));
                    this.writeLong(l2);
                    this.seek(l6);
                    this.writeInt(++n);
                } else {
                    long l7 = l5 + 72L;
                    l4 = this.writeNewDataRecord(l2, l3, l7);
                }
            }
            catch (IOException iOException) {
                System.err.println("IOException in addInstanceAddress");
            }
        }
        return l4;
    }

    private long writeNewDataRecord(long l, long l2, long l3) {
        long l4 = 0L;
        try {
            this.seek(this.length());
            l4 = this.getFilePointer();
            this.writeByte(79);
            this.writeByte(98);
            this.writeByte(106);
            this.writeByte(58);
            this.writeInt(1);
            this.writeLong(l);
            int n = 0;
            while (n < 8) {
                this.writeLong(0L);
                ++n;
            }
            this.seek(l2);
            this.writeLong(l4);
            if (0L != l3) {
                this.seek(l3);
                this.writeLong(l4);
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException in writeNewDataRecord");
        }
        return l4;
    }

    private static boolean initTheIndex(int n, int n2, int n3, long l) throws IOException {
        IH = new IndexHeader(n, n2, l);
        indexArray = new long[n];
        int n4 = 0;
        while (n4 < n) {
            DvNamesIndexFile.indexArray[n4] = -1L;
            ++n4;
        }
        return true;
    }

    private long hashTheKey(byte[] byArray) {
        long l = 0L;
        if (byArray.length > 4) {
            int n = 0;
            while (n < byArray.length) {
                long l2 = byArray[n];
                if (l2 < 0L) {
                    l2 = -l2;
                }
                l = n > 0 && n < 4 ? (l *= l2) : (l += l2 * (long)n);
                if (l < 0L) {
                    l = 0L;
                    l = 0L;
                }
                ++n;
            }
        }
        return l;
    }

    private void initPtrLength() {
        DvDump dvDump = DvConsole.theDump;
        ptrLength = DvUtils.is64BitSystem(dvDump.getArchitecture()) ? 8 : 4;
    }

    static {
        next_record_pos = 0L;
        index_table_size = 0;
    }

    private static class instanceRecord {
        byte[] eye = new byte[4];
        int count;
        long[] instance = new long[8];
        long nextIRptr;

        private instanceRecord(long l) {
            try {
                self.seek(l);
                self.read(this.eye);
                this.count = self.readInt();
                int n = 0;
                while (n < 8) {
                    this.instance[n] = self.readLong();
                    ++n;
                }
                this.nextIRptr = self.readLong();
            }
            catch (IOException iOException) {
                System.err.println("IOexception in instanceRecord constructor");
            }
        }
    }

    private static class dataRecord {
        byte[] eye = new byte[5];
        int length;
        int count;
        long totalsize;
        long nextPtr;
        long dataPtr;
        long lastDRA;
        byte[] name;

        private dataRecord(long l) {
            try {
                self.seek(l);
                self.read(this.eye);
                this.length = self.readInt();
                this.count = self.readInt();
                this.totalsize = self.readLong();
                this.nextPtr = self.readLong();
                this.dataPtr = self.readLong();
                this.lastDRA = self.readLong();
                this.name = new byte[this.length];
                self.read(this.name);
            }
            catch (IOException iOException) {
                System.err.println("IOexception in dataRecord constructor");
            }
        }
    }

    private static class IndexHeader {
        static long magic;
        static int index_table_size;
        static int record_size;
        static int key_size;
        static long index_ptr;

        private IndexHeader() {
        }

        private IndexHeader(int n, int n2, long l) throws IOException {
            magic = l;
            index_table_size = n / 256 * 256;
            record_size = n2;
            this.writeIH();
        }

        private int loadIH() {
            return 0;
        }

        private static IndexHeader readExistingHeader() throws IOException {
            IndexHeader indexHeader = new IndexHeader();
            self.seek(0L);
            magic = self.readLong();
            index_table_size = self.readInt();
            record_size = self.readInt();
            key_size = self.readInt();
            self.readInt();
            index_ptr = self.readLong();
            next_record_pos = self.length();
            return indexHeader;
        }

        private boolean writeIH() throws IOException {
            self.writeLong(magic);
            self.writeInt(index_table_size);
            self.writeInt(record_size);
            self.writeInt(key_size);
            self.writeInt(0);
            long l = self.getFilePointer();
            self.writeLong(0L);
            self.writeLong(0L);
            self.writeLong(0L);
            self.writeLong(0L);
            self.writeLong(0L);
            int n = 0;
            while (n < 4) {
                self.writeByte(105);
                self.writeByte(110);
                self.writeByte(100);
                self.writeByte(120);
                ++n;
            }
            index_ptr = self.getFilePointer();
            int n2 = 0;
            while (n2 < index_table_size) {
                self.writeLong(-1L);
                ++n2;
            }
            int n3 = 0;
            while (n3 < 4) {
                self.writeByte(100);
                self.writeByte(97);
                self.writeByte(116);
                self.writeByte(97);
                ++n3;
            }
            long l2 = self.getFilePointer();
            self.seek(l);
            self.writeLong(index_ptr);
            self.writeLong(l2);
            next_record_pos = l2;
            return true;
        }
    }
}

