/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvFormatAs;
import com.ibm.jvm.dump.format.DvMenu;
import com.ibm.jvm.dump.format.DvMenuItem;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DvBaseCommands;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;

public class DvBaseFmtCmds
extends CommandPlugin {
    private static String thisName = "com.ibm.jvm.dump.plugins.DvBaseFmtCmds";
    private static String[] cbNamesArray = null;
    private static DvBaseFmtCmds selfRef;
    private static String[] commandsSupported;

    public DvBaseFmtCmds() {
        selfRef = this;
    }

    public String pluginName() {
        return "Base format commands (DvBaseFmtCmds)";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public static Object getGenericHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvBaseFmtCmds.properties");
        return vector;
    }

    public String help() {
        return null;
    }

    public String help(String string) {
        return null;
    }

    public String[] guiMenuSyntax() {
        return null;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public void showFormatInfo() {
        Vector vector = new Vector();
        vector.add("  Format information  ==================\n");
        vector.add("The formatting of structures is controlled via either\na mapping of formatable structures within the dump\nitself or by a supplied file whose identity is specified\nusing \"SET FORMATFILE=\" command.");
        vector.add("\n");
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void doFormat() {
        Vector vector = new Vector();
        DvDump dvDump = DvConsole.theDump;
        if (null != dvDump) {
            vector.add(DvBaseFmtCmds.doFormatEx(this.paramString, dvDump, this.verbModifier));
        } else {
            vector.add(" Unable to comply as no dump accessed yet");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public static Vector doFormatEx(String string, DvDump dvDump, String string2) {
        DvUtils.writetoTrace(" Entry to DvBaseFmtCmds:doFormatEx (" + string2 + " " + string + ")");
        Vector vector = new Vector();
        if (null == string) {
            vector.add(" paramString is null !!!!");
        } else {
            Vector vector2 = DvUtils.splitIntoPieces(string, " ");
            String string3 = (String)vector2.get(0);
            if (string3.toUpperCase().equals("AS")) {
                if (vector2.size() != 2) {
                    vector.add(" Invalid request");
                } else {
                    long l = 0L;
                    try {
                        String string4 = DvUtils.getValue("ASID");
                        DvAddressSpace dvAddressSpace = DvUtils.findAsid(dvDump, string4);
                        string2 = DvUtils.remove0x(string2);
                        l = DvUtils.hexToLong(string2);
                        String string5 = (String)vector2.get(1);
                        if (null != CType.find(string5)) {
                            if (null != dvAddressSpace) {
                                DvAddress dvAddress = dvAddressSpace.createAddress(l);
                                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                                    CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, string5);
                                    if (null != cTypeObject) {
                                        vector.add(cTypeObject);
                                        vector.add("\n " + string + " finished");
                                    } else {
                                        vector.add(" Format failed!!!!");
                                    }
                                } else {
                                    vector.add(" Address " + string2 + " not in dump");
                                }
                            } else {
                                vector.add(" Unable to find address space: " + string4);
                            }
                        } else {
                            vector.add(" Unsupported structure \"" + string5 + "\" (case is relevent).");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        vector.add(" Invalid hex: " + string2);
                    }
                }
            }
        }
        DvUtils.writetoTrace(" Exit from DvBaseFmtCmds:doFormatEx");
        return vector;
    }

    public void formatEE() {
        Vector vector = new Vector();
        DvDump dvDump = DvConsole.theDump;
        if (null != dvDump) {
            String string;
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            DvProcess dvProcess = (DvProcess)DvUtils.getAPT(dvDump, "P");
            DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
            if (null == this.paramString) {
                string = DvUtils.getValue("THREAD");
            } else {
                string = this.paramString;
                if (dvAddressSpace != null && dvProcess != null) {
                    dvThread = DvUtils.findThread(dvDump, string, dvAddressSpace, dvProcess);
                }
            }
            vector.add("\n execenv for thread " + string + "\n ==========================\n");
            if (null != dvAddressSpace && null != dvProcess && null != dvThread) {
                DvAddress dvAddress = dvAddressSpace.createAddress(dvThread.eeAddress().getAddressAsLong());
                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                    CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "execenv");
                    if (null != cTypeObject) {
                        vector.add(cTypeObject);
                        vector.add("\n Format of execenv finished");
                    } else {
                        vector.add(" Format of execenv failed!!!!");
                    }
                } else {
                    vector.add(" Address " + dvThread.eeAddress().convertToHex() + " is not available in the dump");
                }
            } else {
                vector.add(" ASID/Process/Thread invalid");
            }
        } else {
            vector.add(" Unable to comply as no dump accessed yet");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void formatJVM() {
        DvUtils.writetoTrace(" Entry to DvBaseFmtCmds:formatJVM");
        Vector vector = new Vector();
        DvDump dvDump = DvConsole.theDump;
        if (null != dvDump) {
            String string;
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            DvProcess dvProcess = (DvProcess)DvUtils.getAPT(dvDump, "P");
            DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
            if (null == this.paramString) {
                string = DvUtils.getValue("THREAD");
            } else {
                string = this.paramString;
                if (dvAddressSpace != null && dvProcess != null) {
                    dvThread = DvUtils.findThread(dvDump, string, dvAddressSpace, dvProcess);
                }
            }
            vector.add("\n Jvm via thread " + string + "\n ==========================\n");
            if (null != dvAddressSpace && null != dvProcess && null != dvThread) {
                DvAddress dvAddress = dvAddressSpace.createAddress(dvThread.eeAddress().getAddressAsLong());
                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                    CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "execenv");
                    if (null != cTypeObject) {
                        CTypeObject cTypeObject2 = cTypeObject.getField("jvmP");
                        if (null != cTypeObject2) {
                            String string2 = cTypeObject2.toString();
                            if (string2.startsWith("null ")) {
                                string2 = string2.substring(5);
                            }
                            if (string2.startsWith("(null) ")) {
                                string2 = string2.substring(7);
                            }
                            string2 = DvUtils.removeAtSign(string2);
                            string2 = DvUtils.remove0x(string2);
                            DvAddress dvAddress2 = null;
                            DvAddress dvAddress3 = dvAddressSpace.createAddress(DvUtils.hexToLong(string2));
                            try {
                                dvAddress2 = dvAddressSpace.readPointer(dvAddress3);
                            }
                            catch (DvAddressException dvAddressException) {
                                vector.add("\n jvmP addressing failure");
                            }
                            CTypeObject cTypeObject3 = null;
                            if (null != dvAddress2) {
                                cTypeObject3 = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress2, "Jvm");
                            }
                            if (null != cTypeObject3) {
                                DvUtils.setupJVMHints(cTypeObject3, dvAddress2.getAddressAsLong(), dvAddressSpace);
                                vector.add(cTypeObject3);
                                vector.add("\n Format of Jvm finished");
                            } else {
                                vector.add(" Unable to format Jvm!");
                            }
                        } else {
                            vector.add(" Unable to get jvmP!");
                        }
                    } else {
                        vector.add(" obtaining execenv failure!!!!");
                    }
                } else {
                    vector.add(" Address " + dvThread.eeAddress().convertToHex() + " is not available in the dump");
                }
            } else {
                vector.add(" ASID/Process/Thread invalid");
            }
        } else {
            vector.add(" Unable to comply as no dump accessed yet");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
        DvUtils.writetoTrace(" Exit from DvBaseFmtCmds:formatJVM");
    }

    public void formatSTGlobal() {
        Vector vector = new Vector();
        DvDump dvDump = DvConsole.theDump;
        if (null != dvDump) {
            DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
            if (null != dvThread) {
                long l = DvUtils.jvmFromThreadId(dvThread.id());
                String string = DvUtils.getJVMHint(l, "STGLOBALPTR");
                if (null != string) {
                    this.verbModifier = string;
                    this.paramString = "as STGlobal";
                    this.doFormat();
                    return;
                }
                vector.add(" Unable to comply - no hint found for STGLOBALPTR");
            } else {
                vector.add(" Unable to comply as no valid address space found");
            }
        } else {
            vector.add(" Unable to comply as no dump accessed");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void displayHints() {
        Vector vector = new Vector();
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        if (null != dvThread) {
            long l = DvUtils.jvmFromThreadId(dvThread.id());
            vector.add("\n Jvm Hints for jvm 0x" + Long.toHexString(l) + "\n ====================================\n");
            vector.add(DvUtils.getAllJVMHints(l));
        } else {
            vector.add("Unable to establish current thread");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void reset() {
    }

    public Vector guiMenus() {
        Vector vector = new Vector();
        vector.add(new DvMenu("Format", -1, false));
        vector.add(new DvMenuItem("Format", "Format .. as ..", -1, null, false, "formatAs", thisName, null, "formatDoubleClick", null, null, false, "Format dialog for generic control block formatting"));
        vector.add(new DvMenuItem("Format", "Execenv (current thread)", -1, null, false, "formatExecEnv", thisName, null, "formatDoubleClick", null, null, false, "Format the execenv for current thread"));
        vector.add(new DvMenuItem("Format", "JVM", -1, null, false, "formatJVM", thisName, null, "formatDoubleClick", null, null, false, "Format the JVM control block"));
        vector.add(new DvMenuItem("Format", "Display ControlBlocks", -1, null, false, "disCB", thisName, null, null, null, null, false, "Display CB and offsets (tree)"));
        return vector;
    }

    public static void formatAs(String string) {
        JInternalFrame jInternalFrame = Dumpviewer.getInternalFrame("Format As input", Dumpviewer.theIFM.getDefaultProperties(), 6);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 270, 320, 350, 200);
        DvFormatAs dvFormatAs = new DvFormatAs(jInternalFrame, Dumpviewer.dvConsole, "");
    }

    public static void formatExecEnv(String string) {
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        if (null != dvAddressSpace && null != dvThread) {
            long l = dvThread.eeAddress().getAddressAsLong();
            DvAddress dvAddress = dvAddressSpace.createAddress(l);
            String string2 = "Format execenv @0x" + Long.toHexString(l);
            if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                String string3 = "Error Format of execenv failed\n";
                CTypeObject cTypeObject = DvBaseFmtCmds.formatGeneric(dvAddress, "execenv", dvAddressSpace);
                if (null != cTypeObject) {
                    DvUtils.writetoTrace("  ... CTypeObject obtained");
                    string3 = cTypeObject.toString();
                } else {
                    DvUtils.writetoTrace(" Format of execenv failed!!!!");
                }
                JInternalFrame jInternalFrame = DvBaseFmtCmds.setupFormatFrame(string3, string2, string);
            } else {
                DvUtils.writetoTrace(" Address " + dvThread.eeAddress().convertToHex() + " is not available in the dump");
            }
        } else {
            DvUtils.writetoTrace(" formatExecEnv:No valid address space/thread found");
        }
    }

    public static CTypeObject formatGeneric(DvAddress dvAddress, String string, DvAddressSpace dvAddressSpace) {
        CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, string);
        return cTypeObject;
    }

    public static JInternalFrame setupFormatFrame(String string, String string2, String string3) {
        DvUtils.writetoTrace("setting up Format Frame " + string2 + " : " + string3);
        JInternalFrame jInternalFrame = Dumpviewer.getInternalFrame(string3, Dumpviewer.theIFM.getDefaultProperties(), 0, string3);
        Dumpviewer.addIFrameToDesktop(jInternalFrame);
        JTree jTree = DvBaseFmtCmds.fillFormatTree(string);
        JScrollPane jScrollPane = new JScrollPane(jTree, 20, 32);
        jInternalFrame.getContentPane().setLayout(new BorderLayout());
        jInternalFrame.setPreferredSize(new Dimension(300, 300));
        jInternalFrame.getContentPane().add("Center", jScrollPane);
        Dumpviewer.addMouseListener(jInternalFrame, jTree);
        return jInternalFrame;
    }

    public static JTree fillFormatTree(Object object) {
        Object object2;
        String string = "";
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        if (object instanceof String) {
            object2 = (String)object;
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                vector2.add(stringTokenizer.nextToken());
            }
        } else {
            vector2 = (Vector)object;
        }
        object2 = new DefaultMutableTreeNode((String)vector2.get(0));
        vector.add(object2);
        boolean bl = true;
        int n = -1;
        boolean bl2 = false;
        Object object3 = object2;
        int n2 = 1;
        while (n2 < vector2.size()) {
            int n3 = 0;
            string = (String)vector2.get(n2);
            int n4 = 0;
            while (n4 < string.length()) {
                if (' ' != string.charAt(n4)) {
                    int n5 = n4 / 2;
                    if (n5 != n3) {
                        object3 = (DefaultMutableTreeNode)vector.get(n5 - 1);
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
                    if (vector.size() <= n5) {
                        vector.add(defaultMutableTreeNode);
                    } else {
                        vector.set(n5, defaultMutableTreeNode);
                    }
                    ((DefaultMutableTreeNode)object3).add(defaultMutableTreeNode);
                    n3 = n5;
                    n4 = string.length();
                }
                ++n4;
            }
            ++n2;
        }
        JTree jTree = new JTree((TreeNode)object2);
        jTree.getSelectionModel().setSelectionMode(1);
        Icon icon = null;
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(icon);
        defaultTreeCellRenderer.setClosedIcon(icon);
        defaultTreeCellRenderer.setOpenIcon(icon);
        jTree.setCellRenderer(defaultTreeCellRenderer);
        return jTree;
    }

    public static void formatJVM(String string) {
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        if (null != dvThread) {
            long l = DvUtils.jvmFromThreadId(dvThread.id());
            String string2 = "Error Format of JVM failed\n";
            String string3 = DvUtils.getJVMHint(l, "JVM");
            if (null != string3) {
                long l2 = Long.parseLong(string3, 16);
                DvAddress dvAddress = dvAddressSpace.createAddress(l2);
                String string4 = "Format jvm @0x" + Long.toHexString(l2);
                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                    CTypeObject cTypeObject = DvBaseFmtCmds.formatGeneric(dvAddress, "Jvm", dvAddressSpace);
                    if (null != cTypeObject) {
                        DvUtils.writetoTrace("  ... CTypeObject obtained");
                        string2 = cTypeObject.toString();
                    } else {
                        DvUtils.writetoTrace(" Format of jvm failed!!!!");
                    }
                    JInternalFrame jInternalFrame = DvBaseFmtCmds.setupFormatFrame(string2, string4, string);
                } else {
                    DvUtils.writetoTrace(" Address " + Long.toHexString(l2) + " is not available in the dump");
                }
            } else {
                DvUtils.writetoTrace(" Unable to comply - no hint found for JVM");
            }
        } else {
            DvUtils.writetoTrace(" formatExecEnv:No valid address space found");
        }
    }

    public static void formatDoubleClick(JInternalFrame jInternalFrame, MouseEvent mouseEvent) {
        DvUtils.writetoTrace("DVBaseFmtCmds:formatDoubleClick entry");
        Object object = mouseEvent.getSource();
        if (object instanceof JTree) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = ((JTree)object).getClosestRowForLocation(n2, n = mouseEvent.getY());
            if (-1 != n3) {
                if (((JTree)object).isCollapsed(n3)) {
                    Object object2 = ((JTree)object).getLastSelectedPathComponent();
                    String string = object2.toString();
                    int n4 = 4;
                    int n5 = string.indexOf("@ 0x");
                    if (-1 == n5) {
                        n5 = string.indexOf(" 0x");
                        n4 = 3;
                    }
                    if (-1 != n5) {
                        String string2 = string.substring(n5 + n4);
                        try {
                            long l = Long.parseLong(string2, 16);
                            DvAddress dvAddress = new DvAddress(l);
                            DvBaseCommands.displayMemory(dvAddress, 512L);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            } else {
                System.out.println(" getClosestRowForLocation returned -1");
            }
        } else {
            DvUtils.writetoTrace(" .... event not associated with our JTree !!! ");
        }
        DvUtils.writetoTrace("DVBaseFmtCmds:formatDoubleClick exit");
    }

    public void formatOffsets() {
        DvUtils.writetoTrace("Entry:DvBaseFmtCmds.formatOffsets()");
        if (null == this.paramString) {
            this.cpr.output("paramString is null");
            this.forcedEnd = true;
            DvUtils.writetoTrace("Exit:1 DvBaseFmtCmds.formatOffsets()");
            return;
        }
        this.formatOffsets(this.paramString);
        this.forcedEnd = true;
        DvUtils.writetoTrace("Exit:2 DvBaseFmtCmds.formatOffsets()");
    }

    private void formatOffsets(String string) {
        DvUtils.writetoTrace("Entry:DvBaseFmtCmds.formatOffsets(" + string + ")");
        if (null == string) {
            this.cpr.output("paramString is null");
            this.forcedEnd = true;
            DvUtils.writetoTrace("Exit:1 DvBaseFmtCmds.formatOffsets(" + string + ")");
            return;
        }
        if (0 == CType.listSize()) {
            this.cpr.output("FAILED to find CType information");
            this.cpr.output("Need either to \"set formatfile=jvmdcf.X\"");
            this.cpr.output("or if embedded core file \"set dump=xxx\"");
            this.forcedEnd = true;
            DvUtils.writetoTrace("Exit:2 DvBaseFmtCmds.formatOffsets(" + string + ")");
            return;
        }
        CType cType = CType.find(string);
        this.cpr.output("");
        try {
            this.cpr.output(cType.getName());
        }
        catch (Exception exception) {
            this.cpr.output("FAILED");
            this.cpr.output("Possible something wrong with the case of \"" + string + "\"");
            this.cpr.output("As this commands is case sensitive with regards to its parameter");
            this.cpr.output("example \"jvm\" needs to be \"Jvm\" ");
            this.cpr.output("");
            this.cpr.output("Use \"dis cb(" + string.toUpperCase() + ")\" to see if any control blocks with this name exist");
            this.cpr.output("The result from this command will also show the correct case");
            this.forcedEnd = true;
            DvUtils.writetoTrace("Exit:3 DvBaseFmtCmds.formatOffsets(" + string + ")");
            return;
        }
        this.cpr.output("----------");
        this.displayCType(this.processCType(cType, "", 0L));
        this.forcedEnd = true;
        DvUtils.writetoTrace("Exit:5 DvBaseFmtCmds.formatOffsets(" + string + ")");
    }

    private Vector processCType(CType cType, String string, long l) {
        DvUtils.writetoTrace("Entry:DvBaseFmtCmds.processCType(CType,String)");
        Vector vector = new Vector();
        if (string.equals("")) {
            vector.add("Offset");
            vector.add("   Name");
            vector.add("Type");
            vector.add("------");
            vector.add("   ----");
            vector.add("----");
        }
        int n = 0;
        while (n < cType.getNumFields()) {
            CType cType2 = cType.getFieldType(n);
            long l2 = cType.getFieldOffset(n);
            vector.add(string + Long.toHexString(l2) + "(" + Long.toHexString(l + l2) + ")");
            vector.add(string + "   " + cType.getFieldName(n));
            if (null == cType2.getName() || cType2.getName().equalsIgnoreCase("void") || cType2.getName().equalsIgnoreCase("(null)") || cType2.getName().equalsIgnoreCase("__unnamed")) {
                vector.add(string + "....");
            } else {
                vector.add(string + cType2.getName());
            }
            vector.addAll(this.processCType(cType2, string + "  ", l + l2));
            ++n;
        }
        DvUtils.writetoTrace("Exit:1 DvBaseFmtCmds.processCType(CType,String)");
        return vector;
    }

    private void displayCType(Vector vector) {
        DvUtils.writetoTrace("Entry:DvBaseFmtCmds.displayCType(Vector)");
        this.cpr.output(this.getCTypeData(vector));
        this.cpr.output("");
        DvUtils.writetoTrace("Exit:1 DvBaseFmtCmds.displayCType(Vector)");
    }

    private Vector getCTypeData(Vector vector) {
        String string;
        Vector vector2 = new Vector();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < vector.size()) {
            String string2 = (String)vector.elementAt(n3);
            if (string2.length() > n) {
                n = string2.length();
            }
            if ((string = (String)vector.elementAt(n3 + 1)).length() > n2) {
                n2 = string.length();
            }
            n3 += 3;
        }
        int n4 = 0;
        while (n4 < vector.size()) {
            string = (String)vector.elementAt(n4);
            String string3 = (String)vector.elementAt(n4 + 1);
            String string4 = (String)vector.elementAt(n4 + 2);
            while (string.length() < n) {
                string = string + " ";
            }
            while (string3.length() < n2) {
                string3 = string3 + " ";
            }
            vector2.add(string + string3 + string4);
            n4 += 3;
        }
        return vector2;
    }

    public void formatList() {
        DvUtils.writetoTrace("Entry:DvBaseFmtCmds.formatList()");
        Vector vector = new Vector();
        if (0 == CType.listSize()) {
            this.cpr.output("FAILED to find CType information");
            this.cpr.output("Need either to \"set formatfile=jvmdcf.X\"");
            this.cpr.output("or if embedded core file \"set dump=xxx\"");
            this.forcedEnd = true;
            DvUtils.writetoTrace("Exit:1 DvBaseFmtCmds.formatList()");
            return;
        }
        if (null == this.paramString) {
            vector.add("*");
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this.paramString, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                vector.add(string);
            }
        }
        if (vector.size() > 0) {
            this.cpr.output("\n");
            if (null == cbNamesArray) {
                selfRef.findControlBlocks();
            }
            int n = 0;
            while (n < cbNamesArray.length) {
                boolean bl = true;
                if (0 != vector.size()) {
                    bl = DvUtils.filtrate(cbNamesArray[n], vector);
                }
                if (bl) {
                    this.cpr.output(cbNamesArray[n]);
                }
                ++n;
            }
        }
        this.forcedEnd = true;
        DvUtils.writetoTrace("Exit:3 DvBaseFmtCmds.formatList()");
    }

    public static void disCB(String string) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        DvUtils.writetoTrace("DvBaseFmtCmds.disCB() entry");
        if (null == cbNamesArray) {
            selfRef.findControlBlocks();
        }
        Vector vector = new Vector();
        vector.add("Control Blocks follow:");
        int n = 0;
        while (n < cbNamesArray.length) {
            vector.add("  " + cbNamesArray[n]);
            object = CType.find(cbNamesArray[n]);
            serializable2 = selfRef.processCType((CType)object, "    ", 0L);
            serializable = selfRef.getCTypeData((Vector)serializable2);
            int n2 = 0;
            while (n2 < ((Vector)serializable).size()) {
                vector.add((String)((Vector)serializable).get(n2));
                ++n2;
            }
            ++n;
        }
        object = Dumpviewer.getInternalFrame(string, Dumpviewer.theIFM.getDefaultProperties(), 0, string);
        Dumpviewer.addIFrameToDesktop((JInternalFrame)object);
        serializable2 = DvBaseFmtCmds.fillFormatTree(vector);
        serializable = new JScrollPane((Component)serializable2, 20, 32);
        ((JInternalFrame)object).getContentPane().setLayout(new BorderLayout());
        ((JComponent)object).setPreferredSize(new Dimension(300, 300));
        ((JInternalFrame)object).getContentPane().add("Center", (Component)serializable);
        DvUtils.writetoTrace("DvBaseFmtCmds.disCB() exit");
    }

    private void findControlBlocks() {
        Vector vector = new Vector();
        int n = 0;
        while (n < CType.listSize()) {
            String string = null;
            try {
                string = CType.find(n).getName();
            }
            catch (Exception exception) {
                string = null;
            }
            if (!(null == string || string.equals("(null)") || string.equals("__unnamed") || string.equals(" ") || string.equals("") || string.equals("void"))) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < vector.size()) {
                    String string2 = (String)vector.get(n2);
                    if (string2.equals(string)) {
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl) {
                    vector.add(string);
                }
            }
            ++n;
        }
        int n3 = vector.size();
        cbNamesArray = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            String string;
            DvBaseFmtCmds.cbNamesArray[n4] = string = (String)vector.get(n4);
            ++n4;
        }
        Arrays.sort(cbNamesArray);
    }

    static {
        commandsSupported = new String[]{"FORMAT,FOR, , ,showFormatInfo,Y,N", "FORMAT,FOR,execenv,ee,formatEE,Y,N", "FORMAT,FOR,jvm,jvm,formatJVM,Y,N", "FORMAT,FOR,stglobal,stg,formatSTGlobal,Y,N", "FORMAT,FOR,*,*,doFormat,Y,N", "DISPLAY,DIS,hints,hints,displayHints,Y,N", "DISPLAY,DIS,controlblock,cb,formatList,N,N", "DISPLAY,DIS,controlblockoffsets,cbo,formatOffsets,N,N", "HELP,?, , ,displayHelp", "HELP,?,*, ,displayHelp"};
    }
}

