/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.ClassDetails;
import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvClassDetailsDisplay;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvConstants;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvMenu;
import com.ibm.jvm.dump.format.DvMenuItem;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.Dvifm;
import com.ibm.jvm.dump.format.SwingWorker;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DvBaseFmtCmds;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class DvClassCommands
extends CommandPlugin {
    private static String thisName = "com.ibm.jvm.dump.plugins.DvClassCommands";
    static JInternalFrame classSummaryJif = null;
    static JTree classTree = null;
    private static String prevVerb = null;
    private static String prevModifier = null;
    private static String prevParms = null;
    private static String prevSeperator = null;
    private static int cc1 = 0;
    private static int cc2 = 0;
    private static int cc3 = 0;
    private static int totalClassesCount = 0;
    private static Vector theClasses = new Vector();
    private static Hashtable classHashByAddr = new Hashtable();
    public static Hashtable classHashByName = new Hashtable();
    private static Hashtable fieldsHashByName = new Hashtable();
    private static Vector theFields = new Vector();
    private static int methodBlockSize;
    private static int fieldBlockSize;
    private static ClassDetails javaLangString;
    private static long stringValueOffset;
    private boolean bWildCards = false;
    private static long mirrorTable;
    private static final String badString = "Unable to get Instance Values";
    private boolean bSummary;
    private static String[] commandsSupported;
    public static DvClassCommands that;

    public DvClassCommands() {
        that = this;
    }

    public String pluginName() {
        return "Class commands (DvClassCommands)";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public static Object getGenericHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvClassCommands.properties");
        return vector;
    }

    public String help() {
        return null;
    }

    public String help(String string) {
        return null;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public void displayHelp() {
        String string = null == this.verbModifier ? "GeneralHelp" : this.verbModifier;
        this.cpr.output(DvUtils.getMultiplePropertyValues(string, "DvBaseCommands.properties"));
        this.forcedEnd = true;
    }

    public void displayCS() {
        DvUtils.writetoTrace("DvClassCommands:displayCS entry");
        this.bSummary = true;
        Vector vector = new Vector();
        vector.add("\n Classes Summary\n ===============\n");
        this.getClasses(vector);
        DvUtils.writetoTrace(" Number of classes found via loadedClasses       = " + cc1);
        DvUtils.writetoTrace(" Number of classes found via loadedACSClasses    = " + cc2);
        DvUtils.writetoTrace(" Number of classes found via loadedSystemClasses = " + cc3);
        vector.add(" Number of classes found via loadedClasses       = " + cc1);
        vector.add(" Number of classes found via loadedACSClasses    = " + cc2);
        vector.add(" Number of classes found via loadedSystemClasses = " + cc3);
        this.displayClasses(vector);
        this.bSummary = false;
        this.cpr.output(vector);
        this.forcedEnd = true;
        DvUtils.writetoTrace("DvClassCommands:displayCS exit");
    }

    public void displayClasses() {
        Vector vector = new Vector();
        this.displayClasses(vector);
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void displayClasses(Vector vector) {
        DvUtils.writetoTrace("DvClassCommands:displayClasses(Vector) entry");
        Vector vector2 = new Vector();
        DvDump dvDump = DvConsole.theDump;
        if (this.paramString != null) {
            vector2 = this.setupFiltersVector(this.paramString);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (null == this.paramString) {
            this.bSummary = true;
        }
        if (null != this.enhancers) {
            String[] stringArray = new String[]{"me", "st", "fld", "nof"};
            if (this.enhancersCheck(stringArray)) {
                bl = this.enhancerIsPresent("me");
                bl2 = this.enhancerIsPresent("st");
                bl3 = this.enhancerIsPresent("fld");
                bl4 = this.enhancerIsPresent("nof");
            } else {
                vector.add("Invalid enhancer detected: " + this.enhancersCheck(stringArray));
            }
        }
        this.getClasses(vector);
        if (vector2.size() > 0 && !this.bWildCards) {
            int n = 0;
            while (n < vector2.size()) {
                String string = (String)vector2.get(n);
                Integer n2 = (Integer)classHashByName.get(string.toUpperCase());
                if (null != n2) {
                    ClassDetails classDetails = (ClassDetails)theClasses.get(n2);
                    if (!bl4) {
                        DvClassCommands.showClass(classDetails, vector, this.bSummary, dvDump);
                    }
                    if (bl) {
                        this.showMethods(classDetails, vector, this.bSummary);
                    }
                    if (bl2) {
                        this.showStatics(classDetails, vector, this.bSummary);
                    }
                    if (bl3) {
                        DvClassCommands.showFields(classDetails, vector, this.bSummary, dvDump);
                    }
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < theClasses.size()) {
                ClassDetails classDetails = (ClassDetails)theClasses.get(n);
                boolean bl5 = true;
                if (0 != vector2.size()) {
                    bl5 = DvUtils.filtrate(classDetails.name, vector2);
                }
                if (bl5) {
                    if (!bl4) {
                        DvClassCommands.showClass(classDetails, vector, this.bSummary, dvDump);
                    }
                    if (bl) {
                        this.showMethods(classDetails, vector, this.bSummary);
                    }
                    if (bl2) {
                        this.showStatics(classDetails, vector, this.bSummary);
                    }
                    if (bl3) {
                        DvClassCommands.showFields(classDetails, vector, this.bSummary, dvDump);
                    }
                }
                ++n;
            }
        }
        DvUtils.writetoTrace("DvClassCommands:displayClasses(Vector) exit");
    }

    public void getClasses(Vector vector) {
        if (0 == theClasses.size()) {
            cc1 = this.getClassesForCategory("LOADEDCLASSES", vector);
            cc3 = this.getClassesForCategory("LOADEDSYSTEMCLASSES", vector);
            cc2 = this.getClassesForCategory("LOADEDACSCLASSES", vector);
        }
        methodBlockSize = CType.find("methodblock").getSize();
        fieldBlockSize = CType.find("fieldblock").getSize();
        DvUtils.writetoTrace("methodblock size is x" + Integer.toHexString(methodBlockSize));
        DvUtils.writetoTrace("fieldblock size is x" + Integer.toHexString(fieldBlockSize));
    }

    private int getClassesForCategory(String string, Vector vector) {
        DvUtils.writetoTrace("Entry: DvClassCommands.getClassesForCategory -" + string);
        DvDump dvDump = DvConsole.theDump;
        int n = 0;
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        long l = 0L;
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        long l2 = DvUtils.jvmFromThreadId(dvThread.id());
        String string2 = DvUtils.getJVMHint(l2, string);
        if (null != string2) {
            long l3 = DvUtils.hexToLong(string2);
            try {
                DvUtils.writetoTrace("  current_start = " + Long.toHexString(l3));
                long l4 = 0L;
                if (0L != l3) {
                    l4 = DvUtils.getFieldAddress(l3, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
                }
                long l5 = l4 - l3;
                while (0L != l4) {
                    l = l4;
                    boolean bl = false;
                    long l6 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "shared_class_id"}, dvAddressSpace);
                    int n2 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l6));
                    if (n2 != 0) {
                        int n3 = this.processSharedClass(l, dvAddressSpace, dvDump, l5, n2, vector);
                        n += n3;
                    } else {
                        bl = this.storeClass(l, dvAddressSpace, dvDump, l5, vector, 0L);
                        if (bl) {
                            ++totalClassesCount;
                            ++n;
                        }
                    }
                    if (bl) {
                        long l7 = DvUtils.getFieldAddress(l, new String[]{"MirroredClassData", "memory_table"}, dvAddressSpace);
                        l3 = l4 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l7);
                        if (0L == l4) continue;
                        l4 = DvUtils.getFieldAddress(l4, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
                        continue;
                    }
                    l4 = 0L;
                }
            }
            catch (DvAddressException dvAddressException) {
                vector.add(" !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                vector.add(" !!! DvAddressException whilst accessing class");
                vector.add(" !!! data from file:\n" + dvAddressException.getMessage());
                vector.add(" !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
        } else {
            vector.add(" !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            vector.add(" !!! Hint missing for category " + string);
            vector.add(" !!! Probably due to mismatch in types file.");
            vector.add(" !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        DvUtils.writetoTrace("Exit: DvClassCommands.getClassesForCategory -" + string + "  count=" + n);
        return n;
    }

    private void showMethods(ClassDetails classDetails, Vector vector, boolean bl) {
        DvDump dvDump = DvConsole.theDump;
        DvUtils.writetoTrace("Entry: DvClassCommands.showMethods");
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        boolean bl2 = true;
        int n = dvDump.getArchitecture();
        boolean bl3 = DvUtils.is64BitSystem(n);
        vector.add("\n Method Block details follow.....\n ===========================\n");
        vector.add(classDetails);
        vector.add("\n");
        if (0L < classDetails.methods_count) {
            long l = classDetails.methods;
            int n2 = 0;
            while ((long)n2 < classDetails.methods_count) {
                DvAddress dvAddress = dvAddressSpace.createAddress(l);
                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                    CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "methodblock");
                    if (!DvClassCommands.clazzCheck(n2, dvAddress, classDetails.address, dvAddressSpace, bl3)) {
                        vector.add("    *** Consistency check failed - clazz field not matching (showMethods)");
                    }
                    String string = "!!!Not established!!!";
                    String string2 = "!!!Not established!!!";
                    CTypeObject cTypeObject2 = cTypeObject.getField("member");
                    if (null != cTypeObject2) {
                        CTypeObject cTypeObject3 = cTypeObject2.getField("name");
                        CTypeObject cTypeObject4 = cTypeObject2.getField("signature");
                        if (null != cTypeObject3) {
                            DvAddress dvAddress2 = null;
                            try {
                                dvAddress2 = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject3.getAddr()));
                                byte[] byArray = dvAddressSpace.readBytes(dvAddress2, 256L);
                                string = DvUtils.getStringFromBytes(byArray);
                                dvAddress2 = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject4.getAddr()));
                                byArray = dvAddressSpace.readBytes(dvAddress2, 256L);
                                string2 = DvUtils.getStringFromBytes(byArray);
                            }
                            catch (DvAddressException dvAddressException) {
                                // empty catch block
                            }
                        }
                    }
                    vector.add("\n Method Block #" + (n2 + 1) + " : " + string + "\n    Signature: " + string2 + "\n =====================================" + "\n");
                    vector.add(cTypeObject);
                } else {
                    vector.add("   *** Method block #" + n2 + " address (" + Long.toHexString(l) + ") not valid***");
                }
                ++n2;
                l += (long)methodBlockSize;
            }
        } else {
            vector.add("   *** Class has NO METHODS ***");
        }
        DvUtils.writetoTrace("Exit: DvClassCommands.showMethods");
    }

    private void showStatics(ClassDetails classDetails, Vector vector, boolean bl) {
        DvUtils.writetoTrace("Entry: DvClassCommands.showStatics");
        DvDump dvDump = DvConsole.theDump;
        boolean bl2 = true;
        int n = dvDump.getArchitecture();
        boolean bl3 = DvUtils.is64BitSystem(n);
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        int n2 = dvAddressSpace.pointerSize();
        vector.add("\n Statics for " + classDetails.name + "\n ===========================\n");
        if (classDetails.loaderInitd) {
            if (0L < classDetails.fields_count) {
                long l = classDetails.fields;
                int n3 = 0;
                while ((long)n3 < classDetails.fields_count) {
                    DvAddress dvAddress = dvAddressSpace.createAddress(l);
                    if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                        short s = 0;
                        try {
                            long l2 = DvUtils.getFieldAddress(l, new String[]{"MemberBlock", "access"}, dvAddressSpace);
                            s = dvAddressSpace.readShort(dvAddressSpace.createAddress(l2));
                        }
                        catch (DvAddressException dvAddressException) {
                            // empty catch block
                        }
                        if (8 == (8 & s)) {
                            String string;
                            CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "fieldblock");
                            if (!DvClassCommands.clazzCheck(n3, dvAddress, classDetails.address, dvAddressSpace, bl3)) {
                                vector.add("    *** Consistency check failed - clazz field not matching (showStatics)");
                            }
                            long l3 = 0L;
                            long l4 = 0L;
                            long l5 = 0L;
                            long l6 = 0L;
                            String string2 = null;
                            try {
                                l4 = DvUtils.getFieldAddress(l, new String[]{"MemberBlock", "signature"}, dvAddressSpace);
                                l5 = DvUtils.getFieldAddress(l, new String[]{"MemberBlock", "name"}, dvAddressSpace);
                                l6 = DvUtils.getFieldAddress(l, new String[]{"fieldblock", "shared_class_id"}, dvAddressSpace);
                                l3 = DvUtils.getFieldAddress(l, new String[]{"fieldblock", "value"}, dvAddressSpace);
                                if (bl3) {
                                    l5 = dvAddressSpace.readLong(dvAddressSpace.createAddress(l5));
                                    l3 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l3));
                                    l4 = dvAddressSpace.readLong(dvAddressSpace.createAddress(l4));
                                } else {
                                    l5 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l5));
                                    l3 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l3));
                                    l4 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l4));
                                }
                                l6 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l6));
                                if (0L != l6) {
                                    l3 = DvClassCommands.staticClassValueAddress(l6, l3, n2, dvAddressSpace);
                                }
                                string2 = DvUtils.stringFromAddress(l4, dvAddressSpace);
                            }
                            catch (DvAddressException dvAddressException) {
                                // empty catch block
                            }
                            if (l5 != 0L) {
                                string = " Field #" + (n3 + 1) + " @0x" + Long.toHexString(l) + " : " + DvUtils.stringFromAddress(l5, dvAddressSpace);
                                vector.add(string);
                            }
                            if (l3 != 0L && l4 != 0L) {
                                string = "     " + DvClassCommands.fieldValue(l3, string2, dvAddressSpace, false);
                                vector.add(string);
                            } else {
                                vector.add("valueAddress:0x" + Long.toHexString(l3) + "  sigAddress:0x" + Long.toHexString(l4));
                                vector.add(DvUtils.stringFromAddress(l4, dvAddressSpace));
                                vector.add(" !!! Value unobtainable for this field");
                            }
                            vector.add("      Access flags:" + DvConstants.interpretAccess(s));
                        }
                    } else {
                        vector.add("   *** Field block #" + n3 + " address (" + Long.toHexString(l) + ") not valid***");
                    }
                    ++n3;
                    l += (long)fieldBlockSize;
                }
            } else {
                vector.add("   *** Class has NO FIELDS ***");
            }
        } else {
            vector.add("   *** Loader not initialized - statics invalid ***");
        }
        DvUtils.writetoTrace("Exit: DvClassCommands.showStatics");
    }

    private static long staticClassValueAddress(long l, long l2, long l3, DvAddressSpace dvAddressSpace) {
        long l4 = 0L;
        DvUtils.writetoTrace("Entry: DvClassCommands.staticClassValueAddress");
        long l5 = mirrorTable + l3 * l;
        try {
            long l6 = DvUtils.getPtrFromPtr(DvConsole.theDump, dvAddressSpace, l5);
            long l7 = DvUtils.getFieldAddress(l6, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
            long l8 = DvUtils.getFieldAddress(l7, new String[]{"MirroredClassData", "static_variable_values"}, dvAddressSpace);
            l8 = DvUtils.getPtrFromPtr(DvConsole.theDump, dvAddressSpace, l8);
            l4 = l8 + l2;
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.trace("DvClassCommands:staticClassValueAddress caught DvAddressException!", 0, true);
        }
        DvUtils.writetoTrace("Exit: DvClassCommands.staticClassValueAddress" + Long.toHexString(l4));
        return l4;
    }

    private static FieldInfo showFields(ClassDetails classDetails, Vector vector, boolean bl, DvDump dvDump) {
        DvUtils.writetoTrace("Entry: DvClassCommands.showFields");
        boolean bl2 = true;
        int n = dvDump.getArchitecture();
        boolean bl3 = DvUtils.is64BitSystem(n);
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (null != vector) {
            vector.add("\n Fields (non-static) for " + classDetails.name + "\n =====================================\n");
        }
        FieldInfo fieldInfo = (FieldInfo)fieldsHashByName.get(classDetails.name);
        boolean bl4 = false;
        if (null == fieldInfo) {
            bl4 = true;
            fieldInfo = new FieldInfo();
        }
        if (0L < classDetails.fields_count) {
            long l = classDetails.fields;
            int n2 = 0;
            while ((long)n2 < classDetails.fields_count) {
                DvAddress dvAddress = dvAddressSpace.createAddress(l);
                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                    short s = 0;
                    try {
                        long l2 = DvUtils.getFieldAddress(l, new String[]{"MemberBlock", "access"}, dvAddressSpace);
                        s = dvAddressSpace.readShort(dvAddressSpace.createAddress(l2));
                    }
                    catch (DvAddressException dvAddressException) {
                        // empty catch block
                    }
                    if (8 != (8 & s)) {
                        String string;
                        CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "fieldblock");
                        if (null != vector && !DvClassCommands.clazzCheck(n2, dvAddress, classDetails.address, dvAddressSpace, bl3)) {
                            vector.add("    *** Consistency check failed - clazz field not matching (showFields)");
                        }
                        long l3 = 0L;
                        long l4 = 0L;
                        long l5 = 0L;
                        String string2 = null;
                        try {
                            l4 = DvUtils.getFieldAddress(l, new String[]{"MemberBlock", "signature"}, dvAddressSpace);
                            l5 = DvUtils.getFieldAddress(l, new String[]{"MemberBlock", "name"}, dvAddressSpace);
                            l3 = DvUtils.getFieldAddress(l, new String[]{"fieldblock", "value"}, dvAddressSpace);
                            if (bl3) {
                                l5 = dvAddressSpace.readLong(dvAddressSpace.createAddress(l5));
                                l3 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l3));
                                l4 = dvAddressSpace.readLong(dvAddressSpace.createAddress(l4));
                            } else {
                                l5 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l5));
                                l3 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l3));
                                l4 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l4));
                            }
                            string2 = DvUtils.stringFromAddress(l4, dvAddressSpace);
                        }
                        catch (DvAddressException dvAddressException) {
                            // empty catch block
                        }
                        String string3 = "";
                        if (l5 != 0L) {
                            string3 = DvUtils.stringFromAddress(l5, dvAddressSpace);
                            string = " Field #" + (n2 + 1) + " @0x" + Long.toHexString(l) + " : " + string3;
                            if (null != vector) {
                                vector.add(string);
                            }
                            if (string3.equals("value") && classDetails.name.equals("java/lang/String")) {
                                stringValueOffset = l3;
                            }
                        }
                        if (l4 != 0L) {
                            string = "     " + DvClassCommands.fieldValue(l3, string2, dvAddressSpace, true);
                            if (null != vector) {
                                vector.add(string);
                            }
                        } else if (null != vector) {
                            vector.add("valueAddress:0x" + Long.toHexString(l3) + "  sigAddress:0x" + Long.toHexString(l4));
                            vector.add(DvUtils.stringFromAddress(l4, dvAddressSpace));
                            vector.add(" !!! Value unobtainable for this field");
                        }
                        if (null != vector) {
                            vector.add("      Access flags:" + DvConstants.interpretAccess(s));
                        }
                        if (bl4) {
                            fieldInfo.addField(DvUtils.stringFromAddress(l5, dvAddressSpace), DvUtils.stringFromAddress(l4, dvAddressSpace), l3, s);
                        }
                    }
                } else if (null != vector) {
                    vector.add("   *** Field block #" + n2 + " address (" + Long.toHexString(l) + ") not valid***");
                }
                ++n2;
                l += (long)fieldBlockSize;
            }
        } else if (null != vector) {
            vector.add("   *** Class has NO FIELDS ***");
        }
        if (bl4) {
            fieldsHashByName.put(classDetails.name, fieldInfo);
        }
        DvUtils.writetoTrace("Exit: DvClassCommands.showFields");
        return fieldInfo;
    }

    private static void showClass(ClassDetails classDetails, Vector vector, boolean bl, DvDump dvDump) {
        if (!bl) {
            vector.add("\n " + classDetails.name + "\n ========================================\n");
            if (0L != classDetails.mirror_obj) {
                vector.add("  *** Warning: this is a shared class *** \n  MirroredClassData is at 0x" + Long.toHexString(classDetails.mirror_obj));
            }
            vector.add(DvBaseFmtCmds.doFormatEx("as Hjava_lang_Class", dvDump, Long.toHexString(classDetails.address)));
            if (0L != classDetails.mirror_obj) {
                vector.add("\n  *** As this is a shared class MirroredClassdata will effectively\n      overlay the MirroredClass data shown above ***** \n");
                vector.add(DvBaseFmtCmds.doFormatEx("as MirroredClassData", dvDump, Long.toHexString(classDetails.mirror_obj)));
            }
        } else {
            vector.add(classDetails);
        }
    }

    public static String getClassName(long l) {
        String string = null;
        Integer n = (Integer)classHashByAddr.get(new Long(l));
        if (n != null) {
            ClassDetails classDetails = (ClassDetails)theClasses.get(n);
            string = new String(classDetails.name);
        }
        return string;
    }

    private void doMethodHelp(Vector vector) {
        Vector vector2 = DvUtils.getMultiplePropertyValues("MethodHelp", "DvClassCommands.properties");
        if (vector2.size() != 0) {
            int n = 0;
            while (n < vector2.size()) {
                vector.add(vector2.elementAt(n));
                ++n;
            }
        }
    }

    public static String fieldValue(long l, String string, DvAddressSpace dvAddressSpace, boolean bl) {
        String string2 = "!!! unable to read value from memory at " + Long.toHexString(l);
        String string3 = " instance offset is " + l + " (0x" + Long.toHexString(l) + ")";
        boolean bl2 = false;
        String string4 = " !!!! Field Value could not be established";
        boolean bl3 = false;
        boolean bl4 = false;
        char c = string.charAt(0);
        switch (c) {
            case 'I': {
                if (bl) {
                    string4 = " integer:" + string3;
                    break;
                }
                try {
                    int n = dvAddressSpace.readInt(dvAddressSpace.createAddress(l));
                    string4 = " integer: " + n + " (0x" + Integer.toHexString(n) + ")";
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " integer: " + string2;
                }
                break;
            }
            case 'J': {
                if (bl) {
                    string4 = " long:" + string3;
                    break;
                }
                try {
                    long l2 = dvAddressSpace.readLong(dvAddressSpace.createAddress(l));
                    string4 = " long: " + l2 + " (0x" + Long.toHexString(l2) + ")";
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " long: " + string2;
                }
                break;
            }
            case 'C': {
                if (bl) {
                    string4 = " char:" + string3;
                    break;
                }
                try {
                    int n = dvAddressSpace.readInt(dvAddressSpace.createAddress(l));
                    Character c2 = new Character((char)n);
                    string4 = " char: " + c2 + " (0x" + Long.toHexString(n) + ")";
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " char: " + string2;
                }
                break;
            }
            case '[': {
                int n = DvConsole.theDump.getArchitecture();
                boolean bl5 = DvUtils.is64BitSystem(n);
                char c3 = string.charAt(1);
                String string5 = "";
                switch (c3) {
                    case 'I': {
                        string5 = "integer";
                        break;
                    }
                    case 'J': {
                        string5 = "long";
                        break;
                    }
                    case 'L': {
                        string5 = "objects";
                        break;
                    }
                    case 'C': {
                        string5 = "char";
                        break;
                    }
                    case 'B': {
                        string5 = "byte";
                        break;
                    }
                    case 'E': {
                        string5 = "enum";
                        break;
                    }
                    case 'F': {
                        string5 = "float";
                        break;
                    }
                    case 'D': {
                        string5 = "double";
                        break;
                    }
                    case 'S': {
                        string5 = "short";
                        break;
                    }
                    case 'V': {
                        string5 = "void";
                        break;
                    }
                    case 'Z': {
                        string5 = "boolean";
                        break;
                    }
                    case 'A': {
                        string5 = "any";
                        break;
                    }
                    case '[': {
                        string5 = "array";
                        break;
                    }
                    default: {
                        string5 = " !!! Not known (" + c3 + ")";
                    }
                }
                if (bl) {
                    string4 = " array of " + string5 + " :" + string3;
                    break;
                }
                try {
                    DvAddress dvAddress = dvAddressSpace.readPointer(dvAddressSpace.createAddress(l));
                    string4 = " Array of " + string5 + " @ 0x" + Long.toHexString(dvAddress.getAddressAsLong());
                    if (string5.equals("char")) {
                        string4 = string4 + "\n\t<<" + DvClassCommands.interpretValue(string, l, dvAddressSpace, false) + ">>";
                        break;
                    }
                    string4 = string4 + "\t" + DvClassCommands.interpretValue(string, l, dvAddressSpace, false);
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " Array of " + string5 + " @ !!! unable to read memory from " + Long.toHexString(l);
                }
                break;
            }
            case 'L': {
                if (bl) {
                    string4 = " class:" + string3;
                    break;
                }
                string4 = " instance of " + string + " @ 0x";
                try {
                    DvAddress dvAddress = dvAddressSpace.readPointer(dvAddressSpace.createAddress(l));
                    string4 = null == dvAddress ? string4 + string2 : string4 + Long.toHexString(dvAddress.getAddressAsLong());
                    if (!string.equals("Ljava/lang/String;") || null == dvAddress) break;
                    try {
                        long l3 = dvAddress.getAddressAsLong();
                        if (l3 != 0L) {
                            long l4 = DvUtils.getFieldAddress(l3, new String[]{"Hjava_lang_Object", "obj"}, dvAddressSpace);
                            string4 = string4 + "\n\t\t  <<" + DvClassCommands.interpretValue("[C", l4, dvAddressSpace, false) + ">>";
                            break;
                        }
                        string4 = string4 + "\n\t\t  Null String <<>>";
                    }
                    catch (DvAddressException dvAddressException) {
                        string4 = string4 + "\n\t\t  Unable to evaluate String value";
                    }
                }
                catch (DvAddressException dvAddressException) {
                    string4 = string4 + " !!! unable to read memory from " + Long.toHexString(l);
                }
                break;
            }
            case 'F': {
                if (bl) {
                    string4 = " float:" + string3;
                    break;
                }
                try {
                    float f = dvAddressSpace.readLong(dvAddressSpace.createAddress(l));
                    string4 = " float: " + f + " (0x" + Long.toHexString((long)f) + ")";
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " float: " + string2;
                }
                break;
            }
            case 'D': {
                if (bl) {
                    string4 = " double:" + string3;
                    break;
                }
                try {
                    double d = dvAddressSpace.readLong(dvAddressSpace.createAddress(l));
                    string4 = " double: " + d + " (0x" + Long.toHexString((long)d) + ")";
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " double: " + string2;
                }
                break;
            }
            case 'Z': {
                if (bl) {
                    string4 = " boolean:" + string3;
                    break;
                }
                try {
                    int n = dvAddressSpace.readInt(dvAddressSpace.createAddress(l));
                    if (0 == n) {
                        string4 = " boolean: false (0x" + Integer.toHexString(n) + ")";
                        break;
                    }
                    string4 = " boolean: true (0x" + Integer.toHexString(n) + ")";
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " boolean: " + string2;
                }
                break;
            }
            case 'B': {
                if (bl) {
                    string4 = " byte:" + string3;
                    break;
                }
                try {
                    int n = dvAddressSpace.readInt(dvAddressSpace.createAddress(l));
                    string4 = " byte: 0x" + Integer.toHexString(n);
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " byte: " + string2;
                }
                break;
            }
            case 'S': {
                if (bl) {
                    string4 = " short:" + string3;
                    break;
                }
                try {
                    int n = dvAddressSpace.readInt(dvAddressSpace.createAddress(l));
                    short s = (short)n;
                    String string6 = Integer.toHexString(s);
                    if (string6.length() > 4) {
                        string6 = string6.substring(4);
                    }
                    string4 = " short: " + s + " (0x" + string6 + ")";
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " short: " + string2;
                }
                break;
            }
            default: {
                string4 = string4 + "( signature: " + string + ")";
            }
        }
        return string4;
    }

    public void reset() {
        prevVerb = null;
        prevModifier = null;
        prevParms = null;
        prevSeperator = null;
        cc1 = 0;
        cc2 = 0;
        cc3 = 0;
        totalClassesCount = 0;
        theClasses.clear();
        classHashByAddr.clear();
        classHashByName.clear();
        fieldsHashByName.clear();
        methodBlockSize = 0;
        mirrorTable = 0L;
    }

    protected static DvClassCommands getCurrentInstance() {
        DvUtils.writetoTrace("Entry/Exit:DvClassCommands.getCurrentInstance()");
        return that;
    }

    public static String getInstanceValues(long l, String string, DvDump dvDump, Vector vector) {
        Object object;
        DvUtils.writetoTrace(" Entry: getInstanceValues  - addr=" + Long.toHexString(l) + "  className=" + string);
        Vector vector2 = new Vector();
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        String string3 = "";
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (0 == theClasses.size()) {
            vector.add("\nRunning imbedded displayCS to establish class formatting!!!\n");
            object = new DvClassCommands();
            ((CommandPlugin)object).verb = "dis";
            ((CommandPlugin)object).verbModifier = "cls";
            ((DvClassCommands)object).displayCS();
        }
        if (0 != theClasses.size()) {
            if (null == classHashByName) {
                System.out.println("classHashByName is null!!!");
            }
            object = (Integer)classHashByName.get(string.toUpperCase());
            Integer n = (Integer)classHashByAddr.get(new Long(l));
            if (n == null) {
                ClassDetails classDetails;
                boolean bl3 = false;
                bl = true;
                if (string.equals("java/Lang/String")) {
                    classDetails = javaLangString;
                    bl3 = true;
                } else if (null != object) {
                    classDetails = (ClassDetails)theClasses.get((Integer)object);
                    if (0L != classDetails.superAddress && !classDetails.superName.equals("java/lang/Object")) {
                        bl2 = true;
                        string3 = classDetails.superName;
                    }
                } else {
                    bl = false;
                }
                if (bl) {
                    Integer n2;
                    FieldInfo fieldInfo = (FieldInfo)fieldsHashByName.get(string);
                    if (null == fieldInfo && null != (n2 = (Integer)classHashByName.get(string.toUpperCase()))) {
                        Vector vector3 = new Vector();
                        ClassDetails classDetails2 = (ClassDetails)theClasses.get(n2);
                        DvClassCommands.showFields(classDetails2, vector3, true, dvDump);
                        fieldInfo = (FieldInfo)fieldsHashByName.get(string);
                    }
                    if (null == fieldInfo) {
                        bl = false;
                    } else {
                        int n3 = dvDump.getArchitecture();
                        int n4 = fieldInfo.name.size();
                        try {
                            String string4;
                            long l2 = DvUtils.getFieldAddress(l, new String[]{"Hjava_lang_Object", "obj"}, dvAddressSpace);
                            int n5 = 0;
                            while (n5 < n4) {
                                string4 = (String)fieldInfo.signature.get(n5);
                                long l3 = (Long)fieldInfo.offset.get(n5);
                                String string5 = (String)fieldInfo.name.get(n5);
                                string2 = string2 + "\n(" + l3 + ") " + string5;
                                string2 = string5.length() > 7 ? string2 + "\t" : string2 + "\t\t";
                                long l4 = l2 + l3;
                                string2 = string2 + DvClassCommands.fieldValue(l4, string4, dvAddressSpace, false);
                                ++n5;
                            }
                            if (bl2 && (string4 = DvClassCommands.getInstanceValues(l, string3, dvDump, vector)) != null && !string4.equals("")) {
                                string2 = string2 + "\n    ===== Super Class expansion for: " + string3 + string4;
                            }
                        }
                        catch (DvAddressException dvAddressException) {
                            string2 = " DvAddressException in DvClassCommands:getInstanceValues";
                        }
                    }
                } else {
                    String string6 = null;
                    if (string.startsWith("array ")) {
                        long l5 = 0L;
                        int n6 = -1;
                        if (string.equals("array char")) {
                            string6 = "[C";
                        } else if (string.equals("array int")) {
                            string6 = "[I";
                        } else if (string.equals("array boolean")) {
                            string6 = "[Z";
                        } else if (string.equals("array long")) {
                            string6 = "[J";
                        } else if (string.equals("array objects")) {
                            string6 = "[L";
                        } else if (string.equals("array byte")) {
                            string6 = "[B";
                        } else if (string.equals("array short")) {
                            string6 = "[S";
                        } else if (string.equals("array double")) {
                            string6 = "[D";
                        } else if (string.equals("array float")) {
                            string6 = "[F";
                        }
                        try {
                            l5 = DvUtils.getFieldAddress(l, new String[]{"Hjava_lang_Object", "methods"}, dvAddressSpace);
                            n6 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l5));
                            if (null != string6) {
                                string2 = string2 + "\n\t <<" + DvClassCommands.interpretValue(string6, l, dvAddressSpace, true) + ">>";
                            } else {
                                string2 = " No array expansion available";
                                string2 = string2 + "\nArray Size:" + n6 + "\n";
                            }
                        }
                        catch (DvAddressException dvAddressException) {
                            string2 = "  !!!exception in array processing in getInstanceValues";
                        }
                    }
                    bl = true;
                }
            } else {
                string2 = " No instance values: ClassClass rather than instance of class";
                bl = true;
            }
        } else {
            vector.add("\n !!! After displayCS there are still no classes available !!!\n");
        }
        DvUtils.writetoTrace(" Exit: getInstanceValues");
        if (bl) {
            return string2;
        }
        return string2 + badString;
    }

    private static String interpretValue(String string, long l, DvAddressSpace dvAddressSpace, boolean bl) {
        String string2 = null;
        boolean bl2 = false;
        if (string.startsWith("[")) {
            char c = string.charAt(1);
            bl2 = true;
            String string3 = null;
            int n = 0;
            DvAddress dvAddress = null;
            int n2 = DvConsole.theDump.getArchitecture();
            boolean bl3 = DvUtils.is64BitSystem(n2);
            try {
                dvAddress = false == bl ? dvAddressSpace.readPointer(dvAddressSpace.createAddress(l)) : dvAddressSpace.createAddress(l);
                if (null != dvAddress && 0L != dvAddress.getAddressAsLong()) {
                    n = bl3 ? (int)dvAddressSpace.readLong(dvAddress) : dvAddressSpace.readInt(dvAddress);
                } else if (0L != dvAddress.getAddressAsLong()) {
                    return " !!! Unavailable memory " + Long.toHexString(l);
                }
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.trace(" !!! " + Long.toHexString(l), 0, true);
            }
            try {
                switch (c) {
                    case 'C': {
                        int n3 = n;
                        if (n > 91) {
                            n3 = 80;
                        }
                        if (n > 0) {
                            char[] cArray = new char[n3];
                            if (bl3) {
                                dvAddress.offsetBy(16L);
                            } else {
                                dvAddress.offsetBy(8L);
                            }
                            int n4 = 0;
                            while (n4 < n3) {
                                cArray[n4] = (char)dvAddressSpace.readShort(dvAddress);
                                dvAddress.offsetBy(2L);
                                ++n4;
                            }
                            string3 = new String(cArray);
                            if (n > 91) {
                                string3 = string3 + " (" + (n - 80) + " bytes not displayed.)";
                            }
                        } else {
                            string3 = "... Null String (length 0) ...";
                        }
                        return string3;
                    }
                    case 'B': {
                        if (n > 0) {
                            string3 = "  Array Size:" + n + " \n\t{";
                            dvAddress.offsetBy(8L);
                            int n5 = 10;
                            int n6 = 0;
                            while (n6 < n && n6 < 10) {
                                int n7 = dvAddressSpace.readByte(dvAddress);
                                int n8 = n7;
                                if (n8 < 0) {
                                    n8 += 256;
                                }
                                string3 = string3 + DvUtils.byteToHex.substring(2 * n8, 2 * n8 + 2);
                                dvAddress.offsetBy(1L);
                                if (n5 - 1 != n6 && n6 != n - 1) {
                                    string3 = string3 + ",";
                                }
                                ++n6;
                            }
                            string3 = n <= n5 ? string3 + "}" : string3 + ", ........";
                            if (n > n5) {
                                string3 = string3 + "\n\t" + (n - n5) + " values not shown";
                            }
                            return string3;
                        }
                        string3 = "... Null Array (length 0) ...";
                        return string3;
                    }
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': {
                        if (n > 0) {
                            string3 = "  Array Size:" + n + " \n\t{";
                            dvAddress.offsetBy(8L);
                            int n9 = 10;
                            int n10 = 0;
                            while (n10 < n && n10 < 10) {
                                if ('I' == c) {
                                    string3 = string3 + dvAddressSpace.readInt(dvAddress);
                                    dvAddress.offsetBy(4L);
                                }
                                if ('J' == c || 'D' == c || 'F' == c) {
                                    if ('J' == c) {
                                        string3 = string3 + dvAddressSpace.readLong(dvAddress);
                                    }
                                    if ('D' == c) {
                                        n9 = 4;
                                        string3 = string3 + (double)dvAddressSpace.readLong(dvAddress);
                                    }
                                    if ('F' == c) {
                                        n9 = 4;
                                        string3 = string3 + (float)dvAddressSpace.readLong(dvAddress);
                                    }
                                    dvAddress.offsetBy(8L);
                                }
                                if ('S' == c) {
                                    string3 = string3 + dvAddressSpace.readShort(dvAddress);
                                    dvAddress.offsetBy(2L);
                                }
                                if (n9 - 1 != n10 && n10 != n - 1) {
                                    string3 = string3 + ",";
                                }
                                ++n10;
                            }
                            string3 = n <= n9 ? string3 + "}" : string3 + ", ........";
                            if (n > n9) {
                                string3 = string3 + "\n\t" + (n - n9) + " values not shown";
                            }
                            return string3;
                        }
                        string3 = "... Null Array (length 0) ...";
                        return string3;
                    }
                }
                string3 = " Array Size:" + n;
                return string3;
            }
            catch (DvAddressException dvAddressException) {
                return "\n !!!!! DvAddressException in DvClassCommands:interpretValue sig:" + string + "  where:" + Long.toHexString(l) + "  !!!!!\n";
            }
        }
        if (!bl2) {
            string2 = "Unable to interpret field (sig=" + string + ", where=" + l + ")";
        }
        return string2;
    }

    private static boolean clazzCheck(int n, DvAddress dvAddress, long l, DvAddressSpace dvAddressSpace, boolean bl) {
        boolean bl2 = true;
        try {
            if (bl) {
                if (l != dvAddressSpace.readLong(dvAddress)) {
                    bl2 = false;
                }
            } else if (l != (long)dvAddressSpace.readInt(dvAddress)) {
                bl2 = false;
            }
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.writetoTrace("\n !!!!!!!!!!!!!!!!!!!!!!\n Method Block entry #" + (n + 1) + "\n produced DvAddressException" + Long.toHexString(l) + "\n Address: " + "\n !!!!!!!!!!!!!!!!!!!!!!");
            bl2 = false;
        }
        return bl2;
    }

    private Vector setupFiltersVector(String string) {
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.startsWith("*") || string2.endsWith("*") || string2.startsWith("!")) {
                this.bWildCards = true;
            }
            DvUtils.writetoTrace("... adding Filter:" + string2);
            vector.add(string2);
        }
        return vector;
    }

    private int processSharedClass(long l, DvAddressSpace dvAddressSpace, DvDump dvDump, long l2, int n, Vector vector) {
        String[] stringArray;
        DvUtils.writetoTrace("Entry: DvClassCommands.processSharedClass ");
        int n2 = 0;
        int n3 = dvAddressSpace.pointerSize();
        int n4 = n;
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        long l3 = DvUtils.jvmFromThreadId(dvThread.id());
        if (0L == mirrorTable && null != (stringArray = DvUtils.getJVMHint(l3, "CLASSMIRRORS"))) {
            mirrorTable = DvUtils.hexToLong((String)stringArray);
        }
        if (0L != mirrorTable) {
            stringArray = new String[]{"Hjava_lang_Class", "obj"};
            String[] stringArray2 = new String[]{"MirroredClassData", "self"};
            String[] stringArray3 = new String[]{"MirroredClassData", "memory_table"};
            String[] stringArray4 = new String[]{"Classjava_lang_Class", "shared_class_id"};
            long l4 = mirrorTable;
            long l5 = l4 + (long)(n3 * n4);
            boolean bl = false;
            while (!bl) {
                long l6 = 0L;
                long l7 = 0L;
                long l8 = 0L;
                try {
                    long l9 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l5);
                    if (0L == l9) continue;
                    l6 = 0L;
                    l7 = 0L;
                    l7 = DvUtils.getFieldAddress(l9, stringArray, dvAddressSpace);
                    l6 = DvUtils.getFieldAddress(l7, stringArray2, dvAddressSpace);
                    l8 = DvUtils.getFieldAddress(l7, stringArray3, dvAddressSpace);
                    long l10 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l6);
                    long l11 = 0L;
                    if (0L != l10) {
                        l11 = DvUtils.getFieldAddress(l10, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
                    }
                    this.storeClass(l11, dvAddressSpace, dvDump, l2, vector, l7);
                    ++n2;
                    ++totalClassesCount;
                    long l12 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l8);
                    if (l12 != 0L) {
                        long l13 = DvUtils.getFieldAddress(l12, stringArray, dvAddressSpace);
                        int n5 = 0;
                        if (0L != l13) {
                            long l14 = DvUtils.getFieldAddress(l13, stringArray4, dvAddressSpace);
                            n5 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l14));
                        }
                        if (0 != n5) {
                            n4 = n5;
                            l5 = l4 + (long)(n3 * n4);
                            continue;
                        }
                        bl = true;
                        continue;
                    }
                    bl = true;
                }
                catch (DvAddressException dvAddressException) {
                    DvUtils.trace(" Shared classes addressing exception: \n  current_position=0x" + Long.toHexString(l5) + "\n  thisObj=0x" + Long.toHexString(l7) + "\n  selfAddress=0x" + Long.toHexString(l6) + "\n processSharedClass abandoned!!!!", 0, true);
                    bl = true;
                }
            }
        } else {
            DvUtils.trace(" !!!!processSharedClass: CLASSMIRRORS hint was not found!!!!", 0, true);
        }
        DvUtils.writetoTrace("Exit: DvClassCommands.processSharedClass (" + n2 + ")");
        return n2;
    }

    boolean storeClass(long l, DvAddressSpace dvAddressSpace, DvDump dvDump, long l2, Vector vector, long l3) {
        boolean bl = true;
        try {
            Object object;
            String string;
            long l4 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "name"}, dvAddressSpace);
            long l5 = DvUtils.getFieldAddress(l, new String[]{"MirroredClassData", "memory_table"}, dvAddressSpace);
            long l6 = 0L;
            if (0L == l3) {
                l6 = DvUtils.getFieldAddress(l, new String[]{"MirroredClassData", "static_variable_values"}, dvAddressSpace);
                l6 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l6);
            } else {
                l6 = DvUtils.getFieldAddress(l3, new String[]{"MirroredClassData", "static_variable_values"}, dvAddressSpace);
                l6 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l6);
            }
            long l7 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "major_version"}, dvAddressSpace);
            long l8 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "methods"}, dvAddressSpace);
            long l9 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l8);
            long l10 = 0L;
            l10 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "fields"}, dvAddressSpace);
            long l11 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l10);
            long l12 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "methods_count"}, dvAddressSpace);
            short s = dvAddressSpace.readShort(dvAddressSpace.createAddress(l12));
            long l13 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "fields_count"}, dvAddressSpace);
            short s2 = dvAddressSpace.readShort(dvAddressSpace.createAddress(l13));
            long l14 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "instance_size"}, dvAddressSpace);
            short s3 = dvAddressSpace.readShort(dvAddressSpace.createAddress(l14));
            long l15 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "static_variable_count"}, dvAddressSpace);
            short s4 = dvAddressSpace.readShort(dvAddressSpace.createAddress(l15));
            byte[] byArray = dvAddressSpace.readBytes(dvAddressSpace.createAddress(l7), 4L);
            long l16 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l4);
            try {
                byte[] byArray2 = dvAddressSpace.readBytes(dvAddressSpace.createAddress(l16), 256L);
                string = null != byArray2 ? DvUtils.getStringFromBytes(byArray2) : " --- unknown --- @ 0x" + Long.toHexString(l16);
            }
            catch (DvAddressException dvAddressException) {
                string = " --- unknown --- @ 0x" + Long.toHexString(l16);
            }
            long l17 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "superclass"}, dvAddressSpace);
            long l18 = dvAddressSpace.readPointer(dvAddressSpace.createAddress(l17)).getAddressAsLong();
            String string2 = " --- none ---";
            if (l18 != 0L) {
                l4 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "super_name"}, dvAddressSpace);
                l16 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l4);
                try {
                    string2 = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(dvAddressSpace.createAddress(l16), 256L));
                }
                catch (DvAddressException dvAddressException) {
                    string2 = " --- unknown --- @ 0x" + Long.toHexString(l16);
                }
            }
            long l19 = DvUtils.getFieldAddress(l, new String[]{"MirroredClassData", "loader"}, dvAddressSpace);
            long l20 = 0L;
            boolean bl2 = false;
            try {
                l20 = dvAddressSpace.readPointer(dvAddressSpace.createAddress(l19)).getAddressAsLong();
                if (0L == l20) {
                    bl2 = true;
                } else {
                    CType cType = CType.find("Classjava_lang_ClassLoader");
                    if (null != cType) {
                        DvAddress dvAddress = dvAddressSpace.createAddress(l20 + l2);
                        CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "Classjava_lang_ClassLoader");
                        CTypeObject cTypeObject2 = cTypeObject.getField("initialized");
                        int n = dvAddressSpace.readInt(dvAddress = dvAddressSpace.createAddress(cTypeObject2.getAddr()));
                        if (0 != n) {
                            bl2 = true;
                        }
                    }
                }
            }
            catch (DvAddressException dvAddressException) {
                bl2 = true;
            }
            short s5 = DvUtils.bytesToShort(byArray, 0, dvDump.getArchitecture());
            short s6 = DvUtils.bytesToShort(byArray, 2, dvDump.getArchitecture());
            boolean bl3 = false;
            long l21 = l - l2;
            if (totalClassesCount > 0 && (object = (Integer)classHashByAddr.get(new Long(l21))) != null) {
                ClassDetails classDetails = (ClassDetails)theClasses.get((Integer)object);
                if (l21 == classDetails.address) {
                    vector.add(" !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                    vector.add(" !!! Circularity detected creating class table !!!");
                    vector.add(" !!!  Class " + classDetails.name + " #" + (Integer)object + " has matching address to proposed #" + totalClassesCount + 1);
                    vector.add(" !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                    bl3 = true;
                }
            }
            if (!bl3) {
                object = new ClassDetails();
                ((ClassDetails)object).name = string;
                ((ClassDetails)object).superName = string2;
                ((ClassDetails)object).superAddress = l18;
                ((ClassDetails)object).address = l21;
                ((ClassDetails)object).major_version = s5;
                ((ClassDetails)object).minor_version = s6;
                ((ClassDetails)object).methods = l9;
                ((ClassDetails)object).fields = l11;
                ((ClassDetails)object).methods_count = s;
                ((ClassDetails)object).fields_count = s2;
                ((ClassDetails)object).loaderInitd = bl2;
                ((ClassDetails)object).instance_size = s3;
                ((ClassDetails)object).static_variable_count = s4;
                ((ClassDetails)object).static_variable_values = l6;
                ((ClassDetails)object).mirror_obj = l3 == 0L ? 0L : l3;
                theClasses.add(object);
                if (string.equals("java/lang/String")) {
                    javaLangString = object;
                }
                classHashByAddr.put(new Long(l21), new Integer(totalClassesCount));
                classHashByName.put(((ClassDetails)object).name.toUpperCase(), new Integer(totalClassesCount));
            }
        }
        catch (DvAddressException dvAddressException) {
            vector.add(" !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            vector.add(" !!! DvAddressException whilst accessing class");
            vector.add(" !!! data from file:\n" + dvAddressException.getMessage());
            vector.add(" !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        return bl;
    }

    public Vector guiMenus() {
        Vector vector = new Vector();
        vector.add(new DvMenu("Classes", 67, false));
        vector.add(new DvMenuItem("Classes", "Class Summary (tree)", -1, null, false, "displayClassSummary", thisName, null, "csDoubleClick", null, null, true));
        return vector;
    }

    public static void csDoubleClick(JInternalFrame jInternalFrame, MouseEvent mouseEvent) {
        DvUtils.writetoTrace("DvClassCommands:csDoubleClick entry");
        Object object = mouseEvent.getSource();
        if (object instanceof JTree) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = ((JTree)object).getClosestRowForLocation(n2, n = mouseEvent.getY());
            if (-1 != n3) {
                if (((JTree)object).isCollapsed(n3)) {
                    Object object2 = ((JTree)object).getLastSelectedPathComponent();
                    String string = object2.toString();
                    JInternalFrame jInternalFrame2 = Dumpviewer.theIFM.createNewFrame(string + " details", Dumpviewer.theIFM.getDefaultProperties(), 6);
                    Dumpviewer.addIFrameToDesktop(jInternalFrame2, 400, 420, 250, 150);
                    DvClassDetailsDisplay dvClassDetailsDisplay = new DvClassDetailsDisplay(jInternalFrame2, Dumpviewer.dvConsole, string, that);
                }
            } else {
                System.out.println(" getClosestRowForLocation returned -1");
            }
        } else {
            DvUtils.writetoTrace(" .... event not associated with our JTree !!! ");
        }
        DvUtils.writetoTrace("DvClassCommands:csDoubleClick exit");
    }

    public static void displayClassSummary(String string) {
        DvUtils.writetoTrace("displayClassSummary (gui) entry");
        Dvifm dvifm = DvUtils.getTheIFM();
        classSummaryJif = Dumpviewer.getInternalFrame("Class Summary", dvifm.getDefaultProperties(), 6, string);
        Dumpviewer.addIFrameToDesktop(classSummaryJif, 325, 470, 300, 75);
        SwingWorker swingWorker = new SwingWorker(){
            boolean resultFound = false;

            public Object construct() {
                Object var1_1 = null;
                classTree = DvClassCommands.getCSResults();
                if (classTree == null) {
                    System.out.println("!!!! ClassTree is null!!!!");
                }
                return var1_1;
            }

            public void finished() {
                Dumpviewer.theIFM.addContentToFrame(classSummaryJif, classTree);
                Dumpviewer.addMouseListener(classSummaryJif, classTree);
                DvUtils.writetoTrace("Finished in displayClassSummary swing worker");
            }
        };
        DvUtils.writetoTrace("... about to start worker thread ...");
        swingWorker.start();
        DvUtils.writetoTrace("displayClassSummary (gui) entry");
    }

    private static JTree getCSResults() {
        String string = "";
        boolean bl = false;
        classTree = null;
        DvUtils.writetoTrace("GetCSResults entry");
        Vector vector = new Vector();
        that.getClasses(vector);
        that.displayClasses(vector);
        if (vector instanceof Vector) {
            Vector vector2 = new Vector();
            int n = 0;
            while (n < vector.size()) {
                Object object = vector.get(n);
                if (!(object instanceof String) && object instanceof ClassDetails) {
                    vector2.add(((ClassDetails)object).name);
                }
                ++n;
            }
            int n2 = vector2.size();
            Object[] objectArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                objectArray[n3] = (String)vector2.get(n3);
                ++n3;
            }
            Arrays.sort(objectArray);
            classTree = DvClassCommands.fillNamesTree((String[])objectArray, "Classes");
        } else {
            System.out.println("Error for \"dis cls\":");
        }
        Dumpviewer.savedConsoleOutput.clear();
        DvUtils.writetoTrace("GetCSResults exit");
        return classTree;
    }

    private static JTree fillNamesTree(String[] stringArray, String string) {
        Serializable serializable;
        String string2;
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode;
        DvUtils.writetoTrace("fillNamesTree entry: " + string);
        Serializable serializable2 = defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        String string3 = "";
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = new StringTokenizer(stringArray[n2], "/");
            string2 = ((StringTokenizer)object).nextToken();
            if (!string2.startsWith("[")) {
                if (string2.equals(string3)) {
                    serializable = new DefaultMutableTreeNode(stringArray[n2]);
                    serializable2.add((MutableTreeNode)((Object)serializable));
                } else {
                    serializable = new DefaultMutableTreeNode(string2);
                    serializable2 = defaultMutableTreeNode;
                    serializable2.add((MutableTreeNode)((Object)serializable));
                    string3 = new String(string2);
                    serializable2 = serializable;
                }
            }
            ++n2;
        }
        object = new JTree(defaultMutableTreeNode);
        ((JTree)object).getSelectionModel().setSelectionMode(1);
        string2 = null;
        ((JComponent)object).setFont(new Font("Monospaced", 1, 14));
        serializable = new DefaultTreeCellRenderer();
        ((DefaultTreeCellRenderer)serializable).setLeafIcon((Icon)((Object)string2));
        ((DefaultTreeCellRenderer)serializable).setClosedIcon((Icon)((Object)string2));
        ((DefaultTreeCellRenderer)serializable).setOpenIcon((Icon)((Object)string2));
        ((JTree)object).setCellRenderer((TreeCellRenderer)((Object)serializable));
        DvUtils.writetoTrace("fillNamesTree exit: " + string);
        return object;
    }

    public static String[] classAddressList() {
        int n = theClasses.size();
        Vector vector = new Vector();
        if (0 == n) {
            that.getClasses(vector);
            n = theClasses.size();
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            ClassDetails classDetails = (ClassDetails)theClasses.get(n2);
            stringArray[n2] = "0x" + Long.toHexString(classDetails.address);
            ++n2;
        }
        return stringArray;
    }

    public static int[] getClassRefOfsets(String string, DvDump dvDump) {
        int n;
        Object object;
        int[] nArray = null;
        Vector vector = new Vector();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        FieldInfo fieldInfo = null;
        if (0 == theClasses.size()) {
            object = new DvClassCommands();
            ((CommandPlugin)object).verb = "dis";
            ((CommandPlugin)object).verbModifier = "cls";
            ((DvClassCommands)object).displayCS();
        }
        if (null == (fieldInfo = (FieldInfo)fieldsHashByName.get(string)) && null != (object = (Integer)classHashByName.get(string.toUpperCase()))) {
            ClassDetails classDetails = (ClassDetails)theClasses.get((Integer)object);
            fieldInfo = DvClassCommands.showFields(classDetails, null, true, dvDump);
        }
        if (null != fieldInfo && (n = fieldInfo.referenceOffsets.size()) > 0) {
            nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = (Integer)fieldInfo.referenceOffsets.get(n2);
                ++n2;
            }
        }
        return nArray;
    }

    static {
        javaLangString = null;
        stringValueOffset = 0L;
        mirrorTable = 0L;
        commandsSupported = new String[]{"DISPLAY,DIS,CLASSSUMMARY,CLS,displayCS,Y,N", "DISPLAY,DIS,CLASS,CL,displayClasses,Y,N"};
    }

    static class FieldInfo {
        public Vector name = new Vector();
        public Vector signature = new Vector();
        public Vector offset = new Vector();
        public Vector access = new Vector();
        public Vector referenceOffsets = new Vector();

        FieldInfo() {
        }

        public void addField(String string, String string2, long l, short s) {
            this.name.add(string);
            this.signature.add(string2);
            if (string2.startsWith("[") || string2.startsWith("L")) {
                this.referenceOffsets.add(new Integer((int)l));
            }
            this.offset.add(new Long(l));
            this.access.add(new Short(s));
        }

        public String toString() {
            String string = "";
            int n = this.name.size();
            string = string + "Field count = " + n;
            int n2 = 0;
            while (n2 < n) {
                string = string + "\n name: " + (String)this.name.get(n2);
                string = string + "\n signature: " + (String)this.signature.get(n2);
                string = string + "\n offset: " + (Long)this.offset.get(n2);
                string = string + "\n access: " + (Short)this.access.get(n2);
                ++n2;
            }
            return string;
        }
    }
}

