/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvClassDetailsDisplay;
import com.ibm.jvm.dump.format.DvClassObjects;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvMenu;
import com.ibm.jvm.dump.format.DvMenuItem;
import com.ibm.jvm.dump.format.DvNamesIndexFile;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.CommandPluginResponse;
import com.ibm.jvm.dump.plugins.DvBaseCommands;
import com.ibm.jvm.dump.plugins.DvClassCommands;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class DvObjectsCommands
extends CommandPlugin
implements ActionListener {
    private static String objSummary;
    private static String thisName;
    private static Vector theOutput;
    private static final String oSeperator = "\n============================================";
    private static boolean heapsTraversed;
    private static boolean unknownSystem;
    private static int totalObjectCount;
    private static int totalSwappedObjectCount;
    private static long totalSwappedObjectLength;
    private static int totalLockedObjectCount;
    private static JMenuItem disObjects;
    private static JMenuItem disClass;
    private static long[][] rangeArray;
    static JTree objTree;
    private static int middlewareH;
    private static int transientH;
    private static int systemH;
    private static int acsH;
    static int threadLocalH;
    private static int ptrLength;
    private static boolean is64bit;
    private static boolean isBigEndian;
    private static long allocBitsAddress;
    private static final byte[] allocBitsTestBytes;
    private static boolean verboseTLH;
    public static DvNamesIndexFile namesIndexFile;
    private static boolean address_index_built;
    private static boolean names_index_built;
    private static boolean monitorsProcessed;
    private static int javaThreadsWithoutTLH;
    private static int javaThreadsWithTLH;
    private static int javaThreadsWithoutTHTLH;
    private static int javaThreadsWithTHTLH;
    static JTree ltTree;
    static JInternalFrame lockedThreadsJif;
    private static byte[] extendedAllocBits;
    private static byte[] lockedAllocBits;
    private static long startOfMHeap;
    private static long endOfMHeap;
    private static long startOfTransHeap;
    private static long endOfTransHeap;
    private static HashSet systemHeapHashByAddr;
    private static HashSet acsHeapHashByAddr;
    private static Vector lockedObjects;
    private static Vector inflMonList;
    private static Vector regMonList;
    private static Vector threadList;
    private static Vector deadlocks;
    private static Hashtable threadsBySysthr;
    private static Hashtable threadsById;
    private static Hashtable monitorsByAddr;
    private static Hashtable monitorsBySysmon;
    private static Hashtable lockedObjectsByAddr;
    public static DvObjectsCommands that;
    private static String[] commandsSupported;
    private static DvAddressSpace as;

    public DvObjectsCommands() {
        that = this;
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String pluginName() {
        return "Object commands Plugin";
    }

    public void reset() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.reset");
        this.cpr.output(theOutput);
        theOutput.clear();
        heapsTraversed = false;
        unknownSystem = false;
        rangeArray = null;
        allocBitsAddress = 0L;
        extendedAllocBits = null;
        lockedAllocBits = null;
        startOfMHeap = 0L;
        endOfMHeap = 0L;
        startOfTransHeap = 0L;
        endOfTransHeap = 0L;
        DvUtils.safeClear(systemHeapHashByAddr);
        DvUtils.safeClear(acsHeapHashByAddr);
        DvUtils.safeClear(lockedObjects);
        DvUtils.safeClear(inflMonList);
        DvUtils.safeClear(regMonList);
        DvUtils.safeClear(threadList);
        DvUtils.safeClear(deadlocks);
        DvUtils.safeClear(threadsBySysthr);
        DvUtils.safeClear(threadsById);
        DvUtils.safeClear(monitorsByAddr);
        DvUtils.safeClear(monitorsBySysmon);
        DvUtils.safeClear(lockedObjectsByAddr);
        totalObjectCount = 0;
        totalLockedObjectCount = 0;
        middlewareH = 0;
        transientH = 0;
        systemH = 0;
        acsH = 0;
        threadLocalH = 0;
        ptrLength = 0;
        names_index_built = false;
        address_index_built = false;
        monitorsProcessed = false;
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.reset");
    }

    public void displayObjects() {
        String string;
        Object object;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayObjects");
        boolean bl = false;
        Vector vector = new Vector();
        DvDump dvDump = DvConsole.theDump;
        DvObjectsCommands.initPtrLength();
        is64bit = DvUtils.is64BitSystem(dvDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(dvDump.getArchitecture());
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (null == this.paramString) {
            theOutput.add("\"dis obj\" without parameters is invalid ... did you mean \"dis os\"?");
            this.returnControl();
            DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayObjects");
            return;
        }
        if (null != this.paramString) {
            try {
                if (this.paramString.charAt(0) == '0' && (this.paramString.charAt(1) == 'x' || this.paramString.charAt(1) == 'X')) {
                    long l = Long.parseLong(this.paramString.substring(2), 16);
                    if (!DvUtils.checkAddressInDump(as.createAddress(l), as)) {
                        theOutput.add("Not a valid address");
                        this.returnControl();
                        DvUtils.writetoTrace("Exit: 3 DvObjectsCommands.displayObjects");
                        return;
                    }
                    if (DvObjectsCommands.checkForKnownObject(l - (long)ptrLength)) {
                        ObjectDetails objectDetails = DvObjectsCommands.getObjectDetails(l - (long)ptrLength);
                        this.showObjects(objectDetails);
                    } else {
                        theOutput.add("@ 0x" + Long.toHexString(l) + " not the start of an object in the heap");
                    }
                    this.returnControl();
                    DvUtils.writetoTrace("Exit:4 DvObjectsCommands.displayObjects");
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.returnControl();
                DvUtils.writetoTrace("Exit:5 DvObjectsCommands.displayObjects The address is not valid hex");
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.returnControl();
                DvUtils.writetoTrace("Exit:6 DvObjectsCommands.displayObjects noStringIndexOutOfBoundsException:The address is not valid");
                return;
            }
            if (Character.isDigit(this.paramString.charAt(0))) {
                this.returnControl();
                DvUtils.writetoTrace("Exit:7 DvObjectsCommands.displayObjects Object names must start with letter");
                return;
            }
            object = new StringTokenizer(this.paramString, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken().trim();
                if (string.startsWith("*") || string.endsWith("*") || string.startsWith("!")) {
                    bl = true;
                }
                vector.add(string);
            }
        }
        if (vector.size() > 0 && !bl) {
            int n = 0;
            while (n < vector.size()) {
                string = (String)vector.get(n);
                long[] lArray = namesIndexFile.getInstancesForClass(string);
                if (null != lArray) {
                    int n2;
                    if (!string.startsWith("+")) {
                        n2 = 0;
                        while (n2 < lArray.length) {
                            ObjectDetails objectDetails = DvObjectsCommands.getObjectDetails(lArray[n2]);
                            this.showObjects(objectDetails);
                            ++n2;
                        }
                    } else {
                        n2 = 0;
                        while (n2 < lArray.length) {
                            theOutput.add(string + " : 0x" + Long.toHexString(lArray[n2]));
                            ++n2;
                        }
                    }
                }
                ++n;
            }
        } else {
            object = namesIndexFile.getAllClassNames();
            int n = 0;
            while (n < ((Vector)object).size()) {
                long[] lArray;
                String string2 = (String)((Vector)object).get(n);
                boolean bl2 = true;
                if (0 != vector.size()) {
                    bl2 = DvUtils.filtrate(string2, vector);
                }
                if (bl2 && null != (lArray = namesIndexFile.getInstancesForClass(string2))) {
                    int n3 = 0;
                    while (n3 < lArray.length) {
                        ObjectDetails objectDetails = DvObjectsCommands.getObjectDetails(lArray[n3]);
                        this.showObjects(objectDetails);
                        ++n3;
                    }
                }
                ++n;
            }
        }
        this.returnControl();
        DvUtils.writetoTrace("Exit:8 DvObjectsCommands.displayObjects");
    }

    public void displayObjectSummary() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayObjectSummary (nongui) ");
        boolean bl = false;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        DvDump dvDump = DvConsole.theDump;
        DvObjectsCommands.displayObjectSummary(vector2, null);
        if (0 != vector2.size()) {
            int n = 0;
            while (n < vector2.size()) {
                theOutput.add(vector2.get(n));
                ++n;
            }
        }
        theOutput.add("Finished..");
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayObjectSummary (nongui)");
    }

    public static boolean displayObjectSummary(Vector vector, JTextArea jTextArea) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayObjectSummary (joint) ");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        Vector vector2 = new Vector();
        vector.clear();
        if (null == jTextArea) {
            if (null == DvObjectsCommands.that.enhancers && null != DvObjectsCommands.that.paramString) {
                DvObjectsCommands.that.enhancers = DvUtils.splitIntoPieces(DvObjectsCommands.that.paramString, " ");
            }
            if (null != DvObjectsCommands.that.enhancers) {
                int n = 0;
                String[] stringArray = new String[]{"i", "t", "n", "a", "d"};
                if (that.enhancersCheck(stringArray)) {
                    bl = that.enhancerIsPresent("i");
                    if (bl) {
                        ++n;
                    }
                    if (bl3 = that.enhancerIsPresent("t")) {
                        ++n;
                    }
                    if (bl2 = that.enhancerIsPresent("n")) {
                        ++n;
                    }
                    bl4 = that.enhancerIsPresent("a");
                    bl5 = that.enhancerIsPresent("d");
                } else {
                    bl6 = true;
                }
                if (0 == n && !bl2) {
                    bl = true;
                }
                if (!bl4 && !bl5) {
                    bl4 = true;
                }
                if (n > 1 || bl4 && bl5) {
                    bl6 = true;
                }
            } else {
                bl = true;
                bl4 = true;
            }
        } else {
            bl2 = true;
        }
        if (!bl4 && !bl5) {
            bl4 = true;
        }
        if (bl6) {
            vector.add("\n Invalid combination of command enhancers; " + DvObjectsCommands.that.enhancers + "\n");
        } else {
            DvObjectsCommands.initPtrLength();
            is64bit = DvUtils.is64BitSystem(DvConsole.theDump.getArchitecture());
            isBigEndian = DvUtils.isBigEndian(DvConsole.theDump.getArchitecture());
            as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
            if (!heapsTraversed) {
                objSummary = null;
                DvObjectsCommands.traverseAllHeaps(jTextArea);
            }
            if (DvObjectsCommands.checkLKGLOBALPTR() == 1 && !monitorsProcessed) {
                DvObjectsCommands.processMonitors();
            }
            if (0 == threadList.size()) {
                DvObjectsCommands.processThreads();
            }
            vector.add("\n\n Objects Summary\n ===============\n");
            objSummary = "\n Number of objects found via Thread Local Heap   = " + threadLocalH + "\n Number of objects found via Middleware Heap     = " + middlewareH + "\n Number of objects found via Transient Heap      = " + transientH + "\n Number of objects found via System Heap         = " + systemH + "\n Number of objects found via ACS Classes Heap    = " + acsH + "\n\n" + " Total number of objects found via all Heaps     = " + totalObjectCount + "\n\n" + " Total number of \"Swapped\" objects            = " + totalSwappedObjectCount + " (" + totalSwappedObjectLength + " bytes)\n\n";
            vector.add(objSummary);
            vector.add(namesIndexFile.summary(bl, bl3, bl2, bl4));
            vector.add("\n Number of Locked objects  = " + totalLockedObjectCount + "\n");
            if (totalSwappedObjectCount != 0) {
                vector.add("\n *** As various heap objects were marked as \"Swapped\" then\n    its likely that heap compaction was taking place when this\n    jvm was dumped. The addresses of the marked objects can be\n    found via \" Dis obj(+IsSwapped+) \" *** \n");
            }
        }
        DvUtils.writetoTrace("Exit:DvObjectsCommands.displayObjectSummary (joint) ");
        return true;
    }

    public void displayLocks() {
        String string;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayLocks");
        boolean bl = false;
        Vector vector = new Vector();
        DvDump dvDump = DvConsole.theDump;
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (null == this.paramString) {
            theOutput.add("This commands needs a parameter\n");
            this.returnControl();
            DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayLocks");
            return;
        }
        try {
            if (this.paramString.charAt(0) == '0' && (this.paramString.charAt(1) == 'x' || this.paramString.charAt(1) == 'X')) {
                long l = Long.parseLong(this.paramString.substring(2), 16);
                if (!DvUtils.checkAddressInDump(as.createAddress(l), as)) {
                    theOutput.add("Not a valid address");
                    this.returnControl();
                    DvUtils.writetoTrace("Exit:3 DvObjectsCommands.displayLocks");
                    return;
                }
                if (DvObjectsCommands.checkForKnownObject(l - (long)ptrLength)) {
                    ObjectDetails objectDetails = DvObjectsCommands.getObjectDetails(l - (long)ptrLength);
                    this.showObjects(objectDetails);
                } else {
                    theOutput.add("@ 0x" + Long.toHexString(l) + " not the start of an object in the heap");
                }
                this.returnControl();
                DvUtils.writetoTrace("Exit:4 DvObjectsCommands.displayLocks");
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:5 DvObjectsCommands.displayLocks The address is not valid hex");
            return;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:6 DvObjectsCommands.displayLocks StringIndexOutOfBoundsException:The address is not valid");
            return;
        }
        if (Character.isDigit(this.paramString.charAt(0))) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:7 DvObjectsCommands.displayLocks Object names must start with letter");
            return;
        }
        Object object = new StringTokenizer(this.paramString, ",");
        while (((StringTokenizer)object).hasMoreTokens()) {
            string = ((StringTokenizer)object).nextToken().trim();
            if (string.startsWith("*") || string.endsWith("*") || string.startsWith("!")) {
                bl = true;
            }
            vector.add(string);
        }
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (vector.size() > 0 && !bl) {
            int n = 0;
            while (n < vector.size()) {
                string = (String)vector.get(n);
                long[] lArray = namesIndexFile.getInstancesForClass(string);
                if (null != lArray) {
                    int n2 = 0;
                    while (n2 < lArray.length) {
                        ObjectDetails objectDetails = DvObjectsCommands.getObjectDetails(lArray[n2]);
                        this.showLocks(objectDetails);
                        ++n2;
                    }
                }
                ++n;
            }
        } else {
            object = namesIndexFile.getAllClassNames();
            int n = 0;
            while (n < ((Vector)object).size()) {
                long[] lArray;
                String string2 = (String)((Vector)object).get(n);
                boolean bl2 = true;
                if (0 != vector.size()) {
                    bl2 = DvUtils.filtrate(string2, vector);
                }
                if (bl2 && null != (lArray = namesIndexFile.getInstancesForClass(string2))) {
                    int n3 = 0;
                    while (n3 < lArray.length) {
                        ObjectDetails objectDetails = DvObjectsCommands.getObjectDetails(lArray[n3]);
                        this.showLocks(objectDetails);
                        ++n3;
                    }
                }
                ++n;
            }
        }
        this.returnControl();
        DvUtils.writetoTrace("Exit:8 DvObjectsCommands.displayLocks");
    }

    public void displayLockSummary() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayLockSummary");
        DvDump dvDump = DvConsole.theDump;
        DvObjectsCommands.initPtrLength();
        is64bit = DvUtils.is64BitSystem(dvDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(dvDump.getArchitecture());
        theOutput.add("");
        theOutput.add("");
        theOutput.add("LOCKING INFORMATION:");
        theOutput.add("");
        if (1 == DvObjectsCommands.checkLKGLOBALPTR()) {
            long l = Long.parseLong(DvUtils.getJVMHint(as, "LKGLOBALPTR"), 16);
            theOutput.add("To view the locking global data:");
            theOutput.add("format 0x" + Long.toHexString(l) + " as _lkgldata");
            theOutput.add("");
        } else {
            DvUtils.writetoTrace("Continue:1 DvObjectsCommands.displayLockSummary No locking global pointer displayMonitorPoolDump(\"dis ls\")");
        }
        if (1 == DvObjectsCommands.checkLKGLOBALPTR()) {
            theOutput.addAll(this.displayMonitorPoolDump("dis ls", null));
        } else {
            DvUtils.writetoTrace("Continue:2 DvObjectsCommands.displayLockSummary No locking global pointer displayMonitorPoolDump(\"dis ls\",null)");
        }
        if (1 == DvObjectsCommands.checkLKGLOBALPTR()) {
            theOutput.addAll(this.displaySysMonitorDump("dis ls"));
        } else {
            DvUtils.writetoTrace("Continue:3 DvObjectsCommands.displayLockSummary No locking global pointer displaySysMonitorDump(\"dis ls\")");
        }
        theOutput.addAll(this.displayThreadIdent("dis ls"));
        theOutput.addAll(this.displayJavaObjMonDump("dis ls"));
        this.findDeadlock();
        theOutput.add("Finished..");
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayLockSummary");
    }

    private static int checkLKGLOBALPTR() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.checkLKGLOBALPTR");
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        long l = Long.parseLong(DvUtils.getJVMHint(as, "LKGLOBALPTR"), 16);
        long l2 = Long.parseLong(DvUtils.getJVMHint(as, "DGGLOBALPTR"), 16);
        if (l == l2) {
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.checkLKGLOBALPTR");
            return 0;
        }
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.checkLKGLOBALPTR");
        return 1;
    }

    private DvThread getDvThread(String string) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.getDvThread");
        DvProcess dvProcess = (DvProcess)DvUtils.getAPT(DvConsole.theDump, "P");
        DvThread[] dvThreadArray = dvProcess.getThreads();
        int n = 0;
        while (n < dvThreadArray.length) {
            if (dvThreadArray[n].isJava() && string == dvThreadArray[n].id()) {
                DvUtils.writetoTrace("Exit:1 DvObjectsCommands.getDvThread");
                return dvThreadArray[n];
            }
            ++n;
        }
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.getDvThread");
        return null;
    }

    private Vector displayMonitorPoolInfo(String string) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayMonitorPoolInfo");
        Vector vector = new Vector();
        if (string.equals(new String("javacore"))) {
            vector.add("1LKPOOLINFO");
            vector.add("Monitor pool info:");
            vector.add("2LKPOOLINIT");
            vector.add("  Initial monitor count: 32");
            vector.add("2LKPOOLEXPNUM");
            vector.add("  Minumum number of free moniors before expansion: 5");
            vector.add("2LKPOOLEXPBY");
            vector.add("  Pool will next be expanded by: <unknown>");
            vector.add("2LKPOOLTOTAL");
            vector.add("  Current total number of free monitors: <unknown>");
            vector.add("2LKPOOLFREE");
            vector.add("  Current number of free monitors: <unknown>");
            vector.add("NULL");
            vector.add("");
        } else {
            vector.add("");
            vector.add("Monitor pool info:");
            vector.add("  Initial monitor count: 32");
            vector.add("  Minumum number of free moniors before expansion: 5");
            vector.add("  Pool will next be expanded by: <unknown>");
            vector.add("  Current total number of free monitors: <unknown>");
            vector.add("  Current number of free monitors: <unknown>");
            vector.add("");
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.displayMonitorPoolInfo");
        return vector;
    }

    private Vector displayMonitorPoolDump(String string, ObjectDetails objectDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayMonitorPoolDump(String, ObjectDetails)");
        if (!monitorsProcessed) {
            DvObjectsCommands.processMonitors();
        }
        Vector vector = new Vector();
        if (string.equals(new String("javacore"))) {
            vector.addElement("1LKMONPOOLDUMP");
            vector.addElement("Monitor Pool Dump (flat & inflated object-monitors):");
        }
        if (string.equals(new String("dis ls"))) {
            vector.add("");
            vector.add("Inflated Object-Monitors:");
        }
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        if (string.equals(new String("dis ls"))) {
            long l = Long.parseLong(DvUtils.getJVMHint(as, "LKGLOBALPTR"), 16);
            long l2 = DvObjectsCommands.getControlBlockField("_lkgldata", "micb", l, as);
            vector.add("     Information is from a table of inflated monitors:");
            vector.add("         monitor_index_cb_t 0x" + Long.toHexString(l2));
            vector.add("");
        }
        boolean bl = false;
        if (null == lockedObjectsByAddr) {
            bl = true;
            lockedObjectsByAddr = new Hashtable();
        }
        int n = 0;
        while (n < inflMonList.size()) {
            long l;
            MonDetails monDetails = (MonDetails)inflMonList.elementAt(n);
            if (string.equals(new String("javacore"))) {
                vector.add("2LKMONINUSE");
                vector.add("  sys_mon_t:0x" + Long.toHexString(monDetails.getSysMon()) + " infl_mon_t: 0x" + Long.toHexString(monDetails.getAddress()));
            }
            if (string.equals(new String("dis ls"))) {
                vector.add("(0x" + Long.toHexString(monDetails.getAddress()) + ")");
            }
            if (DvObjectsCommands.checkForKnownObject((l = monDetails.getObjectAddress()) - (long)ptrLength)) {
                Object object;
                ObjectDetails objectDetails2 = null;
                if (!bl) {
                    objectDetails2 = (ObjectDetails)lockedObjectsByAddr.get(new Long(l - (long)ptrLength));
                } else {
                    object = new Long(l - (long)ptrLength);
                    objectDetails2 = DvObjectsCommands.getObjectDetails(l - (long)ptrLength);
                    lockedObjectsByAddr.put(object, objectDetails2);
                }
                object = "";
                if (string.equals(new String("javacore"))) {
                    object = "    " + monDetails.getObjectName() + "@" + Long.toHexString(monDetails.getObjectAddress()) + "/" + Long.toHexString(monDetails.getObjectAddress() + 8L) + ":";
                }
                if (string.equals(new String("dis ls")) || string.equals(new String("dis lo")) && objectDetails.address == objectDetails2.address) {
                    object = "    (0x" + Long.toHexString(monDetails.getObjectAddress()) + ") " + monDetails.getObjectName();
                    vector.add(object);
                    object = "";
                }
                if (DvUtils.checkAddressInDump(as.createAddress(monDetails.getOwnerAddress()), as) && 0L != monDetails.getOwnerAddress()) {
                    long l3 = 4 == DvConsole.theDump.getSystemType() ? DvObjectsCommands.getControlBlockFieldInt("sys_mon", "monitor_usecount", monDetails.getSysMon(), as) : DvObjectsCommands.getControlBlockFieldInt("sys_mon", "entry_count", monDetails.getSysMon(), as);
                    if (string.equals(new String("javacore"))) {
                        object = (String)object + " owner \"" + monDetails.getOwnerName() + "\" (0x" + Long.toHexString(monDetails.getOwnerAddress()) + ") " + "entry count " + l3;
                    }
                    if (string.equals(new String("dis ls")) || string.equals(new String("dis lo")) && objectDetails.address == objectDetails2.address) {
                        object = (String)object + "        inflated lock owned by " + this.r("0x" + monDetails.getOwnerThreadID(), 10) + " \"" + monDetails.getOwnerName() + "\", entry count " + l3;
                    }
                } else if (objectDetails2.lock && 0L == objectDetails2.shapeBit) {
                    if (string.equals(new String("javacore"))) {
                        object = (String)object + " flat locked by thread ident " + this.r(Long.toString(objectDetails2.threadId), 8) + " " + this.r("(0x" + Long.toHexString(objectDetails2.threadId) + ")", 12) + ", entry count " + objectDetails2.entryCount + " ";
                    }
                    if (string.equals(new String("dis ls")) || string.equals(new String("dis lo")) && objectDetails.address == objectDetails2.address) {
                        ThreadDetails threadDetails;
                        if (0 == threadList.size()) {
                            DvObjectsCommands.processThreads();
                        }
                        if ((threadDetails = (ThreadDetails)threadsById.get(Long.toHexString(objectDetails2.threadId))) != null) {
                            object = (String)object + "        flat locked by " + this.r("0x" + threadDetails.getThreadID(), 10) + " \"" + threadDetails.getThreadName() + "\"" + ", entry count " + objectDetails2.entryCount + " ";
                        }
                    }
                } else {
                    if (string.equals(new String("javacore"))) {
                        object = (String)object + "<unowned>";
                    }
                    if (string.equals(new String("dis ls")) || string.equals(new String("dis lo")) && objectDetails.address == objectDetails2.address) {
                        object = (String)object + "        <unowned>";
                    }
                }
                if (string.equals(new String("javacore"))) {
                    vector.addElement("3LKMONOBJECT");
                    vector.addElement(object);
                }
                if (string.equals(new String("dis ls")) || string.equals(new String("dis lo")) && objectDetails.address == objectDetails2.address) {
                    vector.add(object);
                    this.waitAndEnterQ(string, monDetails, vector);
                }
                object = "";
            } else {
                if (string.equals(new String("javacore"))) {
                    vector.add("3LKWAITNOTIFY");
                    vector.add("    unknown object at: 0x" + Long.toHexString(l - (long)ptrLength));
                }
                if (string.equals(new String("dis ls"))) {
                    vector.add("    unknown object at: 0x" + Long.toHexString(l - (long)ptrLength));
                }
            }
            if (string.equals(new String("dis ls"))) {
                vector.add("");
            }
            ++n;
        }
        if (string.equals(new String("javacore"))) {
            vector.add("NULL");
            vector.add("");
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.displayMonitorPoolDump(String, ObjectDetails)");
        return vector;
    }

    private Vector displaySysMonitorDump(String string) {
        long l;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displaySysMonitorDump");
        if (!monitorsProcessed) {
            DvObjectsCommands.processMonitors();
        }
        Vector vector = new Vector();
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        if (string.equals(new String("javacore"))) {
            vector.add("1LKREGMONDUMP");
            vector.add("JVM System Monitor Dump (registered monitors): ");
        }
        if (string.equals(new String("dis ls"))) {
            vector.add("");
            vector.add("Registered Monitors: ");
        }
        if (string.equals(new String("dis ls"))) {
            long l2 = Long.parseLong(DvUtils.getJVMHint(as, "LKGLOBALPTR"), 16);
            l = DvObjectsCommands.getControlBlockField("_lkgldata", "reg", l2, as);
            vector.add(" Pointer to first registry monitor (0x" + Long.toHexString(l) + ")");
            vector.add("");
        }
        int n = 0;
        while (n < regMonList.size()) {
            MonDetails monDetails = (MonDetails)regMonList.elementAt(n);
            l = monDetails.getSysMon();
            long l3 = monDetails.getOwnerAddress();
            if (string.equals(new String("dis ls"))) {
                vector.addAll(this.showReg(monDetails));
            }
            if (DvUtils.checkAddressInDump(as.createAddress(l3), as) && 0L != l3) {
                long l4 = 0L;
                l4 = 4 == DvConsole.theDump.getSystemType() ? DvObjectsCommands.getControlBlockFieldInt("sys_mon", "monitor_usecount", l, as) : DvObjectsCommands.getControlBlockFieldInt("sys_mon", "entry_count", l, as);
                if (string.equals(new String("javacore"))) {
                    vector.add("2LKREGMON");
                    vector.add("    " + monDetails.getName() + ":" + "owner \"" + monDetails.getOwnerName() + "\" (0x" + Long.toHexString(l) + ")" + ", entry count " + l4);
                }
            } else if (string.equals(new String("javacore"))) {
                vector.add("2LKREGMON");
                vector.add("    " + monDetails.getName() + ": <unowned>");
            }
            if (!string.equals(new String("dis ls"))) {
                this.waitAndEnterQ(string, monDetails, vector);
            }
            ++n;
        }
        if (string.equals(new String("javacore"))) {
            vector.add("NULL");
            vector.add("");
        }
        if (string.equals(new String("dis ls"))) {
            vector.add("");
        }
        DvUtils.writetoTrace("Exit:5 DvObjectsCommands.displaySysMonitorDump");
        return vector;
    }

    private void waitAndEnterQ(String string, MonDetails monDetails, Vector vector) {
        int n;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.waitAndEnterQ");
        if (0L < monDetails.getEnterSize()) {
            if (string.equals(new String("javacore"))) {
                vector.add("3LKENTERQ ");
                vector.add("       Waiting to enter:");
            }
            if (string.equals(new String("dis ls")) || string.equals(new String("dis lo"))) {
                vector.add("            Waiting to enter:");
            }
            n = 0;
            while ((long)n < monDetails.getEnterSize()) {
                if (string.equals(new String("javacore"))) {
                    vector.add("3LKWAITENTER ");
                    vector.add("          \"" + monDetails.getEnterName(n) + "\" (0x" + Long.toHexString(monDetails.getEnterAddress(n)) + ")");
                }
                if (string.equals(new String("dis ls")) || string.equals(new String("dis lo"))) {
                    vector.add("              " + this.r("0x" + monDetails.getEnterThreadID(n), 10) + " \"" + monDetails.getEnterName(n) + "\" ");
                }
                ++n;
            }
        }
        if (0L < monDetails.getWaiterSize()) {
            if (string.equals(new String("javacore"))) {
                vector.add("3LKNOTIFYQ");
                vector.add("       Waiting to be notified:");
            }
            if (string.equals(new String("dis ls")) || string.equals(new String("dis lo"))) {
                vector.add("            Waiting to be notified:");
            }
            n = 0;
            while ((long)n < monDetails.getWaiterSize()) {
                if (string.equals(new String("javacore"))) {
                    vector.add("3LKWAITNOTIFY");
                    vector.add("          \"" + monDetails.getWaiterName(n) + "\" (0x" + Long.toHexString(monDetails.getWaiterAddress(n)) + ")");
                }
                if (string.equals(new String("dis ls")) || string.equals(new String("dis lo"))) {
                    vector.add("              " + this.r("0x" + monDetails.getWaiterThreadID(n), 10) + " " + " \"" + monDetails.getWaiterName(n) + "\" ");
                }
                ++n;
            }
            DvUtils.writetoTrace("Exit:DvObjectsCommands.waitAndEnterQ");
        }
    }

    private Vector displayThreadIdent(String string) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayThreadIdent");
        if (0 == threadList.size()) {
            DvObjectsCommands.processThreads();
        }
        Vector vector = new Vector();
        if (string.equals(new String("javacore"))) {
            vector.add("1LKFLATMONDUMP");
            vector.add("Thread identifiers (as used in flat monitors)");
        }
        if (string.equals(new String("dis ls"))) {
            vector.add("");
            vector.add("Thread Identifiers:");
            vector.add("");
        }
        int n = 0;
        while (n < threadList.size()) {
            ThreadDetails threadDetails = (ThreadDetails)threadList.elementAt(n);
            if (string.equals(new String("javacore"))) {
                vector.add("2LKFLATMON");
                vector.add("    ident 0x" + Long.toHexString(threadDetails.getThreadIdent()) + " \"" + threadDetails.getThreadName() + "\" (0x" + Long.toHexString(threadDetails.getSysThr()) + ") " + "ee 0x" + Long.toHexString(threadDetails.getEE()));
            }
            if (string.equals(new String("dis ls"))) {
                vector.add(this.r("0x" + threadDetails.getThreadID(), 10) + " " + " \"" + threadDetails.getThreadName() + "\"");
                vector.add("");
            }
            ++n;
        }
        if (string.equals(new String("javacore"))) {
            vector.add("NULL");
            vector.add("");
        }
        if (string.equals(new String("dis ls"))) {
            vector.add("");
        }
        DvUtils.writetoTrace("Exit:3 DvObjectsCommands.displayThreadIdent unexpected exception");
        return vector;
    }

    private static void processMonitors() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processMonitors");
        monitorsByAddr = new Hashtable(1000, 1000.0f);
        monitorsBySysmon = new Hashtable(1000, 1000.0f);
        DvObjectsCommands.processInflatedMonitors();
        DvObjectsCommands.processRegisteredMonitors();
        int n = 0;
        while (n < threadList.size()) {
            MonDetails monDetails;
            long l;
            MonDetails monDetails2;
            ThreadDetails threadDetails = (ThreadDetails)threadList.elementAt(n);
            long l2 = threadDetails.getEnterMon();
            if (l2 != 0L && (monDetails2 = (MonDetails)monitorsBySysmon.get(Long.toHexString(l2))) != null) {
                ThreadDetails threadDetails2 = (ThreadDetails)threadsBySysthr.get(Long.toHexString(monDetails2.getOwnerAddress()));
                threadDetails.addBlockingThread(threadDetails2);
            }
            if ((l = threadDetails.getWaitMon()) != 0L && (monDetails = (MonDetails)monitorsByAddr.get(Long.toHexString(l))) != null) {
                long l3;
                ThreadDetails threadDetails3 = (ThreadDetails)threadsBySysthr.get(Long.toHexString(monDetails.getOwnerAddress()));
                if (threadDetails3 == null && (l3 = monDetails.getObjectAddress()) != 0L) {
                    ObjectDetails objectDetails = DvObjectsCommands.getObjectDetails(l3 - (long)ptrLength);
                    threadDetails3 = (ThreadDetails)threadsById.get(Long.toHexString(objectDetails.threadId));
                }
                threadDetails.addBlockingThread(threadDetails3);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < threadList.size()) {
            ThreadDetails threadDetails = null;
            ThreadDetails threadDetails4 = (ThreadDetails)threadList.elementAt(n2);
            if (!threadDetails4.processed) {
                threadDetails = threadDetails4;
                do {
                    threadDetails.incDeadlocked();
                } while ((threadDetails = threadDetails.getBlockingThread()) != null && !threadDetails.processed && threadDetails.getDeadlocked() < 3);
                if (threadDetails == null) {
                    threadDetails = threadDetails4;
                    while (threadDetails != null) {
                        threadDetails.processed = true;
                        threadDetails.decDeadlocked();
                        threadDetails = threadDetails.getBlockingThread();
                    }
                } else {
                    threadDetails.decDeadlocked();
                    if (threadDetails.processed) {
                        threadDetails = threadDetails4;
                        do {
                            threadDetails.processed = true;
                        } while (!(threadDetails = threadDetails.getBlockingThread()).processed);
                    } else {
                        threadDetails4 = threadDetails;
                        do {
                            threadDetails.processed = true;
                        } while (!(threadDetails = threadDetails.getBlockingThread()).processed);
                        deadlocks.addElement(threadDetails4);
                    }
                }
            }
            ++n2;
        }
        monitorsProcessed = true;
    }

    /*
     * Unable to fully structure code
     */
    private static void processInflatedMonitors() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processInflatedMonitors");
        DvObjectsCommands.as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        var0 = DvConsole.theDump.getSystemType();
        var1_1 = Long.parseLong(DvUtils.getJVMHint(DvObjectsCommands.as, "LKGLOBALPTR"), 16);
        var3_2 = DvObjectsCommands.getControlBlockField("_lkgldata", "micb", var1_1, DvObjectsCommands.as);
        var5_3 = DvObjectsCommands.getControlBlockField("monitor_index_cb_t", "table", var3_2, DvObjectsCommands.as);
        var7_4 = DvObjectsCommands.getControlBlockFieldInt("monitor_index_cb_t", "count", var3_2, DvObjectsCommands.as);
        var9_5 = 0L;
        var11_6 = 1;
        DvObjectsCommands.initPtrLength();
        try {
            var9_5 = DvObjectsCommands.as.readPointer(DvObjectsCommands.as.createAddress(var5_3)).getAddressAsLong();
        }
        catch (DvAddressException var12_7) {
            DvUtils.writetoTrace("Continue:1 processInflatedMonitors DvAddressException");
            return;
        }
        var5_3 += (long)DvObjectsCommands.ptrLength;
        if (var9_5 == 0L) ** GOTO lbl35
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processInflatedMonitors(String, ObjectDetails)");
        return;
lbl-1000:
        // 1 sources

        {
            try {
                var9_5 = DvObjectsCommands.as.readPointer(DvObjectsCommands.as.createAddress(var5_3)).getAddressAsLong();
            }
            catch (DvAddressException var12_9) {
                DvUtils.writetoTrace("Continue:3 DvObjectsCommands.processInflatedMonitors DvAddressException");
            }
            var12_8 = new MonDetails(var9_5, true);
            if (var12_8.isOwnedOrWaitedOn()) {
                DvObjectsCommands.processMonitor(var12_8);
                DvObjectsCommands.inflMonList.add(var12_8);
            } else {
                DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processInflSub(long)");
            }
            ++var11_6;
            var5_3 += (long)DvObjectsCommands.ptrLength;
lbl35:
            // 2 sources

            ** while (var7_4 - (long)var11_6 > 0L)
        }
lbl36:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    private static void processRegisteredMonitors() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processRegisteredMonitors");
        var4 = 0L;
        var6_1 = "";
        var7_2 = "";
        DvObjectsCommands.as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        try {
            var8_3 = Long.parseLong(DvUtils.getJVMHint(DvObjectsCommands.as, "LKGLOBALPTR"), 16);
            var0_6 = DvObjectsCommands.getControlBlockField("_lkgldata", "reg", var8_3, DvObjectsCommands.as);
            var2_7 = DvObjectsCommands.as.readPointer(DvObjectsCommands.as.createAddress(var0_6)).getAddressAsLong();
            if (true) ** GOTO lbl20
        }
        catch (DvAddressException var8_4) {
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processRegisteredMonitors DvAddressException in displaySysMonitorDump Unable to get the first reg_mon");
            return;
        }
        do {
            var8_5 = new MonDetails(var2_7, false);
            DvObjectsCommands.processMonitor(var8_5);
            DvObjectsCommands.regMonList.add(var8_5);
            var2_7 = DvObjectsCommands.getControlBlockField("reg_mon", "next", var2_7, DvObjectsCommands.as);
lbl20:
            // 2 sources

        } while (var2_7 != 0L && DvUtils.checkAddressInDump(DvObjectsCommands.as.createAddress(var2_7), DvObjectsCommands.as));
        DvUtils.writetoTrace("Exit:5 DvObjectsCommands.processRegisteredMonitors");
    }

    private static void processMonitor(MonDetails monDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processMonitor(MonDetails monitor)");
        long l = monDetails.getWaitQ(0);
        long l2 = monDetails.getWaitQ(1);
        boolean bl = false;
        if (l == 0L) {
            l = l2;
            bl = true;
        }
        while (l != 0L) {
            long l3 = monDetails.getWaitQThread(l);
            monDetails.addWaiter(l3);
            ThreadDetails threadDetails = (ThreadDetails)threadsBySysthr.get(Long.toHexString(l3));
            if (null == threadDetails) {
                threadDetails = new ThreadDetails(l3, "Dummy!!!", 0L, 0L, "Dummy!!!");
                DvUtils.trace("*** Unexpected event in DvObjectsCommands.processMonitor() \n\"One or more of our threads may have gone astray ......\"\n waitQ thread identified by  \"" + Long.toHexString(l3) + "\"\n is specified in monitor with address 0x" + Long.toHexString(monDetails.monAddr) + "\n and couldn't be located in threadsBySysthr" + "\nFurther investigation suggested", 0, true);
            }
            threadDetails.addWaitMon(monDetails.getAddress());
            l = monDetails.getNextWaitQ(l);
            if (l != 0L || bl) continue;
            l = l2;
            bl = true;
        }
    }

    private static void processThreads() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processThreads");
        DvDump dvDump = DvConsole.getCurrentDump();
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        DvAddress dvAddress = null;
        DvProcess[] dvProcessArray = as.getProcesses();
        int n = 0;
        while (n < dvProcessArray.length) {
            DvThread[] dvThreadArray = dvProcessArray[n].getThreads();
            threadsBySysthr = new Hashtable(dvThreadArray.length);
            threadsById = new Hashtable(dvThreadArray.length);
            int n2 = 0;
            while (n2 < dvThreadArray.length) {
                if (dvThreadArray[n2].isJava()) {
                    CTypeObject cTypeObject = new CTypeObject("execenv", dvThreadArray[n2].eeAddress(), as);
                    if (cTypeObject == null || as == null || dvThreadArray[n2] == null) {
                        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processThreads unexpected NULL variable");
                        return;
                    }
                    if (dvThreadArray[n2].eeAddress().getAddressAsLong() == 0L) {
                        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.processThreads");
                        return;
                    }
                    CTypeObject cTypeObject2 = null;
                    cTypeObject2 = cTypeObject.getField("lk_thread_local.lk.flc");
                    CTypeObject cTypeObject3 = cTypeObject2.getField("thread_ident");
                    if (cTypeObject3 == null) {
                        DvUtils.writetoTrace("Continue:1 DvObjectsCommands.processThreads unexpected NULL variable");
                    } else {
                        long l;
                        try {
                            dvAddress = as.readPointer(as.createAddress(cTypeObject3.getAddr()));
                        }
                        catch (DvAddressException dvAddressException) {
                            DvUtils.writetoTrace("Continue:2 DvObjectsCommands.processThreads() DvAddressException getThreadName");
                        }
                        if (null != dvAddress) {
                            l = dvAddress.getAddressAsLong();
                        } else {
                            l = 0L;
                            DvUtils.trace("*** Unexpected event in DvObjectsCommands.processThreads() \n for thread " + dvThreadArray[n2].id() + "(" + DvUtils.getThreadName(dvThreadArray[n2], as) + ")" + "\nMight be worthy of further investigation", 0, true);
                        }
                        if (l != 0L) {
                            String string = "";
                            try {
                                string = DvObjectsCommands.threadName(dvThreadArray[n2], as);
                            }
                            catch (DvAddressException dvAddressException) {
                                DvUtils.writetoTrace("Continue:3 DvObjectsCommands.processThreads() DvAddressException getThreadName");
                            }
                            CTypeObject cTypeObject4 = cTypeObject.getField("sys_thr");
                            ThreadDetails threadDetails = new ThreadDetails(l >> 16, string, cTypeObject.getAddr(), cTypeObject4.getAddr(), dvThreadArray[n2].id());
                            threadList.add(threadDetails);
                            long l2 = cTypeObject4.getAddr();
                            threadsBySysthr.put(Long.toHexString(l2), threadDetails);
                            threadsById.put(Long.toHexString(threadDetails.thread_ident), threadDetails);
                        }
                    }
                } else {
                    DvUtils.writetoTrace("Continue:4 DvObjectsCommands.processThreads non-Java thread");
                }
                ++n2;
            }
            ++n;
        }
        DvUtils.writetoTrace("Exit:3 DvObjectsCommands.processThreads unexpected exception");
    }

    private Vector displayJavaObjMonDump(String string) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayJavaObjMonDump(String)");
        Vector vector = new Vector();
        if (string.equals(new String("javacore"))) {
            vector.add("1LKOBJMONDUMP");
            vector.add("Java Object Monitor Dump (flat & inflated object-monitors):");
        }
        if (string.equals(new String("dis ls"))) {
            vector.add("");
            vector.add("Flat & Inflated Object-Monitors:");
        }
        int n = lockedObjects.size();
        boolean bl = false;
        if (null == lockedObjectsByAddr) {
            bl = true;
            lockedObjectsByAddr = new Hashtable();
        }
        int n2 = 0;
        while (n2 < n) {
            Long l = (Long)lockedObjects.get(n2);
            long l2 = l;
            ObjectDetails objectDetails = null;
            if (bl) {
                objectDetails = DvObjectsCommands.getObjectDetails(l2);
                lockedObjectsByAddr.put(l, objectDetails);
            } else {
                objectDetails = (ObjectDetails)lockedObjectsByAddr.get(l);
            }
            if (null == objectDetails) {
                objectDetails = DvObjectsCommands.getObjectDetails(l2);
                lockedObjectsByAddr.put(l, objectDetails);
            }
            if (0L == objectDetails.shapeBit) {
                if (string.equals(new String("javacore"))) {
                    vector.add("2LKINFLATEDMON");
                    vector.add("    " + objectDetails.objectName + "@" + Long.toHexString(objectDetails.address) + "/" + Long.toHexString(objectDetails.address + 8L));
                    vector.add("3LKINFLDETAILS");
                    vector.add("        locknflags " + Long.toHexString(objectDetails.locknflags) + " flat locked by thread ident " + objectDetails.threadId + ", entry count " + objectDetails.entryCount);
                }
                if (string.equals(new String("dis ls"))) {
                    ThreadDetails threadDetails;
                    if (0 == threadList.size()) {
                        DvObjectsCommands.processThreads();
                    }
                    if ((threadDetails = (ThreadDetails)threadsById.get(Long.toHexString(objectDetails.threadId))) != null) {
                        vector.add("");
                        vector.add("    (0x" + Long.toHexString(objectDetails.address) + ") " + objectDetails.objectName + " ");
                        vector.add("        flat locked by 0x" + threadDetails.getThreadID() + " \"" + threadDetails.getThreadName() + "\", entry count " + objectDetails.entryCount);
                    }
                    if (!monitorsProcessed) {
                        DvObjectsCommands.processMonitors();
                    }
                    int n3 = 0;
                    while (n3 < inflMonList.size()) {
                        MonDetails monDetails = (MonDetails)inflMonList.elementAt(n3);
                        long l3 = monDetails.getObjectAddress();
                        if (l3 == objectDetails.address && 0L < monDetails.getWaiterSize()) {
                            vector.add("            Waiting to be notified:");
                            int n4 = 0;
                            while ((long)n4 < monDetails.getWaiterSize()) {
                                vector.add("              " + this.r("0x" + monDetails.getWaiterThreadID(n4), 10) + " \"" + monDetails.getWaiterName(n4) + "\" ");
                                ++n4;
                            }
                        }
                        ++n3;
                    }
                }
            } else {
                if (string.equals(new String("javacore"))) {
                    vector.add("2LKINFLATEDMON");
                    vector.add("    " + objectDetails.objectName + "@" + Long.toHexString(objectDetails.address) + "/" + Long.toHexString(objectDetails.address + 8L));
                    vector.add("3LKINFLDETAILS");
                    vector.add("        locknflags " + Long.toHexString(objectDetails.locknflags) + " Monitor inflated infl_mon 0x" + Long.toHexString(objectDetails.inflMon));
                }
                if (string.equals(new String("dis ls"))) {
                    vector.add("");
                    vector.addAll(this.displayMonitorPoolDump("dis lo", objectDetails));
                }
            }
            ++n2;
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.displayJavaObjMonDump(String)");
        return vector;
    }

    private Vector getThreads() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.getThreads");
        DvDump dvDump = DvConsole.getCurrentDump();
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        Vector vector = new Vector();
        Object var3_3 = null;
        try {
            DvProcess[] dvProcessArray = as.getProcesses();
            int n = 0;
            while (n < dvProcessArray.length) {
                DvThread[] dvThreadArray = dvProcessArray[n].getThreads();
                int n2 = 0;
                while (n2 < dvThreadArray.length) {
                    if (dvThreadArray[n2].isJava()) {
                        vector.add(dvThreadArray[n2]);
                    } else {
                        DvUtils.writetoTrace("Continue:1 DvObjectsCommands.getThreads non-Java thread");
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.getThreads unexpected exception");
        }
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.getThreads");
        return vector;
    }

    private static String threadName(DvThread dvThread, DvAddressSpace dvAddressSpace) throws DvAddressException {
        return DvUtils.getThreadName(dvThread, dvAddressSpace);
    }

    private static long getControlBlockFieldInt(String string, String string2, long l, DvAddressSpace dvAddressSpace) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.getControlBlockFieldInt");
        CTypeObject cTypeObject = new CTypeObject(string, dvAddressSpace.createAddress(l), dvAddressSpace);
        CTypeObject cTypeObject2 = cTypeObject.getField(string2);
        long l2 = 0L;
        try {
            l2 = dvAddressSpace.readInt(dvAddressSpace.createAddress(cTypeObject2.getAddr()));
        }
        catch (DvAddressException dvAddressException) {
            theOutput.add("DvAddressException in getControlBlockFieldInt");
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.getControlBlockFieldInt");
        }
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.getControlBlockFieldInt");
        return l2;
    }

    private static long getControlBlockField(String string, String string2, long l, DvAddressSpace dvAddressSpace) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.getControlBlockField");
        CTypeObject cTypeObject = new CTypeObject(string, dvAddressSpace.createAddress(l), dvAddressSpace);
        CTypeObject cTypeObject2 = null;
        if (null != cTypeObject) {
            cTypeObject2 = cTypeObject.getField(string2);
        }
        DvAddress dvAddress = null;
        long l2 = 0L;
        if (null != cTypeObject2) {
            try {
                dvAddress = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject2.getAddr()));
            }
            catch (DvAddressException dvAddressException) {
                theOutput.add("DvAddressException in getControlBlockField");
                DvUtils.writetoTrace("Exit:1 DvObjectsCommands.getControlBlockField");
            }
        }
        if (null != dvAddress) {
            l2 = dvAddress.getAddressAsLong();
        } else {
            DvUtils.trace("!!! DvObjectsComands:getControlBlockField(): \n  Problem finding field \"" + string2 + "\" in control block \"" + string + "\"\n at address: " + Long.toHexString(l), 0, true);
        }
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.getControlBlockField");
        return l2;
    }

    private static long getControlBlockField(String string, String string2, String string3, long l, DvAddressSpace dvAddressSpace) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.getControlBlockField");
        long l2 = 0L;
        CTypeObject cTypeObject = new CTypeObject(string, dvAddressSpace.createAddress(l), dvAddressSpace);
        CTypeObject cTypeObject2 = cTypeObject.getField(string2);
        CTypeObject cTypeObject3 = cTypeObject2.getField(string3);
        DvAddress dvAddress = null;
        try {
            dvAddress = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject3.getAddr()));
        }
        catch (DvAddressException dvAddressException) {
            theOutput.add("DvAddressException in getControlBlockField");
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.getControlBlockField");
        }
        if (null != dvAddress) {
            l2 = dvAddress.getAddressAsLong();
        } else {
            DvUtils.trace("!!! DvObjectsComands:getControlBlockField(): \n  Problem traversing fields \"" + string2 + ":" + string3 + "\" in control block \"" + string + "\"\n at address: " + Long.toHexString(l), 0, true);
        }
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.getControlBlockField");
        return l2;
    }

    public boolean displayObject(long l) throws DvAddressException {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayObject(long)");
        DvDump dvDump = DvConsole.theDump;
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (!DvUtils.checkAddressInDump(as.createAddress(l), as)) {
            DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayObject(long) throw(Unable to comply as not a valid address)");
            throw new DvAddressException("Unable to comply as not a valid address");
        }
        if (DvObjectsCommands.checkForKnownObject(l - (long)ptrLength)) {
            ObjectDetails objectDetails = DvObjectsCommands.getObjectDetails(l - (long)ptrLength);
            this.showObjects(objectDetails);
        } else {
            theOutput.add("@ 0x" + Long.toHexString(l) + " not the start of an object in the heap");
        }
        DvUtils.writetoTrace("Exit:3 DvObjectsCommands.displayObject(long)");
        return false;
    }

    public boolean displayObject(String string) throws DvAddressException {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayObject(String)");
        DvDump dvDump = DvConsole.theDump;
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        long[] lArray = namesIndexFile.getInstancesForClass(string);
        if (null != lArray) {
            int n = 0;
            if (n < lArray.length) {
                ObjectDetails objectDetails = DvObjectsCommands.getObjectDetails(lArray[n]);
                this.showObjects(objectDetails);
                DvUtils.writetoTrace("Exit:1 DvObjectsCommands.displayObject(String)");
                return true;
            }
        }
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayObject(String)");
        return false;
    }

    public void displayLockedObjects() {
        String string;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayLockedObjects()");
        boolean bl = false;
        Vector vector = new Vector();
        DvDump dvDump = DvConsole.theDump;
        DvObjectsCommands.initPtrLength();
        is64bit = DvUtils.is64BitSystem(dvDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(dvDump.getArchitecture());
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (null == this.paramString) {
            this.paramString = "*";
        }
        if (null != this.paramString) {
            try {
                if (this.paramString.charAt(0) == '0' && (this.paramString.charAt(1) == 'x' || this.paramString.charAt(1) == 'X')) {
                    long l = Long.parseLong(this.paramString.substring(2), 16);
                    if (!DvUtils.checkAddressInDump(as.createAddress(l), as)) {
                        theOutput.add("Not a valid address");
                        this.returnControl();
                        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayLockedObjects()");
                        return;
                    }
                    if (DvObjectsCommands.checkForKnownObject(l - (long)ptrLength)) {
                        ObjectDetails objectDetails = DvObjectsCommands.getObjectDetails(l - (long)ptrLength);
                        if (objectDetails.lock) {
                            this.showLocks(objectDetails);
                        } else {
                            theOutput.add("Object is not locked");
                        }
                    } else {
                        theOutput.add("@ 0x" + Long.toHexString(l) + " not the start of an object in the heap");
                    }
                    this.returnControl();
                    DvUtils.writetoTrace("Exit:3 DvObjectsCommands.displayLockedObjects()");
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                theOutput.add("The address is not valid hex");
                this.returnControl();
                DvUtils.writetoTrace("Exit:4 DvObjectsCommands.displayLockedObjects() the address is not valid hex");
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                theOutput.add("The address is not valid     StringIndexOutOfBoundsException:");
                this.returnControl();
                DvUtils.writetoTrace("Exit:5 DvObjectsCommands.displayLockedObjects() StringIndexOutOfBoundsException: The address is not valid");
                return;
            }
            if (Character.isDigit(this.paramString.charAt(0))) {
                theOutput.add("Object names must start with letter");
                this.returnControl();
                DvUtils.writetoTrace("Exit:6 DvObjectsCommands.displayLockedObjects() Object names must start with letter");
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.paramString, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                if (string.startsWith("*") || string.endsWith("*") || string.startsWith("!")) {
                    bl = true;
                }
                vector.add(string);
            }
        }
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (vector.size() > 0 && !bl) {
            int n = 0;
            while (n < vector.size()) {
                string = (String)vector.get(n);
                int n2 = 0;
                while (n2 < lockedObjects.size()) {
                    long l = (Long)lockedObjects.get(n2);
                    ObjectDetails objectDetails = DvObjectsCommands.getObjectDetails(l);
                    if (string.equals(objectDetails.objectName)) {
                        this.showLocks(objectDetails);
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < lockedObjects.size()) {
                long l = (Long)lockedObjects.get(n);
                ObjectDetails objectDetails = DvObjectsCommands.getObjectDetails(l);
                boolean bl2 = false;
                if (0 != vector.size()) {
                    bl2 = DvUtils.filtrate(objectDetails.objectName, vector);
                }
                if (bl2) {
                    this.showLocks(objectDetails);
                }
                ++n;
            }
        }
        this.returnControl();
        DvUtils.writetoTrace("Exit:7 DvObjectsCommands.displayLockedObjects()");
    }

    public void displayThreads() {
        Object object;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayThreads");
        boolean bl = false;
        Vector vector = new Vector();
        DvDump dvDump = DvConsole.theDump;
        DvObjectsCommands.initPtrLength();
        is64bit = DvUtils.is64BitSystem(dvDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(dvDump.getArchitecture());
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (null == this.paramString) {
            if (0 == threadList.size()) {
                DvObjectsCommands.processThreads();
            }
            int n = 0;
            while (n < threadList.size()) {
                ThreadDetails threadDetails = (ThreadDetails)threadList.elementAt(n);
                this.showThread(threadDetails);
                ++n;
            }
            theOutput.add("Finished..");
            this.returnControl();
            DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayThreads");
            return;
        }
        if (null != this.paramString) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.paramString, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                if (((String)object).startsWith("*") || ((String)object).endsWith("*") || ((String)object).startsWith("!")) {
                    bl = true;
                }
                vector.add(object);
            }
        }
        if (0 == threadList.size()) {
            DvObjectsCommands.processThreads();
        }
        if (vector.size() > 0) {
            int n = 0;
            while (n < threadList.size()) {
                object = (ThreadDetails)threadList.elementAt(n);
                String string = ((ThreadDetails)object).getThreadName();
                String string2 = ((ThreadDetails)object).getThreadID();
                boolean bl2 = true;
                if (0 != vector.size()) {
                    boolean bl3 = bl2 = DvUtils.filtrate(string, vector) || DvUtils.filtrate(string2, vector);
                }
                if (bl2) {
                    this.showThread((ThreadDetails)object);
                }
                ++n;
            }
        }
        this.returnControl();
        DvUtils.writetoTrace("Exit:8 DvObjectsCommands.displayThreads");
    }

    public void displayLockedReg() {
        Object object;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayReg");
        boolean bl = false;
        Vector vector = new Vector();
        if (null == DvConsole.theDump) {
            theOutput.add("Unable to comply as no Dump opened yet\n");
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.displayReg");
            return;
        }
        DvObjectsCommands.initPtrLength();
        is64bit = DvUtils.is64BitSystem(DvConsole.theDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(DvConsole.theDump.getArchitecture());
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        if (null == this.paramString) {
            if (!monitorsProcessed) {
                DvObjectsCommands.processMonitors();
            }
            int n = 0;
            while (n < regMonList.size()) {
                MonDetails monDetails = (MonDetails)regMonList.elementAt(n);
                theOutput.add(this.showReg(monDetails));
                theOutput.add("");
                ++n;
            }
            theOutput.add("Finished..");
            this.returnControl();
            DvUtils.writetoTrace("Exit:2 DvObjectsCommands.displayReg");
            return;
        }
        if (null != this.paramString) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.paramString, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                if (((String)object).startsWith("*") || ((String)object).endsWith("*") || ((String)object).startsWith("!")) {
                    bl = true;
                }
                vector.add(object);
            }
        }
        if (!monitorsProcessed) {
            DvObjectsCommands.processMonitors();
        }
        if (vector.size() > 0) {
            int n = 0;
            while (n < regMonList.size()) {
                object = (MonDetails)regMonList.elementAt(n);
                String string = ((MonDetails)object).getName();
                String string2 = "0x" + Long.toHexString(((MonDetails)object).getAddress());
                boolean bl2 = true;
                if (0 != vector.size()) {
                    boolean bl3 = bl2 = DvUtils.filtrate(string, vector) || DvUtils.filtrate(string2, vector);
                }
                if (bl2) {
                    theOutput.add(this.showReg((MonDetails)object));
                    theOutput.add("");
                }
                ++n;
            }
        }
        theOutput.add("Finished..");
        this.returnControl();
        DvUtils.writetoTrace("Exit:8 DvObjectsCommands.displayReg");
    }

    public void findDeadlockVerbose() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.findDeadlockVerbose");
        this.findDeadlock(true);
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.findDeadlockVerbose");
    }

    public void findDeadlock() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.findDeadlock");
        this.findDeadlock(false);
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.findDeadlock");
    }

    public void findDeadlock(boolean bl) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.findDeadlock");
        if (null == DvConsole.theDump) {
            theOutput.add("Unable to comply as no Dump opened yet\n");
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.findDeadlock");
            return;
        }
        DvObjectsCommands.initPtrLength();
        if (!monitorsProcessed) {
            DvObjectsCommands.processMonitors();
        }
        if (deadlocks.size() != 0) {
            theOutput.add("\n\nDeadlock(s) detected !!!\n");
            this.displayDeadlockChain(bl);
        } else {
            theOutput.add("\nNo deadlocks detected\n");
        }
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.findDeadlock");
    }

    private void displayDeadlockChain(boolean bl) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayDeadlockChain");
        int n = 0;
        while (n < deadlocks.size()) {
            ThreadDetails threadDetails;
            String string = "  ";
            String string2 = "  ";
            boolean bl2 = true;
            theOutput.add("\n==============================\n");
            ThreadDetails threadDetails2 = threadDetails = (ThreadDetails)deadlocks.elementAt(n);
            do {
                long l;
                theOutput.add(string + "Thread 0x" + threadDetails2.getThreadID() + " \"" + threadDetails2.getThreadName() + "\"");
                long l2 = threadDetails2.getWaitMon();
                if (l2 != 0L) {
                    theOutput.add(string + string2 + "is waiting to be notified for: ");
                } else {
                    l2 = threadDetails2.getEnterMon();
                    theOutput.add(string + string2 + "is waiting to enter: ");
                }
                MonDetails monDetails = (MonDetails)monitorsByAddr.get(Long.toHexString(l2));
                if (monDetails == null) {
                    monDetails = (MonDetails)monitorsBySysmon.get(Long.toHexString(l2));
                }
                if ((l = monDetails.getObjectAddress()) == 0L) {
                    l = monDetails.getAddress();
                }
                theOutput.add(string + "    (0x" + Long.toHexString(l) + ") \"" + monDetails.getObjectName() + "\"");
                theOutput.add(string + "     which is owned by:\n");
                string = string + "  ";
                threadDetails2 = threadDetails2.getBlockingThread();
                if (!bl2) continue;
                bl2 = false;
                string2 = string2 + "which ";
            } while (threadDetails2 != threadDetails);
            theOutput.add(string + "Thread 0x" + threadDetails2.getThreadID() + " \"" + threadDetails2.getThreadName() + "\"");
            ++n;
        }
        theOutput.add("\n==============================\n");
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.displayDeadlockChain");
    }

    public static Vector lkDumpRoutine() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.lkDumpRoutine()");
        Vector vector = new Vector();
        DvObjectsCommands dvObjectsCommands = DvObjectsCommands.getCurrentInstance();
        vector.addAll(dvObjectsCommands.displayMonitorPoolInfo("javacore"));
        if (1 == DvObjectsCommands.checkLKGLOBALPTR()) {
            vector.addAll(dvObjectsCommands.displayMonitorPoolDump("javacore", null));
        } else {
            DvUtils.writetoTrace("Continue:1 DvObjectsCommands.lkDumpRoutine() No locking global pointer displayMonitorPoolDump(\"dis ls\",null)");
        }
        if (1 == DvObjectsCommands.checkLKGLOBALPTR()) {
            vector.addAll(dvObjectsCommands.displaySysMonitorDump("javacore"));
        } else {
            DvUtils.writetoTrace("Continue:2 DvObjectsCommands.lkDumpRoutine() No locking global pointer displaySysMonitorDump(\"dis ls\")");
        }
        vector.addAll(dvObjectsCommands.displayThreadIdent("javacore"));
        vector.addAll(dvObjectsCommands.displayJavaObjMonDump("javacore"));
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.lkDumpRoutine()");
        return vector;
    }

    private void showObjects(ObjectDetails objectDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.showObjects(ObjectDetails)");
        theOutput.add(oSeperator);
        theOutput.add(objectDetails);
        if (null != objectDetails) {
            theOutput.add(DvClassCommands.getInstanceValues(objectDetails.address, objectDetails.objectName, DvConsole.theDump, theOutput));
        } else {
            theOutput.add(" ---- Null or invalid object ---- ");
        }
        this.cpr.output(theOutput);
        theOutput.clear();
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.showObjects(ObjectDetails)");
    }

    private void showLocks(ObjectDetails objectDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.showLocks(ObjectDetails)");
        String string = "";
        if (null != objectDetails.className) {
            string = objectDetails.className;
        }
        if (objectDetails.lock) {
            if (0L == objectDetails.shapeBit) {
                ThreadDetails threadDetails;
                if (0 == threadList.size()) {
                    DvObjectsCommands.processThreads();
                }
                if ((threadDetails = (ThreadDetails)threadsById.get(Long.toHexString(objectDetails.threadId))) != null) {
                    theOutput.add("");
                    theOutput.add("    (0x" + Long.toHexString(objectDetails.address) + ") " + objectDetails.objectName + " ");
                    theOutput.add("        flat locked by " + this.r("0x" + threadDetails.getThreadID(), 10) + " \"" + threadDetails.getThreadName() + "\", entry count " + objectDetails.entryCount + " " + string);
                }
                if (!monitorsProcessed) {
                    DvObjectsCommands.processMonitors();
                }
                int n = 0;
                while (n < inflMonList.size()) {
                    MonDetails monDetails = (MonDetails)inflMonList.elementAt(n);
                    long l = monDetails.getObjectAddress();
                    if (l == objectDetails.address && 0L < monDetails.getWaiterSize()) {
                        theOutput.add("            Waiting to be notified:");
                        int n2 = 0;
                        while ((long)n2 < monDetails.getWaiterSize()) {
                            theOutput.add("               " + this.r("0x" + monDetails.getWaiterThreadID(n2), 10) + " \"" + monDetails.getWaiterName(n2) + "\" ");
                            ++n2;
                        }
                    }
                    ++n;
                }
            } else {
                theOutput.add("");
                theOutput.addAll(this.displayMonitorPoolDump("dis lo", objectDetails));
            }
        } else {
            theOutput.add("@ 0x" + Long.toHexString(objectDetails.address) + " (" + objectDetails.objectName + ") " + string + "          type:" + objectDetails.type);
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.showLocks(ObjectDetails)");
    }

    private Vector showReg(MonDetails monDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.showReg(MonDetails)");
        Vector vector = new Vector();
        vector.add("(0x" + Long.toHexString(monDetails.getAddress()) + ") " + monDetails.getName());
        if (0L != monDetails.getOwnerAddress()) {
            vector.add("    owned by thread " + this.r("0x" + monDetails.getOwnerThreadID(), 10) + " \"" + monDetails.getOwnerName() + "\"");
        }
        this.waitAndEnterQ("dis ls", monDetails, vector);
        vector.add("");
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.showReg(MonDetails)");
        return vector;
    }

    private void showThread(ThreadDetails threadDetails) {
        int n;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.showThread(ThreadDetails)");
        theOutput.add(this.r("0x" + threadDetails.getThreadID(), 10) + " \"" + threadDetails.getThreadName() + "\"");
        if (!monitorsProcessed) {
            DvObjectsCommands.processMonitors();
        }
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        boolean bl = false;
        long l = threadDetails.getSysThr();
        int n2 = 0;
        while (n2 < inflMonList.size()) {
            MonDetails monDetails = (MonDetails)inflMonList.elementAt(n2);
            if (0L < monDetails.getWaiterSize()) {
                n = 0;
                while ((long)n < monDetails.getWaiterSize()) {
                    if (monDetails.getWaiterAddress(n) == l) {
                        theOutput.add("    waiting on: (0x" + Long.toHexString(monDetails.getObjectAddress()) + ") " + monDetails.getObjectName());
                        bl = true;
                    }
                    ++n;
                }
            }
            ++n2;
        }
        boolean bl2 = false;
        n = 0;
        while (n < inflMonList.size()) {
            MonDetails monDetails = (MonDetails)inflMonList.elementAt(n);
            if (monDetails.getOwnerAddress() == l) {
                long l2 = 4 == DvConsole.theDump.getSystemType() ? DvObjectsCommands.getControlBlockFieldInt("sys_mon", "monitor_usecount", monDetails.getSysMon(), as) : DvObjectsCommands.getControlBlockFieldInt("sys_mon", "entry_count", monDetails.getSysMon(), as);
                if (!bl2) {
                    theOutput.add("        Owns Objects:");
                    bl2 = true;
                }
                theOutput.add("                infl lock on (0x" + Long.toHexString(monDetails.getObjectAddress()) + ") " + monDetails.getObjectName() + " " + ", entry count " + l2);
                bl = true;
            }
            ++n;
        }
        long l3 = threadDetails.getThreadIdent();
        boolean bl3 = false;
        if (null == lockedObjectsByAddr) {
            bl3 = true;
            lockedObjectsByAddr = new Hashtable();
        }
        int n3 = 0;
        while (n3 < lockedObjects.size()) {
            Long l4 = (Long)lockedObjects.get(n3);
            long l5 = l4;
            ObjectDetails objectDetails = null;
            if (bl3) {
                objectDetails = DvObjectsCommands.getObjectDetails(l5);
                lockedObjectsByAddr.put(l4, objectDetails);
            } else {
                objectDetails = (ObjectDetails)lockedObjectsByAddr.get(l4);
            }
            if (objectDetails.lock && 0L == objectDetails.shapeBit && objectDetails.threadId == l3) {
                if (!bl2) {
                    theOutput.add("        Owns Objects:");
                    bl2 = true;
                }
                theOutput.add("          flat lock on (0x" + Long.toHexString(objectDetails.address) + ") " + objectDetails.objectName + " " + ", entry count " + objectDetails.entryCount + " ");
                bl = true;
            }
            ++n3;
        }
        bl2 = false;
        int n4 = 0;
        while (n4 < regMonList.size()) {
            MonDetails monDetails = (MonDetails)regMonList.elementAt(n4);
            if (monDetails.getOwnerAddress() == l) {
                long l6 = 4 == DvConsole.theDump.getSystemType() ? DvObjectsCommands.getControlBlockFieldInt("sys_mon", "monitor_usecount", monDetails.getSysMon(), as) : DvObjectsCommands.getControlBlockFieldInt("sys_mon", "entry_count", monDetails.getSysMon(), as);
                if (bl) {
                    theOutput.add("");
                    bl = false;
                }
                if (!bl2) {
                    theOutput.add("        Owns Registered Monitors:");
                    bl2 = true;
                }
                theOutput.add("                lock on (0x" + Long.toHexString(monDetails.getAddress()) + ") " + monDetails.getName() + " " + ", entry count " + l6);
            }
            ++n4;
        }
        theOutput.add("");
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.showThread(ThreadDetails)");
    }

    public static void traverseAllHeaps(JTextArea jTextArea) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.traverseAllHeaps()");
        if (null == namesIndexFile) {
            DvObjectsCommands.openNamesIndexFile();
        }
        totalObjectCount = 0;
        totalLockedObjectCount = 0;
        totalSwappedObjectCount = 0;
        totalSwappedObjectLength = 0L;
        DvConsole.bHeapTraversalInprogress = true;
        DvObjectsCommands.traverseEveryTLH(jTextArea);
        DvObjectsCommands.traverseMiddlewareHeap(jTextArea);
        DvObjectsCommands.traverseTransientHeap(jTextArea);
        DvObjectsCommands.traverseSystemHeaps(jTextArea);
        DvObjectsCommands.traverseACSHeap(jTextArea);
        heapsTraversed = true;
        namesIndexFile.updateMagic();
        names_index_built = true;
        address_index_built = true;
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.traverseAllHeaps()");
    }

    private static void traverseMiddlewareHeap(JTextArea jTextArea) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.traverseMiddlewareHeap()");
        int n = 0;
        String string = "\nTraversing the Middleware heap\n";
        if (null == jTextArea) {
            theOutput.add(string);
            DvObjectsCommands.that.cpr.output(theOutput);
            theOutput.clear();
        } else {
            jTextArea.append(string);
        }
        startOfMHeap = Long.parseLong(DvUtils.getJVMHint(as, "CURHEAPMIN"), 16);
        endOfMHeap = Long.parseLong(DvUtils.getJVMHint(as, "CURHEAPMAX"), 16);
        middlewareH = n = DvObjectsCommands.traverseHeap(startOfMHeap, endOfMHeap, Long.parseLong(DvUtils.getJVMHint(as, "MH_HEAPBASE"), 16), "Mid", (short)-1, jTextArea);
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.traverseMiddlewareHeap()");
    }

    private static void traverseTransientHeap(JTextArea jTextArea) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.traverseTransientHeap()");
        int n = 0;
        String string = "\nTraversing the transient heap \n";
        if (null == jTextArea) {
            theOutput.add(string);
            DvObjectsCommands.that.cpr.output(theOutput);
            theOutput.clear();
        } else {
            jTextArea.append(string);
        }
        startOfTransHeap = DvUtils.hexToLong(DvUtils.getJVMHint(as, "TH_HEAPBASE"));
        endOfTransHeap = DvUtils.hexToLong(DvUtils.getJVMHint(as, "TH_HEAPLIMIT"));
        transientH = n = DvObjectsCommands.traverseHeap(startOfTransHeap, endOfTransHeap, DvUtils.hexToLong(DvUtils.getJVMHint(as, "MH_HEAPBASE")), "Tra", (short)-3, jTextArea);
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.traverseTransientHeap()");
    }

    private static void traverseSystemHeaps(JTextArea jTextArea) {
        Object object;
        long l;
        long l2;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.traverseSystemHeaps()");
        int n = 0;
        int n2 = 0;
        String string = "Traversing the system heaps \n";
        if (null == jTextArea) {
            theOutput.add(string);
            DvObjectsCommands.that.cpr.output(theOutput);
            theOutput.clear();
        } else {
            jTextArea.append(string);
        }
        Vector vector = new Vector();
        int n3 = 0;
        if (null != rangeArray) {
            n3 = rangeArray.length;
            int n4 = 0;
            while (n4 < rangeArray.length) {
                vector.add(new Range(rangeArray[n4][0], rangeArray[n4][1], rangeArray[n4][2]));
                ++n4;
            }
        }
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        DvAddress dvAddress = dvAddressSpace.createAddress(DvUtils.hexToLong(DvUtils.getJVMHint(dvAddressSpace, "STGLOBALPTR")));
        DvAddress dvAddress2 = dvAddressSpace.createAddress(0L);
        long l3 = DvUtils.hexToLong(DvUtils.getJVMHint(dvAddressSpace, "MH_HEAPBASE"));
        long l4 = DvObjectsCommands.getControlBlockField("STGlobal", "st_jab", dvAddress.getAddressAsLong(), dvAddressSpace);
        dvAddress2 = dvAddressSpace.createAddress(DvObjectsCommands.getControlBlockField("StorageJab", "system_heap_this_extent", l4, dvAddressSpace));
        if (0L != dvAddress2.getAddressAsLong() && DvUtils.checkAddressInDump(dvAddress2, dvAddressSpace)) {
            l2 = DvObjectsCommands.getControlBlockField("heap_extent_info", "base", dvAddress2.getAddressAsLong(), dvAddressSpace);
            l = DvObjectsCommands.getControlBlockField("StorageJab", "system_heap_next", l4, dvAddressSpace);
            object = new Range(l2, l, -1L);
            vector.add(object);
            n += DvObjectsCommands.traverseHeap(l2, l, l3, "Sys " + n2, (short)(-4 - n2), jTextArea);
            ++n2;
        }
        dvAddress2 = dvAddressSpace.createAddress(DvObjectsCommands.getControlBlockField("heap_extent_info", "prev", dvAddress2.getAddressAsLong(), dvAddressSpace));
        while (0L != dvAddress2.getAddressAsLong() && DvUtils.checkAddressInDump(dvAddress2, dvAddressSpace)) {
            l2 = DvObjectsCommands.getControlBlockField("heap_extent_info", "base", dvAddress2.getAddressAsLong(), dvAddressSpace);
            l = DvObjectsCommands.getControlBlockField("heap_extent_info", "limit", dvAddress2.getAddressAsLong(), dvAddressSpace);
            object = new Range(l2, l, -1L);
            vector.add(object);
            n += DvObjectsCommands.traverseHeap(l2, l, l3, "Sys " + n2, (short)(-4 - n2), jTextArea);
            ++n2;
            dvAddress2 = dvAddressSpace.createAddress(DvObjectsCommands.getControlBlockField("heap_extent_info", "prev", dvAddress2.getAddressAsLong(), dvAddressSpace));
        }
        object = DvObjectsCommands.sortRanges(vector);
        if (null != object) {
            int n5 = vector.size();
            rangeArray = new long[n5][3];
            int n6 = 0;
            while (n6 < n5) {
                Range range = (Range)vector.get(object[n6]);
                DvObjectsCommands.rangeArray[n6][0] = range.start;
                DvObjectsCommands.rangeArray[n6][1] = range.end;
                DvObjectsCommands.rangeArray[n6][2] = range.index;
                ++n6;
            }
        }
        systemH = n;
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.traverseSystemHeaps()");
    }

    private static void traverseACSHeap(JTextArea jTextArea) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.traverseACSHeap()");
        DvDump dvDump = DvConsole.theDump;
        int n = 0;
        long l = 0L;
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        int n2 = dvAddressSpace.pointerSize();
        int n3 = dvDump.getArchitecture();
        boolean bl = DvUtils.is64BitSystem(n3);
        long l2 = 0L;
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        long l3 = DvUtils.jvmFromThreadId(dvThread.id());
        String string = DvUtils.getJVMHint(l3, "LOADEDACSCLASSES");
        if (null != string) {
            long l4 = DvUtils.hexToLong(string);
            try {
                DvUtils.writetoTrace("  current_start = " + Long.toHexString(l4));
                long l5 = 0L;
                if (0L != l4) {
                    l5 = DvUtils.getFieldAddress(l4, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
                }
                long l6 = l5 - l4;
                while (0L != l5) {
                    long l7 = l4 - (long)n2;
                    l2 = l5;
                    long l8 = DvUtils.getFieldAddress(l2, new String[]{"Classjava_lang_Class", "shared_class_id"}, dvAddressSpace);
                    int n4 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l8));
                    if (n4 != 0) {
                        return;
                    }
                    boolean bl2 = false;
                    try {
                        if (is64bit) {
                            l = dvAddressSpace.readLong(dvAddressSpace.createAddress(l7));
                            if (1L == (l & 1L)) {
                                bl2 = true;
                            }
                            l &= 0x3FFFFFFFFFFFFFF8L;
                        } else {
                            l = dvAddressSpace.readInt(dvAddressSpace.createAddress(l7));
                            if (1L == (l & 1L)) {
                                bl2 = true;
                            }
                            l &= 0x3FFFFFF8L;
                        }
                    }
                    catch (DvAddressException dvAddressException) {
                        String string2 = "DvAddressException during traverseACSHeap (objLength calculation)\nACS Heap Traversal terminated.";
                        DvUtils.trace(string2, 0, true);
                        return;
                    }
                    DvObjectsCommands.processFoundObject(l7, false, (short)-2, l, bl2);
                    if (bl2) {
                        ++totalSwappedObjectCount;
                        totalSwappedObjectLength += l;
                    }
                    ++n;
                    long l9 = DvUtils.getFieldAddress(l2, new String[]{"MirroredClassData", "memory_table"}, dvAddressSpace);
                    l4 = l5 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l9);
                    if (0L == l5) continue;
                    l5 = DvUtils.getFieldAddress(l5, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
                }
            }
            catch (DvAddressException dvAddressException) {
                String string3 = "DvAddressException during traverseACSHeap\ncurrent_start: 0x" + Long.toHexString(l4) + "\nACS Heap Traversal terminated";
                DvUtils.trace(string3, 0, true);
                return;
            }
        }
        String string4 = "Unable to find hint for LOADEDACSCLASSES\nPossible error in control block analysis\nACS Heap Traversal terminated";
        DvUtils.trace(string4, 0, true);
        return;
        acsH = n;
        DvUtils.writetoTrace("Exit: DvObjectsCommands.traverseACSHeap() :" + n);
    }

    private static int traverseHeap(long l, long l2, long l3, String string, short s, JTextArea jTextArea) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.traverseHeap() - " + string);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = DvConsole.theDump.getArchitecture();
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        if (!DvUtils.checkAddressInDump(dvAddressSpace.createAddress(l), dvAddressSpace) || l == l2) {
            String string2 = "Event traverseHeap min value not in dump";
            if (null == jTextArea) {
                theOutput.add(string2);
            } else {
                jTextArea.append(string2);
            }
            DvUtils.writetoTrace("Exit:2 DvObjectsCommands.traverseHeap() error with min=" + Long.toHexString(l) + " max=" + Long.toHexString(l2) + " value");
            return n;
        }
        if (!DvUtils.checkAddressInDump(dvAddressSpace.createAddress(l2), dvAddressSpace)) {
            DvUtils.writetoTrace("Continue:1 DvObjectsCommands.traverseHeap() max=" + Long.toHexString(l2) + " value not in heap");
        }
        long l4 = l;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        if (0 == string.compareToIgnoreCase("MIDDLEWARE") || 0 == string.compareToIgnoreCase("TRANSIENT") || 0 == string.compareToIgnoreCase("MID") || 0 == string.compareToIgnoreCase("TRA")) {
            bl = true;
        }
        l4 = l;
        while (l4 < l2) {
            long l10 = l4;
            boolean bl2 = false;
            try {
                if (is64bit) {
                    l6 = dvAddressSpace.readLong(dvAddressSpace.createAddress(l10));
                    if (1L == (l6 & 1L)) {
                        bl2 = true;
                    }
                    l6 &= 0x3FFFFFFFFFFFFFF8L;
                } else {
                    l6 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l10));
                    if (1L == (l6 & 1L)) {
                        bl2 = true;
                    }
                    l6 &= 0x3FFFFFF8L;
                }
            }
            catch (DvAddressException dvAddressException) {
                String string3 = "DvAddressException in traverseHeap";
                if (null == jTextArea) {
                    theOutput.add(string3);
                } else {
                    jTextArea.append(string3);
                }
                DvUtils.writetoTrace("Exit:3 DvObjectsCommands.traverseHeap() DvAddressException");
                return n;
            }
            if (l6 > 0L) {
                if (!bl || DvObjectsCommands.checkAllocbit(l4 - l3, dvAddressSpace)) {
                    boolean bl3 = DvObjectsCommands.processFoundObject(l4, bl, s, l6, bl2);
                    ++n;
                    if (bl2) {
                        ++totalSwappedObjectCount;
                        totalSwappedObjectLength += l6;
                    }
                    if (!bl3) {
                        l4 = l2;
                    }
                }
                if (n >= n2 + 5000) {
                    long l11 = (l4 - l) * 100L / (l2 - l);
                    String string4 = "\n  " + DvUtils.getTime() + " " + n + " objects processed...(" + l11 + "% of range scanned so far)";
                    if (null == jTextArea) {
                        DvObjectsCommands.that.cpr.output(string4);
                    } else {
                        jTextArea.append(string4);
                    }
                    n2 = n;
                }
            } else {
                DvUtils.trace("Exit:4 DvObjectsCommands.traverseHeap() Reached a point in the heap (" + Long.toHexString(l4) + ")\n" + " where the object length is 0 or less (" + Long.toHexString(l6) + ")\n" + "This suggests a corrupted heap and should be investigated!!!\n", 0, true);
                l4 = l2;
            }
            l4 += l6;
        }
        DvObjectsCommands.that.cpr.output(theOutput);
        theOutput.clear();
        String string5 = "\t\n" + string + " traversal finished - " + n + " objects\n";
        if (null == jTextArea) {
            DvObjectsCommands.that.cpr.output(string5);
        } else {
            jTextArea.append(string5);
        }
        DvUtils.writetoTrace("Exit:4 DvObjectsCommands.traverseHeap()");
        return n;
    }

    private static void traverseEveryTLH(JTextArea jTextArea) {
        Object object;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.traverseEveryTLH()");
        int n = 0;
        javaThreadsWithoutTLH = 0;
        javaThreadsWithTLH = 0;
        javaThreadsWithoutTHTLH = 0;
        javaThreadsWithTHTLH = 0;
        if (DvConsole.theDump == null) {
            theOutput.add("Unable to comply as no Dump opened yet\n");
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.traverseEveryTLH()");
            return;
        }
        DvDump dvDump = DvConsole.getCurrentDump();
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        String string = "\nTraversing Thread Local Heaps \n";
        if (null == jTextArea) {
            theOutput.add(string);
            DvObjectsCommands.that.cpr.output(theOutput);
            theOutput.clear();
        } else {
            jTextArea.append(string);
        }
        Vector vector = new Vector();
        try {
            DvProcess[] dvProcessArray = as.getProcesses();
            int n2 = 0;
            while (n2 < dvProcessArray.length) {
                object = dvProcessArray[n2].getThreads();
                int n3 = 0;
                while (n3 < ((DvThread[])object).length) {
                    if (object[n3].isJava()) {
                        if (DvUtils.threadWithinCurrentJVM(object[n3])) {
                            n += DvObjectsCommands.traverseOneTLH(object[n3], n3, vector, jTextArea);
                        }
                    } else if (verboseTLH) {
                        String string2 = "        " + object[n3] + " non-Java thread";
                        if (null == jTextArea) {
                            theOutput.add(string2);
                        } else {
                            jTextArea.append(string2);
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            String string3 = "*** Exception received while traversing TLH - " + exception.getMessage();
            if (null == jTextArea) {
                theOutput.add(string3);
                DvObjectsCommands.that.cpr.output(theOutput);
                theOutput.clear();
            } else {
                jTextArea.append(string3);
            }
            exception.printStackTrace();
        }
        int n4 = vector.size();
        if (n4 != 0) {
            rangeArray = new long[n4][3];
            int n5 = 0;
            while (n5 < n4) {
                object = (Range)vector.get(n5);
                DvObjectsCommands.rangeArray[n5][0] = object.start;
                DvObjectsCommands.rangeArray[n5][1] = object.end;
                DvObjectsCommands.rangeArray[n5][2] = object.index;
                ++n5;
            }
        }
        String string4 = "\n        " + javaThreadsWithoutTLH + " of " + (javaThreadsWithTLH + javaThreadsWithoutTLH) + " java threads did not have TLH cache blocks\n" + "        " + javaThreadsWithoutTHTLH + " of " + (javaThreadsWithTHTLH + javaThreadsWithoutTHTLH) + " java threads did not have TH-TLH cache blocks\n" + "TLH finished - " + n + " objects\n";
        if (null == jTextArea) {
            theOutput.add(string4);
            DvObjectsCommands.that.cpr.output(theOutput);
            theOutput.clear();
        } else {
            jTextArea.append(string4);
        }
        threadLocalH = n;
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.traverseEveryTLH()");
    }

    private static int traverseOneTLH(DvThread dvThread, int n, Vector vector, JTextArea jTextArea) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.traverseOneTLH()");
        int n2 = 0;
        DvAddress dvAddress = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n3 = 0;
        int n4 = 1;
        long l4 = DvUtils.is64BitSystem(DvConsole.theDump.getArchitecture()) ? 0x3FFFFFFFFFFFFFF8L : 0x3FFFFFF8L;
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        CTypeObject cTypeObject = new CTypeObject("execenv", dvThread.eeAddress(), as);
        if (cTypeObject == null || as == null || dvThread == null) {
            String string = "        *** Warning: Unable to process TLH for thread - unexpected NULL variable";
            if (null == jTextArea) {
                theOutput.add(string);
                DvObjectsCommands.that.cpr.output(theOutput);
                theOutput.clear();
            } else {
                jTextArea.append(string);
            }
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.traverseOneTLH(DvThread, int, Vector)");
            return 0;
        }
        if (dvThread.eeAddress().getAddressAsLong() == 0L) {
            DvUtils.writetoTrace("Exit:2 DvObjectsCommands.traverseOneTLH(DvThread, int, Vector) Warning: ee address is ZERO - thread ignored.");
            return 0;
        }
        int n5 = n3;
        while (n5 <= n4) {
            block45: {
                Object object;
                CTypeObject cTypeObject2 = null;
                String string = "";
                if (n5 == n3) {
                    cTypeObject2 = cTypeObject.getField("alloc_cache.c.tc");
                    string = "MH-";
                } else {
                    cTypeObject2 = cTypeObject.getField("TH_alloc_cache.c.tc");
                    string = "TH-";
                }
                if (cTypeObject2 == null) {
                    object = "*** Error: Unable to get tc in DvObjectsCommands.traverseOneTLH()";
                    if (null == jTextArea) {
                        theOutput.add(object);
                        DvObjectsCommands.that.cpr.output(theOutput);
                        theOutput.clear();
                    } else {
                        jTextArea.append((String)object);
                    }
                } else {
                    Object object2;
                    object = cTypeObject2.getField("cache_block");
                    CTypeObject cTypeObject3 = cTypeObject2.getField("cache_size");
                    CTypeObject cTypeObject4 = cTypeObject2.getField("cache_orig_size");
                    CTypeObject cTypeObject5 = cTypeObject2.getField("cache_busy");
                    if (object == null || cTypeObject3 == null || cTypeObject4 == null || cTypeObject5 == null) {
                        object2 = "*** Error: Unexpected NULL variable in DvObjectsCommands.traverseOneTLH()";
                        if (null == jTextArea) {
                            theOutput.add(object2);
                            DvObjectsCommands.that.cpr.output(theOutput);
                            theOutput.clear();
                        } else {
                            jTextArea.append((String)object2);
                        }
                    } else {
                        try {
                            dvAddress = as.readPointer(as.createAddress(((CTypeObject)object).getAddr()));
                            if (null == dvAddress) {
                                l = 0L;
                                DvUtils.trace("*** Unexpected event while getting cache block for " + string + "TLH\n thread id is " + dvThread.id() + "(" + DvUtils.getThreadName(dvThread, as) + ")" + "\nThe Address pointed to by the cache_block was 0." + "\nMight be worthy of further investigation", 0, true);
                            } else {
                                l = dvAddress.getAddressAsLong();
                            }
                            if (l == 0L) {
                                if (n5 == n3) {
                                    ++javaThreadsWithoutTLH;
                                } else {
                                    ++javaThreadsWithoutTHTLH;
                                }
                                break block45;
                            }
                            object2 = "        " + string + "TLH cache block located for thread with execenv=0x" + Long.toHexString(cTypeObject.getAddr());
                            if (null == jTextArea) {
                                theOutput.add(object2);
                            } else {
                                jTextArea.append((String)object2);
                            }
                            if (n5 == n3) {
                                ++javaThreadsWithTLH;
                            } else {
                                ++javaThreadsWithTHTLH;
                            }
                            l2 = as.readInt(as.createAddress(cTypeObject3.getAddr()));
                            l3 = as.readInt(as.createAddress(cTypeObject4.getAddr()));
                            object2 = new Range(l, l + l3, n);
                            vector.add(object2);
                        }
                        catch (Exception exception) {
                            String string2 = "*** Unexpected exception while getting cache block for " + string + "TLH : thread id is " + dvThread.id() + "(" + DvUtils.getThreadName(dvThread, as) + ")\n" + "    Exception type = " + exception.getMessage();
                            if (null == jTextArea) {
                                theOutput.add(string2);
                                DvObjectsCommands.that.cpr.output(theOutput);
                                theOutput.clear();
                            } else {
                                jTextArea.append(string2);
                            }
                            exception.printStackTrace();
                        }
                        if (l3 == l2) {
                            if (verboseTLH) {
                                object2 = "        Nothing in " + string + "TLH for Thread " + "(" + dvThread + ")";
                                if (null == jTextArea) {
                                    theOutput.add(object2);
                                } else {
                                    jTextArea.append((String)object2);
                                }
                            }
                        } else {
                            String string3;
                            if (verboseTLH) {
                                object2 = "        Objects in " + string + "TLH for Thread " + "(" + dvThread + ")";
                                if (null == jTextArea) {
                                    theOutput.add(object2);
                                } else {
                                    jTextArea.append((String)object2);
                                }
                            }
                            long l5 = l + l2;
                            int n6 = 0;
                            long l6 = 0L;
                            try {
                                n6 = as.readInt(as.createAddress(cTypeObject5.getAddr()));
                                dvAddress = as.readPointer(as.createAddress(l5));
                                l6 = dvAddress.getAddressAsLong();
                                l6 &= l4;
                            }
                            catch (DvAddressException dvAddressException) {
                                // empty catch block
                            }
                            if (verboseTLH) {
                                string3 = "        " + string + "TLH objects begin at : 0x" + Long.toHexString(l5);
                                if (null == jTextArea) {
                                    theOutput.add(string3);
                                } else {
                                    jTextArea.append(string3);
                                }
                            }
                            if (0L != l6) {
                                n2 += DvObjectsCommands.traverseOneTLHCacheBlock(dvThread, l5, l + l3, string, jTextArea);
                            } else {
                                string3 = "      TLH starting at 0x" + Long.toHexString(l) + " ignored \n" + "     Dump may well have been taken while " + "this thread was in process of allocating object\n" + "        " + string + "TLH objects begin at : 0x" + Long.toHexString(l5);
                                string3 = 0 != n6 ? string3 + "\n   cache_busy flag was set (EXPECTED)" : string3 + "\n   cache_busy flag was NOT set (NOT EXPECTED)!!!";
                                if (null == jTextArea) {
                                    theOutput.add(string3);
                                } else {
                                    jTextArea.append(string3);
                                }
                            }
                        }
                    }
                }
            }
            ++n5;
        }
        DvUtils.writetoTrace("Exit:3 DvObjectsCommands.traverseOneTLH(DvThread, int, Vector)");
        return n2;
    }

    private static int traverseOneTLHCacheBlock(DvThread dvThread, long l, long l2, String string, JTextArea jTextArea) {
        long l3;
        long l4;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.traverseOneTLHCacheBlock(DvThread,long,long,String)");
        int n = 0;
        DvAddress dvAddress = null;
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        if (DvUtils.is64BitSystem(DvConsole.theDump.getArchitecture())) {
            l4 = 0x3FFFFFFFFFFFFFF8L;
            l3 = 1L;
        } else {
            l4 = 0x3FFFFFF8L;
            l3 = 1L;
        }
        try {
            while (l < l2) {
                Object object;
                Object object2;
                long l5 = 0L;
                long l6 = 0L;
                long l7 = 0L;
                long l8 = 0L;
                CTypeObject cTypeObject = null;
                boolean bl = false;
                try {
                    dvAddress = as.readPointer(as.createAddress(l));
                    l8 = dvAddress.getAddressAsLong();
                    if (1L == (l8 & l3)) {
                        bl = true;
                    }
                    l8 &= l4;
                    cTypeObject = new CTypeObject("Hjava_lang_Object", as.createAddress(l + (long)ptrLength), as);
                    CTypeObject cTypeObject2 = cTypeObject.getField("locknflags");
                    dvAddress = as.readPointer(as.createAddress(cTypeObject2.getAddr()));
                    l5 = dvAddress.getAddressAsLong();
                    l5 &= 0xFFFFFFFFL;
                    object2 = cTypeObject.getField("methods");
                    dvAddress = as.readPointer(as.createAddress(((CTypeObject)object2).getAddr()));
                    l6 = dvAddress.getAddressAsLong();
                    object = cTypeObject.getField("obj");
                    dvAddress = as.readPointer(as.createAddress(((CTypeObject)object).getAddr()));
                    l7 = dvAddress.getAddressAsLong();
                }
                catch (DvAddressException dvAddressException) {
                    object2 = "*** Unexpected exception processing an object in " + string + "TLH\n" + "    objPointer=" + l;
                    if (null == jTextArea) {
                        theOutput.add(object2);
                        DvObjectsCommands.that.cpr.output(theOutput);
                        theOutput.clear();
                    } else {
                        jTextArea.append((String)object2);
                    }
                    dvAddressException.printStackTrace();
                }
                boolean bl2 = false;
                if ((l5 & 2L) != 0L) {
                    bl2 = true;
                }
                object2 = new ObjectDetails();
                ((ObjectDetails)object2).methods = l6;
                ((ObjectDetails)object2).obj = l7;
                ((ObjectDetails)object2).heapName = string + "TLH:0x" + Long.toHexString(dvThread.eeAddress().getAddressAsLong());
                ((ObjectDetails)object2).length = l8;
                ((ObjectDetails)object2).address = cTypeObject.getAddr();
                ((ObjectDetails)object2).locknflags = l5;
                object2 = DvObjectsCommands.processData((ObjectDetails)object2);
                if (verboseTLH) {
                    if (bl2) {
                        object = "            Array  @ 0x" + Long.toHexString(l + (long)ptrLength) + " (length=0x" + Long.toHexString(l8) + ") - " + ((ObjectDetails)object2).type + "[" + l6 + "]";
                        if (null == jTextArea) {
                            theOutput.add(object);
                        } else {
                            jTextArea.append((String)object);
                        }
                    } else {
                        object = "            Object @ 0x" + Long.toHexString(l + (long)ptrLength) + " (length=0x" + Long.toHexString(l8) + ") - " + ((ObjectDetails)object2).type;
                        if (null == jTextArea) {
                            theOutput.add(object);
                        } else {
                            jTextArea.append((String)object);
                        }
                    }
                }
                if (verboseTLH) {
                    object = "            *** putting: " + Long.toHexString(l + (long)ptrLength) + ", " + totalObjectCount;
                    if (null == jTextArea) {
                        theOutput.add(object);
                    } else {
                        jTextArea.append((String)object);
                    }
                }
                DvObjectsCommands.processFoundObject(l, true, (short)0, l8, bl);
                ++n;
                if (bl) {
                    ++totalSwappedObjectCount;
                    totalSwappedObjectLength += l8;
                }
                l += l8;
            }
        }
        catch (Exception exception) {
            String string2 = "*** Unexpected exception recieved while examining items on " + string + "TLH\n" + "  Thread=" + dvThread + ", objectPointer=" + l + ", endOfCacheBlock=" + l2;
            if (null == jTextArea) {
                theOutput.add(string2);
                DvObjectsCommands.that.cpr.output(theOutput);
                theOutput.clear();
            } else {
                jTextArea.append(string2);
            }
            exception.printStackTrace();
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.traverseOneTLHCacheBlock(DvThread,long,long,String)");
        return n;
    }

    private static ObjectDetails processData(ObjectDetails objectDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processData(ObjectDetails)");
        objectDetails.type = DvObjectsCommands.processTypes(objectDetails);
        objectDetails.lock = false;
        objectDetails.lkSharedClassLockFlags = false;
        long l = objectDetails.locknflags & 0xFFFFFF00L;
        if (l == 0xFFFFFF00L) {
            objectDetails.lkSharedClassLockFlags = true;
        }
        if (0L != objectDetails.locknflags && l != 0xFFFFFF00L) {
            objectDetails.shapeBit = DvObjectsCommands.processShapeBit(objectDetails);
            if (0L == objectDetails.shapeBit) {
                objectDetails.entryCount = DvObjectsCommands.processEntryCount(objectDetails);
                objectDetails.threadId = DvObjectsCommands.processThreadId(objectDetails);
            } else {
                objectDetails.monitorIndex = DvObjectsCommands.processMonitorIndex(objectDetails);
                objectDetails.inflMon = DvObjectsCommands.processInflMon(objectDetails);
            }
            if (0L != objectDetails.threadId || 0L != objectDetails.entryCount || 0L != objectDetails.monitorIndex) {
                objectDetails.lock = true;
            }
        } else {
            objectDetails.entryCount = 0L;
            objectDetails.threadId = 0L;
            objectDetails.monitorIndex = 0L;
            objectDetails.inflMon = 0L;
            objectDetails.lock = false;
        }
        objectDetails.objectName = DvObjectsCommands.processObjectName(objectDetails);
        objectDetails.className = DvObjectsCommands.processClassName(objectDetails);
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processData(ObjectDetails)");
        return objectDetails;
    }

    private static long processShapeBit(ObjectDetails objectDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processShapeBit(ObjectDetails)");
        long l = objectDetails.locknflags >> 31 & 1L;
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.processShapeBit(ObjectDetails) 32bit");
        return l;
    }

    private static long processEntryCount(ObjectDetails objectDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processEntryCount(ObjectDetails)");
        long l = objectDetails.locknflags >> 8 & 0xFFL;
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.processEntryCount(ObjectDetails)");
        return l;
    }

    private static long processThreadId(ObjectDetails objectDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processThreadId(ObjectDetails)");
        long l = objectDetails.locknflags >> 16 & 0x7FFFL;
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.processThreadId(ObjectDetails)");
        return l;
    }

    private static long processMonitorIndex(ObjectDetails objectDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processMonitorIndex(ObjectDetails)");
        long l = objectDetails.locknflags >> 8 & 0x7FFFFFL;
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.processMonitorIndex(ObjectDetails)");
        return l;
    }

    private static long processInflMon(ObjectDetails objectDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processInflMon(ObjectDetails)");
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        long l = 0L;
        long l2 = 0L;
        DvObjectsCommands.initPtrLength();
        l = Long.parseLong(DvUtils.getJVMHint(as, "LKGLOBALPTR"), 16);
        l2 = Long.parseLong(DvUtils.getJVMHint(as, "DGGLOBALPTR"), 16);
        if (l == l2) {
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processInflMon(ObjectDetails) lk:dataP==dg:dataP");
            return 0L;
        }
        long l3 = objectDetails.address;
        long l4 = 0L;
        try {
            long l5 = DvObjectsCommands.getControlBlockField("_lkgldata", "micb", l, as);
            long l6 = DvObjectsCommands.getControlBlockFieldInt("monitor_index_cb_t", "count", l5, as);
            long l7 = DvObjectsCommands.getControlBlockFieldInt("monitor_index_cb_t", "size", l5, as);
            long l8 = DvObjectsCommands.getControlBlockField("monitor_index_cb_t", "table", l5, as);
            long l9 = l8 + (long)ptrLength * objectDetails.monitorIndex;
            DvAddress dvAddress = as.createAddress(l9);
            dvAddress = as.readPointer(dvAddress);
            if (dvAddress != null) {
                l4 = dvAddress.getAddressAsLong();
            }
        }
        catch (DvAddressException dvAddressException) {
            theOutput.add("DvAddressException in processInflMon");
            DvUtils.writetoTrace("Contine:1 DvObjectsCommands.processInflMon(ObjectDetails) DvAddressException");
        }
        catch (NumberFormatException numberFormatException) {
            theOutput.add("DvNumberFormatException in processInflMon");
            theOutput.add("Possible cause by not having hints setup properly");
            DvUtils.writetoTrace("Contine:2 DvObjectsCommands.processInflMon(ObjectDetails) NumberFormatException");
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processInflMon(ObjectDetails)");
        return l4;
    }

    private static boolean processLock(ObjectDetails objectDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processLocks(ObjectDetails)");
        if (0L != objectDetails.threadId || 0L != objectDetails.entryCount || 0L != objectDetails.monitorIndex) {
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processLocks(ObjectDetails)");
            return true;
        }
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.processLocks(ObjectDetails)");
        return false;
    }

    private static String processObjectName(ObjectDetails objectDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processObjectName(ObjectDetails)");
        String string = "";
        long l = objectDetails.address;
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processObjectName(ObjectDetails)");
        return DvObjectsCommands.processObjectName(l, (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A"));
    }

    private static String processObjectName(long l, DvAddressSpace dvAddressSpace) {
        long l2;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processObjectName(long, DvAddressSpace)");
        String string = "";
        boolean bl = true;
        long l3 = 0L;
        DvObjectsCommands.initPtrLength();
        try {
            l3 = as.readInt(as.createAddress(l + (long)ptrLength));
        }
        catch (DvAddressException dvAddressException) {
            theOutput.add("DvAddressException in processObjectName ");
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processObjectName(long, DvAddressSpace) DvAddressException");
            return string;
        }
        if ((l3 >> 3 & 0x1FL) == 0L && (l3 >> 1 & 1L) == 0L) {
            try {
                long l4;
                l2 = l4 = DvObjectsCommands.getControlBlockField("Hjava_lang_Object", "methods", l, dvAddressSpace);
                long l5 = DvObjectsCommands.getControlBlockField("methodtable", "classdescriptor", l4, dvAddressSpace);
                long l6 = DvUtils.getFieldAddress(l5, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
                long l7 = DvObjectsCommands.getControlBlockField("Classjava_lang_Class", "name", l6, dvAddressSpace);
                string = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(dvAddressSpace.createAddress(l7), 256L));
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.writetoTrace("Continue:1 DvObjectsCommands.processObjectName(long, DvAddressSpace) DvAddressException");
                if (DvConsole.bGuiRequested) {
                    Dumpviewer.showMessage("\n******************\n DvObjectsCommands.processObjectName failure(1)\n for 0x" + Long.toHexString(l) + "\n******************\n", false);
                }
                bl = false;
            }
            catch (NullPointerException nullPointerException) {
                DvUtils.writetoTrace("Continue:2 DvObjectsCommands.processObjectName(long, DvAddressSpace) NullPointerException");
                if (DvConsole.bGuiRequested) {
                    Dumpviewer.showMessage("\n******************\n DvObjectsCommands.processObjectName failure(2)\n for 0x" + Long.toHexString(l) + "\n******************\n", false);
                }
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!bl) {
            l2 = l3 >> 3 & 0x1FL;
            string = DvObjectsCommands.processTypes(l3);
        }
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.processObjectName(long, DvAddressSpace)");
        return string;
    }

    private static String processClassName(ObjectDetails objectDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processClassName(ObjectDetails)");
        if (0 != objectDetails.objectName.compareToIgnoreCase("java/lang/Class")) {
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processClassName(ObjectDetails)");
            return null;
        }
        long l = objectDetails.address;
        String string = null;
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        try {
            long l2 = DvUtils.getFieldAddress(l, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
            long l3 = DvObjectsCommands.getControlBlockField("Classjava_lang_Class", "name", l2, dvAddressSpace);
            string = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(dvAddressSpace.createAddress(l3), 256L));
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.writetoTrace("Continue:1 DvObjectsCommands.processClassName(ObjectDetails) DvAddressException");
        }
        DvUtils.writetoTrace("Exit:2 DvObjectsCommands.processClassName(ObjectDetails)");
        return string;
    }

    private static String processTypes(ObjectDetails objectDetails) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processTypes(ObjectDetails)");
        long l = objectDetails.locknflags;
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processTypes(ObjectDetails)");
        return DvObjectsCommands.processTypes(l);
    }

    private static String processTypes(long l) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processTypes(long)");
        String string = "";
        switch ((int)l & 7) {
            case 4: {
                string = string + "hashedAndMoved ";
                break;
            }
            case 2: {
                string = string + "array ";
                break;
            }
            case 1: {
                string = string + "hashed ";
            }
        }
        switch ((int)(l >> 3) & 0x1F) {
            case 5: {
                string = string + "char";
                break;
            }
            case 4: {
                string = string + "boolean";
                break;
            }
            case 6: {
                string = string + "float";
                break;
            }
            case 7: {
                string = string + "double";
                break;
            }
            case 8: {
                string = string + "byte";
                break;
            }
            case 9: {
                string = string + "short";
                break;
            }
            case 10: {
                string = string + "int";
                break;
            }
            case 12: {
                string = string + "uintpointer";
                break;
            }
            case 11: {
                string = string + "long";
                break;
            }
            case 2: {
                string = string + "class";
                break;
            }
            case 0: {
                string = string + "normal_object";
            }
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processTypes(long)");
        return string;
    }

    private static boolean checkAllocbit(long l, DvAddressSpace dvAddressSpace) {
        DvUtils.writetoTrace("Entry:DvObjects.checkAllocbit  (0x" + Long.toHexString(l) + ")");
        boolean bl = false;
        int n = 0;
        long l2 = 0L;
        byte by = 0;
        long l3 = l / 64L;
        if (0L == allocBitsAddress) {
            allocBitsAddress = DvUtils.hexToLong(DvUtils.getJVMHint(as, "ALLOCBITS"));
        }
        if (0L != allocBitsAddress) {
            try {
                by = as.readByte(dvAddressSpace.createAddress(allocBitsAddress + l3));
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.trace("Continue:1 DvObjects.checkAllocbit \n !!!!!!!!!!!!!!!!!!!!!!\n DvAddressException trying to read AllocBits\n Address = 0x" + Long.toHexString(allocBitsAddress + l3) + "\n Address: " + "\n !!!!!!!!!!!!!!!!!!!!!!", 0, true);
            }
        } else {
            DvUtils.trace("Continue:2 DvObjects.checkAllocbit \n !!!!!!!!!!!!!!!!!!!!!!\n ALLOCBITS hint was 0 - suggests an error in control\n block structure or wrong types file information\n !!!!!!!!!!!!!!!!!!!!!!", 0, true);
        }
        n = (int)(l % 64L) / 8;
        if (!DvUtils.isBigEndian(DvConsole.theDump.getArchitecture())) {
            n = 7 - n;
        }
        if (0 != (by & allocBitsTestBytes[n])) {
            bl = true;
        }
        DvUtils.writetoTrace("Exit:1 DvObjects.checkAllocbit (" + (bl ? "true)" : "false)"));
        return bl;
    }

    protected static DvObjectsCommands getCurrentInstance() {
        DvUtils.writetoTrace("Entry/Exit:DvObjectsCommands.getCurrentInstance()");
        return that;
    }

    public static boolean heapsAlreadyTraversed() {
        return heapsTraversed;
    }

    public static void heapsNeedRetraversal() {
        DvUtils.writetoTrace("Entry: DvObjectsCommands.heapsNeedRetraversal()");
        DvConsole.bHeapTraversalInprogress = false;
        allocBitsAddress = 0L;
        heapsTraversed = false;
        namesIndexFile = null;
        extendedAllocBits = null;
        lockedAllocBits = null;
        startOfMHeap = 0L;
        endOfMHeap = 0L;
        startOfTransHeap = 0L;
        endOfTransHeap = 0L;
        DvUtils.safeClear(systemHeapHashByAddr);
        DvUtils.safeClear(acsHeapHashByAddr);
        DvUtils.safeClear(lockedObjects);
        DvUtils.safeClear(inflMonList);
        DvUtils.safeClear(regMonList);
        DvUtils.safeClear(threadList);
        DvUtils.safeClear(deadlocks);
        DvUtils.safeClear(threadsBySysthr);
        DvUtils.safeClear(threadsById);
        DvUtils.safeClear(monitorsByAddr);
        DvUtils.safeClear(monitorsBySysmon);
        DvUtils.writetoTrace("Exit: DvObjectsCommands.heapsNeedRetraversal()");
    }

    protected String getObjectNameAtAddress(long l) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.getObjectNameAtAddress(long)");
        if (!heapsTraversed) {
            theOutput.add("Traversing Heaps!");
            this.cpr.output(theOutput);
            theOutput.clear();
            DvObjectsCommands.traverseAllHeaps(null);
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.getObjectNameAtAddress(long)");
        return DvObjectsCommands.processObjectName(l, as);
    }

    protected String getClassNameAtAddress(long l) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.getClassNameAtAddress(long)");
        if (!heapsTraversed) {
            theOutput.add("Traversing Heaps!");
            this.cpr.output(theOutput);
            theOutput.clear();
            DvObjectsCommands.traverseAllHeaps(null);
        }
        ObjectDetails objectDetails = new ObjectDetails();
        objectDetails.address = l;
        objectDetails.objectName = "java/lang/Class";
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.getClassNameAtAddress(long)");
        return DvObjectsCommands.processClassName(objectDetails);
    }

    private void returnControl() {
        this.cpr.output(theOutput);
        theOutput.clear();
        unknownSystem = false;
        this.forcedEnd = true;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public static Object getGenericHelp() {
        DvUtils.writetoTrace("Entry:DvObjectCommands.getGenericHelp");
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvObjectsCommands.properties");
        DvUtils.writetoTrace("Exit:1 DvObjectCommands.getGenericHelp");
        return vector;
    }

    private static ObjectDetails getObjectDetails(long l) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.getObjectDetails(long " + l + ")");
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        ObjectDetails objectDetails = new ObjectDetails();
        try {
            long l6;
            if (is64bit) {
                l2 = as.readLong(as.createAddress(l));
                l2 &= 0x3FFFFFFFFFFFFFF8L;
                l6 = l += 8L;
                l3 = as.readLong(as.createAddress(l));
                l += 8L;
            } else {
                l2 = as.readInt(as.createAddress(l));
                l2 &= 0x3FFFFFF8L;
                l6 = l += 4L;
                l3 = as.readInt(as.createAddress(l));
                l += 4L;
            }
            l4 = as.readInt(as.createAddress(l));
            l4 &= 0xFFFFFFFFL;
            l5 = as.readInt(as.createAddress(l += 4L));
            objectDetails.methods = l3;
            objectDetails.obj = l5;
            objectDetails.heapName = DvObjectsCommands.establishHeapName(l6);
            if (null == objectDetails.heapName) {
                objectDetails.heapName = "??????";
            }
            objectDetails.length = l2;
            objectDetails.address = l6;
            objectDetails.locknflags = l4;
            objectDetails = DvObjectsCommands.processData(objectDetails);
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.writetoTrace("Continue:1 DvObjectsCommands.getObjectDetails(long)");
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.getObjectDetails(long)");
        return objectDetails;
    }

    private static void openNamesIndexFile() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.openNamesIndexFile()");
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        long l = DvUtils.jvmFromThreadId(dvThread.id());
        String string = DvUtils.getJVMHint(l, "JVM");
        String string2 = DvUtils.getValue("Dump") + string + ".nidx";
        String string3 = DvUtils.getValue("WorkDir");
        if (null != string3) {
            string2 = DvUtils.stripToFileName(string2);
            string2 = string3 + string2;
        }
        try {
            namesIndexFile = new DvNamesIndexFile(string2, "r", 0, 0, 0, 123456L);
            names_index_built = true;
        }
        catch (IOException iOException) {
            theOutput.add("Invalid or non-existant class names index file\nDump must be scanned (dis os) and index created");
            DvObjectsCommands.that.cpr.output(theOutput);
            theOutput.clear();
            try {
                namesIndexFile = new DvNamesIndexFile(string2, "rw", 1024, 100, 100, 123456L);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.openNamesIndexFile()");
    }

    private static void initPtrLength() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.initPtrLength()");
        if (null == DvConsole.theDump) {
            System.out.println("theDump is nul!!!!");
        }
        ptrLength = DvUtils.is64BitSystem(DvConsole.theDump.getArchitecture()) ? 8 : 4;
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.initPtrLength()");
    }

    public void objectAnalyze() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.objectAnalyze()");
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.objectAnalyze()");
    }

    public static void createEAB(DvAddressSpace dvAddressSpace) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.createEAB(DvAddressSpace)");
        String string = DvUtils.getJVMHint(dvAddressSpace, "MH_HEAPBASE");
        String string2 = DvUtils.getJVMHint(dvAddressSpace, "MH_HEAPLIMIT");
        String string3 = DvUtils.getJVMHint(dvAddressSpace, "TH_HEAPBASE");
        String string4 = DvUtils.getJVMHint(dvAddressSpace, "TH_HEAPLIMIT");
        startOfMHeap = Long.parseLong(string, 16);
        endOfMHeap = Long.parseLong(string2, 16);
        startOfTransHeap = Long.parseLong(string3, 16);
        endOfTransHeap = Long.parseLong(string4, 16);
        int n = 0;
        n = 0L == endOfTransHeap ? (int)((endOfMHeap - startOfMHeap) / 64L) : (int)((endOfTransHeap - startOfMHeap) / 64L);
        extendedAllocBits = new byte[n];
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.createEAB(DvAddressSpace) Allocated " + n + " bytes for extendedAllocBits");
    }

    public static boolean flipEAB(long l) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.flipEAB(long)");
        boolean bl = true;
        if (extendedAllocBits == null) {
            DvObjectsCommands.createEAB(as);
        }
        long l2 = l;
        long l3 = l2 - startOfMHeap;
        l2 = l3 / 64L;
        int n = (int)(l3 % 64L) / 8;
        try {
            if (0 == (extendedAllocBits[(int)l2] & allocBitsTestBytes[n])) {
                int n2 = (int)l2;
                extendedAllocBits[n2] = (byte)(extendedAllocBits[n2] | allocBitsTestBytes[n]);
                int n3 = extendedAllocBits[(int)l2];
                if (n3 < 0) {
                    n3 += 256;
                }
            } else {
                DvUtils.trace("Continue:2 DvObjectsCommands.flipEAB(long) Found extendedAllocBits inconsistency \n !!! for: 0x" + Long.toHexString(l) + " bit already on !\n" + "This is suggestive of heap corruption and\n" + "should be investigated\n", 0, true);
                bl = false;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            DvUtils.trace("Continue:2 DvObjectsCommands.flipEAB(long) Trying to flip bit outside of array for 0x" + Long.toHexString(l), 0, true);
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.flipEAB(long)");
        return bl;
    }

    public static boolean checkForKnownObject(long l) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.checkForKnownObject(long)");
        boolean bl = false;
        if (0L == (l + (long)ptrLength) % 8L) {
            if (l >= startOfMHeap && l <= endOfMHeap) {
                long l2 = l;
                long l3 = l2 - startOfMHeap;
                int n = (int)(l3 % 64L) / 8;
                if (0 != (extendedAllocBits[(int)(l2 = l3 / 64L)] & allocBitsTestBytes[n])) {
                    bl = true;
                }
            } else {
                Long l4 = new Long(l);
                if (systemHeapHashByAddr.contains(l4) || acsHeapHashByAddr.contains(l4)) {
                    bl = true;
                }
            }
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.checkForKnownObject(long)");
        return bl;
    }

    private static boolean processFoundObject(long l, boolean bl, short s, long l2, boolean bl2) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processFoundObject: 0x " + Long.toHexString(l) + " : " + bl + " : " + l2);
        boolean bl3 = true;
        String string = "";
        DvObjectsCommands.initPtrLength();
        if (!names_index_built) {
            string = false == bl2 ? DvObjectsCommands.processObjectName(l + (long)ptrLength, as) : "+IsSwapped+";
            namesIndexFile.write(string, l, s, l2);
        }
        if (bl) {
            bl3 = DvObjectsCommands.flipEAB(l);
        } else if (s == -4) {
            systemHeapHashByAddr.add(new Long(l));
        } else {
            acsHeapHashByAddr.add(new Long(l));
        }
        long l3 = 0L;
        try {
            l3 = as.readInt(as.createAddress(l + (long)(ptrLength * 2)));
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.writetoTrace("Continue:1 DvObjectsCommands.processFoundObject(long,boolean,short,long) DvAddressException");
        }
        long l4 = l3 & 0xFFFFFF00L;
        if (l3 != 0L && l4 != 0xFFFFFF00L && (l3 &= 0xFFFFF800L) != 0L) {
            lockedObjects.add(new Long(l));
            ++totalLockedObjectCount;
        }
        ++totalObjectCount;
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processFoundObject(long,boolean,short,long)");
        return bl3;
    }

    private static int[] sortRanges(Vector vector) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.sortRanges()");
        int[] nArray = null;
        if (0 != vector.size()) {
            nArray = new int[vector.size()];
            long[] lArray = new long[vector.size()];
            int n = 0;
            while (n < nArray.length) {
                Range range = (Range)vector.get(n);
                if (0 == n) {
                    nArray[0] = 0;
                    lArray[0] = range.start;
                } else {
                    int n2 = n - 1;
                    while (n2 > -1) {
                        if (range.start <= lArray[n2]) {
                            nArray[n2 + 1] = nArray[n2];
                            lArray[n2 + 1] = lArray[n2];
                            nArray[n2] = n;
                            lArray[n2] = range.start;
                        } else {
                            nArray[n2 + 1] = n;
                            lArray[n2 + 1] = range.start;
                            n2 = -1;
                        }
                        --n2;
                    }
                }
                ++n;
            }
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.sortRanges()");
        return nArray;
    }

    private static String establishHeapName(long l) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.establishHeapName(long)");
        Object var2_1 = null;
        int n = 0;
        while (n < rangeArray.length) {
            if (l >= rangeArray[n][0] && l <= rangeArray[n][1]) {
                if (rangeArray[n][2] == -1L) {
                    DvUtils.writetoTrace("Exit:1 DvObjectsCommands.establishHeapName(long)");
                    return "System";
                }
                DvProcess dvProcess = (DvProcess)DvUtils.getAPT(DvConsole.theDump, "P");
                DvThread[] dvThreadArray = dvProcess.getThreads();
                DvUtils.writetoTrace("Exit:2 DvObjectsCommands.establishHeapName(long)");
                return "TLH for thread " + dvThreadArray[(int)rangeArray[n][2]].id();
            }
            if (l < rangeArray[n][0]) {
                n = rangeArray.length;
            }
            ++n;
        }
        if (l >= startOfTransHeap && l < endOfTransHeap) {
            DvUtils.writetoTrace("Exit:3 DvObjectsCommands.establishHeapName(long)");
            return "Transient";
        }
        if (l >= startOfMHeap && l < endOfMHeap) {
            DvUtils.writetoTrace("Exit:4 DvObjectsCommands.establishHeapName(long)");
            return "MiddleWare";
        }
        DvUtils.writetoTrace("Exit:5 DvObjectsCommands.establishHeapName(long)");
        return "ACS (assumed)";
    }

    public String whatIs(DvAddress dvAddress, String string, DvDump dvDump) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.whatIs(DvAddress, String, DvDump)");
        String string2 = null;
        if (null != dvAddress) {
            if (!heapsTraversed) {
                string2 = "  DvObjectsCommands: Unable to establish if " + string + " is an object in a heap ...\n" + "    as heaps not yet traversed (run \"dis os\" and retry)";
            } else {
                int n;
                int n2;
                boolean bl = false;
                string2 = "";
                long l = dvAddress.getAddressAsLong();
                if (l >= startOfMHeap && l <= endOfMHeap && l != 0L) {
                    string2 = string2 + "  \"" + string + "\" is in the middleware heap range";
                    bl = true;
                }
                if (l >= startOfTransHeap && l <= endOfTransHeap && l != 0L) {
                    string2 = string2 + "  \"" + string + "\" is in the transient heap range";
                    bl = true;
                }
                if (null != rangeArray) {
                    n2 = rangeArray.length;
                    n = 0;
                    while (n < n2) {
                        if (l >= rangeArray[n][0] && l <= rangeArray[n][1] && l != 0L) {
                            bl = true;
                            if (-1L == rangeArray[n][2]) {
                                string2 = string2 + "\n Its within a System Heap";
                            } else {
                                DvProcess dvProcess = (DvProcess)DvUtils.getAPT(dvDump, "P");
                                DvThread[] dvThreadArray = dvProcess.getThreads();
                                string2 = string2 + "\n Its in TLH for thread " + dvThreadArray[(int)rangeArray[n][2]].id();
                            }
                        }
                        ++n;
                    }
                }
                if (bl) {
                    n2 = 0;
                    n = 0;
                    boolean bl2 = false;
                    if (0L == l % 8L) {
                        if (DvObjectsCommands.checkForKnownObject(l - (long)ptrLength)) {
                            string2 = string2 + "\n Its a known object (use \"dis obj " + string + "\" to view it)";
                            n2 = 1;
                        }
                        if (DvObjectsCommands.checkForKnownObject(l)) {
                            string2 = string2 + "\n It addresses length field of known object (use \"dis obj " + string + ptrLength + "\" to view it)";
                            n = 1;
                        }
                    } else if (0L == l % 4L && !DvUtils.is64BitSystem(dvDump.getArchitecture()) && DvObjectsCommands.checkForKnownObject(l + 4L - (long)ptrLength)) {
                        string2 = string2 + "\n It addresses length field of known object (use \"dis obj  0x" + Long.toHexString(l + 4L) + "\" to view it)";
                        n = 1;
                    }
                    if (0 == n && 0 == n2) {
                        long l2 = l - l % 8L;
                        boolean bl3 = false;
                        int n3 = 0;
                        while (n3 < 4096 && !bl3) {
                            if (DvObjectsCommands.checkForKnownObject(l2 - (long)ptrLength)) {
                                bl3 = true;
                            } else {
                                l2 -= 8L;
                            }
                            ++n3;
                        }
                        if (bl3) {
                            ObjectDetails objectDetails = DvObjectsCommands.getObjectDetails(l2 - (long)ptrLength);
                            string2 = l2 - (long)ptrLength + objectDetails.length > l ? string2 + "\n found object (" + objectDetails.objectName + ") at " + Long.toHexString(l2) + " (length:" + objectDetails.length + ")" + "\n\t....that covers this address (offset 0x" + Long.toHexString(l - l2) + ")" : string2 + "\n nearest object (" + objectDetails.objectName + ") at " + Long.toHexString(l2) + " (length:" + objectDetails.length + ")" + "\n\t....but it does not cover this address";
                        } else {
                            string2 = string2 + "\n Couldn't find an object covering \"" + string + "\"";
                        }
                    }
                }
                if (0 != regMonList.size()) {
                    n2 = 0;
                    while (n2 < regMonList.size()) {
                        MonDetails monDetails = (MonDetails)regMonList.elementAt(n2);
                        if (dvAddress.getAddressAsLong() == monDetails.getAddress()) {
                            string2 = string2 + "\n Its an registered Monitor\n";
                            string2 = string2 + "    name    " + monDetails.getName() + "\n";
                            string2 = string2 + "    to view registered monitor use \"dis lr 0x" + Long.toHexString(monDetails.getAddress()) + "\"\n";
                            string2 = string2 + "    to view sys_mon use \"for 0x" + Long.toHexString(monDetails.getSysMon()) + " as sys_mon\"\n";
                            if (0L != monDetails.getOwnerAddress()) {
                                string2 = string2 + "    locked by thread \"" + monDetails.getOwnerName() + "\"\n";
                            }
                            if (0L < monDetails.getWaiterSize()) {
                                string2 = string2 + "    Waiting to be notified:\n";
                                int n4 = 0;
                                while ((long)n4 < monDetails.getWaiterSize()) {
                                    string2 = string2 + "         \"" + monDetails.getWaiterName(n4) + "\"\n";
                                    ++n4;
                                }
                            }
                        }
                        ++n2;
                    }
                }
                if (0 != inflMonList.size()) {
                    n2 = 0;
                    while (n2 < inflMonList.size()) {
                        MonDetails monDetails = (MonDetails)inflMonList.elementAt(n2);
                        if (dvAddress.getAddressAsLong() == monDetails.getAddress()) {
                            string2 = string2 + "\n Its an inflated Monitor\n";
                            string2 = string2 + "    object    " + monDetails.getObjectName() + "\n";
                            string2 = string2 + "    to view infl_mon use \"for 0x" + Long.toHexString(monDetails.getAddress()) + " as infl_mon\"\n";
                            string2 = string2 + "    to view sys_mon use \"for 0x" + Long.toHexString(monDetails.getSysMon()) + " as sys_mon\"\n";
                            string2 = 0L != monDetails.getOwnerAddress() ? string2 + "    inflated locked by thread \"" + monDetails.getOwnerName() + "\"\n" : string2 + "    WARNING will not show flat locks!! because it is a inflated monitor\n";
                            if (0L < monDetails.getWaiterSize()) {
                                string2 = string2 + "    Waiting to be notified:\n";
                                int n5 = 0;
                                while ((long)n5 < monDetails.getWaiterSize()) {
                                    string2 = string2 + "         \"" + monDetails.getWaiterName(n5) + "\"\n";
                                    ++n5;
                                }
                            }
                        }
                        ++n2;
                    }
                }
                if (0 != threadList.size()) {
                    n2 = 0;
                    while (n2 < threadList.size()) {
                        ThreadDetails threadDetails = (ThreadDetails)threadList.elementAt(n2);
                        if (threadDetails.getThreadID().equals(Long.toHexString(dvAddress.getAddressAsLong()))) {
                            string2 = string2 + "\n Its a thread\n";
                            string2 = string2 + "    name    " + threadDetails.getThreadName() + "\n";
                            string2 = string2 + "    to view thread use \"dis thread " + threadDetails.getThreadID() + "\"\n";
                        }
                        ++n2;
                    }
                }
            }
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.whatIs(DvAddress, String, DvDump)");
        return string2;
    }

    public Vector guiMenus() {
        Vector vector = new Vector();
        vector.add(new DvMenu("Objects", 79, false));
        vector.add(new DvMenuItem("Objects", "Object Summary (text)", -1, null, false, "displayObjectSummary", thisName, null, null, null, null, true));
        vector.add(new DvMenuItem("Objects", "Object tree", -1, null, false, "displayObjectSummary", thisName, null, "osDoubleClick", "osRightClick", null, true));
        vector.add(new DvMenuItem("Objects", "Heap Analysis", -1, null, false, "heapAnalyse", thisName, null, null, null, null, true));
        vector.add(new DvMenu("Locks", 76, false));
        vector.add(new DvMenuItem("Locks", "Lock Summary (text)", -1, null, false, "displayLockSummary", thisName, null, null, null, null, true));
        vector.add(new DvMenuItem("Locks", "Locked Objects", -1, null, false, "displayLockedThreads", thisName, null, null, null, null, true));
        vector.add(new DvMenuItem("Locks", "Locked Threads", -1, null, false, "displayLockedThreads", thisName, null, null, null, null, true));
        vector.add(new DvMenuItem("Locks", "Registered Monitor Locks", -1, null, false, "displayLockedThreads", thisName, null, null, null, null, true));
        vector.add(new DvMenuItem("Locks", "Deadlock detection", -1, null, false, "displayDeadLocks", thisName, null, null, null, null, true));
        return vector;
    }

    public static void displayObjectSummary(String string) {
        DvUtils.writetoTrace(" displayObjectSummary (gui) entry: " + string);
        Vector vector = new Vector();
        boolean bl = false;
        boolean bl2 = false;
        if (-1 != string.indexOf("tree")) {
            bl2 = true;
        }
        if (bl2) {
            Object object;
            JInternalFrame jInternalFrame = Dumpviewer.getInternalFrame(string, Dumpviewer.theIFM.getDefaultProperties(), 0, string);
            Dumpviewer.addIFrameToDesktop(jInternalFrame, 430, 450, 5, Dumpviewer.selfRef.getHeight() - 530);
            int n = 0;
            while (n < Dumpviewer.objectStats.size()) {
                object = Dumpviewer.objectStats.get(n);
                if (object instanceof Vector && 0 != ((Vector)object).size()) {
                    int n2 = 0;
                    while (n2 < ((Vector)object).size()) {
                        Object object2 = ((Vector)object).get(n2);
                        String string2 = (String)object2;
                        if (-1 != string2.indexOf(" (=")) {
                            vector.add(string2);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            try {
                object = new String[1];
                Object[] objectArray = vector.toArray((Object[])object);
                objTree = objectArray != null ? DvObjectsCommands.fillNamesTree((String[])objectArray, "Objects") : DvObjectsCommands.fillNamesTree(object, "Objects");
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                exception.printStackTrace();
            }
            Dumpviewer.theIFM.addContentToFrame(jInternalFrame, objTree);
            Dumpviewer.addMouseListener(jInternalFrame, objTree);
        } else {
            JInternalFrame jInternalFrame = Dumpviewer.getInternalFrame(string, Dumpviewer.theIFM.getDefaultProperties(), 0, string);
            Dumpviewer.addIFrameToDesktop(jInternalFrame, 230, 450, 5, Dumpviewer.selfRef.getHeight() - 530);
            JTextArea jTextArea = new JTextArea(objSummary, 8, 25);
            jTextArea.setEditable(false);
            Dumpviewer.theIFM.addContentToFrame(jInternalFrame, jTextArea);
        }
        DvUtils.writetoTrace(" displayObjectSummary (gui) exit");
    }

    private static JTree fillNamesTree(String[] stringArray, String string) {
        Object object;
        String string2;
        Object object2;
        DefaultMutableTreeNode defaultMutableTreeNode;
        DvUtils.writetoTrace("fillNamesTree entry: " + string);
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        String string3 = "";
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = new StringTokenizer(stringArray[n2], "/");
            string2 = ((StringTokenizer)object2).nextToken();
            if (!string2.startsWith("[")) {
                object = "";
                String string4 = "";
                if (string2.equals(string3)) {
                    int n3 = stringArray[n2].indexOf(":");
                    if (-1 != n3) {
                        object = stringArray[n2].substring(0, n3 - 2);
                        string4 = "instances:" + stringArray[n2].substring(n3 + 1);
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(object);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(string4);
                    defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(string2);
                    defaultMutableTreeNode2 = defaultMutableTreeNode;
                    defaultMutableTreeNode2.add(defaultMutableTreeNode5);
                    string3 = new String(string2);
                    defaultMutableTreeNode2 = defaultMutableTreeNode5;
                }
            }
            ++n2;
        }
        object2 = new JTree(defaultMutableTreeNode);
        ((JTree)object2).getSelectionModel().setSelectionMode(1);
        string2 = null;
        ((JComponent)object2).setFont(new Font("Monospaced", 1, 14));
        object = new DefaultTreeCellRenderer();
        ((DefaultTreeCellRenderer)object).setLeafIcon((Icon)((Object)string2));
        ((DefaultTreeCellRenderer)object).setClosedIcon((Icon)((Object)string2));
        ((DefaultTreeCellRenderer)object).setOpenIcon((Icon)((Object)string2));
        ((JTree)object2).setCellRenderer((TreeCellRenderer)object);
        DvUtils.writetoTrace("fillNamesTree exit: " + string);
        return object2;
    }

    public static void osDoubleClick(JInternalFrame jInternalFrame, MouseEvent mouseEvent) {
        DvUtils.writetoTrace("DVObjectsCommands:osDoubleClick entry");
        Object object = mouseEvent.getSource();
        if (object instanceof JTree) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = ((JTree)object).getClosestRowForLocation(n2, n = mouseEvent.getY());
            if (-1 != n3) {
                if (((JTree)object).isCollapsed(n3)) {
                    Object object2 = ((JTree)object).getLastSelectedPathComponent();
                    String string = object2.toString();
                    int n4 = 4;
                    int n5 = string.indexOf("@ 0x");
                    if (-1 == n5) {
                        n5 = string.indexOf(" 0x");
                        n4 = 3;
                    }
                    if (-1 != n5) {
                        String string2 = string.substring(n5 + n4);
                        try {
                            long l = Long.parseLong(string2, 16);
                            DvAddress dvAddress = new DvAddress(l);
                            DvBaseCommands.displayMemory(dvAddress, 512L);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            } else {
                System.out.println(" getClosestRowForLocation returned -1");
            }
        } else {
            DvUtils.writetoTrace(" .... event not associated with our JTree !!! ");
        }
        DvUtils.writetoTrace("DVObjectsCommands:osDoubleClick exit");
    }

    public static void displayLockedThreads(String string) {
        Serializable serializable;
        Vector vector;
        Object object;
        DvUtils.writetoTrace(" displayLockedThreads entry: " + string);
        Object var1_1 = null;
        boolean bl = false;
        boolean bl2 = true;
        Vector vector2 = new Vector();
        DvObjectsCommands.that.cpr = new CommandPluginResponse(vector2);
        boolean bl3 = false;
        boolean bl4 = false;
        if (string.equals("Registered Monitor Locks")) {
            that.displayLockedReg();
            bl3 = true;
        } else if (string.equals("Locked Objects")) {
            that.displayLockedObjects();
            bl4 = true;
        } else {
            that.displayThreads();
        }
        Vector vector3 = (Vector)vector2.get(0);
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        defaultMutableTreeNode = true == bl3 ? new DefaultMutableTreeNode("Registered Monitors") : (true == bl4 ? new DefaultMutableTreeNode("Objects") : new DefaultMutableTreeNode("Threads"));
        Object object2 = defaultMutableTreeNode;
        int n = vector3.size();
        int n2 = 0;
        while (n2 < n) {
            Object object3;
            int n3;
            String string2;
            object = vector3.get(n2);
            if (!bl3 && object instanceof String) {
                vector = new Vector();
                serializable = new Vector();
                if (!bl4 && -1 != ((String)object).indexOf(" \"") || bl4 && ((String)object).startsWith("    (0x")) {
                    Object object4;
                    string2 = (String)object;
                    boolean bl5 = false;
                    int n4 = n2 + 1;
                    vector.clear();
                    ((Vector)serializable).clear();
                    while (!bl5 && n4 < n) {
                        object4 = vector3.get(n4);
                        if (object4 instanceof String) {
                            if (!bl4 && -1 != ((String)object4).indexOf(" \"")) {
                                bl5 = true;
                                n2 = --n4 - 1;
                            }
                            if (bl4 && ((String)object4).startsWith("    (0x")) {
                                bl5 = true;
                                n2 = --n4 - 1;
                            }
                            if (-1 != ((String)object4).indexOf("lock on") || -1 != ((String)object4).indexOf("locked by")) {
                                vector.add(object4);
                            }
                            if (-1 != ((String)object4).indexOf("Owns Objects") || -1 != ((String)object4).indexOf("Owns Registered Monitors")) {
                                vector.add(object4);
                            }
                            if (-1 != ((String)object4).indexOf("Waiting to be notified") || -1 != ((String)object4).indexOf("waiting on") || -1 != ((String)object4).indexOf("Waiting to enter") || -1 != ((String)object4).indexOf("<unowned>")) {
                                ((Vector)serializable).add(object4);
                            }
                            if (-1 != ((String)object4).indexOf(" \"") && -1 == ((String)object4).indexOf("locked by") && !bl5) {
                                ((Vector)serializable).add(object4);
                            }
                        }
                        ++n4;
                    }
                    if (0 != vector.size() || 0 != ((Vector)serializable).size()) {
                        DefaultMutableTreeNode defaultMutableTreeNode2;
                        object2 = defaultMutableTreeNode;
                        object4 = new DefaultMutableTreeNode(string2);
                        ((DefaultMutableTreeNode)object2).add((MutableTreeNode)object4);
                        object2 = object4;
                        if (0 != vector.size()) {
                            n3 = 0;
                            while (n3 < vector.size()) {
                                object3 = (String)vector.get(n3);
                                defaultMutableTreeNode2 = new DefaultMutableTreeNode(object3);
                                ((DefaultMutableTreeNode)object2).add(defaultMutableTreeNode2);
                                ++n3;
                            }
                        }
                        if (0 != ((Vector)serializable).size()) {
                            n3 = 0;
                            while (n3 < ((Vector)serializable).size()) {
                                object3 = (String)((Vector)serializable).get(n3);
                                defaultMutableTreeNode2 = new DefaultMutableTreeNode(object3);
                                ((DefaultMutableTreeNode)object2).add(defaultMutableTreeNode2);
                                ++n3;
                            }
                        }
                    }
                }
            } else if (bl3 && object instanceof Vector) {
                int n5 = ((Vector)object).size();
                int n6 = 0;
                while (n6 < n5) {
                    string2 = (String)((Vector)object).get(n6);
                    Vector vector4 = new Vector();
                    if (string2.startsWith("(")) {
                        String string3 = string2;
                        boolean bl6 = false;
                        n3 = n6 + 1;
                        vector4.clear();
                        while (!bl6 && n3 < n5) {
                            object3 = ((Vector)object).get(n3);
                            if (object3 instanceof String) {
                                if (((String)object3).startsWith("(")) {
                                    bl6 = true;
                                    --n3;
                                } else {
                                    vector4.add(object3);
                                }
                            }
                            ++n3;
                        }
                        object2 = defaultMutableTreeNode;
                        object3 = new DefaultMutableTreeNode(string3);
                        ((DefaultMutableTreeNode)object2).add((MutableTreeNode)object3);
                        object2 = object3;
                        if (0 != vector4.size()) {
                            int n7 = 0;
                            while (n7 < vector4.size()) {
                                String string4 = (String)vector4.get(n7);
                                ++n7;
                            }
                        }
                    }
                    ++n6;
                }
            }
            ++n2;
        }
        Dumpviewer.savedConsoleOutput.clear();
        object = Dumpviewer.theIFM.createNewFrame(string, Dumpviewer.theIFM.getDefaultProperties(), 0);
        Dumpviewer.addIFrameToDesktop((JInternalFrame)object, 430, 450, 5, Dumpviewer.selfRef.getHeight() - 530);
        ltTree = new JTree(defaultMutableTreeNode);
        ltTree.getSelectionModel().setSelectionMode(1);
        vector = null;
        ltTree.setFont(new Font("Monospaced", 0, 12));
        serializable = new DefaultTreeCellRenderer();
        ((DefaultTreeCellRenderer)serializable).setLeafIcon((Icon)((Object)vector));
        ((DefaultTreeCellRenderer)serializable).setClosedIcon((Icon)((Object)vector));
        ((DefaultTreeCellRenderer)serializable).setOpenIcon((Icon)((Object)vector));
        ltTree.setCellRenderer((TreeCellRenderer)((Object)serializable));
        Dumpviewer.theIFM.addContentToFrame((JInternalFrame)object, ltTree);
        DvUtils.writetoTrace(" displayLockedThreads exit");
    }

    public static void displayLockSummary(String string) {
        DvUtils.writetoTrace(" displayLockSummary entry: " + string);
        Vector vector = new Vector();
        DvObjectsCommands.that.cpr = new CommandPluginResponse(vector);
        that.displayLockSummary();
        String string2 = DvUtils.convertResponse(vector, true);
        JInternalFrame jInternalFrame = Dumpviewer.theIFM.createNewFrame(string, Dumpviewer.theIFM.getDefaultProperties(), 0);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 430, 450, 5, Dumpviewer.selfRef.getHeight() - 530);
        JTextArea jTextArea = new JTextArea(string2, 8, 25);
        jTextArea.setEditable(false);
        Dumpviewer.theIFM.addContentToFrame(jInternalFrame, jTextArea);
        DvUtils.writetoTrace(" displayLockSummary exit");
    }

    public static void displayDeadLocks(String string) {
        DvUtils.writetoTrace(" displayDeadLocks entry");
        Vector vector = new Vector();
        DvObjectsCommands.that.cpr = new CommandPluginResponse(vector);
        that.findDeadlockVerbose();
        String string2 = DvUtils.convertResponse(vector, true);
        JInternalFrame jInternalFrame = Dumpviewer.theIFM.createNewFrame(string, Dumpviewer.theIFM.getDefaultProperties(), 0);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 430, 450, 5, Dumpviewer.selfRef.getHeight() - 530);
        JTextArea jTextArea = new JTextArea(string2, 8, 25);
        jTextArea.setEditable(false);
        Dumpviewer.theIFM.addContentToFrame(jInternalFrame, jTextArea);
        DvUtils.writetoTrace(" displayDeadLocks exit");
    }

    public String r(String string, int n) {
        String string2 = "                                       ";
        return n > string.length() ? string2.substring(0, n - string.length()) + string : string;
    }

    public static void osRightClick(JInternalFrame jInternalFrame, MouseEvent mouseEvent) {
        int n;
        int n2;
        int n3;
        DvUtils.writetoTrace("DVObjectsCommands:osRightClick entry");
        Object object = mouseEvent.getSource();
        if (object instanceof JTree && -1 != (n3 = ((JTree)object).getClosestRowForLocation(n2 = mouseEvent.getX(), n = mouseEvent.getY()))) {
            ((JTree)object).setSelectionRow(n3);
            Object object2 = ((JTree)object).getLastSelectedPathComponent();
            String string = object2.toString();
            int n4 = string.indexOf("  : ");
            if (-1 != n4) {
                string = string.substring(0, n4);
            }
            Vector vector = new Vector();
            DvClassCommands.that.getClasses(vector);
            Integer n5 = (Integer)DvClassCommands.classHashByName.get(string.toUpperCase());
            if (null != n5 || -1 != string.indexOf("array ")) {
                DvUtils.writetoTrace("   ... popup menu displayed");
                if (null == disObjects) {
                    disObjects = new JMenuItem("Display objects for ");
                    disObjects.addActionListener(that);
                }
                if (null == disClass && -1 == string.indexOf("array ")) {
                    disClass = new JMenuItem("Display class details for ");
                    disClass.addActionListener(that);
                }
                disObjects.setText("Display objects for " + string);
                if (-1 == string.indexOf("array ")) {
                    disClass.setText("Display class details for " + string);
                }
                JPopupMenu jPopupMenu = new JPopupMenu(string);
                jPopupMenu.add(disObjects);
                if (-1 == string.indexOf("array ")) {
                    jPopupMenu.add(disClass);
                }
                jPopupMenu.setVisible(true);
                jPopupMenu.show((JTree)object, mouseEvent.getX(), mouseEvent.getY() + 10);
            }
        }
        DvUtils.writetoTrace("DVObjectsCommands:osRightClick exit");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getSource() == disObjects) {
            DvUtils.writetoTrace("   ....Display objects selected from popup ");
            string = disObjects.getText();
            int n = string.indexOf(" for ");
            if (-1 != n) {
                string = string.substring(n + 5);
                new DvClassObjects(string);
            }
        }
        if (actionEvent.getSource() == disClass) {
            DvUtils.writetoTrace("   ....Display class details selected from popup ");
            string = disClass.getText();
            JInternalFrame jInternalFrame = Dumpviewer.theIFM.createNewFrame(string + " details", Dumpviewer.theIFM.getDefaultProperties(), 6);
            Dumpviewer.addIFrameToDesktop(jInternalFrame, 400, 420, 250, 150);
            int n = string.indexOf(" for ");
            if (-1 != n) {
                DvClassCommands.that.paramString = string = string.substring(n + 5);
                if (null != DvClassCommands.that.enhancers) {
                    DvClassCommands.that.enhancers.clear();
                }
                Vector vector = new Vector();
                DvClassCommands.that.displayClasses(vector);
                String string2 = DvUtils.convertResponse(vector, true);
                new DvClassDetailsDisplay(jInternalFrame, Dumpviewer.dvConsole, string, DvClassCommands.that, string2);
            }
        }
    }

    public static String getObjectDetailsAsString(long l) {
        String string = null;
        Vector vector = new Vector();
        ObjectDetails objectDetails = DvObjectsCommands.getObjectDetails(l);
        string = objectDetails.toString();
        string = string + DvClassCommands.getInstanceValues(objectDetails.address, objectDetails.objectName, DvConsole.theDump, vector);
        return string;
    }

    public static long getObjectLength(long l) {
        long l2 = 0L;
        try {
            if (is64bit) {
                l2 = as.readLong(as.createAddress(l));
                l2 &= 0x3FFFFFFFFFFFFFF8L;
            } else {
                l2 = as.readInt(as.createAddress(l));
                l2 &= 0x3FFFFFF8L;
            }
        }
        catch (DvAddressException dvAddressException) {
            // empty catch block
        }
        return l2;
    }

    static {
        thisName = "com.ibm.jvm.dump.plugins.DvObjectsCommands";
        theOutput = new Vector();
        heapsTraversed = false;
        unknownSystem = false;
        disObjects = null;
        disClass = null;
        objTree = null;
        allocBitsAddress = 0L;
        allocBitsTestBytes = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        verboseTLH = false;
        address_index_built = false;
        names_index_built = false;
        monitorsProcessed = false;
        ltTree = null;
        lockedThreadsJif = null;
        extendedAllocBits = null;
        lockedAllocBits = null;
        startOfMHeap = 0L;
        endOfMHeap = 0L;
        startOfTransHeap = 0L;
        endOfTransHeap = 0L;
        systemHeapHashByAddr = new HashSet();
        acsHeapHashByAddr = new HashSet();
        lockedObjects = new Vector();
        inflMonList = new Vector();
        regMonList = new Vector();
        threadList = new Vector();
        deadlocks = new Vector();
        commandsSupported = new String[]{"DISPLAY,DIS,OBJECT,obj,displayObjects,Y,Y", "DISPLAY,DIS,OBJECTSUMMARY,os,displayObjectSummary,Y,N", "DISPLAY,DIS,LOCK,loc,displayLocks,Y,Y", "DISPLAY,DIS,LOCKSUMMARY,ls,displayLockSummary,Y,Y", "DISPLAY,DIS,LOCKEDOBJECTS,lo,displayLockedObjects,Y,Y", "DISPLAY,DIS,THREADLOCKS,lt,displayThreads,Y,Y", "DISPLAY,DIS,LOCKEDREGISTERS,lr,displayLockedReg,Y,Y", "DEADLOCK,DL,VERBOSE,v,findDeadlockVerbose,Y,Y", "DEADLOCK,DL,*,*,findDeadlock,Y,Y"};
    }

    private static class ObjectDetails {
        protected long address = 0L;
        protected long methods = 0L;
        protected long locknflags = 0L;
        protected long obj = 0L;
        protected String objectName = null;
        protected String className = null;
        protected String heapName = null;
        protected String type = null;
        protected boolean lock = false;
        protected long shapeBit = 0L;
        protected long entryCount = 0L;
        protected long threadId = 0L;
        protected long monitorIndex = 0L;
        protected long inflMon = 0L;
        protected boolean lkSharedClassLockFlags = false;
        protected long length = 0L;

        public ObjectDetails(long l, String string) {
            DvUtils.writetoTrace("DvObjectsCommands.ObjectDetails(long,String)");
            this.address = l;
            this.objectName = string;
        }

        public ObjectDetails() {
        }

        public String toString() {
            String string = "\n @ 0x" + Long.toHexString(this.address) + " (" + this.objectName + ") ";
            if (null != this.className) {
                string = string + this.className;
            }
            string = string + "  (heap: " + this.heapName + ")";
            if (this.lock) {
                string = string + "   (LOCKED)";
            }
            if (this.lkSharedClassLockFlags) {
                string = string + "   (LK_SHAREDCLASSLOCKFLAGS)";
            }
            return string;
        }
    }

    private static class ThreadDetails {
        private long thread_ident = 0L;
        private String thread_name = null;
        private long execenv = 0L;
        private long sys_thr = 0L;
        private String thread_ID = null;
        private long monEnterAddr = 0L;
        private long monWaitAddr = 0L;
        private Vector monitorsOwned = new Vector();
        private ThreadDetails blockingThread = null;
        private boolean processed = false;
        private int deadlocked = 0;

        public ThreadDetails(long l, String string, long l2, long l3, String string2) {
            this.thread_ident = l;
            this.thread_name = string;
            this.execenv = l2;
            this.sys_thr = l3;
            this.thread_ID = string2;
            switch (DvConsole.theDump.getSystemType()) {
                case 1: {
                    if (l3 == 0L) break;
                    this.monEnterAddr = DvObjectsCommands.getControlBlockField("sys_thread", "enter_monitor", l3, as);
                    break;
                }
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    if (l3 == 0L) break;
                    this.monEnterAddr = DvObjectsCommands.getControlBlockField("sys_thread", "mon_enter", l3, as);
                    break;
                }
            }
        }

        public ThreadDetails(long l, String string) {
            this(0L, string, 0L, l, null);
        }

        public long getThreadIdent() {
            return this.thread_ident;
        }

        public String getThreadName() {
            return this.thread_name;
        }

        public long getEE() {
            return this.execenv;
        }

        public long getSysThr() {
            return this.sys_thr;
        }

        public long getEnterMon() {
            return this.monEnterAddr;
        }

        public long getWaitMon() {
            return this.monWaitAddr;
        }

        public void addWaitMon(long l) {
            this.monWaitAddr = l;
        }

        public String getThreadID() {
            ThreadDetails threadDetails;
            if (null == this.thread_ID && 0L != this.sys_thr && (threadDetails = (ThreadDetails)threadsBySysthr.get(Long.toHexString(this.sys_thr))) != null) {
                this.thread_ID = threadDetails.getThreadID();
                DvUtils.writetoTrace("Exit:1 DvObjectsCommands.ThreadDetails.getThreadID()");
                return this.thread_ID;
            }
            return this.thread_ID;
        }

        public void addBlockingThread(ThreadDetails threadDetails) {
            DvUtils.writetoTrace("DvObjectsCommands.ThreadDetails.addBlockingThread()");
            this.blockingThread = threadDetails;
        }

        public ThreadDetails getBlockingThread() {
            DvUtils.writetoTrace("DvObjectsCommands.ThreadDetails.getBlockingThread()");
            return this.blockingThread;
        }

        public void incDeadlocked() {
            DvUtils.writetoTrace("DvObjectsCommands.ThreadDetails.incDeadlocked()");
            ++this.deadlocked;
        }

        public void decDeadlocked() {
            DvUtils.writetoTrace("DvObjectsCommands.ThreadDetails.decDeadlocked()");
            --this.deadlocked;
        }

        public int getDeadlocked() {
            DvUtils.writetoTrace("DvObjectsCommands.ThreadDetails.getDeadlocked()");
            return this.deadlocked;
        }

        public String toString() {
            return "thread name " + this.thread_name + " execenv " + Long.toHexString(this.execenv);
        }
    }

    private static class MonDetails {
        private long monAddr = 0L;
        private long sysMon = 0L;
        private long ownerAddr = 0L;
        private long waitQ1 = 0L;
        private long waitQ2 = 0L;
        private String ownerThreadID = null;
        private String ownerName = null;
        private Vector waiterAddr = new Vector();
        private Vector waiterThreadID = new Vector();
        private Vector waiterName = new Vector();
        private Vector enterAddr = new Vector();
        private Vector enterThreadID = new Vector();
        private Vector enterName = new Vector();
        private long objectAddr = 0L;
        private String nameTag = null;

        public MonDetails(long l, boolean bl) {
            DvUtils.writetoTrace("DvObjectsCommands.MonDetails(long " + l + ")");
            long l2 = 0L;
            DvObjectsCommands.initPtrLength();
            if (0 == threadList.size()) {
                DvObjectsCommands.processThreads();
            }
            this.monAddr = l;
            if (bl) {
                this.sysMon = DvObjectsCommands.getControlBlockField("infl_mon", "_sysmon", l, as);
                this.objectAddr = DvObjectsCommands.getControlBlockField("infl_mon", "object", l, as);
                if (DvObjectsCommands.checkForKnownObject(this.objectAddr - (long)ptrLength)) {
                    this.nameTag = DvObjectsCommands.processObjectName(this.objectAddr, as);
                } else {
                    DvUtils.writetoTrace("Exit:2 DvObjectsCommands.MonDetails() unknown object at: 0x" + Long.toHexString(this.objectAddr - (long)ptrLength));
                }
            } else {
                this.sysMon = DvObjectsCommands.getControlBlockField("reg_mon", "mid", l, as);
                l2 = DvObjectsCommands.getControlBlockField("reg_mon", "name", l, as);
                try {
                    this.nameTag = DvUtils.getStringFromBytes(as.readBytes(as.createAddress(l2), 256L));
                }
                catch (DvAddressException dvAddressException) {
                    DvUtils.writetoTrace("Exit:2 DvObjectsCommands.MonDetails DvAddressException nameTag");
                }
            }
            monitorsByAddr.put(Long.toHexString(l), this);
            if (this.sysMon == 0L) {
                return;
            }
            int n = DvConsole.theDump.getSystemType();
            switch (DvConsole.theDump.getSystemType()) {
                case -1: {
                    if (unknownSystem) break;
                    unknownSystem = true;
                    DvUtils.writetoTrace("Continue:5 DvObjectsCommands.processInflatedMonitors  Error SYSTEM IS UNKNOWN (" + n + ")");
                    break;
                }
                case 1: {
                    this.ownerAddr = DvObjectsCommands.getControlBlockField("sys_mon", "monitor_owner", this.sysMon, as);
                    this.waitQ1 = DvObjectsCommands.getControlBlockField("sys_mon", "monitor_waiter", this.sysMon, as);
                    break;
                }
                case 4: {
                    this.ownerAddr = DvObjectsCommands.getControlBlockField("sys_mon", "monitor_owner", this.sysMon, as);
                    this.waitQ1 = DvObjectsCommands.getControlBlockField("sys_mon", "enter_waitq", "queue", this.sysMon, as);
                    this.waitQ2 = DvObjectsCommands.getControlBlockField("sys_mon", "sleep_waitq", "queue", this.sysMon, as);
                    break;
                }
                case 2: 
                case 3: {
                    this.ownerAddr = DvObjectsCommands.getControlBlockField("sys_mon", "monitor_owner", this.sysMon, as);
                    this.waitQ1 = DvObjectsCommands.getControlBlockField("sys_mon", "mwait_queue", "head", this.sysMon, as);
                    break;
                }
                default: {
                    if (unknownSystem) break;
                    unknownSystem = true;
                    DvUtils.writetoTrace("Continue:6 DvObjectsCommands.processInflatedMonitors Error SYSTEM IS UNKNOWN (" + n + ")");
                }
            }
            if (this.ownerAddr != 0L) {
                int n2 = 0;
                while (n2 < threadList.size()) {
                    ThreadDetails threadDetails = (ThreadDetails)threadList.elementAt(n2);
                    if (this.ownerAddr == threadDetails.getSysThr()) {
                        this.ownerName = threadDetails.getThreadName();
                        this.ownerThreadID = threadDetails.getThreadID();
                    }
                    if (threadDetails.getEnterMon() == this.sysMon) {
                        this.addEnter(threadDetails.getSysThr());
                    }
                    ++n2;
                }
            }
            monitorsBySysmon.put(Long.toHexString(this.sysMon), this);
        }

        public boolean isOwnedOrWaitedOn() {
            return (this.ownerAddr | this.waitQ1 | this.waitQ2) != 0L;
        }

        public long getAddress() {
            return this.monAddr;
        }

        public void addName(String string) {
            this.nameTag = string;
        }

        public String getName() {
            return this.nameTag;
        }

        public void addSysMon(long l) {
            this.sysMon = l;
        }

        public long getSysMon() {
            return this.sysMon;
        }

        public long getWaitQ(int n) {
            return n == 0 ? this.waitQ1 : this.waitQ2;
        }

        public long getNextWaitQ(long l) {
            switch (DvConsole.theDump.getSystemType()) {
                case 1: {
                    return DvObjectsCommands.getControlBlockField("sys_thread", "next_waiter", l, as);
                }
                case 4: {
                    return DvObjectsCommands.getControlBlockField("condq", "Next", l, as);
                }
                case 2: 
                case 3: {
                    return DvObjectsCommands.getControlBlockField("monitor_waiter", "next", l, as);
                }
            }
            return 0L;
        }

        public long getWaitQThread(long l) {
            switch (DvConsole.theDump.getSystemType()) {
                case 1: {
                    return l;
                }
                case 4: {
                    return DvObjectsCommands.getControlBlockField("condq", "thread", l, as);
                }
                case 2: 
                case 3: {
                    return DvObjectsCommands.getControlBlockField("monitor_waiter", "waiting_thread", l, as);
                }
            }
            return 0L;
        }

        public void addObject(long l, String string) {
            this.objectAddr = l;
            this.nameTag = string;
        }

        public long getObjectAddress() {
            return this.objectAddr;
        }

        public String getObjectName() {
            return this.nameTag;
        }

        public void addOwner(String string, String string2) {
            this.ownerName = string;
            this.ownerThreadID = string2;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public String getOwnerThreadID() {
            if (null == this.ownerThreadID) {
                return "";
            }
            return this.ownerThreadID;
        }

        public long getOwnerAddress() {
            return this.ownerAddr;
        }

        public void addWaiter(long l) {
            ThreadDetails threadDetails = (ThreadDetails)threadsBySysthr.get(Long.toHexString(l));
            if (threadDetails != null) {
                this.waiterAddr.add(new Long(l));
                this.waiterName.add(threadDetails.getThreadName());
                this.waiterThreadID.add(threadDetails.getThreadID());
            }
        }

        public long getWaiterAddress(int n) {
            if (n >= this.waiterAddr.size()) {
                return 0L;
            }
            return (Long)this.waiterAddr.elementAt(n);
        }

        public String getWaiterName(int n) {
            return (String)this.waiterName.elementAt(n);
        }

        public String getWaiterThreadID(int n) {
            if (null == this.waiterThreadID.elementAt(n)) {
                return "";
            }
            return (String)this.waiterThreadID.elementAt(n);
        }

        public long getWaiterSize() {
            return this.waiterAddr.size();
        }

        public void addEnter(long l) {
            ThreadDetails threadDetails = (ThreadDetails)threadsBySysthr.get(Long.toHexString(l));
            if (threadDetails != null) {
                this.enterAddr.add(new Long(l));
                this.enterName.add(threadDetails.getThreadName());
                this.enterThreadID.add(threadDetails.getThreadID());
            }
        }

        public long getEnterAddress(int n) {
            if (n >= this.enterAddr.size()) {
                return 0L;
            }
            return (Long)this.enterAddr.elementAt(n);
        }

        public String getEnterName(int n) {
            return (String)this.enterName.elementAt(n);
        }

        public String getEnterThreadID(int n) {
            if (null == this.enterThreadID.elementAt(n)) {
                return "";
            }
            return (String)this.enterThreadID.elementAt(n);
        }

        public long getEnterSize() {
            return this.enterAddr.size();
        }

        public String toString() {
            return "inflMonAddr " + Long.toHexString(this.monAddr) + "\nsysMon " + Long.toHexString(this.sysMon) + "\nwaitQ1 " + Long.toHexString(this.waitQ1) + "\nwaitQ2 " + Long.toHexString(this.waitQ2) + "\nownerAddr " + Long.toHexString(this.ownerAddr) + "\nownerName " + this.ownerName + "\nwaiterAddr " + this.waiterAddr + "\nwaiterName " + this.waiterName + "\nobjectAddress " + Long.toHexString(this.objectAddr) + "\nobjectName " + this.nameTag + "\n\n";
        }
    }

    private static class Range {
        protected long start;
        protected long end;
        protected long index;

        protected Range(long l, long l2, long l3) {
            this.start = l;
            this.end = l2;
            this.index = l3;
        }
    }
}

