/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Jvm;
import com.ibm.jvm.svcdump.Tcb;
import java.util.StringTokenizer;
import java.util.Vector;

public class DvSvcdumpCommands
extends CommandPlugin {
    private static String thisName = "com.ibm.jvm.dump.plugins.DvSvcdumpCommands";
    private static Vector theOutput = new Vector();
    private static boolean is64bit;
    private static boolean isBigEndian;
    private static String[] commandsSupported;
    private static DvAddressSpace as;

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public String pluginName() {
        return "SVCDUMP commands Plugin";
    }

    public void reset() {
        DvUtils.writetoTrace("Entry:DvSvcdumpCommands.reset");
        this.cpr.output(theOutput);
        theOutput.clear();
        DvUtils.writetoTrace("Exit:1 DvSvcdumpCommands.reset");
    }

    public static Object getGenericHelp() {
        DvUtils.writetoTrace("Entry:DvSvcdumpCommands.getGenericHelp");
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvSvcdumpCommands.properties");
        DvUtils.writetoTrace("Exit:1 DvSvcdumpCommands.getGenericHelp");
        return vector;
    }

    private boolean checkSvcdump(DvDump dvDump) {
        try {
            ((Dump)dvDump).isSvcdump();
        }
        catch (Exception exception) {
            theOutput.add("This is not a svcdump.  The commands in the DvSvcdumpCommands plugin can't be used");
            return false;
        }
        return true;
    }

    private static void responseFooter() {
        theOutput.add("");
        theOutput.add("");
        theOutput.add("Some of the svcdump commands produce lots of output");
        theOutput.add("Hence it is recommended to redirect the output");
        theOutput.add("Hint: can use \"SET OUTPUT=x\" to redirect theoutput to file name x");
    }

    public void doStuff() {
        DvUtils.writetoTrace("Entry:DvSvcdumpCommands.doStuff");
        DvDump dvDump = DvConsole.theDump;
        if (!this.checkSvcdump(dvDump)) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvSvcdumpCommands.doStuff");
            return;
        }
        this.setUpOutput(dvDump);
        ((Dump)dvDump).doStuff();
        DvSvcdumpCommands.responseFooter();
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvSvcdumpCommands.doStuff");
    }

    public void disassemble() {
        Object object;
        DvUtils.writetoTrace("Entry:DvSvcdumpCommands.disassemble");
        Vector vector = new Vector();
        if (null != this.paramString) {
            object = new StringTokenizer(this.paramString, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken().trim();
                vector.add(string);
            }
        }
        if (2 != vector.size()) {
            theOutput.add("This commands is expecting two parameters");
            theOutput.add("");
            theOutput.add("\"svc dis(addr,n)\"");
            theOutput.add("disassemble <n> instructions starting at <addr> (hex)");
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvSvcdumpCommands.disassemble Needs two arguments");
            return;
        }
        object = DvConsole.theDump;
        if (!this.checkSvcdump((DvDump)object)) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:2 DvSvcdumpCommands.disassemble");
            return;
        }
        this.setUpOutput((DvDump)object);
        Dump.setDisassemble(true);
        try {
            int n = ((String)vector.elementAt(0)).charAt(0) == '0' && (((String)vector.elementAt(0)).charAt(1) == 'x' || ((String)vector.elementAt(0)).charAt(1) == 'X') ? Integer.parseInt(((String)vector.elementAt(0)).substring(2), 16) : Integer.parseInt((String)vector.elementAt(0), 16);
            Dump.setDisassembleAddress(n);
            Dump.setDisassembleLength(Integer.parseInt((String)vector.elementAt(1)));
            ((Dump)object).disassemble();
        }
        catch (Exception exception) {
            DvUtils.writetoTrace("Exception: DvSvcdumpCommands.disassemble");
            exception.printStackTrace();
        }
        Dump.setDisassemble(false);
        DvSvcdumpCommands.responseFooter();
        this.returnControl();
        DvUtils.writetoTrace("Exit:3 DvSvcdumpCommands.disassemble");
    }

    public void dumpstorage() {
        Object object;
        DvUtils.writetoTrace("Entry:DvSvcdumpCommands.dumpstorage");
        Vector vector = new Vector();
        theOutput.add("");
        theOutput.add("\"dis mem(addr,n)\" is a standard jformat command that does the same thing");
        theOutput.add("");
        this.cpr.output(theOutput);
        theOutput.clear();
        if (null != this.paramString) {
            object = new StringTokenizer(this.paramString, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken().trim();
                vector.add(string);
            }
        }
        if (2 != vector.size()) {
            theOutput.add("This commands is expecting two parameters");
            theOutput.add("");
            theOutput.add("\"svc sto(addr,n)\"");
            theOutput.add("dump <n> words of storage starting at <addr> (hex)");
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvSvcdumpCommands.dumpstorage Needs two arguments");
            return;
        }
        object = DvConsole.theDump;
        if (!this.checkSvcdump((DvDump)object)) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:2 DvSvcdumpCommands.dumpstorage");
            return;
        }
        this.setUpOutput((DvDump)object);
        Dump.setDumpstorage(true);
        try {
            int n = ((String)vector.elementAt(0)).charAt(0) == '0' && (((String)vector.elementAt(0)).charAt(1) == 'x' || ((String)vector.elementAt(0)).charAt(1) == 'X') ? Integer.parseInt(((String)vector.elementAt(0)).substring(2), 16) : Integer.parseInt((String)vector.elementAt(0), 16);
            Dump.setDumpstorageAddress(n);
            Dump.setDumpstorageLength(Integer.parseInt((String)vector.elementAt(1)));
            ((Dump)object).dumpstorage();
        }
        catch (Exception exception) {
            DvUtils.writetoTrace("Exception: DvSvcdumpCommands.dumpstorage");
            exception.printStackTrace();
        }
        Dump.setDumpstorage(false);
        DvSvcdumpCommands.responseFooter();
        this.returnControl();
        DvUtils.writetoTrace("Exit:3 DvSvcdumpCommands.dumpstorage");
    }

    public void dumpnative() {
        DvUtils.writetoTrace("Entry:DvSvcdumpCommands.dumpnative");
        DvDump dvDump = DvConsole.theDump;
        if (!this.checkSvcdump(dvDump)) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvSvcdumpCommands.dumpnative");
            return;
        }
        try {
            this.setUpOutput(dvDump);
            ((Dump)dvDump).dumpnative();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DvSvcdumpCommands.responseFooter();
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvSvcdumpCommands.dumpnative");
    }

    public void dumpclasses() {
        DvUtils.writetoTrace("Entry:DvSvcdumpCommands.dumpclasses");
        DvDump dvDump = DvConsole.theDump;
        if (!this.checkSvcdump(dvDump)) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvSvcdumpCommands.dumpclasses");
            return;
        }
        this.setUpOutput(dvDump);
        Dump.setDumpclasses(true);
        try {
            ((Dump)dvDump).dumpclasses();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Dump.setDumpclasses(false);
        DvSvcdumpCommands.responseFooter();
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvSvcdumpCommands.dumpclasses");
    }

    public void dumpclass() {
        Object object;
        DvUtils.writetoTrace("Entry:DvSvcdumpCommands.dumpclass");
        Vector vector = new Vector();
        if (null != this.paramString) {
            object = new StringTokenizer(this.paramString, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken().trim();
                vector.add(string);
            }
        }
        if (1 != vector.size()) {
            theOutput.add("This commands is expecting a parameter");
            theOutput.add("");
            theOutput.add("\"svc class(addr)\"");
            theOutput.add("dump the class at <addr>");
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvSvcdumpCommands.dumpstorage Needs two arguments");
            return;
        }
        object = DvConsole.theDump;
        if (!this.checkSvcdump((DvDump)object)) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:2 DvSvcdumpCommands.dumpstorage");
            return;
        }
        this.setUpOutput((DvDump)object);
        try {
            int n = ((String)vector.elementAt(0)).charAt(0) == '0' && (((String)vector.elementAt(0)).charAt(1) == 'x' || ((String)vector.elementAt(0)).charAt(1) == 'X') ? Integer.parseInt(((String)vector.elementAt(0)).substring(2), 16) : Integer.parseInt((String)vector.elementAt(0), 16);
            Dump.setDumpclass(n);
            ((Dump)object).dumpclass(n);
        }
        catch (Exception exception) {
            DvUtils.writetoTrace("Exception: DvSvcdumpCommands.dumpclass");
            exception.printStackTrace();
        }
        DvSvcdumpCommands.responseFooter();
        this.returnControl();
        DvUtils.writetoTrace("Exit:3 DvSvcdumpCommands.dumpclass");
    }

    public void dumpproperties() {
        DvUtils.writetoTrace("Entry:DvSvcdumpCommands.dumpproperties");
        DvDump dvDump = DvConsole.theDump;
        if (!this.checkSvcdump(dvDump)) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:2 DvSvcdumpCommands.dumpproperties");
            return;
        }
        try {
            this.setUpOutput(dvDump);
            ((Dump)dvDump).dumpproperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DvSvcdumpCommands.responseFooter();
        this.returnControl();
        DvUtils.writetoTrace("Exit:3 DvSvcdumpCommands.dumpproperties");
    }

    public void dumpmdata() {
        Object object;
        DvUtils.writetoTrace("Entry:DvSvcdumpCommands.dumpmdata");
        Vector vector = new Vector();
        if (null != this.paramString) {
            object = new StringTokenizer(this.paramString, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken().trim();
                vector.add(string);
            }
        }
        if (1 != vector.size()) {
            theOutput.add("This commands is expecting a parameter");
            theOutput.add("");
            theOutput.add("\"svc mdata(addr)\"");
            theOutput.add("");
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvSvcdumpCommands.dumpmdata Needs one argument");
            return;
        }
        object = DvConsole.theDump;
        if (!this.checkSvcdump((DvDump)object)) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:2 DvSvcdumpCommands.dumpmdata");
            return;
        }
        this.setUpOutput((DvDump)object);
        Dump.setDumpmdata(true);
        try {
            int n = ((String)vector.elementAt(0)).charAt(0) == '0' && (((String)vector.elementAt(0)).charAt(1) == 'x' || ((String)vector.elementAt(0)).charAt(1) == 'X') ? Integer.parseInt(((String)vector.elementAt(0)).substring(2), 16) : Integer.parseInt((String)vector.elementAt(0), 16);
            ((Dump)object).dumpmdata(n);
        }
        catch (Exception exception) {
            DvUtils.writetoTrace("Exception: DvSvcdumpCommands.dumpmdata");
            exception.printStackTrace();
        }
        Dump.setDumpmdata(false);
        DvSvcdumpCommands.responseFooter();
        this.returnControl();
        DvUtils.writetoTrace("Exit:3 DvSvcdumpCommands.dumpmdata");
    }

    public void systrace() {
        DvUtils.writetoTrace("Entry:DvSvcdumpCommands.systrace");
        DvDump dvDump = DvConsole.theDump;
        if (!this.checkSvcdump(dvDump)) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvSvcdumpCommands.systrace");
            return;
        }
        this.setUpOutput(dvDump);
        Dump.setSystrace(true);
        try {
            ((Dump)dvDump).systrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Dump.setSystrace(false);
        DvSvcdumpCommands.responseFooter();
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvSvcdumpCommands.systrace");
    }

    public void cache() {
        DvUtils.writetoTrace("Entry:DvSvcdumpCommands.cache");
        DvDump dvDump = DvConsole.theDump;
        if (!this.checkSvcdump(dvDump)) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvSvcdumpCommands.cache");
            return;
        }
        this.setUpOutput(dvDump);
        try {
            AddressSpace[] addressSpaceArray = ((Dump)dvDump).getSpaces();
            int n = 0;
            while (n < addressSpaceArray.length) {
                AddressSpace addressSpace = addressSpaceArray[n];
                DvUtils.writetoTrace("processing asid " + addressSpace.hexId());
                Tcb[] tcbArray = addressSpace.tcbs();
                if (tcbArray != null && tcbArray.length != 0) {
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < tcbArray.length) {
                        Tcb tcb = tcbArray[n2];
                        if (tcb.isKnownType()) {
                            if (tcb.tid() != 0) {
                                tcb.printAllocCache();
                            }
                            theOutput.add("");
                        } else {
                            theOutput.add("TCB of unknown type " + tcb.hexId() + " caa " + Dump.hex(tcb.caa()));
                            bl = true;
                        }
                        ++n2;
                    }
                    theOutput.add("");
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DvSvcdumpCommands.responseFooter();
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvSvcdumpCommands.cache");
    }

    public void exception() {
        DvUtils.writetoTrace("Entry:DvSvcdumpCommands.exception");
        DvDump dvDump = DvConsole.theDump;
        if (!this.checkSvcdump(dvDump)) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvSvcdumpCommands.exception");
            return;
        }
        this.setUpOutput(dvDump);
        try {
            AddressSpace[] addressSpaceArray = ((Dump)dvDump).getSpaces();
            int n = 0;
            while (n < addressSpaceArray.length) {
                AddressSpace addressSpace = addressSpaceArray[n];
                DvUtils.writetoTrace("processing asid " + addressSpace.hexId());
                Tcb[] tcbArray = addressSpace.tcbs();
                if (tcbArray != null && tcbArray.length != 0) {
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < tcbArray.length) {
                        Tcb tcb = tcbArray[n2];
                        if (tcb.isKnownType()) {
                            tcb.printException();
                            theOutput.add("");
                        } else {
                            theOutput.add("TCB of unknown type " + tcb.hexId() + " caa " + Dump.hex(tcb.caa()));
                            bl = true;
                        }
                        ++n2;
                    }
                    theOutput.add("");
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DvSvcdumpCommands.responseFooter();
        this.returnControl();
        DvUtils.writetoTrace("Exit:2 DvSvcdumpCommands.exception");
    }

    public void heap() {
        DvUtils.writetoTrace("Entry:DvSvcdumpCommands.heap");
        DvDump dvDump = DvConsole.theDump;
        if (!this.checkSvcdump(dvDump)) {
            this.returnControl();
            DvUtils.writetoTrace("Exit:1 DvSvcdumpCommands.heap");
            return;
        }
        this.setUpOutput(dvDump);
        AddressSpace[] addressSpaceArray = ((Dump)dvDump).getSpaces();
        int n = 0;
        while (n < addressSpaceArray.length) {
            AddressSpace addressSpace = addressSpaceArray[n];
            DvUtils.writetoTrace("processing asid " + addressSpace.hexId());
            Tcb[] tcbArray = addressSpace.tcbs();
            if (tcbArray != null && tcbArray.length != 0) {
                theOutput.add("found " + tcbArray.length + " TCBs in asid 0x" + addressSpace.hexId());
                theOutput.add("");
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                try {
                    Dump.setAnalyzeHeap(true);
                    Jvm[] jvmArray = addressSpace.jvms();
                    if (jvmArray != null) {
                        int n2 = 0;
                        while (n2 < jvmArray.length) {
                            Jvm jvm = jvmArray[n2];
                            try {
                                jvm.analyzeHeap();
                            }
                            catch (Exception exception) {
                                theOutput.add("bad heap in asid " + addressSpace.hexId());
                                exception.printStackTrace();
                            }
                            ++n2;
                        }
                    }
                    Dump.setAnalyzeHeap(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DvSvcdumpCommands.responseFooter();
                this.returnControl();
                DvUtils.writetoTrace("Exit:2 DvSvcdumpCommands.heap");
            }
            ++n;
        }
    }

    public void stacks() {
        Object object;
        block7: {
            DvUtils.writetoTrace("Entry:DvSvcdumpCommands.stacks");
            Vector vector = new Vector();
            if (null != this.paramString) {
                object = new StringTokenizer(this.paramString, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string = ((StringTokenizer)object).nextToken().trim();
                    vector.add(string);
                }
            }
            if (!this.checkSvcdump((DvDump)(object = DvConsole.theDump))) {
                this.returnControl();
                DvUtils.writetoTrace("Exit:1 DvSvcdumpCommands.stacks");
                return;
            }
            this.setUpOutput((DvDump)object);
            try {
                if (0 == vector.size()) {
                    Dump.setReg(-1);
                    theOutput.add("Hint: can use \"svc r(n)\" to show register n in stack");
                    break block7;
                }
                int n = Integer.parseInt((String)vector.elementAt(0));
                if (16 > n) {
                    Dump.setReg(n);
                    theOutput.add("Now when you look at stace trace you get register " + Integer.parseInt((String)vector.elementAt(0)) + " included");
                    break block7;
                }
                theOutput.add("\"svc r(n)\" to show register n in stack");
                theOutput.add("");
                theOutput.add("You can only look at the registers between 0 and 15 inclusive");
                this.returnControl();
                DvUtils.writetoTrace("Exit:2 DvSvcdumpCommands.stacks");
                return;
            }
            catch (Exception exception) {
                DvUtils.writetoTrace("Exception: DvSvcdumpCommands.stacks");
                exception.printStackTrace();
            }
        }
        ((Dump)object).printStacks();
        DvSvcdumpCommands.responseFooter();
        this.returnControl();
        DvUtils.writetoTrace("Exit:3 DvSvcdumpCommands.stacks");
    }

    private void setUpOutput(DvDump dvDump) {
        ((Dump)dvDump).setFromJFormat(true);
    }

    private void returnControl() {
        this.cpr.output(theOutput);
        theOutput.clear();
        this.forcedEnd = true;
    }

    static {
        commandsSupported = new String[]{"SVCDUMP,SVC,default,def,doStuff,Y,N", "SVCDUMP,SVC,disassemble,dis,disassemble,Y,N", "SVCDUMP,SVC,dump,dump,dumpstorage,Y,N", "SVCDUMP,SVC,dumpstorage,sto,dumpstorage,Y,N", "SVCDUMP,SVC,dumpnative,nat,dumpnative,Y,N", "SVCDUMP,SVC,dumpclasses,classes,dumpclasses,Y,N", "SVCDUMP,SVC,dumpclass,class,dumpclass,Y,N", "SVCDUMP,SVC,dumpproperties,prop,dumpproperties,Y,N", "SVCDUMP,SVC,dumpmdata,mdata,dumpmdata,Y,N", "SVCDUMP,SVC,systrace,sys,systrace,Y,N", "SVCDUMP,SVC,cache,cac,cache,Y,N", "SVCDUMP,SVC,exception,exc,exception,Y,N", "SVCDUMP,SVC,heap,hea,heap,Y,N", "SVCDUMP,SVC,registers,r,stacks,Y,N", "SVCDUMP,SVC,stacks,sta,stacks,Y,N"};
    }
}

