/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvMenu;
import com.ibm.jvm.dump.format.DvMenuItem;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvTraceScroller;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.TraceFormatterListener;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.CommandPluginResponse;
import com.ibm.jvm.format.TraceFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JTextArea;

public class DvTraceFmtPlugin
extends CommandPlugin {
    private boolean printLines = true;
    private static String thisName = "com.ibm.jvm.dump.plugins.DvTraceFmtPlugin";
    protected static Vector output = new Vector();
    private static boolean verbose = false;
    private static Vector summaryData = null;
    protected DvAddressSpace as = null;
    protected static String snapTraceFileName = null;
    protected static String snapTraceInfoFileName = null;
    protected static String snapTraceOutputFileName = null;
    private static int traceOutStart = 1;
    private static int traceOutPage = 25;
    public static int waitFlag = 0;
    public static String savedFileName = null;
    private static Hashtable traceRecords = null;
    private static String[] commandsSupported = new String[]{"TRACE,*,EXTRACT,*,CMD_TraceExtract", "TRACE,*,FORMAT,*,CMD_TraceFormat", "TRACE,*,DISPLAY,*,CMD_TraceDisplay", "TRACE,*,SUMMARY,*,CMD_TraceSummary", "TRACE,*,THREADS,*,CMD_TraceThreads", "TRACE,*,VERBOSE,*,CMD_TraceCMD", "TRACE,*,SYMBOLIC,*,CMD_TraceCMD", "TRACE,*,INDENT,*,CMD_TraceCMD", "TRACE,*,ENTRIES,*,CMD_TraceEntries", "TRACE,*,OUTFILENAME,*,CMD_TraceOutfilename", "TRACE,*,DATADIR,*,CMD_TraceDataDir", "TRACE,*,SET,*,CMD_TraceSet", "TRACE,*,HELP,*,CMD_TraceHelp"};
    public static DvTraceFmtPlugin selfRef;

    public DvTraceFmtPlugin() {
        selfRef = this;
    }

    public void CMD_TraceHelp() {
        this.printBanner(true, "", false);
        output.add("HELP FOR USING TRACE\n====================\n");
        output.add("These are the currently supported commands:\n");
        output.add("TRACE FORMAT              - formats the extracted trace file.");
        output.add("TRACE EXTRACT             - writes in-memory trace buffers to an \"extracted\n                            trace file\".");
        output.add("TRACE SUMMARY             - display the summary information for an extracted\n                            trace file.\n");
        output.add("TRACE DISPLAY             - display the current page of the trace output file.");
        output.add("TRACE DISPLAY ALL         - display entire trace file (warning - long!)");
        output.add("TRACE DISPLAY +           - display the next page of the trace output file.");
        output.add("TRACE DISPLAY -           - display the previous page of the trace output file.");
        output.add("TRACE DISPLAY PAGE=nn     - set the length of the page for trace display.\n");
        output.add("TRACE THREADS             - list all the threads in the dump.");
        output.add("TRACE THREADS 0xnn[,0xnn] - format infomation only for these threads.\n");
        output.add("TRACE SET                 - display all env vars affecting trace formatting.");
        output.add("TRACE SET option=value    - set one of these env vars.");
        output.add("TRACE OUTFILENAME <file>  - write the formatted trace to the selected file.");
        output.add("TRACE INDENT true|false   - sets indent mode on or off for formatting.");
        output.add("TRACE ENTRIES id[,id...]  - format infomation only for these components.");
        output.add("TRACE SYMBOLIC true|false - sets symbolic option on or off for formatting.\n                            (symbolic trace point names in trace output.)");
        output.add("TRACE DATADIR <directory> - Set TraceFormat.dat directory (ibm.dg.trc.format)");
        output.add("TRACE VERBOSE true|false  - sets verbose mode on or off (contents of buffers\n                            are displayed as they are formatted etc.)\n");
        this.outputAndFlush("TRACE HELP                - this information.");
        this.printBanner(true, "End of Trace Help", true);
        this.forcedEnd = true;
    }

    public void CMD_TraceDisplay() {
        Object var1_1 = null;
        if (this.noDumpAccessed()) {
            this.forcedEnd = true;
            return;
        }
        if (snapTraceOutputFileName == null) {
            this.printBanner(true, "", true);
            this.outputAndFlush("Unable to comply - trace must first be formatted.");
            this.printBanner(true, "finished Trace Display", true);
            this.forcedEnd = true;
            return;
        }
        if (this.paramString == null) {
            this.displayFile(snapTraceOutputFileName, traceOutStart, traceOutStart + traceOutPage - 1);
        } else if (this.paramString.length() > 5 && this.paramString.toUpperCase().substring(0, 5).equals("PAGE=")) {
            String string = new String(this.paramString.substring(5));
            Integer n = new Integer(string);
            if (n >= 5 && n <= 10001) {
                this.outputAndFlush("\nPage size set to " + n);
                traceOutPage = n;
            } else {
                this.outputAndFlush("\nERROR: Page size must be between 5 and 10000.");
            }
        } else if (this.paramString.toUpperCase().equals("ALL")) {
            this.outputAndFlush("");
            this.displayFile(snapTraceOutputFileName, 1, 1000000);
        } else if (this.paramString.substring(0, 1).equals("+")) {
            this.outputAndFlush("");
            if (!this.displayFile(snapTraceOutputFileName, traceOutStart += traceOutPage, traceOutStart + traceOutPage - 1) && (traceOutStart -= traceOutPage) < 1) {
                traceOutStart = 1;
            }
        } else if (this.paramString.substring(0, 1).equals("-")) {
            if ((traceOutStart -= traceOutPage) < 1) {
                traceOutStart = 1;
            }
            this.outputAndFlush("");
            this.displayFile(snapTraceOutputFileName, traceOutStart, traceOutStart + traceOutPage - 1);
        } else {
            this.printBanner(true, "", true);
            this.outputAndFlush("Usage Error:\n   TRACE DISPLAY [ + | - | ALL ]");
            this.printBanner(true, "", true);
        }
        this.forcedEnd = true;
    }

    public void CMD_TraceCMD() {
        this.printBanner(true, "", false);
        this.outputAndFlush("Query/Set Formatted Trace Options\n=================================\n");
        this.verbModifier = this.verbModifier.toUpperCase();
        if (this.verbModifier.equals("SYMBOLIC") || this.verbModifier.equals("VERBOSE") || this.verbModifier.equals("INDENT")) {
            this.doTraceCMD("TRACE_" + this.verbModifier.toUpperCase());
        } else {
            this.outputAndFlush("Usage error:\n   unrecognised TRACE option: " + this.verbModifier);
        }
        this.printBanner(true, "", true);
        this.forcedEnd = true;
    }

    private void doTraceCMD(String string) {
        if (this.paramString == null) {
            String string2 = null;
            string2 = this.getEnvVar(string);
            if (string2.toUpperCase().equals("NULL")) {
                string2 = "false";
            }
            this.outputAndFlush(string + " = " + string2);
        } else {
            try {
                if (this.paramString.toUpperCase().equals("TRUE")) {
                    DvUtils.setValue(string, "true");
                    this.outputAndFlush(string + " = true");
                    if (string.toUpperCase().equals("VERBOSE")) {
                        verbose = true;
                    }
                } else if (this.paramString.toUpperCase().equals("FALSE")) {
                    DvUtils.setValue(string, "false");
                    this.outputAndFlush(string + " = false");
                    if (string.toUpperCase().equals("VERBOSE")) {
                        verbose = false;
                    }
                } else {
                    this.outputAndFlush("Usage Error:\n   TRACE " + string.substring(6, string.length()) + " true|false");
                }
            }
            catch (Exception exception) {
                this.outputAndFlush("ERROR: Exception setting TRACE_" + string + " (" + exception.getMessage() + ")");
            }
        }
    }

    public void CMD_TraceSet() {
        String string;
        Object object;
        this.printBanner(true, "", false);
        output.add("OPTIONS FOR TRACE FORMATTER\n===========================\n");
        if (this.paramString != null) {
            object = new StringTokenizer(this.paramString, "=");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = null;
                String string2 = null;
                if (((StringTokenizer)object).hasMoreTokens()) {
                    string = ((StringTokenizer)object).nextToken().toUpperCase();
                }
                if (((StringTokenizer)object).hasMoreTokens()) {
                    string2 = ((StringTokenizer)object).nextToken();
                }
                if (string == null || string2 == null) {
                    this.outputAndFlush("Usage Error:\n   TRACE SET [<option>=<value>]");
                    continue;
                }
                if (string.equals("VERBOSE") || string.equals("SYMBOLIC") || string.equals("INDENT") || string.equals("ENTRIES") || string.equals("OUTFILENAME") || string.equals("THREADS") || string.equals("DATADIR")) {
                    boolean bl = this.printLines;
                    this.printLines = false;
                    this.verb = "TRACE";
                    this.verbModifier = string;
                    this.paramString = string2;
                    if (string.equals("VERBOSE")) {
                        this.CMD_TraceCMD();
                    }
                    if (string.equals("INDENT")) {
                        this.CMD_TraceCMD();
                    }
                    if (string.equals("SYMBOLIC")) {
                        this.CMD_TraceCMD();
                    }
                    if (string.equals("THREADS")) {
                        this.CMD_TraceThreads();
                    }
                    if (string.equals("ENTRIES")) {
                        this.CMD_TraceEntries();
                    }
                    if (string.equals("OUTFILENAME")) {
                        this.CMD_TraceOutfilename();
                    }
                    if (string.equals("DATADIR")) {
                        this.CMD_TraceDataDir();
                    }
                    this.printLines = bl;
                    continue;
                }
                this.outputAndFlush("Usage Error:\n   TRACE SET [<OUTFILENAME|THREADS|SYMBOLIC|INDENT|ENTRIES|VERBOSE|<DATADIR>>=<value>]");
            }
        }
        this.outputAndFlush("\nTRACE_INFILENAME  = \"extracted.trc\" (hardcoded)");
        object = this.getEnvVar("TRACE_OUTFILENAME");
        if (((String)object).toUpperCase().equals("NULL")) {
            object = "<not set - will default to \"extracted.trc.fmt\">";
        }
        this.outputAndFlush("TRACE_OUTFILENAME = " + (String)object);
        object = this.getEnvVar("TRACE_THREADS");
        if (((String)object).toUpperCase().equals("NULL")) {
            object = "<not set - will default to ALL>";
        }
        this.outputAndFlush("TRACE_THREADS     = " + (String)object);
        object = this.getEnvVar("TRACE_SYMBOLIC");
        if (((String)object).toUpperCase().equals("NULL")) {
            object = "<not set - will default to false>";
        }
        this.outputAndFlush("TRACE_SYMBOLIC    = " + (String)object);
        object = this.getEnvVar("TRACE_INDENT");
        if (((String)object).toUpperCase().equals("NULL")) {
            object = "<not set - will default to false>";
        }
        this.outputAndFlush("TRACE_INDENT      = " + (String)object);
        object = this.getEnvVar("TRACE_ENTRIES");
        if (((String)object).toUpperCase().equals("NULL")) {
            object = "<not set - will default to ALL>";
        }
        this.outputAndFlush("TRACE_ENTRIES     = " + (String)object);
        object = this.getEnvVar("TRACE_VERBOSE");
        if (((String)object).toUpperCase().equals("NULL")) {
            object = "<not set - will default to false>";
        }
        this.outputAndFlush("TRACE_VERBOSE     = " + (String)object);
        object = this.getEnvVar("TRACE_DATADIR");
        if (((String)object).toUpperCase().equals("NULL")) {
            string = System.getProperty("java.home");
            string = string.concat(File.separator).concat("lib");
            object = System.getProperty("ibm.dg.trc.format", string);
            object = "<not set - will default to:\n                    " + (String)object + ">";
        }
        this.outputAndFlush("TRACE_DATADIR     = " + (String)object);
        this.printBanner(true, "", true);
        this.forcedEnd = true;
    }

    public void CMD_TraceOutfilename() {
        this.printBanner(true, "", false);
        this.outputAndFlush("Query/Set Formatted Trace File Name\n===================================\n");
        if (this.paramString == null) {
            String string = null;
            try {
                string = DvUtils.getValue("TRACE_OUTFILENAME");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null) {
                string = "extracted.trc.fmt";
            }
            this.outputAndFlush("trace out file name = \"" + string + "\"");
        } else {
            try {
                DvUtils.setValue("TRACE_OUTFILENAME", this.paramString);
                this.outputAndFlush("TRACE_OUTFILENAME = " + this.paramString);
            }
            catch (Exception exception) {
                this.outputAndFlush("ERROR: Exception setting TRACE_OUTFILENAME (" + exception.getMessage() + ")");
            }
        }
        this.outputAndFlush("\nNOTE - Embedding %T in an outfilename, e.g.: \"TRACE OUTFILENAME thread.%T.fmt\"\n       will cause the threadid to be inserted at that point when tracing a\n       single thread.");
        this.printBanner(true, "", true);
        this.forcedEnd = true;
    }

    public void CMD_TraceEntries() {
        this.printBanner(true, "", false);
        this.outputAndFlush("Query/Set Entries Option\n========================\n");
        if (this.paramString == null) {
            String string = null;
            try {
                string = this.getEnvVar("TRACE_ENTRIES");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string.toUpperCase().equals("NULL")) {
                string = "ALL";
            }
            this.outputAndFlush("TRACE_ENTRIES = " + string);
        } else {
            boolean bl = true;
            if (!this.paramString.toUpperCase().equals("ALL")) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.paramString, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken().toLowerCase();
                    StringTokenizer stringTokenizer2 = new StringTokenizer("dg,st,lk,xe,xm,ci,cl,dc,hpi,xhpi,java,awt,awt_dnd_datatransfer,Audio,jit,jdwp,mt,fontmanager,net,awt_java2d,awt_print", ",");
                    boolean bl2 = false;
                    while (stringTokenizer2.hasMoreTokens() && !bl2) {
                        String string2 = stringTokenizer2.nextToken().toLowerCase();
                        if (!string.equals(string2)) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    this.outputAndFlush("ERROR: invalid token - " + string + "\n");
                    bl = false;
                }
            }
            if (bl) {
                DvUtils.setValue("TRACE_ENTRIES", this.paramString.toUpperCase());
                this.outputAndFlush("TRACE_ENTRIES = " + this.getEnvVar("TRACE_ENTRIES"));
            } else {
                this.outputAndFlush("Allowed options are:\n   ci  cl  dc  dg  lk  mt  net  st  xe  xm  java  jit  hpi  xhpi\n   audio  awt  awt_dnd_datatransfer  awt_java2d  awt_print  fontmanager  jdwp\n");
                this.outputAndFlush("TRACE_ENTRIES = " + this.getEnvVar("TRACE_ENTRIES") + " (unchanged)");
            }
        }
        this.printBanner(true, "", true);
        this.forcedEnd = true;
    }

    public void CMD_TraceDataDir() {
        String string;
        Object object;
        this.printBanner(true, "", false);
        this.outputAndFlush("Query/Set Data directory\n========================\n");
        if (this.paramString != null) {
            if (this.paramString.equals("NULL")) {
                DvUtils.setValue("TRACE_DATADIR", "NULL");
                this.outputAndFlush("TRACE_DATADIR property cleared.\n");
            } else {
                if (this.paramString != null && this.paramString.indexOf(" ") != -1) {
                    this.paramString = this.paramString.substring(0, this.paramString.indexOf(" "));
                }
                this.outputAndFlush("attempting to set TRACE_DATADIR to:\n   " + this.paramString);
                object = new File(this.paramString);
                string = new String(object + System.getProperty("file.separator") + "TraceFormat.dat");
                if (((File)object).exists() && ((File)object).isDirectory() && new File(string).exists()) {
                    DvUtils.setValue("TRACE_DATADIR", this.paramString);
                    this.outputAndFlush("TRACE_DATADIR set to:\n   " + this.paramString + "\n");
                } else {
                    this.outputAndFlush("ERROR: TraceFormat.dat cannot be found in the specified directory.\n");
                }
            }
        }
        object = null;
        if (this.getEnvVar("TRACE_DATADIR").toUpperCase().equals("NULL")) {
            string = System.getProperty("java.home");
            string = string.concat(File.separator).concat("lib");
            object = System.getProperty("ibm.dg.trc.format", string);
        } else {
            object = this.getEnvVar("TRACE_DATADIR");
        }
        this.outputAndFlush("Trace formatter will use TraceFormat.dat from:\n   " + (String)object);
        this.printBanner(true, "", true);
        this.forcedEnd = true;
    }

    public void CMD_TraceExtract() {
        DvUtils.writetoTrace("DvTraceFmtPlugin:CMD_TraceExtract(Vector) entry");
        if (this.noDumpAccessed()) {
            this.forcedEnd = true;
            return;
        }
        this.printBanner(true, "", false);
        if (this.isTraceEnabled()) {
            this.outputAndFlush("Running Dump Extractor\n======================");
            if (snapTraceFileName == null) {
                this.doCreateTraceFile();
            } else {
                this.outputAndFlush("\nThe file already exists and will be used.\nThe trace filename is: \"" + snapTraceFileName + "\"");
            }
        } else {
            this.outputAndFlush("\nCannot Extract - There are no trace buffers in this dump.");
        }
        this.printBanner(true, "finsihed Dump Extractor", false);
        this.forcedEnd = true;
        DvUtils.writetoTrace("DvTraceFmtPlugin:CMD_TraceExtract(Vector) exit");
    }

    private void doCreateTraceFile() {
        traceRecords = new Hashtable();
        this.outputAndFlush("Processing Trace File Header\n----------------------------");
        try {
            String string = DvUtils.getValue("TRACE_VERBOSE");
            verbose = string.toUpperCase().equals("TRUE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        DvDump dvDump = DvConsole.getCurrentDump();
        DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
        int n = 0;
        snapTraceFileName = "extracted.trc";
        this.as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        CTypeObject cTypeObject = new CTypeObject("execenv", dvThread.eeAddress(), this.as);
        CTypeObject cTypeObject2 = cTypeObject.getField("jvmP").deReference();
        CTypeObject cTypeObject3 = cTypeObject2.getField("facade.dg.dataP").deReference("DgData");
        CTypeObject cTypeObject4 = cTypeObject3.getField("traceHeader").deReference("TraceFileHeader");
        CTypeObject cTypeObject5 = cTypeObject4.getField("bufferSize");
        CTypeObject cTypeObject6 = cTypeObject4.getField("header");
        CTypeObject cTypeObject7 = cTypeObject6.getField("length");
        long l = cTypeObject4.getAddr();
        this.outputAndFlush("address of TraceFileHeader = 0x" + Long.toHexString(l));
        int n2 = this.readAnInt(cTypeObject5);
        this.outputAndFlush("TraceBuffer Size           = " + n2 + " (hex 0x" + Long.toHexString(n2) + ")");
        int n3 = this.readAnInt(cTypeObject7);
        this.outputAndFlush("TraceFileHeader length     = " + n3 + " (hex 0x" + Long.toHexString(n3) + ")");
        this.outputAndFlush("\nwriting TraceFileHeader");
        this.writeDataToFile(l, n3, "NEW");
        this.outputAndFlush("\nProcessing Trace Buffers\n------------------------");
        CTypeObject cTypeObject8 = cTypeObject3.getField("traceGlobal");
        long l2 = this.readPtrAsLong(cTypeObject8);
        if (l2 != 0L) {
            Object object;
            this.outputAndFlush("traceGlobal ptr = 0x" + Long.toHexString(l2));
            while (l2 != 0L) {
                ++n;
                cTypeObject8 = cTypeObject8.deReference("DgTraceBuffer");
                if (verbose) {
                    this.outputAndFlush("************ Buffer (" + n + ") ************");
                    this.outputAndFlush(cTypeObject8.toString());
                }
                CTypeObject cTypeObject9 = cTypeObject8.getField("record");
                object = cTypeObject9.getField("sequence");
                long l3 = this.readLongAsLong((CTypeObject)object);
                traceRecords.put(new Long(l3), new Long(cTypeObject9.getAddr()));
                cTypeObject8 = cTypeObject8.getField("globalNext");
                l2 = this.readPtrAsLong(cTypeObject8);
            }
            int n4 = 0;
            object = traceRecords.keys();
            while (object.hasMoreElements()) {
                ++n4;
                object.nextElement();
            }
            this.outputAndFlush("There are " + n4 + " buffers");
            Object[] objectArray = new Long[n4];
            n4 = 0;
            Enumeration enumeration = traceRecords.keys();
            while (enumeration.hasMoreElements()) {
                objectArray[n4] = (Long)enumeration.nextElement();
                ++n4;
            }
            Arrays.sort(objectArray);
            int n5 = 0;
            while (n5 < objectArray.length) {
                this.outputAndFlush(" ");
                this.outputAndFlush("sequence: 0x" + Long.toHexString((Long)objectArray[n5]));
                long l4 = (Long)traceRecords.get(objectArray[n5]);
                this.writeDataToFile(l4, n2, "APPEND");
                ++n5;
            }
        } else {
            this.outputAndFlush("There are no trace buffers on the global chain (traceGlobal==NULL).");
        }
    }

    public void CMD_TraceFormat() {
        if (this.noDumpAccessed()) {
            this.forcedEnd = true;
            return;
        }
        if (!this.isTraceEnabled()) {
            this.printBanner(true, "", false);
            this.outputAndFlush("\nCannot format trace - There are no trace buffers in this dump.");
            this.printBanner(true, "", false);
            this.forcedEnd = true;
            return;
        }
        if (snapTraceFileName == null) {
            this.CMD_TraceExtract();
            this.outputAndFlush(" ");
        }
        this.printBanner(true, "", false);
        this.outputAndFlush("Running Trace Formatter\n=======================");
        if (snapTraceFileName != null) {
            String[] stringArray = this.buildFormatArgs();
            this.outputAndFlush("input file:   \"" + stringArray[0] + "\"");
            this.outputAndFlush("output file:  \"" + stringArray[1] + "\"");
            int n = 2;
            while (n < stringArray.length) {
                this.outputAndFlush("option:       " + stringArray[n]);
                ++n;
            }
            this.outputAndFlush(" ");
            this.doTraceFormat(stringArray);
        } else {
            this.outputAndFlush("\nERROR: Problem reading extracted trace file.\n");
        }
        this.printBanner(true, "finished Trace Formatter", false);
        this.forcedEnd = true;
    }

    private String[] buildFormatArgs() {
        String[] stringArray;
        Hashtable hashtable = new Hashtable();
        String string = null;
        string = snapTraceFileName;
        hashtable.put("infilename", string);
        string = this.getEnvVar("TRACE_OUTFILENAME");
        if (string.toUpperCase().equals("NULL")) {
            string = snapTraceFileName.concat(".fmt");
        } else if (string.indexOf("%T") != -1) {
            stringArray = null;
            String string2 = null;
            String string3 = null;
            String string4 = this.getEnvVar("TRACE_THREADS");
            int n = string.indexOf("%T");
            stringArray = new String("");
            if (n > 0) {
                stringArray = string.substring(0, n);
            }
            if (string4.toUpperCase().equals("NULL") || string4.toUpperCase().equals("ALL")) {
                string2 = "ALL";
            } else {
                string2 = string4;
                if (string2.indexOf(",") != -1) {
                    string2 = "MULTI";
                }
            }
            string3 = new String("");
            if (n < string.length()) {
                string3 = string.substring(n + 2, string.length());
            }
            string = stringArray.concat(string2).concat(string3);
        }
        hashtable.put("outfilename", string);
        savedFileName = string;
        string = this.getEnvVar("TRACE_THREADS");
        if (!string.equals("ALL") && !string.equals("NULL")) {
            hashtable.put("thread", "-thread:" + string);
        }
        if ((string = this.getEnvVar("TRACE_INDENT")).toUpperCase().equals("TRUE")) {
            hashtable.put("indent", "-indent");
        }
        if ((string = this.getEnvVar("TRACE_SYMBOLIC")).toUpperCase().equals("TRUE")) {
            hashtable.put("symbolic", "-symbolic");
        }
        if (!(string = this.getEnvVar("TRACE_ENTRIES")).equals("ALL") && !string.equals("NULL")) {
            hashtable.put("entries", "-entries:" + string);
        }
        stringArray = new String[hashtable.size()];
        int n = 0;
        if (hashtable.get("infilename") != null) {
            stringArray[n++] = (String)hashtable.get("infilename");
        }
        if (hashtable.get("outfilename") != null) {
            stringArray[n++] = (String)hashtable.get("outfilename");
        }
        if (hashtable.get("thread") != null) {
            stringArray[n++] = (String)hashtable.get("thread");
        }
        if (hashtable.get("indent") != null) {
            stringArray[n++] = (String)hashtable.get("indent");
        }
        if (hashtable.get("symbolic") != null) {
            stringArray[n++] = (String)hashtable.get("symbolic");
        }
        if (hashtable.get("entries") != null) {
            stringArray[n++] = (String)hashtable.get("entries");
        }
        return stringArray;
    }

    private void doTraceFormat(String[] stringArray) {
        PipedInputStream pipedInputStream = null;
        PrintStream printStream = null;
        try {
            pipedInputStream = new PipedInputStream();
            printStream = new PrintStream(new PipedOutputStream(pipedInputStream));
        }
        catch (IOException iOException) {
            this.outputAndFlush("ERROR: Unexpected exception creating output pipe.");
        }
        waitFlag = 0;
        TraceFormatterListener traceFormatterListener = new TraceFormatterListener(pipedInputStream, output, this.cpr);
        traceFormatterListener.start();
        while (waitFlag < 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                this.outputAndFlush("ERROR: Unexpected exception during sleep.");
            }
        }
        Properties properties = new Properties();
        properties.putAll(System.getProperties());
        if (!this.getEnvVar("TRACE_DATADIR").equals("NULL")) {
            System.setProperty("ibm.dg.trc.format", this.getEnvVar("TRACE_DATADIR"));
        }
        String string = null;
        String string2 = System.getProperty("java.home");
        string2 = string2.concat(File.separator).concat("lib");
        string = System.getProperty("ibm.dg.trc.format", string2);
        string = string.concat(System.getProperty("file.separator")).concat("TraceFormat.dat");
        this.outputAndFlush("Looking for Trace Format data in file: \n   " + string + "\n");
        if (new File(string).exists()) {
            TraceFormat traceFormat = new TraceFormat(printStream, stringArray);
        } else {
            this.outputAndFlush("ERROR: Unable to format Trace file - TraceFormat.dat does not exist.");
        }
        waitFlag = 2;
        while (waitFlag < 3) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                this.outputAndFlush("ERROR: Unexpected exception during sleep.");
            }
        }
        try {
            printStream.close();
            pipedInputStream.close();
        }
        catch (IOException iOException) {
            this.outputAndFlush("ERROR: unexpected exception closing print stream.");
        }
        System.setProperties(properties);
        if (snapTraceOutputFileName == null) {
            snapTraceOutputFileName = !this.getEnvVar("TRACE_OUTFILENAME").toUpperCase().equals("NULL") ? this.getEnvVar("TRACE_OUTFILENAME") : new String(snapTraceFileName + ".fmt");
        }
    }

    public void CMD_TraceSummary() {
        if (this.noDumpAccessed()) {
            this.forcedEnd = true;
            return;
        }
        this.printBanner(true, "", false);
        this.outputAndFlush("Display Trace Summary\n=====================\n");
        if (snapTraceFileName != null) {
            String[] stringArray = new String[]{snapTraceFileName, snapTraceFileName + ".tmp", "-summary"};
            this.doTraceFormat(stringArray);
        } else {
            this.outputAndFlush("\nThe trace file must already exist before the TRACE SUMMARY command is run.\n(Use TRACE EXTRACT or TRACE FORMAT before running TRACE SUMMARY).");
        }
        this.printBanner(true, "finished displaying trace summary", true);
        this.forcedEnd = true;
    }

    private void cacheSummaryInfo() {
        PrintStream printStream = null;
        if (this.noDumpAccessed()) {
            this.forcedEnd = true;
            return;
        }
        if (snapTraceFileName != null) {
            if (snapTraceInfoFileName == null) {
                String[] stringArray = new String[]{snapTraceFileName, snapTraceFileName + ".tmp", "-summary"};
                try {
                    printStream = new PrintStream(new FileOutputStream(snapTraceFileName + ".info"));
                }
                catch (IOException iOException) {
                    this.outputAndFlush("ERROR: Unexpected exception creating printStream.");
                }
                TraceFormat traceFormat = new TraceFormat(printStream, stringArray);
                printStream.close();
                snapTraceInfoFileName = new String(snapTraceFileName + ".info");
            }
        } else {
            this.outputAndFlush("\nThe trace file must already exist before the TRACE CACHE command is run.\n(Use TRACE EXTRACT before running TRACE CACHE).");
        }
        this.forcedEnd = true;
    }

    public void CMD_TraceThreads() {
        Object var1_1 = null;
        ArrayList arrayList = new ArrayList();
        boolean bl = true;
        if (this.noDumpAccessed()) {
            this.forcedEnd = true;
            return;
        }
        this.printBanner(true, "", false);
        this.outputAndFlush("Display Threads\n===============\n");
        if (snapTraceFileName == null) {
            this.outputAndFlush("The trace file does not exist so threads cannot be displayed.\n(Use TRACE FORMAT or EXTRACT before running TRACE THREADS).");
            bl = false;
        }
        if (bl && snapTraceInfoFileName == null) {
            this.cacheSummaryInfo();
        }
        boolean bl2 = false;
        String string = null;
        BufferedReader bufferedReader = null;
        if (bl) {
            try {
                bufferedReader = new BufferedReader(new FileReader(snapTraceFileName + ".info"));
                while (bufferedReader.ready()) {
                    string = bufferedReader.readLine();
                    if (bl2) {
                        if (string.trim().toUpperCase().equals("")) {
                            bl2 = false;
                        } else {
                            String string2 = string.trim();
                            this.outputAndFlush("THREAD: 0x" + string2);
                            String string3 = new String("0x" + string2.substring(0, string2.indexOf(" "))).toUpperCase();
                            arrayList.add(string3);
                        }
                    }
                    if (!string.trim().toUpperCase().equals("ACTIVE THREADS :")) continue;
                    bl2 = true;
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                this.outputAndFlush("ERROR: Unexpected exception reading " + snapTraceFileName + ".info " + "(" + exception + ", " + exception.getMessage() + ")");
                exception.printStackTrace();
            }
        }
        this.outputAndFlush(" ");
        if (this.paramString == null) {
            this.checkThreadArgs("NONE", arrayList, bl);
        } else {
            this.checkThreadArgs(this.paramString, arrayList, bl);
        }
        this.printBanner(true, "finished filling summary cache", true);
        this.forcedEnd = true;
    }

    private void checkThreadArgs(String string, ArrayList arrayList, boolean bl) {
        String string2;
        boolean bl2 = false;
        if (string != null) {
            bl2 = true;
        }
        if (string.equals("NONE")) {
            try {
                string = DvUtils.getValue("TRACE_THREADS");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            string = "ALL";
        }
        if ((string = string.toLowerCase()).toUpperCase().equals("ALL")) {
            DvUtils.setValue("TRACE_THREADS", "ALL");
            this.outputAndFlush("\nThe trace formatter will be run without the -thread option");
            return;
        }
        if (string == null) {
            this.outputAndFlush("No optional parameters supplied.");
            return;
        }
        boolean bl3 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.substring(0, 2).equals("0x")) {
                this.outputAndFlush("ERROR: " + string2 + " does not must begin \"0x\" (hex)");
                bl3 = true;
            }
            if (!bl3 && string2.length() == 2) {
                this.outputAndFlush("ERROR: 0x on it's own is not a valid hex number!!");
                bl3 = true;
            }
            if (!bl3) {
                String string3 = string2.substring(2, string2.length());
                try {
                    Long.parseLong(string3, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    this.outputAndFlush("ERROR: " + string2 + " is not a proper hex number.");
                    bl3 = true;
                }
            }
            if (!bl) continue;
            if (arrayList.contains(string2.toUpperCase())) {
                this.outputAndFlush(string2 + " is a valid thread.");
                continue;
            }
            this.outputAndFlush("ERROR: " + string2 + " is not in list of active threads.");
            bl3 = true;
        }
        try {
            if (bl3) {
                if (!bl2) {
                    DvUtils.setValue("TRACE_THREADS", "ALL");
                }
            } else {
                DvUtils.setValue("TRACE_THREADS", string);
            }
        }
        catch (Exception exception) {
            this.outputAndFlush("ERROR: Unexpected Exception received setting TRACE_THREADS");
            this.outputAndFlush("expception text:" + exception.getMessage());
        }
        string2 = null;
        string2 = DvUtils.getValue("TRACE_THREADS");
        if (string2 != null) {
            this.outputAndFlush("\nThe trace formatter will be run with the following option:");
            this.outputAndFlush("\"-thread:" + string2.toLowerCase() + "\"");
        }
    }

    private boolean noDumpAccessed() {
        if (DvConsole.theDump == null) {
            this.printBanner(true, "", true);
            this.outputAndFlush("Unable to comply as no dump accessed yet.");
            this.printBanner(true, "", true);
            return true;
        }
        return false;
    }

    private void printBanner(boolean bl, String string, boolean bl2) {
        if (this.printLines) {
            this.outputAndFlush("------------------------------------------------------------------------------");
        }
    }

    private String getEnvVar(String string) {
        String string2 = "NULL";
        try {
            string2 = DvUtils.getValue(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 == null) {
            string2 = "NULL";
        }
        return string2;
    }

    private boolean displayFile(String string, int n, int n2) {
        this.outputAndFlush("display file \"" + string + "\", from line " + n + " to line " + n2);
        BufferedReader bufferedReader = null;
        File file = new File(string);
        FileReader fileReader = null;
        boolean bl = false;
        if (!file.exists()) {
            this.outputAndFlush("ERROR: the file " + file.getName() + " doesn't exist");
            return false;
        }
        if (!file.canRead()) {
            this.outputAndFlush("ERROR: Unable to read the file " + file.getName());
            return false;
        }
        int n3 = 1;
        String string2 = null;
        boolean bl2 = false;
        try {
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            while (bufferedReader.ready() && !bl2) {
                string2 = bufferedReader.readLine();
                if (n3 >= n) {
                    if (n3 <= n2) {
                        this.outputAndFlush("[" + n3 + "] " + string2);
                        bl = true;
                    } else {
                        bl2 = true;
                    }
                }
                ++n3;
            }
            fileReader.close();
            bufferedReader.close();
        }
        catch (Exception exception) {
            this.outputAndFlush("ERROR: Unexpected exception reading \"" + snapTraceOutputFileName + "\" (" + exception + ", " + exception.getMessage() + ")");
            exception.printStackTrace();
        }
        return bl;
    }

    private long readPtrAsLong(CTypeObject cTypeObject) {
        long l = 0L;
        try {
            DvAddress dvAddress = this.as.readPointer(this.as.createAddress(cTypeObject.getAddr()));
            l = dvAddress.getAddressAsLong();
        }
        catch (DvAddressException dvAddressException) {
            this.outputAndFlush("DvAddressException while trying to read pointer from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            this.outputAndFlush(dvAddressException.toString());
        }
        catch (Exception exception) {
            this.outputAndFlush("Other exception received reading pointer from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            exception.printStackTrace();
        }
        return l;
    }

    private long readLongAsLong(CTypeObject cTypeObject) {
        long l = 0L;
        try {
            l = this.as.readLong(this.as.createAddress(cTypeObject.getAddr()));
        }
        catch (DvAddressException dvAddressException) {
            this.outputAndFlush("DvAddressException while trying to read long from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            this.outputAndFlush(dvAddressException.toString());
        }
        catch (Exception exception) {
            this.outputAndFlush("Other exception received reading long from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            exception.printStackTrace();
        }
        return l;
    }

    private int readAnInt(CTypeObject cTypeObject) {
        int n = -1;
        try {
            n = this.as.readInt(this.as.createAddress(cTypeObject.getAddr()));
        }
        catch (DvAddressException dvAddressException) {
            this.outputAndFlush("Exception while truing to read field from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            this.outputAndFlush(dvAddressException.toString());
        }
        return n;
    }

    private void writeDataToFile(long l, int n, String string) {
        FileOutputStream fileOutputStream;
        boolean bl = true;
        byte[] byArray = null;
        boolean bl2 = true;
        if (string.toUpperCase().trim().equals("NEW")) {
            bl2 = false;
        }
        output.add("writing 0x" + Long.toHexString(n) + " bytes from address 0x" + Long.toHexString(l) + " to file \"" + snapTraceFileName + "\"");
        try {
            fileOutputStream = new FileOutputStream(snapTraceFileName, bl2);
        }
        catch (IOException iOException) {
            output.add("Exception opening FileOutputStream for " + snapTraceFileName);
            return;
        }
        try {
            byArray = this.as.readBytes(l, (long)n);
        }
        catch (Exception exception) {
            output.add("Exception trying to put bytes into array");
            bl = false;
        }
        if (bl) {
            try {
                fileOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                output.add("Exception writing bytes to " + snapTraceFileName);
            }
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            output.add("Exception closing FileOutputStream");
        }
    }

    private void outputAndFlush(String string) {
        output.add(string);
        this.cpr.output(output);
        output.clear();
    }

    private boolean isTraceEnabled() {
        try {
            DvDump dvDump = DvConsole.getCurrentDump();
            DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
            this.as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            CTypeObject cTypeObject = new CTypeObject("execenv", dvThread.eeAddress(), this.as);
            CTypeObject cTypeObject2 = cTypeObject.getField("jvmP").deReference();
            CTypeObject cTypeObject3 = cTypeObject2.getField("facade.dg.dataP").deReference("DgData");
            CTypeObject cTypeObject4 = cTypeObject3.getField("traceGlobal");
            return this.readPtrAsLong(cTypeObject4) != 0L;
        }
        catch (Exception exception) {
            this.outputAndFlush(exception.toString());
            this.outputAndFlush("*** Unexpected exception received in isTraceEnabled() ***\nIf there are any dump buffers present, they cannot be formatted.");
            exception.printStackTrace();
            return false;
        }
    }

    public Vector guiMenus() {
        Vector vector = new Vector();
        vector.add(new DvMenu("Trace", 84, false));
        vector.add(new DvMenuItem("Trace", "Extract", -1, null, false, "CMD_TraceExtract", thisName, null, null, null, null));
        vector.add(new DvMenuItem("Trace", "Format", -1, null, false, "CMD_TraceFormat", thisName, null, null, null, null));
        vector.add(new DvMenuItem("Trace", "Summary", -1, null, false, "CMD_TraceSummary", thisName, null, null, null, null));
        vector.add(new DvMenuItem("Trace", "Display trace", -1, null, false, "CMD_TraceDisplay", thisName, null, null, null, null));
        vector.add(new DvMenuItem("Trace", "Spawn trace browser", -1, null, false, "spawnTraceBrowser", thisName, null, null, null, null));
        return vector;
    }

    public static void CMD_TraceExtract(String string) {
        Vector vector = new Vector();
        DvTraceFmtPlugin.selfRef.cpr = new CommandPluginResponse(vector);
        selfRef.CMD_TraceExtract();
        String string2 = DvUtils.convertResponse(vector, true);
        DvTraceFmtPlugin.displayGUIOutput(string, string2);
    }

    public static void CMD_TraceFormat(String string) {
        Vector vector = new Vector();
        DvTraceFmtPlugin.selfRef.cpr = new CommandPluginResponse(vector);
        selfRef.CMD_TraceFormat();
        String string2 = DvUtils.convertResponse(vector, true);
        DvTraceFmtPlugin.displayGUIOutput(string, string2);
    }

    public static void CMD_TraceSummary(String string) {
        Vector vector = new Vector();
        DvTraceFmtPlugin.selfRef.cpr = new CommandPluginResponse(vector);
        selfRef.CMD_TraceSummary();
        String string2 = DvUtils.convertResponse(vector, true);
        DvTraceFmtPlugin.displayGUIOutput(string, string2);
    }

    public static void CMD_TraceDisplay(String string) {
        Vector vector = new Vector();
        DvTraceFmtPlugin.selfRef.cpr = new CommandPluginResponse(vector);
        selfRef.CMD_TraceDisplay();
        String string2 = DvUtils.convertResponse(vector, true);
        if (-1 == string2.indexOf("Unable to comply")) {
            JInternalFrame jInternalFrame = Dumpviewer.getInternalFrame("Trace Scroller ", Dumpviewer.theIFM.getDefaultProperties(), 6);
            Dumpviewer.addIFrameToDesktop(jInternalFrame, 550, 500, 200, 30);
            DvTraceScroller dvTraceScroller = new DvTraceScroller(jInternalFrame, Dumpviewer.dvConsole, selfRef, string2);
        } else {
            Dumpviewer.genericInfoMessage("Unable to execute this command until trace format performed");
        }
    }

    public static void spawnTraceBrowser(String string) {
        DvUtils.writetoTrace("spawnTraceBrowser entry");
        if (null != savedFileName) {
            try {
                int n = DvConsole.theDump.getSystemType();
                String string2 = null;
                if (n == 1) {
                    string2 = DvUtils.getDvProperty("WindowsBrowser");
                    if (null == string2) {
                        string2 = "notepad";
                    }
                } else {
                    string2 = DvUtils.getDvProperty("UnixBrowser");
                    if (null == string2) {
                        string2 = "vi";
                    }
                }
                DvUtils.writetoTrace(" launching ... " + string2 + " " + savedFileName);
                Process process = Runtime.getRuntime().exec(string2 + " " + savedFileName);
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
            }
        } else {
            Dumpviewer.genericInfoMessage("Unable to execute this command until trace format performed");
        }
        DvUtils.writetoTrace("spawnTraceBrowser exit");
    }

    public static void CMD_setTraceFileName(String string) {
    }

    private static void displayGUIOutput(String string, String string2) {
        JInternalFrame jInternalFrame = Dumpviewer.theIFM.createNewFrame("Trace: " + string, Dumpviewer.theIFM.getDefaultProperties(), 0);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 430, 450, 5, Dumpviewer.selfRef.getHeight() - 530);
        JTextArea jTextArea = new JTextArea(string2, 8, 25);
        jTextArea.setEditable(false);
        Dumpviewer.theIFM.addContentToFrame(jInternalFrame, jTextArea);
    }

    public static Object getGenericHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvTraceFmtPlugin.properties");
        return vector;
    }

    public String pluginName() {
        return "Trace format commands (DvTraceFmtPlugin)";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String help() {
        return null;
    }

    public String help(String string) {
        return null;
    }

    public String[] guiMenuSyntax() {
        return null;
    }

    public String[] guiPopupSyntax() {
        return null;
    }
}

