/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvMenu;
import com.ibm.jvm.dump.format.DvMenuItem;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvRas;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.CommandPluginResponse;
import com.ibm.jvm.dump.plugins.DvBaseCommands;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JTextArea;

public class DvXeCommands
extends CommandPlugin
implements MouseListener {
    private static String thisName = "com.ibm.jvm.dump.plugins.DvXeCommands";
    private static Vector theOutput = new Vector();
    private static String[] commandsSupported = new String[]{"DISPLAY,DIS,JAVASTACK,js,displayJavaStack", "DISPLAY,DIS,NATIVESTACK,ns,displayNativeStack", "DISPLAY,DIS,JITMETHODS,jitm,displayJitMethods"};
    public static DvXeCommands selfRef;
    private static DvAddressSpace as;
    private Vector filter;

    public DvXeCommands() {
        selfRef = this;
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String pluginName() {
        return "XE commands Plugin";
    }

    public static Object getGenericHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvXeCommands.properties");
        return vector;
    }

    public String help() {
        return null;
    }

    public void displayJavaStack() {
        Vector vector = new Vector();
        DvDump dvDump = DvConsole.theDump;
        DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
        Vector vector2 = this.parseParams(this.paramString);
        if (this.paramString == null) {
            DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
            this.showJavaStack(dvThread, vector);
        } else {
            int n = 0;
            while (n < dvAddressSpaceArray.length) {
                DvProcess[] dvProcessArray = dvAddressSpaceArray[n].getProcesses();
                int n2 = 0;
                while (n2 < dvProcessArray.length) {
                    DvThread[] dvThreadArray = dvProcessArray[n2].getThreads();
                    int n3 = 0;
                    while (n3 < dvThreadArray.length) {
                        if (DvUtils.filtrate(dvThreadArray[n3].id(), vector2)) {
                            this.showJavaStack(dvThreadArray[n3], vector);
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void showJavaStack(DvThread dvThread, Vector vector) {
        DvDump dvDump = DvConsole.theDump;
        if (dvDump != null && dvThread != null && dvThread.getJavaStack() != null) {
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            vector.add("\n Java stack for thread " + dvThread.id() + " - " + DvUtils.getThreadName(dvThread, dvAddressSpace) + "\n ==========================\n");
            int n = 0;
            while ((long)n < dvThread.getJavaStack().getNumFrames()) {
                if (!dvThread.getJavaStack().getFrame(n).isPseudo()) {
                    vector.add("\tat " + dvThread.getJavaStack().getFrame(n).toString());
                }
                ++n;
            }
        } else {
            vector.add("No java stack.");
        }
    }

    public void displayNativeStack() {
        Vector vector = new Vector();
        DvDump dvDump = DvConsole.theDump;
        DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
        Vector vector2 = this.parseParams(this.paramString);
        if (this.paramString == null) {
            DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
            this.showNativeStack(dvThread, vector);
        } else {
            int n = 0;
            while (n < dvAddressSpaceArray.length) {
                DvProcess[] dvProcessArray = dvAddressSpaceArray[n].getProcesses();
                int n2 = 0;
                while (n2 < dvProcessArray.length) {
                    DvThread[] dvThreadArray = dvProcessArray[n2].getThreads();
                    int n3 = 0;
                    while (n3 < dvThreadArray.length) {
                        if (DvUtils.filtrate(dvThreadArray[n3].id(), vector2)) {
                            this.showNativeStack(dvThreadArray[n3], vector);
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void showNativeStack(DvThread dvThread, Vector vector) {
        DvDump dvDump = DvConsole.theDump;
        if (dvDump != null && dvThread != null && dvThread.getNativeStack() != null) {
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            vector.add("\n Native stack for thread " + dvThread.id() + " - " + DvUtils.getThreadName(dvThread, dvAddressSpace) + "\n ============================\n");
            int n = 0;
            while ((long)n < dvThread.getNativeStack().getNumFrames()) {
                DvNativeFrame dvNativeFrame = dvThread.getNativeStack().getFrame(n);
                if (dvAddressSpace.pointerSize() == 4) {
                    vector.add("\tat " + Integer.toHexString((int)dvNativeFrame.getPc()) + " in " + dvNativeFrame.toString());
                } else {
                    vector.add("\tat " + Long.toHexString(dvNativeFrame.getPc()) + " in " + dvNativeFrame.toString());
                }
                ++n;
            }
        } else {
            vector.add("Native stack not available.");
        }
    }

    private CTypeObject findAvlTreeRoot(DvAddressSpace dvAddressSpace, DvDump dvDump) {
        try {
            DvRas dvRas = dvDump.getRas();
            CTypeObject cTypeObject = new CTypeObject("jvm_ras_t", dvRas.jvmRas, dvAddressSpace);
            DvAddress dvAddress = new DvAddress(cTypeObject.getField("ras.data.jitRas").getValue());
            CTypeObject cTypeObject2 = new CTypeObject("jit_ras_t", dvAddressSpace.readPointer(dvAddress), dvAddressSpace);
            DvAddress dvAddress2 = new DvAddress(cTypeObject2.getField("ras.data.avl_tree_root").getValue());
            CTypeObject cTypeObject3 = new CTypeObject("committed_code", dvAddressSpace.readPointer(dvAddress2), dvAddressSpace);
            return cTypeObject3;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void displayJitMethods() {
        Vector vector = new Vector();
        DvDump dvDump = DvConsole.theDump;
        this.filter = this.parseParams(this.paramString);
        try {
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            CTypeObject cTypeObject = this.findAvlTreeRoot(dvAddressSpace, dvDump);
            if (null == cTypeObject) {
                vector.add("No jitted methods.");
            } else {
                this.displayCC(cTypeObject, dvAddressSpace, vector);
            }
        }
        catch (Exception exception) {
            vector.add("No jitted methods.");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private String getMethodName(CTypeObject cTypeObject, DvAddressSpace dvAddressSpace) throws DvAddressException {
        String string = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(cTypeObject.getField("member.name").getValue(), 1024L));
        CTypeObject cTypeObject2 = cTypeObject.getField("member.clazz").deReference();
        String string2 = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(cTypeObject2.getField("obj.name").getValue(), 1024L));
        return string2 + "/" + string;
    }

    private String getMethodSignature(CTypeObject cTypeObject, DvAddressSpace dvAddressSpace) throws DvAddressException {
        return DvUtils.getStringFromBytes(dvAddressSpace.readBytes(cTypeObject.getField("member.signature").getValue(), 1024L));
    }

    private void displayCC(CTypeObject cTypeObject, DvAddressSpace dvAddressSpace, Vector vector) {
        if (cTypeObject == null) {
            return;
        }
        try {
            CTypeObject cTypeObject2;
            String string;
            int n = 8;
            String string2 = "0000000000000000";
            String string3 = "00000000";
            if (DvUtils.is64BitSystem(DvConsole.theDump.getArchitecture())) {
                n = 16;
            }
            if (DvUtils.filtrate(string = this.getMethodName(cTypeObject2 = cTypeObject.getField("mb").deReference(), dvAddressSpace), this.filter)) {
                String string4 = Long.toHexString(cTypeObject.getField("start").getValue());
                int n2 = string4.length();
                if (8 == n && n2 < n) {
                    string4 = string3.substring(n2) + string4;
                }
                if (16 == n && n2 < n) {
                    string4 = string2.substring(n2) + string4;
                }
                String string5 = Long.toHexString(cTypeObject.getField("end").getValue());
                n2 = string5.length();
                if (8 == n && n2 < n) {
                    string5 = string3.substring(n2) + string5;
                }
                if (16 == n && n2 < n) {
                    string5 = string2.substring(n2) + string5;
                }
                vector.add(string + " " + this.getMethodSignature(cTypeObject2, dvAddressSpace) + " : (0x" + string4 + " - " + string5 + ")");
            }
            this.displayCC(cTypeObject.getField("left").deReference(), dvAddressSpace, vector);
            this.displayCC(cTypeObject.getField("right").deReference(), dvAddressSpace, vector);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private CTypeObject findJitMethod(CTypeObject cTypeObject, long l) throws DvAddressException {
        if (cTypeObject == null) {
            return null;
        }
        DvAddress dvAddress = new DvAddress(cTypeObject.getField("start").getValue());
        DvAddress dvAddress2 = new DvAddress(cTypeObject.getField("end").getValue());
        DvAddress dvAddress3 = new DvAddress(l);
        if (dvAddress3.compare(dvAddress) <= 0 && dvAddress3.compare(dvAddress2) >= 0) {
            return cTypeObject;
        }
        CTypeObject cTypeObject2 = this.findJitMethod(cTypeObject.getField("left").deReference(), l);
        if (cTypeObject2 != null) {
            return cTypeObject2;
        }
        cTypeObject2 = this.findJitMethod(cTypeObject.getField("right").deReference(), l);
        if (cTypeObject2 != null) {
            return cTypeObject2;
        }
        return null;
    }

    public String whatIs(DvAddress dvAddress, String string, DvDump dvDump) {
        try {
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            CTypeObject cTypeObject = this.findAvlTreeRoot(dvAddressSpace, dvDump);
            CTypeObject cTypeObject2 = this.findJitMethod(cTypeObject, dvAddress.getAddressAsLong());
            if (cTypeObject2 != null) {
                CTypeObject cTypeObject3 = cTypeObject2.getField("mb").deReference();
                String string2 = this.getMethodName(cTypeObject3, dvAddressSpace);
                return "Address is in JITed code for method " + string2 + " " + this.getMethodSignature(cTypeObject3, dvAddressSpace);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Vector parseParams(String string) {
        this.filter = new Vector();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                this.filter.add(string2);
            }
        } else {
            this.filter.add("*");
        }
        return this.filter;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public Vector guiMenus() {
        Vector vector = new Vector();
        vector.add(new DvMenu("JIT", 74, false));
        vector.add(new DvMenuItem("JIT", "JITted Methods", -1, null, false, "displayJitMethods", thisName, null, null, null, null));
        return vector;
    }

    public static void displayJitMethods(String string) {
        Vector vector = new Vector();
        DvXeCommands.selfRef.cpr = new CommandPluginResponse(vector);
        selfRef.displayJitMethods();
        String string2 = DvUtils.convertResponse(vector, false);
        if (-1 != string2.indexOf("No jitted methods")) {
            Dumpviewer.genericInfoMessage("No jitted methods were found");
        } else {
            Vector vector2 = (Vector)vector.get(0);
            Collections.sort(vector2);
            int n = vector2.size();
            String string3 = "";
            int n2 = 0;
            while (n2 < n) {
                String string4 = (String)vector2.get(n2);
                int n3 = string4.indexOf(" : ");
                if (-1 != n3) {
                    string3 = string3 + string4.substring(n3 + 3) + " : " + string4.substring(0, n3) + "\n";
                }
                ++n2;
            }
            DvXeCommands.displayGUIOutput(string, string3);
        }
    }

    private static void displayGUIOutput(String string, String string2) {
        JInternalFrame jInternalFrame = Dumpviewer.theIFM.createNewFrame(string, Dumpviewer.theIFM.getDefaultProperties(), 0);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 430, 450, 5, Dumpviewer.selfRef.getHeight() - 530);
        Font font = new Font("Monospaced", 0, 12);
        JTextArea jTextArea = new JTextArea(string2, 8, 25);
        jTextArea.setEditable(false);
        jTextArea.setFont(font);
        Dumpviewer.theIFM.addContentToFrame(jInternalFrame, jTextArea);
        jTextArea.addMouseListener(selfRef);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        DvUtils.writetoTrace("DVXeCommands: mouseClicked entry");
        int n = mouseEvent.getClickCount();
        if (n > 2) {
            n = 2;
        }
        if (2 == n && !((mouseEvent.getModifiers() & 4) == 4)) {
            String string;
            int n2;
            DvUtils.writetoTrace("    ....Its a double left click");
            Object object = mouseEvent.getSource();
            if (object instanceof JTextArea && -1 != (n2 = (string = ((JTextArea)object).getSelectedText()).toUpperCase().indexOf("0X"))) {
                String string2 = string.substring(n2 + 2);
                try {
                    long l = Long.parseLong(string2, 16);
                    DvAddress dvAddress = new DvAddress(l);
                    DvBaseCommands.displayMemory(dvAddress, 512L);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        DvUtils.writetoTrace("DVXeCommands: mouseClicked exit");
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

