/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.dump.format.DvJavaStack;
import com.ibm.jvm.dump.format.DvUtils;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SDFFJavaStack
extends DvJavaStack {
    private long length = 64L;
    private byte[] eyecatcher = new byte[]{74, 83, 84, 65, 67, 75, 84, 82};
    private byte[] spare = new byte[32];
    private long nullMetaData = -1L;
    private byte[] metadata;
    private DvJavaFrame[] javaFrames;

    public SDFFJavaStack() {
    }

    public SDFFJavaStack(DvJavaFrame[] dvJavaFrameArray) {
        super(dvJavaFrameArray);
        this.javaFrames = dvJavaFrameArray;
        int n = 0;
        while (n < this.spare.length) {
            this.spare[n] = 127;
            ++n;
        }
        if (this.javaFrames != null) {
            int n2 = 0;
            while (n2 < this.javaFrames.length) {
                this.length += 56L;
                if (this.javaFrames[n2].getName() != null) {
                    this.length += (long)this.javaFrames[n2].getName().length;
                }
                ++n2;
            }
        }
    }

    public long getLength() {
        return this.length;
    }

    public void printSdff(RandomAccessFile randomAccessFile) {
        try {
            randomAccessFile.writeLong(this.length);
            randomAccessFile.write(this.eyecatcher);
            randomAccessFile.writeLong(this.javaFrames == null ? 0L : (long)this.javaFrames.length);
            if (this.javaFrames != null) {
                int n = 0;
                while (n < this.javaFrames.length) {
                    randomAccessFile.writeLong(this.javaFrames[n].getMb());
                    randomAccessFile.writeLong(this.javaFrames[n].getPc());
                    randomAccessFile.writeLong(this.javaFrames[n].getSp());
                    randomAccessFile.writeLong(this.javaFrames[n].getArgs());
                    randomAccessFile.writeLong(this.javaFrames[n].getVars());
                    randomAccessFile.writeLong(this.javaFrames[n].getFrameType());
                    randomAccessFile.writeLong(this.javaFrames[n].getName().length);
                    if (this.javaFrames[n].getName() != null) {
                        randomAccessFile.write(this.javaFrames[n].getName());
                    } else {
                        randomAccessFile.writeLong(0L);
                    }
                    ++n;
                }
            }
            randomAccessFile.write(this.spare);
            randomAccessFile.writeLong(this.nullMetaData);
        }
        catch (Exception exception) {
            System.out.println("Error dumping JSTACKTR section");
            return;
        }
    }

    public static SDFFJavaStack loadFromFile(long l, RandomAccessFile randomAccessFile) {
        DvUtils.writetoTrace("Entry to SDFFJavaStack:loadFromFile...");
        long l2 = l;
        DvUtils.writetoTrace("  .... Loading SDFFRegister object from file :" + l);
        SDFFJavaStack sDFFJavaStack = new SDFFJavaStack();
        try {
            randomAccessFile.seek(l2);
            long l3 = randomAccessFile.readLong();
            randomAccessFile.skipBytes(8);
            randomAccessFile.seek(l2 + l3 - 8L);
            long l4 = randomAccessFile.readLong();
            if (l4 != -1L) {
                sDFFJavaStack.metadata = new byte[(int)l4];
                randomAccessFile.seek(l2 + l3 - 8L - l4);
                randomAccessFile.read(sDFFJavaStack.metadata);
                String string = new String(sDFFJavaStack.metadata);
                System.out.println("jstackmd:" + string);
            }
            randomAccessFile.seek(l2 + 16L);
            int n = (int)randomAccessFile.readLong();
            if (n == 0) {
                return sDFFJavaStack;
            }
            DvJavaFrame[] dvJavaFrameArray = new DvJavaFrame[n];
            if (dvJavaFrameArray == null) {
                return sDFFJavaStack;
            }
            int n2 = 0;
            while (n2 < n) {
                dvJavaFrameArray[n2] = new DvJavaFrame();
                dvJavaFrameArray[n2].setMb(randomAccessFile.readLong());
                dvJavaFrameArray[n2].setPc(randomAccessFile.readLong());
                dvJavaFrameArray[n2].setSp(randomAccessFile.readLong());
                dvJavaFrameArray[n2].setArgs(randomAccessFile.readLong());
                dvJavaFrameArray[n2].setVars(randomAccessFile.readLong());
                dvJavaFrameArray[n2].setFrameType((int)randomAccessFile.readLong());
                int n3 = (int)randomAccessFile.readLong();
                if (n3 > 0) {
                    byte[] byArray = new byte[n3];
                    if (byArray != null) {
                        randomAccessFile.read(byArray);
                    }
                    dvJavaFrameArray[n2].setName(byArray);
                }
                ++n2;
            }
            sDFFJavaStack.setFrames(dvJavaFrameArray);
        }
        catch (IOException iOException) {
            DvUtils.errorMsg("IOException in SDFFJavaStack: loadFromFile", 0);
        }
        DvUtils.writetoTrace("Exit from SDFFJavaStack:loadFromFile");
        return sDFFJavaStack;
    }
}

