/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvNativeStack;
import com.ibm.jvm.dump.format.DvUtils;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SDFFNativeStack
extends DvNativeStack {
    private long length = 64L;
    private byte[] eyecatcher = new byte[]{78, 83, 84, 65, 67, 75, 84, 82};
    private byte[] spare = new byte[32];
    private long nullMetaData = -1L;
    private byte[] metadata;
    private DvNativeFrame[] nativeFrames;

    public SDFFNativeStack() {
    }

    public SDFFNativeStack(DvNativeFrame[] dvNativeFrameArray) {
        super(dvNativeFrameArray);
        int n = 0;
        while (n < this.spare.length) {
            this.spare[n] = 127;
            ++n;
        }
        this.nativeFrames = dvNativeFrameArray;
        if (this.nativeFrames != null) {
            int n2 = 0;
            while (n2 < this.nativeFrames.length) {
                this.length += 40L;
                if (this.nativeFrames[n2].getName() != null) {
                    this.length += (long)this.nativeFrames[n2].getName().length;
                }
                ++n2;
            }
        }
    }

    public long getLength() {
        return this.length;
    }

    public void printSdff(RandomAccessFile randomAccessFile) {
        try {
            randomAccessFile.writeLong(this.length);
            randomAccessFile.write(this.eyecatcher);
            randomAccessFile.writeLong(this.nativeFrames == null ? 0L : (long)this.nativeFrames.length);
            if (this.nativeFrames != null) {
                int n = 0;
                while (n < this.nativeFrames.length) {
                    randomAccessFile.writeLong(this.nativeFrames[n].getMb());
                    randomAccessFile.writeLong(this.nativeFrames[n].getPc());
                    randomAccessFile.writeLong(this.nativeFrames[n].getSp());
                    randomAccessFile.writeLong(this.nativeFrames[n].getFrameType());
                    if (this.nativeFrames[n].getName() != null) {
                        randomAccessFile.writeLong(this.nativeFrames[n].getName().length);
                        randomAccessFile.write(this.nativeFrames[n].getName());
                    } else {
                        randomAccessFile.writeLong(0L);
                    }
                    ++n;
                }
            }
            randomAccessFile.write(this.spare);
            randomAccessFile.writeLong(this.nullMetaData);
        }
        catch (Exception exception) {
            System.out.println("Error dumping NSTACKTR section");
            return;
        }
    }

    public static SDFFNativeStack loadFromFile(long l, RandomAccessFile randomAccessFile) {
        DvUtils.writetoTrace("Entry to SDFFNativeStack:loadFromFile...");
        long l2 = l;
        DvUtils.writetoTrace("  .... Loading SDFFRegister object from file :" + l);
        SDFFNativeStack sDFFNativeStack = new SDFFNativeStack();
        try {
            randomAccessFile.seek(l2);
            long l3 = randomAccessFile.readLong();
            randomAccessFile.skipBytes(8);
            randomAccessFile.seek(l2 + l3 - 8L);
            long l4 = randomAccessFile.readLong();
            if (l4 != -1L) {
                sDFFNativeStack.metadata = new byte[(int)l4];
                randomAccessFile.seek(l2 + l3 - 8L - l4);
                randomAccessFile.read(sDFFNativeStack.metadata);
                String string = new String(sDFFNativeStack.metadata);
                System.out.println("nstackmd:" + string);
            }
            randomAccessFile.seek(l2 + 16L);
            int n = (int)randomAccessFile.readLong();
            DvNativeFrame[] dvNativeFrameArray = new DvNativeFrame[n];
            if (n == 0 || dvNativeFrameArray == null) {
                return sDFFNativeStack;
            }
            int n2 = 0;
            while (n2 < n) {
                dvNativeFrameArray[n2] = new DvNativeFrame();
                dvNativeFrameArray[n2].setMb(randomAccessFile.readLong());
                dvNativeFrameArray[n2].setPc(randomAccessFile.readLong());
                dvNativeFrameArray[n2].setSp(randomAccessFile.readLong());
                dvNativeFrameArray[n2].setFrameType((int)randomAccessFile.readLong());
                int n3 = (int)randomAccessFile.readLong();
                if (n3 > 0) {
                    byte[] byArray = new byte[n3];
                    if (byArray != null) {
                        randomAccessFile.read(byArray);
                    }
                    dvNativeFrameArray[n2].setName(byArray);
                }
                ++n2;
            }
            sDFFNativeStack.setFrames(dvNativeFrameArray);
        }
        catch (IOException iOException) {
            DvUtils.errorMsg("IOException in SDFFNativeStack: loadFromFile", 0);
        }
        DvUtils.writetoTrace("Exit from SDFFNativeStack:loadFromFile");
        return sDFFNativeStack;
    }
}

