/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvJavaStack;
import com.ibm.jvm.dump.format.DvNativeStack;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvRegister;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.SDFFAddress;
import com.ibm.jvm.dump.sdff.SDFFJavaStack;
import com.ibm.jvm.dump.sdff.SDFFNativeStack;
import com.ibm.jvm.dump.sdff.SDFFRegister;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdff.SdffConstants;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

class SDFFThread
extends DvThread {
    private static long length;
    private long threadID;
    private int threadType;
    private int threadState;
    private long stackptr;
    private long execEnv;
    private long pc;
    private byte[] metadata;
    private long metadata_offset;
    private DvProcess owner;
    private SDFFJavaStack javaStack;
    private SDFFNativeStack nativeStack;
    private Vector registerSections = new Vector();

    SDFFThread() {
        this.javaStack = new SDFFJavaStack();
    }

    SDFFThread(long l, long l2, long l3) {
        this.execEnv = l3;
    }

    public DvProcess getProcess() {
        return this.owner;
    }

    public String id() {
        return Long.toHexString(this.threadID);
    }

    public boolean isJava() {
        return this.execEnv > 0L;
    }

    public DvAddress eeAddress() {
        SDFFAddress sDFFAddress = new SDFFAddress();
        sDFFAddress.setAddress(this.execEnv);
        return sDFFAddress;
    }

    public DvNativeStack getNativeStack() {
        return this.nativeStack;
    }

    public DvJavaStack getJavaStack() {
        return this.javaStack;
    }

    public DvAddress getPSW() {
        return null;
    }

    public DvRegister[] getRegisters() {
        DvRegister[] dvRegisterArray = null;
        int n = this.registerSections.size();
        if (0 != n) {
            dvRegisterArray = new DvRegister[n];
            int n2 = 0;
            while (n2 < n) {
                dvRegisterArray[n2] = (DvRegister)this.registerSections.get(n2);
                ++n2;
            }
        }
        return dvRegisterArray;
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    public static SDFFThread loadFromFile(long l, RandomAccessFile randomAccessFile) {
        Object object;
        long l2 = l;
        DvUtils.writetoTrace(" Loading SDFFThread object from file offset " + l);
        SDFFThread sDFFThread = new SDFFThread();
        try {
            randomAccessFile.seek(l2);
            length = randomAccessFile.readLong();
            randomAccessFile.seek(l2 + length - 8L);
            sDFFThread.metadata_offset = randomAccessFile.readLong();
            if (-1L != sDFFThread.metadata_offset) {
                sDFFThread.metadata = new byte[(int)sDFFThread.metadata_offset];
                randomAccessFile.seek(l2 + length - 8L - sDFFThread.metadata_offset);
                randomAccessFile.read(sDFFThread.metadata);
            }
            randomAccessFile.seek(l2 + 8L);
            randomAccessFile.skipBytes(8);
            sDFFThread.threadID = randomAccessFile.readLong();
            sDFFThread.threadType = randomAccessFile.readInt();
            sDFFThread.threadState = randomAccessFile.readInt();
            sDFFThread.stackptr = randomAccessFile.readLong();
            sDFFThread.pc = randomAccessFile.readLong();
            sDFFThread.execEnv = randomAccessFile.readLong();
        }
        catch (IOException iOException) {
            DvUtils.errorMsg("IOException in SDFFThread: loadFromFile", 0);
        }
        DvUtils.writetoTrace(" Looking for REGISTER sections " + l);
        long l3 = l2;
        long l4 = l2 + length;
        boolean bl = false;
        byte[] byArray = SdffConstants.SEGMENT_Eye_SdffRegister.getBytes();
        while (l3 != -1L) {
            DvUtils.writetoTrace("  Looking for Register eyecatcher...");
            l3 = DvUtils.findNextInFile(randomAccessFile, byArray, l3, l4, 1);
            DvUtils.writetoTrace("  ... returned offset is x" + Long.toHexString(l3));
            if (l3 == -1L || l3 >= l4) continue;
            object = SDFFRegister.loadFromFile(l3 - 8L, randomAccessFile);
            sDFFThread.registerSections.add(object);
            try {
                randomAccessFile.seek(l3 - 8L);
                l3 += randomAccessFile.readLong();
            }
            catch (IOException iOException) {
                System.out.println("IOException in SDFFThread");
            }
        }
        DvUtils.writetoTrace(" Looking for JSTACKTR subsections " + l);
        l3 = l2;
        l4 = l2 + length;
        byArray = SdffConstants.SEGMENT_Eye_SdffJstackTr.getBytes();
        l3 = DvUtils.findNextInFile(randomAccessFile, byArray, l3, l4, 1);
        DvUtils.writetoTrace("  ... returned offset is x" + Long.toHexString(l3));
        if (l3 != -1L && l3 < l4) {
            sDFFThread.javaStack = object = SDFFJavaStack.loadFromFile(l3 - 8L, randomAccessFile);
        }
        DvUtils.writetoTrace(" Looking for NSTACKTR subsections " + l);
        l3 = l2;
        l4 = l2 + length;
        byArray = SdffConstants.SEGMENT_Eye_SdffNstackTr.getBytes();
        l3 = DvUtils.findNextInFile(randomAccessFile, byArray, l3, l4, 1);
        DvUtils.writetoTrace("  ... returned offset is x" + Long.toHexString(l3));
        if (l3 != -1L && l3 < l4) {
            sDFFThread.nativeStack = object = SDFFNativeStack.loadFromFile(l3 - 8L, randomAccessFile);
        }
        return sDFFThread;
    }

    void printSdff(Sdff sdff) throws IOException {
        long l = sdff.getFilePointer();
        sdff.writeLong(0L);
        sdff.write(SdffConstants.SEGMENT_Eye_SdffThread.getBytes());
        sdff.writeLong(this.threadID);
        sdff.writeInt(-1);
        sdff.writeInt(-1);
        sdff.writeLong(this.stackptr);
        sdff.writeLong(this.pc);
        sdff.writeLong(this.execEnv);
        this.javaStack.printSdff(sdff);
        this.nativeStack.printSdff(sdff);
        int n = 0;
        while (n < this.registerSections.size()) {
            SDFFRegister sDFFRegister = (SDFFRegister)this.registerSections.get(n);
            sDFFRegister.printSdff(sdff);
            ++n;
        }
        sdff.writeLong(-1L);
        sdff.printLength(l);
    }
}

