/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvModule;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.DvReader;
import com.ibm.jvm.dump.sdff.Fixup;
import com.ibm.jvm.dump.sdff.SDFFAddress;
import com.ibm.jvm.dump.sdff.Sdff;
import java.io.IOException;

public class Segment
extends DvModule {
    public DvReader reader;
    public long offset;
    public byte[] flags;

    public Segment(String string, long l, long l2, int n) {
        super(new SDFFAddress(l), string, l2, n);
        this.flags = new byte[24];
    }

    public Segment(String string, long l, long l2, int n, DvReader dvReader, long l3) {
        this(string, l, l2, n);
        this.offset = l3;
        this.reader = dvReader;
    }

    public Segment() {
    }

    void printSdff(Sdff sdff) throws IOException {
        if (this.reader != null) {
            sdff.writeLong(0L);
            sdff.writeLong(0L);
            sdff.writeLong(this.moduleAddress.getAddressAsLong());
            sdff.writeLong(this.moduleSize);
            long l = sdff.getFilePointer();
            sdff.fixup.addElement(new Fixup(l, this.offset));
            sdff.writeLong(0L);
            sdff.writeBytes(new String(this.flags));
        }
    }

    public void printMemory(Sdff sdff) throws IOException {
        int n = 4096;
        if (this.reader != null) {
            long l = this.moduleSize;
            byte[] byArray = new byte[n];
            while (l > (long)n) {
                this.reader.read(byArray);
                sdff.write(byArray);
                l -= (long)n;
            }
            if (l > 0L) {
                this.reader.read(byArray, 0, (int)l);
                sdff.write(byArray, 0, (int)l);
            }
        }
    }

    public void printSdffLoaded(Sdff sdff) throws IOException {
        DvUtils.writetoTrace("Text:(" + this.moduleName + ") " + Long.toHexString(this.moduleAddress.getAddressAsLong()));
        if (!this.moduleName.equals("")) {
            sdff.writeLong(this.moduleAddress.getAddressAsLong());
            sdff.writeLong(this.moduleSize);
            int n = ((this.moduleName.length() - 1) / 8 + 1) * 8;
            sdff.writeLong(this.moduleSize);
            sdff.writeBytes(this.moduleName);
            int n2 = n - this.moduleName.length();
            if (n2 > 0) {
                String string = "        ".substring(0, n2);
                sdff.writeBytes(string);
            }
        }
    }
}

