/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.Heapdump;
import com.ibm.jvm.findroots.HeapdumpContentHandler;
import com.ibm.jvm.findroots.HeapdumpParser;
import com.ibm.jvm.findroots.HprofParseFile;
import com.ibm.jvm.findroots.JavatraceParser;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Jvm;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class Convert
extends Base
implements HeapdumpContentHandler {
    Hashtable classNames = new Hashtable();
    int currentClassId;
    Heapdump dumpWriter;
    int jvmIndex = -1;
    boolean includeDead = false;

    String className() {
        return "Convert";
    }

    String[] options() {
        return new String[]{"-verbose", "-jvm <jvm index>"};
    }

    String[] optionDescriptions() {
        return new String[]{"\tPrint extra debugging info", "\tSpecify which jvm to use"};
    }

    public boolean parseOption(String string, String string2) {
        if ("-jvm".equals(string)) {
            try {
                this.jvmIndex = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                System.err.println(string2 + " is not a valid number");
                this.usage();
            }
            return true;
        }
        if ("-includedead".equals(string)) {
            this.includeDead = true;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) throws Exception {
        new Convert(stringArray);
    }

    void printChoicesAndExit(Jvm[] jvmArray) {
        System.err.println("Choose a jvm from the following list:");
        int n = 0;
        while (n < jvmArray.length) {
            System.err.println("\tjvm index = " + n + " asid = " + Base.hex(jvmArray[n].asid()) + " jvmp = " + Base.hex(jvmArray[n].jvmp));
            ++n;
        }
        System.exit(1);
    }

    Convert(String[] stringArray) throws Exception {
        this.parseOptions(stringArray);
        String string = stringArray[stringArray.length - 1];
        if (Dump.isSupportedSource(string).booleanValue()) {
            Dump dump = new Dump(string);
            if (Base.verbose) {
                Dump.verbose = true;
            }
            Jvm jvm = null;
            Jvm[] jvmArray = dump.jvms();
            if (jvmArray.length > 1) {
                if (this.jvmIndex == -1) {
                    System.err.println("More than one JVM found, please use the -jvm");
                    System.err.println("option to specify which one you want.");
                    this.printChoicesAndExit(jvmArray);
                }
                if (this.jvmIndex >= jvmArray.length) {
                    System.err.println("Error - maximum value for jvm index = " + (jvmArray.length - 1));
                    System.exit(1);
                }
                jvm = jvmArray[this.jvmIndex];
            } else if (jvmArray.length == 0) {
                System.err.println("No JVM's were found in this dump!");
                System.exit(1);
            } else {
                jvm = jvmArray[0];
            }
            this.dumpWriter = new Heapdump(string + ".phd", true);
            jvm.scanHeap(this, this.includeDead);
        } else {
            FileInputStream fileInputStream = new FileInputStream(string);
            int n = fileInputStream.read();
            int n2 = fileInputStream.read();
            int n3 = fileInputStream.read();
            if (n == 74 && n2 == 65 && n3 == 86) {
                this.dumpWriter = new Heapdump(string + ".phd", true);
                new HprofParseFile(this, string);
            } else if (n == 47 && n2 == 47 || n == 48 && n2 == 120) {
                this.dumpWriter = new Heapdump(string + ".phd", true);
                new HeapdumpParser(this, string);
            } else {
                fileInputStream = new FileInputStream(string);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                InputStreamReader inputStreamReader = null;
                if (n == 42 && n2 == 42 && n3 == 42) {
                    inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, "8859_1");
                } else if (n == 92 && n2 == 92 && n3 == 92) {
                    inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, "Cp1047");
                } else if (n == 110 && n2 == 99 && n3 == 32) {
                    inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, "8859_1");
                } else {
                    Convert.serror("Unknown data format: " + string);
                }
                this.dumpWriter = new Heapdump(string + ".phd", true);
                new JavatraceParser(this, inputStreamReader);
            }
        }
        this.dumpWriter.close();
    }

    int classNameIndex(String string) {
        Integer n = (Integer)this.classNames.get(string);
        if (n == null) {
            n = new Integer(this.currentClassId++);
            this.classNames.put(string, n);
            this.dumpWriter.stringDump(string);
        }
        return n;
    }

    public void instanceDump(int n, String string, int[] nArray, int n2) {
        this.dumpWriter.objectDump(n, this.classNameIndex(string), 0, n2, nArray);
    }

    public void classDump(int n, String string, int[] nArray, int n2) {
        this.dumpWriter.classDump(n, this.classNameIndex(string), 0, n2, nArray);
    }

    public void objectArrayDump(int n, String string, int[] nArray, int n2) {
        this.dumpWriter.objectArrayDump(n, this.classNameIndex(string), 0, n2, nArray);
    }

    public void primitiveArrayDump(int n, int n2, int n3) {
        this.dumpWriter.primitiveArrayDump(n, n2, 0, n3);
    }

    public void addEdge(int n, int n2) {
        this.error("Unimplemented method");
    }

    static void serror(String string) {
        throw new Error(string);
    }

    public void error(String string) {
        Convert.serror(string);
    }
}

