/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.DigraphParser;
import com.ibm.jvm.findroots.Graph;
import com.ibm.jvm.findroots.HeapdumpContentHandler;
import com.ibm.jvm.findroots.HeapdumpParser;
import com.ibm.jvm.findroots.HprofParseFile;
import com.ibm.jvm.findroots.JavatraceParser;
import com.ibm.jvm.findroots.PrintClient;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Jvm;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Hashtable;

public class FindRoots
implements HeapdumpContentHandler,
PrintClient {
    Graph graph = new Graph();
    Hashtable idToClass = new Hashtable();
    static DateFormat df = DateFormat.getTimeInstance();

    public final void log(String string) {
        Calendar calendar = Calendar.getInstance();
        String string2 = df.format(calendar.getTime());
        System.out.println(string2 + ": " + string);
    }

    public static void usage() {
        System.err.print("Usage: java com.ibm.jvm.findroots.FindRoots");
        int n = 0;
        while (n < Graph.options().length) {
            System.err.print(" " + Graph.options()[n]);
            ++n;
        }
        System.err.println(" <filename>");
        int n2 = 0;
        while (n2 < Graph.options().length) {
            System.err.println("\t" + Graph.options()[n2] + "\t" + Graph.optionDescriptions()[n2]);
            ++n2;
        }
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        if (stringArray.length < 1) {
            FindRoots.usage();
        }
        FindRoots findRoots = new FindRoots();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) == '-' && !findRoots.graph.parseOption(stringArray[n])) {
                FindRoots.usage();
            }
            ++n;
        }
        if (Graph.xml) {
            System.out.println("<graph>");
        }
        if ((string = stringArray[stringArray.length - 1]).endsWith(".digraph")) {
            new DigraphParser(findRoots, string);
            findRoots.graph.check();
        } else {
            if (Dump.isSupportedSource(string).booleanValue()) {
                Dump dump = new Dump(string, findRoots.graph);
                Jvm jvm = dump.jvms()[0];
                findRoots.graph.activate();
                jvm.findRoots(findRoots.graph);
                if (Graph.xml) {
                    System.out.println("</graph>");
                }
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(string);
            int n2 = fileInputStream.read();
            int n3 = fileInputStream.read();
            int n4 = fileInputStream.read();
            if (n2 == 74 && n3 == 65 && n4 == 86) {
                new HprofParseFile(findRoots, string);
            } else if (n2 == 47 && n3 == 47 || n2 == 48 && n3 == 120) {
                new HeapdumpParser(findRoots, string);
            } else {
                fileInputStream = new FileInputStream(string);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                InputStreamReader inputStreamReader = null;
                if (n2 == 42 && n3 == 42 && n4 == 42) {
                    inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, "8859_1");
                } else if (n2 == 92 && n3 == 92 && n4 == 92) {
                    inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, "Cp1047");
                } else if (n2 == 110 && n3 == 99 && n4 == 32) {
                    inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, "8859_1");
                } else {
                    FindRoots.serror("Unknown data format: " + string);
                }
                new JavatraceParser(findRoots, inputStreamReader);
            }
        }
        findRoots.print();
        if (Graph.xml) {
            System.out.println("</graph>");
        }
    }

    public void print() {
        this.graph.print(this);
    }

    public String getName(int n) {
        return (String)this.idToClass.get(new Integer(n));
    }

    public void instanceDump(int n, String string, int[] nArray, int n2) {
        this.idToClass.put(new Integer(n), string);
        if (!this.graph.nofinal || !string.equals("java/lang/ref/Finalizer")) {
            this.graph.addVertex(n, nArray, n2);
        }
    }

    public void classDump(int n, String string, int[] nArray, int n2) {
        this.idToClass.put(new Integer(n), string);
        this.graph.addVertex(n, nArray, n2);
    }

    public void objectArrayDump(int n, String string, int[] nArray, int n2) {
        this.idToClass.put(new Integer(n), "array of " + string);
        this.graph.addVertex(n, nArray, 4 * nArray.length + 8);
    }

    public void primitiveArrayDump(int n, int n2, int n3) {
        this.idToClass.put(new Integer(n), "array of type " + n2 + " and size " + n3);
        this.graph.addVertex(n, n3 * (1 << (n2 & 3)));
    }

    public void addEdge(int n, int n2) {
        this.graph.addEdge(n, n2);
    }

    static void serror(String string) {
        throw new Error(string);
    }

    public void error(String string) {
        FindRoots.serror(string);
    }
}

