/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.PrintClient;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.SortListener;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Random;

public class Graph {
    IntegerArray vertices = new IntegerArray();
    IntegerArray edgeHead = new IntegerArray();
    IntegerArray edges = new IntegerArray();
    IntegerArray sizes = new IntegerArray();
    IntegerArray widths;
    IntegerArray reachability;
    static final int UNKNOWN = -1;
    static final int IS_ROOT = Integer.MIN_VALUE;
    static final int END_MARKER = 0x40000000;
    boolean resolved;
    boolean active;
    boolean sorted = true;
    int time;
    IntegerArray discoveryTime;
    IntegerArray finishingTime;
    IntegerArray lastTouchTime;
    IntegerArray components;
    IntegerArray dfsOrder;
    int unresolved;
    IntegerArray rootSet;
    PrintClient printClient;
    Graph kernelDAG;
    public static boolean verbose = false;
    static DateFormat df = DateFormat.getTimeInstance();
    boolean[] isNotBranch;
    int[] counts;
    boolean optimize = true;
    int saved;
    int times;
    int notimes;
    int maxdepth = 10;
    int maxroots = 7;
    int prune = 100;
    boolean printall = false;
    boolean[] printed;
    static boolean xml = false;
    public boolean nofinal = true;
    static String version = "1.1";
    static boolean printedVersion = false;
    boolean sizematters = false;
    boolean simple = false;
    public boolean printstrings = false;
    int totalLength;
    int totalObjects;
    int visitorColour;
    int[] lastVisitorColour;
    Graph inverse;
    ReachVisitor reachVisitor = new ReachVisitor();
    static int nextIndex = 1;
    static /* synthetic */ Class class$com$ibm$jvm$findroots$Graph;

    final void initVisit() {
        ++this.visitorColour;
        if (this.lastVisitorColour == null || this.lastVisitorColour.length != this.size()) {
            this.lastVisitorColour = new int[this.size()];
        }
    }

    final boolean visited(int n) {
        return this.lastVisitorColour[n] == this.visitorColour;
    }

    final void visit(int n) {
        this.lastVisitorColour[n] = this.visitorColour;
    }

    static final String getTime() {
        Calendar calendar = Calendar.getInstance();
        return df.format(calendar.getTime());
    }

    public static final void log(String string) {
        if (!printedVersion) {
            printedVersion = true;
            Graph.log("findroots version " + version);
        }
        if (xml) {
            System.out.println("<log time='" + Graph.getTime() + "'>" + string + "</log>");
        } else {
            System.out.println(Graph.getTime() + ": " + string);
        }
    }

    final boolean isRoot(int n) {
        return (this.edgeHead.get(n) & Integer.MIN_VALUE) != 0;
    }

    final void setRoot(int n, boolean bl) {
        if (bl) {
            this.edgeHead.put(n, this.edgeHead.get(n) | Integer.MIN_VALUE);
        } else {
            this.edgeHead.put(n, this.edgeHead.get(n) & Integer.MAX_VALUE);
        }
    }

    public boolean active() {
        return this.active;
    }

    public void activate() {
        this.active = true;
    }

    final int size() {
        return this.vertices.size();
    }

    final int idToIndex(int n) {
        Graph.Assert(this.sorted);
        return this.vertices.indexOf(n);
    }

    public final void addVertex(int n, int[] nArray) {
        this.addVertex(n, nArray, 0);
    }

    public final void addVertex(int n, int[] nArray, int n2) {
        if (!this.sizematters) {
            n2 = 0;
        }
        this.resolved = false;
        this.sorted = false;
        this.vertices.add(n);
        this.sizes.add(n2);
        ++this.totalObjects;
        this.totalLength += n2;
        if (nArray == null || nArray.length == 0) {
            this.edgeHead.add(0x40000000);
            return;
        }
        this.edgeHead.add(this.edges.size());
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] != 0) {
                this.edges.add(nArray[n3]);
                if (n3 == nArray.length - 1) {
                    this.edges.add(0x40000000);
                } else {
                    this.edges.add(this.edges.size() + 1);
                }
            }
            ++n3;
        }
    }

    public final void addVertex(int n) {
        this.addVertex(n, 0);
    }

    public final void addVertex(int n, int n2) {
        if (!this.sizematters) {
            n2 = 0;
        }
        this.resolved = false;
        this.sorted = false;
        this.vertices.add(n);
        this.sizes.add(n2);
        this.edgeHead.add(0x40000000);
        ++this.totalObjects;
        this.totalLength += n2;
    }

    private void sort() {
        if (this.sorted) {
            return;
        }
        this.vertices.sort(new SortListener(){

            public final void swap(int n, int n2) {
                Graph.this.edgeHead.swap(n, n2);
                Graph.this.sizes.swap(n, n2);
                if (Graph.this.reachability != null) {
                    Graph.this.reachability.swap(n, n2);
                }
            }
        });
        this.sorted = true;
    }

    public final void addEdge(int n, int n2) {
        int n3 = this.idToIndex(n);
        if (n3 == -1) {
            this.addVertex(n);
            this.sort();
            n3 = this.idToIndex(n);
        }
        if (n == n2) {
            return;
        }
        if (this.idToIndex(n2) == -1) {
            this.addVertex(n2);
            this.sort();
            n3 = this.idToIndex(n);
        }
        this.addEdgeByIndex(n3, n2, true);
    }

    final void addEdgeByIndex(int n, int n2, boolean bl) {
        int n3;
        Graph.Assert(!this.resolved);
        int n4 = this.getEdgeHead(n);
        if (bl) {
            n3 = n4;
            while (n3 != 0x40000000) {
                if (this.edges.get(n3) == n2) {
                    return;
                }
                n3 = this.edges.get(n3 + 1);
            }
        }
        n3 = this.edgeHead.get(n) & Integer.MIN_VALUE;
        this.edgeHead.put(n, n3 | this.edges.size());
        this.edges.add(n2);
        this.edges.add(n4);
    }

    final void addEdgeByIndex(int n, int n2) {
        this.addEdgeByIndex(n, n2 + 1, true);
    }

    public final int reachability(int n) {
        int n2 = this.idToIndex(n);
        int n3 = this.reachability.get(n2);
        if (n3 != -1) {
            return n3;
        }
        if (this.printed != null && this.printed[n2]) {
            this.reachability.put(n2, 0);
            return 0;
        }
        if (this.components == null) {
            this.reachVisitor.initialize();
            this.visit(this.reachVisitor, n2);
            n3 = this.reachVisitor.result();
        } else {
            int n4 = this.components.get(n2);
            n3 = this.kernelDAG.reachability(n4);
        }
        this.reachability.put(n2, n3);
        return n3;
    }

    void markPrinted(int n) {
        this.printed[n] = true;
        if (!this.simple) {
            int n2 = this.components.get(n);
            int n3 = this.kernelDAG.idToIndex(n2);
            this.kernelDAG.printed[n3] = true;
        }
    }

    public int bruteReachability(int n) {
        int n2 = this.idToIndex(n);
        Visitor visitor = new Visitor(){
            int reach = -1;

            VisitorResult enterVertex(int n) {
                ++this.reach;
                return null;
            }

            int result() {
                return this.reach;
            }
        };
        this.visit(visitor, n2);
        return visitor.result();
    }

    void depthFirstSearch() {
        Graph.log("doing depth first search");
        if (this.dfsOrder == null) {
            this.dfsOrder = new IntegerArray(this.size(), 0);
            int n = 0;
            while (n < this.size()) {
                this.dfsOrder.put(n, n);
                ++n;
            }
        }
        this.dfs(new Visitor(){

            final void initialize() {
                Graph.this.discoveryTime = new IntegerArray(Graph.this.size(), 0);
                Graph.this.finishingTime = new IntegerArray(Graph.this.size(), 0);
                if (Graph.this.optimize) {
                    Graph.this.lastTouchTime = new IntegerArray(Graph.this.size(), 0);
                }
                Graph.this.time = 0;
                Graph.this.initVisit();
            }

            final VisitorResult enterVertex(int n) {
                Graph.this.discoveryTime.put(n, ++Graph.this.time);
                return null;
            }

            final VisitorResult leaveVertex(int n, VisitorResult visitorResult) {
                Graph.this.finishingTime.put(n, ++Graph.this.time);
                return visitorResult;
            }

            final VisitorResult touchVertex(int n) {
                if (Graph.this.optimize) {
                    Graph.this.lastTouchTime.put(n, ++Graph.this.time);
                }
                return null;
            }
        });
        Graph.log("finished depth first search");
    }

    public void dfs(Visitor visitor) {
        this.resolve();
        visitor.initialize();
        int n = 0;
        while (n < this.dfsOrder.size()) {
            int n2 = this.dfsOrder.get(n);
            if (!this.visited(n2)) {
                VisitorResult visitorResult = null;
                visitor.root(n2, visitorResult);
                visitorResult = this.visit(visitor, n2);
                visitor.rootAfter(n2, visitorResult);
            }
            ++n;
        }
    }

    private final void findBranches() {
        Graph.log("enter findBranches");
        this.depthFirstSearch();
        this.isNotBranch = new boolean[this.size()];
        this.counts = new int[this.size()];
        this.dfs(new Visitor(){

            final VisitorResult enterVertex(int n) {
                FindBranchResult findBranchResult = new FindBranchResult();
                findBranchResult.vertex = n;
                findBranchResult.before = Graph.this.discoveryTime.get(n);
                findBranchResult.after = Graph.this.finishingTime.get(n);
                return findBranchResult;
            }

            final VisitorResult leaveVertex(int n, VisitorResult visitorResult) {
                FindBranchResult findBranchResult = (FindBranchResult)visitorResult;
                if (Graph.this.lastTouchTime.get(n) > findBranchResult.after) {
                    findBranchResult.after = Graph.this.lastTouchTime.get(n);
                }
                return findBranchResult;
            }

            final VisitorResult touchVertex(int n) {
                FindBranchResult findBranchResult = new FindBranchResult();
                findBranchResult.vertex = n;
                findBranchResult.before = Graph.this.discoveryTime.get(n);
                findBranchResult.after = Graph.this.lastTouchTime.get(n) > Graph.this.finishingTime.get(n) ? Graph.this.lastTouchTime.get(n) : Graph.this.finishingTime.get(n);
                return findBranchResult;
            }

            final VisitorResult compareVertex(int n, VisitorResult visitorResult, VisitorResult visitorResult2) {
                FindBranchResult findBranchResult = (FindBranchResult)visitorResult;
                FindBranchResult findBranchResult2 = (FindBranchResult)visitorResult2;
                if (findBranchResult2.before < findBranchResult.before) {
                    findBranchResult.before = findBranchResult2.before;
                    Graph.this.isNotBranch[n] = true;
                }
                if (findBranchResult2.after > findBranchResult.after) {
                    findBranchResult.after = findBranchResult2.after;
                    Graph.this.isNotBranch[n] = true;
                }
                return findBranchResult;
            }
        });
        this.dfs(new Visitor(){

            final VisitorResult enterVertex(int n) {
                FindBranchResult findBranchResult = new FindBranchResult();
                findBranchResult.vertex = n;
                findBranchResult.count = Graph.this.sizes.get(n);
                return findBranchResult;
            }

            final VisitorResult compareVertex(int n, VisitorResult visitorResult, VisitorResult visitorResult2) {
                FindBranchResult findBranchResult = (FindBranchResult)visitorResult;
                FindBranchResult findBranchResult2 = (FindBranchResult)visitorResult2;
                if (findBranchResult2 != null) {
                    findBranchResult.count += findBranchResult2.count;
                }
                return findBranchResult;
            }

            final VisitorResult leaveVertex(int n, VisitorResult visitorResult) {
                FindBranchResult findBranchResult = (FindBranchResult)visitorResult;
                if (!Graph.this.isNotBranch[n]) {
                    Graph.this.counts[n] = findBranchResult.count;
                }
                return findBranchResult;
            }
        });
        Graph.log("leave findBranches");
    }

    final int getEdgeHead(int n) {
        int n2 = this.edgeHead.get(n);
        if ((n2 & 0x40000000) != 0) {
            return 0x40000000;
        }
        return n2 & Integer.MAX_VALUE;
    }

    private final VisitorResult visit(Visitor visitor, int n) {
        Graph.Assert(this.resolved);
        this.visit(n);
        VisitorResult visitorResult = visitor.enterVertex(n);
        if (visitor.continueSearch(n)) {
            int n2 = this.getEdgeHead(n);
            while (n2 != 0x40000000) {
                int n3 = this.edges.get(n2);
                if (n3 != -1) {
                    VisitorResult visitorResult2 = !this.visited(n3) ? this.visit(visitor, n3) : visitor.touchVertex(n3);
                    visitorResult = visitor.compareVertex(n, visitorResult, visitorResult2);
                }
                n2 = this.edges.get(n2 + 1);
            }
        }
        visitorResult = visitor.leaveVertex(n, visitorResult);
        return visitorResult;
    }

    private Graph inverse() {
        int n;
        Graph.log("enter inverse");
        this.resolve();
        Graph graph = new Graph();
        graph.vertices = this.vertices;
        graph.sizes = null;
        graph.edgeHead = new IntegerArray(this.size(), 0x40000000);
        int n2 = 0;
        while (n2 < this.size()) {
            n = this.vertices.get(n2);
            int n3 = this.getEdgeHead(n2);
            while (n3 != 0x40000000) {
                int n4 = this.edges.get(n3);
                if (n4 != -1) {
                    graph.addEdgeByIndex(n4, n, false);
                }
                n3 = this.edges.get(n3 + 1);
            }
            ++n2;
        }
        graph.dfsOrder = new IntegerArray(this.size(), 0);
        n = 0;
        while (n < this.size()) {
            graph.dfsOrder.put(n, n);
            ++n;
        }
        graph.resolve();
        Graph.log("exit inverse");
        return graph;
    }

    public void stronglyConnectedComponents() {
        int n;
        Graph.log("enter stronglyConnectedComponents");
        this.resolve();
        this.inverse = this.inverse();
        this.inverse.depthFirstSearch();
        this.inverse.finishingTime.reverseSort(this.inverse.dfsOrder);
        this.dfsOrder = this.inverse.dfsOrder;
        this.discoveryTime = null;
        this.finishingTime = null;
        this.lastTouchTime = null;
        this.inverse.discoveryTime = null;
        this.inverse.finishingTime = null;
        this.inverse.lastTouchTime = null;
        Graph.log("finished calculating inverse order");
        this.inverse = null;
        this.kernelDAG = new Graph();
        this.kernelDAG.optimize = this.optimize;
        this.components = new IntegerArray(this.size(), -1);
        Visitor visitor = new Visitor(){

            final VisitorResult enterVertex(int n) {
                int n2 = Graph.this.kernelDAG.size() - 1;
                Graph.this.components.put(n, n2);
                Graph.this.kernelDAG.sizes.put(n2, Graph.this.kernelDAG.sizes.get(n2) + Graph.this.sizes.get(n) + 1);
                return null;
            }

            final void root(int n, VisitorResult visitorResult) {
                int n2 = Graph.this.kernelDAG.size();
                Graph.this.kernelDAG.addVertex(n2);
                Graph.this.kernelDAG.setRoot(n2, true);
            }
        };
        this.dfs(visitor);
        Graph.log("finished creating kernel DAG vertices");
        this.kernelDAG.sort();
        Graph.log("add edges to kernel DAG");
        int n2 = 0;
        while (n2 < this.size()) {
            n = this.getEdgeHead(n2);
            while (n != 0x40000000) {
                int n3;
                int n4;
                int n5 = this.edges.get(n);
                if (n5 != -1 && (n4 = this.components.get(n2)) != (n3 = this.components.get(n5))) {
                    Graph.Assert(n4 >= 0 && n3 >= 0);
                    this.kernelDAG.addEdge(n4, n3);
                    int n6 = this.kernelDAG.idToIndex(n3);
                    this.kernelDAG.setRoot(n6, false);
                }
                n = this.edges.get(n + 1);
            }
            ++n2;
        }
        Graph.log("finished adding edges to kernel DAG");
        this.kernelDAG.resolve();
        this.kernelDAG.dfsOrder = new IntegerArray();
        n = 0;
        while (n < this.kernelDAG.size()) {
            if (this.kernelDAG.isRoot(n)) {
                this.kernelDAG.dfsOrder.add(n);
            }
            ++n;
        }
        Graph.Assert(this.kernelDAG.unresolved == 0);
        Graph.log("exit stronglyConnectedComponents our size = " + this.size() + " kernel size = " + this.kernelDAG.size());
        if (this.optimize) {
            this.kernelDAG.findBranches();
        }
    }

    int[] findRoots() {
        if (this.rootSet == null) {
            Graph.log("enter findRoots");
            this.stronglyConnectedComponents();
            this.rootSet = new IntegerArray();
            boolean[] blArray = new boolean[this.kernelDAG.size()];
            int n = 0;
            while (n < this.size()) {
                int n2 = this.components.get(n);
                int n3 = this.kernelDAG.idToIndex(n2);
                if (this.kernelDAG.isRoot(n3) && !blArray[n2]) {
                    this.rootSet.add(this.vertices.get(n));
                    blArray[n2] = true;
                }
                ++n;
            }
            Graph.log("exit findRoots, number of roots = " + this.rootSet.size());
        }
        return this.rootSet.toArray();
    }

    void resolve() {
        if (this.resolved) {
            return;
        }
        Graph.log("enter resolve");
        this.resolved = true;
        this.sort();
        int n = 0;
        while (n < this.edges.size()) {
            int n2 = this.edges.get(n);
            int n3 = this.idToIndex(n2);
            if (n3 == -1) {
                ++this.unresolved;
                this.edges.put(n, -1);
            } else {
                this.edges.put(n, n3);
            }
            n += 2;
        }
        Graph.log("exit resolve");
    }

    static Graph random(int n, int n2, int n3) {
        Random random = new Random(n);
        Graph graph = new Graph();
        int n4 = n2 / 2;
        int n5 = 1;
        while (n5 <= n2) {
            graph.addVertex(n5);
            ++n5;
        }
        graph.vertices.sort();
        int n6 = 0;
        while (n6 < n3) {
            int n7 = random.nextInt(n2);
            int n8 = random.nextInt(n2) + 1;
            int n9 = n8 - 1;
            if (n7 < n4 && n9 > n4 || n7 > n4 && n9 < n4 || n7 == n9) continue;
            if (n7 == n4 || n9 == n4) {
                System.out.println("created link from " + n7 + " to " + n9);
            }
            graph.addEdgeByIndex(n7, n8, true);
            ++n6;
        }
        return graph;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.size()) {
            int n2 = this.getEdgeHead(n);
            int n3 = this.vertices.get(n);
            int n4 = n2;
            while (n4 != 0x40000000) {
                int n5 = this.edges.get(n4);
                if (n5 != -1) {
                    if (this.resolved) {
                        n5 = this.vertices.get(n5);
                    }
                    stringBuffer.append(n3 + " --> " + n5 + "\n");
                }
                n4 = this.edges.get(n4 + 1);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static void upper(Graph graph, int n, int n2) {
        int n3 = nextIndex;
        graph.addEdgeByIndex(n3, n);
        graph.addEdgeByIndex(n3 + 1, n);
        nextIndex += 2;
        if (n2 > 0) {
            Graph.upper(graph, n3, n2 - 1);
            Graph.upper(graph, n3 + 1, n2 - 1);
        }
    }

    static void lower(Graph graph, int n, int n2) {
        int n3 = nextIndex;
        graph.addEdgeByIndex(n, n3);
        graph.addEdgeByIndex(n, n3 + 1);
        nextIndex += 2;
        if (n2 > 0) {
            Graph.lower(graph, n3, n2 - 1);
            Graph.lower(graph, n3 + 1, n2 - 1);
        }
    }

    public static void main(String[] stringArray) {
        Graph graph;
        if (stringArray.length >= 3) {
            Graph.log("create random graph");
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[2]);
            graph = Graph.random(n2, n, n * n3 / (n3 - 1));
            Graph.log("finished creating random graph");
        } else {
            graph = new Graph();
            int n = Integer.parseInt(stringArray[0]);
            int n4 = 1 + (4 << n) - 4;
            System.out.println("n = " + n4);
            int n5 = 1;
            while (n5 <= n4) {
                graph.addVertex(n5);
                ++n5;
            }
            graph.vertices.sort();
            Graph.upper(graph, 0, n - 1);
            Graph.lower(graph, 0, n - 1);
            if (stringArray.length > 1) {
                graph.optimize = false;
            }
        }
        graph.resolve();
        graph.prune = 0;
        if (stringArray.length > 3) {
            graph.optimize = false;
        }
        graph.maxroots = 1;
        graph.print(null);
    }

    void check() {
        int[] nArray = this.findRoots();
        int n = 0;
        while (n < nArray.length) {
            int n2;
            int n3 = this.reachability(nArray[n]);
            if (n3 != (n2 = this.reachability(nArray[n]))) {
                System.out.println("at id = " + nArray[n] + " r1 = " + n3 + " r2 = " + n2);
                System.out.print(this);
                System.out.println("kernel dag:\n" + this.kernelDAG);
                this.reachability(nArray[n]);
                System.out.println("non opt:");
                this.reachability(nArray[n]);
                System.exit(1);
            }
            ++n;
        }
        System.out.println("ok");
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    static void Assert(boolean bl) {
        if (!bl) {
            throw new Error("assert failed!");
        }
    }

    public static String[] options() {
        return new String[]{"-depth=<int>", "-roots=<int>|all", "-prune=<int>", "-printall", "-xml", "-final", "-version", "-sizematters", "-verbose", "-simple", "-printstrings", "-help"};
    }

    public static String[] optionDescriptions() {
        return new String[]{"\tDepth of the tree for each root (default 10)", "The number of roots to print (default 7)", "\tPrune nodes with fewer children (default 100)", "\tPrint objects even if they have been done once", "\t\tPrint output in XML", "\tInclude java/lang/ref/Finalizer classes (off by default)", "\tPrint version", "\tUse object sizes as basis for tree order", "\tPrint extra debugging info", "\t\tUse simple non-exact algorithm that is much quicker", "\tPrint the first 40 chars of arrays of char (SVC dumps only)", "\t\tPrint extended help info in html format"};
    }

    public boolean parseOption(String string) {
        if (string.equals("-version")) {
            System.out.println("Version " + version);
            System.exit(0);
        } else if (string.equals("-help")) {
            InputStream inputStream = (class$com$ibm$jvm$findroots$Graph == null ? (class$com$ibm$jvm$findroots$Graph = Graph.class$("com.ibm.jvm.findroots.Graph")) : class$com$ibm$jvm$findroots$Graph).getResourceAsStream("help.html");
            try {
                int n;
                while ((n = inputStream.read()) != -1) {
                    System.out.print((char)n);
                }
            }
            catch (Exception exception) {
                System.err.println("Problem reading help.html");
            }
            System.exit(0);
        } else if ("-printstrings".equals(string)) {
            this.printstrings = true;
        } else if ("-simple".equals(string)) {
            this.simple = true;
        } else if ("-verbose".equals(string)) {
            verbose = true;
        } else if ("-sizematters".equals(string)) {
            this.sizematters = true;
        } else if ("-final".equals(string)) {
            this.nofinal = false;
        } else if ("-xml".equals(string)) {
            xml = true;
        } else if ("-printall".equals(string)) {
            this.printall = true;
        } else {
            int n = string.indexOf(61);
            if (n < 0) {
                return false;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if ("-depth".equals(string2)) {
                this.maxdepth = Integer.parseInt(string3, 10);
            } else if ("-roots".equals(string2)) {
                this.maxroots = string3.equals("all") ? -1 : Integer.parseInt(string3, 10);
            } else if ("-prune".equals(string2)) {
                this.prune = Integer.parseInt(string3, 10);
            } else {
                return false;
            }
        }
        this.active = true;
        return true;
    }

    void calculateReachability() {
        Graph.log("calculate reachability");
        this.reachability.putAll(-1);
        this.kernelDAG.reachability.putAll(-1);
        IntegerArray integerArray = new IntegerArray();
        int n = -1;
        int n2 = 0;
        while (n2 < this.rootSet.size()) {
            int n3 = this.rootSet.get(n2);
            int n4 = this.idToIndex(n3);
            int n5 = 0;
            n5 = this.reachability(n3);
            if (n5 > n) {
                n = n5;
            }
            integerArray.add(n5);
            ++n2;
        }
        integerArray.reverseSort(this.rootSet);
        Graph.log("finished calculate reachability, saved = " + this.kernelDAG.saved + " times = " + this.kernelDAG.times + " notimes = " + this.kernelDAG.notimes + "\n");
    }

    final int width(int n) {
        int n2 = this.sizematters ? this.sizes.get(n) : 1;
        this.visit(n);
        int n3 = this.getEdgeHead(n);
        while (n3 != 0x40000000) {
            int n4 = this.edges.get(n3);
            if (n4 != -1 && !this.visited(n4)) {
                n2 += this.width(n4);
            }
            n3 = this.edges.get(n3 + 1);
        }
        this.widths.put(n, n2);
        return n2;
    }

    void info() {
        if (this.sizematters) {
            Graph.log("Now we print the largest roots with the biggest one first up to a maximum of " + this.maxroots + " roots. The number to the left is the total space occupied by all the objects that are reachable from that object. Child objects are indented.");
        } else {
            Graph.log("Now we print the largest roots with the biggest one first up to a maximum of " + this.maxroots + " roots. The number to the left is the count of all the objects that are reachable from that object. Child objects are indented.");
        }
    }

    void simplePrint() {
        this.resolve();
        this.initVisit();
        this.widths = new IntegerArray(this.size(), 0);
        IntegerArray integerArray = new IntegerArray(this.size(), 0);
        IntegerArray integerArray2 = new IntegerArray();
        int n = 0;
        while (n < this.size()) {
            integerArray2.add(this.vertices.get(n));
            if (!this.visited(n)) {
                this.width(n);
            }
            integerArray.put(n, this.widths.get(n));
            ++n;
        }
        integerArray.reverseSort(integerArray2);
        integerArray = null;
        if (this.maxroots == -1) {
            this.maxroots = this.size();
        }
        this.info();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.size() && n4 < this.maxroots) {
            int n5 = integerArray2.get(n3);
            int n6 = this.idToIndex(n5);
            if (!this.printed[n6]) {
                int n7 = this.widths.get(n6);
                if (n7 < this.prune) {
                    System.out.println("\nRemaining roots pruned because they are smaller than " + this.prune);
                    break;
                }
                n2 += n7;
                if (xml) {
                    System.out.println("<root index='" + n3 + "' running_total = '" + n2 + "'>");
                } else {
                    System.out.println("\n*** root " + n3 + " (running total " + n2 + ") ***\n");
                }
                this.printVertex(integerArray2.get(n3));
                if (xml) {
                    System.out.println("</root>");
                }
                ++n4;
            }
            ++n3;
        }
    }

    public void print(PrintClient printClient) {
        this.printClient = printClient;
        this.printed = new boolean[this.size()];
        if (this.simple) {
            this.simplePrint();
            return;
        }
        this.findRoots();
        this.kernelDAG.printed = new boolean[this.kernelDAG.size()];
        if (this.maxroots == -1) {
            this.maxroots = this.rootSet.size();
        }
        this.info();
        int n = 0;
        long l = System.currentTimeMillis();
        this.reachability = new IntegerArray(this.size(), -1);
        this.kernelDAG.reachability = new IntegerArray(this.kernelDAG.size(), -1);
        int n2 = 0;
        while (n2 < this.maxroots) {
            this.calculateReachability();
            n += this.reachability(this.rootSet.get(0));
            if (xml) {
                System.out.println("<root index='" + n2 + "' running_total = '" + n + "'>");
            } else {
                System.out.println("\n*** root " + n2 + " (running total " + n + ") ***\n");
            }
            this.printVertex(this.rootSet.get(0));
            if (xml) {
                System.out.println("</root>");
            }
            long l2 = System.currentTimeMillis();
            ++n2;
        }
        Graph.log("total size " + this.totalLength + " total objects " + this.totalObjects);
    }

    public void printVertex(int n) {
        int n2 = this.idToIndex(n);
        this.dfsOrder = new IntegerArray();
        this.dfsOrder.add(this.idToIndex(n));
        this.dfs(new Visitor(){
            int depth = 0;

            final VisitorResult enterVertex(int n) {
                String string;
                ++this.depth;
                PrintVisitorResult printVisitorResult = new PrintVisitorResult();
                if (Graph.this.printed[n] && !Graph.this.printall) {
                    return printVisitorResult;
                }
                if (this.depth >= Graph.this.maxdepth) {
                    return printVisitorResult;
                }
                int n2 = Graph.this.simple ? Graph.this.widths.get(n) : Graph.this.reachability(Graph.this.vertices.get(n));
                if (n2 < Graph.this.prune) {
                    return printVisitorResult;
                }
                if (!xml) {
                    int n3 = 0;
                    while (n3 < this.depth - 1) {
                        System.out.print("    ");
                        ++n3;
                    }
                }
                int n4 = Graph.this.vertices.get(n);
                String string2 = string = Graph.this.printClient == null ? "" : Graph.this.printClient.getName(n4);
                if (xml) {
                    System.out.println("<node count='" + n2 + "' id='0x" + Graph.hex(n4) + "'>" + string);
                } else {
                    System.out.println(n2 + " 0x" + Graph.hex(n4) + " " + string);
                }
                printVisitorResult.printed = true;
                return printVisitorResult;
            }

            final VisitorResult leaveVertex(int n, VisitorResult visitorResult) {
                PrintVisitorResult printVisitorResult = (PrintVisitorResult)visitorResult;
                --this.depth;
                Graph.this.markPrinted(n);
                if (printVisitorResult.printed && xml) {
                    System.out.println("</node>");
                }
                return printVisitorResult;
            }

            final boolean continueSearch(int n) {
                return Graph.this.printall || !Graph.this.printed[n];
            }
        });
    }

    public void printTopOfTree(int n) {
        int n2 = this.idToIndex(n);
        this.dfsOrder = new IntegerArray();
        this.dfsOrder.add(this.idToIndex(n));
        this.dfs(new Visitor(){
            int depth = 0;

            final VisitorResult enterVertex(int n) {
                ++this.depth;
                int n2 = 0;
                while (n2 < this.depth - 1) {
                    System.out.print("    ");
                    ++n2;
                }
                int n3 = Graph.this.vertices.get(n);
                String string = Graph.this.printClient == null ? "" : Graph.this.printClient.getName(n3);
                System.out.println("0x" + Graph.hex(n3) + " " + string);
                return null;
            }

            final VisitorResult leaveVertex(int n, VisitorResult visitorResult) {
                --this.depth;
                return null;
            }

            final boolean continueSearch(int n) {
                return this.depth < 7;
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PrintVisitorResult
    extends VisitorResult {
        boolean printed;

        PrintVisitorResult() {
        }
    }

    class VisitorResult {
        VisitorResult() {
        }
    }

    class Visitor {
        Visitor() {
        }

        void initialize() {
            Graph.this.initVisit();
        }

        VisitorResult enterVertex(int n) {
            return null;
        }

        VisitorResult leaveVertex(int n, VisitorResult visitorResult) {
            return visitorResult;
        }

        VisitorResult touchVertex(int n) {
            return null;
        }

        VisitorResult compareVertex(int n, VisitorResult visitorResult, VisitorResult visitorResult2) {
            return visitorResult;
        }

        void root(int n, VisitorResult visitorResult) {
        }

        void rootAfter(int n, VisitorResult visitorResult) {
        }

        boolean continueSearch(int n) {
            return true;
        }

        int result() {
            return 0;
        }
    }

    class FindBranchResult
    extends VisitorResult {
        int before;
        int after;
        int count;
        int vertex;

        FindBranchResult() {
        }
    }

    class ReachVisitor
    extends Visitor {
        int reach;

        ReachVisitor() {
        }

        void initialize() {
            this.reach = -1;
            Graph.this.initVisit();
        }

        VisitorResult enterVertex(int n) {
            if (Graph.this.printed != null && Graph.this.printed[n]) {
                return null;
            }
            if (Graph.this.optimize && !Graph.this.isRoot(n) && !Graph.this.isNotBranch[n]) {
                this.reach += Graph.this.counts[n];
                Graph.this.saved += Graph.this.counts[n] - Graph.this.sizes.get(n);
                ++Graph.this.times;
            } else {
                this.reach += Graph.this.sizes.get(n);
                ++Graph.this.notimes;
            }
            return null;
        }

        int result() {
            return this.reach;
        }

        boolean continueSearch(int n) {
            if (Graph.this.printed != null && Graph.this.printed[n]) {
                return false;
            }
            return !Graph.this.optimize || Graph.this.isRoot(n) || Graph.this.isNotBranch[n];
        }
    }
}

