/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.HeapdumpListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Heapdump
extends Base
implements HeapdumpListener {
    String filename;
    DataInputStream dis;
    DataOutputStream dos;
    Vector strings = new Vector();
    boolean output;
    int lastId;
    public int totalObjects;
    public long totalSize;
    public int totalRefs;
    public int version;
    static final int USE_BYTE_SIZES = 128;
    static final int USE_SHORT_SIZES = 64;
    static final int USE_SHORT_REFS = 32;
    static final int IS_LEAF = 16;
    static final int TAG_MASK = 15;
    static String[] primitiveArrayName = new String[]{"unknown array type", "primitive array", "array of references", "unknown array type", "array of boolean", "array of char", "array of float", "array of double", "array of byte", "array of short", "array of int", "array of long", "unknown array type", "unknown array type", "unknown array type", "unknown array type"};

    Heapdump() {
    }

    public Heapdump(String string, boolean bl) throws IOException {
        this.filename = string;
        this.output = bl;
        if (bl) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                this.dos = new DataOutputStream(bufferedOutputStream);
                this.dos.writeUTF("portable heap dump");
                this.dos.writeInt(2);
                this.dos.writeInt(this.totalObjects);
                this.dos.writeLong(this.totalSize);
                this.dos.writeInt(this.totalRefs);
                this.dos = new DataOutputStream(new GZIPOutputStream(bufferedOutputStream));
            }
            catch (Exception exception) {
                throw new Error("unexpected error: " + exception);
            }
        } else {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            this.checkHeader(randomAccessFile);
            if (this.version == 1) {
                throw new IOException("version 1 phd files no longer supported, please rerun Convert");
            }
            if (this.version > 1) {
                this.readTotals(randomAccessFile);
            }
        }
    }

    String className() {
        return "Heapdump";
    }

    public void close() {
        try {
            if (this.output) {
                this.dos.close();
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.filename, "rw");
                this.checkHeader(randomAccessFile);
                randomAccessFile.writeInt(this.totalObjects);
                randomAccessFile.writeLong(this.totalSize);
                randomAccessFile.writeInt(this.totalRefs);
            }
        }
        catch (Exception exception) {
            throw new Error("unexpected error while closing file" + exception);
        }
    }

    void checkHeader(DataInput dataInput) {
        try {
            String string = dataInput.readUTF();
            if (string.equals("portable heap dump")) {
                this.version = dataInput.readInt();
                Base.Assert(this.version > 0 && this.version < 3);
            } else if (!string.equals("binary heap dump")) {
                throw new IOException("invalid header - are you sure this is a .phd file?");
            }
        }
        catch (Exception exception) {
            throw new Error("invalid header - are you sure this is a .phd file?");
        }
    }

    void readTotals(DataInput dataInput) throws IOException {
        this.totalObjects = dataInput.readInt();
        this.totalSize = dataInput.readLong();
        this.totalRefs = dataInput.readInt();
    }

    public void parse(InputStream inputStream, HeapdumpListener heapdumpListener) {
        try {
            byte by;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            this.dis = new DataInputStream(bufferedInputStream);
            this.checkHeader(this.dis);
            if (this.version > 1) {
                this.readTotals(this.dis);
                this.dis = new DataInputStream(new GZIPInputStream(bufferedInputStream));
            }
            block14: while (true) {
                by = this.dis.readByte();
                switch (by & 0xF) {
                    case 1: {
                        String string = this.dis.readUTF();
                        this.strings.addElement(string);
                        heapdumpListener.stringDump(string);
                        continue block14;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        int n;
                        int n2;
                        short s;
                        int n3 = 0;
                        if ((by & 0x80) != 0) {
                            s = this.dis.readByte();
                            n2 = this.dis.readByte() & 0xFF;
                            if ((by & 0x10) == 0) {
                                n3 = this.dis.readByte() & 0xFF;
                            }
                            n = this.lastId + s;
                        } else if ((by & 0x40) != 0) {
                            s = this.dis.readShort();
                            n2 = this.dis.readShort() & 0xFFFF;
                            if ((by & 0x10) == 0) {
                                n3 = this.dis.readShort() & 0xFFFF;
                            }
                            n = this.lastId + s;
                        } else {
                            n = this.dis.readInt();
                            n2 = this.dis.readInt();
                            if ((by & 0x10) == 0) {
                                n3 = this.dis.readInt();
                            }
                        }
                        this.lastId = n;
                        s = (by & 0xF) == 5 ? (short)this.dis.readByte() : this.dis.readShort();
                        int[] nArray = new int[n3];
                        int n4 = 0;
                        while (n4 < n3) {
                            if ((by & 0x20) == 0) {
                                nArray[n4] = this.dis.readInt();
                            } else {
                                short s2 = this.dis.readShort();
                                nArray[n4] = s2 + n;
                            }
                            ++n4;
                        }
                        switch (by & 0xF) {
                            case 2: {
                                heapdumpListener.objectDump(n, s, 0, n2, nArray);
                                continue block14;
                            }
                            case 3: {
                                heapdumpListener.classDump(n, s, 0, n2, nArray);
                                continue block14;
                            }
                            case 4: {
                                heapdumpListener.objectArrayDump(n, s, 0, n2, nArray);
                                continue block14;
                            }
                            case 5: {
                                heapdumpListener.primitiveArrayDump(n, s, 0, n2);
                                continue block14;
                            }
                        }
                        Base.Assert(false);
                        continue block14;
                    }
                    case 6: {
                        this.readTotals(this.dis);
                        continue block14;
                    }
                }
                break;
            }
            throw new Error("unknown type " + by);
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("unexpected error: " + exception);
        }
    }

    public void parse(String string, HeapdumpListener heapdumpListener) throws Exception {
        this.parse(new FileInputStream(string), heapdumpListener);
    }

    public void stringDump(String string) {
        try {
            this.dos.writeByte(1);
            this.dos.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new Error("unexpected error " + iOException);
        }
    }

    void instanceDump(int n, int n2, int n3, int n4, int[] nArray) {
        ++this.totalObjects;
        this.totalSize += (long)n4;
        if (nArray != null) {
            this.totalRefs += nArray.length;
        }
        try {
            int n5;
            int n6;
            int n7;
            int n8 = nArray == null ? 0 : nArray.length;
            n = (int)((long)n & 0xFFFFFFFFL);
            if (n8 == 0) {
                n2 |= 0x10;
            } else {
                n7 = 1;
                n6 = 0;
                while (n6 < n8) {
                    n5 = nArray[n6];
                    if (Math.abs(n5 - n) > Short.MAX_VALUE) {
                        n7 = 0;
                    }
                    ++n6;
                }
                if (n7 != 0) {
                    n2 |= 0x20;
                }
            }
            n7 = n - this.lastId;
            if (Math.abs(n7) < 128 && n4 < 256 && n8 < 256) {
                this.dos.writeByte(n2 |= 0x80);
                this.dos.writeByte(n7);
                this.dos.writeByte(n4);
                if ((n2 & 0x10) == 0) {
                    this.dos.writeByte(n8);
                }
            } else if (Math.abs(n7) < 32768 && n4 < 65536 && n8 < 65536) {
                this.dos.writeByte(n2 |= 0x40);
                this.dos.writeShort(n7);
                this.dos.writeShort(n4);
                if ((n2 & 0x10) == 0) {
                    this.dos.writeShort(n8);
                }
            } else {
                this.dos.writeByte(n2);
                this.dos.writeInt(n);
                this.dos.writeInt(n4);
                if ((n2 & 0x10) == 0) {
                    this.dos.writeInt(n8);
                }
            }
            if ((n2 & 0xF) == 5) {
                this.dos.writeByte(n3);
            } else {
                this.dos.writeShort(n3);
            }
            n6 = 0;
            while (n6 < n8) {
                if ((n2 & 0x20) == 0) {
                    this.dos.writeInt(nArray[n6]);
                } else {
                    n5 = nArray[n6];
                    this.dos.writeShort(n5 -= n);
                }
                ++n6;
            }
            this.lastId = n;
        }
        catch (IOException iOException) {
            throw new Error("unexpected error " + iOException);
        }
    }

    public void objectDump(int n, int n2, int n3, int n4, int[] nArray) {
        this.instanceDump(n, 2, n2, n4, nArray);
    }

    public void classDump(int n, int n2, int n3, int n4, int[] nArray) {
        this.instanceDump(n, 3, n2, n4, nArray);
    }

    public void objectArrayDump(int n, int n2, int n3, int n4, int[] nArray) {
        this.instanceDump(n, 4, n2, n4, nArray);
    }

    public void primitiveArrayDump(int n, int n2, int n3, int n4) {
        this.instanceDump(n, 5, n2, n4, null);
    }

    public static String primitiveArrayName(int n) {
        return primitiveArrayName[n];
    }
}

