/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.BruteGraph;
import com.ibm.jvm.findroots.Edges;
import com.ibm.jvm.findroots.NewGraph;
import com.ibm.jvm.findroots.PrintClient;
import com.ibm.jvm.findroots.Vertex;
import com.ibm.jvm.util.IntEnumeration;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.IntegerStack;
import com.ibm.jvm.util.SortedIntEnumeration;
import com.ibm.jvm.util.SvcdumpProperties;
import com.ibm.jvm.util.TreeBitSet;
import com.ibm.jvm.util.html.Document;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;

public final class NewGraph
extends Base {
    static DateFormat df = DateFormat.getTimeInstance();
    static boolean xml;
    IntegerArray vertexIds = new IntegerArray();
    IntegerArray vertexIndexes = new IntegerArray();
    IntegerArray vertexSizes = new IntegerArray();
    IntegerArray dagSizes = new IntegerArray();
    boolean isDag;
    IntegerArray orderedVertexIds;
    Edges edges = new Edges();
    HashMap indexCache;
    int[] dagIndex;
    int[] reach;
    NewGraph dag;
    PrintClient client;
    int size;
    BitSet isNotRoot = new BitSet();
    BitSet deleted = new BitSet();
    int lowestId = Integer.MAX_VALUE;
    int highestId = 0;
    boolean recordParents;
    Edges parents;
    boolean complete = false;
    static boolean doFreeze;
    boolean sizeMatters = true;
    BitSet visited;
    int maxdepth = 50;
    int maxroots = 20;
    int prune = 100;
    Document doc = new Document();
    boolean exact = false;
    public boolean nofinal;
    HashMap frozenObjects = new HashMap();
    static BruteGraph brute;

    public NewGraph() {
        this.doc.setPlainText(!SvcdumpProperties.getBooleanProperty("svcdump.output.html", false));
        this.maxdepth = SvcdumpProperties.getIntProperty("findroots.depth", 1000);
        this.sizeMatters = SvcdumpProperties.getBooleanProperty("findroots.sizematters", false);
        this.prune = SvcdumpProperties.getIntProperty("findroots.prune", this.sizeMatters ? 10000 : 1000);
        this.maxroots = SvcdumpProperties.getIntProperty("findroots.maxroots", 20);
        this.exact = SvcdumpProperties.getBooleanProperty("findroots.exact", false);
        Base.verbose = true;
    }

    String className() {
        return "NewGraph";
    }

    public int reachFrom(int n) {
        this.complete();
        if (this.visited == null) {
            this.visited = new BitSet();
        }
        int n2 = this.idToIndex(n);
        Integer n3 = (Integer)this.dfs(new Visitor(){
            int n = 0;

            void enterNode(int n, int n2) {
                this.n += NewGraph.this.vertexSizes.get(n);
            }

            Object result() {
                return new Integer(this.n);
            }
        }, n2, this.visited);
        return n3;
    }

    public IntEnumeration getChildren(int n) {
        int n2 = this.idToIndex(n);
        Base.Assert(n2 >= 0);
        int n3 = this.edges.get(n2);
        IntEnumeration intEnumeration = TreeBitSet.elements(n3);
        class WrapIntEnumeration
        implements IntEnumeration {
            IntEnumeration e;
            private final /* synthetic */ NewGraph this$0;

            WrapIntEnumeration(NewGraph newGraph, IntEnumeration intEnumeration) {
                this.this$0 = newGraph;
                this.e = intEnumeration;
            }

            public boolean hasMoreElements() {
                return this.e.hasMoreElements();
            }

            public Object nextElement() {
                return new Integer(this.nextInt());
            }

            public int nextInt() {
                int n = this.e.nextInt();
                return this.this$0.vertexIds.get(n);
            }

            public void reset() {
                this.e.reset();
            }
        }
        return new WrapIntEnumeration(this, intEnumeration);
    }

    public int reachableVertices(int n) {
        Base.Assert(false);
        return 0;
    }

    public int reachableSize(int n) {
        Base.Assert(false);
        return 0;
    }

    void freeze(Object object, String string) {
        this.log("freeze " + string);
        try {
            File file = File.createTempFile("tmp", ".freeze");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            this.frozenObjects.put(string, file);
            this.log("freeze " + string + " complete");
        }
        catch (Exception exception) {
            throw new Error("Error freezing object: " + exception);
        }
    }

    Object unfreeze(String string) {
        this.log("unfreeze " + string);
        try {
            File file = (File)this.frozenObjects.get(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            this.frozenObjects.remove(string);
            file.delete();
            this.log("unfreeze " + string + " complete");
            return object;
        }
        catch (Exception exception) {
            throw new Error("Error unfreezing object: " + exception);
        }
    }

    void addEdgeByIndex(int n, int n2) {
        this.edges.put(n, TreeBitSet.set(this.edges.get(n), n2));
    }

    public void addEdge(int n, int n2) {
        int n3 = this.idToIndex(n);
        int n4 = this.idToIndex(n2);
        this.edges.put(n3, TreeBitSet.set(this.edges.get(n3), n4));
    }

    void flushCache() {
        if (this.indexCache == null) {
            return;
        }
        Integer[] integerArray = (Integer[])this.indexCache.keySet().toArray(new Integer[0]);
        int n = 0;
        while (n < integerArray.length) {
            Integer n2 = (Integer)this.indexCache.get(integerArray[n]);
            this.vertexIndexes.add(n2);
            this.vertexIds.add(integerArray[n]);
            ++n;
        }
        this.vertexIds.sort(this.vertexIndexes);
        this.indexCache = null;
    }

    void complete() {
        if (!this.complete) {
            this.flushCache();
            this.vertexIndexes.sort(this.vertexIds);
            this.vertexIndexes = null;
            this.complete = true;
        }
    }

    public int idToIndex(int n) {
        int n2;
        if (this.complete) {
            int n3;
            if (this.orderedVertexIds == null) {
                this.orderedVertexIds = new IntegerArray();
                this.vertexIndexes = new IntegerArray();
                n3 = 0;
                while (n3 < this.vertexIds.size()) {
                    this.orderedVertexIds.add(this.vertexIds.get(n3));
                    this.vertexIndexes.add(n3);
                    ++n3;
                }
                this.orderedVertexIds.sort(this.vertexIndexes);
            }
            if ((n3 = this.orderedVertexIds.indexOf(n)) == -1) {
                System.out.println("warning! could not find id " + Base.hex(n));
            }
            return this.vertexIndexes.get(n3);
        }
        int n4 = -1;
        if (this.size > 0) {
            float f = ((float)n - (float)this.lowestId) / ((float)this.highestId - (float)this.lowestId);
            n4 = (int)(f *= (float)this.size);
        }
        if ((n2 = this.vertexIds.indexOf(n, n4)) == -1) {
            Integer n5;
            Integer n6 = new Integer(n);
            if (this.indexCache == null) {
                this.indexCache = new HashMap();
            }
            if ((n5 = (Integer)this.indexCache.get(n6)) == null) {
                this.edges.add(0);
                if (this.recordParents) {
                    this.parents.add(0);
                }
                this.vertexSizes.add(1);
                if (this.isDag) {
                    this.dagSizes.add(0);
                }
                n2 = this.vertexIds.size() + this.indexCache.size();
                n5 = new Integer(n2);
                this.indexCache.put(n6, n5);
                if (this.indexCache.size() == 500000) {
                    this.flushCache();
                }
                if (n < this.lowestId) {
                    this.lowestId = n;
                } else if (n > this.highestId) {
                    this.highestId = n;
                }
                ++this.size;
            } else {
                n2 = n5;
            }
        } else {
            n2 = this.vertexIndexes.get(n2);
        }
        return n2;
    }

    public void setRecordParents(boolean bl) {
        this.recordParents = bl;
        this.parents = new Edges();
    }

    public int[] getParents(int n) {
        Base.Assert(this.recordParents);
        this.complete();
        int n2 = this.idToIndex(n);
        int n3 = this.parents.get(n2);
        int[] nArray = new int[TreeBitSet.numberOfElements(n3)];
        int n4 = 0;
        IntEnumeration intEnumeration = TreeBitSet.elements(n3);
        while (intEnumeration.hasMoreElements()) {
            int n5 = intEnumeration.nextInt();
            nArray[n4++] = this.vertexIds.get(n5);
        }
        return nArray;
    }

    public int pruneLeaves() {
        Base.Assert(this.recordParents);
        this.complete();
        int n = 0;
        int n2 = 0;
        while (n2 < this.size) {
            int n3 = this.parents.get(n2);
            if (TreeBitSet.numberOfElements(n3) == 0) {
                IntEnumeration intEnumeration = TreeBitSet.elements(n3);
                while (intEnumeration.hasMoreElements()) {
                    int n4 = intEnumeration.nextInt();
                }
                this.parents.put(n2, 0);
                this.vertexIds.put(n2, -1);
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void addToVertex(int n, int n2) {
        int n3 = this.idToIndex(n);
        this.vertexSizes.put(n3, this.vertexSizes.get(n3) + n2);
    }

    public void addVertex(int n, int n2) {
        int n3 = this.idToIndex(n);
        if (this.sizeMatters) {
            this.vertexSizes.put(n3, n2);
        }
    }

    public void addVertex(int n, int[] nArray, int n2) {
        int n3 = this.idToIndex(n);
        if (this.sizeMatters) {
            this.vertexSizes.put(n3, n2);
        }
        int n4 = this.edges.get(n3);
        int n5 = 0;
        while (n5 < nArray.length) {
            int n6 = this.idToIndex(nArray[n5]);
            n4 = TreeBitSet.set(n4, n6);
            if (this.recordParents) {
                this.parents.put(n6, TreeBitSet.set(this.parents.get(n6), n3));
            }
            ++n5;
        }
        this.edges.put(n3, n4);
    }

    void printNode(int n, int n2, boolean bl) {
        int n3 = this.vertexIds.get(n);
        int n4 = this.reach[n];
        int n5 = 0;
        while (n5 < n2) {
            System.out.print("   ");
            ++n5;
        }
        System.out.println(n4 + " 0x" + Base.hex(n3) + " " + this.client.getName(n3) + (bl ? "" : " (already visited)"));
    }

    void printTree(int n) {
        this.complete();
        this.log("begin printTree");
        this.printNode(n, 0, true);
        this.dfs(new Visitor(){
            int count = 0;

            void visitChild(int n, int n2, boolean bl, int n3) {
                if (NewGraph.this.reach[n2] < NewGraph.this.prune) {
                    return;
                }
                NewGraph.this.printNode(n2, n3, bl);
            }

            boolean continueSearch(int n, int n2) {
                return n2 < NewGraph.this.maxdepth && NewGraph.this.reach[n] > NewGraph.this.prune;
            }

            boolean sort() {
                return true;
            }

            int getCount(int n) {
                return NewGraph.this.reach[n];
            }
        }, n);
        this.log("end printTree");
    }

    int ancestorWithLowestSemi(int n, int[] nArray, BitSet bitSet, int[] nArray2, int[] nArray3) {
        int n2 = n;
        while (bitSet.get(n)) {
            if (nArray2[nArray3[n]] < nArray2[nArray3[n2]]) {
                n2 = n;
            }
            n = nArray[n];
        }
        return n2;
    }

    void link(int n, int n2, BitSet bitSet) {
        bitSet.set(n2);
    }

    NewGraph findDominators() {
        int n;
        int n2;
        int n3;
        int n4;
        this.log("begin findDominators");
        int[] nArray = new int[this.size];
        int[] nArray2 = new int[this.size];
        int[] nArray3 = new int[this.size];
        int[] nArray4 = new int[this.size];
        int[] nArray5 = new int[this.size];
        int[] nArray6 = new int[this.size];
        BitSet bitSet = new BitSet();
        int n5 = 0;
        while (n5 < this.size) {
            nArray5[n5] = -1;
            ++n5;
        }
        class AssignDfnum
        extends Visitor {
            int N;
            int[] dfnum;
            int[] vertex;
            int[] parent;
            int[] pre;
            private final /* synthetic */ NewGraph this$0;

            AssignDfnum(NewGraph newGraph, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
                this.this$0 = newGraph;
                this.N = 1;
                this.dfnum = nArray;
                this.vertex = nArray2;
                this.parent = nArray3;
                this.pre = nArray4;
            }

            void visitChild(int n, int n2, boolean bl, int n3) {
                if (bl) {
                    this.dfnum[n2] = this.N;
                    this.vertex[this.N] = n2;
                    this.parent[n2] = n;
                    ++this.N;
                }
                this.pre[n2] = TreeBitSet.set(this.pre[n2], n);
            }

            Object result() {
                return null;
            }
        }
        this.dfs(new AssignDfnum(this, nArray, nArray2, nArray3, nArray4), 0);
        int[] nArray7 = nArray4;
        int n6 = this.size - 1;
        while (n6 >= 1) {
            n4 = nArray2[n6];
            Base.Assert(n4 != 0);
            int n7 = n3 = nArray3[n4];
            IntEnumeration intEnumeration = TreeBitSet.elements(nArray4[n4]);
            while (intEnumeration.hasMoreElements()) {
                int n8 = intEnumeration.nextInt();
                n2 = nArray[n8] <= nArray[n4] ? n8 : nArray7[this.ancestorWithLowestSemi(n8, nArray3, bitSet, nArray, nArray7)];
                if (nArray[n2] >= nArray[n7]) continue;
                n7 = n2;
            }
            nArray7[n4] = n7;
            nArray6[n7] = TreeBitSet.set(nArray6[n7], n4);
            this.link(n3, n4, bitSet);
            IntEnumeration intEnumeration2 = TreeBitSet.elements(nArray6[n3]);
            while (intEnumeration2.hasMoreElements()) {
                n2 = intEnumeration2.nextInt();
                n = this.ancestorWithLowestSemi(n2, nArray3, bitSet, nArray, nArray7);
                nArray5[n2] = nArray7[n] == nArray7[n2] ? n3 : n | Integer.MIN_VALUE;
            }
            TreeBitSet.free(nArray6[n3]);
            nArray6[n3] = 0;
            --n6;
        }
        n4 = 1;
        while (n4 < this.size) {
            n3 = nArray2[n4];
            if (nArray5[n3] < 0) {
                Base.Assert(nArray5[n3] != -1);
                nArray5[n3] = nArray5[nArray5[n3] & Integer.MAX_VALUE];
            }
            ++n4;
        }
        n3 = 0;
        while (n3 < this.size) {
            TreeBitSet.free(nArray4[n3]);
            ++n3;
        }
        nArray6 = null;
        nArray7 = null;
        nArray4 = null;
        nArray3 = null;
        nArray2 = null;
        nArray = null;
        this.log("end findDominators");
        NewGraph newGraph = new NewGraph();
        int n9 = 0;
        while (n9 < this.size) {
            newGraph.idToIndex(this.vertexIds.get(n9));
            ++n9;
        }
        int n10 = 1;
        while (n10 < this.size) {
            n2 = this.vertexIds.get(nArray5[n10]);
            n = this.vertexIds.get(n10);
            newGraph.addEdge(n2, n);
            newGraph.vertexSizes.put(n10, this.vertexSizes.get(n10));
            ++n10;
        }
        newGraph.complete();
        return newGraph;
    }

    public void deleteTree(int n) {
        this.dfs(new Visitor(){

            void exitNode(int n) {
                NewGraph.this.deleted.set(n);
            }
        }, n);
    }

    NewGraph findStrongComponents() {
        int n;
        this.log("begin findStrongComponents");
        int[] nArray = (int[])this.dfs(new Visitor(){
            IntegerStack s = new IntegerStack();
            IntegerStack path = new IntegerStack();
            int[] pre;
            int[] sc;
            int cnt0;
            int cnt1;
            {
                this.pre = new int[NewGraph.this.size];
                this.sc = new int[NewGraph.this.size];
                this.cnt0 = 0;
                this.cnt1 = 1;
            }

            void init() {
                int n = 0;
                while (n < NewGraph.this.size) {
                    this.sc[n] = -1;
                    ++n;
                }
            }

            void enterNode(int n, int n2) {
                ++this.cnt0;
                this.s.push(n);
                this.path.push(n);
            }

            void visitChild(int n, int n2, boolean bl, int n3) {
                if (!bl && this.sc[n2] == -1) {
                    while (this.pre[this.path.peek()] > this.pre[n2]) {
                        this.path.pop();
                    }
                }
            }

            void exitNode(int n) {
                if (this.path.peek() == n) {
                    int n2;
                    this.path.pop();
                    do {
                        n2 = this.s.pop();
                        this.sc[n2] = this.cnt1++;
                    } while (n2 != n);
                }
            }

            Object result() {
                return this.sc;
            }
        });
        this.log("create dag");
        this.dag = new NewGraph();
        this.dag.isDag = true;
        this.dagIndex = new int[this.size];
        this.dag.idToIndex(0);
        this.dag.isNotRoot.set(0);
        int n2 = 0;
        while (n2 < this.size) {
            if (!this.deleted.get(n2)) {
                int n3;
                n = this.edges.get(n2);
                this.dagIndex[n2] = n3 = this.dag.idToIndex(nArray[n2]);
                this.dag.vertexSizes.put(n3, this.dag.vertexSizes.get(n3) + this.vertexSizes.get(n2));
                this.dag.dagSizes.put(n3, this.dag.dagSizes.get(n3) + 1);
                if (n != 0) {
                    IntEnumeration intEnumeration = TreeBitSet.elements(n);
                    while (intEnumeration.hasMoreElements()) {
                        int n4 = intEnumeration.nextInt();
                        this.dagIndex[n4] = this.dag.idToIndex(nArray[n4]);
                        if (nArray[n2] == nArray[n4]) continue;
                        this.dag.addEdge(nArray[n2], nArray[n4]);
                        this.dag.isNotRoot.set(this.dagIndex[n4]);
                    }
                }
            }
            ++n2;
        }
        n = 1;
        while (n < this.dag.size) {
            this.dag.vertexSizes.put(n, this.dag.vertexSizes.get(n) - 1);
            if (!this.dag.isNotRoot.get(n)) {
                this.dag.addEdgeByIndex(0, n);
            }
            ++n;
        }
        this.dag.complete();
        this.log("end findStrongComponents");
        return this.dag;
    }

    int dagIdToId(int n) {
        return this.dagIdToIds(n)[0];
    }

    int[] dagIdToIds(int n) {
        IntegerArray integerArray = new IntegerArray();
        int n2 = this.dag.idToIndex(n);
        int n3 = 0;
        while (n3 < this.size) {
            if (!this.deleted.get(n3) && this.dagIndex[n3] == n2) {
                integerArray.add(this.vertexIds.get(n3));
            }
            ++n3;
        }
        return integerArray.toArray();
    }

    boolean isRoot(int n) {
        return !this.dag.isNotRoot.get(this.dagIndex[n]);
    }

    Object dfs(Visitor visitor) {
        BitSet bitSet = new BitSet();
        Stack stack = new Stack();
        IntegerStack integerStack = new IntegerStack();
        visitor.init();
        int n = 0;
        while (n < this.size) {
            this.dfs(visitor, stack, integerStack, bitSet, n);
            ++n;
        }
        return visitor.result();
    }

    Object dfs(Visitor visitor, int n) {
        BitSet bitSet = new BitSet();
        return this.dfs(visitor, n, bitSet);
    }

    Object dfs(Visitor visitor, int n, BitSet bitSet) {
        Stack stack = new Stack();
        IntegerStack integerStack = new IntegerStack();
        visitor.init();
        this.dfs(visitor, stack, integerStack, bitSet, n);
        return visitor.result();
    }

    Object dfs(Visitor visitor, Stack stack, IntegerStack integerStack, BitSet bitSet, int n) {
        if (bitSet.get(n) || this.deleted.get(n)) {
            return visitor.result();
        }
        IntEnumeration intEnumeration = visitor.elements(n);
        visitor.enterNode(n, integerStack.depth());
        integerStack.push(n);
        stack.push(intEnumeration);
        bitSet.set(n);
        while (!integerStack.empty()) {
            int n2 = integerStack.peek();
            intEnumeration = (IntEnumeration)stack.peek();
            boolean bl = true;
            if (intEnumeration != null) {
                int n3;
                if (visitor.continueSearch(n2, integerStack.depth()) && intEnumeration.hasMoreElements()) {
                    n3 = intEnumeration.nextInt();
                    if (this.deleted.get(n3)) continue;
                    boolean bl2 = !bitSet.get(n3);
                    visitor.visitChild(n2, n3, bl2, integerStack.depth());
                    if (!bl2) continue;
                    bitSet.set(n3);
                    visitor.enterNode(n3, integerStack.depth());
                    intEnumeration = visitor.elements(n3);
                    integerStack.push(n3);
                    stack.push(intEnumeration);
                    bl = false;
                } else {
                    intEnumeration.reset();
                    while (intEnumeration.hasMoreElements()) {
                        n3 = intEnumeration.nextInt();
                        if (this.deleted.get(n3)) continue;
                        visitor.visitChildAtExit(n2, n3);
                    }
                }
            }
            if (!bl) continue;
            visitor.exitNode(n2);
            integerStack.pop();
            stack.pop();
        }
        return visitor.result();
    }

    void transitiveClosure() {
        this.log("begin transitiveClosure");
        this.vertexIds = null;
        Visitor visitor = new Visitor(){
            int[] tc;
            {
                this.tc = new int[NewGraph.this.size];
            }

            boolean ignoreDownEdges() {
                return true;
            }

            void visitChild(int n, int n2, boolean bl, int n3) {
                this.tc[n] = TreeBitSet.set(this.tc[n], n2);
            }

            void visitChildAtExit(int n, int n2) {
                if (this.tc[n2] != 0) {
                    this.tc[n] = TreeBitSet.or(this.tc[n], this.tc[n2]);
                }
            }

            void exitNode(int n) {
                this.tc[n] = TreeBitSet.close(this.tc[n]);
            }

            Object result() {
                return this.tc;
            }
        };
        BitSet bitSet = new BitSet();
        Stack stack = new Stack();
        IntegerStack integerStack = new IntegerStack();
        visitor.init();
        int n = 0;
        while (n < this.size) {
            if (!this.isNotRoot.get(n)) {
                this.dfs(visitor, stack, integerStack, bitSet, n);
            }
            ++n;
        }
        int[] nArray = (int[])visitor.result();
        this.log("calculate reachability");
        this.reach = new int[this.size];
        int n2 = 0;
        while (n2 < this.size) {
            if (nArray[n2] != 0) {
                if (this.exact || this.sizeMatters) {
                    IntEnumeration intEnumeration = TreeBitSet.elements(nArray[n2]);
                    while (intEnumeration.hasMoreElements()) {
                        int n3 = intEnumeration.nextInt();
                        int n4 = n2;
                        this.reach[n4] = this.reach[n4] + this.vertexSizes.get(n3);
                    }
                } else {
                    this.reach[n2] = TreeBitSet.numberOfElements(nArray[n2]);
                }
            }
            ++n2;
        }
        int n5 = 0;
        while (n5 < this.size) {
            TreeBitSet.free(nArray[n5]);
            ++n5;
        }
        this.log("end transitiveClosure");
    }

    void gc() {
        this.log("enter gc");
        System.gc();
        int n = 0;
        while (n < 1000) {
            byte[] byArray = new byte[100000];
            byArray[n] = (byte)(n << 1);
            if (byArray[99] == 33) {
                System.out.println("yes");
            }
            ++n;
        }
        System.gc();
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        this.log("exit gc");
    }

    void message(String string) {
        this.gc();
        this.log(string + ", bits heap usage " + TreeBitSet.usage() + " free " + TreeBitSet.freeMemory());
    }

    public void print(PrintClient printClient) {
        this.complete();
        this.message("begin analysis");
        this.client = printClient;
        this.log("number of vertexes = " + this.vertexIds.size());
        int n = 0;
        while (n < this.maxroots) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            System.out.println("*** doing root " + n + " ***");
            System.out.println("");
            this.findStrongComponents();
            this.dag.transitiveClosure();
            this.reach = new int[this.size];
            int n5 = 0;
            while (n5 < this.size) {
                this.reach[n5] = this.dag.reach[this.dagIndex[n5]];
                ++n5;
            }
            this.dag = null;
            this.message("after trans closure");
            int n6 = 0;
            while (n6 < this.vertexIds.size()) {
                n2 = this.reach[n6];
                if (n2 > n4) {
                    n4 = n2;
                    n3 = n6;
                }
                ++n6;
            }
            if (n4 == 0) {
                this.log("no more roots!");
                break;
            }
            n2 = this.vertexIds.get(n3);
            this.log("max reach = " + n4 + " for vertex " + Base.hex(n2) + " " + printClient.getName(n2));
            this.printTree(n3);
            this.deleteTree(n3);
            ++n;
        }
    }

    public NewGraph printLargestRoot(PrintClient printClient) {
        int n;
        this.complete();
        this.message("begin analysis");
        this.client = printClient;
        this.log("number of vertexes = " + this.vertexIds.size());
        int n2 = 0;
        int n3 = 0;
        this.findStrongComponents();
        this.dag.transitiveClosure();
        this.reach = new int[this.size];
        int n4 = 0;
        while (n4 < this.size) {
            this.reach[n4] = this.dag.reach[this.dagIndex[n4]];
            ++n4;
        }
        this.message("after trans closure");
        int n5 = 0;
        while (n5 < this.vertexIds.size()) {
            n = this.reach[n5];
            if (n > n3) {
                n3 = n;
                n2 = n5;
            }
            ++n5;
        }
        n = this.vertexIds.get(n2);
        this.log("max reach = " + n3 + " for vertex " + Base.hex(n) + " " + printClient.getName(n));
        this.printTree(n2);
        this.deleteTree(n2);
        return this.dag;
    }

    public void print(PrintClient printClient, int n) {
        this.complete();
        this.client = printClient;
        this.log("number of vertexes = " + this.vertexIds.size());
        this.findStrongComponents();
        this.dag.transitiveClosure();
        this.reach = new int[this.size];
        int n2 = 0;
        while (n2 < this.size) {
            this.reach[n2] = this.dag.reach[this.dagIndex[n2]];
            ++n2;
        }
        this.dag = null;
        this.printTree(this.idToIndex(n));
    }

    public Vertex[] getRoots() {
        this.complete();
        this.findStrongComponents();
        this.dag.transitiveClosure();
        this.reach = this.dag.reach;
        this.dag = null;
        Vector vector = new Vector();
        int n = 1;
        while (n < this.size) {
            if (this.isRoot(n)) {
                Vertex vertex = new Vertex(this, n);
                vector.add(vertex);
            }
            ++n;
        }
        return (Vertex[])vector.toArray(new Vertex[0]);
    }

    public void printDomTree(PrintClient printClient) {
        this.message("begin analysis");
        this.complete();
        this.client = printClient;
        this.findStrongComponents();
        this.message("after find strong components");
        int n = 1;
        while (n < this.size) {
            if (this.isRoot(n)) {
                this.addEdgeByIndex(0, n);
            }
            ++n;
        }
        NewGraph newGraph = this.findDominators();
        newGraph.deleted.set(0);
        newGraph.print(printClient);
    }

    static NewGraph random(int n, int n2, int n3) {
        Random random = new Random(n);
        NewGraph newGraph = new NewGraph();
        int n4 = 1;
        while (n4 <= n2) {
            newGraph.addVertex(n4, 0);
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            int n6;
            int n7 = random.nextInt(n2) + 1;
            if (n7 == (n6 = random.nextInt(n2) + 1)) continue;
            newGraph.addEdge(n7, n6);
            ++n5;
        }
        return newGraph;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < 1000) {
            System.out.println("doing " + n);
            NewGraph newGraph = NewGraph.random(17, 10000, 20000);
            newGraph.findStrongComponents();
            ++n;
        }
    }

    public static void xxxmain(String[] stringArray) {
        NewGraph newGraph = new NewGraph();
        newGraph.addEdge(0, 1);
        newGraph.addEdge(0, 2);
        newGraph.addEdge(1, 3);
        newGraph.addEdge(1, 6);
        newGraph.addEdge(2, 4);
        newGraph.addEdge(2, 7);
        newGraph.addEdge(3, 5);
        newGraph.addEdge(3, 6);
        newGraph.addEdge(4, 2);
        newGraph.addEdge(4, 7);
        newGraph.addEdge(5, 8);
        newGraph.addEdge(5, 10);
        newGraph.addEdge(6, 9);
        newGraph.addEdge(7, 12);
        newGraph.addEdge(8, 11);
        newGraph.addEdge(9, 8);
        newGraph.addEdge(10, 11);
        newGraph.addEdge(11, 12);
        newGraph.addEdge(11, 1);
        newGraph.print(new PrintClient(){
            char[] ids = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm'};

            public String getName(int n) {
                return "" + this.ids[n];
            }
        });
        System.exit(1);
        newGraph.client = new PrintClient(){
            char[] ids = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm'};

            public String getName(int n) {
                return "" + this.ids[n];
            }
        };
        System.out.println(newGraph);
    }

    public String toString() {
        String string = (String)this.dfs(new Visitor(){
            StringBuffer buff = new StringBuffer();

            void visitChild(int n, int n2, boolean bl, int n3) {
                String string = NewGraph.this.client.getName(NewGraph.this.vertexIds.get(n));
                String string2 = NewGraph.this.client.getName(NewGraph.this.vertexIds.get(n2));
                this.buff.append("    " + string + " -> " + string2 + ";\n");
            }

            Object result() {
                return this.buff.toString();
            }
        }, 0);
        return "digraph G {\n" + string + "}";
    }

    public void check() {
    }

    public void activate() {
    }

    public boolean active() {
        return true;
    }

    static {
        doFreeze = false;
    }

    abstract class Visitor {
        Visitor() {
        }

        void init() {
        }

        void enterNode(int n, int n2) {
        }

        boolean continueSearch(int n, int n2) {
            return true;
        }

        void visitChild(int n, int n2, boolean bl, int n3) {
        }

        void visitChildAtExit(int n, int n2) {
        }

        void exitNode(int n) {
        }

        boolean ignoreDownEdges() {
            return false;
        }

        Object result() {
            return null;
        }

        boolean sort() {
            return false;
        }

        int getCount(int n) {
            return 0;
        }

        IntEnumeration elements(int n) {
            IntEnumeration intEnumeration = null;
            int n2 = NewGraph.this.edges.get(n);
            if (n2 != 0) {
                intEnumeration = TreeBitSet.elements(n2);
                if (this.sort()) {
                    SortedIntEnumeration sortedIntEnumeration = new SortedIntEnumeration();
                    while (intEnumeration.hasMoreElements()) {
                        int n3 = intEnumeration.nextInt();
                        int n4 = this.getCount(n3);
                        sortedIntEnumeration.add(n3, n4);
                    }
                    sortedIntEnumeration.sort();
                    intEnumeration = sortedIntEnumeration;
                }
            }
            return intEnumeration;
        }
    }
}

