/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.PrintBase;
import com.ibm.jvm.findroots.ReachabilityGraph;

public class PrintDomTree
extends PrintBase {
    int rootId;

    public static void main(String[] stringArray) {
        PrintDomTree printDomTree = new PrintDomTree();
        printDomTree.start(stringArray, "PrintDomTree");
    }

    String[] options() {
        return new String[]{"-root <id>"};
    }

    String[] optionDescriptions() {
        return new String[]{"\tSpecify the id to use as the root"};
    }

    public boolean parseOption(String string, String string2) {
        if ("-root".equals(string)) {
            try {
                this.rootId = Integer.parseInt(string2, 16);
            }
            catch (Exception exception) {
                System.err.println(string2 + " is not a valid number");
                this.usage();
            }
            return true;
        }
        return super.parseOption(string, string2);
    }

    protected void parseStart() {
        this.graph.idToIndex(0);
    }

    protected void parseEnd() {
        super.parseEnd();
        if (this.rootId == 0) {
            this.log("go find the biggest root");
            this.rootId = this.graph.getBiggestRoot();
            this.log("biggest root = " + Base.hex(this.rootId));
        }
        this.graph = (ReachabilityGraph)this.graph.getSubgraph(this.rootId);
        ReachabilityGraph reachabilityGraph = this.graph.findDominators(this.rootId);
        this.graph = null;
        reachabilityGraph.print(this);
    }
}

