/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.PrintBase;
import com.ibm.jvm.findroots.ReachabilityGraph;

public class PrintTree
extends PrintBase {
    int root = -1;
    int maxdepth = 50;
    int prune = 100;
    boolean inverse;

    public static void main(String[] stringArray) {
        PrintTree printTree = new PrintTree();
        printTree.start(stringArray, "PrintTree");
    }

    String[] options() {
        return new String[]{"-root <n>", "-inverse"};
    }

    String[] optionDescriptions() {
        return new String[]{"\tSpecify which root to print (in hex)", "\tPrint the inverse tree (ie print the parents and their parents etc)"};
    }

    public boolean parseOption(String string, String string2) {
        if ("-root".equals(string)) {
            try {
                this.root = Integer.parseInt(string2, 16);
            }
            catch (Exception exception) {
                System.err.println(string2 + " is not a valid number");
                this.usage();
            }
            return true;
        }
        if ("-inverse".equals(string)) {
            this.inverse = true;
            return true;
        }
        return super.parseOption(string, string2);
    }

    protected void parseStart() {
        if (this.root == -1) {
            this.usage();
        }
        this.log("begin parsing");
    }

    protected void parseEnd() {
        super.parseEnd();
        this.log("finished parsing");
        if (this.inverse) {
            this.graph = (ReachabilityGraph)this.graph.inverse(new ReachabilityGraph());
            this.log("finished inverse");
        }
        this.graph.print(this, this.root);
    }
}

