/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.PrintClient;
import com.ibm.jvm.findroots.ReachabilityGraph;
import com.ibm.jvm.findroots.SimpleGraph;
import com.ibm.jvm.findroots.StrongComponentsGraph;
import com.ibm.jvm.findroots.Vertex;
import com.ibm.jvm.findroots.Visitor;
import com.ibm.jvm.util.IntEnumeration;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.IntegerStack;
import com.ibm.jvm.util.SvcdumpProperties;
import com.ibm.jvm.util.TreeBitSet;
import java.util.BitSet;
import java.util.Vector;

public final class ReachabilityGraph
extends SimpleGraph {
    int[] dagIndex;
    int[] reach;
    StrongComponentsGraph dag;
    BitSet visited;
    int maxdepth = SvcdumpProperties.getIntProperty("findroots.depth", 1000);
    int maxroots = 20;
    int prune = SvcdumpProperties.getIntProperty("findroots.prune", this.sizeMatters ? 10000 : 1000);
    boolean exact = false;
    boolean uselessmemory = false;
    boolean calculateReachability = true;

    public ReachabilityGraph() {
        this.maxroots = SvcdumpProperties.getIntProperty("findroots.maxroots", 20);
        this.exact = SvcdumpProperties.getBooleanProperty("findroots.exact", false);
        this.uselessmemory = SvcdumpProperties.getBooleanProperty("findroots.uselessmemory", false);
        this.calculateReachability = SvcdumpProperties.getBooleanProperty("findroots.calculate.reachability", true);
    }

    String className() {
        return "ReachabilityGraph";
    }

    public int reachFrom(int n) {
        if (this.visited == null) {
            this.visited = new BitSet();
        }
        return this.reachFrom(n, this.visited);
    }

    public int reachFrom(Vertex vertex) {
        return this.reachFrom(vertex.id());
    }

    public boolean reachGreaterThan(Vertex vertex, int n) {
        this.complete();
        class ReachVisitor
        extends Visitor {
            int n;
            boolean greater;
            int target;
            private final /* synthetic */ ReachabilityGraph this$0;

            ReachVisitor(ReachabilityGraph reachabilityGraph, int n) {
                this.this$0 = reachabilityGraph;
                this.n = 0;
                this.target = n;
            }

            public boolean continueSearch(int n, int n2) {
                return !this.greater;
            }

            public void enterNode(int n, int n2) {
                if (++this.n > this.target) {
                    this.greater = true;
                }
            }

            public Object result() {
                return new Boolean(this.greater);
            }
        }
        Boolean bl = (Boolean)this.dfs(new ReachVisitor(this, n), vertex.index);
        return bl;
    }

    public int reachableVertices(int n) {
        Base.Assert(false);
        return 0;
    }

    public int reachableSize(int n) {
        Base.Assert(false);
        return 0;
    }

    void printNode(int n, int n2, boolean bl) {
        int n3 = this.vertexIds.get(n);
        int n4 = 0;
        while (n4 < n2) {
            System.out.print("   ");
            ++n4;
        }
        if (this.reach == null) {
            System.out.println("0x" + Base.hex(n3) + " " + this.client.getName(n3) + (bl ? "" : " (already visited)"));
        } else {
            System.out.println(this.reach[n] + " 0x" + Base.hex(n3) + " " + this.client.getName(n3) + (bl ? "" : " (already visited)"));
        }
    }

    void printTree(int n) {
        this.complete();
        this.log("begin printTree");
        this.printNode(n, 0, true);
        this.dfs(new Visitor(){
            int count = 0;

            public void visitChild(int n, int n2, boolean bl, int n3) {
                if (ReachabilityGraph.this.reach != null && ReachabilityGraph.this.reach[n2] < ReachabilityGraph.this.prune) {
                    return;
                }
                ReachabilityGraph.this.printNode(n2, n3, bl);
            }

            public boolean continueSearch(int n, int n2) {
                return n2 < ReachabilityGraph.this.maxdepth && (ReachabilityGraph.this.reach == null ? true : ReachabilityGraph.this.reach[n] > ReachabilityGraph.this.prune);
            }

            public int getCount(int n) {
                return ReachabilityGraph.this.reach == null ? 0 : ReachabilityGraph.this.reach[n];
            }

            public boolean sort() {
                return true;
            }
        }, n);
        this.log("end printTree");
    }

    ReachabilityGraph findDominators(int n) {
        this.calculateImmediateDominators(n);
        ReachabilityGraph reachabilityGraph = new ReachabilityGraph();
        int n2 = 0;
        while (n2 < this.size) {
            reachabilityGraph.idToIndex(this.vertexIds.get(n2));
            ++n2;
        }
        int n3 = this.idToIndex(n);
        int n4 = 0;
        while (n4 < this.size) {
            if (n4 != n3) {
                int n5 = this.vertexIds.get(this.idom[n4]);
                int n6 = this.vertexIds.get(n4);
                reachabilityGraph.addEdge(n5, n6);
                reachabilityGraph.vertexSizes.put(n4, this.vertexSizes.get(n4));
            }
            ++n4;
        }
        reachabilityGraph.complete();
        return reachabilityGraph;
    }

    StrongComponentsGraph findStrongComponents() {
        int n;
        this.log("begin findStrongComponents");
        int[] nArray = (int[])this.dfs(new Visitor(){
            IntegerStack s = new IntegerStack();
            IntegerStack path = new IntegerStack();
            int[] pre;
            int[] sc;
            int cnt0;
            int cnt1;
            {
                this.pre = new int[ReachabilityGraph.this.size];
                this.sc = new int[ReachabilityGraph.this.size];
                this.cnt0 = 0;
                this.cnt1 = 1;
            }

            public void init() {
                int n = 0;
                while (n < ReachabilityGraph.this.size) {
                    this.sc[n] = -1;
                    ++n;
                }
            }

            public void enterNode(int n, int n2) {
                ++this.cnt0;
                this.s.push(n);
                this.path.push(n);
            }

            public void visitChild(int n, int n2, boolean bl, int n3) {
                if (!bl && this.sc[n2] == -1) {
                    while (this.pre[this.path.peek()] > this.pre[n2]) {
                        this.path.pop();
                    }
                }
            }

            public void exitNode(int n) {
                if (this.path.peek() == n) {
                    int n2;
                    this.path.pop();
                    do {
                        n2 = this.s.pop();
                        this.sc[n2] = this.cnt1++;
                    } while (n2 != n);
                }
            }

            public Object result() {
                return this.sc;
            }
        });
        this.log("create dag");
        this.dag = new StrongComponentsGraph();
        this.dagIndex = new int[this.size];
        this.dag.idToIndex(0);
        this.dag.isNotRoot.set(0);
        int n2 = 0;
        while (n2 < this.size) {
            if (!this.deleted.get(n2)) {
                int n3;
                n = this.edges.get(n2);
                this.dagIndex[n2] = n3 = this.dag.idToIndex(nArray[n2]);
                this.dag.vertexSizes.put(n3, this.dag.vertexSizes.get(n3) + this.vertexSizes.get(n2));
                this.dag.dagSizes.put(n3, this.dag.dagSizes.get(n3) + 1);
                if (n != 0) {
                    IntEnumeration intEnumeration = TreeBitSet.elements(n);
                    while (intEnumeration.hasMoreElements()) {
                        int n4 = intEnumeration.nextInt();
                        this.dagIndex[n4] = this.dag.idToIndex(nArray[n4]);
                        if (nArray[n2] == nArray[n4]) continue;
                        this.dag.addEdge(nArray[n2], nArray[n4]);
                        this.dag.isNotRoot.set(this.dagIndex[n4]);
                    }
                }
            }
            ++n2;
        }
        n = 1;
        while (n < this.dag.size) {
            this.dag.vertexSizes.put(n, this.dag.vertexSizes.get(n) - 1);
            if (!this.dag.isNotRoot.get(n)) {
                this.dag.addEdgeByIndex(0, n);
            }
            ++n;
        }
        this.dag.complete();
        this.log("end findStrongComponents");
        return this.dag;
    }

    int dagIdToId(int n) {
        return this.dagIdToIds(n)[0];
    }

    int[] dagIdToIds(int n) {
        IntegerArray integerArray = new IntegerArray();
        int n2 = this.dag.idToIndex(n);
        int n3 = 0;
        while (n3 < this.size) {
            if (!this.deleted.get(n3) && this.dagIndex[n3] == n2) {
                integerArray.add(this.vertexIds.get(n3));
            }
            ++n3;
        }
        return integerArray.toArray();
    }

    boolean isRoot(int n) {
        return !this.dag.isNotRoot.get(this.dagIndex[n]);
    }

    public void print(PrintClient printClient) {
        this.complete();
        this.log("begin analysis");
        this.client = printClient;
        this.log("number of vertexes = " + this.vertexIds.size());
        int n = 0;
        while (n < this.maxroots) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            if (n > 0) {
                System.out.println("");
            }
            System.out.println("*** doing root " + n + " ***");
            System.out.println("");
            this.findStrongComponents();
            this.dag.transitiveClosure();
            this.reach = new int[this.size];
            int n5 = 0;
            while (n5 < this.size) {
                this.reach[n5] = this.dag.reach[this.dagIndex[n5]];
                ++n5;
            }
            this.dag = null;
            this.log("after trans closure");
            int n6 = 0;
            while (n6 < this.vertexIds.size()) {
                n2 = this.reach[n6];
                if (n2 > n4) {
                    n4 = n2;
                    n3 = n6;
                }
                ++n6;
            }
            if (n4 == 0) {
                this.log("no more roots!");
                break;
            }
            n2 = this.vertexIds.get(n3);
            this.log("max reach = " + n4 + " for vertex " + Base.hex(n2) + " " + printClient.getName(n2));
            this.printTree(n3);
            this.deleteTree(n3);
            ++n;
        }
    }

    public void print(PrintClient printClient, int n) {
        this.complete();
        this.client = printClient;
        this.log("number of vertexes = " + this.vertexIds.size());
        if (this.calculateReachability) {
            this.findStrongComponents();
            this.dag.transitiveClosure();
            this.reach = new int[this.size];
            int n2 = 0;
            while (n2 < this.size) {
                this.reach[n2] = this.dag.reach[this.dagIndex[n2]];
                ++n2;
            }
            this.dag = null;
        }
        this.printTree(this.idToIndex(n));
    }

    public Vertex[] getRoots() {
        this.complete();
        this.findStrongComponents();
        this.dag.transitiveClosure();
        this.reach = this.dag.reach;
        Vector vector = new Vector();
        int n = 1;
        while (n < this.size) {
            if (this.isRoot(n)) {
                Vertex vertex = new Vertex(this, n);
                vector.add(vertex);
            }
            ++n;
        }
        return (Vertex[])vector.toArray(new Vertex[0]);
    }

    int getBiggestRoot() {
        this.findStrongComponents();
        this.dag.transitiveClosure();
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.size) {
            int n4 = this.dag.reach[this.dagIndex[n3]];
            if (n4 > n) {
                n = n4;
                n2 = n3;
            }
            ++n3;
        }
        if (n2 == -1) {
            return -1;
        }
        return this.id(n2);
    }

    public static void main(String[] stringArray) {
        Object object;
        int n = 1;
        while (n < 1) {
            ReachabilityGraph reachabilityGraph = new ReachabilityGraph();
            reachabilityGraph.setRecordParents(true);
            reachabilityGraph.random(n, 100, 150);
            int n2 = reachabilityGraph.getBiggestRoot();
            if (n2 != -1) {
                reachabilityGraph = (ReachabilityGraph)reachabilityGraph.getSubgraph(n2);
                int n3 = reachabilityGraph.idToIndex(n2);
                Integer n4 = (Integer)reachabilityGraph.dfs(new Visitor(){
                    int n = -1;

                    public void enterNode(int n, int n2) {
                        this.n = n;
                    }

                    public Object result() {
                        return new Integer(this.n);
                    }
                }, n3);
                int n5 = reachabilityGraph.vertexIds.get(n4);
                TreeBitSet treeBitSet = reachabilityGraph.findDominators(n2, n5);
                object = reachabilityGraph.getDominators(n2, n5);
                IntEnumeration intEnumeration = treeBitSet.elements();
                while (intEnumeration.hasMoreElements()) {
                    int n6 = intEnumeration.nextInt();
                    n6 = reachabilityGraph.vertexIds.get(n6);
                }
                IntEnumeration intEnumeration2 = ((TreeBitSet)object).elements();
                while (intEnumeration2.hasMoreElements()) {
                    int n7 = intEnumeration2.nextInt();
                    n7 = reachabilityGraph.vertexIds.get(n7);
                }
                if (!treeBitSet.equals(object)) {
                    throw new Error("no match!");
                }
                System.out.println("done " + n);
            }
            ++n;
        }
        int n8 = 1;
        while (true) {
            ReachabilityGraph reachabilityGraph = new ReachabilityGraph();
            reachabilityGraph.random(n8, 10000, 15000);
            reachabilityGraph.findStrongComponents();
            reachabilityGraph.dag.uselessmemory = false;
            reachabilityGraph.dag.exact = true;
            long l = System.currentTimeMillis();
            reachabilityGraph.dag.transitiveClosure();
            long l2 = System.currentTimeMillis();
            object = reachabilityGraph.dag.reach;
            reachabilityGraph.dag.uselessmemory = true;
            reachabilityGraph.dag.transitiveClosure();
            long l3 = System.currentTimeMillis();
            int[] nArray = reachabilityGraph.dag.reach;
            int n9 = 0;
            while (n9 < reachabilityGraph.dag.size) {
                if (!reachabilityGraph.dag.ignoreNode(n9) && object[n9] != nArray[n9]) {
                    throw new Error("mismatch at " + n9 + "! " + (int)object[n9] + " compared with " + nArray[n9]);
                }
                ++n9;
            }
            System.out.println("done " + n8 + " fast took " + (l2 - l) + " millis, slow took " + (l3 - l2));
            ++n8;
        }
    }
}

