/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.CompareVisitor;
import com.ibm.jvm.findroots.Edges;
import com.ibm.jvm.findroots.PrintClient;
import com.ibm.jvm.findroots.SimpleGraph;
import com.ibm.jvm.findroots.Vertex;
import com.ibm.jvm.findroots.Visitor;
import com.ibm.jvm.util.IntEnumeration;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.IntegerStack;
import com.ibm.jvm.util.SortedIntEnumeration;
import com.ibm.jvm.util.SvcdumpProperties;
import com.ibm.jvm.util.TreeBitSet;
import com.ibm.jvm.util.html.Document;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Random;
import java.util.Stack;

public class SimpleGraph
extends Base {
    IntegerArray vertexIds = new IntegerArray();
    IntegerArray vertexIndexes = new IntegerArray();
    IntegerArray vertexSizes = new IntegerArray();
    IntegerArray orderedVertexIds;
    Edges edges = new Edges();
    HashMap indexCache;
    int size;
    BitSet deleted = new BitSet();
    int lowestId = Integer.MAX_VALUE;
    int highestId = 0;
    boolean recordParents;
    Edges parents;
    boolean complete;
    boolean sizeMatters;
    Document doc = new Document();
    BitSet isValid;
    int[] idom;
    PrintClient client;
    HashMap frozenObjects = new HashMap();

    public SimpleGraph() {
        this.doc.setPlainText(!SvcdumpProperties.getBooleanProperty("svcdump.output.html", false));
        this.sizeMatters = SvcdumpProperties.getBooleanProperty("findroots.sizematters", false);
    }

    public SimpleGraph inverse(SimpleGraph simpleGraph) {
        this.complete();
        int n = 0;
        while (n < this.size) {
            int n2 = this.vertexIds.get(n);
            int n3 = this.edges.get(n);
            IntEnumeration intEnumeration = TreeBitSet.elements(n3);
            while (intEnumeration.hasMoreElements()) {
                int n4 = intEnumeration.nextInt();
                simpleGraph.addEdge(this.vertexIds.get(n4), n2);
            }
            ++n;
        }
        simpleGraph.complete();
        return simpleGraph;
    }

    public int reachFrom(int n, BitSet bitSet) {
        this.complete();
        int n2 = this.idToIndex(n);
        Integer n3 = (Integer)this.dfs(new Visitor(){
            int n = 0;

            public void enterNode(int n, int n2) {
                this.n += SimpleGraph.this.vertexSizes.get(n);
            }

            public Object result() {
                return new Integer(this.n);
            }
        }, n2, bitSet);
        return n3;
    }

    public void setPrintClient(PrintClient printClient) {
        this.client = printClient;
    }

    String className() {
        return "SimpleGraph";
    }

    public int getSize(int n) {
        this.complete();
        int n2 = this.idToIndex(n);
        return this.vertexSizes.get(n2);
    }

    public void setSize(int n, int n2) {
        this.complete();
        int n3 = this.idToIndex(n);
        this.vertexSizes.put(n3, n2);
    }

    public IntEnumeration getChildren(int n) {
        int n2 = this.idToIndex(n);
        Base.Assert(n2 >= 0);
        int n3 = this.edges.get(n2);
        IntEnumeration intEnumeration = TreeBitSet.elements(n3);
        class WrapIntEnumeration
        implements IntEnumeration {
            IntEnumeration e;
            private final /* synthetic */ SimpleGraph this$0;

            WrapIntEnumeration(SimpleGraph simpleGraph, IntEnumeration intEnumeration) {
                this.this$0 = simpleGraph;
                this.e = intEnumeration;
            }

            public boolean hasMoreElements() {
                return this.e.hasMoreElements();
            }

            public Object nextElement() {
                return new Integer(this.nextInt());
            }

            public int nextInt() {
                int n = this.e.nextInt();
                return this.this$0.vertexIds.get(n);
            }

            public void reset() {
                this.e.reset();
            }
        }
        return new WrapIntEnumeration(this, intEnumeration);
    }

    public boolean isLeaf(int n) {
        return this.getChildCount(n) == 0;
    }

    public int getChildCount(int n) {
        int n2 = this.idToIndex(n);
        int n3 = this.edges.get(n2);
        return TreeBitSet.numberOfElements(n3);
    }

    public SimpleGraph newInstance() {
        try {
            return (SimpleGraph)this.getClass().newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public SimpleGraph getSubgraph(int n) {
        this.complete();
        int n2 = this.idToIndex(n);
        Base.Assert(n2 >= 0);
        SimpleGraph simpleGraph = (SimpleGraph)this.dfs(new Visitor(){
            SimpleGraph subgraph;

            public void init() {
                this.subgraph = SimpleGraph.this.newInstance();
                this.subgraph.setRecordParents(true);
            }

            public void visitChildAtExit(int n, int n2) {
                int n3 = SimpleGraph.this.vertexIds.get(n2);
                int n4 = SimpleGraph.this.vertexIds.get(n);
                this.subgraph.addVertex(n3, SimpleGraph.this.vertexSizes.get(n2));
                this.subgraph.addVertex(n4, SimpleGraph.this.vertexSizes.get(n));
                this.subgraph.addEdge(n4, n3);
            }

            public Object result() {
                return this.subgraph;
            }
        }, n2);
        simpleGraph.complete();
        this.log("subgraph returned, size " + simpleGraph.size + " our size " + this.size);
        return simpleGraph;
    }

    int ancestorWithLowestSemi(int n, int[] nArray, BitSet bitSet, int[] nArray2, int[] nArray3) {
        int n2 = n;
        while (bitSet.get(n)) {
            if (nArray2[nArray3[n]] < nArray2[nArray3[n2]]) {
                n2 = n;
            }
            n = nArray[n];
        }
        return n2;
    }

    void link(int n, int n2, BitSet bitSet) {
        bitSet.set(n2);
    }

    TreeBitSet findDominators(int n, int n2) {
        this.calculateImmediateDominators(n);
        int n3 = this.idToIndex(n2);
        TreeBitSet treeBitSet = new TreeBitSet();
        int n4 = this.idom[n3];
        while (n4 >= 0) {
            treeBitSet.set(n4);
            n4 = this.idom[n4];
        }
        return treeBitSet;
    }

    void calculateImmediateDominators(int n) {
        int n2;
        int n3;
        if (this.idom != null) {
            return;
        }
        this.log("begin calculateImmediateDominators");
        this.complete();
        int n4 = this.idToIndex(n);
        this.idom = new int[this.size];
        int[] nArray = new int[this.size];
        int[] nArray2 = new int[this.size];
        int[] nArray3 = new int[this.size];
        int[] nArray4 = new int[this.size];
        int[] nArray5 = new int[this.size];
        int[] nArray6 = new int[this.size];
        BitSet bitSet = new BitSet();
        int n5 = 0;
        while (n5 < this.size) {
            this.idom[n5] = -1;
            nArray5[n5] = -1;
            ++n5;
        }
        class AssignDfnum
        extends Visitor {
            int N;
            int[] dfnum;
            int[] vertex;
            int[] parent;
            int[] pre;
            private final /* synthetic */ SimpleGraph this$0;

            AssignDfnum(SimpleGraph simpleGraph, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
                this.this$0 = simpleGraph;
                this.N = 1;
                this.dfnum = nArray;
                this.vertex = nArray2;
                this.parent = nArray3;
                this.pre = nArray4;
            }

            public void visitChild(int n, int n2, boolean bl, int n3) {
                if (bl) {
                    this.dfnum[n2] = this.N;
                    this.vertex[this.N] = n2;
                    this.parent[n2] = n;
                    ++this.N;
                }
                this.pre[n2] = TreeBitSet.set(this.pre[n2], n);
            }

            public Object result() {
                return null;
            }
        }
        this.dfs(new AssignDfnum(this, nArray, nArray2, nArray3, nArray4), n4);
        nArray2[0] = n4;
        int n6 = this.size - 1;
        while (n6 >= 0) {
            n3 = nArray2[n6];
            if (n3 != n4) {
                int n7;
                int n8 = n2 = nArray3[n3];
                IntEnumeration intEnumeration = TreeBitSet.elements(nArray4[n3]);
                while (intEnumeration.hasMoreElements()) {
                    int n9 = intEnumeration.nextInt();
                    n7 = nArray[n9] <= nArray[n3] ? n9 : nArray5[this.ancestorWithLowestSemi(n9, nArray3, bitSet, nArray, nArray5)];
                    if (nArray[n7] >= nArray[n8]) continue;
                    n8 = n7;
                }
                nArray5[n3] = n8;
                nArray6[n8] = TreeBitSet.set(nArray6[n8], n3);
                this.link(n2, n3, bitSet);
                IntEnumeration intEnumeration2 = TreeBitSet.elements(nArray6[n2]);
                while (intEnumeration2.hasMoreElements()) {
                    n7 = intEnumeration2.nextInt();
                    int n10 = this.ancestorWithLowestSemi(n7, nArray3, bitSet, nArray, nArray5);
                    this.idom[n7] = nArray5[n10] == nArray5[n7] ? n2 : n10 | Integer.MIN_VALUE;
                }
                TreeBitSet.free(nArray6[n2]);
                nArray6[n2] = 0;
            }
            --n6;
        }
        n3 = 0;
        while (n3 < this.size) {
            n2 = nArray2[n3];
            if (n2 != n4 && this.idom[n2] < 0) {
                Base.Assert(this.idom[n2] != -1);
                this.idom[n2] = this.idom[this.idom[n2] & Integer.MAX_VALUE];
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.size) {
            TreeBitSet.free(nArray4[n2]);
            ++n2;
        }
    }

    public int id(int n) {
        return this.vertexIds.get(n);
    }

    String getMemberIds(int n) {
        boolean bl = true;
        String string = "";
        IntEnumeration intEnumeration = TreeBitSet.elements(n);
        while (intEnumeration.hasMoreElements()) {
            int n2 = intEnumeration.nextInt();
            string = bl ? "" + this.id(n2) : string + " " + this.id(n2);
            bl = false;
        }
        return string;
    }

    public TreeBitSet getDominators(int n, int n2) {
        int n3;
        this.complete();
        int n4 = this.idToIndex(n);
        Base.Assert(n4 >= 0);
        IntegerArray integerArray = (IntegerArray)this.dfs(new Visitor(){
            IntegerArray reversePostOrder = new IntegerArray();

            public void exitNode(int n) {
                this.reversePostOrder.add(n);
            }

            public Object result() {
                return this.reversePostOrder;
            }
        }, n4);
        int[] nArray = new int[this.size];
        nArray[n4] = TreeBitSet.set(0, n4);
        BitSet bitSet = new BitSet();
        int n5 = 0;
        while (n5 < this.size) {
            if (n5 != n4) {
                bitSet.set(n5);
                nArray[n5] = TreeBitSet.setAll(0, this.size);
            }
            ++n5;
        }
        boolean bl = false;
        int n6 = 0;
        do {
            int n7 = 0;
            bl = false;
            int n8 = this.size - 1;
            while (n8 >= 0) {
                if (n8 != n4) {
                    int n9;
                    n3 = this.parents.get(n8);
                    boolean bl2 = false;
                    IntEnumeration intEnumeration = TreeBitSet.elements(n3);
                    while (intEnumeration.hasMoreElements()) {
                        n9 = intEnumeration.nextInt();
                        if (!bitSet.get(n9)) continue;
                        bl2 = true;
                        break;
                    }
                    if (n6 == 0 || bl2) {
                        n9 = -1;
                        IntEnumeration intEnumeration2 = TreeBitSet.elements(n3);
                        while (intEnumeration2.hasMoreElements()) {
                            int n10 = intEnumeration2.nextInt();
                            n9 = n9 == -1 ? TreeBitSet.clone(nArray[n10]) : TreeBitSet.and(n9, nArray[n10]);
                        }
                        if (n9 == -1) {
                            n9 = 0;
                        }
                        if (!TreeBitSet.equals(nArray[n8], n9 = TreeBitSet.set(n9, n8))) {
                            TreeBitSet.free(nArray[n8]);
                            nArray[n8] = n9;
                            bitSet.set(n8);
                            bl = true;
                            ++n7;
                        } else {
                            TreeBitSet.free(n9);
                            bitSet.clear(n8);
                        }
                    }
                }
                --n8;
            }
            ++n6;
        } while (bl);
        TreeBitSet treeBitSet = new TreeBitSet();
        n4 = this.idToIndex(n2);
        IntEnumeration intEnumeration = TreeBitSet.elements(nArray[n4]);
        while (intEnumeration.hasMoreElements()) {
            n3 = intEnumeration.nextInt();
            if (n3 == n4) continue;
            treeBitSet.set(n3);
        }
        return treeBitSet;
    }

    public int[] getReferences(int n) {
        this.complete();
        int n2 = this.idToIndex(n);
        Base.Assert(n2 >= 0);
        int n3 = this.edges.get(n2);
        int[] nArray = new int[TreeBitSet.numberOfElements(n3)];
        int n4 = 0;
        IntEnumeration intEnumeration = TreeBitSet.elements(n3);
        while (intEnumeration.hasMoreElements()) {
            int n5 = intEnumeration.nextInt();
            nArray[n4++] = this.vertexIds.get(n5);
        }
        return nArray;
    }

    void freeze(Object object, String string) {
        this.log("freeze " + string);
        try {
            File file = File.createTempFile("tmp", ".freeze");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            this.frozenObjects.put(string, file);
            this.log("freeze " + string + " complete");
        }
        catch (Exception exception) {
            throw new Error("Error freezing object: " + exception);
        }
    }

    Object unfreeze(String string) {
        this.log("unfreeze " + string);
        try {
            File file = (File)this.frozenObjects.get(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            this.frozenObjects.remove(string);
            file.delete();
            this.log("unfreeze " + string + " complete");
            return object;
        }
        catch (Exception exception) {
            throw new Error("Error unfreezing object: " + exception);
        }
    }

    void addEdgeByIndex(int n, int n2) {
        this.edges.put(n, TreeBitSet.set(this.edges.get(n), n2));
    }

    public void addEdge(int n, int n2) {
        int n3 = this.idToIndex(n);
        int n4 = this.idToIndex(n2);
        this.edges.put(n3, TreeBitSet.set(this.edges.get(n3), n4));
        if (this.recordParents) {
            this.parents.put(n4, TreeBitSet.set(this.parents.get(n4), n3));
        }
    }

    void flushCache() {
        if (this.indexCache == null) {
            return;
        }
        Integer[] integerArray = (Integer[])this.indexCache.keySet().toArray(new Integer[0]);
        int n = 0;
        while (n < integerArray.length) {
            Integer n2 = (Integer)this.indexCache.get(integerArray[n]);
            this.vertexIndexes.add(n2);
            this.vertexIds.add(integerArray[n]);
            ++n;
        }
        this.vertexIds.sort(this.vertexIndexes);
        this.indexCache = null;
    }

    public void complete() {
        if (!this.complete) {
            this.flushCache();
            this.vertexIndexes.sort(this.vertexIds);
            this.vertexIndexes = null;
            if (this.isValid != null) {
                int n = 0;
                while (n < this.size) {
                    if (!this.isValid.get(n) && Base.verbose()) {
                        System.out.println("warning: found invalid ref 0x" + Base.hex(this.vertexIds.get(n)));
                    }
                    ++n;
                }
            }
            this.complete = true;
        }
    }

    void createSlot() {
        this.edges.add(0);
        if (this.recordParents) {
            this.parents.add(0);
        }
        this.vertexSizes.add(1);
    }

    public int idToIndex(int n) {
        int n2;
        if (this.complete) {
            int n3;
            if (this.orderedVertexIds == null) {
                this.orderedVertexIds = new IntegerArray();
                this.vertexIndexes = new IntegerArray();
                n3 = 0;
                while (n3 < this.vertexIds.size()) {
                    this.orderedVertexIds.add(this.vertexIds.get(n3));
                    this.vertexIndexes.add(n3);
                    ++n3;
                }
                this.orderedVertexIds.sort(this.vertexIndexes);
            }
            if ((n3 = this.orderedVertexIds.indexOf(n)) == -1) {
                System.out.println("warning! could not find id " + Base.hex(n));
            }
            return this.vertexIndexes.get(n3);
        }
        int n4 = -1;
        if (this.size > 0) {
            float f = ((float)n - (float)this.lowestId) / ((float)this.highestId - (float)this.lowestId);
            n4 = (int)(f *= (float)this.size);
        }
        if ((n2 = this.vertexIds.indexOf(n, n4)) == -1) {
            Integer n5;
            Integer n6 = new Integer(n);
            if (this.indexCache == null) {
                this.indexCache = new HashMap();
            }
            if ((n5 = (Integer)this.indexCache.get(n6)) == null) {
                this.createSlot();
                n2 = this.vertexIds.size() + this.indexCache.size();
                n5 = new Integer(n2);
                this.indexCache.put(n6, n5);
                if (this.indexCache.size() == 500000) {
                    this.flushCache();
                }
                if (n < this.lowestId) {
                    this.lowestId = n;
                } else if (n > this.highestId) {
                    this.highestId = n;
                }
                ++this.size;
            } else {
                n2 = n5;
            }
        } else {
            n2 = this.vertexIndexes.get(n2);
        }
        return n2;
    }

    public void setRecordParents(boolean bl) {
        this.recordParents = bl;
        this.parents = new Edges();
    }

    public int[] getParents(int n) {
        Base.Assert(this.recordParents);
        this.complete();
        int n2 = this.idToIndex(n);
        int n3 = this.parents.get(n2);
        int[] nArray = new int[TreeBitSet.numberOfElements(n3)];
        int n4 = 0;
        IntEnumeration intEnumeration = TreeBitSet.elements(n3);
        while (intEnumeration.hasMoreElements()) {
            int n5 = intEnumeration.nextInt();
            nArray[n4++] = this.vertexIds.get(n5);
        }
        return nArray;
    }

    public int pruneLeaves() {
        Base.Assert(this.recordParents);
        this.complete();
        int n = 0;
        int n2 = 0;
        while (n2 < this.size) {
            int n3 = this.parents.get(n2);
            if (TreeBitSet.numberOfElements(n3) == 0) {
                IntEnumeration intEnumeration = TreeBitSet.elements(n3);
                while (intEnumeration.hasMoreElements()) {
                    int n4 = intEnumeration.nextInt();
                }
                this.parents.put(n2, 0);
                this.vertexIds.put(n2, -1);
                ++n;
            }
            ++n2;
        }
        return n;
    }

    void setValid(int n) {
        if (this.isValid == null) {
            this.isValid = new BitSet();
        }
        this.isValid.set(n);
    }

    public void addToVertex(int n, int n2) {
        int n3 = this.idToIndex(n);
        this.vertexSizes.put(n3, this.vertexSizes.get(n3) + n2);
    }

    public void addVertex(int n, int n2) {
        int n3 = this.idToIndex(n);
        if (this.sizeMatters) {
            this.vertexSizes.put(n3, n2);
        }
        this.setValid(n3);
    }

    public void addVertex(int n, int[] nArray, int n2) {
        int n3 = this.idToIndex(n);
        if (this.sizeMatters) {
            this.vertexSizes.put(n3, n2);
        }
        int n4 = this.edges.get(n3);
        int n5 = 0;
        while (n5 < nArray.length) {
            int n6 = this.idToIndex(nArray[n5]);
            n4 = TreeBitSet.set(n4, n6);
            if (this.recordParents) {
                this.parents.put(n6, TreeBitSet.set(this.parents.get(n6), n3));
            }
            ++n5;
        }
        this.edges.put(n3, n4);
        this.setValid(n3);
    }

    public void deleteTree(int n) {
        this.dfs(new Visitor(){

            public void exitNode(int n) {
                SimpleGraph.this.deleted.set(n);
            }
        }, n);
    }

    Object dfs(Visitor visitor) {
        BitSet bitSet = new BitSet();
        Stack stack = new Stack();
        IntegerStack integerStack = new IntegerStack();
        visitor.init();
        int n = 0;
        while (n < this.size) {
            this.dfs(visitor, stack, integerStack, bitSet, n);
            ++n;
        }
        return visitor.result();
    }

    public Object dfs(Visitor visitor, int n) {
        BitSet bitSet = new BitSet();
        return this.dfs(visitor, n, bitSet);
    }

    Object dfs(Visitor visitor, int n, BitSet bitSet) {
        Stack stack = new Stack();
        IntegerStack integerStack = new IntegerStack();
        visitor.init();
        this.dfs(visitor, stack, integerStack, bitSet, n);
        return visitor.result();
    }

    Object dfs(Visitor visitor, Stack stack, IntegerStack integerStack, BitSet bitSet, int n) {
        Base.Assert(this.complete);
        Stepper stepper = new Stepper(visitor, stack, integerStack, bitSet, n);
        while (stepper.hasMoreElements()) {
            IntEnumeration intEnumeration = stepper.children();
            boolean bl = true;
            if (intEnumeration != null) {
                int n2;
                if (visitor.continueSearch(stepper.currentNode(), integerStack.depth()) && intEnumeration.hasMoreElements()) {
                    n2 = intEnumeration.nextInt();
                    if (stepper.childAlreadyVisited(n2)) continue;
                    stepper.enterNode(n2);
                    bl = false;
                } else {
                    intEnumeration.reset();
                    while (intEnumeration.hasMoreElements()) {
                        n2 = intEnumeration.nextInt();
                        if (this.deleted.get(n2)) continue;
                        visitor.visitChildAtExit(stepper.currentNode(), n2);
                    }
                }
            }
            if (!bl) continue;
            stepper.exitNode();
        }
        return visitor.result();
    }

    boolean dfsCompare(CompareVisitor compareVisitor, int n, int n2) {
        BitSet bitSet = new BitSet();
        int n3 = this.idToIndex(n);
        int n4 = this.idToIndex(n2);
        Stepper stepper = new Stepper(compareVisitor, new Stack(), new IntegerStack(), bitSet, n3);
        Stepper stepper2 = new Stepper(compareVisitor, new Stack(), new IntegerStack(), bitSet, n4);
        compareVisitor.init();
        while (stepper.hasMoreElements() || stepper2.hasMoreElements()) {
            if (!stepper.hasMoreElements() || !stepper2.hasMoreElements()) {
                return false;
            }
            IntEnumeration intEnumeration = stepper.children();
            IntEnumeration intEnumeration2 = stepper2.children();
            boolean bl = true;
            if (intEnumeration != null || intEnumeration2 != null) {
                if (intEnumeration == null || intEnumeration2 == null || intEnumeration.hasMoreElements() != intEnumeration2.hasMoreElements()) {
                    return false;
                }
                if (compareVisitor.continueSearch(stepper.currentNode(), stepper2.currentNode()) && intEnumeration.hasMoreElements()) {
                    boolean bl2;
                    int n5 = intEnumeration.nextInt();
                    int n6 = intEnumeration2.nextInt();
                    boolean bl3 = !stepper.childAlreadyVisited(n5);
                    boolean bl4 = bl2 = !stepper2.childAlreadyVisited(n6);
                    if (bl3 != bl2) {
                        return false;
                    }
                    if (!bl3) continue;
                    stepper.enterNode(n5);
                    stepper2.enterNode(n6);
                    if (!compareVisitor.compare(stepper.currentNode(), stepper2.currentNode())) {
                        return false;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            stepper.exitNode();
            stepper2.exitNode();
        }
        return true;
    }

    IntEnumeration elements(Visitor visitor, int n) {
        IntEnumeration intEnumeration = null;
        int n2 = this.edges.get(n);
        if (n2 != 0) {
            intEnumeration = TreeBitSet.elements(n2);
            if (visitor.sort()) {
                SortedIntEnumeration sortedIntEnumeration = new SortedIntEnumeration();
                while (intEnumeration.hasMoreElements()) {
                    int n3 = intEnumeration.nextInt();
                    int n4 = visitor.getCount(n3);
                    sortedIntEnumeration.add(n3, n4);
                }
                sortedIntEnumeration.sort();
                intEnumeration = sortedIntEnumeration;
            }
        }
        return intEnumeration;
    }

    void random(int n, int n2, int n3) {
        Random random = new Random(n);
        int n4 = 1;
        while (n4 <= n2) {
            this.addVertex(n4, 0);
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            int n6;
            int n7 = random.nextInt(n2) + 1;
            if (n7 == (n6 = random.nextInt(n2) + 1)) continue;
            this.addEdge(n7, n6);
            ++n5;
        }
        this.complete();
    }

    public Vertex getVertex(int n) {
        return new Vertex(this, this.idToIndex(n));
    }

    class Stepper {
        Visitor visitor;
        Stack enums;
        IntegerStack stack;
        BitSet grey;
        int initialNode;

        Stepper(Visitor visitor, Stack stack, IntegerStack integerStack, BitSet bitSet, int n) {
            this.visitor = visitor;
            this.enums = stack;
            this.stack = integerStack;
            this.grey = bitSet;
            this.initialNode = n;
            if (!bitSet.get(n) && !SimpleGraph.this.deleted.get(n)) {
                this.enterNode(n);
            }
        }

        void enterNode(int n) {
            IntEnumeration intEnumeration = SimpleGraph.this.elements(this.visitor, n);
            this.visitor.enterNode(n, this.stack.depth());
            this.stack.push(n);
            this.enums.push(intEnumeration);
            this.grey.set(n);
        }

        void exitNode() {
            this.visitor.exitNode(this.currentNode());
            this.stack.pop();
            this.enums.pop();
        }

        boolean hasMoreElements() {
            return !this.stack.empty();
        }

        int currentNode() {
            return this.stack.peek();
        }

        String id() {
            int n = SimpleGraph.this.vertexIds.get(this.currentNode());
            return Base.hex(n);
        }

        IntEnumeration children() {
            return (IntEnumeration)this.enums.peek();
        }

        boolean childAlreadyVisited(int n) {
            if (SimpleGraph.this.deleted.get(n)) {
                return true;
            }
            this.visitor.visitChild(this.currentNode(), n, !this.grey.get(n), this.stack.depth());
            return this.grey.get(n);
        }
    }
}

