/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.PrintClient;
import com.ibm.jvm.findroots.SimpleGraph;
import com.ibm.jvm.findroots.Visitor;
import com.ibm.jvm.util.IntPairEnumeration;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.IntegerStack;
import com.ibm.jvm.util.SvcdumpProperties;
import com.ibm.jvm.util.TreeBitSet;
import java.util.BitSet;
import java.util.Stack;
import sun.misc.SoftCache;

public final class StrongComponentsGraph
extends SimpleGraph {
    IntegerArray dagSizes = new IntegerArray();
    int[] reach;
    PrintClient client;
    BitSet isNotRoot = new BitSet();
    boolean exact = SvcdumpProperties.getBooleanProperty("findroots.exact", false);
    boolean uselessmemory = SvcdumpProperties.getBooleanProperty("findroots.uselessmemory", false);

    String className() {
        return "StrongComponentsGraph";
    }

    void createSlot() {
        super.createSlot();
        this.dagSizes.add(0);
    }

    boolean ignoreNode(int n) {
        return false;
    }

    void transitiveClosureFast() {
        Visitor visitor = new Visitor(){
            int[] tc;
            {
                this.tc = new int[StrongComponentsGraph.this.size];
            }

            public boolean ignoreDownEdges() {
                return true;
            }

            public void visitChild(int n, int n2, boolean bl, int n3) {
                this.tc[n] = TreeBitSet.set(this.tc[n], n2);
            }

            public void visitChildAtExit(int n, int n2) {
                if (this.tc[n2] != 0) {
                    this.tc[n] = TreeBitSet.or(this.tc[n], this.tc[n2]);
                }
            }

            public void exitNode(int n) {
                this.tc[n] = TreeBitSet.close(this.tc[n]);
            }

            public Object result() {
                return this.tc;
            }
        };
        BitSet bitSet = new BitSet();
        Stack stack = new Stack();
        IntegerStack integerStack = new IntegerStack();
        visitor.init();
        int n = 0;
        while (n < this.size) {
            this.dfs(visitor, stack, integerStack, bitSet, n);
            ++n;
        }
        int[] nArray = (int[])visitor.result();
        this.log("calculate reachability");
        this.reach = new int[this.size];
        SoftCache softCache = new SoftCache();
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        while (n2 < this.size) {
            if (!this.ignoreNode(n2)) {
                if (this.exact || this.sizeMatters) {
                    this.reach[n2] = this.vertexSizes.get(n2);
                }
                if (nArray[n2] != 0) {
                    if (this.exact || this.sizeMatters) {
                        IntPairEnumeration intPairEnumeration = TreeBitSet.intPairs(nArray[n2]);
                        while (intPairEnumeration.hasMoreElements()) {
                            int n3;
                            long l3 = intPairEnumeration.nextIntPair();
                            int n4 = (int)l3;
                            Base.Assert(n4 >= (n3 = (int)(l3 >> 32)));
                            if (n4 < n3 + 10) {
                                int n5 = 0;
                                int n6 = n3;
                                while (n6 <= n4) {
                                    n5 += this.vertexSizes.get(n6);
                                    ++n6;
                                }
                                int n7 = n2;
                                this.reach[n7] = this.reach[n7] + n5;
                                l2 += (long)(n4 - n3 + 1);
                                continue;
                            }
                            Long l4 = new Long(l3);
                            Integer n8 = (Integer)softCache.get(l4);
                            if (n8 == null) {
                                int n9 = 0;
                                int n10 = n3;
                                while (n10 <= n4) {
                                    n9 += this.vertexSizes.get(n10);
                                    ++n10;
                                }
                                n8 = new Integer(n9);
                                softCache.put(l4, n8);
                                l2 += (long)(n4 - n3 + 1);
                            } else {
                                l += (long)(n4 - n3 + 1);
                            }
                            int n11 = n2;
                            this.reach[n11] = this.reach[n11] + n8;
                        }
                    } else {
                        this.reach[n2] = TreeBitSet.numberOfElements(nArray[n2]);
                    }
                }
            }
            ++n2;
        }
        int n12 = 0;
        while (n12 < this.size) {
            TreeBitSet.free(nArray[n12]);
            ++n12;
        }
    }

    void transitiveClosureSlow() {
        this.reach = new int[this.size];
        int n = 0;
        while (n < this.size) {
            if (!this.ignoreNode(n)) {
                Integer n2 = (Integer)this.dfs(new Visitor(){
                    int r = 0;

                    public void enterNode(int n, int n2) {
                        this.r = StrongComponentsGraph.this.exact || StrongComponentsGraph.this.sizeMatters ? (this.r += StrongComponentsGraph.this.vertexSizes.get(n)) : ++this.r;
                    }

                    public Object result() {
                        return new Integer(this.r);
                    }
                }, n);
                this.reach[n] = n2;
            }
            ++n;
        }
    }

    void transitiveClosure() {
        this.log("begin transitiveClosure");
        if (this.uselessmemory) {
            this.transitiveClosureSlow();
        } else {
            this.transitiveClosureFast();
        }
        this.log("end transitiveClosure");
    }
}

