/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.ActiveSection;
import com.ibm.jvm.format.ProcessorSection;
import com.ibm.jvm.format.ServiceSection;
import com.ibm.jvm.format.StartupSection;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.TraceRecord;
import com.ibm.jvm.format.TraceRecordExternal;
import com.ibm.jvm.format.TraceRecordInternal;
import com.ibm.jvm.format.TraceSection;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.IOException;

public final class TraceFileHeader {
    private String eyecatcher_string;
    private int length;
    private int version;
    private int modification;
    private int bufferSize;
    private int endianSignature;
    private int nextRecord = 0;
    private int traceStart;
    private int serviceStart;
    private int startupStart;
    private int activeStart;
    private int processorStart;
    private final int BIG_ENDIAN_SIG = 305419896;
    private final int LITTLE_ENDIAN_SIG = 2018915346;
    private TraceFile traceFile;
    protected TraceSection traceSection;
    private ServiceSection serviceSection;
    private StartupSection startupSection;
    private ActiveSection activeSection;
    private ProcessorSection processorSection;
    protected static final int INTERNAL = 0;
    protected static final int EXTERNAL = 1;

    protected TraceFileHeader(TraceFile traceFile) throws IOException {
        this.traceFile = traceFile;
        TraceRecord.Chars[0] = "-";
        TraceRecord.Chars[1] = "*";
        TraceRecord.Chars[2] = ">";
        TraceRecord.Chars[3] = ">";
        TraceRecord.Chars[4] = "<";
        TraceRecord.Chars[5] = "<";
        TraceRecord.Chars[6] = " ";
        TraceRecord.Chars[7] = " ";
        TraceRecord.Chars[8] = " ";
        TraceRecord.Chars[9] = " ";
        TraceRecord.Chars[10] = " ";
        TraceRecord.Chars[11] = " ";
        TraceRecord.EVENT_TYPE = 0;
        TraceRecord.EXCEPTION_TYPE = 1;
        TraceRecord.ENTRY_TYPE = (byte)2;
        TraceRecord.ENTRY_EXCPT_TYPE = (byte)3;
        TraceRecord.EXIT_TYPE = (byte)4;
        TraceRecord.EXIT_EXCPT_TYPE = (byte)5;
        TraceRecord.MEM_TYPE = (byte)6;
        TraceRecord.MEM_EXCPT_TYPE = (byte)7;
        TraceRecord.DEBUG_TYPE = (byte)8;
        TraceRecord.DEBUG_EXCPT_TYPE = (byte)9;
        TraceRecord.PERF_TYPE = (byte)10;
        TraceRecord.PERF_EXCPT_TYPE = (byte)11;
        TraceRecord.MAX_TYPES = (byte)12;
        TraceRecord.types[0] = "Event     ";
        TraceRecord.types[1] = "Exception ";
        TraceRecord.types[2] = "Entry     ";
        TraceRecord.types[3] = "Entry     ";
        TraceRecord.types[4] = "Exit      ";
        TraceRecord.types[5] = "Exit      ";
        TraceRecord.types[6] = "Mem       ";
        TraceRecord.types[7] = "Mem       ";
        TraceRecord.types[8] = "Debug     ";
        TraceRecord.types[9] = "Debug     ";
        TraceRecord.types[10] = "Perf      ";
        TraceRecord.types[11] = "Perf      ";
        this.eyecatcher_string = Util.convertAndCheckEyecatcher(traceFile.readI());
        this.length = traceFile.readI();
        this.version = traceFile.readI();
        this.modification = traceFile.readI();
        this.bufferSize = traceFile.readI();
        this.endianSignature = traceFile.readI();
        switch (this.endianSignature) {
            case 305419896: {
                Util.Debug.println("Endian is BIG");
                traceFile.setBigEndian(true);
                Util.setBigEndian(true);
                break;
            }
            case 2018915346: {
                Util.Debug.println("Endian is LITTLE");
                traceFile.setBigEndian(false);
                Util.setBigEndian(false);
                this.length = Util.convertEndian(this.length);
                this.version = Util.convertEndian(this.version);
                this.modification = Util.convertEndian(this.modification);
                this.bufferSize = Util.convertEndian(this.bufferSize);
                break;
            }
            default: {
                TraceFormat.outStream.println("TraceFileHeader has invalid endian signature");
            }
        }
        Util.Debug.println("TraceFileHeader: eyecatcher:       " + this.eyecatcher_string);
        Util.Debug.println("TraceFileHeader: length:           " + this.length);
        Util.Debug.println("TraceFileHeader: version:          " + this.version);
        Util.Debug.println("TraceFileHeader: modification:     " + this.modification);
        Util.Debug.println("TraceFileHeader: bufferSize:       " + this.bufferSize);
        TraceFormat.verMod = (float)this.version + (float)this.modification / 10.0f;
        Util.Debug.println("TraceFileHeader: verMod:           " + TraceFormat.verMod);
        this.traceStart = traceFile.readI();
        this.serviceStart = traceFile.readI();
        this.startupStart = traceFile.readI();
        this.activeStart = traceFile.readI();
        this.processorStart = traceFile.readI();
        this.traceSection = new TraceSection(traceFile, this.traceStart);
        this.serviceSection = new ServiceSection(traceFile, this.serviceStart);
        this.startupSection = new StartupSection(traceFile, this.startupStart);
        this.activeSection = new ActiveSection(traceFile, this.activeStart);
        this.processorSection = new ProcessorSection(traceFile, this.processorStart);
    }

    protected final void processTraceBufferHeaders() throws IOException {
        int n = this.length;
        int n2 = 0;
        while ((long)n < this.traceFile.length()) {
            ++n2;
            if (this.traceSection.getTraceType() == 0) {
                new TraceRecordInternal(this.traceFile, n);
            } else {
                new TraceRecordExternal(this.traceFile, n);
            }
            n += this.bufferSize;
        }
        TraceFormat.outStream.println("Found " + n2 + " Trace Buffers in file " + this.traceFile.toString());
        if (TraceFormat.invalidBuffers > 0) {
            TraceFormat.outStream.println("*** WARNING *** found " + TraceFormat.invalidBuffers + " invalid Trace Buffers");
            TraceFormat.outStream.println("attempting to format the remainder");
        }
        Util.Debug.println("TraceFileHeader: number of buffers = " + n2);
        TraceFormat.expectedRecords = n2;
    }

    protected final void summarize(BufferedWriter bufferedWriter) throws IOException {
        this.serviceSection.summary(bufferedWriter);
        this.startupSection.summary(bufferedWriter);
        this.activeSection.summary(bufferedWriter);
        this.processorSection.summary(bufferedWriter);
    }

    protected final int getLength() {
        return this.length;
    }

    protected final int getBufferSize() {
        return this.bufferSize;
    }
}

