/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceArgs;
import com.ibm.jvm.format.TraceFormat;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public final class Util {
    private static Properties properties;
    private static Hashtable threads;
    private static int timerType;
    private static Hashtable components;
    private static boolean bigendian;
    static final String[] timerDesc;
    protected static final int BYTE = 1;
    protected static final int INT = 4;
    protected static final int LONG = 8;
    protected static final String SUM_TAB = "        ";
    protected static final BigInteger MILLIS2SECONDS;
    protected static final BigInteger SECONDS2MINUTES;
    protected static final BigInteger MINUTES2HOURS;
    protected static final BigInteger HOURS2DAYS;
    protected static final BigInteger MILLION;

    private Util() {
    }

    protected static final void initStatics() {
        properties = null;
        threads = null;
        components = null;
    }

    protected static final void putThreadID(Long l) {
        if (threads == null) {
            threads = new Hashtable();
        }
        threads.put(l, l);
    }

    protected static final boolean findThreadID(Long l) {
        if (threads == null) {
            return true;
        }
        return threads.containsKey(l);
    }

    protected static final void putComponent(String string) {
        if (components == null) {
            components = new Hashtable();
        }
        components.put(string.toLowerCase(), new TypeList());
    }

    protected static final void putComponent(String string, Vector vector) {
        if (components == null) {
            components = new Hashtable();
        }
        components.put(string.toLowerCase(), new TypeList(vector));
    }

    protected static final boolean findComponentAndType(String string, String string2) {
        if (components == null) {
            return true;
        }
        if (string.equals("dg")) {
            return true;
        }
        return components.containsKey(string) && ((TypeList)components.get(string)).contains(string2);
    }

    static final void determineEncoding(byte by) {
        Debug.println("Encoding is Ascii: " + (char)by + "= D");
        Util.setProperty("ENCODING", "ASCII");
    }

    private static final void reverseByteOrder(byte[] byArray) {
        int n = 0;
        while (n < byArray.length / 2) {
            byte by = byArray[n];
            byArray[n] = byArray[byArray.length - 1 - n];
            byArray[byArray.length - 1 - n] = by;
            ++n;
        }
    }

    protected static final BigInteger constructUnsignedLong(byte[] byArray, int n) {
        return Util.constructUnsignedLong(byArray, n, 8);
    }

    protected static final BigInteger constructUnsignedLong(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        try {
            System.arraycopy(byArray, n, byArray2, 0, n2);
            if (!bigendian) {
                Util.reverseByteOrder(byArray2);
            }
            BigInteger bigInteger = new BigInteger(1, byArray2);
            return bigInteger;
        }
        catch (Exception exception) {
            TraceFormat.outStream.println("******************* Exception: data.length " + byArray.length + " offset " + n + " numBytes " + n2);
            return null;
        }
    }

    protected static final int constructTraceID(byte[] byArray, int n) {
        return byArray[n] << 16 & 0xFF0000 | byArray[n + 1] << 8 & 0xFF00 | byArray[n + 2] & 0xFF;
    }

    protected static final long constructUnsignedInt(byte[] byArray, int n) {
        return !bigendian ? (long)byArray[n + 3] << 24 & 0xFF000000L | (long)byArray[n + 2] << 16 & 0xFF0000L | (long)byArray[n + 1] << 8 & 0xFF00L | (long)byArray[n] & 0xFFL : (long)byArray[n] << 24 & 0xFF000000L | (long)byArray[n + 1] << 16 & 0xFF0000L | (long)byArray[n + 2] << 8 & 0xFF00L | (long)byArray[n + 3] & 0xFFL;
    }

    protected static final int constructUnsignedByte(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    private static final int findNull(byte[] byArray, int n) {
        while (n < byArray.length) {
            if (byArray[n] == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected static final String constructString(byte[] byArray, int n) {
        return Util.constructString(byArray, n, Util.getProperty("ENCODING", "ASCII"));
    }

    protected static final String constructString(byte[] byArray, int n, String string) {
        try {
            int n2 = Util.findNull(byArray, n);
            if (n2 == -1) {
                return "";
            }
            return new String(byArray, n, n2 - n, string);
        }
        catch (Exception exception) {
            TraceFormat.outStream.println("Util.constructString ****> " + exception);
            return "";
        }
    }

    protected static final String constructString(byte[] byArray, int n, int n2) {
        return Util.constructString(byArray, n, n2, Util.getProperty("ENCODING", "ASCII"));
    }

    protected static final String constructString(byte[] byArray, int n, int n2, String string) {
        try {
            return new String(byArray, n, n2, string);
        }
        catch (Exception exception) {
            TraceFormat.outStream.println("Util.constructString ****> " + exception);
            return "";
        }
    }

    protected static final void setProperty(String string, String string2) {
        if (properties == null) {
            properties = new Properties();
        }
        properties.setProperty(string, string2);
    }

    protected static final String getProperty(String string) {
        if (properties == null) {
            properties = new Properties();
        }
        return properties.getProperty(string);
    }

    protected static final String getProperty(String string, String string2) {
        if (properties == null) {
            properties = new Properties();
        }
        return properties.getProperty(string, string2);
    }

    protected static final void padBuffer(StringBuffer stringBuffer, int n, char c) {
        Util.padBuffer(stringBuffer, n, c, false);
    }

    protected static final void padBuffer(StringBuffer stringBuffer, int n, char c, boolean bl) {
        while (stringBuffer.length() < n) {
            if (bl) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.insert(0, c);
        }
    }

    static final void setTimerType(int n) {
        timerType = n;
    }

    static final String getTimerDescription() {
        return timerDesc[timerType];
    }

    static final void printDump(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n / 16 + 1) {
            StringBuffer stringBuffer = new StringBuffer(100);
            StringBuffer stringBuffer2 = new StringBuffer(100);
            int n3 = 0;
            while (n3 < 4) {
                int n4 = 0;
                while (n4 < 4) {
                    if (n4 + n3 * 4 + n2 * 16 >= n) break;
                    Util.byte2hex(byArray[n4 + n3 * 4 + n2 * 16], stringBuffer);
                    if (byArray[n4 + n3 * 4 + n2 * 16] > 40 && byArray[n4 + n3 * 4 + n2 * 16] < 128) {
                        stringBuffer2.append((char)byArray[n4 + n3 * 4 + n2 * 16]);
                    } else {
                        stringBuffer2.append(".");
                    }
                    ++n4;
                }
                stringBuffer.append(" ");
                ++n3;
            }
            Debug.println(Integer.toHexString(n2 * 16) + ": " + stringBuffer + " " + stringBuffer2);
            ++n2;
        }
    }

    private static void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    static final String getFormattedTime(BigInteger bigInteger) {
        switch (timerType) {
            case 2: 
            case 4: 
            case 5: {
                if ((double)TraceFormat.verMod >= 1.1) {
                    bigInteger = bigInteger.subtract(TraceFormat.overallStartPlatform);
                    BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(TraceFormat.timeConversion);
                    BigInteger[] bigIntegerArray2 = bigIntegerArray[0].add(TraceFormat.overallStartSystem).divideAndRemainder(MILLIS2SECONDS);
                    BigInteger bigInteger2 = bigIntegerArray2[1].multiply(MILLION).add(bigIntegerArray[1].multiply(MILLION).divide(TraceFormat.timeConversion));
                    BigInteger[] bigIntegerArray3 = bigIntegerArray2[0].divideAndRemainder(SECONDS2MINUTES);
                    BigInteger[] bigIntegerArray4 = bigIntegerArray3[0].divideAndRemainder(MINUTES2HOURS);
                    BigInteger[] bigIntegerArray5 = bigIntegerArray4[0].divideAndRemainder(HOURS2DAYS);
                    try {
                        return "00".substring(bigIntegerArray5[1].toString().length()) + bigIntegerArray5[1].toString() + ":" + "00".substring(bigIntegerArray4[1].toString().length()) + bigIntegerArray4[1].toString() + ":" + "00".substring(bigIntegerArray3[1].toString().length()) + bigIntegerArray3[1].toString() + "." + "000000000".substring(bigInteger2.toString().length()) + bigInteger2.toString();
                    }
                    catch (Exception exception) {
                        Debug.println(bigIntegerArray5[1].toString() + ":" + bigIntegerArray4[1].toString() + ":" + bigIntegerArray3[1].toString() + "." + bigInteger2.toString());
                        return "Bad Time: " + bigInteger.toString(16);
                    }
                }
                return "0000000000000000".substring(bigInteger.toString(16).length()) + bigInteger.toString(16);
            }
            case 3: {
                long l = bigInteger.shiftRight(32).longValue() & 0xFFFFFFFFL;
                long l2 = bigInteger.longValue() & 0xFFFFFFFFL;
                long l3 = l % 60L;
                long l4 = l / 60L % 60L;
                long l5 = l / 3600L % 24L;
                try {
                    return "00".substring(Long.toString(l5).length()) + Long.toString(l5) + ":" + "00".substring(Long.toString(l4).length()) + Long.toString(l4) + ":" + "00".substring(Long.toString(l3).length()) + Long.toString(l3) + "." + "000000000".substring(Long.toString(l2).length()) + Long.toString(l2);
                }
                catch (Exception exception) {
                    Debug.println("hh: " + Long.toString(l5) + " mm: " + Long.toString(l4) + " ss: " + Long.toString(l3) + " Nanos: " + Long.toString(l2));
                    return "Bad Time: " + bigInteger.toString(16);
                }
            }
            case 6: {
                long l = bigInteger.shiftRight(12).longValue() & 0xFFFFFFFFFFFFFL;
                long l6 = l / 1000000L % 60L;
                long l7 = l / 60000000L % 60L;
                long l8 = l / 3600000000L % 24L;
                long l9 = (bigInteger.longValue() & 0xFFFL | (l %= 1000000L) << 12) * 244140625L / 1000000L;
                try {
                    return "00".substring(Long.toString(l8).length()) + Long.toString(l8) + ":" + "00".substring(Long.toString(l7).length()) + Long.toString(l7) + ":" + "00".substring(Long.toString(l6).length()) + Long.toString(l6) + "." + "000000000000".substring(Long.toString(l9).length()) + Long.toString(l9);
                }
                catch (Exception exception) {
                    Debug.println("hh: " + Long.toString(l8) + " mm: " + Long.toString(l7) + " ss: " + Long.toString(l6) + " Picos: " + Long.toString(l9));
                    return "Bad Time: " + bigInteger.toString(16);
                }
            }
        }
        return "0000000000000000".substring(bigInteger.toString(16).length()) + bigInteger.toString(16);
    }

    protected static final int convertEndian(int n) {
        return n >>> 24 | n << 24 | n << 8 & 0xFF0000 | n >> 8 & 0xFF00;
    }

    protected static final String convertAndCheckEyecatcher(int n) {
        String string;
        n = bigendian ? n : Util.convertEndian(n);
        switch (n) {
            case 1213482820: {
                string = "DGTH (in ASCII)";
                break;
            }
            case 1145525320: {
                string = "DGTH (in ASCII)";
                break;
            }
            case 1145525331: {
                string = "DGTS (in ASCII)";
                break;
            }
            case 1145525075: {
                string = "DGSS (in ASCII)";
                break;
            }
            case 1145525071: {
                string = "DGSO (in ASCII)";
                break;
            }
            case 1145525313: {
                string = "DGTA (in ASCII)";
                break;
            }
            case 1145524306: {
                string = "DGPR (in ASCII)";
                break;
            }
            case -993532984: {
                string = "DGTH (in EBCDIC)";
                break;
            }
            case -993532958: {
                string = "DGTS (in EBCDIC)";
                break;
            }
            case -993533214: {
                string = "DGSS (in EBCDIC)";
                break;
            }
            case -993533226: {
                string = "DGSO (in EBCDIC)";
                break;
            }
            case -993532991: {
                string = "DGTA (in EBCDIC)";
                break;
            }
            case -993536039: {
                string = "DGPR (in EBCDIC)";
                break;
            }
            default: {
                string = "eyecatcher is bad " + Integer.toHexString(n) + " *********************************";
            }
        }
        return string;
    }

    protected static final void setBigEndian(boolean bl) {
        bigendian = bl;
    }

    static {
        timerDesc = new String[]{"Sequence number  ", "Special          ", "Pentium TSC        ", "Time (UTC)         ", "MSPR             ", "MFTB             ", "Time (UTC)            "};
        MILLIS2SECONDS = BigInteger.valueOf(1000L);
        SECONDS2MINUTES = BigInteger.valueOf(60L);
        MINUTES2HOURS = BigInteger.valueOf(60L);
        HOURS2DAYS = BigInteger.valueOf(24L);
        MILLION = BigInteger.valueOf(1000000L);
    }

    static final class TypeList {
        Hashtable types;

        TypeList() {
        }

        TypeList(Vector vector) {
            this.types = new Hashtable();
            int n = 0;
            while (n < vector.size()) {
                String string = ((String)vector.elementAt(n)).toLowerCase();
                this.types.put(string, string);
                ++n;
            }
        }

        final boolean contains(String string) {
            if (this.types == null) {
                return true;
            }
            return this.types.containsKey(string);
        }
    }

    static class Debug {
        static PrintStream out = TraceFormat.outStream;

        Debug() {
        }

        static void println(Object object) {
            if (TraceArgs.debug) {
                out.println(object);
            }
        }
    }
}

