/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.io;

import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public final class LocalizedPrintStream
extends PrintStream {
    private String lineSeparator;
    private int lineSeparatorNLIndex;

    private LocalizedPrintStream(OutputStream outputStream, boolean bl, String string) {
        super(outputStream, bl);
        this.lineSeparator = string;
        this.lineSeparatorNLIndex = this.lineSeparator.indexOf(10);
    }

    public void print(char c) {
        if (c != '\n') {
            super.print(c);
        } else {
            super.print(this.lineSeparator);
        }
    }

    public void print(char[] cArray) {
        super.print(this.getNewlinedString(cArray, false));
    }

    public void print(String string) {
        super.print(this.getNewlinedString(string));
    }

    public void print(Object object) {
        super.print(this.getNewlinedString(object));
    }

    public void println(char c) {
        if (c != '\n') {
            super.println(c);
        } else {
            super.println(this.lineSeparator);
        }
    }

    public void println(char[] cArray) {
        super.println(this.getNewlinedString(cArray, false));
    }

    public void println(String string) {
        super.println(this.getNewlinedString(string));
    }

    public void println(Object object) {
        super.println(this.getNewlinedString(object));
    }

    private String getNewlinedString(Object object) {
        return this.getNewlinedString(object, true);
    }

    private String getNewlinedString(Object object, boolean bl) {
        String string;
        if (object == null) {
            return null;
        }
        String string2 = string = object instanceof char[] && !bl ? new String((char[])object) : String.valueOf(object);
        if (string == null) {
            return null;
        }
        int n = string.indexOf(10);
        if (n == -1) {
            return string;
        }
        char[] cArray = object instanceof char[] && !bl ? (char[])object : string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        int n2 = 0;
        while (n != -1) {
            if (this.lineSeparatorNLIndex != -1 && string.regionMatches(n - this.lineSeparatorNLIndex, this.lineSeparator, 0, this.lineSeparator.length())) {
                n = n + this.lineSeparator.length() - this.lineSeparatorNLIndex - 1;
            } else {
                stringBuffer.append(cArray, n2, n - n2);
                stringBuffer.append(this.lineSeparator);
                n2 = n + 1;
            }
            n = string.indexOf(10, n + 1);
        }
        if (stringBuffer.length() == 0) {
            return string;
        }
        if (n2 < cArray.length) {
            stringBuffer.append(cArray, n2, cArray.length - n2);
        }
        return stringBuffer.toString();
    }

    public static PrintStream localize(OutputStream outputStream) {
        return LocalizedPrintStream.localize(outputStream, false);
    }

    public static PrintStream localize(OutputStream outputStream, boolean bl) {
        if (outputStream instanceof LocalizedPrintStream) {
            return (PrintStream)outputStream;
        }
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        if (string.equals("\n")) {
            if (outputStream instanceof PrintStream) {
                return (PrintStream)outputStream;
            }
            return new PrintStream(outputStream, bl);
        }
        return new LocalizedPrintStream(outputStream, bl, string);
    }
}

