/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvMemRanges;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.io.RandomAccessStream;
import com.ibm.jvm.svcdump.Address;
import com.ibm.jvm.svcdump.Dsa;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Function;
import com.ibm.jvm.svcdump.Jvm;
import com.ibm.jvm.svcdump.MemRange;
import com.ibm.jvm.svcdump.Page;
import com.ibm.jvm.svcdump.Process;
import com.ibm.jvm.svcdump.Tcb;
import com.ibm.jvm.svcdump.TraceEntry;
import com.ibm.jvm.util.IntHashtable;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.html.Document;
import com.ibm.jvm.util.html.Table;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public final class AddressSpace
extends DvAddressSpace
implements Serializable,
RandomAccessStream {
    static int ascbasxb;
    static AddressSpace root;
    IntegerArray addresses = new IntegerArray();
    IntegerArray blocks = new IntegerArray();
    SoftReference[] blockPointers;
    int id;
    Dump dump;
    Hashtable traceTable = new Hashtable();
    IntHashtable strings = new IntHashtable();
    Hashtable functionNames = new Hashtable();
    Function[] traceFunctions;
    Tcb[] tcbs;
    Tcb lastTcb;
    HashMap tcbMap = new HashMap();
    private Jvm[] jvms;
    boolean checkedJvms;
    int currentOffset;
    int firsttcb = 0;
    int lastAddress;
    BitSet pages = new BitSet();
    MemRange[] memRanges;
    Process[] processes;
    int cacheMisses;
    ArrayList traceEntries = new ArrayList();
    int jvmRasAddress;
    int[] lastBlock;
    int lastBlockAddress = -1;

    public DvMemRanges[] getMemRanges() {
        return this.memRanges;
    }

    public DvProcess[] getProcesses() {
        if (this.processes == null) {
            this.processes = new Process[1];
            this.processes[0] = new Process(this);
        }
        return this.processes;
    }

    public DvProcess getCurrentProcess() {
        throw new Error("unimplemented method");
    }

    public DvAddress createAddress(long l) {
        Address address = new Address((int)l);
        return address;
    }

    public byte[] readBytes(DvAddress dvAddress, long l) throws DvAddressException {
        int n = (int)dvAddress.getAddressAsLong();
        byte[] byArray = new byte[(int)l];
        int n2 = 0;
        while ((long)n2 < l) {
            try {
                byArray[n2] = this.readByte(n + n2);
            }
            catch (IOException iOException) {
                if (n2 == 0) {
                    throw new DvAddressException("Could not read: " + AddressSpace.hex(n + n2));
                }
                n2 = (int)l;
            }
            ++n2;
        }
        return byArray;
    }

    public byte readByte(DvAddress dvAddress) throws DvAddressException {
        byte by;
        int n = (int)dvAddress.getAddressAsLong();
        try {
            by = this.readByte(n);
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n));
        }
        return by;
    }

    public short readShort(DvAddress dvAddress) throws DvAddressException {
        int n = (int)dvAddress.getAddressAsLong();
        try {
            return (short)this.readShort(n);
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n));
        }
    }

    public int readInt(DvAddress dvAddress) throws DvAddressException {
        int n = (int)dvAddress.getAddressAsLong();
        try {
            return this.readInt(n);
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n));
        }
    }

    public long readLong(DvAddress dvAddress) throws DvAddressException {
        int n = (int)dvAddress.getAddressAsLong();
        try {
            long l = this.readInt(n);
            long l2 = this.readInt(n + 4);
            return l << 32 | l2;
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n));
        }
    }

    public String id() {
        return Integer.toHexString(this.id);
    }

    public DvAddress readPointer(DvAddress dvAddress) throws DvAddressException {
        int n;
        int n2 = (int)dvAddress.getAddressAsLong();
        try {
            n = this.readInt(n2);
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n2));
        }
        Address address = new Address(n);
        return address;
    }

    public Jvm addJvm(int n, boolean bl) throws Exception {
        if (Dump.debug) {
            System.out.println("add jvm " + AddressSpace.hex(n));
        }
        if (this.jvms == null) {
            this.jvms = new Jvm[0];
        }
        int n2 = 0;
        while (n2 < this.jvms.length) {
            if (this.jvms[n2].jvmp == n) {
                return this.jvms[n2];
            }
            ++n2;
        }
        Jvm[] jvmArray = new Jvm[this.jvms.length + 1];
        System.arraycopy(this.jvms, 0, jvmArray, 0, this.jvms.length);
        Jvm jvm = new Jvm(this, n, bl);
        this.jvms = jvmArray;
        this.jvms[this.jvms.length - 1] = jvm;
        return jvm;
    }

    public Jvm[] jvms() {
        if (this.checkedJvms) {
            return this.jvms;
        }
        this.checkedJvms = true;
        if (this.jvms != null) {
            Jvm[] jvmArray = this.jvms;
            this.jvms = null;
            int n = 0;
            while (n < jvmArray.length) {
                block6: {
                    try {
                        Jvm jvm = jvmArray[n];
                        if (Dump.debug) {
                            System.out.println("about to init jvm " + jvm);
                        }
                        jvm.init();
                        this.addJvm(jvm.jvmp, jvm.isPostRas).init();
                    }
                    catch (Throwable throwable) {
                        if (!Dump.debug) break block6;
                        System.out.println("failed to init jvm: " + throwable);
                    }
                }
                ++n;
            }
        }
        return this.jvms;
    }

    public String getString(int n, int n2) throws Exception {
        String string = (String)this.strings.get(n);
        if (string == null) {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n3 < n2) {
                byArray[n3] = (byte)this.readUnsignedByte(n + n3);
                ++n3;
            }
            string = Dump.getEbcdicString(byArray);
            this.strings.put(n, (Object)string);
        }
        return string;
    }

    public boolean isJava() {
        this.tcbs();
        return this.jvms() != null;
    }

    public void mapTid(int n, Tcb tcb) {
        this.tcbMap.put(new Integer(n), tcb);
    }

    public int zeroBlocks() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.addresses.size()) {
            if (this.addresses.get(n2) != 0) break;
            ++n;
            ++n2;
        }
        return n;
    }

    long milli(long l) {
        l >>>= 12;
        l /= 1000L;
        long l2 = 613608L;
        l2 *= 3600L;
        return l -= (l2 *= 1000L);
    }

    public Date mvsClockToDate(long l) {
        return new Date(this.milli(l));
    }

    public void printFullTrace(Document document) {
        if (this.traceEntries.size() == 0) {
            return;
        }
        Object[] objectArray = (TraceEntry[])this.traceEntries.toArray(new TraceEntry[0]);
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                TraceEntry traceEntry = (TraceEntry)object;
                TraceEntry traceEntry2 = (TraceEntry)object2;
                if (traceEntry.tod > traceEntry2.tod) {
                    return 1;
                }
                if (traceEntry.tod < traceEntry2.tod) {
                    return -1;
                }
                return 0;
            }
        });
        Object object = objectArray[0];
        Date date = new Date(this.milli(((TraceEntry)object).tod));
        document.printHeader("Trace for asid " + this.hexId() + " started at " + date);
        document.println("");
        Table table = new Table(new String[]{"Time", "Tcb", "Psw", "Type", "Function"});
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss:SSS");
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            Date date2 = new Date(this.milli(((TraceEntry)object2).tod));
            String string = simpleDateFormat.format(date2);
            table.addRow(new String[]{string, AddressSpace.hex(((TraceEntry)object2).tcb), AddressSpace.hex(((TraceEntry)object2).psw), ((TraceEntry)object2).typeString, ((TraceEntry)object2).functionName});
            ++n;
        }
        document.addElement(table);
    }

    public void addTraceEntry(int n, String string, int n2, int n3, long l) {
        Integer n4;
        Integer n5 = (Integer)this.traceTable.get(n4 = new Integer(n2));
        this.traceTable.put(n4, new Integer(n5 == null ? 1 : n5 + 1));
        if (this.lastTcb != null && this.lastTcb.tcbid == n3) {
            this.lastTcb.addTraceEntry(n, n2);
        } else if (this.tcbs() != null && n3 != 0) {
            int n6 = 0;
            while (n6 < this.tcbs.length) {
                this.lastTcb = this.tcbs[n6];
                if (this.lastTcb.tcbid == n3) {
                    this.lastTcb.addTraceEntry(n, n2);
                    break;
                }
                ++n6;
            }
        }
        String string2 = this.functionName(new Integer(n2));
        this.traceEntries.add(new TraceEntry(string2, string, n2, n3, l));
    }

    String functionName(Integer n) {
        String string = (String)this.functionNames.get(n);
        if (string != null) {
            return string;
        }
        int n2 = n;
        boolean bl = Dump.debug;
        int n3 = (n2 &= 0x7FFFFFFC) + 4;
        int n4 = 0;
        while (n4 < 4096) {
            block8: {
                try {
                    int n5 = this.readInt(n3);
                    if (n5 == 0xC3C5C5 || n5 == 29607365) {
                        Integer n6 = new Integer(n3 - 4);
                        string = (String)this.functionNames.get(n6);
                        if (string != null) break;
                        try {
                            string = Dsa.function(this, n3 - 4);
                            this.functionNames.put(n6, string);
                            break;
                        }
                        catch (Exception exception) {
                            if (!bl) break;
                            System.out.println("problem creating function at " + AddressSpace.hex(n3));
                        }
                    }
                    break block8;
                }
                catch (Exception exception) {
                    if (!bl) break;
                    System.out.println("problem reading " + AddressSpace.hex(n3));
                }
                break;
            }
            n3 -= 4;
            ++n4;
        }
        if (string == null) {
            string = "unknown function (0x" + AddressSpace.hex(n2) + ")";
        }
        this.functionNames.put(n, string);
        return string;
    }

    public Function[] traceFunctions(Hashtable hashtable) {
        Object[] objectArray;
        Hashtable hashtable2 = new Hashtable();
        boolean bl = Dump.debug;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            String string = this.functionName((Integer)objectArray);
            if (bl) {
                System.out.println("address " + AddressSpace.hex(objectArray.intValue()) + " maps to " + string);
            }
            int n = (Integer)hashtable.get(objectArray);
            Function function = (Function)hashtable2.get(string);
            if (function == null) {
                function = new Function(string, n);
            } else {
                function.addCount(n);
            }
            hashtable2.put(string, function);
        }
        objectArray = (Function[])hashtable2.values().toArray(new Function[0]);
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Function function = (Function)object;
                Function function2 = (Function)object2;
                return function2.entryCount - function.entryCount;
            }
        });
        return objectArray;
    }

    public Function[] traceFunctions() {
        if (this.traceFunctions == null) {
            this.traceFunctions = this.traceFunctions(this.traceTable);
        }
        return this.traceFunctions;
    }

    public boolean isTrace() {
        int n = this.addresses.get(0);
        try {
            int n2 = this.readInt(n);
            if (Dump.debug) {
                System.out.println("asid " + this + ": block1 = " + AddressSpace.hex(n) + ": eyecatcher = " + AddressSpace.hex(n2));
            }
            return n2 == -471612472;
        }
        catch (Exception exception) {
            if (Dump.debug) {
                System.out.println("asid " + this + ": problem reading " + AddressSpace.hex(n) + ": " + exception);
            }
            return false;
        }
    }

    AddressSpace(Dump dump, int n) {
        this.dump = dump;
        this.id = n;
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    public String hexId() {
        return Integer.toHexString(this.id);
    }

    public String toString() {
        return this.hexId();
    }

    public boolean validTCB(int n, boolean bl) {
        try {
            int n2 = this.readInt(n + 256);
            if (n2 == -473710016) {
                return true;
            }
            if (!bl && Dump.debug) {
                System.out.println("bad eyecatcher: " + AddressSpace.hex(n2));
            }
            return false;
        }
        catch (Exception exception) {
            if (!bl && Dump.debug) {
                System.out.println("could not read " + AddressSpace.hex(n + 256));
            }
            return false;
        }
    }

    public int nextTcb(int n) throws Exception {
        return this.readInt(n + 116);
    }

    public int prevTcb(int n) throws Exception {
        return this.readInt(n + 220);
    }

    public int validTCBs() {
        int n = 0;
        int n2 = 0;
        try {
            this.firsttcb = this.readInt(ascbasxb + 4);
        }
        catch (Exception exception) {
            if (Dump.debug) {
                System.out.println("asid " + this.hexId() + ": could not read first tcb at " + AddressSpace.hex(ascbasxb + 4));
            }
            return 0;
        }
        try {
            n2 = this.readInt(ascbasxb + 8);
        }
        catch (Exception exception) {
            if (Dump.debug) {
                System.out.println("asid " + this.hexId() + ": could not read last tcb at " + AddressSpace.hex(ascbasxb + 8));
            }
            return 0;
        }
        if (this.firsttcb == n2) {
            if (Dump.debug) {
                System.out.println("first and last tcb the same! " + AddressSpace.hex(this.firsttcb));
            }
            try {
                this.firsttcb = root.readInt(ascbasxb + 4);
                n2 = root.readInt(ascbasxb + 8);
            }
            catch (Exception exception) {
                if (Dump.debug) {
                    System.out.println("nice try");
                }
                return 0;
            }
            if (this.firsttcb == n2) {
                if (Dump.debug) {
                    System.out.println("first and last tcb STILL the same! " + AddressSpace.hex(this.firsttcb));
                }
                return 0;
            }
        }
        try {
            int n3 = this.firsttcb;
            while (n3 != 0) {
                if (Dump.debug) {
                    System.out.println("asid " + this.hexId() + ": process tcb at " + AddressSpace.hex(n3));
                }
                if (!this.validTCB(n3, false)) {
                    if (Dump.debug) {
                        System.out.println("asid " + this.hexId() + ": invalid tcb at " + AddressSpace.hex(n3));
                    }
                    return 0;
                }
                ++n;
                if (n3 == n2) break;
                n3 = this.nextTcb(n3);
            }
            if (Dump.debug) {
                System.out.println("asid " + this.hexId() + ": processed all tcbs from " + AddressSpace.hex(this.firsttcb) + " to " + AddressSpace.hex(n2));
            }
            return n;
        }
        catch (Exception exception) {
            if (Dump.debug) {
                System.out.println("asid " + this.hexId() + ": error processing a tcb");
            }
            return 0;
        }
    }

    void lastDitch() {
        try {
            int n = this.readInt(ascbasxb + 4);
            int n2 = (n &= 0xFFF00000) + 0x100000;
            Vector vector = new Vector();
            while (n < n2) {
                if (this.validTCB(n, true)) {
                    vector.add(new Tcb(this, n));
                }
                n += 4;
            }
            this.tcbs = (Tcb[])vector.toArray(new Tcb[0]);
        }
        catch (Exception exception) {
            if (Dump.debug) {
                System.out.println("could not recover tcbs");
            }
            this.tcbs = new Tcb[0];
        }
    }

    void addTcb(Tcb tcb) {
        Tcb[] tcbArray = new Tcb[this.tcbs.length + 1];
        System.arraycopy(this.tcbs, 0, tcbArray, 0, this.tcbs.length);
        tcbArray[this.tcbs.length] = tcb;
        this.tcbs = tcbArray;
        if (Dump.debug) {
            System.out.println("added tcb " + tcb + " new size " + this.tcbs.length);
        }
    }

    public Tcb[] tcbs() {
        int n;
        if (this.tcbs != null) {
            return this.tcbs;
        }
        int n2 = this.validTCBs();
        if (n2 != 0) {
            try {
                this.tcbs = new Tcb[n2];
                n = this.firsttcb;
                int n3 = 0;
                while (n3 < n2) {
                    this.tcbs[n3] = new Tcb(this, n);
                    if (Dump.debug) {
                        System.out.println("created tcb " + AddressSpace.hex(n) + " at index " + n3);
                    }
                    n = this.nextTcb(n);
                    ++n3;
                }
            }
            catch (Exception exception) {
                if (Dump.debug) {
                    System.out.println("in asid " + this.hexId() + " problem creating tcbs:");
                    exception.printStackTrace(System.out);
                }
                return null;
            }
        } else {
            if (Dump.debug) {
                System.out.println("in asid " + this.hexId() + " corrupt tcb chain...");
            }
            this.lastDitch();
        }
        if (this.tcbs == null) {
            return null;
        }
        n = 0;
        while (n < this.tcbs.length) {
            int n4;
            Tcb tcb = this.tcbs[n];
            if (!tcb.scannedTid && (n4 = tcb.tid()) != 0) {
                try {
                    int n5 = this.readInt(n4);
                    while (n5 != 0) {
                        Tcb tcb2 = (Tcb)this.tcbMap.get(new Integer(n5));
                        if (tcb2 == null) {
                            tcb2 = new Tcb(this, 0, n5);
                            this.mapTid(n5, tcb2);
                            if (tcb2.isKnownType()) {
                                this.addTcb(tcb2);
                            }
                        } else if (tcb2.scannedTid) break;
                        tcb2.scannedTid = true;
                        n5 = this.readInt(n5);
                    }
                    int n6 = this.readInt(n4 + 4);
                    while (n6 != 0) {
                        Tcb tcb3 = (Tcb)this.tcbMap.get(new Integer(n6));
                        if (tcb3 == null) {
                            tcb3 = new Tcb(this, 0, n6);
                            this.mapTid(n6, tcb3);
                            if (tcb3.isKnownType()) {
                                this.addTcb(tcb3);
                            }
                        } else if (tcb3.scannedTid) break;
                        tcb3.scannedTid = true;
                        n6 = this.readInt(n6 + 4);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
        return this.tcbs;
    }

    public void add(int n, int n2) {
        int n3;
        if ((n & 0xFFF) != 0) {
            System.out.println("Warning: in asid " + this.hexId() + " address " + AddressSpace.hex(n) + " is not page aligned!");
        }
        if (this.pages.get(n3 = n >>> 12)) {
            if (Dump.debug) {
                System.out.println("duplicate address " + AddressSpace.hex(n) + " for asid " + this.hexId());
            }
            return;
        }
        this.pages.set(n3);
        this.addresses.add(n);
        this.blocks.add(n2);
    }

    public void sort() {
        int n;
        int n2;
        this.addresses.sort(this.blocks);
        Vector vector = new Vector();
        int n3 = n2 = this.addresses.get(0);
        boolean bl = false;
        int n4 = 1;
        while (n4 < this.addresses.size()) {
            n = this.addresses.get(n4);
            if (n != n3 + 4096) {
                int n5 = n3 + 4096 - n2;
                MemRange memRange = new MemRange(n2, n5);
                vector.addElement(memRange);
                n2 = n;
                bl = false;
            } else {
                bl = true;
            }
            n3 = n;
            ++n4;
        }
        if (bl) {
            n = n3 + 4096 - n2;
            MemRange memRange = new MemRange(n2, n);
            vector.addElement(memRange);
        }
        this.memRanges = (MemRange[])vector.toArray(new MemRange[0]);
    }

    public final void seek(long l) throws IOException {
        this.currentOffset = (int)l;
    }

    public void search(int n) {
        int n2 = 0;
        while (n2 < this.addresses.size()) {
            int n3 = this.addresses.get(n2);
            int n4 = 0;
            while (n4 < 4096) {
                ++n4;
            }
            ++n2;
        }
    }

    int[] getBlock(int n) throws IOException {
        int[] nArray;
        int n2 = n & 0x7FFFF000;
        if (n2 == this.lastBlockAddress) {
            return this.lastBlock;
        }
        if (this.blockPointers == null || this.blockPointers[n2 >> 12] == null || (nArray = (int[])this.blockPointers[n2 >> 12].get()) == null) {
            int n3 = this.addresses.indexOf(n2);
            if (n3 == -1) {
                throw new IOException("cannot read " + Integer.toHexString(n));
            }
            int n4 = this.blocks.get(n3);
            this.dump.seek(n4);
            nArray = this.dump.readBlock();
            if (this.blockPointers != null) {
                this.blockPointers[n2 >> 12] = new SoftReference(nArray);
            }
            if (this.cacheMisses++ > 10 && this.blockPointers == null) {
                this.blockPointers = new SoftReference[524288];
            }
        }
        this.lastBlock = nArray;
        this.lastBlockAddress = n2;
        return nArray;
    }

    public final int readInt(long l) throws IOException {
        int n = (int)l;
        if (n == 0 || (n & Integer.MIN_VALUE) != 0) {
            throw new IOException("cannot read " + Integer.toHexString(n));
        }
        int[] nArray = this.getBlock(n);
        int n2 = (n & 0xFFF) >> 2;
        int n3 = 0;
        switch (n & 3) {
            case 0: {
                n3 = nArray[n2];
                break;
            }
            case 1: {
                n3 = nArray[n2] << 8 | this.readInt((n & 0xFFFFFFFC) + 4) >>> 24;
                break;
            }
            case 2: {
                n3 = nArray[n2] << 16 | this.readInt((n & 0xFFFFFFFC) + 4) >>> 16;
                break;
            }
            case 3: {
                n3 = nArray[n2] << 24 | this.readInt((n & 0xFFFFFFFC) + 4) >>> 8;
            }
        }
        return n3;
    }

    public final int readInt() throws IOException {
        int n = this.readInt(this.currentOffset);
        this.currentOffset += 4;
        return n;
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.readInt(this.currentOffset) >>> 24;
        ++this.currentOffset;
        return n;
    }

    public final int readUnsignedByte(long l) throws IOException {
        return this.readInt(l) >>> 24;
    }

    public final byte readByte(long l) throws IOException {
        return (byte)this.readUnsignedByte(l);
    }

    public final byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    public int readShort(int n) throws IOException {
        return this.readInt(n) >>> 16;
    }

    public final long readLong(int n) throws IOException {
        long l = this.readInt(n);
        long l2 = this.readInt(n + 4);
        return l << 32 | l2 & 0xFFFFFFFFFFFFFFFFL;
    }

    public String readString(int n) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = this.readUnsignedByte(n++)) != 0) {
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public String readStringObject(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.readInt(n + 8);
        int n3 = this.readInt(n + 12);
        int n4 = this.readInt(n + 16);
        int n5 = 0;
        while (n5 < n4) {
            char c = (char)this.readShort(n2 + 8 + n3 + (n5 << 1));
            if (c != '\n') {
                stringBuffer.append(c);
            }
            ++n5;
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.id);
        objectOutputStream.writeInt(this.jvmRasAddress);
        objectOutputStream.writeObject(this.addresses);
        objectOutputStream.writeObject(this.blocks);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.id = objectInputStream.readInt();
        this.jvmRasAddress = objectInputStream.readInt();
        this.addresses = (IntegerArray)objectInputStream.readObject();
        this.blocks = (IntegerArray)objectInputStream.readObject();
        this.traceTable = new Hashtable();
        this.strings = new IntHashtable();
        this.functionNames = new Hashtable();
        this.traceEntries = new ArrayList();
        this.tcbMap = new HashMap();
        this.lastBlockAddress = -1;
    }

    public int pointerSize() {
        return 4;
    }

    public void setJvmRasAddress(int n) {
        this.jvmRasAddress = n;
    }

    public Enumeration getPages() {
        return new Enumeration(){
            int p;

            public boolean hasMoreElements() {
                return this.p < AddressSpace.this.addresses.size();
            }

            public Object nextElement() {
                return new Page(AddressSpace.this, AddressSpace.this.addresses.get(this.p++));
            }
        };
    }

    public boolean isValidAddress(int n) {
        int n2 = this.addresses.indexOf(n &= 0x7FFFF000);
        return n2 != -1;
    }

    public int getId() {
        return this.id;
    }

    public int ascb() throws IOException {
        return this.readInt(548L);
    }
}

