/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Base;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.HeapMethod;
import com.ibm.jvm.svcdump.Tcb;
import com.ibm.jvm.util.SvcdumpProperties;
import java.util.Hashtable;

public class Dsa
extends Base {
    int address;
    Dsa previous;
    AddressSpace space;
    Tcb tcb;
    int[] registers = new int[16];
    String function;
    String simpleFunction;
    String program;
    String service;
    static int micb = 0;
    boolean foundPrevious;
    int prevCount = -1;
    boolean foundPrevCount;
    boolean is118;
    static int numArgs = SvcdumpProperties.getIntProperty("svcdump.numargs", 4);
    static boolean derefArgs = SvcdumpProperties.getBooleanProperty("svcdump.deref.args", false);
    static String[] knownFunctions = new String[]{"CEEOPEF", "pthread exit forced", "CEEHSGL", "raise a condition", "CEEOSIGG", "deliver signal", "CEEOPCT", "pthread_cond_timedwait", "CEEOPML2", "pthread_mutex_lock", "CEEOPMU2", "pthread_mutex_unlock", "CEEPMDEL", "delete a load module", "CEEVGSTR", "get main storage", "CEEOPGS", "pthread_getspecific", "CEECZLOD", "process level load under CICS", "CEEPVDEL", "delete a module", "CEEVGQP", "get heap pool storage", "CEEOPCS", "pthread_cond_signal", "CEEOPMI", "pthread_mutex_init", "CEEPVLOD", "load module", "CEEVFQP", "free heap pool storage", "CEEVSTLO", "get heap latch", "CEEVCZST", "realloc", "CEEHDSP", "exception dispatcher", "CEEOPMD", "pthread_mutex_destroy", "CEEHHDLR", "register user condition handler", "CEEVGTST", "get heap storage", "CEEVGTSI", "extend stack", "CEEVFSTR", "free main storage", "CEEPTLC", "load dll", "CEEBTERM", "batch termination", "CEEM@MOU", "output MVS message", "CEEV#GTS", "get heap storage", "CEEOGLAT", "get contended latch", "CEEORLAT", "release contended latch", "CEEBBEXT", "bootstrap routine", "CEEOTERM", "posix termination", "CEEZRET", "thread termination", "EDCZMINV", "main invocation event handler", "CEEHSFXS", "stack frame exit schedule", "mmipSelectInvokeJavaMethod", "java", "mmipSelectInvokeSynchronizedJavaMethod", "java", "mmipInvokeJavaMethod", "java", "mmipInvokeSynchronizedJavaMethod", "java"};
    static Hashtable knownFunctionsTable = new Hashtable();

    public int stackPointer() {
        return this.address;
    }

    public String functionName() {
        return this.function();
    }

    Dsa(Tcb tcb, int n) throws Exception {
        this.tcb = tcb;
        this.space = tcb.space;
        this.address = n;
        this.registers[14] = this.space.readInt(n + 12);
        this.registers[15] = this.space.readInt(n + 16);
        int n2 = 0;
        while (n2 < 14) {
            this.registers[n2] = this.space.readInt(n + 20 + n2 * 4);
            ++n2;
        }
    }

    public Dsa previous() {
        if (!this.foundPrevious) {
            this.foundPrevious = true;
            try {
                int n = this.space.readInt(this.address + 4);
                if (n != 0 && n != this.address) {
                    this.previous = new Dsa(this.tcb, n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.previous;
    }

    public int getMdata() {
        return this.registers[4] & Integer.MAX_VALUE;
    }

    public boolean isJitFrame() throws Exception {
        int n = this.space.readInt(this.getMdata());
        return n != 0;
    }

    public boolean isMmiFrame() throws Exception {
        return this.tcb.jvm.isMmiFrame(this);
    }

    public Dsa jitFramePrevious() throws Exception {
        Dsa dsa = this.previous();
        while (this.space.readByte(dsa.address) != 16) {
            dsa = dsa.previous();
        }
        return dsa;
    }

    public int prevJavaFrame() throws Exception {
        return this.space.readInt(this.address + 188);
    }

    public static String function(AddressSpace addressSpace, int n) throws Exception {
        String string;
        block10: {
            int n2;
            string = null;
            int n3 = addressSpace.readInt(n + 4);
            if (n3 == 0xC3C5C5 || n3 == 29607365) {
                n2 = n + addressSpace.readInt(n + 12);
                int n4 = addressSpace.readUnsignedByte(n2);
                if (n3 == 29607365) {
                    n4 <<= 1;
                }
                string = Dsa.readFunctionName(addressSpace, n2, n4);
                break block10;
            }
            if ((n3 & 0xFF0000) == 0xCE0000) {
                n2 = n;
                int n5 = n3 >>> 24;
                string = Dsa.readFunctionName(addressSpace, n2, n5);
                break block10;
            }
            if ((addressSpace.readInt(n) & 0xFFFFF000) == 1206972416) {
                n2 = addressSpace.readUnsignedByte(n + 4);
                byte[] byArray = new byte[n2];
                int n6 = 0;
                while (n6 < n2) {
                    byArray[n6] = (byte)addressSpace.readUnsignedByte(n + 5 + n6);
                    ++n6;
                }
                string = Dump.getEbcdicString(byArray);
                int n7 = 0;
                while (n7 < string.length()) {
                    if (!Character.isLetterOrDigit(string.charAt(n7))) {
                        string = "(unknown)";
                        break block10;
                    }
                    ++n7;
                }
                break block10;
            }
            string = "(unknown)";
        }
        String string2 = (String)knownFunctionsTable.get(string);
        if (string2 != null && !string2.equals("java")) {
            string = string + "    (" + string2 + ")";
        }
        return string;
    }

    public String function() {
        int n;
        int n2;
        if (this.function != null) {
            return this.function;
        }
        this.function = "(unknown)";
        int n3 = this.entryPoint();
        if (n3 == 0) {
            return this.function;
        }
        try {
            this.function = Dsa.function(this.space, n3);
            if (Dump.printArgs) {
                n2 = this.previous().registers[1];
                this.function = this.function + "(";
                n = 0;
                while (n < numArgs) {
                    try {
                        int n4 = this.space.readInt(n2 + (n << 2));
                        this.function = this.function + Dsa.hex(n4);
                        if (derefArgs) {
                            try {
                                n4 = this.space.readInt(n4);
                                this.function = this.function + "(->" + Dsa.hex(n4) + ")";
                            }
                            catch (Exception exception) {
                                this.function = this.function + "(->?)";
                            }
                        }
                    }
                    catch (Exception exception) {
                        this.function = this.function + "?";
                    }
                    this.function = n == numArgs - 1 ? this.function + ") " : this.function + ", ";
                    ++n;
                }
            }
            if (Dump.debug) {
                this.function = this.function + " (ep = " + Dsa.hex(n3) + ")";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.function.equals("clInitClass")) {
            try {
                n2 = this.previous().registers[1];
                n = this.space.readInt(n2 + 4);
                String string = this.tcb.jvm.cbName(n);
                this.function = this.function + " (class = " + string + ")";
            }
            catch (Exception exception) {
                this.function = this.function + " (error reading class: " + exception + ")";
            }
        }
        return this.function;
    }

    public String simpleFunction() {
        if (this.simpleFunction != null) {
            return this.simpleFunction;
        }
        this.simpleFunction = "(unknown)";
        int n = this.entryPoint();
        if (n == 0) {
            return this.simpleFunction;
        }
        try {
            this.simpleFunction = Dsa.function(this.space, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.simpleFunction;
    }

    public String program() {
        if (this.program != null) {
            return this.program;
        }
        this.program = "";
        try {
            int n = this.entryPoint();
            int n2 = this.space.readInt(n + 4);
            if (n2 == 0xC3C5C5 || n2 == 29607365) {
                int n3 = n + this.space.readInt(n + 12);
                if (n2 == 29607365) {
                    int n4 = n + this.space.readInt(n3 + 4);
                    int n5 = this.space.readInt(n4 + 8);
                    if (n5 != 0) {
                        int n6 = n4 + n5;
                        int n7 = this.space.readShort(n6 + 12);
                        if (n7 > 1000) {
                            throw new Exception("bad length: " + n7);
                        }
                        this.program = this.space.getString(n6 + 14, n7);
                    }
                } else {
                    int n8 = this.space.readInt(n3 + 4);
                    int n9 = this.space.readInt(n8 + 8);
                    if (n9 != 0) {
                        int n10 = this.space.readShort(n9 + 12);
                        Base.Assert(n10 < 1000);
                        this.program = this.space.getString(n9 + 14, n10);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.program;
    }

    public String service() {
        if (this.service != null) {
            return this.service;
        }
        try {
            int n = this.entryPoint();
            int n2 = this.space.readInt(n + 4);
            if (n2 == 0xC3C5C5 || n2 == 29607365) {
                int n3 = n + this.space.readInt(n + 12);
                if (n2 == 29607365) {
                    int n4 = n + this.space.readInt(n3 + 4);
                    int n5 = n4 + this.space.readInt(n4 + 12);
                    int n6 = this.space.readShort(n5 + 20);
                    byte[] byArray = new byte[n6];
                    int n7 = 0;
                    while (n7 < n6) {
                        byArray[n7] = (byte)this.space.readUnsignedByte(n5 + 22 + n7);
                        ++n7;
                    }
                    this.service = Dump.getEbcdicString(byArray);
                } else {
                    int n8 = this.space.readInt(n3 + 4);
                    int n9 = this.space.readInt(n8 + 12);
                }
            } else if ((n2 & 0xFF0000) == 0xCE0000) {
                int n10 = n;
                int n11 = this.space.readInt(n10 + 4);
                n = this.space.readInt(n11 + 16);
                this.service = Dsa.function(this.space, n);
            } else {
                this.service = "(unknown)";
            }
        }
        catch (Exception exception) {
            this.service = "(unknown)";
        }
        return this.service;
    }

    public static Dsa findTop(Tcb tcb, int n) throws Exception {
        int n2 = n;
        try {
            int n3;
            while (tcb.space.readInt((n3 = tcb.space.readInt(n2 + 76)) + 4) == n2) {
                n2 = n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Dsa(tcb, n2);
    }

    public static Dsa findStack(Tcb tcb, int n) {
        Dsa dsa = null;
        int n2 = n;
        while (n2 > n - 4096) {
            try {
                int n3 = tcb.space.readInt(n2 + 76);
                if (tcb.space.readInt(n3 + 4) == n2) {
                    Dsa dsa2 = Dsa.findTop(tcb, n2);
                    if (dsa == null || dsa.prevCount() < dsa2.prevCount()) {
                        dsa = dsa2;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n2 -= 4;
        }
        return dsa;
    }

    public int prevCount() {
        if (Dump.debug) {
            System.out.println("prevCount begin");
        }
        if (!this.foundPrevCount) {
            this.foundPrevCount = true;
            Dsa dsa = this;
            while (dsa != null) {
                ++this.prevCount;
                if (this.prevCount > 1000) {
                    if (Dump.debug) {
                        System.out.println("bad prevCount, probably loop");
                    }
                    this.prevCount = -1;
                    break;
                }
                dsa = dsa.previous();
            }
        }
        if (Dump.debug) {
            System.out.println("prevCount end");
        }
        return this.prevCount;
    }

    boolean badName(String string) {
        if (string.equals(".")) {
            return true;
        }
        int n = 0;
        while (n < string.length()) {
            if (Character.isIdentifierIgnorable(string.charAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String method() {
        this.function();
        String string = "";
        try {
            if (this.function.startsWith("mmipInvoke") || this.function.startsWith("mmisInvoke") || this.function.startsWith("mmipSelectInvoke")) {
                string = this.cbName(false) + "." + this.mbName(false);
            } else if (this.function.equals("EXECJAVA") && this.badName(string = this.cbName(false) + "." + this.mbName(false)) && this.badName(string = this.cbName(true) + "." + this.mbName(true))) {
                string = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String readFunctionName(AddressSpace addressSpace, int n, int n2) throws Exception {
        int n3 = addressSpace.readShort(n + n2);
        if (n3 > 500) {
            throw new Exception("Impossibly long name: " + n3);
        }
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            byArray[n4] = (byte)addressSpace.readUnsignedByte(n + n2 + 2 + n4);
            ++n4;
        }
        return Dump.getEbcdicString(byArray);
    }

    HeapMethod mb() {
        try {
            int n = this.space.readInt(this.address + 172);
            if (n == 0) {
                return null;
            }
            Base.Assert(n == this.previous().registers[6]);
            try {
                return new HeapMethod(this.tcb.jvm, n);
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("bad read " + exception);
        }
    }

    int last_pc() {
        try {
            return this.space.readInt(this.address + 192);
        }
        catch (Exception exception) {
            throw new Error("bad read " + exception);
        }
    }

    String mbName(boolean bl) {
        String string = "";
        try {
            int n;
            int n2;
            int n3 = 0;
            if (bl) {
                n2 = this.previous().registers[1];
                int n4 = this.space.readInt(n2);
                n = this.space.readInt(n4 + 8);
                int n5 = this.space.readInt(n + 0);
                n3 = this.space.readInt(n5 + 4);
            } else {
                n3 = this.previous().registers[6];
            }
            n2 = this.space.readInt(n3 + 8);
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = this.space.readUnsignedByte(n2++)) != 0) {
                stringBuffer.append((char)n);
            }
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    String cbName(boolean bl) {
        String string = "";
        try {
            int n;
            int n2 = 0;
            if (bl) {
                n = this.previous().registers[1];
                int n3 = this.space.readInt(n);
                int n4 = this.space.readInt(n3 + 8);
                int n5 = this.space.readInt(n4 + 0);
                n2 = this.space.readInt(n5 + 4);
            } else {
                n2 = this.previous().registers[6];
            }
            n = this.space.readInt(n2);
            string = this.tcb.jvm.cbName(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public int entryPoint() {
        if (this.previous() == null) {
            return 0;
        }
        if (this.previous().address == this.tcb.failingDsa()) {
            try {
                int n = this.space.readInt(this.previous().address + 76);
                int n2 = this.space.readInt(n + 16);
                return n2 & Integer.MAX_VALUE;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.previous().registers[15] & Integer.MAX_VALUE;
    }

    public int address() {
        return this.address;
    }

    public int returnAddress() {
        return this.registers[14] & Integer.MAX_VALUE;
    }

    public int offset() {
        int n;
        if (this.address == this.tcb.failingDsa() && (n = this.tcb.failingPsw()) != 0) {
            return n - this.entryPoint();
        }
        return this.returnAddress() - this.entryPoint() - 2;
    }

    public int reg(int n) {
        return this.registers[n];
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    static {
        int n = 0;
        while (n < knownFunctions.length) {
            knownFunctionsTable.put(knownFunctions[n], knownFunctions[n + 1]);
            n += 2;
        }
    }
}

